/***************************************************************************
                          svgexplugin.cpp  -  description
                             -------------------
    begin                : Sun Aug 3 08:00:00 CEST 2002
    copyright            : (C) 2002 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "svgexplugin.h"
#include "svgexplugin.moc"
#include "config.h"
#include "customfdialog.h"
#include <qfile.h>
#include <qtextstream.h>
extern void Level2Layer(ScribusDoc *doc, struct Layer *ll, int Level);

QString Name()
{
  return QObject::tr("Save Page as SVG...");
}

int Type()
{
	return 3;
}

void Run(QWidget *d, ScribusApp *plug)
{
	if (plug->HaveDoc)
		{
		QString fileName = plug->CFileDialog(QObject::tr("Save as"), QObject::tr("SVG-Images (*.svg);; All Files (*)"),"", false, false);
		if (!fileName.isEmpty())
			{
  		QFile f(fileName);
  		if (f.exists())
  			{
  			int exit=QMessageBox::warning(d, QObject::tr("Warning"),
  																		QObject::tr("Do you really want to overwrite the File:\n%1 ?").arg(fileName),
                                			QObject::tr("Yes"),
                                			QObject::tr("No"),
                                			0, 0, 1);
  			if (exit != 0)
  				return;
  			}
  		SVGExPlug *dia = new SVGExPlug(d, plug, fileName);
  		delete dia;
			}
		else
			return;
  	}
}

SVGExPlug::SVGExPlug( QWidget* parent, ScribusApp *plug, QString fName )
{
	QString tmp, trans, fill, stroke, strokeW, strokeLC, strokeLJ, strokeDA;
	uint d;
	struct Pti *hl;
	int Lnr = 0;
	struct Layer ll;
	ll.Drucken = false;
	ll.LNr = 0;
	QDomDocument docu("svgdoc");
	QString vo = "<?xml version=\"1.0\" standalone=\"yes\"?>\n";
	QString st = "<svg></svg>";
	docu.setContent(st);
	QDomElement elem = docu.documentElement();
	elem.setAttribute("width", plug->doc->PageB);
	elem.setAttribute("height", plug->doc->PageH);
	Page *Seite;
	PageItem *Item;
	Seite = plug->doc->ActPage;
	QDomElement ob, gr, tp, tp2;
	QDomText tp1;
	for (uint la = 0; la < plug->doc->Layers.count(); la++)
		{
		Level2Layer(plug->doc, &ll, Lnr);
		if (ll.Drucken)
			{
			for(uint j = 0; j < Seite->Items.count();j++)
				{
				Item = Seite->Items.at(j);
				if (Item->LayerNr != ll.LNr)
					continue;
				if (Item->Pcolor != "None")
					fill = "fill:"+SetFarbe(Item->Pcolor, Item->Shade, plug)+";";
				else
					fill = "fill:none;";
				if (Item->Pcolor2 != "None")
					stroke = "stroke:"+SetFarbe(Item->Pcolor2, Item->Shade2, plug)+";";
				else
					stroke = "stroke:none;";
				trans = "translate("+FToStr(Item->Xpos)+" "+FToStr(Item->Ypos)+")";
				if (Item->Rot != 0)
					trans += " rotate("+FToStr(Item->Rot)+")";
				strokeW = "stroke-width:"+FToStr(Item->Pwidth)+";";
				strokeLC = "stroke-linecap:";
				switch (Item->PLineEnd)
					{
					case Qt::FlatCap:
						strokeLC += "butt;";
						break;
					case Qt::SquareCap:
						strokeLC += "square;";
						break;
					case Qt::RoundCap:
						strokeLC += "round;";
						break;
					default:
						strokeLC += "butt;";
						break;
					}
				strokeLJ = "stroke-linejoin:";
				switch (Item->PLineJoin)
					{
					case Qt::MiterJoin:
						strokeLJ += "miter;";
						break;
					case Qt::BevelJoin:
						strokeLJ += "bevel;";
						break;
					case Qt::RoundJoin:
						strokeLJ += "round;";
						break;
					default:
						strokeLJ += "miter;";
						break;
					}
				strokeDA = "stroke-dasharray:";
				QString Dt = FToStr(QMAX(Item->Pwidth, 1));
				QString Da = FToStr(QMAX(3*Item->Pwidth, 1));
				switch (Item->PLineArt)
					{
					case Qt::SolidLine:
						strokeDA += "none;";
						break;
					case Qt::DashLine:
						strokeDA += Da+","+Dt+";";
						break;
					case Qt::DotLine:
						strokeDA += Dt+";";
						break;
					case Qt::DashDotLine:
						strokeDA += Da+","+Dt+","+Dt+","+Dt+";";
						break;
					case Qt::DashDotDotLine:
						strokeDA += Da+","+Dt+","+Dt+","+Dt+","+Dt+","+Dt+";";
						break;
					default:
						strokeDA += "none;";
						break;
					}
				gr = docu.createElement("g");
				gr.setAttribute("transform", trans);
				if (Item->PType != 4)
					{
					if ((Item->PType == 5) || (Item->PType == 7) || (Item->PType == 8))
						gr.setAttribute("style", "fill:none; "+stroke+" "+strokeW+" "+strokeLC+" "+strokeLJ+" "+strokeDA);
					else
						gr.setAttribute("style", fill+" "+stroke+" "+strokeW+" "+strokeLC+" "+strokeLJ+" "+strokeDA);
					}
				switch (Item->PType)
					{
					case 1:
					case 3:
					case 6:
						ob = docu.createElement("path");
						ob.setAttribute("d", SetClipPath(Item)+"Z");
						break;
					case 2:
						break;
					case 7:
						ob = docu.createElement("path");
						ob.setAttribute("d", SetClipPath(Item));
						break;
					case 4:
						if (Item->Pcolor != "None")
							{
							ob = docu.createElement("path");
							ob.setAttribute("d", SetClipPath(Item)+"Z");
							ob.setAttribute("style", fill);
							gr.appendChild(ob);
							}
						ob = docu.createElement("text");
						for (d = 0; d < Item->MaxChars; d++)
							{
							hl = Item->Ptext.at(d);
							if ((hl->ch == QChar(13)) || (hl->ch == QChar(10)))
								continue;
							if (hl->yp == 0)
								break;
							tp = docu.createElement("tspan");
							tp.setAttribute("x", hl->xp);
							tp.setAttribute("y", hl->yp);
							SetTextProps(&tp, hl, plug);
							tp1 = docu.createTextNode(hl->ch);
							tp.appendChild(tp1);
							ob.appendChild(tp);
							}
						break;
					case 5:
						ob = docu.createElement("path");
						ob.setAttribute("d", "M 0 0 L "+FToStr(Item->Width)+" 0");
						break;
					case 8:
						if (Item->PoShow)
							{
							ob = docu.createElement("path");
							ob.setAttribute("d", SetClipPath(Item));
							gr.appendChild(ob);
							}
						ob = docu.createElement("text");
						for (d = 0; d < Item->MaxChars; d++)
							{
							hl = Item->Ptext.at(d);
							if ((hl->ch == QChar(13)) || (hl->ch == QChar(10)))
								continue;
							tp = docu.createElement("tspan");
							tp.setAttribute("x", hl->PtransX);
							tp.setAttribute("y", hl->PtransY);
							tp.setAttribute("rotate", hl->PRot);
							tp2 = docu.createElement("tspan");
							tp2.setAttribute("dx", hl->xp);
							tp2.setAttribute("dy", hl->yp);
							SetTextProps(&tp2, hl, plug);
							tp1 = docu.createTextNode(hl->ch);
							tp2.appendChild(tp1);
							tp.appendChild(tp2);
							ob.appendChild(tp);
							}
						break;
					}
				gr.appendChild(ob);
				elem.appendChild(gr);
				}
			}
		Lnr++;
		}
	QFile f(fName);
	if(!f.open(IO_WriteOnly))
		return;
	QTextStream s(&f);
	s.setEncoding( QTextStream::UnicodeUTF8 );
	s<<vo;
	s<<docu.toString();
	f.close();
}

QString SVGExPlug::SetClipPath(PageItem *ite)
{
	QString tmp = "";
	if (ite->PoLine.size() > 3)
		{
		FPoint np = ite->PoLine.point(0);
		tmp += "M"+FToStr(np.x())+" "+FToStr(np.y())+" ";
		for (uint poi=0; poi<ite->PoLine.size()-3; poi += 4)
			{
			np = ite->PoLine.point(poi+1);
			tmp += "C"+IToStr(np.x())+" "+IToStr(np.y())+" ";
			np = ite->PoLine.point(poi+3);
			tmp += IToStr(np.x())+" "+IToStr(np.y())+" ";
			np = ite->PoLine.point(poi+2);
			tmp += IToStr(np.x())+" "+IToStr(np.y())+" ";
			}
		}
	return tmp;
}       

QString SVGExPlug::FToStr(float c)
{
	QString cc;
	return cc.setNum(c);
}

QString SVGExPlug::IToStr(int c)
{
	QString cc;
	return cc.setNum(c);
}

void SVGExPlug::SetTextProps(QDomElement *tp, struct Pti *hl, ScribusApp *plug)
{
	int chst;
	if (hl->ccolor != "None")
		tp->setAttribute("fill", SetFarbe(hl->ccolor, hl->cshade, plug));
	else
		tp->setAttribute("fill", "none");
	tp->setAttribute("font-size", hl->csize);
	tp->setAttribute("font-family", plug->doc->UsedFonts[hl->cfont].family());
	chst = hl->cstyle & 127;
	if (chst != 0)
		{
		if (chst & 64)
			tp->setAttribute("font-variant", "small-caps");
		if (chst & 32)
			tp->setAttribute("font-weight", "bold");
		if (chst & 16)
			tp->setAttribute("text-decoration", "line-through");
		if (chst & 8)
			tp->setAttribute("text-decoration", "underline");
		if (chst & 4)
			tp->setAttribute("font-style", "italic");
		}
}

QString SVGExPlug::SetFarbe(QString farbe, int shad, ScribusApp *plug)
{
	int h, s, v, sneu;
	QColor tmp;
	plug->doc->PageColors[farbe].getRGBColor().rgb(&h, &s, &v);
	if ((h == s) && (s == v))
		{
		plug->doc->PageColors[farbe].getRGBColor().hsv(&h, &s, &v);
		sneu = 255 - ((255 - v) * shad / 100);
		tmp.setHsv(h, s, sneu);
		}
	else
		{
		plug->doc->PageColors[farbe].getRGBColor().hsv(&h, &s, &v);
		sneu = s * shad / 100;
		tmp.setHsv(h, sneu, v);
		}
	return tmp.name();
}

SVGExPlug::~SVGExPlug()
{
}

