#ifndef SVGPLUG_H
#define SVGPLUG_H

#include "Python.h"
#include "scribus.h"
#include "pconsole.h"


/** Calls the Plugin with the main Application window as parent
  * and the main Application Class as parameter */
extern "C" void Run(QWidget *d, ScribusApp *plug);

/** Returns the Name of the Plugin.
  * This name appears in the relevant Menue-Entrys */
extern "C" QString Name();

/** Returns the Type of the Plugin.
  * 1 = the Plugin is a normal Plugin, which appears in the Extras Menue
  * 2 = the Plugin is a Import Plugin, which appears in the Import Menue
  * 3 = the Plugin is a Export Plugin, which appears in the Export Menue
  * 4 = the Plugin is a resident Plugin   */
extern "C" int Type();

/** Initializes the Plugin if it's a Plugin of Type 4 */
extern "C" void InitPlug(QWidget *d, ScribusApp *plug);

/** Possible CleanUpOperations when closing the Plugin */
extern "C" void CleanUpPlug();

extern "C" void initscribus(ScribusApp *pl);

/** Some useful Subroutines */
static PyObject *scribus_retval(PyObject *self, PyObject* args);
static PyObject *scribus_getval(PyObject *self, PyObject* args);
QString RetString;
QString InValue;
int RetVal;

static QPopupMenu* men;

class MenuTest : public QObject
{
    Q_OBJECT

public:
    MenuTest(QWidget* parent);
    ~MenuTest();
		void ReadPlugPrefs();
		void SavePlugPrefs();
		PConsole *pcon;
		QPopupMenu* rmen;
		int rmenid;
		int cons;
		QStringList SavedRecentScripts;
    QStringList RecentScripts;

public slots:
		void slotHelp();
		void slotTest();
		void RecentScript(int id);
		void slotRunScriptFile(QString fileName);
		QString slotRunScript(QString Script);
		void slotInteractiveScript();
		void slotExecute();
};

static MenuTest* Tes;
#endif // CMSPLUG_H
