#ifndef SVGPLUG_H
#define SVGPLUG_H

#include "Python.h"
#include "scribus.h"
#include "pconsole.h"


/** Calls the Plugin with the main Application window as parent
  * and the main Application Class as parameter */
extern "C" void Run(QWidget *d, ScribusApp *plug);

/** Returns the Name of the Plugin.
  * This name appears in the relevant Menue-Entrys */
extern "C" QString Name();

/** Returns the Type of the Plugin.
  * 1 = the Plugin is a normal Plugin, which appears in the Extras Menue
  * 2 = the Plugin is a Import Plugin, which appears in the Import Menue
  * 3 = the Plugin is a Export Plugin, which appears in the Export Menue
  * 4 = the Plugin is a resident Plugin   */
extern "C" int Type();

/** Initializes the Plugin if it's a Plugin of Type 4 */
extern "C" void InitPlug(QWidget *d, ScribusApp *plug);

/** Possible CleanUpOperations when closing the Plugin */
extern "C" void CleanUpPlug();

extern "C" void initscribus(ScribusApp *pl);

/** Some useful Subroutines */
float PointToValue(float Val);
float ValToPts(float Val, int ein);
float ValueToPoint(float Val);
int GetItem(QString Name);
void ReplaceColor(QString col, QString rep);

/** Calling Dialogs from Scribus */
static PyObject *scribus_newdocdia(PyObject *self, PyObject* args);

/**	Document related Commands */
static PyObject *scribus_newdoc(PyObject *self, PyObject* args);
static PyObject *scribus_closedoc(PyObject *self, PyObject* args);
static PyObject *scribus_havedoc(PyObject *self, PyObject* args);
static PyObject *scribus_opendoc(PyObject *self, PyObject* args);
static PyObject *scribus_savedoc(PyObject *self, PyObject* args);
static PyObject *scribus_savedocas(PyObject *self, PyObject* args);
static PyObject *scribus_setinfo(PyObject *self, PyObject* args);
static PyObject *scribus_setmargins(PyObject *self, PyObject* args);
static PyObject *scribus_setunit(PyObject *self, PyObject* args);
static PyObject *scribus_getunit(PyObject *self, PyObject* args);

/** Page related Commands */
static PyObject *scribus_newpage(PyObject *self, PyObject* args);
static PyObject *scribus_actualpage(PyObject *self, PyObject* args);
static PyObject *scribus_redraw(PyObject *self, PyObject* args);
static PyObject *scribus_savepageeps(PyObject *self, PyObject* args);
static PyObject *scribus_deletepage(PyObject *self, PyObject* args);
static PyObject *scribus_gotopage(PyObject *self, PyObject* args);
static PyObject *scribus_pagecount(PyObject *self, PyObject* args);

/** Object related Commands */
static PyObject *scribus_newrect(PyObject *self, PyObject* args);
static PyObject *scribus_newellipse(PyObject *self, PyObject* args);
static PyObject *scribus_newimage(PyObject *self, PyObject* args);
static PyObject *scribus_newtext(PyObject *self, PyObject* args);
static PyObject *scribus_newline(PyObject *self, PyObject* args);
static PyObject *scribus_polyline(PyObject *self, PyObject* args);
static PyObject *scribus_polygon(PyObject *self, PyObject* args);
static PyObject *scribus_bezierline(PyObject *self, PyObject* args);
static PyObject *scribus_pathtext(PyObject *self, PyObject* args);
static PyObject *scribus_deleteobj(PyObject *self, PyObject* args);

/** Query-Functions */
static PyObject *scribus_getfillcolor(PyObject *self, PyObject* args);
static PyObject *scribus_getlinecolor(PyObject *self, PyObject* args);
static PyObject *scribus_getlinewidth(PyObject *self, PyObject* args);
static PyObject *scribus_getlineshade(PyObject *self, PyObject* args);
static PyObject *scribus_getlinejoin(PyObject *self, PyObject* args);
static PyObject *scribus_getlineend(PyObject *self, PyObject* args);
static PyObject *scribus_getlinestyle(PyObject *self, PyObject* args);
static PyObject *scribus_getfillshade(PyObject *self, PyObject* args);
static PyObject *scribus_getcornerrad(PyObject *self, PyObject* args);
static PyObject *scribus_getimgscale(PyObject *self, PyObject* args);
static PyObject *scribus_getimgname(PyObject *self, PyObject* args);
static PyObject *scribus_getposi(PyObject *self, PyObject* args);
static PyObject *scribus_getsize(PyObject *self, PyObject* args);
static PyObject *scribus_getrotation(PyObject *self, PyObject* args);
static PyObject *scribus_getfontsize(PyObject *self, PyObject* args);
static PyObject *scribus_getfont(PyObject *self, PyObject* args);
static PyObject *scribus_gettextsize(PyObject *self, PyObject* args);
static PyObject *scribus_gettext(PyObject *self, PyObject* args);
static PyObject *scribus_getlinespace(PyObject *self, PyObject* args);
static PyObject *scribus_getallobj(PyObject *self, PyObject* args);

/** Setting Object Properties */
static PyObject *scribus_setfillcolor(PyObject *self, PyObject* args);
static PyObject *scribus_setlinecolor(PyObject *self, PyObject* args);
static PyObject *scribus_setlinewidth(PyObject *self, PyObject* args);
static PyObject *scribus_setlineshade(PyObject *self, PyObject* args);
static PyObject *scribus_setlinejoin(PyObject *self, PyObject* args);
static PyObject *scribus_setlineend(PyObject *self, PyObject* args);
static PyObject *scribus_setlinestyle(PyObject *self, PyObject* args);
static PyObject *scribus_setfillshade(PyObject *self, PyObject* args);
static PyObject *scribus_setcornerrad(PyObject *self, PyObject* args);
static PyObject *scribus_loadimage(PyObject *self, PyObject* args);
static PyObject *scribus_scaleimage(PyObject *self, PyObject* args);
static PyObject *scribus_setboxtext(PyObject *self, PyObject* args);
static PyObject *scribus_inserttext(PyObject *self, PyObject* args);
static PyObject *scribus_setfont(PyObject *self, PyObject* args);
static PyObject *scribus_setfontsize(PyObject *self, PyObject* args);
static PyObject *scribus_setlinespace(PyObject *self, PyObject* args);
static PyObject *scribus_setalign(PyObject *self, PyObject* args);

/** Manipulating Objects */
static PyObject *scribus_moveobjrel(PyObject *self, PyObject* args);
static PyObject *scribus_moveobjabs(PyObject *self, PyObject* args);
static PyObject *scribus_rotobjrel(PyObject *self, PyObject* args);
static PyObject *scribus_rotobjabs(PyObject *self, PyObject* args);
static PyObject *scribus_sizeobjabs(PyObject *self, PyObject* args);
static PyObject *scribus_getselobjnam(PyObject *self, PyObject* args);
static PyObject *scribus_selcount(PyObject *self, PyObject* args);
static PyObject *scribus_selectobj(PyObject *self, PyObject* args);
static PyObject *scribus_deselect(PyObject *self, PyObject* args);
static PyObject *scribus_selecttext(PyObject *self, PyObject* args);
static PyObject *scribus_deletetext(PyObject *self, PyObject* args);
static PyObject *scribus_groupobj(PyObject *self, PyObject* args);
static PyObject *scribus_ungroupobj(PyObject *self, PyObject* args);
static PyObject *scribus_scalegroup(PyObject *self, PyObject* args);

/** Managing Colors */
static PyObject *scribus_colornames(PyObject *self, PyObject* args);
static PyObject *scribus_getcolor(PyObject *self, PyObject* args);
static PyObject *scribus_setcolor(PyObject *self, PyObject* args);
static PyObject *scribus_newcolor(PyObject *self, PyObject* args);
static PyObject *scribus_delcolor(PyObject *self, PyObject* args);
static PyObject *scribus_replcolor(PyObject *self, PyObject* args);

/** Other Commands */
static PyObject *scribus_fontnames(PyObject *self, PyObject* args);
static PyObject *scribus_getlayers(PyObject *self, PyObject* args);
static PyObject *scribus_setactlayer(PyObject *self, PyObject* args);
static PyObject *scribus_getactlayer(PyObject *self, PyObject* args);
static PyObject *scribus_senttolayer(PyObject *self, PyObject* args);
static PyObject *scribus_layervisible(PyObject *self, PyObject* args);
static PyObject *scribus_layerprint(PyObject *self, PyObject* args);
static PyObject *scribus_glayervisib(PyObject *self, PyObject* args);
static PyObject *scribus_glayerprint(PyObject *self, PyObject* args);
static PyObject *scribus_removelayer(PyObject *self, PyObject* args);
static PyObject *scribus_createlayer(PyObject *self, PyObject* args);


static PyObject *scribus_retval(PyObject *self, PyObject* args);
static PyObject *scribus_getval(PyObject *self, PyObject* args);
QString RetString;
QString InValue;
int RetVal;

/** Global Pointer to the Scribus Application */
static ScribusApp* Carrier;
static ScribusDoc* doc;
static QPopupMenu* men;

class MenuTest : public QObject
{
    Q_OBJECT

public:
    MenuTest(QWidget* parent);
    ~MenuTest();
		void ReadPlugPrefs();
		void SavePlugPrefs();
		PConsole *pcon;
		QPopupMenu* rmen;
		int rmenid;
		int cons;
		QStringList SavedRecentScripts;
    QStringList RecentScripts;

public slots:
		void slotHelp();
		void slotTest();
		void RecentScript(int id);
		void slotRunScriptFile(QString fileName);
		QString slotRunScript(QString Script);
		void slotInteractiveScript();
		void slotExecute();
};

static MenuTest* Tes;
#endif // CMSPLUG_H
