/***************************************************************************
                          scriptplugin.cpp  -  description
                             -------------------
    begin                : Thu Oct 3 08:00:00 CEST 2002
    copyright            : (C) 2002 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "scriptplugin.h"
#include "scriptplugin.moc"
#include "customfdialog.h"
#include "helpbrowser.h"
#include "config.h"
#include <qmessagebox.h>
#include <qtextcodec.h>
#include <qdom.h>
#include <qtextstream.h>
#include <cstdlib>

QString Name()
{
  return QObject::tr("About Scripter...");
}

int Type()
{
	return 4;
}

void InitPlug(QWidget *d, ScribusApp *plug)
{
	QString cm;
	Py_Initialize();
	Carrier = plug;
	RetVal = 0;
	initscribus(Carrier);
	Tes = new MenuTest(d);
	men = new QPopupMenu();
	Tes->rmen = new QPopupMenu();
	Tes->SavedRecentScripts.clear();
	Tes->ReadPlugPrefs();
	Tes->RecentScripts.clear();
	if (Tes->SavedRecentScripts.count() != 0)
		{
		uint max = QMIN(Carrier->Prefs.RecentDCount, Tes->SavedRecentScripts.count());
		for (uint m = 0; m < max; m++)
			{
			QFileInfo fd(Tes->SavedRecentScripts[m]);
			if (fd.exists())
				{
				Tes->RecentScripts.append(Tes->SavedRecentScripts[m]);
				Tes->rmen->insertItem(Tes->SavedRecentScripts[m]);
				}
			}
		}
	Tes->pcon = new PConsole(d);
	men->insertItem(QObject::tr("Execute Script..."), Tes, SLOT(slotTest()));
	Tes->rmenid = men->insertItem(QObject::tr("Recent Scripts"), Tes->rmen);
	Tes->cons = men->insertItem(QObject::tr("Show Console"), Tes, SLOT(slotInteractiveScript()));
	men->insertSeparator();
	men->insertItem(QObject::tr("Online-Help"), Tes, SLOT(slotHelp()));
	plug->menuBar()->insertItem(QObject::tr("Script"), men, -1, plug->menuBar()->count() - 2);
	QObject::connect(Tes->pcon->OutWin, SIGNAL(returnPressed()), Tes, SLOT(slotExecute()));
	QObject::connect(Tes->pcon, SIGNAL(Schliessen()), Tes, SLOT(slotInteractiveScript()));
	QObject::connect(Tes->rmen, SIGNAL(activated(int)), Tes, SLOT(RecentScript(int)));
}

void CleanUpPlug()
{
	Py_Finalize();
	Tes->SavePlugPrefs();
}

void Run(QWidget *d, ScribusApp *plug)
{
	QString mess = QObject::tr("Scripter");
	mess += "\n\n" + QObject::tr("This Plugin allows you to use Python as a");
	mess += "\n" + QObject::tr("scripting Language for Scribus.");
	mess += "\n\n" + QObject::tr("Programming:");
	mess += "\n\t" + QObject::tr("Franz Schmid <Franz.Schmid@altmuehlnet.de>");
	mess += "\n\n" + QObject::tr("Documentation:");
	mess += "\n\t" + QObject::tr("Peter Linnell <netscribe@attbi.com>");
	mess += "\n\t" + QObject::tr("Franz Schmid <Franz.Schmid@altmuehlnet.de>");
	QMessageBox::about(d, QObject::tr("About Scripter"), mess);
}

MenuTest::MenuTest(QWidget* parent) : QObject( parent, "bu")
{
}

MenuTest::~MenuTest()
{
}

void MenuTest::slotHelp()
{
 	QString pfad = PREL;
 	QString pfad2;
//  pfad2 = pfad + "/share/scribus/doc/"+QString(QTextCodec::locale()).left(2)+"/Scripter/index.html";
  pfad2 = pfad + "/lib/scribus/doc/en/Scripter/index.html";
	HelpBrowser *dia = new HelpBrowser(0, QObject::tr("Online Reference"), pfad2);
	dia->show();
}

void MenuTest::slotTest()
{
	QString fileName;
	CustomFDialog diaf((QWidget*)parent(), QObject::tr("Open"), QObject::tr("Python Scripts (*.py);; All Files (*)"));
	if (diaf.exec())
		{
		fileName = diaf.selectedFiles()[0];
		slotRunScriptFile(fileName);
		rmen->clear();
		if (RecentScripts.findIndex(fileName) == -1)
			RecentScripts.prepend(fileName);
		else
			{
			RecentScripts.remove(fileName);
			RecentScripts.prepend(fileName);
			}
		uint max = QMIN(Carrier->Prefs.RecentDCount, RecentScripts.count());
		for (uint m = 0; m < max; m++)
			{
			rmen->insertItem(RecentScripts[m]);
			}
		}
}

void MenuTest::RecentScript(int id)
{
	QString fn = rmen->text(id);
	QFileInfo fd(fn);
	if (!fd.exists())
		{
		RecentScripts.remove(fn);
		rmen->clear();
		uint max = QMIN(Carrier->Prefs.RecentDCount, RecentScripts.count());
		for (uint m = 0; m < max; m++)
			{
			rmen->insertItem(RecentScripts[m]);
			}
		return;
		}
	slotRunScriptFile(fn);
}

void MenuTest::slotRunScriptFile(QString fileName)
{
	char* comm[1];
	QFileInfo fi(fileName);
	QCString na = fi.fileName().latin1();
	QDir::setCurrent(fi.dirPath(true));
//	PyThreadState *stateo = PyThreadState_Get();
	PyThreadState *stateo = PyEval_SaveThread();
	PyThreadState *state = Py_NewInterpreter();
	initscribus(Carrier);
	QString cm = "import sys\nsys.path[0] = \""+fi.dirPath(true)+"\"\n";
	cm += "try:\n\texecfile(\""+fileName+"\")\nexcept SystemExit:\n\tpass\n";
	QCString cmd = cm.latin1();
	comm[0] = na.data();
	PySys_SetArgv(1, comm);
	PyRun_SimpleString(cmd.data());
	Py_EndInterpreter(state);
	PyEval_RestoreThread(stateo);
}

QString MenuTest::slotRunScript(QString Script)
{
	char* comm[1];
	QString cm;
	InValue = Script;
	QString CurDir = QDir::currentDirPath();
	if(PyThreadState_Get() != NULL)
		{
		initscribus(Carrier);
		if (RetVal == 0)
			{
			cm = "import sys\nsys.path[0] = \""+CurDir+"\"\n";
			cm += "import cStringIO\n";
			cm += "from scribus import *\n";
			cm += "bu = cStringIO.StringIO()\n";
			cm += "sys.stdout = bu\n";
			cm += "sys.stderr = bu\n";
			cm += "import code\n";
			cm += "ia = code.InteractiveConsole(globals())\n";
			}
		cm += "sc = getval()\n";
		cm += "rv = ia.push(sc)\n";
		cm += "if rv == 1:\n";
		cm += "\tre = \"...\"\n";
		cm += "else:\n";
		cm += "\tre = bu.getvalue()\n";
		cm += "retval(re, rv)\n";
		}
	QCString cmd = cm.latin1();
	comm[0] = "scribus";
	PySys_SetArgv(1, comm);
	PyRun_SimpleString(cmd.data());
	if (RetVal == 0)
		{
		RetString += ">>>";
		pcon->OutWin->Prompt = ">>>";
		}
	else
		pcon->OutWin->Prompt = "...";
	return RetString;
}

void MenuTest::slotInteractiveScript()
{
	if (pcon->isVisible())
		{
		men->changeItem(cons, tr("Show Console"));
		pcon->hide();
		}
	else
		{
		men->changeItem(cons, tr("Hide Console"));
		pcon->show();
		}
}

void MenuTest::slotExecute()
{
	pcon->OutWin->append(slotRunScript(pcon->OutWin->LastComm));
	pcon->OutWin->moveCursor(QTextEdit::MoveEnd, false);
	pcon->OutWin->scrollToBottom();
	pcon->OutWin->ensureCursorVisible();
	if (Carrier->HaveDoc)
		Carrier->doc->ActPage->repaint();
}

void MenuTest::ReadPlugPrefs()
{
	QDomDocument docu("scriptrc");
	QString ho = getenv("HOME");
	QFile f(ho+"/.scribus/scripter.rc");
	if(!f.open(IO_ReadOnly))
		return;
	if(!docu.setContent(&f))
		{
		f.close();
		return;
		}
	f.close();
	QDomElement elem=docu.documentElement();
	if (elem.tagName() != "SCRIPTRC")
		return;
	QDomNode DOC=elem.firstChild();
	while(!DOC.isNull())
		{
		QDomElement dc=DOC.toElement();
		if (dc.tagName()=="RECENT")
			SavedRecentScripts.append(dc.attribute("NAME"));
		DOC=DOC.nextSibling();
		}
}

void MenuTest::SavePlugPrefs()
{
	QDomDocument docu("scriptrc");
	QString st="<SCRIPTRC></SCRIPTRC>";
	docu.setContent(st);
	QDomElement elem=docu.documentElement();
	for (uint rd=0; rd < Tes->RecentScripts.count(); rd++)
		{
		QDomElement rde=docu.createElement("RECENT");
		rde.setAttribute("NAME",Tes->RecentScripts[rd]);
		elem.appendChild(rde);
		}
	QString ho = getenv("HOME");
	QFile f(ho+"/.scribus/scripter.rc");
	if(!f.open(IO_WriteOnly))
		return;
	QTextStream s(&f);
	s<<docu.toCString();
	f.close();
}

/****************************************************************************************/
/*                                                                                      */
/*   Definitionen der Python-Befehle                                                    */
/*                                                                                      */
/****************************************************************************************/

static PyObject *scribus_retval(PyObject *self, PyObject* args)
{
	char *Name;
	int retV;
	if (!PyArg_ParseTuple(args, "si", &Name, &retV))
		return NULL;
	RetString = QString(Name);
	RetVal = retV;
	return PyInt_FromLong(0L);
}

static PyObject *scribus_getval(PyObject *self, PyObject* args)
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	return PyString_FromString(InValue);
}

float PointToValue(float Val)
{
	float ret = 0.0;
	switch (doc->Einheit)
		{
		case 0:
			ret = Val;
			break;
		case 1:
			ret = Val * 0.3527777;
			break;
		case 2:
			ret = Val * (1.0 / 72.0);
			break;
		case 3:
			ret = Val * (1.0 / 12.0);
			break;
		}
	return ret;
}

float ValToPts(float Val, int ein)
{
	float ret = 0.0;
	switch (ein)
		{
		case 0:
			ret = Val;
			break;
		case 1:
			ret = Val / 0.3527777;
			break;
		case 2:
			ret = Val / (1.0 / 72.0);
			break;
		case 3:
			ret = Val / (1.0 / 12.0);
			break;
		}
	return ret;
}

float ValueToPoint(float Val)
{
	return ValToPts(Val, doc->Einheit);
}

int GetItem(QString Name)
{
  if (Name != "")
		{
		for (uint a = 0; a < doc->ActPage->Items.count(); a++)
			{
			if (doc->ActPage->Items.at(a)->AnName == Name)
				return int(a);
			}
		}
	else
		{
		if (doc->ActPage->SelItem.count() != 0)
			return doc->ActPage->SelItem.at(0)->ItemNr;
		}
	return -1;
}

void ReplaceColor(QString col, QString rep)
{
	for (uint b = 0; b < Carrier->view->Pages.count(); b++)
		{
		for (uint c = 0; c < Carrier->view->Pages.at(b)->Items.count(); c++)
			{
			if (Carrier->view->Pages.at(b)->Items.at(c)->PType == 4)
				{
				for (uint d = 0; d < Carrier->view->Pages.at(b)->Items.at(c)->Ptext.count(); d++)
					{
					if (col == Carrier->view->Pages.at(b)->Items.at(c)->Ptext.at(d)->ccolor)
						{
						Carrier->view->Pages.at(b)->Items.at(c)->Ptext.at(d)->ccolor = rep;
						}
					}
				}
			if (col == Carrier->view->Pages.at(b)->Items.at(c)->Pcolor)
				Carrier->view->Pages.at(b)->Items.at(c)->Pcolor = rep;
			if (col == Carrier->view->Pages.at(b)->Items.at(c)->Pcolor2)
				Carrier->view->Pages.at(b)->Items.at(c)->Pcolor2 = rep;
			}
		}
}

static PyObject *scribus_newdocdia(PyObject *self, PyObject* args)
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	bool ret = Carrier->slotFileNew();
	if (ret)
		doc = Carrier->doc;
	return PyInt_FromLong(long(ret));
}

static PyObject *scribus_newdoc(PyObject *self, PyObject* args)
{
	float b, h, lr, tpr, btr, rr, ebr;
	int unit, ds, fsl, fNr, ori;
	PyObject *p, *m;
	if (!PyArg_ParseTuple(args, "OOiiiii", &p, &m, &ori, &fNr, &unit, &ds, &fsl))
		return NULL;
	if (!PyArg_ParseTuple(p, "ff", &b, &h))
		return NULL;
	if (!PyArg_ParseTuple(m, "ffff", &lr, &rr, &tpr, &btr))
		return NULL;
	if (Carrier->HaveDoc)
		Carrier->DoFileClose();
	b = ValToPts(b, unit);
	h = ValToPts(h, unit);
	if (ori == 1)
		{
		ebr = b;
		b = h;
		h = ebr;
		}                   
	tpr = ValToPts(tpr, unit);
	lr = ValToPts(lr, unit);
	rr = ValToPts(rr, unit);
	btr = ValToPts(btr, unit);
	bool ret = Carrier->doFileNew(b, h, tpr, lr, rr, btr, 0, 1, false, ds, unit, fsl, ori, fNr);
	if (ret)
		doc = Carrier->doc;
	return PyInt_FromLong(long(ret));
}

static PyObject *scribus_setmargins(PyObject *self, PyObject* args)
{
	float lr, tpr, btr, rr;
	if (!PyArg_ParseTuple(args, "ffff", &lr, &rr, &tpr, &btr))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	tpr = ValueToPoint(tpr);
	lr = ValueToPoint(lr);
	rr = ValueToPoint(rr);
	btr = ValueToPoint(btr);
	doc->resetPage(tpr, lr, rr, btr, doc->PageFP);
	Carrier->view->reformPages();
	doc->setModified();
	Carrier->view->GotoPage(doc->ActPage->PageNr);
	Carrier->view->DrawNew();
	return Py_None;
}

static PyObject *scribus_closedoc(PyObject *self, PyObject* args)
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	return PyInt_FromLong(long(Carrier->DoFileClose()));
}

static PyObject *scribus_havedoc(PyObject *self, PyObject* args)
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	return PyInt_FromLong(long(Carrier->HaveDoc));
}

static PyObject *scribus_opendoc(PyObject *self, PyObject* args)
{
	char *Name;
	if (!PyArg_ParseTuple(args, "s", &Name))
		return NULL;
	bool ret = Carrier->LadeDoc(QString(Name));
	if (ret)
		doc = Carrier->doc;
	return PyInt_FromLong(long(ret));
}

static PyObject *scribus_savedoc(PyObject *self, PyObject* args)
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	Carrier->slotFileSave();
	return PyInt_FromLong(0L);
}

static PyObject *scribus_savedocas(PyObject *self, PyObject* args)
{
	char *Name;
	if (!PyArg_ParseTuple(args, "s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	return PyInt_FromLong(long(Carrier->DoFileSave(QString(Name))));
}

static PyObject *scribus_setinfo(PyObject *self, PyObject* args)
{
	char *Author;
	char *Title;
	char *Desc;
	if (!PyArg_ParseTuple(args, "zzz", &Author, &Title, &Desc))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	doc->DocAutor = QString(Author);
	doc->DocTitel = QString(Title);
	doc->DocComments = QString(Desc);
	Carrier->slotDocCh();
	return Py_None;
}

static PyObject *scribus_setunit(PyObject *self, PyObject* args)
{
	int e;
	if (!PyArg_ParseTuple(args, "i", &e))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	if ((e < 0) || (e > 3))
		return Py_None;
	Carrier->slotChangeUnit(e);
	return Py_None;
}

static PyObject *scribus_actualpage(PyObject *self, PyObject* args)
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	return PyInt_FromLong(long(Carrier->doc->ActPage->PageNr + 1));
}

static PyObject *scribus_getunit(PyObject *self, PyObject* args)
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	return PyInt_FromLong(long(Carrier->doc->Einheit));
}

static PyObject *scribus_redraw(PyObject *self, PyObject* args)
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	Carrier->view->DrawNew();
	return Py_None;
}

static PyObject *scribus_savepageeps(PyObject *self, PyObject* args)
{
	char *Name;
	if (!PyArg_ParseTuple(args, "s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	return PyInt_FromLong(long(Carrier->DoSaveAsEps(QString(Name))));
}

static PyObject *scribus_deletepage(PyObject *self, PyObject* args)
{
	int e;
	if (!PyArg_ParseTuple(args, "i", &e))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	e--;
	if ((e < 0) || (e > int(Carrier->view->Pages.count())-1))
		return Py_None;
	Carrier->DeletePage2(e);
	return Py_None;
}

static PyObject *scribus_gotopage(PyObject *self, PyObject* args)
{
	int e;
	if (!PyArg_ParseTuple(args, "i", &e))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	e--;
	if ((e < 0) || (e > int(Carrier->view->Pages.count())-1))
		return Py_None;
	Carrier->view->GotoPage(e);
	return Py_None;
}

static PyObject *scribus_newpage(PyObject *self, PyObject* args)
{
	int e;
	char *name = "Normal";
	if (!PyArg_ParseTuple(args, "i|s", &e, &name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	if (e < 0)
		Carrier->slotNewPageP(Carrier->view->Pages.count(), QString(name));
	else
		{
		e--;
		if ((e < 0) || (e > int(Carrier->view->Pages.count())-1))
			return Py_None;
		Carrier->slotNewPageP(e, QString(name));
		}
	return Py_None;
}

static PyObject *scribus_pagecount(PyObject *self, PyObject* args)
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	return PyInt_FromLong(long(Carrier->view->Pages.count()));
}

static PyObject *scribus_newrect(PyObject *self, PyObject* args)
{
	float x, y, b, h;
	int i;
	char *Name = "";
	if (!PyArg_ParseTuple(args, "ffff|s", &x, &y, &b, &h, &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	i = doc->ActPage->PaintRect(ValueToPoint(x), ValueToPoint(y),
															ValueToPoint(b), ValueToPoint(h),
															doc->Dwidth, doc->Dbrush, doc->Dpen);
	doc->ActPage->SetRectFrame(doc->ActPage->Items.at(i));
	if (Name != "")
		doc->ActPage->Items.at(i)->AnName = QString(Name);
	return PyString_FromString(doc->ActPage->Items.at(i)->AnName);
}

static PyObject *scribus_newellipse(PyObject *self, PyObject* args)
{
	float x, y, b, h;
	int i;
	char *Name = "";
	if (!PyArg_ParseTuple(args, "ffff|s", &x, &y, &b, &h, &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	i = doc->ActPage->PaintEllipse(ValueToPoint(x), ValueToPoint(y),
																 ValueToPoint(b), ValueToPoint(h),
																 doc->Dwidth, doc->Dbrush, doc->Dpen);
	doc->ActPage->SetOvalFrame(doc->ActPage->Items.at(i));
	if (Name != "")
		doc->ActPage->Items.at(i)->AnName = QString(Name);
	return PyString_FromString(doc->ActPage->Items.at(i)->AnName);
}

static PyObject *scribus_newimage(PyObject *self, PyObject* args)
{
	float x, y, b, h;
	int i;
	char *Name = "";
	if (!PyArg_ParseTuple(args, "ffff|s", &x, &y, &b, &h, &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	i = doc->ActPage->PaintPict(ValueToPoint(x), ValueToPoint(y), ValueToPoint(b), ValueToPoint(h));
	doc->ActPage->SetRectFrame(doc->ActPage->Items.at(i));
	if (Name != "")
		doc->ActPage->Items.at(i)->AnName = QString(Name);
	return PyString_FromString(doc->ActPage->Items.at(i)->AnName);
}

static PyObject *scribus_newtext(PyObject *self, PyObject* args)
{
	float x, y, b, h;
	int i;
	char *Name = "";
	if (!PyArg_ParseTuple(args, "ffff|s", &x, &y, &b, &h, &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	i = doc->ActPage->PaintText(ValueToPoint(x), ValueToPoint(y),
															ValueToPoint(b), ValueToPoint(h),
															doc->Dwidth, doc->DpenText);
	doc->ActPage->SetRectFrame(doc->ActPage->Items.at(i));
	if (Name != "")
		doc->ActPage->Items.at(i)->AnName = QString(Name);
	return PyString_FromString(doc->ActPage->Items.at(i)->AnName);
}

static PyObject *scribus_newline(PyObject *self, PyObject* args)
{
	float x, y, b, h;
	int i;
	char *Name = "";
	if (!PyArg_ParseTuple(args, "ffff|s", &x, &y, &b, &h, &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	x =	ValueToPoint(x);
	y = ValueToPoint(y);
	b = ValueToPoint(b);
	h = ValueToPoint(h);
	i = doc->ActPage->PaintPolyLine(x, y, 1, 1,	doc->Dwidth, doc->Dbrush, doc->Dpen);
	PageItem *it = doc->ActPage->Items.at(i);
	it->PoLine.resize(4);
	it->PoLine.setPoint(0, 0, 0);
	it->PoLine.setPoint(1, 0, 0);
	it->PoLine.setPoint(2, b-x, h-y);
	it->PoLine.setPoint(3, b-x, h-y);
	FPoint np2 = doc->ActPage->GetMinClipF(it->PoLine);
	if (np2.x() < 0)
		{
		it->PoLine.translate(-np2.x(), 0);
		doc->ActPage->MoveItem(np2.x(), 0, it);
		}
	if (np2.y() < 0)
		{
		it->PoLine.translate(0, -np2.y());
		doc->ActPage->MoveItem(0, np2.y(), it);
		}
	doc->ActPage->SizeItem(it->PoLine.WidthHeight().x(), it->PoLine.WidthHeight().y(), i, false, false);
	doc->ActPage->AdjustItemSize(it);
	if (Name != "")
		it->AnName = QString(Name);
	return PyString_FromString(it->AnName);
}

static PyObject *scribus_polyline(PyObject *self, PyObject* args)
{
	float x, y, b, h;
	int i = 0;
	int ic, pp, len;
	char *Name = "";
	PyObject *il;
	if (!PyArg_ParseTuple(args, "O|s", &il, &Name))
		return NULL;
	if (!PyList_Check(il))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	len = PyList_Size(il);
	if (len < 4)
		return PyString_FromString("");
	if ((len % 2) != 0)
		return PyString_FromString("");
	x = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i))));
	i++;
	y = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i))));
	i++;
	ic = doc->ActPage->PaintPolyLine(x, y, 1, 1,	doc->Dwidth, doc->Dbrush, doc->Dpen);
	PageItem *it = doc->ActPage->Items.at(ic);
	it->PoLine.resize(2);
	it->PoLine.setPoint(0, 0, 0);
	it->PoLine.setPoint(1, 0, 0);
	pp = 6;
	for (i = 2; i < len - 2; i += 2)
		{
		b = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i))));
		h = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i+1))));
		it->PoLine.resize(pp);
		it->PoLine.setPoint(pp-4, b-x, h-y);
		it->PoLine.setPoint(pp-3, b-x, h-y);
		it->PoLine.setPoint(pp-2, b-x, h-y);
		it->PoLine.setPoint(pp-1, b-x, h-y);
		pp += 4;
		}
	pp -= 2;
	b = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, len-2))));
	h = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, len-1))));
	it->PoLine.resize(pp);
	it->PoLine.setPoint(pp-2, b-x, h-y);
	it->PoLine.setPoint(pp-1, b-x, h-y);
	FPoint np2 = doc->ActPage->GetMinClipF(it->PoLine);
	if (np2.x() < 0)
		{
		it->PoLine.translate(-np2.x(), 0);
		doc->ActPage->MoveItem(np2.x(), 0, it);
		}
	if (np2.y() < 0)
		{
		it->PoLine.translate(0, -np2.y());
		doc->ActPage->MoveItem(0, np2.y(), it);
		}
	doc->ActPage->SizeItem(it->PoLine.WidthHeight().x(), it->PoLine.WidthHeight().y(), ic, false, false);
	doc->ActPage->AdjustItemSize(it);
	if (Name != "")
		it->AnName = QString(Name);
	return PyString_FromString(it->AnName);
}

static PyObject *scribus_polygon(PyObject *self, PyObject* args)
{
	float x, y, b, h;
	int i = 0;
	int ic, pp, len;
	char *Name = "";
	PyObject *il;
	if (!PyArg_ParseTuple(args, "O|s", &il, &Name))
		return NULL;
	if (!PyList_Check(il))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	len = PyList_Size(il);
	if (len < 6)
		return PyString_FromString("");
	if ((len % 2) != 0)
		return PyString_FromString("");
	x = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i))));
	i++;
	y = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i))));
	i++;
	ic = doc->ActPage->PaintPoly(x, y, 1, 1,	doc->Dwidth, doc->Dbrush, doc->Dpen);
	PageItem *it = doc->ActPage->Items.at(ic);
	it->PoLine.resize(2);
	it->PoLine.setPoint(0, 0, 0);
	it->PoLine.setPoint(1, 0, 0);
	pp = 6;
	for (i = 2; i < len - 2; i += 2)
		{
		b = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i))));
		h = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i+1))));
		it->PoLine.resize(pp);
		it->PoLine.setPoint(pp-4, b-x, h-y);
		it->PoLine.setPoint(pp-3, b-x, h-y);
		it->PoLine.setPoint(pp-2, b-x, h-y);
		it->PoLine.setPoint(pp-1, b-x, h-y);
		pp += 4;
		}
	b = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, len-2))));
	h = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, len-1))));
	it->PoLine.resize(pp);
	it->PoLine.setPoint(pp-4, b-x, h-y);
	it->PoLine.setPoint(pp-3, b-x, h-y);
	it->PoLine.setPoint(pp-2, b-x, h-y);
	it->PoLine.setPoint(pp-1, b-x, h-y);
	pp += 2;
	it->PoLine.resize(pp);
	it->PoLine.setPoint(pp-2, 0, 0);
	it->PoLine.setPoint(pp-1, 0, 0);
	FPoint np2 = doc->ActPage->GetMinClipF(it->PoLine);
	if (np2.x() < 0)
		{
		it->PoLine.translate(-np2.x(), 0);
		doc->ActPage->MoveItem(np2.x(), 0, it);
		}
	if (np2.y() < 0)
		{
		it->PoLine.translate(0, -np2.y());
		doc->ActPage->MoveItem(0, np2.y(), it);
		}
	doc->ActPage->SizeItem(it->PoLine.WidthHeight().x(), it->PoLine.WidthHeight().y(), ic, false, false);
	doc->ActPage->AdjustItemSize(it);
	if (Name != "")
		it->AnName = QString(Name);
	return PyString_FromString(it->AnName);
}

static PyObject *scribus_bezierline(PyObject *self, PyObject* args)
{
	float x, y, b, h, kx, ky, kx2, ky2;
	int i = 0;
	int ic, pp, len;
	char *Name = "";
	PyObject *il;
	if (!PyArg_ParseTuple(args, "O|s", &il, &Name))
		return NULL;
	if (!PyList_Check(il))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	len = PyList_Size(il);
	if (len < 8)
		return PyString_FromString("");
	if ((len % 6) != 0)
		return PyString_FromString("");
	x = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i))));
	i++;
	y = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i))));
	i++;
	kx = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i))));
	i++;
	ky = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i))));
	i++;
	kx2 = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i))));
	i++;
	ky2 = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i))));
	i++;
	ic = doc->ActPage->PaintPolyLine(x, y, 1, 1,	doc->Dwidth, doc->Dbrush, doc->Dpen);
	PageItem *it = doc->ActPage->Items.at(ic);
	it->PoLine.resize(2);
	it->PoLine.setPoint(0, 0, 0);
	it->PoLine.setPoint(1, kx-x, ky-y);
	pp = 6;
	for (i = 6; i < len - 6; i += 6)
		{
		b = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i))));
		h = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i+1))));
		kx = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i+2))));
		ky = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i+3))));
		kx2 = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i+4))));
		ky2 = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, i+5))));
		it->PoLine.resize(pp);
		it->PoLine.setPoint(pp-4, b-x, h-y);
		it->PoLine.setPoint(pp-3, kx-x, ky-y);
		it->PoLine.setPoint(pp-2, it->PoLine.point(pp-4));
		it->PoLine.setPoint(pp-1, kx2-x, ky2-y);
		pp += 4;
		}
	pp -= 2;
	b = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, len-6))));
	h = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, len-5))));
	kx = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, len-4))));
	ky = ValueToPoint(float(PyFloat_AsDouble(PyList_GetItem(il, len-3))));
	it->PoLine.resize(pp);
	it->PoLine.setPoint(pp-2, b-x, h-y);
	it->PoLine.setPoint(pp-1, kx-x, ky-y);
	FPoint np2 = doc->ActPage->GetMinClipF(it->PoLine);
	if (np2.x() < 0)
		{
		it->PoLine.translate(-np2.x(), 0);
		doc->ActPage->MoveItem(np2.x(), 0, it);
		}
	if (np2.y() < 0)
		{
		it->PoLine.translate(0, -np2.y());
		doc->ActPage->MoveItem(0, np2.y(), it);
		}
	doc->ActPage->SizeItem(it->PoLine.WidthHeight().x(), it->PoLine.WidthHeight().y(), ic, false, false);
	doc->ActPage->AdjustItemSize(it);
	if (Name != "")
		it->AnName = QString(Name);
	return PyString_FromString(it->AnName);
}

static PyObject *scribus_pathtext(PyObject *self, PyObject* args)
{
	int i, ii;
	float x, y;
	char *Name = "";
	char *TextB = "";
	char *PolyB = "";
	if (!PyArg_ParseTuple(args, "ffss|s", &x, &y, &TextB, &PolyB, &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	if ((TextB == "") || (PolyB == ""))
		return PyString_FromString("");
	i = GetItem(QString(TextB));
	ii = GetItem(QString(PolyB));
	if ((i == -1) || (ii == -1))
		return PyString_FromString("");
	doc->ActPage->SelItem.clear();
	doc->ActPage->SelItem.append(doc->ActPage->Items.at(i));
	doc->ActPage->SelItem.append(doc->ActPage->Items.at(ii));
	PageItem *it = doc->ActPage->Items.at(i);
	doc->ActPage->ToPathText();
	doc->ActPage->MoveItem(ValueToPoint(x) - it->Xpos, ValueToPoint(y) - it->Ypos, it);
	if (Name != "")
		it->AnName = QString(Name);
	return PyString_FromString(it->AnName);
}

static PyObject *scribus_deleteobj(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	if (Name != "")
		{
		doc->ActPage->SelItem.clear();
		i = GetItem(QString(Name));
		if (i != -1)
			doc->ActPage->SelItem.append(doc->ActPage->Items.at(i));
		}
	doc->ActPage->DeleteItem();
	return Py_None;
}

static PyObject *scribus_getfillcolor(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	i = GetItem(QString(Name));
	if (i != -1)
		return PyString_FromString(doc->ActPage->Items.at(i)->Pcolor);
	else
		return PyString_FromString("");
}

static PyObject *scribus_getlinecolor(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	PageItem *it;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	i = GetItem(QString(Name));
	if (i != -1)
		{
		it = doc->ActPage->Items.at(i);
		if ((it->HasSel) && ((it->PType == 4) || (it->PType == 8)))
			{
			for (uint b = 0; b < it->Ptext.count(); b++)
				{
				if (it->Ptext.at(b)->cselect)
					return PyString_FromString(it->Ptext.at(b)->ccolor);
				}
			}
		else
			return PyString_FromString(it->Pcolor2);
		}
	return PyString_FromString("");
}

static PyObject *scribus_getlinewidth(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyFloat_FromDouble(0.0);
	i = GetItem(QString(Name));
	if (i != -1)
		return PyFloat_FromDouble(double(doc->ActPage->Items.at(i)->Pwidth));
	else
		return PyFloat_FromDouble(0.0);
}

static PyObject *scribus_getlineshade(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	PageItem *it;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	i = GetItem(QString(Name));
	if (i != -1)
		{
		it = doc->ActPage->Items.at(i);
		if ((it->HasSel) && ((it->PType == 4) || (it->PType == 8)))
			{
			for (uint b = 0; b < it->Ptext.count(); b++)
				{
				if (it->Ptext.at(b)->cselect)
					return PyInt_FromLong(long(it->Ptext.at(b)->cshade));
				}
			}
		else
			return PyInt_FromLong(long(it->Shade2));
		}
	return PyInt_FromLong(0L);
}

static PyObject *scribus_getlinejoin(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	i = GetItem(QString(Name));
	if (i != -1)
		return PyInt_FromLong(long(doc->ActPage->Items.at(i)->PLineJoin));
	else
		return PyInt_FromLong(0L);
}

static PyObject *scribus_getlineend(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	i = GetItem(QString(Name));
	if (i != -1)
		return PyInt_FromLong(long(doc->ActPage->Items.at(i)->PLineEnd));
	else
		return PyInt_FromLong(0L);
}

static PyObject *scribus_getlinestyle(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	i = GetItem(QString(Name));
	if (i != -1)
		return PyInt_FromLong(long(doc->ActPage->Items.at(i)->PLineArt));
	else
		return PyInt_FromLong(0L);
}

static PyObject *scribus_getfillshade(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	i = GetItem(QString(Name));
	if (i != -1)
		return PyInt_FromLong(long(doc->ActPage->Items.at(i)->Shade));
	else
		return PyInt_FromLong(0L);
}

static PyObject *scribus_getcornerrad(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	i = GetItem(QString(Name));
	if (i != -1)
		return PyInt_FromLong(long(doc->ActPage->Items.at(i)->RadRect));
	else
		return PyInt_FromLong(0L);
}

static PyObject *scribus_getimgscale(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return Py_BuildValue("(ff)", 1.0, 1.0);
	i = GetItem(QString(Name));
	if (i != -1)
		{
		PageItem *b = doc->ActPage->Items.at(i);
		return Py_BuildValue("(ff)", b->LocalScX, b->LocalScY);
		}
	else
		return Py_BuildValue("(ff)", 1.0, 1.0);
}

static PyObject *scribus_getimgname(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	i = GetItem(QString(Name));
	if (i != -1)
		return PyString_FromString(doc->ActPage->Items.at(i)->Pfile);
	else
		return PyString_FromString("");
}

static PyObject *scribus_getposi(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return Py_BuildValue("(ff)", 0.0, 0.0);
	i = GetItem(QString(Name));
	if (i != -1)
		{
		PageItem *it = doc->ActPage->Items.at(i);
		return Py_BuildValue("(ff)", PointToValue(it->Xpos), PointToValue(it->Ypos));
		}
	else
		return Py_BuildValue("(ff)", 0.0, 0.0);
}

static PyObject *scribus_getsize(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return Py_BuildValue("(ff)", 0.0, 0.0);
	i = GetItem(QString(Name));
	if (i != -1)
		{
		PageItem *it = doc->ActPage->Items.at(i);
		return Py_BuildValue("(ff)", PointToValue(it->Width), PointToValue(it->Height));
		}
	else
		return Py_BuildValue("(ff)", 0.0, 0.0);
}

static PyObject *scribus_getrotation(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyFloat_FromDouble(0.0);
	i = GetItem(QString(Name));
	if (i != -1)
		return PyFloat_FromDouble(double(doc->ActPage->Items.at(i)->Rot * -1));
	else
		return PyFloat_FromDouble(0.0);
}

static PyObject *scribus_getfontsize(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	PageItem *it;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	i = GetItem(QString(Name));
	if (i != -1)
		{
		it = doc->ActPage->Items.at(i);
		if (it->HasSel)
			{
			for (uint b = 0; b < it->Ptext.count(); b++)
				{
				if (it->Ptext.at(b)->cselect)
					return PyInt_FromLong(long(it->Ptext.at(b)->csize));
				}
			}
		else
			return PyInt_FromLong(long(it->ISize));
		}
	return PyInt_FromLong(0L);
}

static PyObject *scribus_getfont(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	PageItem *it;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	i = GetItem(QString(Name));
	if (i != -1)
		{
		it = doc->ActPage->Items.at(i);
		if (it->HasSel)
			{
			for (uint b = 0; b < it->Ptext.count(); b++)
				{
				if (it->Ptext.at(b)->cselect)
					return PyString_FromString(it->Ptext.at(b)->cfont);
				}
			}
		else
			return PyString_FromString(it->IFont);
		}
	return PyString_FromString("");
}

static PyObject *scribus_gettextsize(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	i = GetItem(QString(Name));
	if (i != -1)
		return PyInt_FromLong(long(doc->ActPage->Items.at(i)->Ptext.count()));
	else
		return PyInt_FromLong(0L);
}

static PyObject *scribus_getlinespace(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyFloat_FromDouble(0.0);
	i = GetItem(QString(Name));
	if (i != -1)
		return PyFloat_FromDouble(double(doc->ActPage->Items.at(i)->LineSp));
	else
		return PyFloat_FromDouble(0.0);
}

static PyObject *scribus_setfillcolor(PyObject *self, PyObject* args)
{
	char *Name = "";
	char *Color;
	int i;
	if (!PyArg_ParseTuple(args, "s|s", &Color, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		doc->ActPage->Items.at(i)->Pcolor = QString(Color);
	return Py_None;
}

static PyObject *scribus_setlinecolor(PyObject *self, PyObject* args)
{
	char *Name = "";
	char *Color;
	int i;
	PageItem *it;
	if (!PyArg_ParseTuple(args, "s|s", &Color, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		{
		it = doc->ActPage->Items.at(i);
		if ((it->PType == 4) || (it->PType == 8))
			{
			for (uint b = 0; b < it->Ptext.count(); b++)
				{
				if (it->HasSel)
					{
					if (it->Ptext.at(b)->cselect)
						it->Ptext.at(b)->ccolor = QString(Color);
					}
				else
					it->Ptext.at(b)->ccolor = QString(Color);
				}
			}
		it->Pcolor2 = QString(Color);
		}
	return Py_None;
}

static PyObject *scribus_setlinewidth(PyObject *self, PyObject* args)
{
	char *Name = "";
	float w;
	int i;
	if (!PyArg_ParseTuple(args, "f|s", &w, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	if ((w < 0.0) || (w > 12.0))
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		doc->ActPage->Items.at(i)->Pwidth = w;
	return Py_None;
}

static PyObject *scribus_setlineshade(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i, w;
	PageItem *it;
	if (!PyArg_ParseTuple(args, "i|s", &w, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	if ((w < 0) || (w > 100))
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		{
		it = doc->ActPage->Items.at(i);
		if ((it->PType == 4) || (it->PType == 8))
			{
			for (uint b = 0; b < it->Ptext.count(); b++)
				{
				if (it->HasSel)
					{
					if (it->Ptext.at(b)->cselect)
						it->Ptext.at(b)->cshade = w;
					}
				else
					it->Ptext.at(b)->cshade = w;
				}
			}
		it->Shade2 = w;
		}
	return Py_None;
}

static PyObject *scribus_setfillshade(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i, w;
	if (!PyArg_ParseTuple(args, "i|s", &w, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	if ((w < 0) || (w > 100))
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		doc->ActPage->Items.at(i)->Shade = w;
	return Py_None;
}

static PyObject *scribus_setlinejoin(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i, w;
	if (!PyArg_ParseTuple(args, "i|s", &w, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		doc->ActPage->Items.at(i)->PLineJoin = Qt::PenJoinStyle(w);
	return Py_None;
}

static PyObject *scribus_setlineend(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i, w;
	if (!PyArg_ParseTuple(args, "i|s", &w, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		doc->ActPage->Items.at(i)->PLineEnd = Qt::PenCapStyle(w);
	return Py_None;
}

static PyObject *scribus_setlinestyle(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i, w;
	if (!PyArg_ParseTuple(args, "i|s", &w, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		doc->ActPage->Items.at(i)->PLineArt = Qt::PenStyle(w);
	return Py_None;
}

static PyObject *scribus_setcornerrad(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i, w;
	if (!PyArg_ParseTuple(args, "i|s", &w, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	if (w < 0)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		{
		PageItem *b = doc->ActPage->Items.at(i);
		if ((b->PType == 2) || (b->PType == 3) || (b->PType == 4))
			{
			b->RadRect = w;
			if (w > 0)
				doc->ActPage->SetFrameRound(b);
			else
				doc->ActPage->SetRectFrame(b);
			}
		}
	return Py_None;
}

static PyObject *scribus_setlinespace(PyObject *self, PyObject* args)
{
	char *Name = "";
	float w;
	int i;
	if (!PyArg_ParseTuple(args, "f|s", &w, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	if (w < 0.1)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		doc->ActPage->Items.at(i)->LineSp = w;
	return Py_None;
}

static PyObject *scribus_loadimage(PyObject *self, PyObject* args)
{
	char *Name = "";
	char *Image;
	int i;
	if (!PyArg_ParseTuple(args, "s|s", &Image, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		doc->ActPage->LoadPict(QString(Image), i);
	return Py_None;
}

static PyObject *scribus_scaleimage(PyObject *self, PyObject* args)
{
	char *Name = "";
	float x, y;
	int i;
	if (!PyArg_ParseTuple(args, "ff|s", &x, &y, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if ((i != -1) && (doc->ActPage->Items.at(i)->PType == 2))
		{
		PageItem *b = doc->ActPage->Items.at(i);
		b->LocalScX = x;
		b->LocalScY = y;
		}
	return Py_None;
}

static PyObject *scribus_setboxtext(PyObject *self, PyObject* args)
{
	char *Name = "";
	char *Text;
	int i;
	PageItem *it;
	PageItem *nb;
	struct Pti *hg;
	if (!PyArg_ParseTuple(args, "s|s", &Text, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	QString Daten = QString(Text);
	if (i != -1)
		{
		it = doc->ActPage->Items.at(i);
		if (it->NextBox != 0)
			{
			nb = it->NextBox;
			while (nb != 0)
				{
				nb->Ptext.clear();
				nb->CPos = 0;
				nb->Dirty = true;
				nb = nb->NextBox;
				}
			}
		it->Ptext.clear();
		for (uint a = 0; a < Daten.length(); a++)
			{
			hg = new Pti;
			hg->ch = Daten.at(a);
			if (hg->ch == QChar(10)) { hg->ch = QChar(13); }
			if (hg->ch == QChar(9)) { hg->ch = " "; }
			hg->cfont = it->IFont;
			hg->csize = it->ISize;
			hg->ccolor = it->Pcolor2;
			hg->cextra = 0;
			hg->cshade = it->Shade2;
			hg->cselect = false;
			hg->cstyle = 0;
 			hg->cab = doc->CurrentABStil;
			hg->xp = 0;
			hg->yp = 0;
			hg->PRot = 0;
			hg->PtransX = 0;
			hg->PtransY = 0;
			it->Ptext.append(hg);
			}
		}
	return Py_None;
}

static PyObject *scribus_inserttext(PyObject *self, PyObject* args)
{
	char *Name = "";
	char *Text;
	int i, pos;
	PageItem *it;
	struct Pti *hg;
	if (!PyArg_ParseTuple(args, "si|s", &Text, &pos, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	QString Daten = QString(Text);
	if (i != -1)
		{
		it = doc->ActPage->Items.at(i);
		if ((pos < 0) && (pos > int(it->Ptext.count())))
			return Py_None;
		for (uint a = 0; a < Daten.length(); a++)
			{
			hg = new Pti;
			hg->ch = Daten.at(Daten.length()-1-a);
			if (hg->ch == QChar(10)) { hg->ch = QChar(13); }
			if (hg->ch == QChar(9)) { hg->ch = " "; }
			hg->cfont = it->IFont;
			hg->csize = it->ISize;
			hg->ccolor = it->Pcolor2;
			hg->cextra = 0;
			hg->cshade = it->Shade2;
			hg->cselect = false;
			hg->cstyle = 0;
 			hg->cab = doc->CurrentABStil;
			hg->xp = 0;
			hg->yp = 0;
			hg->PRot = 0;
			hg->PtransX = 0;
			hg->PtransY = 0;
			it->Ptext.insert(pos, hg);
			}
		it->CPos = pos + Daten.length();
 		it->Dirty = true;
 		it->paintObj();
		}
	return Py_None;
}

static PyObject *scribus_gettext(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	QString text = "";
	PageItem *it;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	i = GetItem(QString(Name));
	if (i != -1)
		{
		it = doc->ActPage->Items.at(i);
		for (uint a = 0; a < it->Ptext.count(); a++)
			{
			if (it->HasSel)
				{
				if (it->Ptext.at(a)->cselect)
					text += it->Ptext.at(a)->ch;
				}
			else
				text += it->Ptext.at(a)->ch;
			}
		return PyString_FromString(text);
		}
	else
		return PyString_FromString("");
}

static PyObject *scribus_setalign(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i, size, Apm;
	if (!PyArg_ParseTuple(args, "i|s", &size, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (size > 3)
		return Py_None;
	if (size < 0)
		return Py_None;
	if ((i != -1) && (doc->ActPage->Items.at(i)->PType == 4))
		{
		Apm = doc->AppMode;
		doc->ActPage->SelItem.clear();
		doc->ActPage->SelItem.append(doc->ActPage->Items.at(i));
		if (doc->ActPage->Items.at(i)->HasSel)
			doc->AppMode = 7;
		Carrier->setNewAbStyle(size);
		doc->AppMode = Apm;
		doc->ActPage->Deselect();
		}
	return Py_None;
}

static PyObject *scribus_setfontsize(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i, size, Apm;
	if (!PyArg_ParseTuple(args, "i|s", &size, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (size > 512)
		return Py_None;
	if (size < 1)
		return Py_None;
	if ((i != -1) && (doc->ActPage->Items.at(i)->PType == 4))
		{
		Apm = doc->AppMode;
		doc->ActPage->SelItem.clear();
		doc->ActPage->SelItem.append(doc->ActPage->Items.at(i));
		if (doc->ActPage->Items.at(i)->HasSel)
			doc->AppMode = 7;
		doc->ActPage->chFSize(size);
		doc->AppMode = Apm;
		doc->ActPage->Deselect();
		}
	return Py_None;
}

static PyObject *scribus_setfont(PyObject *self, PyObject* args)
{
	char *Name = "";
	char *Font = "";
	int i, Apm;
	if (!PyArg_ParseTuple(args, "s|s", &Font, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if ((i != -1) && (doc->ActPage->Items.at(i)->PType == 4))
		{
		if (Carrier->Prefs.AvailFonts.find(QString(Font)))
			{
			Apm = doc->AppMode;
			doc->ActPage->SelItem.clear();
			doc->ActPage->SelItem.append(doc->ActPage->Items.at(i));
			if (doc->ActPage->Items.at(i)->HasSel)
				doc->AppMode = 7;
			Carrier->SetNewFont(QString(Font));
			doc->AppMode = Apm;
			doc->ActPage->Deselect();
			}
		}
	return Py_None;
}

static PyObject *scribus_selecttext(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i, start, ende;
	PageItem *it;
	if (!PyArg_ParseTuple(args, "ii|s", &start, &ende, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		{
		it = doc->ActPage->Items.at(i);
		if ((start < 0) || ((start + ende) > int(it->Ptext.count()-1)))
			return Py_None;
		for (uint a = 0; a < it->Ptext.count(); a++)
			{
			it->Ptext.at(a)->cselect = false;
			}
		if (ende == 0)
			{
			it->HasSel = false;
			return Py_None;
			}
		for (int aa = start; aa < (start + ende); aa++)
			{
			it->Ptext.at(aa)->cselect = true;
			}
		it->HasSel = true;
		return Py_None;
		}
	else
		return Py_None;
}

static PyObject *scribus_deletetext(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	PageItem *it;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		{
		it = doc->ActPage->Items.at(i);
		if (it->HasSel)
			Carrier->DeleteSel(it);
		else
			{
			it->Ptext.clear();
			it->CPos = 0;
			}
		}
	return Py_None;
}

static PyObject *scribus_moveobjrel(PyObject *self, PyObject* args)
{
	char *Name = "";
	float x, y;
	int i;
	if (!PyArg_ParseTuple(args, "ff|s", &x, &y, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		{
		if (doc->ActPage->GroupSel)
			doc->ActPage->moveGroup(ValueToPoint(x), ValueToPoint(y));
		else
			doc->ActPage->MoveItem(ValueToPoint(x), ValueToPoint(y), doc->ActPage->Items.at(i));
		}
	return Py_None;
}

static PyObject *scribus_moveobjabs(PyObject *self, PyObject* args)
{
	char *Name = "";
	float x, y, x2, y2, w, h;
	int i;
	if (!PyArg_ParseTuple(args, "ff|s", &x, &y, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		{
		if (doc->ActPage->GroupSel)
			{
			doc->ActPage->getGroupRect(&x2, &y2, &w, &h);
			doc->ActPage->moveGroup(ValueToPoint(x) - x2, ValueToPoint(y) - y2);
			}
		else
			{
			PageItem *b = doc->ActPage->Items.at(i);
			doc->ActPage->MoveItem(ValueToPoint(x) - b->Xpos, ValueToPoint(y) - b->Ypos, b);
			}
		}
	return Py_None;
}

static PyObject *scribus_rotobjrel(PyObject *self, PyObject* args)
{
	char *Name = "";
	float x;
	int i;
	if (!PyArg_ParseTuple(args, "f|s", &x, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		doc->ActPage->RotateItem(doc->ActPage->Items.at(i)->Rot - x, i);
	return Py_None;
}

static PyObject *scribus_rotobjabs(PyObject *self, PyObject* args)
{
	char *Name = "";
	float x;
	int i;
	if (!PyArg_ParseTuple(args, "f|s", &x, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		doc->ActPage->RotateItem(x * -1.0, i);
	return Py_None;
}

static PyObject *scribus_sizeobjabs(PyObject *self, PyObject* args)
{
	char *Name = "";
	float x, y;
	int i;
	if (!PyArg_ParseTuple(args, "ff|s", &x, &y, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		{
		PageItem *b = doc->ActPage->Items.at(i);
		doc->ActPage->SizeItem(ValueToPoint(x) - b->Xpos, ValueToPoint(y) - b->Ypos, i);
		}
	return Py_None;
}

static PyObject *scribus_groupobj(PyObject *self, PyObject* args)
{
	int i = 0;
	int ic, len;
	char *Name = "";
	PyObject *il = 0;
	if (!PyArg_ParseTuple(args, "|O", &il))
		return NULL;
	if (il != 0)
		{
		if (!PyList_Check(il))
			return NULL;
		Py_INCREF(Py_None);
		if (!Carrier->HaveDoc)
			return Py_None;
		len = PyList_Size(il);
		if (len == 0)
			return Py_None;
		for (i = 0; i < len; i++)
			{
			Name = PyString_AsString(PyList_GetItem(il, i));
			ic = GetItem(QString(Name));
			if (ic != -1)
				doc->ActPage->SelectItemNr(ic);
			}
		}
	else
		{
		Py_INCREF(Py_None);
		if (!Carrier->HaveDoc)
			return Py_None;
		}
	if (doc->ActPage->SelItem.count() != 0)
		{
		Carrier->GroupObj();
		doc->ActPage->Deselect();
		}
	return Py_None;
}

static PyObject *scribus_ungroupobj(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "|s", &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		Carrier->UnGroupObj();
	return Py_None;
}

static PyObject *scribus_scalegroup(PyObject *self, PyObject* args)
{
	char *Name = "";
	float sc;
	int i, h;
	if (!PyArg_ParseTuple(args, "f|s", &sc, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	else
	if (sc == 0.0)
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		{
		doc->ActPage->Deselect();
		doc->ActPage->SelectItemNr(i);
		h = doc->ActPage->HowTo;
		doc->ActPage->HowTo = 1;
		doc->ActPage->scaleGroup(sc, sc);
		doc->ActPage->HowTo = h;
		}
	return Py_None;
}

static PyObject *scribus_getselobjnam(PyObject *self, PyObject* args)
{
	int i = 0;
	if (!PyArg_ParseTuple(args, "|i", &i))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	if ((i < int(doc->ActPage->SelItem.count())) && (i > -1))
		return PyString_FromString(doc->ActPage->SelItem.at(i)->AnName);
	else
		return PyString_FromString("");
}

static PyObject *scribus_selcount(PyObject *self, PyObject* args)
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	return PyInt_FromLong(long(doc->ActPage->SelItem.count()));
}

static PyObject *scribus_selectobj(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i;
	if (!PyArg_ParseTuple(args, "s", &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	if (Name == "")
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		doc->ActPage->SelectItemNr(i);
	return Py_None;
}

static PyObject *scribus_deselect(PyObject *self, PyObject* args)
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	if (Carrier->HaveDoc)
		doc->ActPage->Deselect();
	return Py_None;
}

static PyObject *scribus_colornames(PyObject *self, PyObject* args)
{
	CListe edc;
	PyObject *l;
	int cc = 0;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (Carrier->HaveDoc)
		edc = Carrier->doc->PageColors;
	else
		edc = Carrier->Prefs.DColors;
	CListe::Iterator it;
	l = PyList_New(edc.count());
	for (it = edc.begin(); it != edc.end(); ++it)
		{
		PyList_SetItem(l, cc, PyString_FromString(it.key()));
		cc++;
		}
	return l;
}

static PyObject *scribus_getcolor(PyObject *self, PyObject* args)
{
	CListe edc;
	char *Name = "";
	int c, m, y, k;
	if (!PyArg_ParseTuple(args, "s", &Name))
		return NULL;
	if (Name == "")
		return Py_BuildValue("(iiii)", 0, 0, 0, 0);
	if (Carrier->HaveDoc)
		edc = Carrier->doc->PageColors;
	else
		edc = Carrier->Prefs.DColors;
	QString col = QString(Name);
	if (!edc.contains(col))
		return Py_BuildValue("(iiii)", 0, 0, 0, 0);
  edc[col].getCMYK(&c, &m, &y, &k);
	return Py_BuildValue("(iiii)", long(c), long(m), long(y), long(k));
}

static PyObject *scribus_setcolor(PyObject *self, PyObject* args)
{
	char *Name = "";
	int c, m, y, k;
	if (!PyArg_ParseTuple(args, "siiii", &Name, &c, &m, &y, &k))
		return NULL;
	Py_INCREF(Py_None);
	if (Name == "")
		return Py_None;
	QString col = QString(Name);
	if (Carrier->HaveDoc)
		{
		if (!Carrier->doc->PageColors.contains(col))
			return Py_None;
  	Carrier->doc->PageColors[col].setColor(c, m, y, k);
		}
	else
		{
		if (!Carrier->Prefs.DColors.contains(col))
			return Py_None;
		Carrier->Prefs.DColors[col].setColor(c, m, y, k);
		}
	return Py_None;
}

static PyObject *scribus_newcolor(PyObject *self, PyObject* args)
{
	char *Name = "";
	int c, m, y, k;
	if (!PyArg_ParseTuple(args, "siiii", &Name, &c, &m, &y, &k))
		return NULL;
	Py_INCREF(Py_None);
	if (Name == "")
		return Py_None;
	QString col = QString(Name);
	if (Carrier->HaveDoc)
		{
		if (!Carrier->doc->PageColors.contains(col))
			Carrier->doc->PageColors.insert(col, CMYKColor(c, m, y, k));
		else
  		Carrier->doc->PageColors[col].setColor(c, m, y, k);
		}
	else
		{
		if (!Carrier->Prefs.DColors.contains(col))
			Carrier->Prefs.DColors.insert(col, CMYKColor(c, m, y, k));
		else
			Carrier->Prefs.DColors[col].setColor(c, m, y, k);
		}
	return Py_None;
}

static PyObject *scribus_delcolor(PyObject *self, PyObject* args)
{
	char *Name = "";
	char *Repl = "None";
	if (!PyArg_ParseTuple(args, "s|s", &Name, &Repl))
		return NULL;
	Py_INCREF(Py_None);
	if (Name == "")
		return Py_None;
	QString col = QString(Name);
	QString rep = QString(Repl);
	if (Carrier->HaveDoc)
		{
		if (Carrier->doc->PageColors.contains(col) && (Carrier->doc->PageColors.contains(rep) || (rep == "None")))
			{
			Carrier->doc->PageColors.remove(col);
			ReplaceColor(col, rep);
			}
		}
	else
		{
		if (Carrier->Prefs.DColors.contains(col))
			Carrier->Prefs.DColors.remove(col);
		}
	return Py_None;
}

static PyObject *scribus_replcolor(PyObject *self, PyObject* args)
{
	char *Name = "";
	char *Repl = "None";
	if (!PyArg_ParseTuple(args, "s|s", &Name, &Repl))
		return NULL;
	Py_INCREF(Py_None);
	if (Name == "")
		return Py_None;
	QString col = QString(Name);
	QString rep = QString(Repl);
	if (!Carrier->HaveDoc)
		return Py_None;
	if (Carrier->doc->PageColors.contains(col) && (Carrier->doc->PageColors.contains(rep) || (rep == "None")))
		ReplaceColor(col, rep);
	return Py_None;
}

static PyObject *scribus_fontnames(PyObject *self, PyObject* args)
{
	PyObject *l;
	int cc = 0;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	l = PyList_New(Carrier->Prefs.AvailFonts.count());
	SCFontsIterator it(Carrier->Prefs.AvailFonts);
	for ( ; it.current() ; ++it)
		{
		PyList_SetItem(l, cc, PyString_FromString(it.currentKey()));
		cc++;
		}
	return l;
}

static PyObject *scribus_getlayers(PyObject *self, PyObject* args)
{
	PyObject *l;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (Carrier->HaveDoc)
		{
		l = PyList_New(doc->Layers.count());
		for (uint lam=0; lam < doc->Layers.count(); lam++)
			{
			PyList_SetItem(l, lam, PyString_FromString(doc->Layers[lam].Name));
			}
		}
	else
		l = PyList_New(0);
	return l;
}

static PyObject *scribus_setactlayer(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i = -1;
	if (!PyArg_ParseTuple(args, "s", &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	if (Name == "")
		return Py_None;
	for (uint lam=0; lam < doc->Layers.count(); lam++)
		{
		if (doc->Layers[lam].Name == QString(Name))
			{
			i = int(lam);
			doc->ActiveLayer = i;
			Carrier->changeLayer(i);
			break;
			}
		}
	return Py_None;
}

static PyObject *scribus_getactlayer(PyObject *self, PyObject* args)
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyString_FromString("");
	return PyString_FromString(doc->Layers[doc->ActiveLayer].Name);
}

static PyObject *scribus_senttolayer(PyObject *self, PyObject* args)
{
	char *Name = "";
	char *Layer = "";
	int i, la;
	if (!PyArg_ParseTuple(args, "s|s", &Layer, &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	if (Layer == "")
		return Py_None;
	i = GetItem(QString(Name));
	if (i != -1)
		{
		la = -1;
		PageItem *b = doc->ActPage->Items.at(i);
		doc->ActPage->SelectItemNr(i);
		for (uint lam=0; lam < doc->Layers.count(); lam++)
			{
			if (doc->Layers[lam].Name == QString(Layer))
				{
				b->LayerNr = int(lam);
				break;
				}
			}
		}
	return Py_None;
}

static PyObject *scribus_layervisible(PyObject *self, PyObject* args)
{
	char *Name = "";
	int vis = 1;
	if (!PyArg_ParseTuple(args, "si", &Name, &vis))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	if (Name == "")
		return Py_None;
	for (uint lam=0; lam < doc->Layers.count(); lam++)
		{
		if (doc->Layers[lam].Name == QString(Name))
			{
			doc->Layers[lam].Sichtbar = vis;
			break;
			}
		}
	return Py_None;
}

static PyObject *scribus_layerprint(PyObject *self, PyObject* args)
{
	char *Name = "";
	int vis = 1;
	if (!PyArg_ParseTuple(args, "si", &Name, &vis))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	if (Name == "")
		return Py_None;
	for (uint lam=0; lam < doc->Layers.count(); lam++)
		{
		if (doc->Layers[lam].Name == QString(Name))
			{
			doc->Layers[lam].Drucken = vis;
			break;
			}
		}
	return Py_None;
}

static PyObject *scribus_glayervisib(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i = 0;
	if (!PyArg_ParseTuple(args, "s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	if (Name == "")
		return PyInt_FromLong(0L);
	for (uint lam=0; lam < doc->Layers.count(); lam++)
		{
		if (doc->Layers[lam].Name == QString(Name))
			{
			i = int(doc->Layers[lam].Sichtbar);
			break;
			}
		}
	return PyInt_FromLong(long(i));
}

static PyObject *scribus_glayerprint(PyObject *self, PyObject* args)
{
	char *Name = "";
	int i = 0;
	if (!PyArg_ParseTuple(args, "s", &Name))
		return NULL;
	if (!Carrier->HaveDoc)
		return PyInt_FromLong(0L);
	if (Name == "")
		return PyInt_FromLong(0L);
	for (uint lam=0; lam < doc->Layers.count(); lam++)
		{
		if (doc->Layers[lam].Name == QString(Name))
			{
			i = int(doc->Layers[lam].Drucken);
			break;
			}
		}
	return PyInt_FromLong(long(i));
}

static PyObject *scribus_removelayer(PyObject *self, PyObject* args)
{
	char *Name = "";
	int num, num2;
	if (!PyArg_ParseTuple(args, "s", &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	if (Name == "")
		return Py_None;
	if (doc->Layers.count() == 1)
		return Py_None;
	for (uint lam=0; lam < doc->Layers.count(); lam++)
		{
		if (doc->Layers[lam].Name == QString(Name))
			{
			QValueList<Layer>::iterator it2;
			it2 = doc->Layers.at(lam);
			num2 = (*it2).LNr;
			num = (*it2).Level;
			doc->Layers.remove(it2);
			QValueList<Layer>::iterator it;
			for (uint l = 0; l < doc->Layers.count(); l++)
				{
				it = doc->Layers.at(l);
				if ((*it).Level > num)
					(*it).Level -= 1;
				if ((*it).LNr > num2)
					(*it).LNr -= 1;
				}
			Carrier->LayerRemove(lam);
			doc->ActiveLayer = 0;
			Carrier->changeLayer(0);
			break;
			}
		}
	return Py_None;
}

static PyObject *scribus_createlayer(PyObject *self, PyObject* args)
{
	char *Name = "";
	if (!PyArg_ParseTuple(args, "s", &Name))
		return NULL;
	Py_INCREF(Py_None);
	if (!Carrier->HaveDoc)
		return Py_None;
	if (Name == "")
		return Py_None;
	QString tmp;
	struct Layer ll;
	ll.LNr = doc->Layers.count();
	ll.Level = doc->Layers.count();
	ll.Name = QString(Name);
	ll.Sichtbar = true;
	ll.Drucken = true;
	doc->Layers.append(ll);
	doc->ActiveLayer = ll.LNr;
	Carrier->changeLayer(ll.LNr);
	return Py_None;
}

static PyObject *scribus_getallobj(PyObject *self, PyObject* args)
{
	PyObject *l;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (Carrier->HaveDoc)
		{
		l = PyList_New(doc->ActPage->Items.count());
		for (uint lam=0; lam < doc->ActPage->Items.count(); lam++)
			{
			PyList_SetItem(l, lam, PyString_FromString(doc->ActPage->Items.at(lam)->AnName));
			}
		}
	else
		l = PyList_New(0);
	return l;
}

static PyMethodDef scribus_methods[] = {
	{"NewDocDialog",			scribus_newdocdia,		METH_VARARGS},
	{"NewDoc",						scribus_newdoc,				METH_VARARGS},
	{"CloseDoc",					scribus_closedoc,			METH_VARARGS},
	{"HaveDoc",						scribus_havedoc,			METH_VARARGS},
	{"OpenDoc",						scribus_opendoc,			METH_VARARGS},
	{"SaveDoc",						scribus_savedoc,			METH_VARARGS},
	{"SaveDocAs",					scribus_savedocas,		METH_VARARGS},
	{"SetInfo",						scribus_setinfo,			METH_VARARGS},
	{"SetMargins",				scribus_setmargins,		METH_VARARGS},
	{"SetUnit",						scribus_setunit,			METH_VARARGS},
	{"GetUnit",						scribus_getunit,			METH_VARARGS},
	{"CurrentPage",				scribus_actualpage,		METH_VARARGS},
	{"RedrawAll",					scribus_redraw,				METH_VARARGS},
	{"SavePageAsEPS",			scribus_savepageeps,	METH_VARARGS},
	{"NewPage",						scribus_newpage,			METH_VARARGS},
	{"DeletePage",				scribus_deletepage,		METH_VARARGS},
	{"GotoPage",					scribus_gotopage,			METH_VARARGS},
	{"PageCount",					scribus_pagecount,		METH_VARARGS},
	{"CreateRect",				scribus_newrect,			METH_VARARGS},
	{"CreateEllipse",			scribus_newellipse,		METH_VARARGS},
	{"CreateImage",				scribus_newimage,			METH_VARARGS},
	{"CreateLine",				scribus_newline,			METH_VARARGS},
	{"CreatePolyLine",		scribus_polyline,			METH_VARARGS},
	{"CreatePolygon",			scribus_polygon,			METH_VARARGS},
	{"CreateBezierLine",	scribus_bezierline,		METH_VARARGS},
	{"CreatePathText",		scribus_pathtext,			METH_VARARGS},
	{"CreateText",				scribus_newtext,			METH_VARARGS},
	{"DeleteObject",			scribus_deleteobj,		METH_VARARGS},
	{"GetFillColor",			scribus_getfillcolor,	METH_VARARGS},
	{"GetLineColor",			scribus_getlinecolor,	METH_VARARGS},
	{"GetLineWidth",			scribus_getlinewidth,	METH_VARARGS},
	{"GetLineShade",			scribus_getlineshade,	METH_VARARGS},
	{"GetLineJoin",				scribus_getlinejoin,	METH_VARARGS},
	{"GetLineCap",				scribus_getlineend,		METH_VARARGS},
	{"GetLineStyle",			scribus_getlinestyle,	METH_VARARGS},
	{"GetFillShade",			scribus_getfillshade,	METH_VARARGS},
	{"GetCornerRadius",		scribus_getcornerrad,	METH_VARARGS},
	{"GetImageScale",			scribus_getimgscale,	METH_VARARGS},
	{"GetImageFile",			scribus_getimgname,		METH_VARARGS},
	{"GetPosition",				scribus_getposi,			METH_VARARGS},
	{"GetSize",						scribus_getsize,			METH_VARARGS},
	{"GetRotation",				scribus_getrotation,	METH_VARARGS},
	{"GetFontSize",				scribus_getfontsize,	METH_VARARGS},
	{"GetFont",						scribus_getfont,			METH_VARARGS},
	{"GetTextLength",			scribus_gettextsize,	METH_VARARGS},
	{"GetTextColor",			scribus_getlinecolor,	METH_VARARGS},
	{"GetTextShade",			scribus_getlineshade,	METH_VARARGS},
	{"GetLineSpacing",		scribus_getlinespace,	METH_VARARGS},
	{"GetText",						scribus_gettext,			METH_VARARGS},
	{"GetAllObjects",			scribus_getallobj,		METH_VARARGS},
	{"SetFillColor",			scribus_setfillcolor,	METH_VARARGS},
	{"SetLineColor",			scribus_setlinecolor,	METH_VARARGS},
	{"SetLineWidth",			scribus_setlinewidth,	METH_VARARGS},
	{"SetLineShade",			scribus_setlineshade,	METH_VARARGS},
	{"SetLineJoin",				scribus_setlinejoin,	METH_VARARGS},
	{"SetLineCap",				scribus_setlineend,		METH_VARARGS},
	{"SetLineStyle",			scribus_setlinestyle,	METH_VARARGS},
	{"SetFillShade",			scribus_setfillshade,	METH_VARARGS},
	{"SetCornerRadius",		scribus_setcornerrad,	METH_VARARGS},
	{"LoadImage",					scribus_loadimage,		METH_VARARGS},
	{"ScaleImage",				scribus_scaleimage,		METH_VARARGS},
	{"SetText",						scribus_setboxtext,		METH_VARARGS},
	{"InsertText",				scribus_inserttext,		METH_VARARGS},
	{"SelectText",				scribus_selecttext,		METH_VARARGS},
	{"DeleteText",				scribus_deletetext,		METH_VARARGS},
	{"SetFont",						scribus_setfont,			METH_VARARGS},
	{"SetFontSize",				scribus_setfontsize,	METH_VARARGS},
	{"SetTextColor",			scribus_setlinecolor,	METH_VARARGS},
	{"SetTextShade",			scribus_setlineshade,	METH_VARARGS},
	{"SetLineSpacing",		scribus_setlinespace,	METH_VARARGS},
	{"SetTextAlignment",	scribus_setalign,			METH_VARARGS},
	{"MoveObject",				scribus_moveobjrel,		METH_VARARGS},
	{"MoveObjectAbs",			scribus_moveobjabs,		METH_VARARGS},
	{"RotateObject",			scribus_rotobjrel,		METH_VARARGS},
	{"RotateObjectAbs",		scribus_rotobjabs,		METH_VARARGS},
	{"SizeObject",				scribus_sizeobjabs,		METH_VARARGS},
	{"GroupObjects",			scribus_groupobj,			METH_VARARGS},
	{"UnGroupObject",			scribus_ungroupobj,		METH_VARARGS},
	{"ScaleGroup",				scribus_scalegroup,		METH_VARARGS},
	{"GetSelectedObject",	scribus_getselobjnam,	METH_VARARGS},
	{"SelectionCount",		scribus_selcount,			METH_VARARGS},
	{"SelectObject",			scribus_selectobj,		METH_VARARGS},
	{"DeselectAll",				scribus_deselect,			METH_VARARGS},
	{"GetColorNames",			scribus_colornames,		METH_VARARGS},
	{"GetColor",					scribus_getcolor,			METH_VARARGS},
	{"ChangeColor",				scribus_setcolor,			METH_VARARGS},
	{"DefineColor",				scribus_newcolor,			METH_VARARGS},
	{"DeleteColor",				scribus_delcolor,			METH_VARARGS},
	{"ReplaceColor",			scribus_replcolor,		METH_VARARGS},
	{"GetFontNames",			scribus_fontnames,		METH_VARARGS},
	{"GetLayers",					scribus_getlayers,		METH_VARARGS},
	{"SetActiveLayer",		scribus_setactlayer,	METH_VARARGS},
	{"GetActiveLayer",		scribus_getactlayer,	METH_VARARGS},
	{"SentToLayer",				scribus_senttolayer,	METH_VARARGS},
	{"SetLayerVisible",		scribus_layervisible,	METH_VARARGS},
	{"SetLayerPrintable",	scribus_layerprint,		METH_VARARGS},
	{"IsLayerVisible",		scribus_glayervisib,	METH_VARARGS},
	{"IsLayerPrintable",	scribus_glayerprint,	METH_VARARGS},
	{"CreateLayer",				scribus_createlayer,	METH_VARARGS},
	{"DeleteLayer",				scribus_removelayer,	METH_VARARGS},
	{"retval",						scribus_retval,				METH_VARARGS},
	{"getval",						scribus_getval,				METH_VARARGS},
	{NULL,		NULL}		/* sentinel */
};

void initscribus(ScribusApp *pl)
{
	PyObject *m, *d;
	PyImport_AddModule("scribus");
	m = Py_InitModule("scribus", scribus_methods);
	d = PyModule_GetDict(m);
	PyDict_SetItemString(d, "Points", 					Py_BuildValue("i", 0));
	PyDict_SetItemString(d, "Millimeters", 			Py_BuildValue("i", 1));
	PyDict_SetItemString(d, "Inches", 					Py_BuildValue("i", 2));
	PyDict_SetItemString(d, "Picas", 						Py_BuildValue("i", 3));
	PyDict_SetItemString(d, "Portrait", 				Py_BuildValue("i", 0));
	PyDict_SetItemString(d, "Landscape", 				Py_BuildValue("i", 1));
	PyDict_SetItemString(d, "NoFacingPages", 		Py_BuildValue("i", 0));
	PyDict_SetItemString(d, "FacingPages", 			Py_BuildValue("i", 1));
	PyDict_SetItemString(d, "FirstPageRight", 	Py_BuildValue("i", 0));
	PyDict_SetItemString(d, "FirstPageLeft", 		Py_BuildValue("i", 1));
	PyDict_SetItemString(d, "LeftAlign",		 		Py_BuildValue("i", 0));
	PyDict_SetItemString(d, "RightAlign", 			Py_BuildValue("i", 2));
	PyDict_SetItemString(d, "Centered",				 	Py_BuildValue("i", 1));
	PyDict_SetItemString(d, "Forced",				 		Py_BuildValue("i", 3));
	PyDict_SetItemString(d, "SolidLine",		 		Py_BuildValue("i", Qt::SolidLine));
	PyDict_SetItemString(d, "DashLine",			 		Py_BuildValue("i", Qt::DashLine));
	PyDict_SetItemString(d, "DotLine",			 		Py_BuildValue("i", Qt::DotLine));
	PyDict_SetItemString(d, "DashDotLine",	 		Py_BuildValue("i", Qt::DashDotLine));
	PyDict_SetItemString(d, "DashDotDotLine",		Py_BuildValue("i", Qt::DashDotDotLine));
	PyDict_SetItemString(d, "MiterJoin",		 		Py_BuildValue("i", Qt::MiterJoin));
	PyDict_SetItemString(d, "BevelJoin",		 		Py_BuildValue("i", Qt::BevelJoin));
	PyDict_SetItemString(d, "RoundJoin",		 		Py_BuildValue("i", Qt::RoundJoin));
	PyDict_SetItemString(d, "FlatCap",			 		Py_BuildValue("i", Qt::FlatCap));
	PyDict_SetItemString(d, "SquareCap",		 		Py_BuildValue("i", Qt::SquareCap));
	PyDict_SetItemString(d, "RoundCap",			 		Py_BuildValue("i", Qt::RoundCap));
	PyDict_SetItemString(d, "Paper_A0", 				Py_BuildValue("(ff)", 2380.0, 3368.0));
	PyDict_SetItemString(d, "Paper_A1", 				Py_BuildValue("(ff)", 1684.0, 2380.0));
	PyDict_SetItemString(d, "Paper_A2", 				Py_BuildValue("(ff)", 1190.0, 1684.0));
	PyDict_SetItemString(d, "Paper_A3", 				Py_BuildValue("(ff)", 842.0, 1190.0));
	PyDict_SetItemString(d, "Paper_A4", 				Py_BuildValue("(ff)", 595.0, 842.0));
	PyDict_SetItemString(d, "Paper_A5", 				Py_BuildValue("(ff)", 421.0, 595.0));
	PyDict_SetItemString(d, "Paper_A6", 				Py_BuildValue("(ff)", 297.0, 421.0));
	PyDict_SetItemString(d, "Paper_A7", 				Py_BuildValue("(ff)", 210.0, 297.0));
	PyDict_SetItemString(d, "Paper_A8", 				Py_BuildValue("(ff)", 148.0, 210.0));
	PyDict_SetItemString(d, "Paper_A9", 				Py_BuildValue("(ff)", 105.0, 148.0));
	PyDict_SetItemString(d, "Paper_B0", 				Py_BuildValue("(ff)", 2836.0, 4008.0));
	PyDict_SetItemString(d, "Paper_B1", 				Py_BuildValue("(ff)", 2004.0, 2836.0));
	PyDict_SetItemString(d, "Paper_B2", 				Py_BuildValue("(ff)", 1418.0, 2004.0));
	PyDict_SetItemString(d, "Paper_B3", 				Py_BuildValue("(ff)", 1002.0, 1418.0));
	PyDict_SetItemString(d, "Paper_B4", 				Py_BuildValue("(ff)", 709.0, 1002.0));
	PyDict_SetItemString(d, "Paper_B5", 				Py_BuildValue("(ff)", 501.0, 709.0));
	PyDict_SetItemString(d, "Paper_B6", 				Py_BuildValue("(ff)", 355.0, 501.0));
	PyDict_SetItemString(d, "Paper_B7", 				Py_BuildValue("(ff)", 250.0, 355.0));
	PyDict_SetItemString(d, "Paper_B8", 				Py_BuildValue("(ff)", 178.0, 250.0));
	PyDict_SetItemString(d, "Paper_B9", 				Py_BuildValue("(ff)", 125.0, 178.0));
	PyDict_SetItemString(d, "Paper_B10", 				Py_BuildValue("(ff)", 89.0, 125.0));
	PyDict_SetItemString(d, "Paper_C5E", 				Py_BuildValue("(ff)", 462.0, 649.0));
	PyDict_SetItemString(d, "Paper_Comm10E", 		Py_BuildValue("(ff)", 298.0, 683.0));
	PyDict_SetItemString(d, "Paper_DLE", 				Py_BuildValue("(ff)", 312.0, 624.0));
	PyDict_SetItemString(d, "Paper_Executive",	Py_BuildValue("(ff)", 542.0, 720.0));
	PyDict_SetItemString(d, "Paper_Folio", 			Py_BuildValue("(ff)", 595.0, 935.0));
	PyDict_SetItemString(d, "Paper_Ledger", 		Py_BuildValue("(ff)", 1224.0, 792.0));
	PyDict_SetItemString(d, "Paper_Legal", 			Py_BuildValue("(ff)", 612.0, 1008.0));
	PyDict_SetItemString(d, "Paper_Letter", 		Py_BuildValue("(ff)", 612.0, 792.0));
	PyDict_SetItemString(d, "Paper_Tabloid", 		Py_BuildValue("(ff)", 792.0, 1224.0));
	Carrier = pl;
	doc = Carrier->doc;
}

