/***************************************************************************
                          util.cpp  -  description
                             -------------------
    begin                : Fri Sep 14 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstring.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qpainter.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qtextstream.h>
#include <qstringlist.h>
#include <qmap.h>
#include <qdom.h>
#include <qimage.h>
#include <qpointarray.h>
#include <cstdlib>
#include <cmath>
#include "md5.h"
#include "config.h"
#include "scribusdoc.h"
#ifdef HAVE_LIBZ
	#include <zlib.h>
#endif
#ifdef HAVE_TIFF
	#include <tiffio.h>
#endif
#ifdef HAVE_CMS
	#include <lcms.h>
extern cmsHPROFILE CMSoutputProf;
extern cmsHPROFILE CMSprinterProf;
extern cmsHTRANSFORM stdTrans;
extern cmsHTRANSFORM stdProof;
extern cmsHTRANSFORM stdTransImg;
extern cmsHTRANSFORM stdProofImg;
extern bool SoftProofing;
extern bool Gamut;
extern bool CMSuse;
extern int IntentMonitor;
extern int IntentPrinter;
#endif
extern ProfilesL InputProfiles;

QByteArray ComputeMD5Sum(QByteArray *in);
char *toHex( uchar u );
QString String2Hex(QString *in, bool lang = true);
QString CompressStr(QString *in);
QString ImageToTxt(QImage *im);
QString ImageToCMYK(QImage *im);
QString ImageToCMYK_PS(QImage *im, int pl);
QString MaskToTxt(QImage *im, bool PDF = true);
void Level2Layer(ScribusDoc *doc, struct Layer *ll, int Level);
void BezierPoints(QPointArray *ar, QPoint n1, QPoint n2, QPoint n3, QPoint n4);
float xy2Deg(float x, float y);
QPointArray FlattenPath(FPointArray ina);
QPointArray RegularPolygon(float w, float h, uint c, bool star, float factor, float rota);
FPointArray RegularPolygonF(float w, float h, uint c, bool star, float factor, float rota);
QPixmap loadIcon(QString nam);
bool loadText(QString nam, QString *Buffer);
bool loadTextQS(QString nam, QString *Buffer);
float Cwidth(ScribusDoc *doc, QPainter *p, QString name, QString ch, int Siz);
float QStoFloat(QString in);
int QStoInt(QString in);
QString GetAttr(QDomElement *el, QString at, QString def="0");
QImage LoadPict(QString fn);
#ifdef HAVE_CMS
QImage ProofPict(QImage *Im, QString Prof, int Rend, cmsHPROFILE emPr=0);
#else
QImage ProofPict(QImage *Im, QString Prof, int Rend);
#endif
QImage ProofImage(QImage *Im);

#ifdef HAVE_CMS
QImage ProofPict(QImage *Im, QString Prof, int Rend, cmsHPROFILE emPr)
#else
QImage ProofPict(QImage *Im, QString Prof, int Rend)
#endif
{
	bool emp = false;
	if (Prof == "")
		return Im->copy();
#ifdef HAVE_CMS
	QImage out = Im->copy();
	if ((CMSuse) && (SoftProofing))
		{
		cmsHTRANSFORM xform;
		cmsHPROFILE inputProf;
  	if (emPr != 0)
  		inputProf = emPr;
  	else
			{
  		inputProf = cmsOpenProfileFromFile(InputProfiles[Prof], "r");
			emp = true;
			}
		int dcmsFlags = 0;
		if (Gamut)
			dcmsFlags |= cmsFLAGS_GAMUTCHECK;
		else
			dcmsFlags |= cmsFLAGS_SOFTPROOFING;
		xform = cmsCreateProofingTransform(inputProf, TYPE_RGBA_8,
															 				 CMSoutputProf, TYPE_RGBA_8,
															 				 CMSprinterProf,
															 				 IntentPrinter,
															 				 Rend, dcmsFlags);
		for (int i=0; i < out.height(); ++i)
			{
			LPBYTE ptr = out.scanLine(i);
			cmsDoTransform(xform, ptr, ptr, out.width());
			}
		cmsDeleteTransform(xform);
		if (emp)
			cmsCloseProfile(inputProf);
		}
	else
		{
		if (CMSuse)
			{
			cmsHTRANSFORM xform;
			cmsHPROFILE inputProf;
  		if (emPr != 0)
  			inputProf = emPr;
  		else
				{
  			inputProf = cmsOpenProfileFromFile(InputProfiles[Prof], "r");
				emp = true;
				}
			xform = cmsCreateTransform(inputProf, TYPE_RGBA_8,
															 	 CMSoutputProf, TYPE_RGBA_8,
															 	 Rend,
															 	 0);
			for (int i=0; i < out.height(); ++i)
				{
				LPBYTE ptr = out.scanLine(i);
				cmsDoTransform(xform, ptr, ptr, out.width());
				}
			cmsDeleteTransform(xform);
			if (emp)
				cmsCloseProfile(inputProf);
			}
		}
	return out;
#else
	return Im->copy();
#endif
}

QImage ProofImage(QImage *Im)
{
#ifdef HAVE_CMS
	QImage out = Im->copy();
	if ((CMSuse) && (SoftProofing))
		{
		for (int i=0; i < out.height(); ++i)
			{
			LPBYTE ptr = out.scanLine(i);
			cmsDoTransform(stdProofImg, ptr, ptr, out.width());
			}
		}
	else
		{
		if (CMSuse)
			{
			for (int i=0; i < out.height(); ++i)
				{
				LPBYTE ptr = out.scanLine(i);
				cmsDoTransform(stdTransImg, ptr, ptr, out.width());
				}
			}
		}
	return out;
#else
	return Im->copy();
#endif
}

QImage LoadPict(QString fn)
{
	QString tmp, dummy, cmd1, cmd2, BBox;
	QChar tc;
	QImage Bild;
	float x, y, b, h;
	bool found = false;
	int ret = -1;
	QFileInfo fi = QFileInfo(fn);
	QString ext = fi.extension(false).lower();
	if ((ext == "eps") || (ext == "ps"))
		{
		QFile f(fn);
		if (f.open(IO_ReadOnly))
			{
			QTextStream ts(&f);
			while (!ts.atEnd())
				{
				tc = ' ';
				tmp = "";
				while ((tc != '\n') && (tc != '\r'))
					{
					ts >> tc;
					if ((tc != '\n') && (tc != '\r'))
						tmp += tc;
					}
				if (tmp.startsWith("%%BoundingBox"))
					{
					found = true;
					BBox = tmp;
					}
				if (tmp.startsWith("%%EndComments"))
					break;
				}	
			f.close();
			if (found)
				{
				QTextStream ts2(&BBox, IO_ReadOnly);
				ts2 >> dummy >> x >> y >> b >> h;
				cmd1 = "gs -q -dNOPAUSE -sDEVICE=png16m -r72 -sOutputFile=/tmp/sc.png -g";
				cmd2 = " -c showpage -c quit";
				ret = system(cmd1 + tmp.setNum(qRound(b)) + "x" + tmp.setNum(qRound(h)) + " " + fn + cmd2);
				if (ret == 0)
					{
					QImage im4;
					QImage image;
					image.load("/tmp/sc.png");
  				image = image.convertDepth(32);
					int wi = image.width();
					int hi = image.height();
					QBitmap bm("/tmp/sc.png");
					bm.fill(Qt::color1);
    			QPainter pp;
    			pp.begin(&bm);
    			pp.setPen(Qt::color0);
    			QString tmp2;
    			if ( image.depth() == 8 )
						{
        		for( int yi=0; yi < hi; ++yi )
							{
            	uchar * s = image.scanLine( yi );
            	for( int xi=0; xi < wi; ++xi )
								{
                if(image.color(s[xi]) == 0xffffffff)
                	pp.drawPoint(xi, yi);
            		}
        			}
    				}
					else
						{
        		for( int yi=0; yi < hi; ++yi )
							{
            	QRgb * s = (QRgb*)(image.scanLine( yi ));
              for(int xi=0; xi < wi; ++xi )
								{
                if((*s++) == 0xffffffff)
                	pp.drawPoint(xi, yi);
                }
        			}
    				}
    			pp.end();
					QPixmap pm;
					pm.convertFromImage(image);
					pm.setMask(bm);
					im4.setAlphaBuffer(true);
					im4 = pm.convertToImage();
					Bild = im4.copy(static_cast<int>(x), 0, static_cast<int>(b-x), static_cast<int>(h-y));
					system("rm -f /tmp/sc.png");
					}
				}
			}
		}
#ifdef HAVE_TIFF
	if (ext == "tif")
		{
		QImage img;
		QImage inI2;
		TIFF* tif = TIFFOpen(fn, "r");
		if(tif)
			{
			unsigned width, height,size;
			TIFFGetField(tif, TIFFTAG_IMAGEWIDTH, &width);
			TIFFGetField(tif, TIFFTAG_IMAGELENGTH, &height);
			size=width*height;
			uint32 *bits=(uint32*) _TIFFmalloc(size * sizeof (uint32));
			if(bits)
				{
				if (TIFFReadRGBAImage(tif, width, height, bits, 0))
					{
        	img.create(width,height,32);
					if(TIFFGetR(0x1234567)==qRed  (0x1234567) &&
						 TIFFGetG(0x1234567)==qGreen(0x1234567) &&
						 TIFFGetB(0x1234567)==qBlue (0x1234567))
						{
						for(unsigned y=0; y<height; ++y)
							memcpy(img.scanLine(height-1-y),bits+y*width,width*4);
						}
					else
						{
						uint32 *inp=bits;
						for(unsigned y=0; y<height; ++y)
							{
							QRgb *row=(QRgb*) (img.scanLine(height-1-y));
							for(unsigned x=0; x<width; ++x)
								{
								const uint32 col=*(inp++);
								row[x]=qRgb(TIFFGetR(col), TIFFGetG(col), TIFFGetB(col) ) | (TIFFGetA(col)<<24);
								}
							}
						}
					Bild = img.copy();
					}
				_TIFFfree(bits);
				}
			TIFFClose(tif);
			}
		}
#endif
	else
		{
		Bild.load(fn);
  	Bild = Bild.convertDepth(32);
		}
	return Bild;
}

QString GetAttr(QDomElement *el, QString at, QString def)
{
	return el->attribute(at, def);
}

int QStoInt(QString in)
{
	bool ok = false;
	int c = in.toInt(&ok);
	if (ok)
		return c;
	else
		return 0;
}

float QStoFloat(QString in)
{
	bool ok = false;
	float c = in.toFloat(&ok);
	if (ok)
		return c;
	else
		return 0.0;
}

QPixmap loadIcon(QString nam)
{
  QString pfad = PREL;
  pfad += "/lib/scribus/icons/"+nam;
	QPixmap pm;
	pm.load(pfad);
	return pm;
}

bool loadText(QString nam, QString *Buffer)
{
	QFile f(nam);
	QFileInfo fi(f);
	if (!fi.exists())
		return false;
	uint posi;
	bool ret = false;
	QByteArray bb(f.size());
	if (f.open(IO_ReadOnly))
		{
		f.readBlock(bb.data(), f.size());
		f.close();
		for (posi = 0; posi < bb.size(); ++posi)
			{
			*Buffer += bb[posi];
			}
		ret = true;
		}
	else
		{
		ret = false;
		}
	return ret;
}

bool loadTextQS(QString nam, QString *Buffer)
{
	QFile f(nam);
	QFileInfo fi(f);
	if (!fi.exists())
		return false;
	bool ret = false;
	if (f.open(IO_ReadOnly))
		{
		QTextStream t(&f);
		t.setEncoding(QTextStream::Locale);
		*Buffer = t.read();
		f.close();
		ret = true;
		}
	else
		{
		ret = false;
		}
	return ret;
}

float Cwidth(ScribusDoc *doc, QPainter *p, QString name, QString ch, int Siz)
{
	if ((*doc->AllFonts)[name]->HasMetrics)
		return (*doc->AllFonts)[name]->CharWidth[QMIN(ch.at(0).unicode(),255)]*Siz;
	else
		return p->fontMetrics().width(ch);
}

QPointArray RegularPolygon(float w, float h, uint c, bool star, float factor, float rota)
{
	uint cx;
	if (star)
		cx = c * 2;
	else
		cx = c;
	float seg = 360.0 / cx;
	float sc = rota + 180.0;
	float di = factor;
	int mx = 0;
	int my = 0;
	QPointArray pts = QPointArray();
	for (uint x = 0; x < cx; ++x)
		{
		sc = seg * x + 180.0 + rota;
		if (star)
			{
			if (x % 2 == 0)
				{
				mx = qRound(sin(sc / 180 * M_PI) * (w/2) + (w/2));
				my = qRound(cos(sc / 180 * M_PI) * (h/2) + (h/2));
				}
			else
				{
				mx = qRound(sin(sc / 180 * M_PI) * (w/2*di) + (w/2));
				my = qRound(cos(sc / 180 * M_PI) * (h/2*di) + (h/2));
				}
			}
		else
			{
			mx = qRound(sin(sc / 180 * M_PI) * (w/2) + (w/2));
			my = qRound(cos(sc / 180 * M_PI) * (h/2) + (h/2));
			}
		pts.resize(x+1);
		pts.setPoint(x, mx, my);
		}
	return pts;
}

FPointArray RegularPolygonF(float w, float h, uint c, bool star, float factor, float rota)
{
	uint cx;
	if (star)
		cx = c * 2;
	else
		cx = c;
	float seg = 360.0 / cx;
	float sc = rota + 180.0;
	float di = factor;
	float mx = 0;
	float my = 0;
	FPointArray pts = FPointArray();
	for (uint x = 0; x < cx; ++x)
		{
		sc = seg * x + 180.0 + rota;
		if (star)
			{
			if (x % 2 == 0)
				{
				mx = sin(sc / 180 * M_PI) * (w/2) + (w/2);
				my = cos(sc / 180 * M_PI) * (h/2) + (h/2);
				}
			else
				{
				mx = sin(sc / 180 * M_PI) * (w/2*di) + (w/2);
				my = cos(sc / 180 * M_PI) * (h/2*di) + (h/2);
				}
			}
		else
			{
			mx = sin(sc / 180 * M_PI) * (w/2) + (w/2);
			my = cos(sc / 180 * M_PI) * (h/2) + (h/2);
			}
		pts.resize(x+1);
		pts.setPoint(x, mx, my);
		}
	return pts;
}

QPointArray FlattenPath(FPointArray ina)
{
	QPointArray Bez(4);
	QPointArray outa, cli;
	if (ina.size() > 3)
		{
		for (uint poi=0; poi<ina.size()-3; poi += 4)
			{
			BezierPoints(&Bez, ina.pointQ(poi), ina.pointQ(poi+1), ina.pointQ(poi+3), ina.pointQ(poi+2));
			cli = Bez.cubicBezier();
			outa.putPoints(outa.size(), cli.size()-1, cli);
			}
		outa.resize(outa.size()+1);
		outa.setPoint(outa.size()-1, cli.point(cli.size()-1));
		}
	return outa;
}

float xy2Deg(float x, float y)
{
	return (atan2(y,x)*(180.0/M_PI));
}

void BezierPoints(QPointArray *ar, QPoint n1, QPoint n2, QPoint n3, QPoint n4)
{
	ar->setPoint(0, n1);
	ar->setPoint(1, n2);
	ar->setPoint(2, n3);
	ar->setPoint(3, n4);
	return;
}

void Level2Layer(ScribusDoc *doc, struct Layer *ll, int Level)
{
	for (uint la2 = 0; la2 < doc->Layers.count(); ++la2)
		{
		if (doc->Layers[la2].Level == Level)
			{
			ll->Sichtbar = doc->Layers[la2].Sichtbar;
			ll->Drucken = doc->Layers[la2].Drucken;
			ll->LNr = doc->Layers[la2].LNr;
			break;
			}
		}
}

QString ImageToTxt(QImage *im)
{
	int h = im->height();
	int w = im->width();
	QString ImgStr = "";
	for( int yi=0; yi < h; ++yi )
		{
		QRgb * s = (QRgb*)(im->scanLine( yi ));
		for( int xi=0; xi < w; ++xi )
			{
			QRgb r=*s++;
			unsigned char u=qRed(r);
			ImgStr += u;
			u=qGreen(r);
			ImgStr += u;
			u=qBlue(r);
			ImgStr += u;
			}
		}
	return ImgStr;
}

QString ImageToCMYK(QImage *im)
{
	int h = im->height();
	int w = im->width();
	QString ImgStr = "";
	for( int yi=0; yi < h; ++yi )
		{
		QRgb * s = (QRgb*)(im->scanLine( yi ));
		for( int xi=0; xi < w; ++xi )
			{
			QRgb r=*s++;
			int c = 255 - qRed(r);
			int m = 255 - qGreen(r);
			int y = 255 - qBlue(r);
			int k = QMIN(QMIN(c, m), y);
			ImgStr += c - k;
			ImgStr += m - k;
			ImgStr += y - k;
			ImgStr += k;
			}
		}
	return ImgStr;
}

QString ImageToCMYK_PS(QImage *im, int pl)
{
	int h = im->height();
	int w = im->width();
	QString ImgStr = "";
	for( int yi=0; yi < h; ++yi )
		{
		QRgb * s = (QRgb*)(im->scanLine( yi ));
		for( int xi=0; xi < w; ++xi )
			{
			QRgb r=*s++;
			int c = 255 - qRed(r);
			int m = 255 - qGreen(r);
			int y = 255 - qBlue(r);
			int k = QMIN(QMIN(c, m), y);
			if (pl == -1)
				{
				ImgStr += c - k;
				ImgStr += m - k;
				ImgStr += y - k;
				ImgStr += k;
				}
			else
				{
				if (pl == 1)
					ImgStr += c - k;
				if (pl == 2)
					ImgStr += m - k;
				if (pl == 3)
					ImgStr += y - k;
				if (pl == 0)
					ImgStr += k;
				}
			}
		}
	return ImgStr;
}

QString MaskToTxt(QImage *im, bool PDF)
{
	int h = im->height();
	int w = im->width();
  int w2;
  w2 = w / 8;
  if ((w % 8) != 0)
  	w2++;
	QString ImgStr = "";
	for( int yi=0; yi < h; ++yi )
		{
		uchar * s = im->scanLine( yi );
		for( int xi=0; xi < w2; ++xi )
			{
			unsigned char u = *(s+xi);
			if (PDF)
				ImgStr += ~u;
			else
				ImgStr += u;
			}
		}
	return ImgStr;
}

QString CompressStr(QString *in)
{
	QString out = "";
#ifdef HAVE_LIBZ
	QByteArray bb(in->length());
	for (uint ax = 0; ax < in->length(); ++ax)
		{
		bb[ax] = uchar(QChar(in->at(ax)));
		}
	uLong exlen = uint(bb.size() * 0.001 + 16) + bb.size();
	QByteArray bc(exlen);
	compress2((Byte *)bc.data(), &exlen, (Byte *)bb.data(), uLong(bb.size()), 9);
	for (uint cl = 0; cl < exlen; ++cl)
		{
		out += bc[cl];
		}
#else
	out = *in;
#endif
	return out;
}

char *toHex( uchar u )
{
    static char hexVal[3];
    int i = 1;
    while ( i >= 0 )
			{
			ushort hex = (u & 0x000f);
			if ( hex < 0x0a )
	    	hexVal[i] = '0'+hex;
			else
	    	hexVal[i] = 'A'+(hex-0x0a);
			u = u >> 4;
			i--;
    	}
    hexVal[2] = '\0';
    return hexVal;
}

QString String2Hex(QString *in, bool lang)
{
	int i = 0;
	QString out = "";
	for( uint xi = 0; xi < in->length(); ++xi )
		{
		out += toHex(uchar(QChar(in->at(xi))));
		++i;
		if ((i>40) && (lang))
			{
			out += '\n';
			i=0;
			}
		}
	return out;
}

QByteArray ComputeMD5Sum(QByteArray *in)
{
	QByteArray MDsum(16);
	md5_buffer (in->data(), in->size(), (void*)MDsum.data());
	return MDsum;
}
