#include "charselect.h"
#include "charselect.moc"
#include <qtextcodec.h>
 
QString Name()
{
  return "Insert Special";
}

int Type()
{
	return 1;
}

void Run(QWidget *d, ScribusApp *plug)
{
	if ((plug->HaveDoc) && (plug->doc->ActPage->SelItem.count() != 0))
		{
		PageItem *b = plug->doc->ActPage->SelItem.at(0);
		if ((b->PType == 4) && (plug->doc->AppMode == 7))
			{
  		ZAuswahl *dia = new ZAuswahl(d, &plug->Prefs, b, plug);
  		dia->exec();
  		delete dia;
  		}
  	}
}
 
ZAuswahl::ZAuswahl( QWidget* parent, preV *Vor, PageItem *item, ScribusApp *pl)
    : QDialog( parent, "ZAuswahl", true, 0 )
{
    setCaption( tr( "Select Character" ) );
    ite = item;
    ap = pl;
//  	setIcon(ap->view->loadIcon("AppIcon.xpm"));
    ZAuswahlLayout = new QVBoxLayout( this );
    ZAuswahlLayout->setSpacing( 6 );
    ZAuswahlLayout->setMargin( 11 );

    ZTabelle = new QTable( this, "ZTabelle" );
    ZTabelle->setNumRows( 7 );
    ZTabelle->setNumCols( 32 );
    ZTabelle->setLeftMargin(0);
    ZTabelle->verticalHeader()->hide();
    ZTabelle->setTopMargin(0);
    ZTabelle->horizontalHeader()->hide();
    ZTabelle->setSorting(false);
    ZTabelle->setSelectionMode(QTable::NoSelection);
    ZTabelle->setColumnMovingEnabled(false);
    ZTabelle->setRowMovingEnabled(false);
    QFont rr;
    rr = Vor->AvailFonts[ite->IFont]->Font;
    rr.setPointSize(12);
    ZTabelle->setFont(rr);
    QByteArray c = QByteArray(1);
    c[0] = 32;
    uint cc = 32;
    for (int a = 0; a < 7; a++)
      {
      for (int b = 0; b < 32; b++)
        {
				QTableItem *it = new QTableItem(ZTabelle, QTableItem::Never, QTextCodec::codecForLocale()->toUnicode(c));
				ZTabelle->setItem(a, b, it);
        cc++;
        c[0] = cc;
        }
      }
    for (int d = 0; d < 32; d++)
      {
			ZTabelle->setColumnWidth(d, ZTabelle->rowHeight(0));
      }
    ZTabelle->setMinimumSize(QSize(ZTabelle->rowHeight(0)*32, ZTabelle->rowHeight(0)*7));
    ZAuswahlLayout->addWidget( ZTabelle );

    Zeichen = new QLineEdit( this, "Zeichen" );
    Zeichen->setFont(rr);
    ZAuswahlLayout->addWidget( Zeichen );

    Layout1 = new QHBoxLayout;
    Layout1->setSpacing( 6 );
    Layout1->setMargin( 0 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer );

    Einf = new QPushButton( this, "Einf" );
    Einf->setText( tr( "Insert" ) );
    Layout1->addWidget( Einf );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer_2 );

    Delete = new QPushButton( this, "Delete" );
    Delete->setText( tr( "Clear" ) );
    Layout1->addWidget( Delete );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer_3 );

    Close = new QPushButton( this, "Close" );
    Close->setText( tr( "Close" ) );
    Layout1->addWidget( Close );
    QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer_4 );
    ZAuswahlLayout->addLayout( Layout1 );

    // signals and slots connections
    connect(Close, SIGNAL(clicked()), this, SLOT(accept()));
    connect(Delete, SIGNAL(clicked()), this, SLOT(DelEdit()));
    connect(Einf, SIGNAL(clicked()), this, SLOT(InsChar()));
    connect(ZTabelle, SIGNAL(pressed(int, int, int, const QPoint&)), this, SLOT(NeuesZeichen(int, int)));
}

ZAuswahl::~ZAuswahl()
{
}

void ZAuswahl::NeuesZeichen(int r, int c)
{
  Zeichen->insert(ZTabelle->text(r, c));
}

void ZAuswahl::DelEdit()
{
	Zeichen->clear();
}

void ZAuswahl::InsChar()
{
	struct Pti *hg;
	QString Tex = Zeichen->text();
	for (uint a=0; a<Tex.length(); a++)
		{
		hg = new Pti;
		hg->ch = Tex.at(a);
		if (hg->ch == QChar(10)) { hg->ch = QChar(13); }
		if (hg->ch == QChar(9)) { hg->ch = " "; }
		hg->cfont = ite->IFont;
		hg->csize = ite->ISize;
		hg->ccolor = ite->Pcolor2;
		hg->cextra = 0;
		hg->cshade = ite->Shade2;
		hg->cselect = false;
		hg->cstyle = 0;
		hg->cab = 0;
		hg->xp = 0;
		hg->yp = 0;
		hg->PRot = 0;
		hg->PtransX = 0;
		hg->PtransY = 0;
		ite->Ptext.insert(ite->CPos, hg);
 		ite->CPos += 1;
		}
	ite->Dirty = true;
	ite->paintObj();
	ap->slotDocCh();
}
