#include "mpalette.h"
#include "mpalette.moc"
#include <qmainwindow.h>
#include <math.h>
#include <qpoint.h>
#include <qwmatrix.h>
// #include <iostream.h>
extern QPixmap loadIcon(QString nam);
extern float UmReFaktor;

Mpalette::Mpalette(QWidget* parent, QPopupMenu* FontMenu)
        : QDockWindow( InDock, parent, "Mfloat", WStyle_Customize | WStyle_DialogBorder)
{
    setCaption( tr( "Measurements" ) );
    HaveDoc = false;
    HaveItem = false;
		Umrech = UmReFaktor;
 		setOrientation(Vertical);
  	QMainWindow* pa = (QMainWindow*)parent;
  	pa->moveDockWindow(this, DockLeft);
    setIcon( loadIcon("AppIcon.xpm") );

    TabWidget3 = new QTabWidget( this, "TabWidget3" );
    TabWidget3->setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding));
    tab = new QWidget( TabWidget3, "tab" );
    tabLayout = new QGridLayout( tab, 7, 2, 10, 5, "tabLayout");
    Text1 = new QLabel( tab, "Text1" );
    Text1->setText( tr( "X-Pos:" ) );
    Text2 = new QLabel( tab, "Text2" );
    Text2->setText( tr( "Y-Pos:" ) );
    Text3 = new QLabel( tab, "Text3" );
    Text3->setText( tr( "Width:" ) );
    Text4 = new QLabel( tab, "Text4" );
    Text4->setText( tr( "Height:" ) );
    Text5 = new QLabel( tab, "Text5" );
    Text5->setText( tr( "Angle:" ) );
    Text5_2 = new QLabel( tab, "Text5_2" );
    Text5_2->setText( tr( "Corner Radius:" ) );

    Xpos = new MSpinBox( tab, 2 );
    Xpos->setSuffix( tr( " pt" ) );
    Ypos = new MSpinBox( tab, 2 );
    Ypos->setSuffix( tr( " pt" ) );
    Width = new MSpinBox( tab, 2 );
    Width->setSuffix( tr( " pt" ) );
    Height = new MSpinBox( tab, 2 );
    Height->setSuffix( tr( " pt" ) );
    Rot = new MSpinBox( tab, 2 );
    Rot->setSuffix( tr( " " ) );
    Rot->setWrapping( TRUE );
    RoundRect = new QSpinBox( tab, "Corner" );
    RoundRect->setSuffix( tr( " pt" ) );
		LineMode = new QComboBox(true, tab, "lmo");
		LineMode->setEditable(false);
		LineMode->insertItem(tr("Left Point"));
		LineMode->insertItem(tr("Endpoints"));
		LMode = false;
/*		ScaleGr = new QCheckBox( tab, "sg");
    ScaleGr->setText( tr( "Scale proportional" ) );  */
    QSpacerItem* spacer = new QSpacerItem( 0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding );
		tabLayout->addMultiCellWidget(LineMode, 0, 0, 0, 1);
    tabLayout->addWidget( Text1, 1, 0 );
    tabLayout->addWidget( Xpos, 1, 1);
    tabLayout->addWidget( Text2, 2, 0 );
    tabLayout->addWidget( Ypos, 2, 1);
    tabLayout->addWidget( Text3, 3, 0 );
    tabLayout->addWidget( Width, 3, 1);
    tabLayout->addWidget( Text4, 4, 0 );
    tabLayout->addWidget( Height, 4, 1);
    tabLayout->addWidget( Text5, 5, 0 );
    tabLayout->addWidget( Rot, 5, 1);
    tabLayout->addWidget( Text5_2, 6, 0 );
    tabLayout->addWidget( RoundRect, 6, 1);
//		tabLayout->addMultiCellWidget( ScaleGr, 7, 7, 0, 1);
    tabLayout->addItem( spacer, 8, 0 );
    TabWidget3->insertTab( tab, tr( "Position" ) );			
		LineMode->hide();
//		ScaleGr->hide();

    tab_2 = new QWidget( TabWidget3, "tab_2" );
    tabLayout_2 = new QVBoxLayout( tab_2, 10, 5, "tabLayout_2");
    Fram = new QWidgetStack(tab_2);
    tabLayout_2->addWidget( Fram );
    GroupBox5 = new QButtonGroup( this, "GroupBox5" );
    GroupBox5->setExclusive( FALSE );
    GroupBox5->setRadioButtonExclusive(true);
    GroupBox5->setFrameShape( QGroupBox::NoFrame );
    GroupBox5->setFrameShadow( QGroupBox::Plain );
    GroupBox5->setTitle( tr( "" ) );
    GroupBox5->setAlignment( int( QGroupBox::AlignLeft ) );
    GroupBox5->setColumnLayout(0, Qt::Vertical );
    GroupBox5->layout()->setSpacing( 5 );
    GroupBox5->layout()->setMargin( 0 );
    GroupBox5Layout = new QVBoxLayout( GroupBox5->layout() );
    GroupBox5Layout->setAlignment( Qt::AlignTop );
    FreeScale = new QRadioButton( GroupBox5, "FreeScale" );
    FreeScale->setText( tr( "Free Scaling" ) );
    GroupBox5Layout->addWidget( FreeScale );
    GroupBox4 = new QGroupBox( GroupBox5, "GroupBox4" );
    GroupBox4->setTitle( tr( "Scaling" ) );
    GroupBox4->setColumnLayout(0, Qt::Vertical );
    GroupBox4->layout()->setSpacing( 5 );
    GroupBox4->layout()->setMargin( 10 );
    GroupBox4Layout = new QGridLayout( GroupBox4->layout() );
    GroupBox4Layout->setAlignment( Qt::AlignTop );
    Text10 = new QLabel( GroupBox4, "Text15" );
    Text10->setText( tr( "X-Pos:" ) );
    GroupBox4Layout->addWidget( Text10, 0, 0 );
    Text11 = new QLabel( GroupBox4, "Text11" );
    Text11->setText( tr( "Y-Pos:" ) );
    GroupBox4Layout->addWidget( Text11, 1, 0 );
    Text12 = new QLabel( GroupBox4, "Text12" );
    Text12->setText( tr( "X-Dir:" ) );
    GroupBox4Layout->addWidget( Text12, 2, 0);
    Text13 = new QLabel( GroupBox4, "Text13" );
    Text13->setText( tr( "Y-Dir:" ) );
    GroupBox4Layout->addWidget( Text13, 3, 0 );
    LXpos = new MSpinBox( GroupBox4, 2 );
    LXpos->setSuffix( tr( " pt" ) );
    GroupBox4Layout->addWidget( LXpos, 0, 1);
    LYpos = new MSpinBox( GroupBox4, 2 );
    LYpos->setSuffix( tr( " pt" ) );
    GroupBox4Layout->addWidget( LYpos, 1, 1);
    ScaleX = new MSpinBox( GroupBox4, 1);
    ScaleX->setSuffix( tr( " %" ) );
    GroupBox4Layout->addWidget( ScaleX, 2, 1);
    ScaleY = new MSpinBox( GroupBox4, 1 );
    ScaleY->setSuffix( tr( " %" ) );
    GroupBox4Layout->addWidget( ScaleY, 3, 1);
    Kette = new LinkButton( GroupBox4 );
    Kette->setToggleButton( TRUE );
    Kette->setAutoRaise( TRUE );
    Kette->setMaximumSize( QSize( 15, 32767 ) );
    GroupBox4Layout->addMultiCellWidget( Kette, 2, 3, 2, 2 );
    GroupBox5Layout->addWidget( GroupBox4 );
    FrameScale = new QRadioButton( GroupBox5, "FrameScale" );
    FrameScale->setText( tr( "Scale Picture to Frame Size" ) );
    GroupBox5Layout->addWidget( FrameScale );
    ScaleLayout3 = new QHBoxLayout( 0, 0, 5, "ScaleLayout3");
    QSpacerItem* spacerSC2 = new QSpacerItem( 20, 20, QSizePolicy::Fixed, QSizePolicy::Minimum );
    ScaleLayout3->addItem( spacerSC2 );
    Aspect = new QCheckBox( GroupBox5, "Aspect" );
    Aspect->setText( tr( "Keep Aspect Ratio" ) );
    ScaleLayout3->addWidget( Aspect );
    GroupBox5Layout->addLayout( ScaleLayout3 );

    Layout14_2 = new QHBoxLayout( 0, 0, 5, "Layout14_2");
    FlipH2 = new QToolButton( GroupBox5, "FlipH2" );
    FlipH2->setPixmap( loadIcon("FlipH.xpm") );
    Layout14_2->addWidget( FlipH2 );
    FlipV2 = new QToolButton( GroupBox5, "FlipV2" );
    FlipV2->setPixmap( loadIcon("FlipV.xpm") );
    Layout14_2->addWidget( FlipV2 );
    QSpacerItem* spacer_5 = new QSpacerItem( 0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout14_2->addItem( spacer_5 );
    GroupBox5Layout->addLayout( Layout14_2 );
    Fram->addWidget(GroupBox5, 1);

    Frame8 = new QFrame( this, "Frame8" );
    Frame8->setFrameShape( QFrame::NoFrame );
    Frame8->setFrameShadow( QFrame::Plain );
    Frame8Layout = new QGridLayout( Frame8, 1, 1, 0, 5, "Frame7Layout");
    Text15 = new QLabel( Frame8, "Text15" );
    Text15->setText( tr( "Linestyle:" ) );
    Frame8Layout->addMultiCellWidget( Text15, 0, 0, 0, 1 );
    LStyle = new LineCombo(Frame8);
    Frame8Layout->addMultiCellWidget( LStyle, 1, 1, 0, 1 );
    Text16 = new QLabel( Frame8, "Text16" );
    Text16->setText( tr( "Linewidth:" ) );
    Frame8Layout->addWidget( Text16, 2, 0 );
    LSize = new MSpinBox( Frame8, 1 );
    LSize->setSuffix( tr( " pt" ) );
		LSize->setLineStep(10);
    Frame8Layout->addWidget( LSize, 2, 1 );

    Text20 = new QLabel( Frame8, "Text15" );
    Text20->setText( tr( "Edges:" ) );
    Frame8Layout->addMultiCellWidget( Text20, 3, 3, 0, 1 );
    LJoinStyle = new QComboBox( true, Frame8, "LJ" );
    LJoinStyle->setEditable(false);
    LJoinStyle->insertItem(loadIcon("MiterJoin.png"), " " + tr( "MiterJoin" ) );
    LJoinStyle->insertItem(loadIcon("BevelJoin.png"), " " + tr( "BevelJoin" ) );
    LJoinStyle->insertItem(loadIcon("RoundJoin.png"), " " + tr( "RoundJoin" ) );
    Frame8Layout->addMultiCellWidget( LJoinStyle, 4, 4, 0, 1 );
    Text21 = new QLabel( Frame8, "Text16" );
    Text21->setText( tr( "Endings:" ) );
    Frame8Layout->addMultiCellWidget( Text21, 5, 5, 0, 1 );
    LEndStyle = new QComboBox( true, Frame8, "Le" );
    LEndStyle->setEditable(false);
    LEndStyle->insertItem(loadIcon("ButtCap.png"), " " + tr( "FlatCap" ) );
    LEndStyle->insertItem(loadIcon("SquareCap.png"), " " + tr( "SquareCap" ) );
    LEndStyle->insertItem(loadIcon("RoundCap.png"), " " + tr( "RoundCap" ) );
    Frame8Layout->addMultiCellWidget( LEndStyle, 6, 6, 0, 1 );
    QSpacerItem* spacer8 = new QSpacerItem( 0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding );
    Frame8Layout->addItem( spacer8 );
    Fram->addWidget(Frame8, 2);

    Frame7 = new QFrame( this, "Frame7" );
    Frame7->setFrameShape( QFrame::NoFrame );
    Frame7->setFrameShadow( QFrame::Plain );
    Frame7Layout = new QVBoxLayout( Frame7, 0, 5, "Frame7Layout");

    GroupBox1 = new QGroupBox( Frame7, "GroupBox1" );
    GroupBox1->setTitle( tr( "Character Settings" ) );
    GroupBox1->setColumnLayout(0, Qt::Vertical );
    GroupBox1->layout()->setSpacing( 5 );
    GroupBox1->layout()->setMargin( 10 );
    GroupBox1Layout = new QGridLayout( GroupBox1->layout() );
    GroupBox1Layout->setAlignment( Qt::AlignTop );

    Text22 = new QLabel( GroupBox1, "Text22" );
    Text22->setText( tr( "Size:" ) );
    GroupBox1Layout->addWidget( Text22, 1, 0 );

    Size = new QSpinBox( GroupBox1, "Size" );
    Size->setSuffix( tr( " pt" ) );
    GroupBox1Layout->addWidget( Size, 1, 1);

    Fonts = new QToolButton(GroupBox1, "Fonts");
    Fonts->setMaximumSize( QSize( 130, 32767 ) );
    Fonts->setPopup(FontMenu);
    Fonts->setPopupDelay(1);
    GroupBox1Layout->addMultiCellWidget( Fonts, 0, 0, 0, 1 );
    Frame7Layout->addWidget( GroupBox1 );

    GroupBox2 = new QGroupBox( Frame7, "GroupBox2" );
    GroupBox2->setTitle( tr( "Distances" ) );
    GroupBox2->setColumnLayout(0, Qt::Vertical );
    GroupBox2->layout()->setSpacing( 5 );
    GroupBox2->layout()->setMargin( 10 );
    GroupBox2Layout = new QGridLayout( GroupBox2->layout() );
    GroupBox2Layout->setAlignment( Qt::AlignTop );

    Text23 = new QLabel( GroupBox2, "Text23" );
    Text23->setText( tr( "Linespacing:" ) );
		GroupBox2Layout->addWidget( Text23, 0, 0 );

    LineSp = new MSpinBox( GroupBox2, 1 );
    LineSp->setSuffix( tr( " pt" ) );
    GroupBox2Layout->addWidget( LineSp, 0, 1);

    Text24 = new QLabel( GroupBox2, "Text24" );
    Text24->setText( tr( "Kerning:" ) );
    GroupBox2Layout->addWidget( Text24, 1, 0 );

    Extra = new MSpinBox( GroupBox2, 1 );
    Extra->setSuffix( tr( " pt" ) );
    GroupBox2Layout->addWidget( Extra, 1, 1);
    Frame7Layout->addWidget( GroupBox2 );

    Layout11 = new QHBoxLayout( 0, 0, 0, "Layout11"); 

    Bold = new QToolButton( Frame7, "Bold" );
    Bold->setMinimumSize( QSize( 20, 20 ) );
    Bold->setMaximumSize( QSize( 20, 20 ) );
    Bold->setPixmap( loadIcon("Fett.xpm") );
    Bold->setToggleButton( TRUE );
    Layout11->addWidget( Bold );

    Italic = new QToolButton( Frame7, "Italic" );
    Italic->setMinimumSize( QSize( 20, 20 ) );
    Italic->setMaximumSize( QSize( 20, 20 ) );
    Italic->setPixmap( loadIcon("Italic.xpm") );
    Italic->setToggleButton( TRUE );
    Layout11->addWidget( Italic );

    Underline = new QToolButton( Frame7, "Underline" );
    Underline->setMinimumSize( QSize( 20, 20 ) );
    Underline->setMaximumSize( QSize( 20, 20 ) );
    Underline->setPixmap( loadIcon("Unter.xpm") );
    Underline->setToggleButton( TRUE );
    Layout11->addWidget( Underline );

    Kapital = new QToolButton( Frame7, "Kapital" );
    Kapital->setMinimumSize( QSize( 20, 20 ) );
    Kapital->setMaximumSize( QSize( 20, 20 ) );
    Kapital->setPixmap( loadIcon("Kapital.xpm") );
    Kapital->setToggleButton( TRUE );
    Layout11->addWidget( Kapital );

    ButtonGroup6 = new QButtonGroup( Frame7, "ButtonGroup6" );
    ButtonGroup6->setFrameShape( QButtonGroup::NoFrame );
    ButtonGroup6->setExclusive( TRUE );
    ButtonGroup6->setColumnLayout(0, Qt::Vertical );
    ButtonGroup6->layout()->setSpacing( 0 );
    ButtonGroup6->layout()->setMargin( 0 );
    ButtonGroup6Layout = new QHBoxLayout( ButtonGroup6->layout() );
    ButtonGroup6Layout->setAlignment( Qt::AlignTop );

    Subs = new QToolButton( ButtonGroup6, "Subs" );
    Subs->setMinimumSize( QSize( 20, 20 ) );
    Subs->setMaximumSize( QSize( 20, 20 ) );
    Subs->setToggleButton( TRUE );
    Subs->setPixmap( loadIcon("Tief.xpm") );
    ButtonGroup6Layout->addWidget( Subs );

    Supers = new QToolButton( ButtonGroup6, "Supers" );
    Supers->setMinimumSize( QSize( 20, 20 ) );
    Supers->setMaximumSize( QSize( 20, 20 ) );
    Supers->setToggleButton( TRUE );
    Supers->setPixmap( loadIcon("Hoch.xpm") );
    ButtonGroup6Layout->addWidget( Supers );
    Layout11->addWidget( ButtonGroup6 );

    Strike = new QToolButton( Frame7, "Strike" );
    Strike->setMinimumSize( QSize( 20, 20 ) );
    Strike->setMaximumSize( QSize( 20, 20 ) );
    Strike->setPixmap( loadIcon("Strike.xpm") );
    Strike->setToggleButton( TRUE );
    Layout11->addWidget( Strike );
    QSpacerItem* spacer_2 = new QSpacerItem( 0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout11->addItem( spacer_2 );
    Frame7Layout->addLayout( Layout11 );

    Layout14 = new QHBoxLayout( 0, 0, 0, "Layout14"); 

    ButtonGroup2 = new QButtonGroup( Frame7, "ButtonGroup2" );
    ButtonGroup2->setFrameShape( QButtonGroup::NoFrame );
    ButtonGroup2->setTitle( tr( "" ) );
    ButtonGroup2->setExclusive( TRUE );
    ButtonGroup2->setColumnLayout(0, Qt::Vertical );
    ButtonGroup2->layout()->setSpacing( 0 );
    ButtonGroup2->layout()->setMargin( 0 );
    ButtonGroup2Layout = new QHBoxLayout( ButtonGroup2->layout() );
    ButtonGroup2Layout->setAlignment( Qt::AlignTop );

    TextL = new QToolButton( ButtonGroup2, "AlignLeft" );
    TextL->setMinimumSize( QSize( 20, 20 ) );
    TextL->setMaximumSize( QSize( 20, 20 ) );
    TextL->setPixmap( loadIcon("text_left.png") );
    TextL->setToggleButton( TRUE );
    TextL->setOn( TRUE );
    ButtonGroup2Layout->addWidget( TextL );

    TextR = new QToolButton( ButtonGroup2, "AlignRight" );
    TextR->setMinimumSize( QSize( 20, 20 ) );
    TextR->setMaximumSize( QSize( 20, 20 ) );
    TextR->setPixmap( loadIcon("text_right.png") );
    TextR->setToggleButton( TRUE );
    ButtonGroup2Layout->addWidget( TextR );

    TextC = new QToolButton( ButtonGroup2, "AlignCenter" );
    TextC->setMinimumSize( QSize( 20, 20 ) );
    TextC->setMaximumSize( QSize( 20, 20 ) );
    TextC->setPixmap( loadIcon("text_center.png") );
    TextC->setToggleButton( TRUE );
    ButtonGroup2Layout->addWidget( TextC );

    TextB = new QToolButton( ButtonGroup2, "AlignBlock" );
    TextB->setMinimumSize( QSize( 20, 20 ) );
    TextB->setMaximumSize( QSize( 20, 20 ) );
    TextB->setPixmap( loadIcon("text_block.png") );
    TextB->setToggleButton( TRUE );
    ButtonGroup2Layout->addWidget( TextB );
    Layout14->addWidget( ButtonGroup2 );

    FlipH = new QToolButton( Frame7, "FlipH" );
    FlipH->setMinimumSize( QSize( 20, 20 ) );
    FlipH->setMaximumSize( QSize( 20, 20 ) );
    FlipH->setPixmap( loadIcon("FlipH.xpm") );
    Layout14->addWidget( FlipH );

    FlipV = new QToolButton( Frame7, "FlipV" );
    FlipV->setMinimumSize( QSize( 20, 20 ) );
    FlipV->setMaximumSize( QSize( 20, 20 ) );
    FlipV->setPixmap( loadIcon("FlipV.xpm") );
    Layout14->addWidget( FlipV );
    QSpacerItem* spacer_3 = new QSpacerItem( 0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout14->addItem( spacer_3 );
    Frame7Layout->addLayout( Layout14 );
    Fram->addWidget(Frame7, 3);
    Frame9 = new QFrame( this, "Frame7" );
    Frame9->setFrameShape( QFrame::NoFrame );
    Frame9->setFrameShadow( QFrame::Plain );
    Fram->addWidget(Frame9, 4);
    Fram->raiseWidget(3);
    TabWidget3->insertTab( tab_2, tr( "Contents" ) );
		boxLayout()->addWidget(TabWidget3);
    QToolTip::add( Size, tr( "Font Size" ) );
    QToolTip::add( LineSp, tr( "Linespacing" ) );
    QToolTip::add( Extra, tr( "Manual Kerning" ) );
    QToolTip::add( Bold, tr( "Bold" ) );
    QToolTip::add( Italic, tr( "Italic" ) );
    QToolTip::add( Underline, tr( "Underline" ) );
    QToolTip::add( Kapital, tr( "Small Caps" ) );
    QToolTip::add( Subs, tr( "Subscript" ) );
    QToolTip::add( Supers, tr( "Superscript" ) );
    QToolTip::add( Strike, tr( "Strikeout" ) );
    QToolTip::add( TextL, tr( "Align Text Left" ) );
    QToolTip::add( TextR, tr( "Align Text Right" ) );
    QToolTip::add( TextB, tr( "Align Text Block" ) );
    QToolTip::add( TextC, tr( "Align Text Center" ) );
    QToolTip::add( FlipH, tr( "Flip horizontal" ) );
    QToolTip::add( FlipV, tr( "Flip vertical" ) );
    QToolTip::add( FlipH2, tr( "Flip horizontal" ) );
    QToolTip::add( FlipV2, tr( "Flip vertical" ) );
  	connect(this, SIGNAL(visibilityChanged(bool)), this, SLOT(Verbergen(bool)));
    connect(Xpos, SIGNAL(valueChanged(int)), this, SLOT(NewX()));
    connect(Ypos, SIGNAL(valueChanged(int)), this, SLOT(NewY()));
    connect(Width, SIGNAL(valueChanged(int)), this, SLOT(NewW()));
    connect(Height, SIGNAL(valueChanged(int)), this, SLOT(NewH()));
    connect(Rot, SIGNAL(valueChanged(int)), this, SLOT(NewR()));
    connect(RoundRect, SIGNAL(valueChanged(int)), this, SLOT(NewRR()));
    connect(LineSp, SIGNAL(valueChanged(int)), this, SLOT(NewLsp()));
    connect(Size, SIGNAL(valueChanged(int)), this, SLOT(NewSize()));
    connect(Extra, SIGNAL(valueChanged(int)), this, SLOT(NewExtra()));
    connect(ScaleX, SIGNAL(valueChanged(int)), this, SLOT(HChange()));
    connect(ScaleY, SIGNAL(valueChanged(int)), this, SLOT(VChange()));
    connect(LXpos, SIGNAL(valueChanged(int)), this, SLOT(NewLocalXY()));
    connect(LYpos, SIGNAL(valueChanged(int)), this, SLOT(NewLocalXY()));
    connect(LSize, SIGNAL(valueChanged(int)), this, SLOT(NewLS()));
    connect(LStyle, SIGNAL(activated(int)), this, SLOT(NewLSty()));
    connect(LJoinStyle, SIGNAL(activated(int)), this, SLOT(NewLJoin()));
    connect(LEndStyle, SIGNAL(activated(int)), this, SLOT(NewLEnd()));
    connect(LineMode, SIGNAL(activated(int)), this, SLOT(NewLMode()));
    connect(Kette, SIGNAL(clicked()), this, SLOT(ToggleKette()));
    connect(FlipH, SIGNAL(clicked()), this, SLOT(DoFlipH()));
    connect(FlipV2, SIGNAL(clicked()), this, SLOT(DoFlipV()));
    connect(FlipH2, SIGNAL(clicked()), this, SLOT(DoFlipH()));
    connect(FlipV, SIGNAL(clicked()), this, SLOT(DoFlipV()));
    connect(ButtonGroup2, SIGNAL(clicked(int)), this, SLOT(NewAli()));
    connect(Kapital, SIGNAL(clicked()), this, SLOT(setTypeStyle()));
    connect(Bold, SIGNAL(clicked()), this, SLOT(setTypeStyle()));
    connect(Underline, SIGNAL(clicked()), this, SLOT(setTypeStyle()));
    connect(Strike, SIGNAL(clicked()), this, SLOT(setTypeStyle()));
    connect(Italic, SIGNAL(clicked()), this, SLOT(setTypeStyle()));
    connect(Supers, SIGNAL(clicked()), this, SLOT(setTypeStyle()));
    connect(Subs, SIGNAL(clicked()), this, SLOT(setTypeStyle()));
    connect(FreeScale, SIGNAL(clicked()), this, SLOT(ChangeScaling()));
    connect(FrameScale, SIGNAL(clicked()), this, SLOT(ChangeScaling()));
    connect(Aspect, SIGNAL(clicked()), this, SLOT(ChangeScaling()));
  	connect(this, SIGNAL(placeChanged(QDockWindow::Place)), this, SLOT(Docken(QDockWindow::Place)));
  	setCloseMode(Always);
		undock();
		resize(sizeHint());
		setResizeEnabled(true);
    Fram->raiseWidget(4);
}

Mpalette::~Mpalette()
{
}

void Mpalette::Docken(QDockWindow::Place p)
{
	if (p == InDock)
		setResizeEnabled(false);
	else
		setResizeEnabled(true);
}

void Mpalette::Verbergen(bool vis)
{
  Fram->raiseWidget(4);
	if (!vis)
		{
		emit Schliessen();
		}
	else
		{
		if ((HaveDoc) && (HaveItem))
			NewSel(CurItem->PType);
		}	
	Sichtbar = vis;
}

void Mpalette::keyPressEvent(QKeyEvent *k)
{
	if (k->key() == Key_Shift)
		{
    Xpos->setLineStep(10);
    Ypos->setLineStep(10);
    Width->setLineStep(10);
    Height->setLineStep(10);
    Rot->setLineStep(10);
    Extra->setLineStep(1);
    LineSp->setLineStep(1);
    LXpos->setLineStep(10);
    LYpos->setLineStep(10);
    ScaleX->setLineStep(1);
    ScaleY->setLineStep(1);
    LSize->setLineStep(1);
		}
}

void Mpalette::keyReleaseEvent(QKeyEvent *k)
{
	if (k->key() == Key_Shift)
		{
    Xpos->setLineStep(100);
    Ypos->setLineStep(100);
    Width->setLineStep(100);
    Height->setLineStep(100);
    Rot->setLineStep(100);
    Extra->setLineStep(10);
    LineSp->setLineStep(10);
    LXpos->setLineStep(100);
    LYpos->setLineStep(100);
    ScaleX->setLineStep(10);
    ScaleY->setLineStep(10);
    LSize->setLineStep(10);
		}
}

void Mpalette::SetDoc(ScribusDoc *d)
{
	doc = d;
	HaveDoc = true;
	Xpos->setMaxValue( 300000 );
	Xpos->setMinValue( -300000 );
	Ypos->setMaxValue( 300000 );
	Ypos->setMinValue( -300000 );
	Width->setMaxValue( 300000 );
	Width->setMinValue( 100 );
	Height->setMaxValue( 300000 );
	Height->setMinValue( 100 );
	Rot->setMaxValue( 36000 );
	Rot->setMinValue( 0 );
	RoundRect->setMaxValue( 3000 );
	RoundRect->setMinValue( -3000 );
	LYpos->setMaxValue( 300000 );
	LYpos->setMinValue( -300000 );
	ScaleY->setMaxValue( 3000 );
	ScaleY->setMinValue( 1 );
	ScaleX->setMaxValue( 3000 );
	ScaleX->setMinValue( 1 );
	LXpos->setMaxValue( 300000 );
	LXpos->setMinValue( -300000 );
	Size->setMaxValue( 512 );
	Size->setMinValue( 1 );
	LineSp->setMaxValue( 3000 );
	LineSp->setMinValue( 1 );
	Extra->setMaxValue( 3000 );
	Extra->setMinValue( -3000 );
	LSize->setMaxValue( 120 );
	LSize->setMinValue( 1 );
  Xpos->setLineStep(100);
  Ypos->setLineStep(100);
  Width->setLineStep(100);
  Height->setLineStep(100);
  Rot->setLineStep(100);
  Extra->setLineStep(10);
  LineSp->setLineStep(10);
  LXpos->setLineStep(100);
  LYpos->setLineStep(100);
  ScaleX->setLineStep(10);
  ScaleY->setLineStep(10);
}

void Mpalette::UnsetDoc()
{
	HaveDoc = false;
}

void Mpalette::SetCurItem(PageItem *i)
{
	HaveItem = false;
	CurItem = i;
	Fonts->setText(i->IFont);
	RoundRect->setValue(qRound(i->RadRect));
	if (((i->PType == 4) || (i->PType == 2) || (i->PType == 3)) &&  (!i->ClipEdited))
		{
		RoundRect->show();
		Text5_2->show();
		}
	else
		{
		RoundRect->hide();
		Text5_2->hide();
		}
	if (i->PType == 5)
		{
		if (LMode)
			{
    	Text3->setText(tr( "X2-Pos:" ));
			Text4->setText(tr( "Y2-Pos:" ));
			Rot->hide();
			Text5->hide();
			Height->show();
			Text4->show();
			}
		else
			{
    	Text3->setText(tr("Length:" ));
    	Text4->setText(tr("Height:"));
			Height->hide();
			Text4->hide();
			Rot->show();
			Text5->show();
			}
		}
	else
		{
		if (i->PType == 2)
			{
    	disconnect(FreeScale, SIGNAL(clicked()), this, SLOT(ChangeScaling()));
    	disconnect(FrameScale, SIGNAL(clicked()), this, SLOT(ChangeScaling()));
    	disconnect(Aspect, SIGNAL(clicked()), this, SLOT(ChangeScaling()));
			if (i->ScaleType)
				{
				FreeScale->setChecked(true);
				FrameScale->setChecked(false);
				GroupBox4->setEnabled(true);
				Aspect->setEnabled(false);
				Aspect->setChecked(false);
				}
			else
				{
				FreeScale->setChecked(false);
				FrameScale->setChecked(true);
				GroupBox4->setEnabled(false);
				Kette->setOn(false);
				Aspect->setEnabled(true);
				Aspect->setChecked(i->AspectRatio);
				}
    	connect(FreeScale, SIGNAL(clicked()), this, SLOT(ChangeScaling()));
    	connect(FrameScale, SIGNAL(clicked()), this, SLOT(ChangeScaling()));
    	connect(Aspect, SIGNAL(clicked()), this, SLOT(ChangeScaling()));
			}
		Height->show();
		Text4->show();
		Rot->show();
		Text5->show();
    Text3->setText(tr("Width:"));
    Text4->setText(tr("Height:"));
		}
	HaveItem = true;
}

void Mpalette::NewSel(int nr)
{
	if (doc->ActPage->GroupSel)
		{
   	Text3->setText(tr("Width:"));
   	Text4->setText(tr("Height:"));
		HaveItem = false;
		Xpos->setValue(0);
		Ypos->setValue(0);
		Width->setValue(0);
		Height->setValue(0);
		Rot->setValue(0);
		Height->show();
		Text4->show();
//		ScaleGr->show();
		RoundRect->setValue(0);
		RoundRect->hide();
		Text5_2->hide();		
		LineMode->hide();
   	Fram->raiseWidget(4);
		HaveItem = true;
		}
	else
		{
//		ScaleGr->hide();
		switch (nr)
			{
			case -1:
    		Text3->setText(tr("Width:"));
    		Text4->setText(tr("Height:"));
				HaveItem = false;
				Xpos->setValue(0);
				Ypos->setValue(0);
				Width->setValue(0);
				Height->setValue(0);
				Rot->setValue(0);
				RoundRect->setValue(0);		
				LineMode->hide();
    		Fram->raiseWidget(4);
				break;
			case 2:
				LineMode->hide();
    		Fram->raiseWidget(1);
				HaveItem = true;
				break;
			case 8:
			case 4:
				LineMode->hide();
    		Fram->raiseWidget(3);
				HaveItem = true;
				break;
			default:
    		Fram->raiseWidget(2);
				if (nr == 5)
					LineMode->show();
				else
					LineMode->hide();
				HaveItem = true;
				break;
			}
		}
	updateGeometry();
	repaint();
}

void Mpalette::UnitChange()
{
	float old = Umrech;
	bool tmp = HaveItem;
	HaveItem = false;
	QString ein;
	Umrech = UmReFaktor;
	switch (doc->Einheit)
		{
		case 0:
			ein = " pt";
			break;
		case 1:
    	ein = " mm";
			break;
		case 2:
    	ein = " in";
			break;
		case 3:
    	ein = " p";
			break;
		}
	Xpos->setSuffix( ein );
	Ypos->setSuffix( ein );
	Width->setSuffix( ein );
	Height->setSuffix( ein );
	LXpos->setSuffix( ein );
	LYpos->setSuffix( ein );
	Xpos->setValue(qRound(float(Xpos->value()) / old * UmReFaktor));
	Ypos->setValue(qRound(float(Ypos->value()) / old) * UmReFaktor);
	Width->setValue(qRound(float(Width->value()) / old * UmReFaktor));
	Height->setValue(qRound(float(Height->value()) / old * UmReFaktor));
	LXpos->setValue(qRound(float(LXpos->value()) / old * UmReFaktor));
	LYpos->setValue(qRound(float(LYpos->value()) / old * UmReFaktor));
	HaveItem = tmp;
}

void Mpalette::setXY(float x, float y)
{
	bool tmp = HaveItem;
	HaveItem = false;
	Xpos->setValue(qRound(x*UmReFaktor*100));
	Ypos->setValue(qRound(y*UmReFaktor*100));
	if (LMode)
		setBH(CurItem->Width, CurItem->Height);
	HaveItem = tmp;
}

void Mpalette::setBH(float x, float y)
{
	bool tmp = HaveItem;
	HaveItem = false;
	QWMatrix ma;
	QPoint dp;
	if ((LMode) && (CurItem->PType == 5))
		{
		ma.translate(float(Xpos->value()) / UmReFaktor / 100, float(Ypos->value()) / UmReFaktor / 100);
		ma.rotate(float(Rot->value())/100*(-1));
		dp = ma * QPoint(x, y);
		Width->setValue(qRound(dp.x()*UmReFaktor*100));
		Height->setValue(qRound(dp.y()*UmReFaktor*100));
		}
	else
		{
		RoundRect->setMaxValue(QMIN(x, y)/2);
		Width->setValue(qRound(x*UmReFaktor*100));
		Height->setValue(qRound(y*UmReFaktor*100));
		}
	HaveItem = tmp;
}

void Mpalette::setR(float r)
{
	bool tmp = HaveItem;
	float rr = r;
	if (r > 0)
		rr = 360 - rr;
	HaveItem = false;
	Rot->setValue(qRound(fabs(rr)*100));
	HaveItem = tmp;
}

void Mpalette::setRR(float r)
{
	bool tmp = HaveItem;
	HaveItem = false;
	RoundRect->setValue(qRound(r));
	HaveItem = tmp;
}

void Mpalette::setLsp(float r)
{
	bool tmp = HaveItem;
	HaveItem = false;
	LineSp->setValue(qRound(r*10));
	HaveItem = tmp;
}

void Mpalette::setSize(int s)
{
	bool tmp = HaveItem;
	HaveItem = false;
	Size->setValue(s);
	HaveItem = tmp;
}

void Mpalette::setExtra(float e)
{
	bool tmp = HaveItem;
	HaveItem = false;
	Extra->setValue(qRound(e*10));
	HaveItem = tmp;
}

void Mpalette::ChangeScaling()
{
	if (FreeScale->isChecked())
		{
		GroupBox4->setEnabled(true);
		Aspect->setEnabled(false);
		}
	else
		{
		GroupBox4->setEnabled(false);
		Aspect->setEnabled(true);
		}
	if ((HaveDoc) && (HaveItem))
		{
		CurItem->ScaleType = FreeScale->isChecked();
		CurItem->AspectRatio = Aspect->isChecked();
		if (!CurItem->ScaleType)
			doc->ActPage->AdjustPictScale(CurItem);
		doc->ActPage->RefreshItem(CurItem);
		emit DocChanged();
		setFocus();
		}
}

void Mpalette::setLvalue(float scx, float scy, float x, float y)
{
	bool tmp = HaveItem;
	HaveItem = false;
	LXpos->setValue(qRound(x * UmReFaktor * 100));
	LYpos->setValue(qRound(y * UmReFaktor * 100));
	ScaleX->setValue(qRound(scx * 1000));
	ScaleY->setValue(qRound(scy * 1000));
	HaveItem = tmp;
}

void Mpalette::setSvalue(float s)
{
	bool tmp = HaveItem;
	HaveItem = false;
	LSize->setValue(qRound(s*10));
	HaveItem = tmp;
}

void Mpalette::setLIvalue(PenStyle p, PenCapStyle pc, PenJoinStyle pj)
{
	bool tmp = HaveItem;
	HaveItem = false;
	switch (p)
		{
		case SolidLine:
			LStyle->setCurrentItem(0);
			break;
		case DashLine:
			LStyle->setCurrentItem(1);
			break;
		case DotLine:
			LStyle->setCurrentItem(2);
			break;
		case DashDotLine:
			LStyle->setCurrentItem(3);
			break;
		case DashDotDotLine:
			LStyle->setCurrentItem(4);
			break;
		default:
			LStyle->setCurrentItem(0);
			break;
		}
	switch (pc)
		{
		case FlatCap:
			LEndStyle->setCurrentItem(0);
			break;
		case SquareCap:
			LEndStyle->setCurrentItem(1);
			break;
		case RoundCap:
			LEndStyle->setCurrentItem(2);
			break;
		default:
			LEndStyle->setCurrentItem(0);
			break;
		}
	switch (pj)
		{
		case MiterJoin:
			LJoinStyle->setCurrentItem(0);
			break;
		case BevelJoin:
			LJoinStyle->setCurrentItem(1);
			break;
		case RoundJoin:
			LJoinStyle->setCurrentItem(2);
			break;
		default:
			LJoinStyle->setCurrentItem(0);
			break;
		}
	HaveItem = tmp;
}

void Mpalette::setStil(int s)
{
	Supers->setOn(false);
	Subs->setOn(false);
	Italic->setOn(false);
	Strike->setOn(false);
	Underline->setOn(false);
	Bold->setOn(false);
	Kapital->setOn(false);
	if (s & 1)
		Supers->setOn(true);
	if (s & 2)
		Subs->setOn(true);
	if (s & 4)
		Italic->setOn(true);
	if (s & 8)
		Underline->setOn(true);
	if (s & 16)
		Strike->setOn(true);
	if (s & 32)
		Bold->setOn(true);
	if (s & 64)
		Kapital->setOn(true);
}

void Mpalette::setAli(int e)
{
	bool tmp = HaveItem;
	HaveItem = false;
	switch (e)
		{
		case 0:
			TextL->setOn(true);
			break;
		case 2:
			TextR->setOn(true);
			break;
		case 1:
			TextC->setOn(true);
			break;
		case 3:
			TextB->setOn(true);
			break;
		default:
			TextL->setOn(false);
			TextR->setOn(false);
			TextC->setOn(false);
			TextB->setOn(false);
			break;
		}
	HaveItem = tmp;
}

void Mpalette::NewX()
{
	float x,y,w,h, gx, gy, gh, gw;
	x = float(Xpos->value()) / UmReFaktor / 100;
	y = float(Ypos->value()) / UmReFaktor / 100;
	w = float(Width->value()) / UmReFaktor / 100;
	h = float(Height->value()) / UmReFaktor / 100;
	if ((HaveDoc) && (HaveItem))
		{
		if (doc->ActPage->GroupSel)
			{
			doc->ActPage->getGroupRect(&gx, &gy, &gw, &gh);
			doc->ActPage->moveGroup(x - gx, 0, true);
			}
		else
			{
			if ((CurItem->PType == 5) && (LMode))
				{
				float r = atan2(h-y,w-x)*(180.0/3.1415927);
				w = sqrt(pow(w-x,2)+pow(h-y,2));
				doc->ActPage->MoveItem(x - CurItem->Xpos, 0, CurItem, true);
				doc->ActPage->SizeItem(w, CurItem->Height, CurItem->ItemNr, true);
				doc->ActPage->RotateItem(r, CurItem->ItemNr);
				}
			else
				doc->ActPage->MoveItem(x - CurItem->Xpos, 0, CurItem, true);
			}
		emit DocChanged();
		setFocus();
		}
}

void Mpalette::NewY()
{
	float x,y,w,h, gx, gy, gh, gw;
	x = float(Xpos->value()) / UmReFaktor / 100;
	y = float(Ypos->value()) / UmReFaktor / 100;
	w = float(Width->value()) / UmReFaktor / 100;
	h = float(Height->value()) / UmReFaktor / 100;
	if ((HaveDoc) && (HaveItem))
		{
		if (doc->ActPage->GroupSel)
			{
			doc->ActPage->getGroupRect(&gx, &gy, &gw, &gh);
			doc->ActPage->moveGroup(0, y - gy, true);
			}
		else
			{
			if ((CurItem->PType == 5) && (LMode))
				{
				float r = atan2(h-y,w-x)*(180.0/3.1415927);
				w = sqrt(pow(w-x,2)+pow(h-y,2));
				doc->ActPage->MoveItem(0, y - CurItem->Ypos, CurItem, true);
				doc->ActPage->SizeItem(w, CurItem->Height, CurItem->ItemNr, true);
				doc->ActPage->RotateItem(r, CurItem->ItemNr);
				}
			else
				doc->ActPage->MoveItem(0, y - CurItem->Ypos, CurItem);
			}
		emit DocChanged();
		setFocus();
		}
}

void Mpalette::NewW()
{
	float x,y,w,h, gx, gy, gh, gw;
	x = float(Xpos->value()) / UmReFaktor / 100;
	y = float(Ypos->value()) / UmReFaktor / 100;
	w = float(Width->value()) / UmReFaktor / 100;
	h = float(Height->value()) / UmReFaktor / 100;
	if ((HaveDoc) && (HaveItem))
		{
		if (doc->ActPage->GroupSel)
			{
			doc->ActPage->getGroupRect(&gx, &gy, &gw, &gh);
			doc->ActPage->HowTo = 1;
//			if (ScaleGr->isChecked())
//				{
				doc->ActPage->scaleGroup(w / gw, w / gw);
				setBH(w, (w / gw) * gh);
/*				}
			else
				doc->ActPage->scaleGroup(w / gw, h / gh);  */
			}
		else
			{
			CurItem->OldB2 = CurItem->Width;
			CurItem->OldH2 = CurItem->Height;
			if (CurItem->PType == 5)
				{
				if (LMode)
					{
					float r = atan2(h-y,w-x)*(180.0/3.1415927);
					doc->ActPage->RotateItem(r, CurItem->ItemNr);
					w = sqrt(pow(w-x,2)+pow(h-y,2));
					}
				doc->ActPage->SizeItem(w, CurItem->Height, CurItem->ItemNr, true);
				}
			else
				doc->ActPage->SizeItem(w, CurItem->Height, CurItem->ItemNr, true);
			emit DocChanged();
			}
		setFocus();
		}
}

void Mpalette::NewH()
{
	float x,y,w,h, gx, gy, gh, gw;
	x = float(Xpos->value()) / UmReFaktor / 100;
	y = float(Ypos->value()) / UmReFaktor / 100;
	w = float(Width->value()) / UmReFaktor / 100;
	h = float(Height->value()) / UmReFaktor / 100;
	if ((HaveDoc) && (HaveItem))
		{
		if (doc->ActPage->GroupSel)
			{
			doc->ActPage->getGroupRect(&gx, &gy, &gw, &gh);
			doc->ActPage->HowTo = 1;
//			if (ScaleGr->isChecked())
//				{
				doc->ActPage->scaleGroup(h / gh, h / gh);
				setBH((h / gh) * gw, h);
/*				}
			else
				doc->ActPage->scaleGroup(w / gw, h / gh);      */
			}
		else
			{
			CurItem->OldB2 = CurItem->Width;
			CurItem->OldH2 = CurItem->Height;
			if (CurItem->PType == 5)
				{
				if (LMode)
					{
					float r = atan2(h-y,w-x)*(180.0/3.1415927);
					doc->ActPage->RotateItem(r, CurItem->ItemNr);
					w = sqrt(pow(w-x,2)+pow(h-y,2));
					}
				doc->ActPage->SizeItem(w, CurItem->Height, CurItem->ItemNr, true);
				}
			else
				doc->ActPage->SizeItem(CurItem->Width, h, CurItem->ItemNr, true);
			}
		emit DocChanged();
		setFocus();
		}
}

void Mpalette::NewR()
{
	if ((HaveDoc) && (HaveItem))
		{
		if (doc->ActPage->GroupSel)
			return;
		doc->ActPage->RotateItem(float(Rot->value())/100*(-1), CurItem->ItemNr);
		emit DocChanged();
		setFocus();
		}
}

void Mpalette::NewRR()
{
	if ((HaveDoc) && (HaveItem))
		{
		CurItem->RadRect = RoundRect->value();
		doc->ActPage->SetFrameRounded();
		emit DocChanged();
		setFocus();
		}
}

void Mpalette::NewLsp()
{
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->ChLineSpa(float(LineSp->value())/10);
		emit DocChanged();
		setFocus();
		}
}

void Mpalette::NewSize()
{
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->chFSize(Size->value());
		emit DocChanged();
		setFocus();
		}
}

void Mpalette::NewExtra()
{
	if ((HaveDoc) && (HaveItem))
		{
		if ((CurItem->HasSel) || (doc->AppMode == 1))
			{
			doc->ActPage->chKerning(float(Extra->value())/10);
			emit DocChanged();
			}
		else
			{
			if (uint(CurItem->CPos) != CurItem->Ptext.count())
				{
				CurItem->Ptext.at(CurItem->CPos)->cextra = float(Extra->value())/10;
				CurItem->Dirty = true;
				CurItem->paintObj();
				emit DocChanged();
				}
			}
		setFocus();
		}
}

void Mpalette::NewLocalXY()
{
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->ChLocalXY(float(LXpos->value()) / UmReFaktor / 100, float(LYpos->value()) / UmReFaktor / 100);
		emit DocChanged();
		setFocus();
		}
}

void Mpalette::NewLocalSC()
{
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->ChLocalSc(float(ScaleX->value()) / 1000, float(ScaleY->value()) / 1000);
		emit DocChanged();
		setFocus();
		}
}

void Mpalette::NewLS()
{
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->ChLineWidth(float(LSize->value())/10);
		emit DocChanged();
		setFocus();
		}
}

void Mpalette::NewLSty()
{
	PenStyle c = SolidLine;
	switch (LStyle->currentItem())
		{
		case 0:
			c = SolidLine;
			break;
		case 1:
			c = DashLine;
			break;
		case 2:
			c = DotLine;
			break;
		case 3:
			c = DashDotLine;
			break;
		case 4:
			c = DashDotDotLine;
			break;
		}
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->ChLineArt(c);
		emit DocChanged();
		}
}

void Mpalette::NewLMode()
{
	if (LineMode->currentItem() == 0)
		{
		Height->hide();
		Text4->hide();
		Rot->show();
		Text5->show();
    Text3->setText(tr("Width:" ));
    Text4->setText(tr("Height:"));
		LMode = false;
		}
	else
		{
		Rot->hide();
		Text5->hide();
    Height->show();
    Text4->show();
    Text3->setText(tr( "X2-Pos:" ));
		Text4->setText(tr( "Y2-Pos:" ));
		LMode = true;
		}
	setBH(CurItem->Width, CurItem->Height);
}

void Mpalette::NewLJoin()
{
	PenJoinStyle c = MiterJoin;
	switch (LJoinStyle->currentItem())
		{
		case 0:
			c = MiterJoin;
			break;
		case 1:
			c = BevelJoin;
			break;
		case 2:
			c = RoundJoin;
			break;
		}
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->ChLineJoin(c);
		emit DocChanged();
		}
}

void Mpalette::NewLEnd()
{
	PenCapStyle c = FlatCap;
	switch (LEndStyle->currentItem())
		{
		case 0:
			c = FlatCap;
			break;
		case 1:
			c = SquareCap;
			break;
		case 2:
			c = RoundCap;
			break;
		}
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->ChLineEnd(c);
		emit DocChanged();
		}
}

void Mpalette::ToggleKette()
{
	if (Kette->isOn())
		{
		ScaleY->setValue(ScaleX->value());
		NewLocalSC();
		}	
}

void Mpalette::HChange()
{
	if (Kette->isOn())
		{
		ScaleY->setValue(ScaleX->value());
		}
	NewLocalSC();
}

void Mpalette::VChange()
{
	if (Kette->isOn())
		{
		ScaleX->setValue(ScaleY->value());
		}
	NewLocalSC();
}

void Mpalette::DoFlipH()
{
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->FlipImageH();
		emit DocChanged();
		}
}

void Mpalette::DoFlipV()
{
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->FlipImageV();
		emit DocChanged();
		}
}

void Mpalette::NewAli()
{
	if ((HaveDoc) && (HaveItem))
		{
		if (TextL->isOn())
			emit NewAbStyle(0);
		if (TextR->isOn())
			emit NewAbStyle(2);
		if (TextC->isOn())
			emit NewAbStyle(1);
		if (TextB->isOn())
			emit NewAbStyle(3);
		}
}

void Mpalette::setTypeStyle()
{
	if (Supers == sender())
		{
		emit Stellung(1);
		Subs->setOn(false);
		emit BackHome();
		return;
		}
	if (Subs == sender())
		{
		emit Stellung(2);
		Supers->setOn(false);
		emit BackHome();
		return;
		}
	if (Italic == sender())
		{
		emit Stellung(4);
		emit BackHome();
		return;
		}
	if (Underline == sender())
		{
		emit Stellung(8);
		emit BackHome();
		return;
		}
	if (Strike == sender())
		{
		emit Stellung(16);
		emit BackHome();
		return;
		}
	if (Bold == sender())
		{
		emit Stellung(32);
		emit BackHome();
		return;
		}
	if (Kapital == sender())
		{
		emit Stellung(64);
		emit BackHome();
		return;
		}
	emit Stellung(0);
}
