/***************************************************************************
                          fpointarray.cpp  -  description
                             -------------------
    begin                : Mit Jul 24 2002
    copyright            : (C) 2002 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "fpointarray.h"
#include <stdarg.h>

FPointArray::FPointArray()
{
}

void FPointArray::setPoint(uint i, float x, float y)
{
	QMemArray<FPoint>::at( i ) = FPoint( x, y );
}

void FPointArray::setPoint(uint i, FPoint p)
{
	setPoint(i, p.x(), p.y());
}

bool FPointArray::setPoints( int nPoints, double firstx, double firsty, ... )
{
	va_list ap;
	if ( !resize(nPoints) )
		return FALSE;
	setPoint( 0, firstx, firsty );
	int i = 1;
	float x, y;
	nPoints--;
	va_start( ap, firsty );
	while ( nPoints-- )
		{
		x = float(va_arg( ap, double ));
		y = float(va_arg( ap, double ));
		setPoint( i++, x, y );
    }
	va_end( ap );
	return TRUE;
}

bool FPointArray::putPoints( int index, int nPoints, double firstx, double firsty,  ... )
{
	va_list ap;
	if ( index + nPoints > (int)size() )
		{
		if ( !resize(index + nPoints) )
			return FALSE;
		}
	if ( nPoints <= 0 )
		return TRUE;
	setPoint( index, firstx, firsty );		// set first point
	int i = index + 1;
	float x, y;
	nPoints--;
	va_start( ap, firsty );
	while ( nPoints-- )
		{
		x = float(va_arg(ap, double));
		y = float(va_arg(ap, double));
		setPoint( i++, x, y );
		}
	va_end( ap );
	return TRUE;
}

bool FPointArray::putPoints( int index, int nPoints, const FPointArray & from, int fromIndex )
{
	if ( index + nPoints > (int)size() )
		{	// extend array
		if ( !resize(index + nPoints) )
			return FALSE;
		}
	if ( nPoints <= 0 )
		return TRUE;
	int n = 0;
	while( n < nPoints )
		{
		setPoint( index+n, from[fromIndex+n] );
		n++;
    }
	return TRUE;
}

void FPointArray::point(uint i, float *x, float *y)
{
	FPoint p = QMemArray<FPoint>::at(i);
	if (x)
		*x = p.x();
	if (y)
		*y = p.y();
}

FPoint FPointArray::point(uint i)
{
	return QMemArray<FPoint>::at(i);
}

QPoint FPointArray::pointQ(uint i)
{
	FPoint p = QMemArray<FPoint>::at(i);
	QPoint r(qRound(p.x()),qRound(p.y()));
	return r;
}

void FPointArray::translate( float dx, float dy )
{
	register FPoint *p = data();
	register int i = size();
	FPoint pt( dx, dy );
	while ( i-- )
		{
		*p += pt;
		p++;
		}
}

FPoint FPointArray::WidthHeight()
{
	if ( isEmpty() )
		return FPoint( 0.0, 0.0 );		// null rectangle
	register FPoint *pd = data();
	float minx, maxx, miny, maxy;
	minx = maxx = pd->x();
	miny = maxy = pd->y();
	pd++;
	for ( int i=1; i<(int)size(); i++ )
		{	// find min+max x and y
		if ( pd->x() < minx )
			minx = pd->x();
		else
			if ( pd->x() > maxx )
	    	maxx = pd->x();
		if ( pd->y() < miny )
			miny = pd->y();
		else
			if ( pd->y() > maxy )
	    	maxy = pd->y();
		pd++;
    }
	return FPoint(maxx - minx,maxy - miny);
}

void FPointArray::map( QWMatrix m )
{
	register FPoint *p = data();
	register int i = size();
	while ( i-- )
		{
		float mx = m.m11() * p->x() + m.m21() * p->y() + m.dx();
		float my = m.m22() * p->y() + m.m12() * p->x() + m.dy();
		*p = FPoint(mx, my);
		p++;
		}
}

FPointArray::~FPointArray()
{
}
