/***************************************************************************
                 	scribusXml.cpp the document xml library for scribus
                             -------------------
    begin                : Sam Jul 14 10:00:00 CEST 2001
    copyright            : (C) 2001 by Christian Tpp
    email                : christian.toepp@mr-ct@gmx.de
 ***************************************************************************/
#include "scribusXml.h"
#include "scribusXml.moc"
#include <qfile.h>
#include <qtextstream.h>
#include <qapplication.h>
#include <qstylefactory.h>
#include <qtl.h>
#include <qcursor.h>
#include <stdlib.h>
#include <math.h>
#include "missing.h"
#include "config.h"
#ifdef HAVE_LIBZ
#include <zlib.h>
#endif

extern float QStoFloat(QString in);
extern int QStoInt(QString in);
extern bool loadTextQS(QString nam, QString *Buffer);

ScriXmlDoc::ScriXmlDoc()
{
}

ScriXmlDoc::~ScriXmlDoc()
{
}

bool ScriXmlDoc::ReadColors(QString fileName)
{
	QDomDocument docu("scridoc");
	QFile f(fileName);
	if(!f.open(IO_ReadOnly))
		return FALSE;
	if(!docu.setContent(&f))
		{
		f.close();
		return FALSE;
		}
	f.close();
	Farben.clear();
	CMYKColor lf = CMYKColor();
	QDomElement elem=docu.documentElement();
	if (elem.tagName() != "SCRIBUS")
		return false;
	QDomNode DOC=elem.firstChild();
	while(!DOC.isNull())
		{
		QDomElement dc=DOC.toElement();
		QDomNode PAGE=DOC.firstChild();
		while(!PAGE.isNull())
			{
			QDomElement pg=PAGE.toElement();
			if(pg.tagName()=="COLOR")
				{
				if (pg.hasAttribute("CMYK"))
					lf.setNamedColor(pg.attribute("CMYK"));
				else
					lf.fromQColor(QColor(pg.attribute("RGB")));
		  	Farben[pg.attribute("NAME")] = lf;
				}
			PAGE=PAGE.nextSibling();
			}
		DOC=DOC.nextSibling();
		}
	return TRUE;
}

bool ScriXmlDoc::ReadDoc(QString fileName, SCFonts &avail, ScribusDoc *doc, ScribusView *view, QProgressBar *dia2)
{
struct CLBuf OB;
struct StVorL vg;
struct Layer la;
int counter, Pgc;
bool AtFl;
struct Linked Link;
QString tmp, tmpf, tmp2, tmp3, tmp4, PgNam, f, Defont;
QFont fo;
QMap<QString,QString> DoFonts;
int x, y, a;
float xf, yf;
PageItem *Neu;
LFrames.clear();
QDomDocument docu("scridoc");
/**
  * added to support gz docs
  * 2.7.2002 C.Toepp
  * <c.toepp@gmx.de>
  */
#ifdef HAVE_LIBZ
if(fileName.right(2) == "gz")
	{
//	qDebug("-- zipped --");
//  there is an zipped document
	gzFile gzDoc;
	char buff[4097];
	QString buff2;
	int i;
	gzDoc = gzopen(fileName.latin1(),"rb");
	if(gzDoc == NULL)
		{
		return false;
		}
	while((i = gzread(gzDoc,&buff,4096)) > 0)
		{
		buff[i] = '\0';
		buff2.append(buff);
		}
	QString errMsg;
	int errLine;
	int errCol;
	if(!docu.setContent(buff2,&errMsg,&errLine,&errCol))
		{
		return false;
		}
	gzclose(gzDoc);
	}
else
	{
// a normal document
	if (!loadTextQS(fileName, &f))
		return false;
	if(!docu.setContent(f))
		return false;
	}
#else
if (!loadTextQS(fileName, &f))
	return false;
if(!docu.setContent(f))
	return false;
#endif
/** end changes */
doc->PageColors.clear();
doc->Layers.clear();
CMYKColor lf = CMYKColor();
QDomElement elem=docu.documentElement();
if (elem.tagName() != "SCRIBUS")
	return false;
QDomNode DOC=elem.firstChild();
dia2->setTotalSteps(DOC.childNodes().count());
dia2->setProgress(0);
int ObCount = 0;
while(!DOC.isNull())
{
	QDomElement dc=DOC.toElement();
	/*
	* Attribute von DOCUMENT auslesen
	*/
	doc->PageB=QStoFloat(dc.attribute("PAGEWITH"));
	doc->PageH=QStoFloat(dc.attribute("PAGEHEIGHT"));
	doc->PageM.Left=QStoFloat(dc.attribute("BORDERLEFT"));
	doc->PageM.Right=QStoFloat(dc.attribute("BORDERRIGHT"));
	doc->PageM.Top=QStoFloat(dc.attribute("BORDERTOP"));
	doc->PageM.Bottom=QStoFloat(dc.attribute("BORDERBOTTOM"));
	doc->PageOri = QStoInt(dc.attribute("ORIENTATION","0"));
	doc->FirstPnum = QStoInt(dc.attribute("FIRSTNUM","1"));
	doc->PageFP=QStoInt(dc.attribute("BOOK"));
	doc->FirstPageLeft=QStoInt(dc.attribute("FIRSTLEFT"));
	doc->PageAT=QStoInt(dc.attribute("AUTOTEXT"));
	doc->PageSp=QStoInt(dc.attribute("AUTOSPALTEN"));
	doc->PageSpa=QStoFloat(dc.attribute("ABSTSPALTEN"));
	doc->Einheit = QStoInt(dc.attribute("UNITS","0"));
	Defont=dc.attribute("DFONT");
	doc->Dsize=QStoInt(dc.attribute("DSIZE"));
	doc->DocAutor=dc.attribute("AUTHOR");
	doc->DocComments=dc.attribute("COMMENTS");
	doc->DocTitel=dc.attribute("TITLE");
	doc->VHoch=QStoInt(dc.attribute("VHOCH"));
	doc->VHochSc=QStoInt(dc.attribute("VHOCHSC"));
	doc->VTief=QStoInt(dc.attribute("VTIEF"));
	doc->VTiefSc=QStoInt(dc.attribute("VTIEFSC"));
	doc->VKapit=QStoInt(dc.attribute("VKAPIT"));
	doc->GroupCounter=QStoInt(dc.attribute("GROUPC","1"));
	doc->HasCMS = bool(QStoInt(dc.attribute("HCMS","0")));
	doc->CMSSettings.SoftProofOn = bool(QStoInt(dc.attribute("DPSo","0")));
	doc->CMSSettings.CMSinUse = bool(QStoInt(dc.attribute("DPuse","0")));
	doc->CMSSettings.GamutCheck = bool(QStoInt(dc.attribute("DPgam","0")));
	doc->CMSSettings.DefaultMonitorProfile = dc.attribute("DPMo","");
	doc->CMSSettings.DefaultPrinterProfile = dc.attribute("DPPr","");
	doc->CMSSettings.DefaultInputProfile = dc.attribute("DPIn","");
	doc->CMSSettings.DefaultInputProfile2 = dc.attribute("DPIn2","");
	doc->CMSSettings.DefaultIntentPrinter = QStoInt(dc.attribute("DIPr","0"));
	doc->CMSSettings.DefaultIntentMonitor = QStoInt(dc.attribute("DIMo","1"));
	doc->CMSSettings.DefaultIntentMonitor2 = QStoInt(dc.attribute("DIMo2","1"));
	doc->ActiveLayer = QStoInt(dc.attribute("ALAYER","0"));
	DoFonts.clear();
	QDomNode PAGE=DOC.firstChild();
	while(!PAGE.isNull())
	{
		ObCount++;
		dia2->setProgress(ObCount);
		QDomElement pg=PAGE.toElement();
		if(pg.tagName()=="FONT")
		{
			/*
			* Attribute von FONT auslesen
			*/
			tmpf = pg.attribute("NAME");
			if (!avail.find(tmpf))
				{
  			qApp->setOverrideCursor(QCursor(arrowCursor), true);
				DmF *dia = new DmF(view, tmpf, avail);
				dia->exec();
				tmpf = dia->Ersatz;
				delete dia;
  			qApp->setOverrideCursor(QCursor(waitCursor), true);
				}
			fo = avail[tmpf]->Font;
			fo.setPointSize(doc->Dsize);
			doc->AddFont(tmpf, fo);
			DoFonts[pg.attribute("NAME")] = tmpf;
		}
		if(pg.tagName()=="COLOR")
			{
			if (pg.hasAttribute("CMYK"))
				lf.setNamedColor(pg.attribute("CMYK"));
			else
				lf.fromQColor(QColor(pg.attribute("RGB")));
		  doc->PageColors[pg.attribute("NAME")] = lf;
			}
		if(pg.tagName()=="STYLE")
			{
			vg.Vname = pg.attribute("NAME");
			vg.LineSpa = QStoFloat(pg.attribute("LINESP"));
			vg.Indent = QStoFloat(pg.attribute("INDENT","0"));
			vg.First = QStoFloat(pg.attribute("FIRST","0"));
			vg.Ausri = QStoInt(pg.attribute("ALIGN"));
			vg.Avor = QStoFloat(pg.attribute("VOR","0"));
			vg.Anach = QStoFloat(pg.attribute("NACH","0"));			
			doc->Vorlagen.append(vg);
			}
		if(pg.tagName()=="JAVA")
			doc->JavaScripts[pg.attribute("NAME")] = pg.attribute("SCRIPT");
		if(pg.tagName()=="LAYERS")
			{
			la.LNr = QStoInt(pg.attribute("NUMMER"));
			la.Level = QStoInt(pg.attribute("LEVEL"));
			la.Name = pg.attribute("NAME");
			la.Sichtbar = QStoInt(pg.attribute("SICHTBAR"));
			la.Drucken = QStoInt(pg.attribute("DRUCKEN"));			
			doc->Layers.append(la);
			}
		if(pg.tagName()=="PAGE")
		{
			/*
			* Attribute von PAGE auslesen
			*/
			a = QStoInt(pg.attribute("NUM"));
			PgNam = "";
			PgNam = pg.attribute("NAM", "");
			Pgc = doc->PageC;
			AtFl = doc->PageAT;
			if (PgNam == "")
				{
				doc->PageC = Pgc;
				view->Pages = view->DocPages;
				doc->PageAT = AtFl;
				doc->MasterP = false;
				}
			else
				{
				doc->PageC = 0;
				doc->PageAT = false;
				view->Pages = view->MasterPages;
				doc->MasterP = true;
				}
			emit NewPage(a);
			view->Pages.at(a)->LeftPg=QStoInt(pg.attribute("LEFT","0"));
			view->Pages.at(a)->MPageNam=pg.attribute("MNAM","");
			counter = 0;
			QDomNode OBJ=PAGE.firstChild();
			while(!OBJ.isNull())
			{
				QDomElement obj=OBJ.toElement();
				/*
				* Attribute von OBJECT auslesen
				*/
				if (QStoInt(obj.attribute("NEXTITEM")) != -1)
					{
					if (QStoInt(obj.attribute("BACKITEM")) == -1)
						{
						Link.Start = counter;
						Link.StPag = a;
						LFrames.append(Link);
						}
					}
				OB.PType = QStoInt(obj.attribute("PTYPE"));
				OB.Xpos = QStoFloat(obj.attribute("XPOS"));
				OB.Ypos=QStoFloat(obj.attribute("YPOS"));
				OB.Width=QStoFloat(obj.attribute("WIDTH"));
				OB.Height=QStoFloat(obj.attribute("HEIGHT"));
				OB.RadRect = QStoFloat(obj.attribute("RADRECT","0"));
				OB.ClipEdited = QStoInt(obj.attribute("CLIPEDIT", "0"));
				OB.FrameType = QStoInt(obj.attribute("FRTYPE", "0"));
				OB.Pwidth=QStoFloat(obj.attribute("PWIDTH"));
				OB.Pcolor=obj.attribute("PCOLOR");
				OB.Pcolor2=obj.attribute("PCOLOR2");
				OB.Shade=QStoInt(obj.attribute("SHADE"));
				OB.Shade2=QStoInt(obj.attribute("SHADE2"));
				OB.Rot=QStoFloat(obj.attribute("ROT"));
				OB.PLineArt=Qt::PenStyle(QStoInt(obj.attribute("PLINEART")));
				OB.PLineEnd=Qt::PenCapStyle(QStoInt(obj.attribute("PLINEEND","0")));
				OB.PLineJoin=Qt::PenJoinStyle(QStoInt(obj.attribute("PLINEJOIN","0")));
				OB.LineSp=QStoFloat(obj.attribute("LINESP"));
				OB.ExtraV=QStoFloat(obj.attribute("EXTRAV","0"));
				OB.LocalScX=QStoFloat(obj.attribute("LOCALSCX"));
				OB.LocalScY=QStoFloat(obj.attribute("LOCALSCY"));
				OB.LocalX=QStoFloat(obj.attribute("LOCALX"));
				OB.LocalY=QStoFloat(obj.attribute("LOCALY"));
				OB.PicArt=QStoInt(obj.attribute("PICART"));
				OB.flippedH=QStoInt(obj.attribute("FLIPPEDH"));
				OB.flippedV=QStoInt(obj.attribute("FLIPPEDV"));
				OB.BBoxX=QStoFloat(obj.attribute("BBOXX"));
				OB.BBoxH=QStoFloat(obj.attribute("BBOXH"));
				OB.ScaleType = QStoInt(obj.attribute("SCALETYPE","1"));
				OB.AspectRatio = QStoInt(obj.attribute("RATIO","0"));
				OB.isPrintable=QStoInt(obj.attribute("PRINTABLE"));
				OB.isBookmark=QStoInt(obj.attribute("BOOKMARK"));
				OB.isAnnotation=QStoInt(obj.attribute("ANNOTATION","0"));
				OB.AnType = QStoInt(obj.attribute("ANTYPE","0"));
				OB.AnAction = obj.attribute("ANACTION","");
				OB.An_E_act = obj.attribute("ANEACT","");
				OB.An_X_act = obj.attribute("ANXACT","");
				OB.An_D_act = obj.attribute("ANDACT","");
				OB.An_Fo_act = obj.attribute("ANFOACT","");
				OB.An_Bl_act = obj.attribute("ANBLACT","");
				OB.An_K_act = obj.attribute("ANKACT","");
				OB.An_F_act = obj.attribute("ANFACT","");
				OB.An_V_act = obj.attribute("ANVACT","");
				OB.An_C_act = obj.attribute("ANCACT","");
				OB.AnZiel = QStoInt(obj.attribute("ANZIEL","0"));
				OB.AnActType = QStoInt(obj.attribute("ANACTYP","0"));
				OB.AnName = obj.attribute("ANNAME","");
				OB.AnToolTip = obj.attribute("ANTOOLTIP","");
				OB.AnRollOver = obj.attribute("ANROLL","");
				OB.AnDown = obj.attribute("ANDOWN","");
				OB.AnBwid = QStoInt(obj.attribute("ANBWID","1"));
				OB.AnBsty = QStoInt(obj.attribute("ANBSTY","0"));
				OB.AnFeed = QStoInt(obj.attribute("ANFEED","1"));
				OB.AnFlag = QStoInt(obj.attribute("ANFLAG","0"));
				OB.AnFont = QStoInt(obj.attribute("ANFONT","4"));
				OB.AnFormat = QStoInt(obj.attribute("ANFORMAT","0"));
				OB.AnVis = QStoInt(obj.attribute("ANVIS","0"));
				OB.AnIsChk = bool(QStoInt(obj.attribute("ANCHK","0")));
				OB.AnAAact = bool(QStoInt(obj.attribute("ANAA","0")));
				OB.AnHTML = bool(QStoInt(obj.attribute("ANHTML","0")));
				OB.AnUseIcons = bool(QStoInt(obj.attribute("ANICON","0")));
				OB.AnChkStil = QStoInt(obj.attribute("ANCHKS","0"));
				OB.AnMaxChar = QStoInt(obj.attribute("ANMC","-1"));
				OB.AnBColor = obj.attribute("ANBCOL","None");
				OB.AnIPlace = QStoInt(obj.attribute("ANPLACE","1"));
				OB.AnScaleW = QStoInt(obj.attribute("ANSCALE","0"));
				if (QStoInt(obj.attribute("TRANSPARENT","0")) == 1)
					OB.Pcolor = "None";
				OB.Textflow=QStoInt(obj.attribute("TEXTFLOW"));
				OB.Extra=QStoFloat(obj.attribute("EXTRA"));
				OB.PoShow = QStoInt(obj.attribute("PTLSHOW","0"));
				OB.BaseOffs = QStoFloat(obj.attribute("BASEOF","0"));
				OB.Ausrich = QStoInt(obj.attribute("ALIGN","0"));
				OB.IFont = DoFonts[obj.attribute("IFONT")];
				OB.ISize = QStoInt(obj.attribute("ISIZE","12"));
				OB.Pfile=obj.attribute("PFILE");
				OB.Pfile2=obj.attribute("PFILE2","");
				OB.Pfile3=obj.attribute("PFILE3","");
				OB.IProfile=obj.attribute("PRFILE","");
				OB.EmProfile=obj.attribute("EPROF","");
				OB.IRender = QStoInt(obj.attribute("IRENDER","1"));
				OB.UseEmbedded = QStoInt(obj.attribute("EMBEDDED","1"));
				OB.LayerNr = QStoInt(obj.attribute("LAYER","0"));
				if (obj.hasAttribute("NUMCLIP"))
					{
					OB.Clip.resize(obj.attribute("NUMCLIP").toUInt());
					tmp = obj.attribute("CLIPCOOR");
					QTextStream f(&tmp, IO_ReadOnly);
					for (uint c=0; c<obj.attribute("NUMCLIP").toUInt(); c++)
						{
						f >> x;
						f >> y;
						OB.Clip.setPoint(c, x, y);
						}
					}
				else
					OB.Clip.resize(0);
				if (obj.hasAttribute("NUMPO"))
					{
					OB.PoLine.resize(obj.attribute("NUMPO").toUInt());
					tmp = obj.attribute("POCOOR");
						QTextStream fp(&tmp, IO_ReadOnly);
					for (uint cx=0; cx<obj.attribute("NUMPO").toUInt(); cx++)
						{
						fp >> xf;
						fp >> yf;
						OB.PoLine.setPoint(cx, xf, yf);
						}
					}
				else
					OB.PoLine.resize(0);
				tmp = "";
				if ((obj.hasAttribute("GROUPS")) && (QStoInt(obj.attribute("NUMGROUP","0")) != 0))
					{
					tmp = obj.attribute("GROUPS");
					QTextStream fg(&tmp, IO_ReadOnly);
					OB.Groups.clear();
					for (int cx = 0; cx < QStoInt(obj.attribute("NUMGROUP","0")); cx++)
						{
						fg >> x;
						OB.Groups.push(x);
						}
					tmp = "";
					}
				else
					OB.Groups.clear();
				QDomNode IT=OBJ.firstChild();
				while(!IT.isNull())
				{
					QDomElement it=IT.toElement();
					if (it.tagName()=="ITEXT")
						{
						tmp2 = it.attribute("CH");
						tmp3 = "\t" + DoFonts[it.attribute("CFONT")] + "\t";
						tmp3 += it.attribute("CSIZE") + "\t";
						tmp3 += it.attribute("CCOLOR") + "\t";
						tmp3 += it.attribute("CEXTRA") + "\t";
						tmp3 += it.attribute("CSHADE") + "\t";
						tmp3 += it.attribute("CSTYLE") + "\t";
						tmp3 += it.attribute("CAB","0") + "\n";
						for (uint cxx=0; cxx<tmp2.length(); cxx++)
							{
							tmp += tmp2.at(cxx)+tmp3;
							}
						}
					else
						{
						tmp += QString(QChar(QStoInt(it.attribute("CH")))) + "\t";
						tmp += DoFonts[it.attribute("CFONT")] + "\t";
						tmp += it.attribute("CSIZE") + "\t";
						tmp += it.attribute("CCOLOR") + "\t";
						tmp += it.attribute("CEXTRA") + "\t";
						tmp += it.attribute("CSHADE") + "\t";
						tmp += it.attribute("CSTYLE") + "\t";
						tmp += it.attribute("CAB","0") + "\n";
						}
					IT=IT.nextSibling();
				}
				OB.Ptext = tmp;
				int docGc = doc->GroupCounter;
				doc->GroupCounter = 0;
				doc->Dfont = DoFonts[Defont];
				if ((OB.PType == 5) && (OB.Height != 0))
					{
					OB.Rot += atan2(OB.Height,OB.Width)*(180.0/3.1415927);
					OB.Width = sqrt(pow(OB.Width,2)+pow(OB.Height,2));
					OB.Height = 0;
					OB.Clip.setPoints(4, -1,-1, int(OB.Width+1),-1, int(OB.Width+1),int(OB.Height+1), -1,int(OB.Height+1));
					}
				view->Pages.at(a)->PasteItem(&OB, true);
				doc->GroupCounter = docGc;
				Neu = view->Pages.at(a)->Items.at(counter);
				Neu->isAutoText=QStoInt(obj.attribute("AUTOTEXT"));
				if (Neu->isAutoText)
					doc->LastAuto = Neu;
				Neu->NextIt = QStoInt(obj.attribute("NEXTITEM"));
				Neu->NextPg = QStoInt(obj.attribute("NEXTPAGE"));
				counter++;
				OBJ=OBJ.nextSibling();
			}
			if (PgNam == "")
				{
				view->DocPages = view->Pages;
				}
			else
				{
				view->Pages.at(a)->PageNam = PgNam;
				view->MasterNames[PgNam] = a;
				view->MasterPages = view->Pages;
				}
			doc->MasterP = false;
			doc->PageC = Pgc+1;
			doc->PageAT = AtFl;
		}
		PAGE=PAGE.nextSibling();
	}
	DOC=DOC.nextSibling();
}
for (uint ap=0; ap<view->MasterPages.count(); ap++)
	{
	view->MasterPages.at(ap)->parentWidget()->hide();
	}
view->Pages = view->DocPages;
doc->PageC = view->Pages.count();
view->reformPages();
if (doc->Layers.count() == 0)
	{	
	la.LNr = 0;
	la.Level = 0;
	la.Name = tr("Background");
	la.Sichtbar = true;
	la.Drucken = true;			
	doc->Layers.append(la);
	}
if (LFrames.count() != 0)
	{
	PageItem *Its;
	PageItem *Itn;
	PageItem *Itr;
	QValueList<Linked>::Iterator lc;
	for (lc = LFrames.begin(); lc != LFrames.end(); ++lc)
		{
		Its = view->Pages.at((*lc).StPag)->Items.at((*lc).Start);
		Itr = Its;
		Its->BackBox = 0;
		if (Its->isAutoText)
			doc->FirstAuto = Its;
		while (Its->NextIt != -1)
			{
			Itn = view->Pages.at(Its->NextPg)->Items.at(Its->NextIt);
			Its->NextBox = Itn;
			Itn->BackBox = Its;
			Its = Itn;
			}
		Its->NextBox = 0;
		Itr->Dirty = true;
		Itr->paintObj();
		}
	}
if (doc->Einheit == 0)
	view->UN->setText("pt");
else
	view->UN->setText("mm");
dia2->setProgress(DOC.childNodes().count());
return TRUE;
}

bool ScriXmlDoc::ReadElemHeader(QString file, bool isFile, float *x, float *y, float *w, float *h)
{
	QString f;
	QDomDocument docu("scridoc");
	if (isFile)
		{
		if (!loadTextQS(file, &f))
			return false;
		if(!docu.setContent(f))
			return false;
		}
	else
		{
		if(!docu.setContent(file))
			return false;
		}
	QDomElement elem=docu.documentElement();
	if (elem.tagName() != "SCRIBUSELEM")
		return false;
	*x = QStoFloat(elem.attribute("XP"));
	*y = QStoFloat(elem.attribute("YP"));
	*w = QStoFloat(elem.attribute("W","0"));
	*h = QStoFloat(elem.attribute("H","0"));
	return true;
}

bool ScriXmlDoc::ReadElem(QString fileName, SCFonts &avail, ScribusDoc *doc, int Xp, int Yp, bool Fi, bool loc)
{
	struct CLBuf OB;
	struct StVorL vg;
	QString tmp, tmpf, tmp2, tmp3, tmp4, f, tmV;
	QFont fo;
	QMap<QString,QString> DoFonts;
	QMap<uint,QString> DoVorl;
	uint VorlC;
	bool fou;
	bool VorLFound = false;
	int x, y;
	float GrX, GrY, xf, yf;
	int GrMax = doc->GroupCounter;
	CMYKColor lf = CMYKColor();
	QDomDocument docu("scridoc");
	if (Fi)
		{
		if (!loadTextQS(fileName, &f))
			return false;
		if(!docu.setContent(f))
			return false;
		}
	else
		{
		if(!docu.setContent(fileName))
			return FALSE;
		}
	QDomElement elem=docu.documentElement();
	if (elem.tagName() != "SCRIBUSELEM")
		return false;
	if (loc)
		{
		GrX = 0;
		GrY = 0;
		}
	else
		{
		GrX = QStoFloat(elem.attribute("XP"));
		GrY = QStoFloat(elem.attribute("YP"));
		}
	QDomNode DOC=elem.firstChild();
	DoFonts.clear();
	DoVorl.clear();
	VorlC = 5;
	while(!DOC.isNull())
		{
		QDomElement pg=DOC.toElement();
		if(pg.tagName()=="FONT")
			{
			tmpf = pg.attribute("NAME");
			if (!avail.find(tmpf))
				{
				DmF *dia = new DmF(0, tmpf, avail);
				dia->exec();
				tmpf = dia->Ersatz;
				delete dia;
				}
			fo = avail[tmpf]->Font;
			fo.setPointSize(doc->Dsize);
			if(!doc->UsedFonts.contains(tmpf))
				doc->AddFont(tmpf, fo);
			DoFonts[pg.attribute("NAME")] = tmpf;
			}
		if(pg.tagName()=="COLOR")
			{
			if (!doc->PageColors.contains(pg.attribute("NAME")))
				{
				if (pg.hasAttribute("CMYK"))
					lf.setNamedColor(pg.attribute("CMYK"));
				else
					lf.fromQColor(QColor(pg.attribute("RGB")));
		  	doc->PageColors[pg.attribute("NAME")] = lf;
				}
			}
		if(pg.tagName()=="STYLE")
			{
			fou = false;
			VorLFound = true;
			vg.Vname = pg.attribute("NAME");
			vg.LineSpa = QStoFloat(pg.attribute("LINESP"));
			vg.Indent = QStoFloat(pg.attribute("INDENT","0"));
			vg.First = QStoFloat(pg.attribute("FIRST","0"));
			vg.Ausri = QStoInt(pg.attribute("ALIGN"));
			vg.Avor = QStoFloat(pg.attribute("VOR","0"));
			vg.Anach = QStoFloat(pg.attribute("NACH","0"));
			for (uint xx=0; xx<doc->Vorlagen.count(); xx++)
				{
				if (vg.Vname == doc->Vorlagen[xx].Vname)
					{
					DoVorl[VorlC] = tmV.setNum(xx);
					VorlC++;
					fou = true;
					break;
					}
				}
			if (!fou)
				{
				doc->Vorlagen.append(vg);
				DoVorl[VorlC] = tmV.setNum(doc->Vorlagen.count()-1);
				VorlC++;
				}
			}
		DOC=DOC.nextSibling();
		}
	DOC=elem.firstChild();
	while(!DOC.isNull())
		{
		QDomElement pg=DOC.toElement();
		if(pg.tagName()=="ITEM")
			{
			OB.PType = QStoInt(pg.attribute("PTYPE"));
			OB.Xpos = float(Xp) + QStoFloat(pg.attribute("XPOS")) - GrX;
			OB.Ypos = float(Yp) + QStoFloat(pg.attribute("YPOS")) - GrY;
			OB.Width = QStoFloat(pg.attribute("WIDTH"));
			OB.Height = QStoFloat(pg.attribute("HEIGHT"));
			OB.RadRect = QStoFloat(pg.attribute("RADRECT","0"));
			OB.ClipEdited = QStoInt(pg.attribute("CLIPEDIT", "0"));
			OB.FrameType = QStoInt(pg.attribute("FRTYPE", "0"));
			OB.Pwidth = QStoFloat(pg.attribute("PWIDTH"));
			OB.Pcolor = pg.attribute("PCOLOR");
			OB.Pcolor2 = pg.attribute("PCOLOR2");
			OB.Shade = QStoInt(pg.attribute("SHADE"));
			OB.Shade2 = QStoInt(pg.attribute("SHADE2"));
			OB.Rot = QStoFloat(pg.attribute("ROT"));
			OB.PLineArt = Qt::PenStyle(QStoInt(pg.attribute("PLINEART")));
			OB.PLineEnd = Qt::PenCapStyle(QStoInt(pg.attribute("PLINEEND","0")));
			OB.PLineJoin = Qt::PenJoinStyle(QStoInt(pg.attribute("PLINEJOIN","0")));
			OB.LineSp = QStoFloat(pg.attribute("LINESP"));
			OB.ExtraV = QStoFloat(pg.attribute("EXTRAV","0"));
			OB.LocalScX = QStoFloat(pg.attribute("LOCALSCX"));
			OB.LocalScY = QStoFloat(pg.attribute("LOCALSCY"));
			OB.LocalX = QStoFloat(pg.attribute("LOCALX"));
			OB.LocalY = QStoFloat(pg.attribute("LOCALY"));
			OB.PicArt = QStoInt(pg.attribute("PICART"));
			OB.flippedH = QStoInt(pg.attribute("FLIPPEDH"));
			OB.flippedV = QStoInt(pg.attribute("FLIPPEDV"));
			OB.ScaleType = QStoInt(pg.attribute("SCALETYPE","1"));
			OB.AspectRatio = QStoInt(pg.attribute("RATIO","0"));
			OB.BBoxX = QStoFloat(pg.attribute("BBOXX"));
			OB.BBoxH = QStoFloat(pg.attribute("BBOXH"));
			OB.isPrintable = QStoInt(pg.attribute("PRINTABLE"));
			OB.isBookmark = QStoInt(pg.attribute("BOOKMARK"));
			OB.isAnnotation = QStoInt(pg.attribute("ANNOTATION","0"));
			OB.AnType = QStoInt(pg.attribute("ANTYPE","0"));
			OB.AnAction = pg.attribute("ANACTION","");
			OB.An_E_act = pg.attribute("ANEACT","");
			OB.An_X_act = pg.attribute("ANXACT","");
			OB.An_D_act = pg.attribute("ANDACT","");
			OB.An_Fo_act = pg.attribute("ANFOACT","");
			OB.An_Bl_act = pg.attribute("ANBLACT","");
			OB.An_K_act = pg.attribute("ANKACT","");
			OB.An_F_act = pg.attribute("ANFACT","");
			OB.An_V_act = pg.attribute("ANVACT","");
			OB.An_C_act = pg.attribute("ANCACT","");
			OB.AnZiel = QStoInt(pg.attribute("ANZIEL","0"));
			OB.AnActType = QStoInt(pg.attribute("ANACTYP","0"));
			OB.AnName = pg.attribute("ANNAME","");
			OB.AnToolTip = pg.attribute("ANTOOLTIP","");
			OB.AnRollOver = pg.attribute("ANROLL","");
			OB.AnDown = pg.attribute("ANDOWN","");
			OB.AnBwid = QStoInt(pg.attribute("ANBWID","1"));
			OB.AnBsty = QStoInt(pg.attribute("ANBSTY","0"));
			OB.AnFeed = QStoInt(pg.attribute("ANFEED","1"));
			OB.AnFlag = QStoInt(pg.attribute("ANFLAG","0"));
			OB.AnFont = QStoInt(pg.attribute("ANFONT","4"));
			OB.AnFormat = QStoInt(pg.attribute("ANFORMAT","0"));
			OB.AnVis = QStoInt(pg.attribute("ANVIS","0"));
			OB.AnMaxChar = QStoInt(pg.attribute("ANMC","-1"));
			OB.AnIsChk = bool(QStoInt(pg.attribute("ANCHK","0")));
			OB.AnAAact = bool(QStoInt(pg.attribute("ANAA","0")));
			OB.AnHTML = bool(QStoInt(pg.attribute("ANHTML","0")));
			OB.AnUseIcons = bool(QStoInt(pg.attribute("ANICON","0")));
			OB.AnChkStil = QStoInt(pg.attribute("ANCHKS","0"));
			OB.AnIPlace = QStoInt(pg.attribute("ANPLACE","1"));
			OB.AnScaleW = QStoInt(pg.attribute("ANSCALE","0"));
			OB.AnBColor = pg.attribute("ANBCOL","None");
			if (QStoInt(pg.attribute("TRANSPARENT","0")) == 1)
				OB.Pcolor = "None";
			OB.Textflow = QStoInt(pg.attribute("TEXTFLOW"));
			OB.Extra = QStoFloat(pg.attribute("EXTRA"));
			OB.PoShow = QStoInt(pg.attribute("PTLSHOW","0"));
			OB.BaseOffs = QStoFloat(pg.attribute("BASEOF","0"));
			OB.Ausrich = QStoInt(pg.attribute("ALIGN","0"));
			OB.IFont = DoFonts[pg.attribute("IFONT")];
			OB.ISize = QStoInt(pg.attribute("ISIZE","12"));
			OB.Pfile = pg.attribute("PFILE");
			OB.Pfile2 = pg.attribute("PFILE2","");
			OB.Pfile3 = pg.attribute("PFILE3","");
			OB.IProfile = pg.attribute("PRFILE","");
			OB.EmProfile = pg.attribute("EPROF","");
			OB.IRender = QStoInt(pg.attribute("IRENDER","1"));
			OB.UseEmbedded = QStoInt(pg.attribute("EMBEDDED","1"));
			if (pg.hasAttribute("NUMCLIP"))
				{
				OB.Clip.resize(pg.attribute("NUMCLIP").toUInt());
				tmp = pg.attribute("CLIPCOOR");
				QTextStream f(&tmp, IO_ReadOnly);
				for (uint c=0; c<pg.attribute("NUMCLIP").toUInt(); c++)
					{
					f >> x;
					f >> y;
					OB.Clip.setPoint(c, x, y);
					}
				}
			else
				OB.Clip.resize(0);
			if (pg.hasAttribute("NUMPO"))
				{
				OB.PoLine.resize(pg.attribute("NUMPO").toUInt());
				tmp = pg.attribute("POCOOR");
				QTextStream fp(&tmp, IO_ReadOnly);
				for (uint cx=0; cx<pg.attribute("NUMPO").toUInt(); cx++)
					{
					fp >> xf;
					fp >> yf;
					OB.PoLine.setPoint(cx, xf, yf);
					}
				}
			else
				OB.PoLine.resize(0);
			tmp = "";
			if ((pg.hasAttribute("GROUPS")) && (QStoInt(pg.attribute("NUMGROUP","0")) != 0))
				{
				tmp = pg.attribute("GROUPS");
				QTextStream fg(&tmp, IO_ReadOnly);
				OB.Groups.clear();
				for (int cx = 0; cx < QStoInt(pg.attribute("NUMGROUP","0")); cx++)
					{
					fg >> x;
					OB.Groups.push(x+doc->GroupCounter);
					GrMax = QMAX(GrMax, x+doc->GroupCounter);
					}
				tmp = "";
				}
			else
				OB.Groups.clear();
			tmp = "";
			QDomNode IT=DOC.firstChild();
			while(!IT.isNull())
				{
				QDomElement it=IT.toElement();
				if (it.tagName()=="ITEXT")
						{
						tmp2 = it.attribute("CH");
						tmp3 = "\t" + DoFonts[it.attribute("CFONT")] + "\t";
						tmp3 += it.attribute("CSIZE") + "\t";
						tmp3 += it.attribute("CCOLOR") + "\t";
						tmp3 += it.attribute("CEXTRA") + "\t";
						tmp3 += it.attribute("CSHADE") + "\t";
						tmp3 += it.attribute("CSTYLE") + "\t";
						if (VorLFound)
							tmp3 += DoVorl[it.attribute("CAB","0").toUInt()] + "\n";
						else
							{
							if (it.attribute("CAB","0").toUInt() < 5)
								tmp3 += it.attribute("CAB","0")+"\n";
							else
								tmp3 += "0\n";
								}
						for (uint cxx=0; cxx<tmp2.length(); cxx++)
							{
							tmp += tmp2.at(cxx)+tmp3;
							}
						}
					else
						{
						tmp += QString(QChar(QStoInt(it.attribute("CH")))) + "\t";
						tmp += DoFonts[it.attribute("CFONT")] + "\t";
						tmp += it.attribute("CSIZE") + "\t";
						tmp += it.attribute("CCOLOR") + "\t";
						tmp += it.attribute("CEXTRA") + "\t";
						tmp += it.attribute("CSHADE") + "\t";
						tmp += it.attribute("CSTYLE") + "\t";
						if ((VorLFound) || (it.attribute("CAB","0").toUInt() < 5))
							tmp3 += DoVorl[it.attribute("CAB","0").toUInt()] + "\n";
						else
							{
							if (it.attribute("CAB","0").toUInt() < 5)
								tmp3 += it.attribute("CAB","0")+"\n";
							else
								tmp3 += "0\n";
							}
						}
					IT=IT.nextSibling();
				}
			OB.Ptext = tmp;
			if ((OB.PType == 5) && (OB.Height != 0))
				{
				OB.Rot += atan2(OB.Height,OB.Width)*(180.0/3.1415927);
				OB.Width = sqrt(pow(OB.Width,2)+pow(OB.Height,2));
				OB.Height = 0;
				OB.Clip.setPoints(4, -1,-1, int(OB.Width+1),-1, int(OB.Width+1),int(OB.Height+1), -1,int(OB.Height+1));
				}
			OB.LayerNr = -1;
			doc->ActPage->PasteItem(&OB, true);
			}
		DOC=DOC.nextSibling();
		}
	doc->GroupCounter = GrMax + 1;
	return TRUE;
}

QString ScriXmlDoc::WriteElem(QPtrList<PageItem> *Selitems, ScribusDoc *doc)
{
	int ts, ts2, tsh, tsh2, tst, tst2, tsb, tsb2;
	QString text, tf, tf2, tc, tc2, tmp;
	float te, te2, xf, yf;
	PageItem *item;
	QDomDocument docu("scribus");
	QString st="<SCRIBUSELEM></SCRIBUSELEM>";
	docu.setContent(st);
	QDomElement elem=docu.documentElement();
	item = Selitems->at(0);
	QValueList<uint> ELL;
	for (uint cor=0; cor<Selitems->count(); cor++)
		{
		ELL.append(Selitems->at(cor)->ItemNr);
		}
	qHeapSort(ELL);
	if (doc->ActPage->GroupSel)
		{
		elem.setAttribute("XP", doc->ActPage->GroupX);
		elem.setAttribute("YP", doc->ActPage->GroupY);
		elem.setAttribute("W", doc->ActPage->GroupW);
		elem.setAttribute("H", doc->ActPage->GroupH);
		}
	else
		{
		elem.setAttribute("XP", item->Xpos);
		elem.setAttribute("YP", item->Ypos);
		elem.setAttribute("W", item->Width);
		elem.setAttribute("H", item->Height);
		}
	elem.setAttribute("COUNT", Selitems->count());	
	for (uint co=0; co<Selitems->count(); co++)
		{
		item = doc->ActPage->Items.at(ELL[co]);
		QDomElement ob=docu.createElement("ITEM");
		ob.setAttribute("PTYPE",item->PType);
		ob.setAttribute("XPOS",item->Xpos);
		ob.setAttribute("YPOS",item->Ypos);
		ob.setAttribute("WIDTH",item->Width);
		ob.setAttribute("HEIGHT",item->Height);
		ob.setAttribute("RADRECT",item->RadRect);
		ob.setAttribute("FRTYPE", item->FrameType);
		if(item->ClipEdited)
			ob.setAttribute("CLIPEDIT",1);
		else
			ob.setAttribute("CLIPEDIT",0);
		ob.setAttribute("PWIDTH",item->Pwidth);
		ob.setAttribute("PCOLOR",item->Pcolor);
		ob.setAttribute("PCOLOR2",item->Pcolor2);
		ob.setAttribute("SHADE",item->Shade);
		ob.setAttribute("SHADE2",item->Shade2);
		ob.setAttribute("ROT",item->Rot);
		ob.setAttribute("PLINEART",item->PLineArt);
		ob.setAttribute("PLINEEND", item->PLineEnd);
		ob.setAttribute("PLINEJOIN", item->PLineJoin);
		ob.setAttribute("LINESP",item->LineSp);
		ob.setAttribute("EXTRAV",item->ExtraV);
		ob.setAttribute("LOCALSCX",item->LocalScX);
		ob.setAttribute("LOCALSCY",item->LocalScY);
		ob.setAttribute("LOCALX",item->LocalX);
		ob.setAttribute("LOCALY",item->LocalY);
		if(item->PicArt)
			ob.setAttribute("PICART",1);
		else
			ob.setAttribute("PICART",0);
		if(item->PoShow)
			ob.setAttribute("PTLSHOW",1);
		else
			ob.setAttribute("PTLSHOW",0);
		ob.setAttribute("BASEOF", item->BaseOffs);
		ob.setAttribute("FLIPPEDH",item->flippedH);
		ob.setAttribute("FLIPPEDV",item->flippedV);
		ob.setAttribute("BBOXX",item->BBoxX);
		ob.setAttribute("BBOXH",item->BBoxH);
		if(item->ScaleType)
			ob.setAttribute("SCALETYPE", 1);
		else
			ob.setAttribute("SCALETYPE", 0);
		if(item->AspectRatio)
			ob.setAttribute("RATIO", 1);
		else
			ob.setAttribute("RATIO", 0);
		if(item->isPrintable)
			ob.setAttribute("PRINTABLE",1);
		else
			ob.setAttribute("PRINTABLE",0);
		if(item->isBookmark)
			ob.setAttribute("BOOKMARK",1);
		else
			ob.setAttribute("BOOKMARK",0);
		if(item->isAnnotation)
			{
			ob.setAttribute("ANNOTATION",1);
			ob.setAttribute("ANTYPE", item->AnType);
			ob.setAttribute("ANACTION", item->AnAction);
			ob.setAttribute("ANEACT", item->An_E_act);
			ob.setAttribute("ANXACT", item->An_X_act);
			ob.setAttribute("ANDACT", item->An_D_act);
			ob.setAttribute("ANFOACT", item->An_Fo_act);
			ob.setAttribute("ANBLACT", item->An_Bl_act);
			ob.setAttribute("ANKACT", item->An_K_act);
			ob.setAttribute("ANFACT", item->An_F_act);
			ob.setAttribute("ANVACT", item->An_V_act);
			ob.setAttribute("ANCACT", item->An_C_act);
			ob.setAttribute("ANZIEL", item->AnZiel);
			ob.setAttribute("ANACTYP", item->AnActType);
			ob.setAttribute("ANTOOLTIP", item->AnToolTip);
			ob.setAttribute("ANBWID", item->AnBwid);
			ob.setAttribute("ANBSTY", item->AnBsty);
			ob.setAttribute("ANFEED", item->AnFeed);
			ob.setAttribute("ANFLAG", item->AnFlag);
			ob.setAttribute("ANFONT", item->AnFont);
			ob.setAttribute("ANFORMAT", item->AnFormat);
			ob.setAttribute("ANROLL", item->AnRollOver);
			ob.setAttribute("ANDOWN", item->AnDown);
			ob.setAttribute("ANVIS", item->AnVis);
			ob.setAttribute("ANMC", item->AnMaxChar);
			ob.setAttribute("ANCHK", item->AnIsChk);
			ob.setAttribute("ANAA", item->AnAAact);
			ob.setAttribute("ANCHKS", item->AnChkStil);
			ob.setAttribute("ANBCOL", item->AnBColor);
			ob.setAttribute("ANHTML", item->AnHTML);
			ob.setAttribute("ANICON", item->AnUseIcons);
			ob.setAttribute("ANPLACE", item->AnIPlace);
			ob.setAttribute("ANSCALE", item->AnScaleW);
			}
		else
			ob.setAttribute("ANNOTATION",0);
		ob.setAttribute("ANNAME", item->AnName);
		if(item->Textflow)
			ob.setAttribute("TEXTFLOW",1);
		else
			ob.setAttribute("TEXTFLOW",0);
		if(item->isAutoText)
			ob.setAttribute("AUTOTEXT",1);
		else
			ob.setAttribute("AUTOTEXT",0);
		ob.setAttribute("EXTRA",item->Extra);
		ob.setAttribute("ALIGN",item->Ausrich);
		ob.setAttribute("IFONT",item->IFont);
		ob.setAttribute("ISIZE",item->ISize);
		if (item->Pfile != "")
			ob.setAttribute("PFILE",item->Pfile);
		else
			ob.setAttribute("PFILE","");
		if (item->Pfile2 != "")
			ob.setAttribute("PFILE2",item->Pfile2);
		else
			ob.setAttribute("PFILE2","");
		if (item->Pfile3 != "")
			ob.setAttribute("PFILE3",item->Pfile3);
		else
			ob.setAttribute("PFILE3","");
		ob.setAttribute("PRFILE",item->IProfile);
		ob.setAttribute("EPROF", item->EmProfile);
		ob.setAttribute("IRENDER",item->IRender);
		if(item->UseEmbedded)
			ob.setAttribute("EMBEDDED",1);
		else
			ob.setAttribute("EMBEDDED",0);
		for(uint k=0;k<item->Ptext.count();k++)
			{
			QDomElement it=docu.createElement("ITEXT");
			ts = item->Ptext.at(k)->csize;
			tf = item->Ptext.at(k)->cfont;
			tc = item->Ptext.at(k)->ccolor;
			te = item->Ptext.at(k)->cextra;
			tsh = item->Ptext.at(k)->cshade;
			tst = item->Ptext.at(k)->cstyle;
			tsb = item->Ptext.at(k)->cab;
			text = item->Ptext.at(k)->ch;
			k++;
			if (k == item->Ptext.count())
				{
				it.setAttribute("CH",text);
				it.setAttribute("CSIZE",ts);
				it.setAttribute("CFONT",tf);
				it.setAttribute("CCOLOR",tc);
				it.setAttribute("CEXTRA",te);
				it.setAttribute("CSHADE",tsh);
				it.setAttribute("CSTYLE",tst);
				it.setAttribute("CAB",tsb);
				ob.appendChild(it);
				break;
				}
			ts2 = item->Ptext.at(k)->csize;
			tf2 = item->Ptext.at(k)->cfont;
			tc2 = item->Ptext.at(k)->ccolor;
			te2 = item->Ptext.at(k)->cextra;
			tsh2 = item->Ptext.at(k)->cshade;
			tst2 = item->Ptext.at(k)->cstyle;
			tsb2 = item->Ptext.at(k)->cab;
			while ((ts2 == ts) && (tsb2 == tsb) && (tf2 == tf) && (tc2 == tc) && (te2 == te) && (tsh2 == tsh) && (tst2 == tst))
				{
				text += item->Ptext.at(k)->ch;
				k++;
				if (k == item->Ptext.count())
					break;
				ts2 = item->Ptext.at(k)->csize;
				tf2 = item->Ptext.at(k)->cfont;
				tc2 = item->Ptext.at(k)->ccolor;
				te2 = item->Ptext.at(k)->cextra;
				tsh2 = item->Ptext.at(k)->cshade;
				tst2 = item->Ptext.at(k)->cstyle;
				tsb2 = item->Ptext.at(k)->cab;
				}
			it.setAttribute("CH",text);
			it.setAttribute("CSIZE",ts);
			it.setAttribute("CFONT",tf);
			it.setAttribute("CCOLOR",tc);
			it.setAttribute("CEXTRA",te);
			it.setAttribute("CSHADE",tsh);
			it.setAttribute("CSTYLE",tst);
			it.setAttribute("CAB",tsb);
			k--;
			ob.appendChild(it);
			}
		ob.setAttribute("NUMTEXT",item->Ptext.count());
		QString txnu = "";
		for(uint kt=0;kt<item->Ptext.count();kt++)
			{
			txnu += tmp.setNum(item->Ptext.at(kt)->xp) + " " + tmp.setNum(item->Ptext.at(kt)->yp) + " ";
			}
		ob.setAttribute("TEXTCOOR", txnu);
		ob.setAttribute("NUMGROUP",item->Groups.count());
		QString glp = "";
		QValueStack<int>::Iterator nx;
		for (nx = item->Groups.begin(); nx != item->Groups.end(); ++nx)
			{
			glp += tmp.setNum((*nx)) + " ";
			}
		ob.setAttribute("GROUPS", glp);
		ob.setAttribute("NUMPO",item->PoLine.size());
		QString polp = "";
		for (uint nxx=0; nxx<item->PoLine.size(); nxx++)
			{
			item->PoLine.point(nxx, &xf, &yf);
			polp += tmp.setNum(xf) + " " + tmp.setNum(yf) + " ";
			}
		ob.setAttribute("POCOOR", polp);
		ob.setAttribute("BACKITEM", -1);
		ob.setAttribute("BACKPAGE", -1);
		ob.setAttribute("NEXTITEM", -1);
		ob.setAttribute("NEXTPAGE", -1);
		elem.appendChild(ob);
		}
	QMap<QString,QFont>::Iterator itf;
	for (itf = doc->UsedFonts.begin(); itf != doc->UsedFonts.end(); ++itf)
		{
		QDomElement fn=docu.createElement("FONT");
		fn.setAttribute("NAME",itf.key());
		elem.appendChild(fn);
		}
	CListe::Iterator itc;
	for (itc = doc->PageColors.begin(); itc != doc->PageColors.end(); ++itc)
		{
		QDomElement co=docu.createElement("COLOR");
		co.setAttribute("NAME",itc.key());
		co.setAttribute("RGB",doc->PageColors[itc.key()].getRGBColor().name());
		co.setAttribute("CMYK",doc->PageColors[itc.key()].name());
		elem.appendChild(co);
		}
	if (doc->Vorlagen.count() > 5)
		{
		for (uint ff = 5; ff < doc->Vorlagen.count(); ff++)
			{
			QDomElement fo=docu.createElement("STYLE");
			fo.setAttribute("NAME",doc->Vorlagen[ff].Vname);
			fo.setAttribute("ALIGN",doc->Vorlagen[ff].Ausri);
			fo.setAttribute("LINESP",doc->Vorlagen[ff].LineSpa);
			fo.setAttribute("INDENT",doc->Vorlagen[ff].Indent);
			fo.setAttribute("FIRST",doc->Vorlagen[ff].First);
			fo.setAttribute("VOR",doc->Vorlagen[ff].Avor);
			fo.setAttribute("NACH",doc->Vorlagen[ff].Anach);
			elem.appendChild(fo);
			}
		}
	return docu.toString();
}

void ScriXmlDoc::WritePages(ScribusView *view, QDomDocument docu, QDomElement dc, QProgressBar *dia2, uint maxC)
{
int ts, ts2, tsh, tsh2, tst, tst2, tsb, tsb2;
QString text, tf, tf2, tc, tc2, tmp;
float te, te2, xf, yf;
uint ObCount = maxC;
Page *page;
PageItem *item;
for(uint i=0;i<view->Pages.count();i++)
{
	ObCount++;
	dia2->setProgress(ObCount);
	page = view->Pages.at(i);
	QDomElement pg=docu.createElement("PAGE");
	pg.setAttribute("NUM",page->PageNr);
	pg.setAttribute("NAM",page->PageNam);
	pg.setAttribute("MNAM",page->MPageNam);
	if (page->LeftPg)
		pg.setAttribute("LEFT", 1);
	else
		pg.setAttribute("LEFT", 0);
	for(uint j=0;j<page->Items.count();j++)
	{
		item = page->Items.at(j);
		QDomElement ob=docu.createElement("PAGEOBJECT");
		ob.setAttribute("PTYPE",item->PType);
		ob.setAttribute("XPOS",item->Xpos);
		ob.setAttribute("YPOS",item->Ypos);
		ob.setAttribute("WIDTH",item->Width);
		ob.setAttribute("HEIGHT",item->Height);
		ob.setAttribute("RADRECT",item->RadRect);
		ob.setAttribute("FRTYPE", item->FrameType);
		if(item->ClipEdited)
			ob.setAttribute("CLIPEDIT",1);
		else
			ob.setAttribute("CLIPEDIT",0);
		ob.setAttribute("PWIDTH",item->Pwidth);
		ob.setAttribute("PCOLOR",item->Pcolor);
		ob.setAttribute("PCOLOR2",item->Pcolor2);
		ob.setAttribute("SHADE",item->Shade);
		ob.setAttribute("SHADE2",item->Shade2);
		ob.setAttribute("ROT",item->Rot);
		ob.setAttribute("PLINEART",item->PLineArt);
		ob.setAttribute("PLINEEND", item->PLineEnd);
		ob.setAttribute("PLINEJOIN", item->PLineJoin);
		ob.setAttribute("LINESP",item->LineSp);
		ob.setAttribute("EXTRAV",item->ExtraV);
		ob.setAttribute("LOCALSCX",item->LocalScX);
		ob.setAttribute("LOCALSCY",item->LocalScY);
		ob.setAttribute("LOCALX",item->LocalX);
		ob.setAttribute("LOCALY",item->LocalY);
		if(item->PicArt)
			ob.setAttribute("PICART",1);
		else
			ob.setAttribute("PICART",0);
		if(item->PoShow)
			ob.setAttribute("PTLSHOW",1);
		else
			ob.setAttribute("PTLSHOW",0);
		ob.setAttribute("BASEOF", item->BaseOffs);
		ob.setAttribute("FLIPPEDH",item->flippedH);
		ob.setAttribute("FLIPPEDV",item->flippedV);
		ob.setAttribute("BBOXX",item->BBoxX);
		ob.setAttribute("BBOXH",item->BBoxH);
		ob.setAttribute("ALIGN",item->Ausrich);
		ob.setAttribute("IFONT",item->IFont);
		ob.setAttribute("ISIZE",item->ISize);
		if(item->ScaleType)
			ob.setAttribute("SCALETYPE", 1);
		else
			ob.setAttribute("SCALETYPE", 0);
		if(item->AspectRatio)
			ob.setAttribute("RATIO", 1);
		else
			ob.setAttribute("RATIO", 0);
		if(item->isPrintable)
			ob.setAttribute("PRINTABLE",1);
		else
			ob.setAttribute("PRINTABLE",0);
		if(item->isBookmark)
			ob.setAttribute("BOOKMARK",1);
		else
			ob.setAttribute("BOOKMARK",0);
		if(item->isAnnotation)
			{
			ob.setAttribute("ANNOTATION",1);
			ob.setAttribute("ANTYPE", item->AnType);
			ob.setAttribute("ANACTION", item->AnAction);
			ob.setAttribute("ANEACT", item->An_E_act);
			ob.setAttribute("ANXACT", item->An_X_act);
			ob.setAttribute("ANDACT", item->An_D_act);
			ob.setAttribute("ANFOACT", item->An_Fo_act);
			ob.setAttribute("ANBLACT", item->An_Bl_act);
			ob.setAttribute("ANKACT", item->An_K_act);
			ob.setAttribute("ANFACT", item->An_F_act);
			ob.setAttribute("ANVACT", item->An_V_act);
			ob.setAttribute("ANCACT", item->An_C_act);
			ob.setAttribute("ANZIEL", item->AnZiel);
			ob.setAttribute("ANACTYP", item->AnActType);
			ob.setAttribute("ANTOOLTIP", item->AnToolTip);
			ob.setAttribute("ANBWID", item->AnBwid);
			ob.setAttribute("ANBSTY", item->AnBsty);
			ob.setAttribute("ANFEED", item->AnFeed);
			ob.setAttribute("ANFLAG", item->AnFlag);
			ob.setAttribute("ANFONT", item->AnFont);
			ob.setAttribute("ANFORMAT", item->AnFormat);
			ob.setAttribute("ANROLL", item->AnRollOver);
			ob.setAttribute("ANDOWN", item->AnDown);
			ob.setAttribute("ANVIS", item->AnVis);
			ob.setAttribute("ANMC", item->AnMaxChar);
			ob.setAttribute("ANCHK", item->AnIsChk);
			ob.setAttribute("ANAA", item->AnAAact);
			ob.setAttribute("ANCHKS", item->AnChkStil);
			ob.setAttribute("ANBCOL", item->AnBColor);
			ob.setAttribute("ANHTML", item->AnHTML);
			ob.setAttribute("ANICON", item->AnUseIcons);
			ob.setAttribute("ANPLACE", item->AnIPlace);
			ob.setAttribute("ANSCALE", item->AnScaleW);
			}
		else
			ob.setAttribute("ANNOTATION",0);
		ob.setAttribute("ANNAME", item->AnName);
		if(item->Textflow)
			ob.setAttribute("TEXTFLOW",1);
		else
			ob.setAttribute("TEXTFLOW",0);
		if(item->isAutoText)
			ob.setAttribute("AUTOTEXT",1);
		else
			ob.setAttribute("AUTOTEXT",0);
		ob.setAttribute("EXTRA",item->Extra);
		if (item->Pfile != "")
			ob.setAttribute("PFILE",item->Pfile);
		else
			ob.setAttribute("PFILE","");
		if (item->Pfile2 != "")
			ob.setAttribute("PFILE2",item->Pfile2);
		else
			ob.setAttribute("PFILE2","");
		if (item->Pfile3 != "")
			ob.setAttribute("PFILE3",item->Pfile3);
		else
			ob.setAttribute("PFILE3","");
		ob.setAttribute("PRFILE",item->IProfile);
		ob.setAttribute("EPROF", item->EmProfile);
		ob.setAttribute("IRENDER",item->IRender);
		if(item->UseEmbedded)
			ob.setAttribute("EMBEDDED",1);
		else
			ob.setAttribute("EMBEDDED",0);
		for(uint k=0;k<item->Ptext.count();k++)
			{
			QDomElement it=docu.createElement("ITEXT");
			ts = item->Ptext.at(k)->csize;
			tf = item->Ptext.at(k)->cfont;
			tc = item->Ptext.at(k)->ccolor;
			te = item->Ptext.at(k)->cextra;
			tsh = item->Ptext.at(k)->cshade;
			tst = item->Ptext.at(k)->cstyle;
			tsb = item->Ptext.at(k)->cab;
			text = item->Ptext.at(k)->ch;
			k++;
			if (k == item->Ptext.count())
				{
				it.setAttribute("CH",text);
				it.setAttribute("CSIZE",ts);
				it.setAttribute("CFONT",tf);
				it.setAttribute("CCOLOR",tc);
				it.setAttribute("CEXTRA",te);
				it.setAttribute("CSHADE",tsh);
				it.setAttribute("CSTYLE",tst);
				it.setAttribute("CAB",tsb);
				ob.appendChild(it);
				break;
				}
			ts2 = item->Ptext.at(k)->csize;
			tf2 = item->Ptext.at(k)->cfont;
			tc2 = item->Ptext.at(k)->ccolor;
			te2 = item->Ptext.at(k)->cextra;
			tsh2 = item->Ptext.at(k)->cshade;
			tst2 = item->Ptext.at(k)->cstyle;
			tsb2 = item->Ptext.at(k)->cab;
			while ((ts2 == ts) && (tsb2 == tsb) && (tf2 == tf) && (tc2 == tc) && (te2 == te) && (tsh2 == tsh) && (tst2 == tst))
				{
				text += item->Ptext.at(k)->ch;
				k++;
				if (k == item->Ptext.count())
					break;
				ts2 = item->Ptext.at(k)->csize;
				tf2 = item->Ptext.at(k)->cfont;
				tc2 = item->Ptext.at(k)->ccolor;
				te2 = item->Ptext.at(k)->cextra;
				tsh2 = item->Ptext.at(k)->cshade;
				tst2 = item->Ptext.at(k)->cstyle;
				tsb2 = item->Ptext.at(k)->cab;
				}
			it.setAttribute("CH",text);
			it.setAttribute("CSIZE",ts);
			it.setAttribute("CFONT",tf);
			it.setAttribute("CCOLOR",tc);
			it.setAttribute("CEXTRA",te);
			it.setAttribute("CSHADE",tsh);
			it.setAttribute("CSTYLE",tst);
			it.setAttribute("CAB",tsb);
			k--;
			ob.appendChild(it);
			}
		ob.setAttribute("NUMGROUP",item->Groups.count());
		QString glp = "";
		QValueStack<int>::Iterator nx;
		for (nx = item->Groups.begin(); nx != item->Groups.end(); ++nx)
			{
			glp += tmp.setNum((*nx)) + " ";
			}
		ob.setAttribute("GROUPS", glp);
		ob.setAttribute("NUMPO",item->PoLine.size());
		QString polp = "";
		for (uint nxx=0; nxx<item->PoLine.size(); nxx++)
			{
			item->PoLine.point(nxx, &xf, &yf);
			polp += tmp.setNum(xf) + " " + tmp.setNum(yf) + " ";
			}
		ob.setAttribute("POCOOR", polp);
		if (item->BackBox != 0)
			{
			ob.setAttribute("BACKITEM", item->BackBox->ItemNr);
			ob.setAttribute("BACKPAGE", item->BackBox->OwnPage->PageNr);
			}
		else
			{
			ob.setAttribute("BACKITEM", -1);
			ob.setAttribute("BACKPAGE", -1);
			}
		if (item->NextBox != 0)
			{
			ob.setAttribute("NEXTITEM", item->NextBox->ItemNr);
			ob.setAttribute("NEXTPAGE", item->NextBox->OwnPage->PageNr);
			}
		else
			{
			ob.setAttribute("NEXTITEM", -1);
			ob.setAttribute("NEXTPAGE", -1);
			}
		ob.setAttribute("LAYER", item->LayerNr);
		pg.appendChild(ob);
	}
	dc.appendChild(pg);
}
}

bool ScriXmlDoc::WriteDoc(QString fileName, ScribusDoc *doc, ScribusView *view, QProgressBar *dia2)
{
QString text, tf, tf2, tc, tc2;
QDomDocument docu("scribus");
QString st="<SCRIBUS></SCRIBUS>";
docu.setContent(st);
QDomElement elem=docu.documentElement();
QDomElement dc=docu.createElement("DOCUMENT");
dc.setAttribute("ANZPAGES",doc->PageC);
dc.setAttribute("PAGEWITH",doc->PageB);
dc.setAttribute("PAGEHEIGHT",doc->PageH);
dc.setAttribute("BORDERLEFT",doc->PageM.Left);
dc.setAttribute("BORDERRIGHT",doc->PageM.Right);
dc.setAttribute("BORDERTOP",doc->PageM.Top);
dc.setAttribute("BORDERBOTTOM",doc->PageM.Bottom);
dc.setAttribute("ORIENTATION",doc->PageOri);
dc.setAttribute("FIRSTNUM",doc->FirstPnum);
if(doc->PageFP)
	dc.setAttribute("BOOK",1);
if(doc->FirstPageLeft)
	dc.setAttribute("FIRSTLEFT",1);
if(doc->PageAT)
	dc.setAttribute("AUTOTEXT",1);
dc.setAttribute("AUTOSPALTEN",doc->PageSp);
dc.setAttribute("ABSTSPALTEN",doc->PageSpa);
dc.setAttribute("UNITS",doc->Einheit);
dc.setAttribute("DFONT",doc->Dfont);
dc.setAttribute("DSIZE",doc->Dsize);
dc.setAttribute("AUTHOR",doc->DocAutor);
dc.setAttribute("COMMENTS",doc->DocComments);
dc.setAttribute("TITLE",doc->DocTitel);
dc.setAttribute("VHOCH",doc->VHoch);
dc.setAttribute("VHOCHSC",doc->VHochSc);
dc.setAttribute("VTIEF",doc->VTief);
dc.setAttribute("VTIEFSC",doc->VTiefSc);
dc.setAttribute("VKAPIT",doc->VKapit);
dc.setAttribute("GROUPC",doc->GroupCounter);
dc.setAttribute("HCMS",int(doc->HasCMS));
dc.setAttribute("DPSo",int(doc->CMSSettings.SoftProofOn));
dc.setAttribute("DPuse",int(doc->CMSSettings.CMSinUse));
dc.setAttribute("DPgam",int(doc->CMSSettings.GamutCheck));
dc.setAttribute("DPMo",doc->CMSSettings.DefaultMonitorProfile);
dc.setAttribute("DPPr",doc->CMSSettings.DefaultPrinterProfile);
dc.setAttribute("DPIn",doc->CMSSettings.DefaultInputProfile);
dc.setAttribute("DPIn2",doc->CMSSettings.DefaultInputProfile2);
dc.setAttribute("DIPr",doc->CMSSettings.DefaultIntentPrinter);
dc.setAttribute("DIMo",doc->CMSSettings.DefaultIntentMonitor);
dc.setAttribute("DIMo2",doc->CMSSettings.DefaultIntentMonitor2);
dc.setAttribute("ALAYER", doc->ActiveLayer);
QMap<QString,QString>::Iterator itja;
for (itja = doc->JavaScripts.begin(); itja != doc->JavaScripts.end(); ++itja)
	{
	QDomElement jav=docu.createElement("JAVA");
	jav.setAttribute("NAME",itja.key());
	jav.setAttribute("SCRIPT",itja.data());
	dc.appendChild(jav);
	}
QMap<QString,QFont>::Iterator itf;
for (itf = doc->UsedFonts.begin(); itf != doc->UsedFonts.end(); ++itf)
	{
	QDomElement fn=docu.createElement("FONT");
	fn.setAttribute("NAME",itf.key());
	dc.appendChild(fn);
	}
CListe::Iterator itc;
for (itc = doc->PageColors.begin(); itc != doc->PageColors.end(); ++itc)
	{
	QDomElement co=docu.createElement("COLOR");
	co.setAttribute("NAME",itc.key());
	co.setAttribute("RGB",doc->PageColors[itc.key()].getRGBColor().name());
	co.setAttribute("CMYK",doc->PageColors[itc.key()].name());
	dc.appendChild(co);
	}
if (doc->Vorlagen.count() > 5)
	{
	for (uint ff = 5; ff < doc->Vorlagen.count(); ff++)
		{
		QDomElement fo=docu.createElement("STYLE");
		fo.setAttribute("NAME",doc->Vorlagen[ff].Vname);
		fo.setAttribute("ALIGN",doc->Vorlagen[ff].Ausri);
		fo.setAttribute("LINESP",doc->Vorlagen[ff].LineSpa);
		fo.setAttribute("INDENT",doc->Vorlagen[ff].Indent);
		fo.setAttribute("FIRST",doc->Vorlagen[ff].First);
		fo.setAttribute("VOR",doc->Vorlagen[ff].Avor);
		fo.setAttribute("NACH",doc->Vorlagen[ff].Anach);
		dc.appendChild(fo);
		}
	}
for (uint lay = 0; lay < doc->Layers.count(); lay++)
	{
	QDomElement la = docu.createElement("LAYERS");
	la.setAttribute("NUMMER",doc->Layers[lay].LNr);
	la.setAttribute("LEVEL",doc->Layers[lay].Level);
	la.setAttribute("NAME",doc->Layers[lay].Name);
	la.setAttribute("SICHTBAR",int(doc->Layers[lay].Sichtbar));
	la.setAttribute("DRUCKEN",int(doc->Layers[lay].Drucken));
	dc.appendChild(la);
	}
dia2->setTotalSteps(view->Pages.count()+view->MasterPages.count());
dia2->setProgress(0);
WritePages(view, docu, dc, dia2, 0);
view->DocPages = view->Pages;
view->Pages = view->MasterPages;
WritePages(view, docu, dc, dia2, view->DocPages.count());
view->Pages = view->DocPages;
elem.appendChild(dc);
/**
 * changed to enable saving
 * of *.gz documents
 * 2.7.2002 C.Toepp
 * <c.toepp@gmx.de>
*/
#ifdef HAVE_LIBZ
if(fileName.right(2) == "gz")
	{
  // zipped saving
	gzFile gzDoc = gzopen(fileName.latin1(),"wb");
	if(gzDoc == NULL)
		return false;
	gzputs(gzDoc, docu.toString().latin1());
	gzclose(gzDoc);
	}
else
	{
	QFile f(fileName);
	if(!f.open(IO_WriteOnly))
		return FALSE;
	QTextStream s(&f);
	s<<docu.toString();
	f.close();
	}
#else
QFile f(fileName);
if(!f.open(IO_WriteOnly))
	return FALSE;
QTextStream s(&f);
s<<docu.toString();
f.close();
#endif
return TRUE;
}

void ScriXmlDoc::WritePref(preV *Vor)
{
	QDomDocument docu("scribusrc");
	QString st="<SCRIBUSRC></SCRIBUSRC>";
	docu.setContent(st);
	QDomElement elem=docu.documentElement();
	QDomElement dc=docu.createElement("GUI");
	dc.setAttribute("STILT",Vor->GUI);
	dc.setAttribute("RAD",Vor->Wheelval);
	dc.setAttribute("APF",Vor->AppFontSize);
	dc.setAttribute("GRAB",Vor->GrabRad);
	dc.setAttribute("UNIT",Vor->Einheit);
	dc.setAttribute("SBS", Vor->PagesSbS);
	dc.setAttribute("FRV", Vor->ShFrames);
	dc.setAttribute("RCD", Vor->RecentDCount);
	elem.appendChild(dc);
	QDomElement dc1=docu.createElement("GRID");
	dc1.setAttribute("MINOR",Vor->DminGrid);
	dc1.setAttribute("MAJOR",Vor->DmajGrid);
	dc1.setAttribute("MINORC",Vor->DminColor.name());
	dc1.setAttribute("MAJORC",Vor->DmajColor.name());
	if (Vor->Before)
		dc1.setAttribute("BACKG",1);
	else
		dc1.setAttribute("BACKG",0);
	elem.appendChild(dc1);
	QDomElement dc1a=docu.createElement("PAGE");
	dc1a.setAttribute("PAGEC",Vor->DpapColor.name());
	dc1a.setAttribute("MARGC",Vor->DmargColor.name());
	if (Vor->RandFarbig)
		dc1a.setAttribute("RANDF",1);
	else
		dc1a.setAttribute("RANDF",0);
	elem.appendChild(dc1a);
	QDomElement dc2=docu.createElement("FONTS");
	dc2.setAttribute("FACE",Vor->DefFont);
	dc2.setAttribute("SIZE",Vor->DefSize);
	elem.appendChild(dc2);
	QDomElement dc3=docu.createElement("TYPO");
	dc3.setAttribute("TIEF",Vor->DVTief);
	dc3.setAttribute("TIEFSC",Vor->DVTiefSc);
	dc3.setAttribute("HOCH",Vor->DVHoch);
	dc3.setAttribute("HOCHSC",Vor->DVHochSc);
	dc3.setAttribute("SMCAPS",Vor->DVKapit);
	dc3.setAttribute("AUTOL", Vor->AutoLine);
	elem.appendChild(dc3);
	QDomElement dc9=docu.createElement("TOOLS");
	dc9.setAttribute("PEN",Vor->Dpen);
	dc9.setAttribute("BRUSH",Vor->Dbrush);
	dc9.setAttribute("PENLINE",Vor->DpenLine);
	dc9.setAttribute("PENTEXT",Vor->DpenText);
	dc9.setAttribute("STIL",Vor->DLineArt);
	dc9.setAttribute("STILLINE",Vor->DLstyleLine);
	dc9.setAttribute("WIDTH",Vor->Dwidth);
	dc9.setAttribute("WIDTHLINE",Vor->DwidthLine);
	dc9.setAttribute("PENSHADE",Vor->Dshade2);
	dc9.setAttribute("LINESHADE",Vor->DshadeLine);
	dc9.setAttribute("BRUSHSHADE",Vor->Dshade);
	dc9.setAttribute("MAGMIN",Vor->MagMin);
	dc9.setAttribute("MAGMAX",Vor->MagMax);
	dc9.setAttribute("MAGSTEP",Vor->MagStep);
	dc9.setAttribute("CPICT",Vor->DbrushPict);
	dc9.setAttribute("PICTSHADE",Vor->ShadePict);
	dc9.setAttribute("PICTSCX",Vor->ScaleX);
	dc9.setAttribute("PICTSCY",Vor->ScaleY);
	dc9.setAttribute("POLYC", Vor->PolyC);
	dc9.setAttribute("POLYF", Vor->PolyF);
	dc9.setAttribute("POLYR", Vor->PolyR);
	dc9.setAttribute("POLYFD", Vor->PolyFd);
	dc9.setAttribute("POLYS", int(Vor->PolyS));
	dc9.setAttribute("PSCALE", int(Vor->ScaleType));
	dc9.setAttribute("PASPECT", int(Vor->AspectRatio));
	elem.appendChild(dc9);
	QDomElement dc4=docu.createElement("MAINWINDOW");
	dc4.setAttribute("XPOS",Vor->MainX);
	dc4.setAttribute("YPOS",Vor->MainY);
	dc4.setAttribute("WIDTH",Vor->MainW);
	dc4.setAttribute("HEIGHT",Vor->MainH);
	elem.appendChild(dc4);
	QDomElement dc5=docu.createElement("TOOLPALETTE");
	dc5.setAttribute("VISIBLE",int(Vor->Werkv));
	elem.appendChild(dc5);
	QDomElement dc6=docu.createElement("COLORPALETTE");
	dc6.setAttribute("VISIBLE",int(Vor->Cpalv));
	dc6.setAttribute("XPOS",Vor->Cpalx);
	dc6.setAttribute("YPOS",Vor->Cpaly);
	elem.appendChild(dc6);
	QDomElement dc7=docu.createElement("TREEPALETTE");
	dc7.setAttribute("VISIBLE",int(Vor->Tpalv));
	dc7.setAttribute("XPOS",Vor->Tpalx);
	dc7.setAttribute("YPOS",Vor->Tpaly);
	elem.appendChild(dc7);
	QDomElement dc71=docu.createElement("STYLEPALETTE");
	dc71.setAttribute("VISIBLE",int(Vor->Spalv));
	dc71.setAttribute("XPOS",Vor->Spalx);
	dc71.setAttribute("YPOS",Vor->Spaly);
	elem.appendChild(dc71);
	QDomElement dc72=docu.createElement("NODEPALETTE");
	dc72.setAttribute("XPOS",Vor->Npalx);
	dc72.setAttribute("YPOS",Vor->Npaly);
	elem.appendChild(dc72);
	QDomElement dc73=docu.createElement("SCRAPBOOK");
	dc73.setAttribute("VISIBLE",int(Vor->SCpalv));
	dc73.setAttribute("XPOS",Vor->SCpalx);
	dc73.setAttribute("YPOS",Vor->SCpaly);
	dc73.setAttribute("WIDTH",Vor->SCpalw);
	dc73.setAttribute("HEIGHT",Vor->SCpalh);
	dc73.setAttribute("PREVIEW",Vor->PSize);
	dc73.setAttribute("SAVE",int(Vor->SaveAtQ));
	elem.appendChild(dc73);
	QDomElement dc74=docu.createElement("LAYERPALETTE");
	dc74.setAttribute("VISIBLE",int(Vor->Lpalv));
	dc74.setAttribute("XPOS",Vor->Lpalx);
	dc74.setAttribute("YPOS",Vor->Lpaly);
	elem.appendChild(dc74);
	QDomElement dc75=docu.createElement("PAGEPALETTE");
	dc75.setAttribute("VISIBLE",int(Vor->Sepalv));
	dc75.setAttribute("XPOS",Vor->Sepalx);
	dc75.setAttribute("YPOS",Vor->Sepaly);
	dc75.setAttribute("THUMBS",int(Vor->SepalT));
	dc75.setAttribute("NAMES",int(Vor->SepalN));
	elem.appendChild(dc75);
	QDomElement dc76=docu.createElement("DOKUMENT");
	dc76.setAttribute("FORMATCODE",Vor->PageFormat);
	dc76.setAttribute("AUSRICHTUNG",Vor->Ausrichtung);
	dc76.setAttribute("BREITE",Vor->PageBreite);
	dc76.setAttribute("HOEHE",Vor->PageHoehe);
	dc76.setAttribute("RANDO",Vor->RandOben);
	dc76.setAttribute("RANDU",Vor->RandUnten);
	dc76.setAttribute("RANDL",Vor->RandLinks);
	dc76.setAttribute("RANDR",Vor->RandRechts);
	dc76.setAttribute("DOPPEL",int(Vor->DoppelSeiten));
	dc76.setAttribute("LINKS",int(Vor->ErsteLinks));
	elem.appendChild(dc76);
	QDomElement dc8=docu.createElement("MEASUREMENTS");
	dc8.setAttribute("VISIBLE",int(Vor->Mpalv));
	dc8.setAttribute("XPOS",Vor->Mpalx);
	dc8.setAttribute("YPOS",Vor->Mpaly);
	elem.appendChild(dc8);
	QDomElement dc81=docu.createElement("CMS");
	dc81.setAttribute("DPSo",int(Vor->DCMSset.SoftProofOn));
	dc81.setAttribute("DPuse",int(Vor->DCMSset.CMSinUse));
	dc81.setAttribute("DPgam",int(Vor->DCMSset.GamutCheck));
	dc81.setAttribute("DPMo",Vor->DCMSset.DefaultMonitorProfile);
	dc81.setAttribute("DPPr",Vor->DCMSset.DefaultPrinterProfile);
	dc81.setAttribute("DPIn",Vor->DCMSset.DefaultInputProfile);
	dc81.setAttribute("DPIn2",Vor->DCMSset.DefaultInputProfile2);
	dc81.setAttribute("DIPr",Vor->DCMSset.DefaultIntentPrinter);
	dc81.setAttribute("DIMo",Vor->DCMSset.DefaultIntentMonitor);
	dc81.setAttribute("DIMo2",Vor->DCMSset.DefaultIntentMonitor2);
	elem.appendChild(dc81);
	QDomElement dc82=docu.createElement("PRINTER");
	dc82.setAttribute("NAME",Vor->PrinterName);
	dc82.setAttribute("FILE",Vor->PrinterFile);
	dc82.setAttribute("COMMAND",Vor->PrinterCommand);
	elem.appendChild(dc82);
	CListe::Iterator itc;
	for (itc = Vor->DColors.begin(); itc != Vor->DColors.end(); ++itc)
		{
		QDomElement co=docu.createElement("COLOR");
		co.setAttribute("NAME",itc.key());
		co.setAttribute("RGB",Vor->DColors[itc.key()].getRGBColor().name());
		co.setAttribute("CMYK",Vor->DColors[itc.key()].name());
		elem.appendChild(co);
		}
	for ( SCFontsIterator itf(Vor->AvailFonts); itf.current(); ++itf)
		{
		QDomElement fn=docu.createElement("FONT");
		fn.setAttribute("NAME",itf.currentKey());
		fn.setAttribute("EMBED",int(itf.current()->EmbedPS));
		elem.appendChild(fn);
		}
	for (uint rd=0; rd<Vor->RecentDocs.count(); rd++)
		{
		QDomElement rde=docu.createElement("RECENT");
		rde.setAttribute("NAME",Vor->RecentDocs[rd]);
		elem.appendChild(rde);
		}
	for (uint ksc=0; ksc<66; ksc++)
		{
		QDomElement kscc=docu.createElement("SHORTCUT");
		kscc.setAttribute("CODE",Vor->KeyActions[ksc].KeyID);
		kscc.setAttribute("NR", ksc);
		elem.appendChild(kscc);
		}
	QString ho = getenv("HOME");
	QFile f(ho+"/.scribus.rc");
	if(!f.open(IO_WriteOnly))
		return;
	QTextStream s(&f);
	s<<docu.toCString();
	f.close();
}

bool ScriXmlDoc::ReadPref(struct preV *Vorein)
{
	QDomDocument docu("scridoc");
	QString ho = getenv("HOME");
	QFile f(ho+"/.scribus.rc");
	if(!f.open(IO_ReadOnly))
		return false;
	if(!docu.setContent(&f))
		{
		f.close();
		return false;
		}
	f.close();
	QDomElement elem=docu.documentElement();
	if (elem.tagName() != "SCRIBUSRC")
		return false;
	Vorein->DColors.clear();
	CMYKColor lf = CMYKColor();
	QDomNode DOC=elem.firstChild();
	while(!DOC.isNull())
		{
		QDomElement dc=DOC.toElement();
		if (dc.tagName()=="GUI")
			{
			Vorein->GUI = dc.attribute("STILT","Default");
			Vorein->Wheelval = QStoInt(dc.attribute("RAD"));
			Vorein->GrabRad = QStoInt(dc.attribute("GRAB","4"));
			Vorein->Einheit = QStoInt(dc.attribute("UNIT","0"));
			Vorein->PagesSbS = QStoInt(dc.attribute("SBS","1"));
			Vorein->ShFrames = QStoInt(dc.attribute("FRV","1"));
			Vorein->AppFontSize = QStoInt(dc.attribute("APF","12"));
			Vorein->RecentDCount = dc.attribute("RCD","5").toUInt();
			}
		if (dc.tagName()=="GRID")
			{
			Vorein->DminGrid = QStoFloat(dc.attribute("MINOR"));
			Vorein->DmajGrid = QStoFloat(dc.attribute("MAJOR"));
			Vorein->DminColor = QColor(dc.attribute("MINORC"));
			Vorein->DmajColor = QColor(dc.attribute("MAJORC"));
			Vorein->Before = bool(QStoInt(dc.attribute("BACKG","1")));
			}
		if (dc.tagName()=="PAGE")
			{
			Vorein->DpapColor = QColor(dc.attribute("PAGEC"));
			Vorein->DmargColor = QColor(dc.attribute("MARGC","#0000ff"));
			Vorein->RandFarbig = bool(QStoInt(dc.attribute("RANDF","0")));
			}
		if (dc.tagName()=="TYPO")
			{
			Vorein->DVTief = QStoInt(dc.attribute("TIEF"));
			Vorein->DVTiefSc = QStoInt(dc.attribute("TIEFSC"));
			Vorein->DVHoch = QStoInt(dc.attribute("HOCH"));
			Vorein->DVHochSc = QStoInt(dc.attribute("HOCHSC"));
			Vorein->DVKapit = QStoInt(dc.attribute("SMCAPS"));
			Vorein->AutoLine = QStoInt(dc.attribute("AUTOL","20"));
			}
		if (dc.tagName()=="TOOLS")
			{
			Vorein->Dpen = dc.attribute("PEN");
			Vorein->Dbrush = dc.attribute("BRUSH");
			Vorein->DpenLine = dc.attribute("PENLINE");
			Vorein->DpenText = dc.attribute("PENTEXT");
			Vorein->DLineArt = QStoInt(dc.attribute("STIL"));
			Vorein->DLstyleLine = QStoInt(dc.attribute("STILLINE"));
			Vorein->Dwidth = QStoFloat(dc.attribute("WIDTH"));
			Vorein->DwidthLine = QStoFloat(dc.attribute("WIDTHLINE"));
			Vorein->Dshade2 = QStoInt(dc.attribute("PENSHADE"));
			Vorein->DshadeLine = QStoInt(dc.attribute("LINESHADE"));
			Vorein->Dshade = QStoInt(dc.attribute("BRUSHSHADE"));
			Vorein->MagMin = QStoInt(dc.attribute("MAGMIN","10"));
			Vorein->MagMax = QStoInt(dc.attribute("MAGMAX","800"));
			Vorein->MagStep = QStoInt(dc.attribute("MAGSTEP","25"));
			Vorein->DbrushPict = dc.attribute("CPICT");
			Vorein->ShadePict = QStoInt(dc.attribute("PICTSHADE","100"));
			Vorein->ScaleX = QStoFloat(dc.attribute("PICTSCX","1"));
			Vorein->ScaleY = QStoFloat(dc.attribute("PICTSCY","1"));
			Vorein->ScaleType = bool(QStoInt(dc.attribute("PSCALE", "1")));
			Vorein->AspectRatio = bool(QStoInt(dc.attribute("PASPECT", "0")));
			Vorein->PolyC = QStoInt(dc.attribute("POLYC", "4"));
			Vorein->PolyF = QStoFloat(dc.attribute("POLYF", "0.5"));
			Vorein->PolyR = QStoFloat(dc.attribute("POLYR", "0"));
			Vorein->PolyFd = QStoInt(dc.attribute("POLYFD", "0"));
			Vorein->PolyS = bool(QStoInt(dc.attribute("POLYS", "0")));
			}
		if (dc.tagName()=="MAINWINDOW")
			{
			Vorein->MainX = QStoInt(dc.attribute("XPOS"));
			Vorein->MainY = QStoInt(dc.attribute("YPOS"));
			Vorein->MainW = QStoInt(dc.attribute("WIDTH"));
			Vorein->MainH = QStoInt(dc.attribute("HEIGHT"));
			}
		if (dc.tagName()=="TOOLPALETTE")
			Vorein->Werkv = bool(QStoInt(dc.attribute("VISIBLE","1")));
		if (dc.tagName()=="COLORPALETTE")
			{
			Vorein->Cpalv = bool(QStoInt(dc.attribute("VISIBLE")));
			Vorein->Cpalx = QStoInt(dc.attribute("XPOS"));
			Vorein->Cpaly = QStoInt(dc.attribute("YPOS"));
			}
		if (dc.tagName()=="TREEPALETTE")
			{
			Vorein->Tpalv = bool(QStoInt(dc.attribute("VISIBLE")));
			Vorein->Tpalx = QStoInt(dc.attribute("XPOS"));
			Vorein->Tpaly = QStoInt(dc.attribute("YPOS"));
			}
		if (dc.tagName()=="STYLEPALETTE")
			{
			Vorein->Spalv = bool(QStoInt(dc.attribute("VISIBLE")));
			Vorein->Spalx = QStoInt(dc.attribute("XPOS"));
			Vorein->Spaly = QStoInt(dc.attribute("YPOS"));
			}
		if (dc.tagName()=="LAYERPALETTE")
			{
			Vorein->Lpalv = bool(QStoInt(dc.attribute("VISIBLE")));
			Vorein->Lpalx = QStoInt(dc.attribute("XPOS"));
			Vorein->Lpaly = QStoInt(dc.attribute("YPOS"));
			}
		if (dc.tagName()=="PAGEPALETTE")
			{
			Vorein->Sepalv = bool(QStoInt(dc.attribute("VISIBLE")));
			Vorein->Sepalx = QStoInt(dc.attribute("XPOS"));
			Vorein->Sepaly = QStoInt(dc.attribute("YPOS"));
			Vorein->SepalT = bool(QStoInt(dc.attribute("THUMBS")));
			Vorein->SepalN = bool(QStoInt(dc.attribute("NAMES")));
			}
		if (dc.tagName()=="SCRAPBOOK")
			{
			Vorein->SCpalv = bool(QStoInt(dc.attribute("VISIBLE")));
			Vorein->SCpalx = QStoInt(dc.attribute("XPOS"));
			Vorein->SCpaly = QStoInt(dc.attribute("YPOS"));
			Vorein->SCpalw = QStoInt(dc.attribute("WIDTH"));
			Vorein->SCpalh = QStoInt(dc.attribute("HEIGHT"));
			Vorein->PSize = QStoInt(dc.attribute("PREVIEW"));
			Vorein->SaveAtQ = bool(QStoInt(dc.attribute("SAVE")));
			}
		if (dc.tagName() == "DOKUMENT")
			{
			Vorein->PageFormat = QStoInt(dc.attribute("FORMATCODE","4"));
			Vorein->Ausrichtung = QStoInt(dc.attribute("AUSRICHTUNG","0"));
			Vorein->PageBreite = QStoFloat(dc.attribute("BREITE","595"));
			Vorein->PageHoehe = QStoFloat(dc.attribute("HOEHE","842"));
			Vorein->RandOben = QStoFloat(dc.attribute("RANDO","9"));
			Vorein->RandUnten = QStoFloat(dc.attribute("RANDU","40"));
			Vorein->RandLinks = QStoFloat(dc.attribute("RANDL","9"));
			Vorein->RandRechts = QStoFloat(dc.attribute("RANDR","9"));
			Vorein->DoppelSeiten = bool(QStoInt(dc.attribute("DOPPEL","0")));
			Vorein->ErsteLinks = bool(QStoInt(dc.attribute("LINKS","0")));
			}
		if (dc.tagName()=="CMS")
			{
			Vorein->DCMSset.SoftProofOn = bool(QStoInt(dc.attribute("DPSo","0")));
			Vorein->DCMSset.CMSinUse = bool(QStoInt(dc.attribute("DPuse","0")));
			Vorein->DCMSset.GamutCheck = bool(QStoInt(dc.attribute("DPgam","0")));
			Vorein->DCMSset.DefaultMonitorProfile = dc.attribute("DPMo","");
			Vorein->DCMSset.DefaultPrinterProfile = dc.attribute("DPPr","");
			Vorein->DCMSset.DefaultInputProfile = dc.attribute("DPIn","");
			Vorein->DCMSset.DefaultInputProfile2 = dc.attribute("DPIn2","");
			Vorein->DCMSset.DefaultIntentPrinter = QStoInt(dc.attribute("DIPr","0"));
			Vorein->DCMSset.DefaultIntentMonitor = QStoInt(dc.attribute("DIMo","3"));
			Vorein->DCMSset.DefaultIntentMonitor2 = QStoInt(dc.attribute("DIMo2","3"));
			}
		if (dc.tagName()=="NODEPALETTE")
			{
			Vorein->Npalx = QStoInt(dc.attribute("XPOS"));
			Vorein->Npaly = QStoInt(dc.attribute("YPOS"));
			}
		if (dc.tagName()=="SHORTCUT")
			Vorein->KeyActions[QStoInt(dc.attribute("NR"))].KeyID = QStoInt(dc.attribute("CODE"));
		if (dc.tagName()=="RECENT")
			Vorein->RecentDocs.append(dc.attribute("NAME"));
		if (dc.tagName()=="MEASUREMENTS")
			{
			Vorein->Mpalv = bool(QStoInt(dc.attribute("VISIBLE")));
			Vorein->Mpalx = QStoInt(dc.attribute("XPOS"));
			Vorein->Mpaly = QStoInt(dc.attribute("YPOS"));
			}
		if (dc.tagName()=="PRINTER")
			{
			Vorein->PrinterName = dc.attribute("NAME");
			Vorein->PrinterFile = dc.attribute("FILE");
			Vorein->PrinterCommand = dc.attribute("COMMAND");
			}
		if (dc.tagName()=="FONTS")
			{
			QString tmpf = dc.attribute("FACE");
			if (!Vorein->AvailFonts.find(tmpf))
				{
				DmF *dia = new DmF(0, tmpf, Vorein->AvailFonts);
				dia->exec();
				Vorein->DefFont = dia->Ersatz;
				delete dia;
				}
			else
				Vorein->DefFont = dc.attribute("FACE");
			Vorein->DefSize = QStoInt(dc.attribute("SIZE"));
			}
		if (dc.tagName()=="FONT")
			{
			if (Vorein->AvailFonts.find(dc.attribute("NAME")))
				{
				Vorein->AvailFonts[dc.attribute("NAME")]->EmbedPS = bool(QStoInt(dc.attribute("EMBED")));
				}
			}
		if (dc.tagName()=="COLOR")
			{
			if (dc.hasAttribute("CMYK"))
				lf.setNamedColor(dc.attribute("CMYK"));
			else
				lf.fromQColor(QColor(dc.attribute("RGB")));
		  Vorein->DColors[dc.attribute("NAME")] = lf;
			}
		DOC=DOC.nextSibling();
		}
	if (Vorein->GUI != "Default")
		qApp->setStyle(QStyleFactory::create(Vorein->GUI));
	qApp->setFont(QFont("helvetica", Vorein->AppFontSize),true);
	return true;
}


