#include "pdfopts.h"
#include "pdfopts.moc"
#include "customfdialog.h"
extern QPixmap loadIcon(QString nam);

PDF_Opts::PDF_Opts( QWidget* parent,  QString Fname, QMap<QString,QFont> DocFonts, ScribusView *vie, QValueList<PreSet> Eff )
    : QDialog( parent, "pdf", true, 0 )
{
    setCaption( tr( "Create PDF-File" ) );
  	setIcon(loadIcon("AppIcon.xpm"));
  	FontsToEmbed.clear();
  	view = vie;
  	EffVal = Eff;
  	PDFOptsLayout = new QVBoxLayout( this );
    PDFOptsLayout->setSpacing( 6 );
    PDFOptsLayout->setMargin( 11 );
    Name = new QLabel( this, "Name" );
    Name->setFrameShape( QLabel::NoFrame );
    Name->setText( tr( "Output to File:" ) );
    PDFOptsLayout->addWidget( Name );
    Layout5 = new QHBoxLayout;
    Layout5->setSpacing( 6 );
    Layout5->setMargin( 0 );
    Datei = new QLineEdit( this, "Datei" );
    Datei->setMinimumSize( QSize( 268, 22 ) );
    QFileInfo fi = QFileInfo(Fname);
    Datei->setText(fi.dirPath()+"/"+fi.baseName()+".pdf");
    Layout5->addWidget( Datei );
    FileC = new QToolButton( this, "FileC" );
    FileC->setMinimumSize( QSize( 88, 24 ) );
    FileC->setText( tr( "Change..." ) );
    Layout5->addWidget( FileC );
    PDFOptsLayout->addLayout( Layout5 );
    Options = new QTabWidget( this, "TabWidget2" );
    tab = new QWidget( Options, "tab" );
    tabLayout = new QVBoxLayout( tab );
    tabLayout->setSpacing( 6 );
    tabLayout->setMargin( 11 );

    Layout13 = new QHBoxLayout( 0, 0, 6, "Layout13");

    RangeGroup = new QButtonGroup( tab, "RangeGroup" );
    RangeGroup->setTitle( tr( "Export Range" ) );
    RangeGroup->setColumnLayout(0, Qt::Vertical );
    RangeGroup->layout()->setSpacing( 6 );
    RangeGroup->layout()->setMargin( 11 );
    RangeGroupLayout = new QVBoxLayout( RangeGroup->layout() );
    RangeGroupLayout->setAlignment( Qt::AlignTop );
    AllPages = new QRadioButton( RangeGroup, "AllPages" );
    AllPages->setText( tr( "All Pages" ) );
    AllPages->setChecked( TRUE );
    RangeGroupLayout->addWidget( AllPages );
    Layout11 = new QGridLayout( 0, 1, 1, 0, 6, "Layout11");
    OnlySome = new QRadioButton( RangeGroup, "OnlySome" );
    OnlySome->setText( tr( "From:" ) );
    Layout11->addWidget( OnlySome, 0, 0 );
    LastPage = new QSpinBox( RangeGroup, "LastPage" );
    LastPage->setMaxValue(view->Pages.count());
    LastPage->setMinValue( 1 );
    Layout11->addWidget( LastPage, 1, 1 );
    RText = new QLabel( RangeGroup, "RText" );
    RText->setText( tr( "to:" ) );
    Layout11->addWidget( RText, 1, 0, AlignRight );
    FirstPage = new QSpinBox( RangeGroup, "FirstPage" );
    FirstPage->setMaxValue(view->Pages.count());
    FirstPage->setMinValue( 1 );
		FirstPage->setValue(1);
		LastPage->setValue(view->Pages.count());
    Layout11->addWidget( FirstPage, 0, 1 );
    RangeGroupLayout->addLayout( Layout11 );
		FirstPage->setEnabled(false);
		LastPage->setEnabled(false);
		RText->setEnabled(false);
    Layout13->addWidget( RangeGroup );

    GroupBox1 = new QGroupBox( tab, "GroupBox1" );
    GroupBox1->setTitle( tr( "File Options" ) );
    GroupBox1->setColumnLayout(0, Qt::Vertical );
    GroupBox1->layout()->setSpacing( 0 );
    GroupBox1->layout()->setMargin( 0 );
    GroupBox1Layout = new QGridLayout( GroupBox1->layout() );
    GroupBox1Layout->setAlignment( Qt::AlignTop );
    GroupBox1Layout->setSpacing( 6 );
    GroupBox1Layout->setMargin( 11 );
    TextLabel1 = new QLabel( GroupBox1, "TextLabel1" );
    TextLabel1->setText( tr( "Compatibility:" ) );
    TextLabel1->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );
    GroupBox1Layout->addWidget( TextLabel1, 0, 0 );
    ComboBox1 = new QComboBox( true, GroupBox1, "ComboBox1" );
    ComboBox1->insertItem("Acrobat 4.0");
    ComboBox1->insertItem("Acrobat 5.0");
    ComboBox1->setEditable(false);
    GroupBox1Layout->addMultiCellWidget( ComboBox1, 0, 0, 1, 2, AlignLeft );
    TextLabel1x = new QLabel( GroupBox1, "TextLabel1" );
    TextLabel1x->setText( tr( "Binding:" ) );
    TextLabel1x->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );
    GroupBox1Layout->addWidget( TextLabel1x, 1, 0 );
    ComboBind = new QComboBox( true, GroupBox1, "ComboBind" );
    ComboBind->insertItem(tr("Left Margin"));
    ComboBind->insertItem(tr("Right Margin"));
    ComboBind->setEditable(false);
    GroupBox1Layout->addMultiCellWidget( ComboBind, 1, 1, 1, 2, AlignLeft );
    CheckBox1 = new QCheckBox( GroupBox1, "CheckBox1" );
    CheckBox1->setText( tr( "Generate Thumbnails" ) );
    GroupBox1Layout->addMultiCellWidget( CheckBox1, 2, 2, 0, 2 );
    Article = new QCheckBox( GroupBox1, "CheckBox1" );
    Article->setText( tr( "Save linked Text Frames as PDF-Articles" ) );
    GroupBox1Layout->addMultiCellWidget( Article, 3, 3, 0, 2 );
    TextLabel2 = new QLabel( GroupBox1, "TextLabel2" );
    TextLabel2->setText( tr( "Resolution:" ) );
    TextLabel2->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );
    GroupBox1Layout->addWidget( TextLabel2, 4, 0 );
    Resolution = new QSpinBox( GroupBox1, "Resolution" );
    Resolution->setMaxValue( 4000 );
    Resolution->setMinValue( 35 );
    Resolution->setValue( 300 );
    Resolution->setSuffix( tr( " dpi" ) );
    GroupBox1Layout->addWidget( Resolution, 4, 1, AlignLeft );
    Layout13->addWidget( GroupBox1 );
    tabLayout->addLayout( Layout13 );
    GroupBox2 = new QGroupBox( tab, "GroupBox2" );
    GroupBox2->setTitle( tr( "Compression" ) );
    GroupBox2->setColumnLayout(0, Qt::Vertical );
    GroupBox2->layout()->setSpacing( 0 );
    GroupBox2->layout()->setMargin( 0 );
    GroupBox2Layout = new QGridLayout( GroupBox2->layout() );
    GroupBox2Layout->setAlignment( Qt::AlignTop );
    GroupBox2Layout->setSpacing( 6 );
    GroupBox2Layout->setMargin( 11 );
    DSColor = new QCheckBox( GroupBox2, "DSColor" );
    DSColor->setText( tr( "Downsample Images to:" ) );
    GroupBox2Layout->addWidget( DSColor, 1, 0 );
    ValC = new QSpinBox( GroupBox2, "ValC" );
    ValC->setSuffix( tr( " dpi" ) );
    ValC->setMaxValue( 4000 );
    ValC->setMinValue( 35 );
    ValC->setValue( 300 );
    ValC->setEnabled(false);
    GroupBox2Layout->addWidget( ValC, 1, 1, AlignLeft );
    Compression = new QCheckBox( GroupBox2, "Compression" );
    Compression->setText( tr( "Compress Text and Vector Graphics" ) );
    Compression->setChecked( TRUE );
    GroupBox2Layout->addMultiCellWidget( Compression, 0, 0, 0, 1 );
    tabLayout->addWidget( GroupBox2 );
    Options->insertTab( tab, tr( "General" ) );
    tab_3 = new QWidget( Options, "tab_3" );
    tabLayout_3 = new QVBoxLayout( tab_3 );
    tabLayout_3->setSpacing( 6 );
    tabLayout_3->setMargin( 11 );
    EmbedFonts = new QCheckBox( tab_3, "EmbedFonts" );
    EmbedFonts->setText( tr( "Embed all Fonts" ) );
    tabLayout_3->addWidget( EmbedFonts );
    GroupFont = new QGroupBox( tab_3, "GroupFont" );
    GroupFont->setTitle( tr( "Embedding" ) );
    GroupFont->setColumnLayout(0, Qt::Vertical );
    GroupFont->layout()->setSpacing( 0 );
    GroupFont->layout()->setMargin( 0 );
    GroupFontLayout = new QHBoxLayout( GroupFont->layout() );
    GroupFontLayout->setAlignment( Qt::AlignTop );
    GroupFontLayout->setSpacing( 6 );
    GroupFontLayout->setMargin( 11 );
    Layout4_2 = new QVBoxLayout;
    Layout4_2->setSpacing( 6 );
    Layout4_2->setMargin( 0 );
    TextFont1 = new QLabel( GroupFont, "TextFont1" );
    TextFont1->setText( tr( "Available Fonts:" ) );
    Layout4_2->addWidget( TextFont1 );
    AvailFlist = new QListBox( GroupFont, "AvailFlist" );
		QMap<QString,QFont>::Iterator it;	
		for (it = DocFonts.begin(); it != DocFonts.end(); ++it)
			{
    	AvailFlist->insertItem(it.key());
			}
    AvailFlist->setMinimumSize(QSize(150, 140));
    AvailFlist->setMaximumSize(QSize(150, 140));
    Layout4_2->addWidget( AvailFlist );
    GroupFontLayout->addLayout( Layout4_2 );
    Layout5_2 = new QVBoxLayout;
    Layout5_2->setSpacing( 6 );
    Layout5_2->setMargin( 0 );
    ToEmbed = new QPushButton( GroupFont, "ToEmbed" );
    ToEmbed->setText( tr( ">>" ) );
    ToEmbed->setEnabled(false);
    Layout5_2->addWidget( ToEmbed );
    FromEmbed = new QPushButton( GroupFont, "FromEmbed" );
    FromEmbed->setText( tr( "<<" ) );
    FromEmbed->setEnabled(false);
    Layout5_2->addWidget( FromEmbed );
    GroupFontLayout->addLayout( Layout5_2 );
    Layout6 = new QVBoxLayout;
    Layout6->setSpacing( 6 );
    Layout6->setMargin( 0 );
    TextFont1_2 = new QLabel( GroupFont, "TextFont1_2" );
    TextFont1_2->setText( tr( "Fonts to embed:" ) );
    Layout6->addWidget( TextFont1_2 );
    EmbedList = new QListBox( GroupFont, "EmbedList" );
    EmbedList->setMinimumSize(QSize(150, 140));
    EmbedList->setMaximumSize(QSize(150, 140));
    Layout6->addWidget( EmbedList );
    GroupFontLayout->addLayout( Layout6 );
    tabLayout_3->addWidget( GroupFont );
    Options->insertTab( tab_3, tr( "Fonts" ) );

    tab4 = new QWidget( Options, "tab4" );
    tab4Layout = new QVBoxLayout( tab4 );
    tab4Layout->setSpacing( 6 );
    tab4Layout->setMargin( 11 );
    CheckBM = new QCheckBox( tab4, "E" );
    CheckBM->setText( tr( "Include Bookmarks" ) );
    tab4Layout->addWidget( CheckBM );
		BView = new BookMView(tab4, vie);
		BView->setRootIsDecorated(true);
		BView->addColumn(tr("Bookmarks"));
		BView->setSorting(0,1);
    tab4Layout->addWidget(BView);
    if (BView->childCount() != 0)
    	CheckBM->setChecked(true);
    else
    	CheckBM->setChecked(false);
    Options->insertTab( tab4, tr( "Bookmarks" ) );

    tab_5 = new QWidget( Options, "tab_5" );
    tabLayout_5 = new QGridLayout( tab_5 );
    tabLayout_5->setSpacing( 6 );
    tabLayout_5->setMargin( 11 );
    CheckBox10 = new QCheckBox( tab_5, "CheckBox10" );
    CheckBox10->setText( tr( "Enable Presentation Effects" ) );
    CheckBox10->setChecked(false);
		tabLayout_5->addMultiCellWidget( CheckBox10, 0, 0, 0, 1 );

    Pages = new QListBox( tab_5, "Pages" );
    Pages->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, Pages->sizePolicy().hasHeightForWidth() ) );
    QString tmp;
    struct PreSet ef;
    for (uint pg = 0; pg < vie->Pages.count(); pg++)
    	{
    	Pages->insertItem(tr("Page")+" "+tmp.setNum(pg+1));
    	ef.EffektLen = 1;
    	ef.AnzeigeLen = 1;
    	ef.Effekt = 0;
    	ef.Dm = 0;
    	ef.M = 0;
    	ef.Di = 0;
    	EffVal.append(ef);
    	}
    tabLayout_5->addWidget( Pages, 1, 0 );
    PagePrev = new QCheckBox( tab_5, "CheckBox10" );
    PagePrev->setText( tr( "Show Page Previews" ) );
    PagePrev->setChecked(false);
		tabLayout_5->addWidget( PagePrev, 2, 0 );

    Effects = new QGroupBox( tab_5, "Effects" );
    Effects->setTitle( tr( "Effects" ) );
    Effects->setColumnLayout(0, Qt::Vertical );
    Effects->layout()->setSpacing( 0 );
    Effects->layout()->setMargin( 0 );
    EffectsLayout = new QGridLayout( Effects->layout() );
    EffectsLayout->setAlignment( Qt::AlignTop );
    EffectsLayout->setSpacing( 6 );
    EffectsLayout->setMargin( 11 );
    TextLabel1e = new QLabel( Effects, "TextLabel1_2" );
    TextLabel1e->setText( tr( "Display Duration:" ) );
    EffectsLayout->addWidget( TextLabel1e, 0, 0 );
    TextLabel2e = new QLabel( Effects, "TextLabel2_2" );
    TextLabel2e->setText( tr( "Effect Duration:" ) );
		EffectsLayout->addWidget( TextLabel2e, 1, 0 );
    TextLabel3e = new QLabel( Effects, "TextLabel3_2" );
    TextLabel3e->setText( tr( "Effect Type:" ) );
		EffectsLayout->addWidget( TextLabel3e, 2, 0 );
    TextLabel4e = new QLabel( Effects, "TextLabel4_2" );
    TextLabel4e->setText( tr( "Moving Lines:" ) );
		EffectsLayout->addWidget( TextLabel4e, 3, 0 );
    TextLabel5e = new QLabel( Effects, "TextLabel6" );
    TextLabel5e->setText( tr( "from the:" ) );
    EffectsLayout->addWidget( TextLabel5e, 4, 0 );
		TextLabel6e = new QLabel( Effects, "TextLabel5" );
    TextLabel6e->setText( tr( "Direction:" ) );
		EffectsLayout->addWidget( TextLabel6e, 5, 0 );
    PageTime = new QSpinBox( Effects, "PageTime" );
    PageTime->setSuffix( tr( " sec" ) );
    PageTime->setMaxValue( 3600 );
    PageTime->setMinValue( 1 );
    PageTime->setValue(EffVal[0].AnzeigeLen);
    EffectsLayout->addWidget( PageTime, 0, 1 );
    EffectTime = new QSpinBox( Effects, "EffectTime" );
    EffectTime->setSuffix( tr( " sec" ) );
    EffectTime->setMaxValue( 3600 );
    EffectTime->setMinValue( 1 );
    EffectTime->setValue(EffVal[0].EffektLen);
    EffectsLayout->addWidget( EffectTime, 1, 1 );
    EffectType = new QComboBox( true, Effects, "EffectType" );
    EffectType->insertItem( tr( "No Effect" ) );
    EffectType->insertItem( tr( "Blinds" ) );
    EffectType->insertItem( tr( "Box" ) );
    EffectType->insertItem( tr( "Dissolve" ) );
    EffectType->insertItem( tr( "Glitter" ) );
    EffectType->insertItem( tr( "Split" ) );
    EffectType->insertItem( tr( "Wipe" ) );
    EffectType->setEditable(false);
    EffectsLayout->addWidget( EffectType, 2, 1 );
    EDirection = new QComboBox( true, Effects, "EDirection" );
    EDirection->insertItem( tr( "Horizontal" ) );
    EDirection->insertItem( tr( "Vertical" ) );
    EDirection->setEditable(false);
    EffectsLayout->addWidget( EDirection, 3, 1 );
    EDirection_2 = new QComboBox( true, Effects, "EDirection_2" );
    EDirection_2->insertItem( tr( "Inside" ) );
    EDirection_2->insertItem( tr( "Outside" ) );
    EDirection_2->setEditable(false);
    EffectsLayout->addWidget( EDirection_2, 4, 1 );
    EDirection_2_2 = new QComboBox( true, Effects, "EDirection_2_2" );
    EDirection_2_2->insertItem( tr( "Left to Right" ) );
    EDirection_2_2->insertItem( tr( "Top to Bottom" ) );
    EDirection_2_2->insertItem( tr( "Bottom to Top" ) );
    EDirection_2_2->insertItem( tr( "Right to Left" ) );
    EDirection_2_2->insertItem( tr( "Top-Left to Bottom-Right" ) );
    EDirection_2_2->setEditable(false);
		EffectsLayout->addWidget( EDirection_2_2, 5, 1 );
		EonAllPg = new QPushButton( Effects, "Eon" );
    EonAllPg->setText( tr( "Apply Effect on all Pages" ) );
		EffectsLayout->addMultiCellWidget( EonAllPg, 6, 6, 0, 1 );
    tabLayout_5->addMultiCellWidget( Effects, 1, 2, 1, 1 );
    Options->insertTab( tab_5, tr( "Extras" ) );
    PgSel = 0;
    Pages->setCurrentItem(0);
    SetEffOpts(0);
		Pages->setEnabled(false);
		Effects->setEnabled(false);
		PagePrev->setEnabled(false);
    PDFOptsLayout->addWidget( Options );
    Layout7 = new QHBoxLayout;
    Layout7->setSpacing( 6 );
    Layout7->setMargin( 0 );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout7->addItem( spacer_2 );
    OK = new QPushButton( this, "OK" );
    OK->setText( tr( "OK" ) );
    OK->setAutoDefault( TRUE );
    OK->setDefault( TRUE );
    Layout7->addWidget( OK );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout7->addItem( spacer_3 );
    Cancel = new QPushButton( this, "Cancel" );
    Cancel->setText( tr( "Cancel" ) );
    Layout7->addWidget( Cancel );
    QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout7->addItem( spacer_4 );
    PDFOptsLayout->addLayout( Layout7 );
    setMaximumSize( sizeHint() );

    // signals and slots connections
    connect( FileC, SIGNAL( clicked() ), this, SLOT( ChangeFile() ) );
    connect( OK, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( Cancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect(EmbedFonts, SIGNAL(clicked()), this, SLOT(EmbedAll()));
    connect(AvailFlist, SIGNAL(clicked(QListBoxItem*)), this, SLOT(SelAFont(QListBoxItem*)));
    connect(EmbedList, SIGNAL(clicked(QListBoxItem*)), this, SLOT(SelEFont(QListBoxItem*)));
    connect(ToEmbed, SIGNAL(clicked()), this, SLOT(PutToEmbed()));
    connect(FromEmbed, SIGNAL(clicked()), this, SLOT(RemoveEmbed()));
    connect(DSColor, SIGNAL(clicked()), this, SLOT(DoDownsample()));
    connect(CheckBM, SIGNAL(clicked()), this, SLOT(ToggleBM()));
    connect(PagePrev, SIGNAL(clicked()), this, SLOT(PagePr()));
    connect(Pages, SIGNAL(highlighted(int)), this, SLOT(SetPgEff(int)));
    connect(EffectType, SIGNAL(activated(int)), this, SLOT(SetEffOpts(int)));
    connect(EDirection_2_2, SIGNAL(activated(int)), this, SLOT(ValidDI(int)));
    connect(CheckBox10, SIGNAL(clicked()), this, SLOT(DoEffects()));
    connect(EonAllPg, SIGNAL(clicked()), this, SLOT(EffectOnAll()));
    connect(AllPages, SIGNAL(toggled(bool)), this, SLOT(SelRange(bool)));
    connect(FirstPage, SIGNAL(valueChanged(int)), this, SLOT(ChFrom()));
    connect(LastPage, SIGNAL(valueChanged(int)), this, SLOT(ChTo()));
}

/*  
 *  Destroys the object and frees any allocated resources
 */
PDF_Opts::~PDF_Opts()
{
    // no need to delete child widgets, Qt does it all for us
}

void PDF_Opts::ChFrom()
{
  disconnect(LastPage, SIGNAL(valueChanged(int)), this, SLOT(ChTo()));
	if (FirstPage->value() > LastPage->value())
		LastPage->setValue(FirstPage->value());
	connect(LastPage, SIGNAL(valueChanged(int)), this, SLOT(ChTo()));
}

void PDF_Opts::ChTo()
{
  disconnect(FirstPage, SIGNAL(valueChanged(int)), this, SLOT(ChFrom()));
	if (LastPage->value() < FirstPage->value())
		FirstPage->setValue(LastPage->value());
  connect(FirstPage, SIGNAL(valueChanged(int)), this, SLOT(ChFrom()));
}

void PDF_Opts::SelRange(bool e)
{
	if (e)
		{
    RText->setEnabled( FALSE );
    FirstPage->setEnabled( FALSE );
   	LastPage->setEnabled( FALSE );
		}
	else
		{
    RText->setEnabled( true );
    FirstPage->setEnabled( true );
   	LastPage->setEnabled( true );
		CheckBM->setChecked(false);
		ToggleBM();
		}
}

void PDF_Opts::EffectOnAll()
{
	for (uint pg = 0; pg < view->Pages.count(); pg++)
		{
		EffVal[pg].AnzeigeLen = PageTime->value();
		EffVal[pg].EffektLen = EffectTime->value();
		EffVal[pg].Effekt = EffectType->currentItem();
		EffVal[pg].Dm = EDirection->currentItem();
		EffVal[pg].M = EDirection_2->currentItem();
		EffVal[pg].Di = EDirection_2_2->currentItem();
		}
}

void PDF_Opts::DoEffects()
{
	if (CheckBox10->isChecked())
		{
		Pages->setEnabled(true);
		Effects->setEnabled(true);
		PagePrev->setEnabled(true);
		}
	else
		{
		Pages->setEnabled(false);
		Effects->setEnabled(false);
		PagePrev->setEnabled(false);
		}
}

void PDF_Opts::ValidDI(int nr)
{
	if (!EDirection_2_2->listBox()->item(nr)->isSelectable())
		EDirection_2_2->setCurrentItem(0);
}

void PDF_Opts::SetPgEff(int nr)
{
	if (nr < 0)
		return;
	EffVal[PgSel].AnzeigeLen = PageTime->value();
	EffVal[PgSel].EffektLen = EffectTime->value();
	EffVal[PgSel].Effekt = EffectType->currentItem();
	EffVal[PgSel].Dm = EDirection->currentItem();
	EffVal[PgSel].M = EDirection_2->currentItem();
	EffVal[PgSel].Di = EDirection_2_2->currentItem();
	SetEffOpts(EffectType->currentItem());
	PageTime->setValue(EffVal[nr].AnzeigeLen);
	EffectTime->setValue(EffVal[nr].EffektLen);
	EffectType->setCurrentItem(EffVal[nr].Effekt);
	EDirection->setCurrentItem(EffVal[nr].Dm);
	EDirection_2->setCurrentItem(EffVal[nr].M);
	EDirection_2_2->setCurrentItem(EffVal[nr].Di);
	PgSel = nr;
}

void PDF_Opts::SetEffOpts(int nr)
{
	EDirection_2_2->listBox()->item(2)->setSelectable(false);
	EDirection_2_2->listBox()->item(3)->setSelectable(false);
	EDirection_2_2->listBox()->item(4)->setSelectable(false);
	switch (nr)
		{
		case 0:
		case 3:
			EDirection->setEnabled(false);
			EDirection_2->setEnabled(false);
			EDirection_2_2->setEnabled(false);
			break;
		case 1:
			EDirection->setEnabled(true);
			EDirection_2->setEnabled(false);
			EDirection_2_2->setEnabled(false);
			break;
		case 2:
			EDirection->setEnabled(false);
			EDirection_2->setEnabled(true);
			EDirection_2_2->setEnabled(false);
			break;
		case 4:
		case 6:
			EDirection->setEnabled(false);
			EDirection_2->setEnabled(false);
			EDirection_2_2->setEnabled(true);
			if (nr == 6)
				{
				EDirection_2_2->listBox()->item(2)->setSelectable(true);
				EDirection_2_2->listBox()->item(3)->setSelectable(true);
				}
			else
				EDirection_2_2->listBox()->item(4)->setSelectable(true);
			break;
		case 5:
			EDirection->setEnabled(true);
			EDirection_2->setEnabled(true);
			EDirection_2_2->setEnabled(false);
			break;
		}
}

void PDF_Opts::PagePr()
{
	QString tmp;
	int ci = Pages->currentItem();
	if (PagePrev->isChecked())
		{
  	for (uint pg = 0; pg < view->Pages.count(); pg++)
  		{
   		Pages->changeItem(view->PageToPixmap(pg, 70), tr("Page")+" "+tmp.setNum(pg+1), pg);
    	}
    }
  else
  	{
  	for (uint pg = 0; pg < view->Pages.count(); pg++)
  		{
   		Pages->changeItem(tr("Page")+" "+tmp.setNum(pg+1), pg);
    	}
  	}
  if (ci != -1)
  	{
  	PgSel = ci;
  	Pages->setCurrentItem(ci);
  	}
  else
  	{
  	PgSel = 0;
  	Pages->clearSelection();
  	}
}

void PDF_Opts::ToggleBM()
{
	if (CheckBM->isChecked())
		BView->setEnabled(true);
	else
		BView->setEnabled(false);
}

void PDF_Opts::DoDownsample()
{
	if (DSColor->isChecked())
		{
		ValC->setEnabled(true);
		if (ValC->value() > Resolution->value())
			ValC->setValue(Resolution->value());
    ValC->setMaxValue(Resolution->value());
    ValC->setMinValue(35);
		}
	else
		{
		ValC->setEnabled(false);
		}
}

void PDF_Opts::RemoveEmbed()
{
	FontsToEmbed.remove(EmbedList->currentText());
	EmbedList->removeItem(EmbedList->currentItem());
  EmbedList->clearSelection();
  if (EmbedList->count() == 0)
		FromEmbed->setEnabled(false);
}

void PDF_Opts::PutToEmbed()
{
	if (EmbedList->count() != 0)
		{
		if (EmbedList->findItem(AvailFlist->currentText()) == NULL)
			{
			FontsToEmbed.append(AvailFlist->currentText());
			EmbedList->insertItem(AvailFlist->currentText());
			}
		}
	else
		{
		FontsToEmbed.append(AvailFlist->currentText());
		EmbedList->insertItem(AvailFlist->currentText());		
		}
}

void PDF_Opts::SelAFont(QListBoxItem *c)
{
	if ((c != NULL) && (!EmbedFonts->isChecked()))
		{
		FromEmbed->setEnabled(false);
  	ToEmbed->setEnabled(true);
  	EmbedList->clearSelection();
  	}
}

void PDF_Opts::SelEFont(QListBoxItem *c)
{
	if ((c != NULL) && (!EmbedFonts->isChecked()))
		{
		FromEmbed->setEnabled(true);
  	ToEmbed->setEnabled(false);
  	AvailFlist->clearSelection();
  	}
}

void PDF_Opts::EmbedAll()
{
	if (EmbedFonts->isChecked())
		{
		EmbedList->clear();
		FontsToEmbed.clear();
		FromEmbed->setEnabled(false);
  	ToEmbed->setEnabled(false);
		for (uint a=0; a < AvailFlist->count(); a++)
			{
			FontsToEmbed.append(AvailFlist->item(a)->text());
			EmbedList->insertItem(AvailFlist->item(a)->text());
			}
		}
}

void PDF_Opts::ChangeFile()
{
	QString fn;
	CustomFDialog dia(this, tr("Save as"), tr("PDF-Files (*.pdf);; All Files (*)"), false, false);
	if (Datei->text() != "")
		dia.setSelection(Datei->text());
	if (dia.exec())
		fn = dia.selectedFile();
	else
		return;
  if (!fn.isEmpty())
  	Datei->setText(fn);
}
