/***************************************************************************
                          pdflib.h  -  description
                             -------------------
    begin                : Sat Jan 19 2002
    copyright            : (C) 2002 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PDFLIB_H
#define PDFLIB_H
#include <qstring.h>
#include <qrect.h>
#include <qvaluelist.h>
#include <qimage.h>
#include "pageitem.h"
#include "scribusview.h"
#include "bookmwin.h"

/**
  *@author Franz Schmid
  */

class PDFlib {

public: 
	PDFlib();
	virtual ~PDFlib();
	virtual void PDF_Begin_Doc(ScribusDoc *docu, ScribusView *vie, PDFOpt *opts, SCFonts &AllFonts, QMap<QString,QFont> DocFonts, BookMView* vi);
	virtual void PDF_Begin_Page(Page* pag);
	virtual void PDF_End_Page();
	virtual void PDF_ProcessPage(Page* pag, uint PNr);
	virtual QString PDF_End_Doc();
	QString Dokument;
	QString Inhalt;
  ScribusDoc* doc;
  ScribusView* view;
  Page* ActPage;
  PDFOpt* Options;
  BookMView* Bvie;
	
private:
	QString FToStr(float c);
	QString IToStr(int c);
	QString SetClipPath(PageItem *ite);
	QString SetFarbe(QString farbe, int Shade);
	QString setTextSt(PageItem *ite, uint PNr);
	void PutDoc(QString in);
	void PutPage(QString in);
	void StartObj(int nr);
	void WritePDFStream(QString cc);
	QString CompressStr(QString *in);
	QString PDFEncode(QString in);
	void PDF_Bookmark(int nr, float ypos);
	void PDF_Annotation(PageItem *ite, uint PNr);
	void PDF_circle(float x, float y);
	void PDF_roundRect(float b, float h, float r);
	void PDF_Form(QString im);
  void PDF_xForm(float w, float h, QString im);
	QString ImageToTxt(QImage *im);
	QString MaskToTxt(QImage *im);
	void PDF_Image(QString fn, float sx, float sy, float x, float y, bool fromAN = false);
	struct Dest {	QString Name;
								int Seite;
								QString Act;
							};
	struct Cata { int Outlines;
								int PageTree;
								int Dest;
							} Catalog;
	struct PagT { QValueList<int> Kids;
								int Count;
							} PageTree;
	struct PagL { int ObjNum;
								int Thumb;
								QMap<QString,int> XObjects;
								QMap<QString,int> FObjects;
								QValueList<int> AObjects;
								QValueList<int> FormObjects;
							} Seite;
	struct OutL { int First;
								int Last;
								int Count;
							} Outlines;
	struct Bead { int Parent;
								int Next;
								int Prev;
								int Page;
								QRect Recht;
							};
	QValueList<uint> XRef;
	QValueList<Dest> NamedDest;
	QValueList<int> Threads;
	QValueList<Bead> Beads;
	QValueList<int> CalcFields;
	int ObjCounter;
	bool NeedsStroke;
	QString ResNam;
	int ResCount;
	QString NDnam;
	int NDnum;
	QMap<QString, QString> UsedFonts;
	SCFonts FontDef;
	bool CompAvail;
};

#endif
