/***************************************************************************
                          scribus.cpp  -  description
                             -------------------
    begin                : Fre Apr  6 21:09:31 CEST 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qaccel.h>
#include <qapplication.h>
#include <qcolordialog.h>
#include <qcolor.h>
#include <qiconset.h>
#include <qtextstream.h>
#include <qstylefactory.h>
#include <qregexp.h>
#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <iostream.h>
#include "scribus.h"
#include "scribus.moc"
#include "newfile.h"
#include "page.h"
#include "query.h"
#include "mdup.h"
#include "docinfo.h"
#include "reformdoc.h"
#include "serializer.h"
#include "align.h"
#include "fmitem.h"
#include "fontprefs.h"
#include "libprefs/prefs.h"
#include "pdfopts.h"
#include "inspage.h"
#include "delpages.h"
#include "movepage.h"
#include "helpbrowser.h"
#include "scribusXml.h"
#include "libabout/about.h"
#include "druck.h"
#include "editformats.h"
#include "muster.h"
#include "applytemplate.h"
#include "picstatus.h"
#include "customfdialog.h"
#include "cmsprefs.h"
#include "annot.h"
#include "annota.h"
#include "javadocs.h"
#include "config.h"
#include "fpoint.h"
#include "fpointarray.h"

extern QPixmap loadIcon(QString nam);

#ifdef HAVE_CMS
cmsHPROFILE CMSinputProf;
cmsHPROFILE CMSoutputProf;
cmsHPROFILE CMSprinterProf;
cmsHTRANSFORM stdTrans;
cmsHTRANSFORM stdProof;
cmsHTRANSFORM stdTransImg;
cmsHTRANSFORM stdProofImg;
bool SoftProofing;
bool Gamut;
bool CMSuse;
int IntentMonitor;
int IntentPrinter;
#endif
bool CMSavail;
ProfilesL InputProfiles;
int PolyC;
int PolyFd;
float PolyF;
bool PolyS;
float PolyR;
float UmReFaktor;

ScribusApp::ScribusApp()
{
  setCaption(tr("Scribus " VERSION));
  setIcon(loadIcon("AppIcon.xpm"));
  initMenuBar();
  initStatusBar();
  WerkTools2 = new QToolBar(tr("File"), this);
  DatNeu = new QToolButton(loadIcon("DateiNeu.xpm"), tr("Creates a new Document"), QString::null, this, SLOT(slotFileNew()), WerkTools2);
  DatOpe = new QToolButton(loadIcon("DateiOpen.xpm"), tr("Opens a Document"), QString::null, this, SLOT(slotDocOpen()), WerkTools2);
  DatSav = new QToolButton(loadIcon("DateiSave.xpm"), tr("Saves the current Document"), QString::null, this, SLOT(slotFileSave()), WerkTools2);
  DatClo = new QToolButton(loadIcon("DateiClos.xpm"), tr("Closes the current Document"), QString::null, this, SLOT(slotFileClose()), WerkTools2);
  DatPri = new QToolButton(loadIcon("DateiPrint.xpm"), tr("Prints the current Document"), QString::null, this, SLOT(slotFilePrint()), WerkTools2);
  DatPDF = new QToolButton(loadIcon("acrobat.png"), tr("Saves the current Document as PDF"), QString::null, this, SLOT(SaveAsPDF()), WerkTools2);
	DatSav->setEnabled(false);
	DatClo->setEnabled(false);
	DatPri->setEnabled(false);
	DatPDF->setEnabled(false);
	DatOpe->setPopup(recentMenu);
	WerkTools = new WerkToolB(this);
	setDockEnabled(WerkTools, DockLeft, false);
	setDockEnabled(WerkTools, DockRight, false);
	WerkTools->setEnabled(false);
	/** Erstelle Fontliste */
  NoFonts = false;
  GetAllFonts();
  if (NoFonts)
  	{
		QString mess = tr("There are no Postscript-Fonts on your System");
		mess += "\n" + tr("Exiting now");
		QMessageBox::critical(this, tr("Fatal Error"), mess, 1, 0, 0);
  	}
  else
  	{
  	HaveDoc = false;
		TemplateMode = false;
  	BuildFontMenu();
		SCFontsIterator it(Prefs.AvailFonts);
		Prefs.DefFont = it.currentKey();
  	Prefs.DefSize = 12;
  	Prefs.AppFontSize = 12;
  	/** Default Farbenliste */
  	Prefs.DColors.clear();
	  Prefs.DColors.insert("White", CMYKColor(0, 0, 0, 0));
  	Prefs.DColors.insert("Black", CMYKColor(0, 0, 0, 255));
		Prefs.DColors.insert("Blue", CMYKColor(255, 255, 0, 0));
		Prefs.DColors.insert("Cyan", CMYKColor(255, 0, 0, 0));
		Prefs.DColors.insert("Green", CMYKColor(255, 0, 255, 0));
		Prefs.DColors.insert("Red", CMYKColor(0, 255, 255, 0));
		Prefs.DColors.insert("Yellow", CMYKColor(0, 0, 255, 0));
		Prefs.DColors.insert("Magenta", CMYKColor(0, 255, 0, 0));
		DispX = 10;
		DispY = 10;
		Prefs.Wheelval = 40;
		Prefs.GrabRad = 4;
		Prefs.DminGrid = 20;
	  Prefs.DmajGrid = 100;
	  DocNr = 1;
	  Prefs.DminColor = QColor(green);
	  Prefs.DmajColor = QColor(green);
	  Prefs.DpapColor = QColor(white);
	  Prefs.DmargColor = QColor(blue);
	  Prefs.DVHoch = 33;
	  Prefs.DVHochSc = 100;
	  Prefs.DVTief = 33;
	  Prefs.DVTiefSc = 100;
	  Prefs.DVKapit = 75;
	  Prefs.GUI = "Default";
	  Prefs.Dpen = "Black";
	  Prefs.Dbrush = "Black";
	  Prefs.Dshade = 100;
	  Prefs.Dshade2 = 100;
	  Prefs.DLineArt = SolidLine;
	  Prefs.Dwidth = 1;
	  Prefs.DpenLine = "Black";
	  Prefs.DpenText = "Black";
	  Prefs.DshadeLine = 100;
	  Prefs.DLstyleLine = SolidLine;
	  Prefs.DwidthLine = 1;
	  Prefs.MagMin = 10;
	  Prefs.MagMax = 800;
	  Prefs.MagStep = 25;
	  Prefs.DbrushPict = "White";
	  Prefs.ShadePict = 100;
	  Prefs.ScaleX = 1;
	  Prefs.ScaleY = 1;
	  Prefs.Before = true;
	  Prefs.Einheit = 0;
		UmReFaktor = 1.0;
		PolyC = 4;
		PolyF = 0.5;
		PolyS = false;
		PolyFd = 0;
		PolyR = 0;
		Prefs.PolyC = PolyC;
		Prefs.PolyF = PolyF;
		Prefs.PolyFd = PolyFd;
		Prefs.PolyS = PolyS;
		Prefs.PolyR = PolyR;
	  BufferSet = false;
	  BufferSet2 = false;
	  Prefs.Werkv = true;
	  Prefs.Mpalv = false;
	  Prefs.Cpalv = false;
	  Prefs.Tpalv = false;
	  Prefs.Spalv = false;
	  Prefs.SCpalv = false;
	  Prefs.Lpalv = false;
	  Prefs.PSize = 40;
	  Prefs.SaveAtQ = true;
	  Prefs.ShFrames = true;
	  Prefs.PagesSbS = true;
	  Prefs.RecentDocs.clear();
	  Prefs.RecentDCount = 5;
	  Prefs.RandFarbig = false;
	  Prefs.AutoLine = 20;
		Prefs.PageFormat = 4;
		Prefs.Ausrichtung = 0;
		Prefs.PageBreite = 595;
		Prefs.PageHoehe = 842;
		Prefs.RandOben = 9;
		Prefs.RandUnten = 40;
		Prefs.RandLinks = 9;
		Prefs.RandRechts = 9;
		Prefs.DoppelSeiten = false;
		Prefs.ErsteLinks = false;
		Prefs.ScaleType = true;
		Prefs.AspectRatio = false;
	  PDFavailable = true;
		PDef.Pname = "";
		PDef.Dname = "";
		PDef.Command = "";
	  PrinterUsed = false;
		resize(610, 600);
		Cpal = new Cpalette(this);
		Cpal->SetColors(Prefs.DColors);
		setDockEnabled(Cpal, DockTop, false);
		setDockEnabled(Cpal, DockBottom, false);
		Tpal = new Tree(this, WStyle_Customize | WStyle_DialogBorder);
		Mpal = new Mpalette(this, FontMenu);
		setDockEnabled(Mpal, DockTop, false);
		setDockEnabled(Mpal, DockBottom, false);
		Spal = new Spalette(this);
		setDockEnabled(Spal, DockTop, false);
		setDockEnabled(Spal, DockBottom, false);
		Npal = new NodePalette(this);
		Lpal = new LayerPalette(this);
		ScBook = new Biblio(this, Prefs.AvailFonts, &Prefs);
		Sepal = new SeitenPal(this);
		CMSavail = false;
		Prefs.DCMSset.DefaultMonitorProfile = "";
		Prefs.DCMSset.DefaultPrinterProfile = "";
		Prefs.DCMSset.DefaultInputProfile = "";
		Prefs.DCMSset.DefaultInputProfile2 = "";
		Prefs.DCMSset.CMSinUse = false;
		Prefs.DCMSset.SoftProofOn = false;
		Prefs.DCMSset.GamutCheck = false;
		Prefs.DCMSset.DefaultIntentMonitor = 1;
		Prefs.DCMSset.DefaultIntentMonitor2 = 1;
		Prefs.DCMSset.DefaultIntentPrinter = 0;
		SetKeyEntry(56, tr("Smart Hyphen"), 0, ALT+Key_Minus);
		SetKeyEntry(57, tr("Align Left"), 0, CTRL+Key_L);
		SetKeyEntry(58, tr("Align Right"), 0, CTRL+Key_R);
		SetKeyEntry(59, tr("Align Center"), 0, CTRL+Key_E);
		SetKeyEntry(60, tr("Insert Pagenumber"), 0, ALT+Key_NumberSign);
		SetKeyEntry(61, tr("Attach Text to Path"), PfadT, 0);
		SetKeyEntry(62, tr("Show Layers"), viewLpal, 0);
		SetKeyEntry(63, tr("JavaScripts..."), jman, 0);
		SetKeyEntry(64, tr("Undo"), edUndo, CTRL+Key_Z);
		SetKeyEntry(65, tr("Show Page Palette"), viewSepal, 0);
		GetCMSProfiles();
		ReadPrefs();
		SetShortCut();
		if (CMSavail)
			{
			editMenu->insertItem(tr("Color Management..."), this , SLOT(SetCMSPrefs()));
			ProfilesL::Iterator ip;
			if ((Prefs.DCMSset.DefaultInputProfile == "") || (!InputProfiles.contains(Prefs.DCMSset.DefaultInputProfile)))
				{
				ip = InputProfiles.begin();
				Prefs.DCMSset.DefaultInputProfile = ip.key();
				}
			if ((Prefs.DCMSset.DefaultInputProfile2 == "") || (!InputProfiles.contains(Prefs.DCMSset.DefaultInputProfile2)))
				{
				ip = InputProfiles.begin();
				Prefs.DCMSset.DefaultInputProfile2 = ip.key();
				}
			if ((Prefs.DCMSset.DefaultMonitorProfile == "") || (!MonitorProfiles.contains(Prefs.DCMSset.DefaultMonitorProfile)))
				{
				ip = MonitorProfiles.begin();
				Prefs.DCMSset.DefaultMonitorProfile = ip.key();
				}
			if ((Prefs.DCMSset.DefaultPrinterProfile == "") || (!PrinterProfiles.contains(Prefs.DCMSset.DefaultPrinterProfile)))
				{
				ip = PrinterProfiles.begin();
				Prefs.DCMSset.DefaultPrinterProfile = ip.key();
				}
#ifdef HAVE_CMS
			SoftProofing = Prefs.DCMSset.SoftProofOn;
			CMSuse = Prefs.DCMSset.CMSinUse;
			IntentPrinter = Prefs.DCMSset.DefaultIntentPrinter;
			IntentMonitor = Prefs.DCMSset.DefaultIntentMonitor;
#endif
			OpenCMSProfiles();
			if ((Prefs.DCMSset.CMSinUse) && (Prefs.DCMSset.SoftProofOn))
				RecalcColors();
			}
		QString SCf = QString(getenv("HOME"))+"/.scribusscrap.scs";
		QFileInfo SCfi = QFileInfo(SCf);
		if (SCfi.exists())
			{
			ScBook->BibWin->ReadContents(SCf);
			ScBook->ScFilename = SCf;
			}
		ScBook->AdjustMenu();
		HaveGS = system("gs -h > /dev/null 2>&1");
		InitPlugs();
		connect(WerkTools, SIGNAL(NewMode(int)), this, SLOT(ModeFromTB(int)));
		connect(WerkTools, SIGNAL(Schliessen()), this, SLOT(ToggleTools()));
		connect(Mpal, SIGNAL(DocChanged()), this, SLOT(slotDocCh()));
		connect(Mpal, SIGNAL(NewAbStyle(int)), this, SLOT(setNewAbStyle(int)));
		connect(Mpal, SIGNAL(BackHome()), this, SLOT(Aktiv()));
		connect(Mpal, SIGNAL(Stellung(int)), this, SLOT(setItemHoch(int)));
		connect(Mpal, SIGNAL(Schliessen()), this, SLOT(ToggleMpal()));
		connect(Cpal, SIGNAL(Schliessen()), this, SLOT(ToggleCpal()));
		connect(Cpal, SIGNAL(NewPen(QString)), this, SLOT(setPenFarbe(QString)));
		connect(Cpal, SIGNAL(NewBrush(QString)), this, SLOT(setBrushFarbe(QString)));
		connect(Cpal, SIGNAL(NewPenShade(int)), this, SLOT(setPenShade(int)));
		connect(Cpal, SIGNAL(NewBrushShade(int)), this, SLOT(setBrushShade(int)));
		connect(Cpal, SIGNAL(QueryItem()), this, SLOT(GetBrushPen()));
		connect(Tpal, SIGNAL(Schliessen()), this, SLOT(ToggleTpal()));
		connect(Tpal, SIGNAL(SelectElement(int, int)), this, SLOT(SelectFromOutl(int, int)));
		connect(Tpal, SIGNAL(SelectSeite(int)), this, SLOT(SelectFromOutlS(int)));
		connect(Spal, SIGNAL(Schliessen()), this, SLOT(ToggleSpal()));
		connect(Spal, SIGNAL(NewStyle(int)), this, SLOT(setNewAbStyle(int)));
		connect(Spal, SIGNAL(EditSt()), this, SLOT(slotEditStyles()));
		connect(Npal, SIGNAL(Schliessen()), this, SLOT(NoFrameEdit()));
		connect(Lpal, SIGNAL(LayerActivated(int)), this, SLOT(changeLayer(int)));
		connect(Lpal, SIGNAL(LayerRemoved(int)), this, SLOT(LayerRemove(int)));
		connect(Lpal, SIGNAL(LayerChanged()), this, SLOT(showLayer()));
		connect(Lpal, SIGNAL(Schliessen()), this, SLOT(ToggleLpal()));
		connect(Sepal, SIGNAL(Schliessen()), this, SLOT(ToggleSepal()));
		connect(ScBook, SIGNAL(Schliessen()), this, SLOT(ToggleBpal()));
		connect(Sepal, SIGNAL(EditTemp(QString)), this, SLOT(ManageTemp(QString)));
		connect(Sepal->PageView, SIGNAL(UseTemp(QString, int)), this, SLOT(Apply_Temp(QString, int)));
		connect(Sepal->PageView, SIGNAL(NewPage(int, QString)), this, SLOT(slotNewPageP(int, QString)));
		connect(Sepal->Trash, SIGNAL(DelPage(int)), this, SLOT(DeletePage2(int)));
		connect(Sepal, SIGNAL(GotoSeite(int)), this, SLOT(SelectFromOutlS(int)));
		connect(recentMenu, SIGNAL(activated(int)), this, SLOT(LoadRecent(int)));
		connect(ColorMenu, SIGNAL(activated(int)), this, SLOT(setItemFarbe(int)));
	  connect(ShadeMenu, SIGNAL(activated(int)), this, SLOT(setItemShade(int)));
	  connect(FontMenu, SIGNAL(activated(int)), this, SLOT(setItemFont(int)));
	  connect(SizeTMenu, SIGNAL(activated(int)), this, SLOT(setItemFSize(int)));
	  connect(TypeStyleMenu, SIGNAL(activated(int)), this, SLOT(setItemTypeStyle(int)));
	  connect(AliMenu, SIGNAL(activated(int)), this, SLOT(setItemTextAli(int)));
		connect(this, SIGNAL(TextIFont(QString)), this, SLOT(AdjustFontMenu(QString)));
		connect(this, SIGNAL(TextISize(int)), this, SLOT(setFSizeMenu(int)));
		connect(this, SIGNAL(TextISize(int)), Mpal, SLOT(setSize(int)));
		connect(this, SIGNAL(TextUSval(float)), Mpal, SLOT(setExtra(float)));
		connect(this, SIGNAL(TextStil(int)), Mpal, SLOT(setStil(int)));
		connect(this, SIGNAL(TextFarben(QString, QString, int, int)), Cpal, SLOT(setActFarben(QString, QString, int, int)));
	}
}

ScribusApp::~ScribusApp()
{
}

void ScribusApp::initMenuBar()
{
	int a;
	int MenID;
	QFont tmp;
	recentMenu = new QPopupMenu();
	RecentDocs.clear();
	fileMenu=new QPopupMenu();
	fid12 = fileMenu->insertItem(loadIcon("DateiNeu16.png"), tr("New"), this, SLOT(slotFileNew()), CTRL+Key_N);
	fid13 = fileMenu->insertItem(loadIcon("DateiOpen16.png"), tr("Open..."), this, SLOT(slotDocOpen()), CTRL+Key_O);
	fid14 = fileMenu->insertItem(tr("Recent Documents"), recentMenu);
	SetKeyEntry(0, tr("New"), fid12, CTRL+Key_N);
	SetKeyEntry(1, tr("Open..."), fid13, CTRL+Key_O);
	fileMenu->insertSeparator();
	fid1 = fileMenu->insertItem(loadIcon("DateiClos16.png"), tr("Close"), this, SLOT(slotFileClose()), CTRL+Key_W);
	SetKeyEntry(2, tr("Close"), fid1, CTRL+Key_W);
	fileMenu->setItemEnabled(fid1, 0);
	fid4 = fileMenu->insertItem(loadIcon("DateiSave16.png"), tr("Save"), this, SLOT(slotFileSave()), CTRL+Key_S);
	SetKeyEntry(3, tr("Save"), fid4, CTRL+Key_S);
	fileMenu->setItemEnabled(fid4, 0);
	fid5 = fileMenu->insertItem(tr("Save as..."), this, SLOT(slotFileSaveAs()));
	SetKeyEntry(4, tr("Save as..."), fid5, 0);
	fileMenu->setItemEnabled(fid5, 0);
	fileMenu->insertSeparator();
	importMenu = new QPopupMenu();
	fid2 = importMenu->insertItem(tr("Get Text/Picture..."), this, SLOT(slotFileOpen()));
	importMenu->setItemEnabled(fid2, 0);
	fileMenu->insertItem(tr("Import..."), importMenu);
	exportMenu = new QPopupMenu();
	fid3 = exportMenu->insertItem(tr("Save Text..."), this, SLOT(SaveText()));
	exportMenu->setItemEnabled(fid3, 0);
	fid8 = exportMenu->insertItem(tr("Save Page as EPS..."), this, SLOT(SaveAsEps()));
	exportMenu->setItemEnabled(fid8, 0);
	fid10 = exportMenu->insertItem(tr("Save as PDF..."), this, SLOT(SaveAsPDF()));
	exportMenu->setItemEnabled(fid10, 0);
	fid11 = fileMenu->insertItem(tr("Export..."), exportMenu);
	fileMenu->setItemEnabled(fid11, 0);
	fileMenu->insertSeparator();
	fid6 = fileMenu->insertItem(tr("Document Info..."), this, SLOT(InfoDoc()), CTRL+Key_I);
	fileMenu->setItemEnabled(fid6, 0);
	SetKeyEntry(5, tr("Document Info..."), fid6, CTRL+Key_I);
	fid7 = fileMenu->insertItem(tr("Document Setup..."), this, SLOT(SetupDoc()));
	fileMenu->setItemEnabled(fid7, 0);
	SetKeyEntry(6, tr("Document Setup..."), fid7, 0);
	fid9 = fileMenu->insertItem(loadIcon("DateiPrint16.png"), tr("Print..."), this, SLOT(slotFilePrint()), CTRL+Key_P);
	fileMenu->setItemEnabled(fid9, 0);
	SetKeyEntry(7, tr("Print..."), fid9, CTRL+Key_P);
	fileMenu->insertSeparator();
	MenID = fileMenu->insertItem(loadIcon("exit.png"), tr("Quit"), this, SLOT(slotFileQuit()), CTRL+Key_Q);
	SetKeyEntry(8, tr("Quit"), MenID, CTRL+Key_Q);
	editMenu = new QPopupMenu();
	edUndo = editMenu->insertItem(tr("Undo"), this, SLOT(UnDoAction()), CTRL+Key_Z);
	editMenu->insertSeparator();
	edid1 = editMenu->insertItem(loadIcon("editcut.png"), tr("Cut"), this , SLOT(slotEditCut()), CTRL+Key_X);
	edid2 = editMenu->insertItem(loadIcon("editcopy.png"), tr("Copy"), this , SLOT(slotEditCopy()), CTRL+Key_C);
	edid3 = editMenu->insertItem(loadIcon("editpaste.png"), tr("Paste"), this , SLOT(slotEditPaste()), CTRL+Key_V);
	edid4 = editMenu->insertItem(loadIcon("editdelete.png"), tr("Clear"), this, SLOT(DeleteText()));
	edid5 = editMenu->insertItem(tr("Select all"), this, SLOT(SelectAll()), CTRL+Key_A);
	SetKeyEntry(9, tr("Cut"), edid1, CTRL+Key_X);
	SetKeyEntry(10, tr("Copy"), edid2, CTRL+Key_C);
	SetKeyEntry(11, tr("Paste"), edid3, CTRL+Key_V);
	SetKeyEntry(12, tr("Clear"), edid4, 0);
	SetKeyEntry(13, tr("Select all"), edid5, CTRL+Key_A);
	editMenu->insertSeparator();
	MenID = editMenu->insertItem(tr("Colors..."), this , SLOT(slotEditColors()));
	SetKeyEntry(14, tr("Colors..."), MenID, 0);
	edid6 = editMenu->insertItem(tr("Styles..."), this , SLOT(slotEditStyles()));
	SetKeyEntry(15, tr("Styles..."), edid6, 0);
	tman = editMenu->insertItem(tr("Templates..."), this, SLOT(ManageTemp()));
	SetKeyEntry(16, tr("Templates..."), tman, 0);
	jman = editMenu->insertItem(tr("JavaScripts..."), this, SLOT(ManageJava()));
	MenID = editMenu->insertItem(tr("Fonts..."), this , SLOT(slotFontOrg()));
	SetKeyEntry(17, tr("Fonts..."), MenID, 0);
	MenID = editMenu->insertItem(tr("Preferences..."), this , SLOT(slotPrefsOrg()));
	SetKeyEntry(18, tr("Preferences..."), MenID, 0);
	editMenu->setItemEnabled(edUndo, 0);
	editMenu->setItemEnabled(edid1, 0);
	editMenu->setItemEnabled(edid2, 0);
	editMenu->setItemEnabled(edid3, 0);
	editMenu->setItemEnabled(edid4, 0);
	editMenu->setItemEnabled(edid5, 0);
	editMenu->setItemEnabled(edid6, 0);
	editMenu->setItemEnabled(tman, 0);
	editMenu->setItemEnabled(jman, 0);
	StilMenu = new QPopupMenu();
	ObjMenu = new QPopupMenu();
	MenID = ObjMenu->insertItem(tr("Modify..."), this, SLOT(ModifyObject()), CTRL+Key_M);
	SetKeyEntry(19, tr("Modify..."), MenID, CTRL+Key_M);
	MenID = ObjMenu->insertItem(tr("Duplicate"), this, SLOT(ObjektDup()), CTRL+Key_D);
	SetKeyEntry(20, tr("Duplicate"), MenID, CTRL+Key_D);
	MenID = ObjMenu->insertItem(tr("Multiple Duplicate"), this, SLOT(ObjektDupM()));
	SetKeyEntry(21, tr("Multiple Duplicate"), MenID, 0);
	Loesch = ObjMenu->insertItem(tr("Delete"), this, SLOT(DeleteObjekt()), CTRL+Key_K);
	SetKeyEntry(22, tr("Delete"), Loesch, CTRL+Key_K);
	ObjMenu->insertSeparator();
	Gr = ObjMenu->insertItem(tr("Group"), this, SLOT(GroupObj()), CTRL+Key_G);
	SetKeyEntry(23, tr("Group"), Gr, CTRL+Key_G);
	UnGr = ObjMenu->insertItem(tr("Ungroup"), this, SLOT(UnGroupObj()), CTRL+Key_U);
	SetKeyEntry(24, tr("Ungroup"), UnGr, CTRL+Key_U);
	ObjMenu->insertSeparator();
	MenID = ObjMenu->insertItem(tr("Send to Back"), this, SLOT(Objekt2Back()));
	SetKeyEntry(25, tr("Send to Back"), MenID, 0);
	MenID = ObjMenu->insertItem(tr("Bring to Front"), this, SLOT(Objekt2Front()));
	SetKeyEntry(26, tr("Bring to Front"), MenID, 0);
	MenID = ObjMenu->insertItem(tr("Lower"), this, SLOT(ObjektLower()));
	SetKeyEntry(27, tr("Lower"), MenID, 0);
	MenID = ObjMenu->insertItem(tr("Raise"), this, SLOT(ObjektRaise()));
	SetKeyEntry(28, tr("Raise"), MenID, 0);
	DistM = ObjMenu->insertItem(tr("Distribute/Align..."), this, SLOT(ObjektAlign()));
	SetKeyEntry(29, tr("Distribute/Align..."), DistM, 0);
	ObjMenu->insertSeparator();
	ShapeMenu = new QPopupMenu();
	ShapeMenu->insertItem(tr("Rectangle"), this, SLOT(RectFrame()));
	ShapeMenu->insertItem(tr("Rounded Rectangle"), this, SLOT(RoundedFrame()));
	ShapeMenu->insertItem(tr("Oval"), this, SLOT(OvalFrame()));
	ShapeEdit = ShapeMenu->insertItem(tr("Edit Frame"), this, SLOT(ToggleFrameEdit()));
	ShapeM = ObjMenu->insertItem(tr("Shape"), ShapeMenu);
	PfadT = ObjMenu->insertItem(tr("Attach Text to Path"), this, SLOT(Pfadtext()));
	ObjMenu->setItemEnabled(ShapeM, 0);
	ObjMenu->setItemEnabled(DistM, 0);
	ObjMenu->setItemEnabled(Gr, 0);
	ObjMenu->setItemEnabled(UnGr, 0);
	ObjMenu->setItemEnabled(PfadT, 0);
	pageMenu = new QPopupMenu();
	MenID = pageMenu->insertItem(tr("Insert..."), this, SLOT(slotNewPageM()));
	SetKeyEntry(30, tr("Insert..."), MenID, 0);
	pgmd = pageMenu->insertItem(tr("Delete..."), this, SLOT(DeletePage()));
	SetKeyEntry(31, tr("Delete..."), pgmd, 0);
	MenID = pageMenu->insertItem(tr("Copy")+"...", this, SLOT(CopyPage()));
	SetKeyEntry(61, tr("Copy")+"...", MenID, 0);
	pgmv = pageMenu->insertItem(tr("Move..."), this, SLOT(MovePage()));
	SetKeyEntry(32, tr("Move..."), pgmv, 0);
	MenID = pageMenu->insertItem(tr("Apply Template..."), this, SLOT(ApplyTemp()));
	SetKeyEntry(33, tr("Apply Template..."), MenID, 0);
	pageMenu->setItemEnabled(pgmd, 0);
	pageMenu->setItemEnabled(pgmv, 0);
	viewMenu=new QPopupMenu();
	MenID = viewMenu->insertItem(tr("Fit in Window"), this, SLOT(slotZoomFit()), CTRL+Key_0);
	SetKeyEntry(34, tr("Fit in Window"), MenID, CTRL+Key_0);
	MenID = viewMenu->insertItem("50%", this, SLOT(slotZoom50()));
	SetKeyEntry(35, tr("50%"), MenID, 0);
	MenID = viewMenu->insertItem("75%", this, SLOT(slotZoom75()));
	SetKeyEntry(36, tr("75%"), MenID, 0);
	MenID = viewMenu->insertItem(tr("Actual Size"), this, SLOT(slotZoom100()), CTRL+Key_1);
	SetKeyEntry(37, tr("Actual Size"), MenID, CTRL+Key_1);
	MenID = viewMenu->insertItem("200%", this, SLOT(slotZoom200()));
	SetKeyEntry(38, tr("200%"), MenID, 0);
	MenID = viewMenu->insertItem(tr("Thumbnails"), this, SLOT(slotZoom20()));
	SetKeyEntry(39, tr("Thumbnails"), MenID, 0);
	viewMenu->insertSeparator();
	Markers = viewMenu->insertItem(tr("Hide Margins"), this, SLOT(ToggleMarks()));
	SetKeyEntry(40, tr("Hide Margins"), Markers, 0);
	FrameDr = viewMenu->insertItem(tr("Hide Frames"), this, SLOT(ToggleFrames()));
	SetKeyEntry(41, tr("Hide Frames"), FrameDr, 0);
	Bilder = viewMenu->insertItem(tr("Hide Images"), this, SLOT(TogglePics()));
	SetKeyEntry(42, tr("Hide Images"), Bilder, 0);
	Ras = viewMenu->insertItem(tr("Show Guides"), this, SLOT(ToggleRaster()));
	SetKeyEntry(43, tr("Show Guides"), Ras, 0);
	uRas = viewMenu->insertItem(tr("Snap to Guides"), this, SLOT(ToggleURaster()));
	SetKeyEntry(44, tr("Snap to Guides"), uRas, 0);
	for (a=0; a<6; a++)
		{
		viewMenu->setItemEnabled(viewMenu->idAt(a), 0);
		}
	viewMenu->setItemEnabled(Markers, 0);
	viewMenu->setItemEnabled(FrameDr, 0);
	viewMenu->setItemEnabled(Bilder, 0);
	viewMenu->setItemEnabled(Ras, 0);
	viewMenu->setItemEnabled(uRas, 0);
	toolMenu=new QPopupMenu();
	viewTools = toolMenu->insertItem(tr("Hide Tools"), this, SLOT(ToggleTools()));
	SetKeyEntry(45, tr("Hide Tools"), viewTools, 0);
	viewMpal = toolMenu->insertItem(tr("Show Measurements"), this, SLOT(ToggleMpal()));
	SetKeyEntry(46, tr("Show Measurements"), viewMpal, 0);
	viewCpal = toolMenu->insertItem(tr("Show Colors"), this, SLOT(ToggleCpal()));
	SetKeyEntry(47, tr("Show Colors"), viewCpal, 0);
	viewTpal = toolMenu->insertItem(tr("Show Outline"), this, SLOT(ToggleTpal()));
	SetKeyEntry(48, tr("Show Outline"), viewTpal, 0);
	viewSpal = toolMenu->insertItem(tr("Show Styles"), this, SLOT(ToggleSpal()));
	SetKeyEntry(49, tr("Show Styles"), viewSpal, 0);
	viewBpal = toolMenu->insertItem(tr("Show Scrapbook"), this, SLOT(ToggleBpal()));
	SetKeyEntry(50, tr("Show Scrapbook"), viewBpal, 0);
	viewLpal = toolMenu->insertItem(tr("Show Layers"), this, SLOT(ToggleLpal()));
	viewSepal = toolMenu->insertItem(tr("Show Page Palette"), this, SLOT(ToggleSepal()));
	extraMenu=new QPopupMenu();
	MenID = extraMenu->insertItem(tr("Manage Pictures"), this, SLOT(StatusPic()));
	SetKeyEntry(51, tr("Manage Pictures"), MenID, 0);
	helpMenu=new QPopupMenu();
	MenID = helpMenu->insertItem(tr("About Scribus"), this, SLOT(slotHelpAbout()));
	SetKeyEntry(52, tr("About Scribus"), MenID, 0);
	MenID = helpMenu->insertItem(tr("About Qt"), this, SLOT(slotHelpAboutQt()));
	SetKeyEntry(53, tr("About Qt"), MenID, 0);
	helpMenu->insertSeparator();
	MenID = helpMenu->insertItem(tr("Online-Help..."), this, SLOT(slotOnlineHelp()));
	SetKeyEntry(54, tr("Online-Help..."), MenID, 0);
	tip = helpMenu->insertItem(tr("Tool-Tips"), this, SLOT(ToggleTips()));
	SetKeyEntry(55, tr("Tool-Tips"), tip, 0);
  tipsOn = true;
  helpMenu->setItemChecked(tip, tipsOn);
//	helpMenu->insertItem(tr("Test"), this, SLOT(slotTest()));
//	helpMenu->insertItem(tr("Test2"), this, SLOT(slotTest2()));
	menuBar()->insertItem(tr("File"), fileMenu);
	menuBar()->insertItem(tr("Edit"), editMenu);
	Stm = menuBar()->insertItem(tr("Style"), StilMenu);
	Obm = menuBar()->insertItem(tr("Item"), ObjMenu);
	pgmm = menuBar()->insertItem(tr("Page"), pageMenu);
	menuBar()->setItemEnabled(Obm, 0);
	menuBar()->setItemEnabled(pgmm, 0);
	menuBar()->insertItem(tr("View"), viewMenu);
	menuBar()->insertItem(tr("Tools"), toolMenu);
	exmn = menuBar()->insertItem(tr("Extras"), extraMenu);
	menuBar()->setItemEnabled(exmn, 0);
	menuBar()->insertSeparator();
	menuBar()->insertItem(tr("Help"), helpMenu);
	AliMenu = new QPopupMenu();
	AliMenu->insertItem(tr("Left"));
	AliMenu->insertItem(tr("Center"));
	AliMenu->insertItem(tr("Right"));
	AliMenu->insertItem(tr("Block"));
	AliMenu->insertItem(tr("Forced"));
	ColorMenu = new QPopupMenu();
	SizeTMenu = new QPopupMenu();
	SizeTMenu->insertItem(tr("Other..."));
	SizeTMenu->insertItem(" 7 pt");
	SizeTMenu->insertItem(" 9 pt");
	SizeTMenu->insertItem("10 pt");
	SizeTMenu->insertItem("12 pt");
	SizeTMenu->insertItem("14 pt");
	SizeTMenu->insertItem("18 pt");
	SizeTMenu->insertItem("24 pt");
	SizeTMenu->insertItem("36 pt");
	SizeTMenu->insertItem("48 pt");
	SizeTMenu->insertItem("60 pt");
	SizeTMenu->insertItem("72 pt");
	ShadeMenu = new QPopupMenu();
	ShadeMenu->insertItem(tr("Other..."));
	ShadeMenu->insertItem("0 %");
	ShadeMenu->insertItem("10 %");
	ShadeMenu->insertItem("20 %");
	ShadeMenu->insertItem("30 %");
	ShadeMenu->insertItem("40 %");
	ShadeMenu->insertItem("50 %");
	ShadeMenu->insertItem("60 %");
	ShadeMenu->insertItem("70 %");
	ShadeMenu->insertItem("80 %");
	ShadeMenu->insertItem("90 %");
	ShadeMenu->insertItem("100 %");
	FStyleMenu = new QPopupMenu();
	FontMenu = new QPopupMenu();
	TypeStyleMenu = new QPopupMenu();
	TypeStyleMenu->insertItem(tr("Normal"));
	tmp = qApp->font();
	tmp.setBold(true);
	TypeStyleMenu->insertItem(new FmItem(tr("Bold"), tmp));
	tmp = qApp->font();
	tmp.setItalic(true);
	TypeStyleMenu->insertItem(new FmItem(tr("Italic"), tmp));
	tmp = qApp->font();
	tmp.setUnderline(true);
	TypeStyleMenu->insertItem(new FmItem(tr("Underline"), tmp));
	tmp = qApp->font();
	tmp.setStrikeOut(true);
	TypeStyleMenu->insertItem(new FmItem(tr("Strikethru"), tmp));
	TypeStyleMenu->insertItem(tr("Small Caps"));
	TypeStyleMenu->insertItem(tr("Superscript"));
	TypeStyleMenu->insertItem(tr("Subscript"));
}

void ScribusApp::initStatusBar()
{
	FMess = new QLabel(statusBar(), "ft");
	FMess->setText("           ");
	statusBar()->addWidget(FMess, 3, true);
	FProg = new QProgressBar(statusBar(), "p");
  FProg->setCenterIndicator(true);
	FProg->setFixedWidth( 100 );
	statusBar()->addWidget(FProg, 0, true);
	FProg->reset();
	XMess = new QLabel(statusBar(), "xt");
	XMess->setText(tr("X-Pos:"));
	statusBar()->addWidget(XMess, 0, true);
	XDat = new QLabel(statusBar(), "dt");
	statusBar()->addWidget(XDat, 1, true);
	XDat->setText("         ");
	YMess = new QLabel(statusBar(), "yt");
	YMess->setText(tr("Y-Pos:"));
	statusBar()->addWidget(YMess, 0, true);
	YDat = new QLabel(statusBar(), "ydt");
	statusBar()->addWidget(YDat, 1, true);
	YDat->setText("         ");	
}

void ScribusApp::ReportMP(float xp, float yp)
{
	QString tmp, tmp2;
	switch (doc->Einheit)
		{
		case 0:
			tmp2 = " pt";
			break;
		case 1:
			tmp2 = " mm";
			break;
		case 2:
			tmp2 = " in";
			break;
		case 3:
			tmp2 = " p";
			break;
		}
	XDat->setText(tmp.setNum(qRound(xp*UmReFaktor * 100) / 100.0)+tmp2);
	YDat->setText(tmp.setNum(qRound(yp*UmReFaktor * 100) / 100.0)+tmp2);
}

void ScribusApp::SetKeyEntry(int Nr, QString text, int Men, int KeyC)
{
	Keys ke;
	ke.Name = text;
	ke.MenuID = Men;
	ke.KeyID = KeyC;
	Prefs.KeyActions.insert(Nr, ke);
}

void ScribusApp::DeleteSel(PageItem *b)
{
	Pti *it;
 	for (it = b->Ptext.first(); it != 0; it = b->Ptext.next())
 		{
 		if (it->cselect)
 			{
 			b->Ptext.remove();
 			it = b->Ptext.prev();
 			if (it == 0)
 				{
 				it = b->Ptext.first();
 				}
 			}
 		}
 	if (b->Ptext.first()->cselect)
 		{
 		b->Ptext.remove();
 		}
 	b->HasSel = false;
 	b->CPos = QMIN(b->CPos, doc->ActPage->oldCp);
 	DisableTxEdit();
}

void ScribusApp::setTBvals(PageItem *b)
{
	if (b->Ptext.count() != 0)
		{
		emit TextIFont(b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cfont);
 		emit TextISize(b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->csize);
 		emit TextUSval(b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cextra);
 		emit TextStil(b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cstyle & 127);
 		doc->CurrentStyle = b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cstyle & 127;
 		doc->CurrentABStil = b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cab;
 		setAbsValue(doc->CurrentABStil);
 		Mpal->setAli(doc->CurrentABStil);
 		b->IFont = b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cfont;
 		b->ISize = b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->csize;
		emit TextFarben(b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->ccolor,
										b->Pcolor,
										b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cshade,
										b->Shade);
		b->Pcolor2 = b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->ccolor;
		b->Shade2 = b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cshade;
 		}
}

void ScribusApp::wheelEvent(QWheelEvent *w)
{
	if (HaveDoc)
		{
		if (w->delta() < 0)
			{
			view->scrollBy(0, Prefs.Wheelval);
			}
		else
			{
			view->scrollBy(0, -Prefs.Wheelval);
			}
		w->accept();
		}
}

void ScribusApp::keyPressEvent(QKeyEvent *k)
{
	struct Pti *hg;
	int kk = k->key();
	int as = k->ascii();
	float altx, alty;
	QString uc = k->text();
	QString cr;
	switch (k->state())
		{
		case ShiftButton:
			KeyMod = 0x00200000;
			break;
		case AltButton:
			KeyMod = 0x00800000;
			break;
		case ControlButton:
			KeyMod = 0x00400000;
			break;
		default:
			KeyMod = 0;
		}
 	if ((HaveDoc) && (!view->LE->hasFocus()))
 		{
 		switch (kk)
 			{
 			case Key_Prior:
 				view->scrollBy(0, -Prefs.Wheelval);
 				return;
 				break;
 			case Key_Next:
 				view->scrollBy(0, Prefs.Wheelval);
 				return;
 				break;
 			}
 		if (doc->ActPage->SelItem.count() != 0)
 			{
 			PageItem *b = doc->ActPage->SelItem.at(0);
 			switch (doc->AppMode)
 				{
 				case 1:
 					switch (kk)
 						{
 						case Key_Delete:
 							if (!doc->EditClip)
 								doc->ActPage->DeleteItem();
 							break;
 						case Key_Left:
							if (!k->isAutoRepeat())
								{
								doc->ActPage->storeUndoInf(b);
								doc->UnData.UnCode = 1;
								doc->UnDoValid = true;
								CanUndo();
								}
 							doc->ActPage->moveGroup(-1, 0);
 							break;
 						case Key_Right:
							if (!k->isAutoRepeat())
								{
								doc->ActPage->storeUndoInf(b);
								doc->UnData.UnCode = 1;
								doc->UnDoValid = true;
								CanUndo();
								}
 							doc->ActPage->moveGroup(1, 0);
 							break;
 						case Key_Up:
							if (!k->isAutoRepeat())
								{
								doc->ActPage->storeUndoInf(b);
								doc->UnData.UnCode = 1;
								doc->UnDoValid = true;
								CanUndo();
								}
 							doc->ActPage->moveGroup(0, -1);
 							break;
 						case Key_Down:
							if (!k->isAutoRepeat())
								{
								doc->ActPage->storeUndoInf(b);
								doc->UnData.UnCode = 1;
								doc->UnDoValid = true;
								CanUndo();
								}
 							doc->ActPage->moveGroup(0, 1);
 						default:
 							if (b->PType == 4)
 								{
 								if ((kk + KeyMod) == Prefs.KeyActions[59].KeyID)
 									{
									setNewAbStyle(1);
 									b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									}
 								if ((kk + KeyMod) == Prefs.KeyActions[58].KeyID)
 									{
									setNewAbStyle(2);
 									b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									}
 								if ((kk + KeyMod) == Prefs.KeyActions[57].KeyID)
 									{
									setNewAbStyle(0);
 									b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									}
 								}
 							break;
 						}
 					slotDocCh();
 					break;
 				case 7:
 					if (b->PType == 4)
 						{
 						doc->ActPage->slotDoCurs(false);
 						switch (kk)
 							{
 							case Key_Down:
 								if (b->CPos != int(b->Ptext.count()))
 									{
 									alty = b->Ptext.at(b->CPos)->yp;
 									altx = b->Ptext.at(b->CPos)->xp;
 									do
 										{
 										b->CPos += 1;
 										if (b->CPos == int(b->Ptext.count()))
 											break;
 										if (b->Ptext.at(b->CPos)->yp > alty)
 											{
 											if (b->Ptext.at(b->CPos)->xp >= altx)
 												break;
 											}
 										}
 									while (b->CPos < int(b->Ptext.count()));
 									if (b->CPos == int(b->Ptext.count()))
 										if (b->NextBox != 0)
 											{
 											if (b->NextBox->Ptext.count() != 0)
 												{
												b->OwnPage->Deselect();
												b->NextBox->CPos = 0;
												doc->ActPage = b->NextBox->OwnPage;
												b->NextBox->OwnPage->SelectItemNr(b->NextBox->ItemNr);
												b = b->NextBox;
												}
 											} 									
 									}
 								else
 									{
 									if (b->NextBox != 0)
 										{
 										if (b->NextBox->Ptext.count() != 0)
 											{
											b->OwnPage->Deselect();
											b->NextBox->CPos = 0;
											doc->ActPage = b->NextBox->OwnPage;
											b->NextBox->OwnPage->SelectItemNr(b->NextBox->ItemNr);
											b = b->NextBox;
											}
 										}
 									}
 								setTBvals(b);
 								break;
 							case Key_Up:
 								if (b->CPos > 0)
 									{
 									if (b->CPos == int(b->Ptext.count()))
 										b->CPos -= 1;
 									alty = b->Ptext.at(b->CPos)->yp;
 									altx = b->Ptext.at(b->CPos)->xp;
									if (b->CPos > 0)
										{
 										do
 											{
 											b->CPos -= 1;
 											if (b->CPos == 0)
 												break;
 											if (b->Ptext.at(b->CPos)->yp < alty)
 												{
 												if (b->Ptext.at(b->CPos)->xp <= altx)
 													break;
 												}
 											}
 										while (b->CPos > 0);
										}
 									if (b->CPos == 0)
 										{
 										if (b->BackBox != 0)
 											{
											b->OwnPage->Deselect();
											b->BackBox->CPos = b->BackBox->Ptext.count();
											doc->ActPage = b->BackBox->OwnPage;
											b->BackBox->OwnPage->SelectItemNr(b->BackBox->ItemNr);
											b = b->BackBox;
 											}
 										}
 									}
 								else
 									{
 									b->CPos = 0;
 									if (b->BackBox != 0)
 										{
										b->OwnPage->Deselect();
										b->BackBox->CPos = b->BackBox->Ptext.count();
										doc->ActPage = b->BackBox->OwnPage;
										b->BackBox->OwnPage->SelectItemNr(b->BackBox->ItemNr);
										b = b->BackBox;
 										}
 									}
 								setTBvals(b);
 								break;
							case Key_Home:
 								b->CPos = 0;
 								setTBvals(b);
 								break;
							case Key_End:
 								b->CPos = int(b->Ptext.count());
 								setTBvals(b);
 								break;
 							case Key_Left:
 								b->CPos -= 1;
 								if (b->CPos < 0)
 									{
 									b->CPos = 0;
 									if (b->BackBox != 0)
 										{
										b->OwnPage->Deselect();
										b->BackBox->CPos = b->BackBox->Ptext.count();
										doc->ActPage = b->BackBox->OwnPage;
										b->BackBox->OwnPage->SelectItemNr(b->BackBox->ItemNr);
										b = b->BackBox;
 										}
 									}
 								setTBvals(b);
 								break;
 							case Key_Right:
 								b->CPos += 1;
 								if (b->CPos > int(b->Ptext.count()))
 									{
 									b->CPos -= 1;
 									if (b->NextBox != 0)
 										{
 										if (b->NextBox->Ptext.count() != 0)
 											{
											b->OwnPage->Deselect();
											b->NextBox->CPos = 0;
											doc->ActPage = b->NextBox->OwnPage;
											b->NextBox->OwnPage->SelectItemNr(b->NextBox->ItemNr);
											b = b->NextBox;
											}
 										}
 									}
 								setTBvals(b);
 								break;
 							case Key_Delete:
 								if (b->CPos == int(b->Ptext.count())) { return; }
 								if (b->Ptext.count() == 0) { return; }
 								cr = b->Ptext.at(b->CPos)->ch;
 								if (b->HasSel)
 									{
 									DeleteSel(b);
 									}
 								else
 									{
 									b->Ptext.remove(b->CPos);
 									}
 								b->Tinput = false;
 								if (cr == QChar(13))
 									{
 									doc->ActPage->chAbStyle(b, b->Ptext.at(QMAX(b->CPos-1,0))->cab);
 									b->Tinput = false;
 									}
 								setTBvals(b);
 								b->Dirty = true;
 								b->paintObj();
 								break;
 							case Key_Backspace:
 								if (b->CPos == 0)
 									return;
 								if (b->Ptext.count() == 0) { return; }
 								cr = b->Ptext.at(QMAX(b->CPos-1,0))->ch;
 								if (b->HasSel)
 									{
 									DeleteSel(b);
 									}
 								else
 									{
 									b->CPos -= 1;
 									b->Ptext.remove(b->CPos);
 									}
 								b->Tinput = false;
 								if ((cr == QChar(13)) && (b->Ptext.count() != 0))
 									{
 									doc->ActPage->chAbStyle(b, b->Ptext.at(QMAX(b->CPos-1,0))->cab);
 									b->Tinput = false;
 									}
 								setTBvals(b);
 								b->Dirty = true;
 								b->paintObj();
 								break;
 							default:
 								if ((b->HasSel) && (kk < 0x1000))
 									{
 									DeleteSel(b);
 									b->Dirty = true;
 									b->paintObj();
 									}
 								if ((kk + KeyMod) == Prefs.KeyActions[60].KeyID)
 									{
 									as = 30;
 									uc = QString(QChar(30));
 									}
 								if ((kk + KeyMod) == Prefs.KeyActions[56].KeyID)
 									{
 									b->Ptext.at(QMAX(b->CPos-1,0))->cstyle ^= 128;
 									b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									break;
 									}
 								if ((kk + KeyMod) == Prefs.KeyActions[59].KeyID)
 									{
									setNewAbStyle(1);
 									b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									break;
 									}
 								if ((kk + KeyMod) == Prefs.KeyActions[57].KeyID)
 									{
									setNewAbStyle(0);
 									b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									break;
 									}
 								if ((kk + KeyMod) == Prefs.KeyActions[58].KeyID)
 									{
									setNewAbStyle(2);
 									b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									break;
 									}
 								if ((as > 31) || (as == 13) || (as == 30))
 									{
 									hg = new Pti;
 									hg->ch = uc;
 									hg->cfont = b->IFont;
 									hg->csize = b->ISize;
 									hg->ccolor = b->Pcolor2;
 									hg->cextra = 0;
 									hg->cshade = b->Shade2;
 									hg->cselect = false;
 									hg->cstyle = doc->CurrentStyle;
 									hg->cab = doc->CurrentABStil;
 									hg->xp = 0;
 									hg->yp = 0;
									hg->PRot = 0;
									hg->PtransX = 0;
									hg->PtransY = 0;
 									b->Ptext.insert(b->CPos, hg);
 									b->CPos += 1;
 									if ((b->CPos < int(b->Ptext.count())) || (as == 30))
 										b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									}
 								break;
 							}
 						if (b->Ptext.count() != 0)
 							if (b->Ptext.at(QMAX(b->CPos-1, 0))->yp != 0)
 								doc->ActPage->slotDoCurs(true);
 						if ((kk == Key_Left) || (kk == Key_Right) || (kk == Key_Up) || (kk == Key_Down))
 							return;
 						}
 					slotDocCh(false);
 					break;
 				}
 			}
 		}
}

void ScribusApp::closeEvent(QCloseEvent *ce)
{
	if ((HaveDoc) && doc->isModified())
		{
		if (queryExit())
			{
			SavePrefs();
			if (Prefs.SaveAtQ)
				{
				if (ScBook->ScFilename.isEmpty())
					ScBook->ScFilename = QString(getenv("HOME"))+"/.scribusscrap.scs";
				ScBook->Save();
				}
			if (ScBook->BibWin->Objekte.count() == 0)
				system("rm -f " + QString(getenv("HOME"))+"/.scribusscrap.scs");
  		if (Npal->isVisible())
  			ToggleFrameEdit();			
			qApp->setOverrideCursor(QCursor(ArrowCursor), true);
			Mpal->UnsetDoc();
			Sepal->Vie = 0;
			view->close(true);
			delete doc;
			Prefs.AvailFonts.~SCFonts();
#ifdef HAVE_CMS
			if (CMSavail)
				CloseCMSProfiles();
#endif
			FinalizePlugs();
			exit(0);
//			ce->accept();
			}
		else
			{
			ce->ignore();
			return;
			}
		}
	else
		{
		SavePrefs();
		if (Prefs.SaveAtQ)
			{
			if (ScBook->ScFilename.isEmpty())
				ScBook->ScFilename = QString(getenv("HOME"))+"/.scribusscrap.scs";
			ScBook->Save();
			}
		if (ScBook->BibWin->Objekte.count() == 0)
			system("rm -f " + QString(getenv("HOME"))+"/.scribusscrap.scs");
		qApp->setOverrideCursor(QCursor(ArrowCursor), true);
		Prefs.AvailFonts.~SCFonts();
#ifdef HAVE_CMS
		if (CMSavail)
			CloseCMSProfiles();
#endif
		FinalizePlugs();
		exit(0);
//		ce->accept();
		}
}

bool ScribusApp::queryExit()
{
  bool retw = false;
  int exit=QMessageBox::information(this,
  																	tr("Warning"),
                                    tr("The document has been changed since the last save."),
                                    tr("Save Now"),
                                    tr("Cancel"),
                                    tr("Leave Anyway"),
                                    0, 1);
  switch (exit)
  	{
  	case 0:
  		slotFileSaveAs();
  		retw = true;
  		break;
  	case 1:
  		retw = false;
  		break;
  	case 2:
  		retw = true;
  		break;
  	}
  return retw;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////
float ScribusApp::mm2pts(int mm)
{
	return mm / 25.4 * 72;
}

float ScribusApp::pts2mm(float pts)
{
	return pts / 72 * 25.4;
}

bool ScribusApp::slotFileNew()
{
	float b, h, tpr, lr, rr, br, sp, ab;
	bool fp, atf, ret;
	if (HaveDoc)
		{
		if (!slotFileClose())
			return false;
		}
	NewDoc* dia = new NewDoc(this, &Prefs);
	if (dia->exec())
		{
		tpr = dia->Top;
		lr = dia->Left;
		rr = dia->Right;
		br = dia->Bottom;
		ab = dia->Dist;
		b = dia->Pagebr;
		h = dia->Pageho;
		sp = dia->SpinBox10->value();
		atf = dia->AutoFrame->isChecked();
		fp = dia->Doppelseiten->isChecked();
		if (dia->ComboBox3->currentItem() == 1)
			{
			b = mm2pts(qRound(pts2mm(dia->Pagebr)));
			h = mm2pts(qRound(pts2mm(dia->Pageho)));
			}
		ret = doFileNew(b, h, tpr, lr, rr, br, ab, sp, atf, fp, dia->ComboBox3->currentItem(),
										dia->ErsteSeite->isChecked(), dia->Orient, dia->PgNr->value());
  	FMess->setText(tr("Ready"));
		}
	else
		ret = false;
	delete dia;
	return ret;
}

bool ScribusApp::doFileNew(float b, float h, float tpr, float lr, float rr, float br, float ab, float sp,
													 bool atf, bool fp, int einh, bool firstleft, int Ori, int SNr)
{
	QString cc;
	doc = new ScribusDoc();
	doc->Einheit = einh;
	if (fp)
		doc->FirstPageLeft = firstleft;
	doc->PageOri = Ori;
	doc->FirstPnum = SNr;
	doc->AllFonts = &Prefs.AvailFonts;
	doc->AddFont(Prefs.DefFont, Prefs.AvailFonts[Prefs.DefFont]->Font);
	doc->Dfont = Prefs.DefFont;
	doc->Dsize = Prefs.DefSize;
	doc->GrabRad = Prefs.GrabRad;
	doc->minorGrid = Prefs.DminGrid;
	doc->majorGrid = Prefs.DmajGrid;
	doc->minorColor = Prefs.DminColor;
	doc->majorColor = Prefs.DmajColor;
	doc->papColor = Prefs.DpapColor;
	doc->margColor = Prefs.DmargColor;
	doc->VHoch = Prefs.DVHoch;
	doc->VHochSc = Prefs.DVHochSc;
	doc->VTief = Prefs.DVTief;
	doc->VTiefSc = Prefs.DVTiefSc;
	doc->VKapit = Prefs.DVKapit;
 	doc->Dpen = Prefs.Dpen;
 	doc->DpenText = Prefs.DpenText;
 	doc->Dbrush = Prefs.Dbrush;
 	doc->Dshade = Prefs.Dshade;
 	doc->Dshade2 = Prefs.Dshade2;
 	doc->DLineArt = PenStyle(Prefs.DLineArt);
 	doc->Dwidth = Prefs.Dwidth;
 	doc->DpenLine = Prefs.DpenLine;
 	doc->DshadeLine = Prefs.DshadeLine;
 	doc->DLstyleLine = PenStyle(Prefs.DLstyleLine);
 	doc->DwidthLine = Prefs.DwidthLine;
 	doc->MagMin = Prefs.MagMin;
 	doc->MagMax = Prefs.MagMax;
 	doc->MagStep = Prefs.MagStep;
 	doc->DbrushPict = Prefs.DbrushPict;
	doc->ShadePict = Prefs.ShadePict;
	doc->ScaleX = Prefs.ScaleX;
	doc->ScaleY = Prefs.ScaleY;
	doc->ScaleType = Prefs.ScaleType;
	doc->AspectRatio = Prefs.AspectRatio;
	doc->Before = Prefs.Before;
	doc->PagesSbS = Prefs.PagesSbS;
	doc->ShFrames = Prefs.ShFrames;
	doc->RandFarbig = Prefs.RandFarbig;
	doc->AutoLine = Prefs.AutoLine;
	doc->DocName = doc->DocName+cc.setNum(DocNr);
	doc->HasCMS = true;
	doc->CMSSettings.DefaultInputProfile = Prefs.DCMSset.DefaultInputProfile;
	doc->CMSSettings.DefaultInputProfile2 = Prefs.DCMSset.DefaultInputProfile2;
	doc->CMSSettings.DefaultMonitorProfile = Prefs.DCMSset.DefaultMonitorProfile;
	doc->CMSSettings.DefaultPrinterProfile = Prefs.DCMSset.DefaultPrinterProfile;
	doc->CMSSettings.DefaultIntentPrinter = Prefs.DCMSset.DefaultIntentPrinter;
	doc->CMSSettings.DefaultIntentMonitor = Prefs.DCMSset.DefaultIntentMonitor;
	doc->CMSSettings.DefaultIntentMonitor2 = Prefs.DCMSset.DefaultIntentMonitor2;
	doc->CMSSettings.SoftProofOn = Prefs.DCMSset.SoftProofOn;
	doc->CMSSettings.GamutCheck = Prefs.DCMSset.GamutCheck;
	doc->CMSSettings.CMSinUse = Prefs.DCMSset.CMSinUse;
	doc->ActiveLayer = 0;
	HaveDoc = TRUE;
	if (CMSavail)
		{
		OpenCMSProfiles();
#ifdef HAVE_CMS
		SoftProofing = Prefs.DCMSset.SoftProofOn;
		CMSuse = Prefs.DCMSset.CMSinUse;
		IntentPrinter = Prefs.DCMSset.DefaultIntentPrinter;
		IntentMonitor = Prefs.DCMSset.DefaultIntentMonitor;
#endif
		if ((Prefs.DCMSset.CMSinUse) && (Prefs.DCMSset.SoftProofOn))
			RecalcColors();
		}
	DocNr++;
	doc->Scale = 1.0;
	doc->AppMode = 1;
	doc->PageColors = Prefs.DColors;
	view=new ScribusView(this, doc, &Prefs);
	setCentralWidget(view);
	view->show();
	doc->setPage(b, h, tpr, lr, rr, br, sp, ab, atf, fp);
	slotNewPage(0);
	HaveNewDoc();
	view->Pages.at(0)->parentWidget()->hide();
	view->DocPages = view->Pages;
	view->Pages = view->MasterPages;
	doc->PageC = view->MasterPages.count();
	bool atfb = doc->PageAT;
	doc->PageAT = false;
	slotNewPage(0);
	doc->PageAT = atfb;
	view->MasterNames["Normal"] = 0;
	view->Pages.at(0)->PageNam = "Normal";
	view->Pages.at(0)->parentWidget()->hide();
	view->MasterPages = view->Pages;
	doc->PageC = view->DocPages.count();
	view->Pages = view->DocPages;
	doc->MasterP = false;
	view->Pages.at(0)->MPageNam = "Normal";
	view->Pages.at(0)->parentWidget()->show();
	doc->setUnModified();
	doc->loading = false;
	doc->ActPage = view->Pages.at(0);
	Sepal->Rebuild();
	return true;
}

bool ScribusApp::SetupDoc()
{
	float tpr = doc->PageM.Top;
	float lr = doc->PageM.Left;
	float rr = doc->PageM.Right;
	float br = doc->PageM.Bottom;	
	bool fp = doc->PageFP;
	bool fpe = doc->FirstPageLeft;
	float tpr2, lr2, rr2, br2;
	bool ret = false;
	ReformDoc* dia = new ReformDoc(this, tpr, lr, rr, br, fp, fpe, doc->Einheit);
	if (dia->exec())
		{
		tpr2 = dia->TopR->value() / UmReFaktor / 100.0;
		lr2 = dia->LeftR->value() / UmReFaktor / 100.0;
		rr2 = dia->RightR->value() / UmReFaktor / 100.0;
		br2 = dia->BottomR->value() / UmReFaktor / 100.0;
		fp = dia->Doppelseiten->isChecked();
		if (fp)
			doc->FirstPageLeft = dia->ErsteSeite->isChecked();
		doc->resetPage(tpr2, lr2, rr2, br2, fp);
		view->reformPages();
		doc->setModified();
		view->GotoPage(doc->ActPage->PageNr);
		view->DrawNew();
		Sepal->RebuildPage();
		ret = true;
		}
	delete dia;
	return ret;
}

void ScribusApp::HaveNewDoc()
{
	int a;
	DatPri->setEnabled(true);
	DatPDF->setEnabled(true);
	fileMenu->setItemEnabled(fid1, 1);
	fileMenu->setItemEnabled(fid4, 0);
	fileMenu->setItemEnabled(fid5, 1);
	fileMenu->setItemEnabled(fid6, 1);
	fileMenu->setItemEnabled(fid7, 1);
	exportMenu->setItemEnabled(fid8, 1);
	fileMenu->setItemEnabled(fid9, 1);
	if (PDFavailable)
		exportMenu->setItemEnabled(fid10, 1);
	fileMenu->setItemEnabled(fid11, 1);
	editMenu->setItemEnabled(edid1, 0);
	editMenu->setItemEnabled(edid2, 0);
	editMenu->setItemEnabled(edid3, 0);
	editMenu->setItemEnabled(edid6, 1);
	for (a=0; a<6; a++)
		{
		viewMenu->setItemEnabled(viewMenu->idAt(a), 1);
		}
	viewMenu->setItemEnabled(Markers, 1);
	viewMenu->setItemEnabled(FrameDr, 1);
	viewMenu->setItemEnabled(Bilder, 1);
	viewMenu->setItemEnabled(Ras, 1);
	viewMenu->setItemEnabled(uRas, 1);
	viewMenu->setItemChecked(uRas, doc->useRaster);
	menuBar()->setItemEnabled(pgmm, 1);
	menuBar()->setItemEnabled(exmn, 1);
	WerkTools->setEnabled(true);
	if (view->Pages.count() > 1)
		{
		pageMenu->setItemEnabled(pgmd, 1);
		pageMenu->setItemEnabled(pgmv, 1);
		}
	else
		{
		pageMenu->setItemEnabled(pgmd, 0);
		pageMenu->setItemEnabled(pgmv, 0);
		}
	editMenu->setItemEnabled(tman, 1);
	editMenu->setItemEnabled(jman, 1);
	CListe::Iterator it;
	QPixmap pm = QPixmap(15, 15);
	a = 0;
	ColorMenu->clear();
	ColorMenu->insertItem(tr("None"));
	for (it = doc->PageColors.begin(); it != doc->PageColors.end(); ++it)
		{
		pm.fill(doc->PageColors[it.key()].getRGBColor());
		ColorMenu->insertItem(QIconSet(pm), it.key());
		if (it.key() == doc->Dbrush)
			{
			ColorMenu->setItemChecked(ColorMenu->idAt(a), true);
			}
		a++;
		}
	Cpal->SetColors(doc->PageColors);
	setCaption(tr(doc->DocName));
	ShadeMenu->setItemChecked(ShadeMenu->idAt(11), true);
	connect(view, SIGNAL(changeUN(int)), this, SLOT(slotChangeUnit(int)));
	connect(view, SIGNAL(changeLA(int)), Lpal, SLOT(MarkActiveLayer(int)));
	Mpal->SetDoc(doc);
	Sepal->SetView(view);
	Spal->SetFormats(doc);
	Lpal->setLayers(&doc->Layers, &doc->ActiveLayer);
	view->LaMenu();
	view->setLayMenTxt(doc->ActiveLayer);
	doc->CurrentABStil = 0;
	slotChangeUnit(doc->Einheit);
  BuildFontMenu();
	if (doc->ShFrames)
		viewMenu->changeItem(FrameDr, tr("Hide Frames"));
	else
		viewMenu->changeItem(FrameDr, tr("Show Frames"));
	DatClo->setEnabled(true);
}

void ScribusApp::HaveNewSel(int Nr)
{
	PageItem *b;
	switch (Nr)
		{
		case -1:
			importMenu->changeItem(fid2, tr("Get Text/Picture..."));
			importMenu->setItemEnabled(fid2, 0);
			exportMenu->setItemEnabled(fid3, 0);
			menuBar()->setItemEnabled(Obm, 0);
			ObjMenu->setItemEnabled(ShapeM, 0);
			editMenu->setItemEnabled(edid1, 0);
			editMenu->setItemEnabled(edid2, 0);
			editMenu->setItemEnabled(edid4, 0);
			editMenu->setItemEnabled(edid5, 0);
			StilMenu->clear();
			WerkTools->KetteAus->setEnabled(false);
			WerkTools->KetteEin->setEnabled(false);
			WerkTools->Textedit->setEnabled(false);
			WerkTools->Rotiere->setEnabled(false);
			break;
		case 2:
			importMenu->changeItem(fid2, tr("Get Picture..."));
			importMenu->setItemEnabled(fid2, 1);
			editMenu->setItemEnabled(edid1, 1);
			editMenu->setItemEnabled(edid2, 1);
			editMenu->setItemEnabled(edid4, 0);
			editMenu->setItemEnabled(edid5, 0);
			menuBar()->setItemEnabled(Obm, 1);
			ObjMenu->setItemEnabled(ShapeM, 1);
			StilMenu->clear();
			StilMenu->insertItem(tr("Color"), ColorMenu);
			StilMenu->insertItem(tr("Invert"));
			WerkTools->KetteAus->setEnabled(false);
			WerkTools->KetteEin->setEnabled(false);
			WerkTools->Textedit->setEnabled(true);
			WerkTools->Rotiere->setEnabled(true);
 			Mpal->SetCurItem(doc->ActPage->SelItem.at(0));
			break;
		case 4:
			importMenu->changeItem(fid2, tr("Get Text..."));
			importMenu->setItemEnabled(fid2, 1);
			exportMenu->setItemEnabled(fid3, 1);
			editMenu->setItemEnabled(edid1, 1);
			editMenu->setItemEnabled(edid2, 1);
			editMenu->setItemEnabled(edid4, 0);
			editMenu->setItemEnabled(edid5, 0);
			menuBar()->setItemEnabled(Obm, 1);
			ObjMenu->setItemEnabled(ShapeM, 1);
			StilMenu->clear();
			StilMenu->insertItem(tr("Font"), FontMenu);
			StilMenu->insertItem(tr("Size"), SizeTMenu);
			StilMenu->insertItem(tr("Style"), TypeStyleMenu);
			StilMenu->insertItem(tr("Alignment"), AliMenu);
			StilMenu->insertItem(tr("Color"), ColorMenu);
			StilMenu->insertItem(tr("Shade"), ShadeMenu);
			WerkTools->Rotiere->setEnabled(true);
			b = doc->ActPage->SelItem.at(0);
			if ((b->NextBox != 0) || (b->BackBox != 0))
				{
				WerkTools->KetteAus->setEnabled(true);
				if ((b->BackBox != 0) && (b->Ptext.count() == 0))
					WerkTools->Textedit->setEnabled(false);
				else
					WerkTools->Textedit->setEnabled(true);
				}
			else
				WerkTools->Textedit->setEnabled(true);
			if (b->NextBox == 0)
				WerkTools->KetteEin->setEnabled(true);
			if (doc->MasterP)
				WerkTools->KetteEin->setEnabled(false);
 			Mpal->SetCurItem(b);
			doc->CurrentStyle = 0;
			doc->Vorlagen[0].LineSpa = b->LineSp;
			doc->Vorlagen[0].Ausri = b->Ausrich;
			break;
		case 8:
			importMenu->changeItem(fid2, tr("Get Text..."));
			importMenu->setItemEnabled(fid2, 1);
			exportMenu->setItemEnabled(fid3, 1);
			editMenu->setItemEnabled(edid1, 1);
			editMenu->setItemEnabled(edid2, 1);
			editMenu->setItemEnabled(edid4, 0);
			editMenu->setItemEnabled(edid5, 0);
			menuBar()->setItemEnabled(Obm, 1);
			ObjMenu->setItemEnabled(ShapeM, 0);
			StilMenu->clear();
			StilMenu->insertItem(tr("Font"), FontMenu);
			StilMenu->insertItem(tr("Size"), SizeTMenu);
			StilMenu->insertItem(tr("Style"), TypeStyleMenu);
			StilMenu->insertItem(tr("Color"), ColorMenu);
			StilMenu->insertItem(tr("Shade"), ShadeMenu);
			WerkTools->Rotiere->setEnabled(true);
			WerkTools->Textedit->setEnabled(false);
			WerkTools->KetteEin->setEnabled(false);
			WerkTools->KetteAus->setEnabled(false);
 			Mpal->SetCurItem(doc->ActPage->SelItem.at(0));
			doc->CurrentStyle = 0;
			break;
		default:
			importMenu->changeItem(fid2, tr("Get Text/Picture..."));
			importMenu->setItemEnabled(fid2, 0);
			exportMenu->setItemEnabled(fid3, 0);
			editMenu->setItemEnabled(edid1, 1);
			editMenu->setItemEnabled(edid2, 1);
			editMenu->setItemEnabled(edid4, 0);
			editMenu->setItemEnabled(edid5, 0);
			menuBar()->setItemEnabled(Obm, 1);
			StilMenu->clear();
			StilMenu->insertItem(tr("Color"), ColorMenu);
			StilMenu->insertItem(tr("Shade"), ShadeMenu);
			WerkTools->KetteAus->setEnabled(false);
			WerkTools->KetteEin->setEnabled(false);
			if (Nr != 5)
				WerkTools->Rotiere->setEnabled(true);
			else
				WerkTools->Rotiere->setEnabled(false);
 			Mpal->SetCurItem(doc->ActPage->SelItem.at(0));
			break;
		}
	doc->CurrentSel = Nr;
	if (doc->ActPage->SelItem.count() > 1)
		{
		ObjMenu->setItemEnabled(DistM, 1);
		ObjMenu->setItemEnabled(Gr, 1);
		if (doc->ActPage->SelItem.count() == 2)
			ObjMenu->setItemEnabled(PfadT, 1);
		}
	else
		{
		ObjMenu->setItemEnabled(DistM, 0);
		ObjMenu->setItemEnabled(Gr, 0);
		ObjMenu->setItemEnabled(PfadT, 0);
		}
	if (doc->ActPage->SelItem.count() != 0)
		{
		if(doc->ActPage->SelItem.at(0)->Groups.count() != 0)
			ObjMenu->setItemEnabled(UnGr, 1);
		else
			ObjMenu->setItemEnabled(UnGr, 0);
		}
}

void ScribusApp::slotDocCh(bool reb)
{
	if (reb)
		Tpal->BuildTree(view);
	if (!doc->isModified())
		{
		doc->setModified();
		setCaption(tr(doc->DocName) + "*");
		}
	if ((!doc->DocName.startsWith("Document")) && (!TemplateMode))
		{
		fileMenu->setItemEnabled(fid4, 1);
		DatSav->setEnabled(true);
		DatClo->setEnabled(true);
		}
}

void ScribusApp::UpdateRecent(QString fn)
{
	recentMenu->clear();
	if (RecentDocs.findIndex(fn) == -1)
		RecentDocs.prepend(fn);
	else
		{
		RecentDocs.remove(fn);
		RecentDocs.prepend(fn);
		}
	uint max = QMIN(Prefs.RecentDCount, RecentDocs.count());
	for (uint m = 0; m < max; m++)
		{
		recentMenu->insertItem(RecentDocs[m]);
		}
}

void ScribusApp::LoadRecent(int id)
{
	QString fn = recentMenu->text(id);
	QFileInfo fd(fn);
	if (!fd.exists())
		{
		RecentDocs.remove(fn);
		recentMenu->clear();
		uint max = QMIN(Prefs.RecentDCount, RecentDocs.count());
		for (uint m = 0; m < max; m++)
			{
			recentMenu->insertItem(RecentDocs[m]);
			}
		return;
		}
	if (HaveDoc)
		{
		if(!slotFileClose())
			return;
		}
  qApp->setOverrideCursor(QCursor(waitCursor), true);
	LadeDoc(recentMenu->text(id));
  qApp->setOverrideCursor(QCursor(arrowCursor), true);
}

bool ScribusApp::slotDocOpen()
{
	bool ret = false;
	if (HaveDoc)
		{
		if(!slotFileClose())
			return false;
		}
  if (CMSavail)
  	CloseCMSProfiles();
#ifdef HAVE_LIBZ
	QString fileName = CFileDialog(tr("Open"),tr("Documents (*.scd *scd.gz);; All Files (*)"));
#else
	QString fileName = CFileDialog(tr("Open"),tr("Documents (*.scd);; All Files (*)"));
#endif
  qApp->setOverrideCursor(QCursor(waitCursor), true);
	ret = LadeDoc(fileName);
  qApp->setOverrideCursor(QCursor(arrowCursor), true);
	return ret;
}
	
bool ScribusApp::LadeDoc(QString fileName)
{
	bool ret = false;
  if (!fileName.isEmpty())
  	{
		doc=new ScribusDoc();
		doc->AllFonts = &Prefs.AvailFonts;
		doc->Dsize = Prefs.DefSize;
		doc->GrabRad = Prefs.GrabRad;
		doc->minorGrid = Prefs.DminGrid;
		doc->majorGrid = Prefs.DmajGrid;
		doc->minorColor = Prefs.DminColor;
		doc->majorColor = Prefs.DmajColor;
		doc->papColor = Prefs.DpapColor;
		doc->margColor = Prefs.DmargColor;
  	doc->Dpen = Prefs.Dpen;
  	doc->DpenText = Prefs.DpenText;
  	doc->Dbrush = Prefs.Dbrush;
  	doc->Dshade = Prefs.Dshade;
  	doc->Dshade2 = Prefs.Dshade2;
  	doc->DLineArt = PenStyle(Prefs.DLineArt);
  	doc->Dwidth = Prefs.Dwidth;
  	doc->DpenLine = Prefs.DpenLine;
  	doc->DshadeLine = Prefs.DshadeLine;
  	doc->DLstyleLine = PenStyle(Prefs.DLstyleLine);
  	doc->DwidthLine = Prefs.DwidthLine;
  	doc->MagMin = Prefs.MagMin;
  	doc->MagMax = Prefs.MagMax;
  	doc->MagStep = Prefs.MagStep;
  	doc->DbrushPict = Prefs.DbrushPict;
		doc->ShadePict = Prefs.ShadePict;
		doc->ScaleX = Prefs.ScaleX;
		doc->ScaleY = Prefs.ScaleY;
		doc->ScaleType = Prefs.ScaleType;
		doc->AspectRatio = Prefs.AspectRatio;
		doc->Before = Prefs.Before;
		doc->Einheit = Prefs.Einheit;
		doc->PagesSbS = Prefs.PagesSbS;
		doc->ShFrames = Prefs.ShFrames;
		doc->RandFarbig = Prefs.RandFarbig;
		doc->AutoLine = Prefs.AutoLine;
		doc->Scale = 1.0;
		doc->AppMode = 1;
		doc->HasCMS = false;
		doc->ActiveLayer = 0;
		FMess->setText(tr("Loading..."));
		FProg->reset();
		view=new ScribusView(this, doc, &Prefs);
  	ScriXmlDoc *ss = new ScriXmlDoc();
  	connect(ss, SIGNAL(NewPage(int)), this, SLOT(slotNewPage(int)));
		setCentralWidget(view);
		qApp->processEvents();
		view->show();
		doc->loading = true;
#ifdef HAVE_CMS
		SoftProofing = false;
		Gamut = false;
		bool cmsu = CMSuse;
		CMSuse = false;
#endif
  	if(!ss->ReadDoc(fileName, Prefs.AvailFonts, doc, view, FProg))
  		{
  		delete ss;
  		delete doc;
  		delete view;
			FMess->setText("");
			FProg->reset();
  		return false;
  		}
  	delete ss;
		FMess->setText("");
		FProg->reset();
#ifdef HAVE_CMS
		CMSuse = cmsu;
#endif
		HaveDoc = true;
		if (!doc->HasCMS)
			{
			doc->CMSSettings.DefaultInputProfile = Prefs.DCMSset.DefaultInputProfile;
			doc->CMSSettings.DefaultInputProfile2 = Prefs.DCMSset.DefaultInputProfile2;
			doc->CMSSettings.DefaultMonitorProfile = Prefs.DCMSset.DefaultMonitorProfile;
			doc->CMSSettings.DefaultPrinterProfile = Prefs.DCMSset.DefaultPrinterProfile;
			doc->CMSSettings.DefaultIntentPrinter = Prefs.DCMSset.DefaultIntentPrinter;
			doc->CMSSettings.DefaultIntentMonitor = Prefs.DCMSset.DefaultIntentMonitor;
			doc->CMSSettings.DefaultIntentMonitor2 = Prefs.DCMSset.DefaultIntentMonitor2;
			doc->CMSSettings.SoftProofOn = Prefs.DCMSset.SoftProofOn;
			doc->CMSSettings.GamutCheck = Prefs.DCMSset.GamutCheck;
			doc->CMSSettings.CMSinUse = false;
			}
		if (CMSavail)
			{
			if (!InputProfiles.contains(doc->CMSSettings.DefaultInputProfile))
				doc->CMSSettings.DefaultInputProfile = Prefs.DCMSset.DefaultInputProfile;
			if (!InputProfiles.contains(doc->CMSSettings.DefaultInputProfile2))
				doc->CMSSettings.DefaultInputProfile2 = Prefs.DCMSset.DefaultInputProfile2;
			if (!MonitorProfiles.contains(doc->CMSSettings.DefaultMonitorProfile))
				doc->CMSSettings.DefaultMonitorProfile = Prefs.DCMSset.DefaultMonitorProfile;
			if (!PrinterProfiles.contains(doc->CMSSettings.DefaultPrinterProfile))
				doc->CMSSettings.DefaultPrinterProfile = Prefs.DCMSset.DefaultPrinterProfile;
#ifdef HAVE_CMS
			SoftProofing = doc->CMSSettings.SoftProofOn;
			Gamut = doc->CMSSettings.GamutCheck;
			CMSuse = doc->CMSSettings.CMSinUse;
			IntentPrinter = doc->CMSSettings.DefaultIntentPrinter;
			IntentMonitor = doc->CMSSettings.DefaultIntentMonitor;
#endif
			OpenCMSProfiles();
			if ((doc->CMSSettings.CMSinUse) && (doc->CMSSettings.SoftProofOn))
				{
				RecalcColors();
				view->RecalcPictures(&InputProfiles);
				}
			}
		Cpal->SetColors(doc->PageColors);
		doc->DocName = fileName;
		doc->MasterP = false;
		HaveNewDoc();
		if (view->MasterPages.count() == 0)
			{
			for (uint ax=0; ax<view->Pages.count(); ax++)
				{
				view->Pages.at(ax)->parentWidget()->hide();
				}
			view->DocPages = view->Pages;
			view->Pages = view->MasterPages;
			doc->PageC = view->MasterPages.count();
			bool atf = doc->PageAT;
			doc->PageAT = false;
			slotNewPage(0);
			doc->PageAT = atf;
			view->MasterNames["Normal"] = 0;
			view->Pages.at(0)->PageNam = "Normal";
			view->Pages.at(0)->parentWidget()->hide();
			view->MasterPages = view->Pages;
			doc->PageC = view->DocPages.count();
			view->Pages = view->DocPages;
			doc->MasterP = false;
			for (uint ay=0; ay<view->Pages.count(); ay++)
				{
				view->Pages.at(ay)->parentWidget()->show();
				}
			}
		doc->setUnModified();
		doc->loading = false;
		view->GotoPage(0);
		setActiveWindow();
		UpdateRecent(fileName);
  	FMess->setText(tr("Ready"));
		ret = true;
  	}
	else
		{
  	if (CMSavail)
			{
  		OpenCMSProfiles();
			if ((Prefs.DCMSset.CMSinUse) && (Prefs.DCMSset.SoftProofOn))
				RecalcColors();
			}
		}
	Sepal->Rebuild();
	return ret;
}

void ScribusApp::slotFileOpen()
{
  if (doc->ActPage->SelItem.count() != 0)
  	{
 		PageItem *b = doc->ActPage->SelItem.at(0);
  	if (b->PType == 2)
  		{
  		QString fileName = CFileDialog(tr("Open"),tr("Images (*.tif *.png *.jpg *.xpm);;Postscript (*.eps);;All Files (*)"), "", true);
  		if (!fileName.isEmpty())
  			{
  			b->EmProfile = "";
  			b->UseEmbedded = true;
  			b->IProfile = doc->CMSSettings.DefaultInputProfile;
				b->IRender = doc->CMSSettings.DefaultIntentMonitor2;
    		doc->ActPage->LoadPict(fileName, b->ItemNr);
    		doc->ActPage->AdjustPictScale(b);
    		doc->ActPage->update();
				slotDocCh();
  			}
  		}
  	if (b->PType == 4)
  		{
  		QString fileName = CFileDialog(tr("Open"),tr("Textfiles (*.txt);;All Files (*)"));
  		if (!fileName.isEmpty())
  			{
  			Serializer *ss = new Serializer(fileName);
  			if (ss->Read())
  				{
  				ss->GetText(b, doc->CurrentABStil);
  				}
  			delete ss;
    		doc->ActPage->update();
				slotDocCh();
  			}
  		}
  	}
}


void ScribusApp::slotFileSave()
{
  QString fn = doc->DocName;
	FMess->setText(tr("Saving..."));
	FProg->reset();
  ScriXmlDoc *ss = new ScriXmlDoc();
	qApp->processEvents();
  ss->WriteDoc(fn, doc, view, FProg);
	delete ss;
	doc->setUnModified();
	setCaption(fn);
	fileMenu->setItemEnabled(fid4, 0);
	DatSav->setEnabled(false);
	FProg->reset();
  FMess->setText(tr("Ready"));
}

void ScribusApp::slotFileSaveAs()
{
	QString fna;
  if (!doc->DocName.startsWith("Document"))
  	{
  	QFileInfo fi(doc->DocName);
  	fna = fi.dirPath()+"/"+fi.baseName()+".scd";
  	}
  else
  	{
  	QDir di = QDir();
  	fna = di.currentDirPath()+"/"+doc->DocName+".scd";
  	}
#ifdef HAVE_LIBZ
  QString fn = CFileDialog(tr("Save as"), tr("Documents (*.scd *scd.gz);; All Files (*)"), fna, false, false, true);
#else
  QString fn = CFileDialog(tr("Save as"), tr("Documents (*.scd);; All Files (*)"), fna, false, false, false);
#endif
  if (!fn.isEmpty())
  	{
  	QFile f(fn);
  	if (f.exists())
  		{
  		int exit=QMessageBox::warning(this,
  																	tr("Warning"),
  																	tr("Do you really want to overwrite the File:\n%1 ?").arg(fn),
                                		tr("No"),
                                		tr("Yes"),
                                		0, 0, 1);
  		if (exit != 1)
  			return;
  		}
		DoFileSave(fn);
  	}
  FMess->setText(tr("Ready"));
}

bool ScribusApp::DoFileSave(QString fn)
{
	FMess->setText(tr("Saving..."));
	FProg->reset();
 	ScriXmlDoc *ss = new ScriXmlDoc();
	qApp->processEvents();
 	ss->WriteDoc(fn, doc, view, FProg);
 	delete ss;
	doc->setUnModified();
	setCaption(fn);
	doc->DocName = fn;
	fileMenu->setItemEnabled(fid4, 0);
	DatSav->setEnabled(false);
	UpdateRecent(fn);
	FMess->setText("");
	FProg->reset();
	return true;
}

bool ScribusApp::slotFileClose()
{
  if (doc->isModified())
  	{
  	if (!queryExit())
  		return false;
  	}
	return DoFileClose();
}

bool ScribusApp::DoFileClose()
{
  uint a;
	if ((doc->UnData.UnCode == 0) && (doc->UnDoValid))
		delete doc->UnData.Item;
  if (CMSavail)
  	CloseCMSProfiles();
  Mpal->UnsetDoc();
	Sepal->Vie = 0;
	Sepal->Rebuild();
  Spal->SetFormats(0);
  view->close();
  for (a = 0; a<view->Pages.count(); a++)
  	{
  	delete view->Pages.at(a);
  	}
  delete view;
  delete doc;
  HaveDoc = FALSE;
	fileMenu->setItemEnabled(fid1, 0);
	importMenu->setItemEnabled(fid2, 0);
	exportMenu->setItemEnabled(fid3, 0);
	fileMenu->setItemEnabled(fid4, 0);
	fileMenu->setItemEnabled(fid5, 0);
	fileMenu->setItemEnabled(fid6, 0);
	fileMenu->setItemEnabled(fid7, 0);
	exportMenu->setItemEnabled(fid8, 0);
	fileMenu->setItemEnabled(fid9, 0);
	exportMenu->setItemEnabled(fid10, 0);
	fileMenu->setItemEnabled(fid11, 0);
	editMenu->setItemEnabled(edUndo, 0);
	editMenu->setItemEnabled(edid1, 0);
	editMenu->setItemEnabled(edid2, 0);
	editMenu->setItemEnabled(edid3, 0);
	editMenu->setItemEnabled(edid4, 0);
	editMenu->setItemEnabled(edid5, 0);
	editMenu->setItemEnabled(edid6, 0);
	for (a=0; a<6; a++)
		{
		viewMenu->setItemEnabled(viewMenu->idAt(a), 0);
		}
	viewMenu->setItemEnabled(Markers, 0);
	viewMenu->setItemEnabled(FrameDr, 0);
	viewMenu->setItemEnabled(Bilder, 0);
	viewMenu->setItemEnabled(Ras, 0);
	viewMenu->setItemEnabled(uRas, 0);
	viewMenu->setItemChecked(uRas, false);
	viewMenu->changeItem(Markers, tr("Hide Margins"));
	viewMenu->changeItem(FrameDr, tr("Hide Frames"));
	viewMenu->changeItem(Bilder, tr("Hide Images"));
	viewMenu->changeItem(Ras, tr("Show Guides"));
	editMenu->setItemEnabled(tman, 0);
	editMenu->setItemEnabled(jman, 0);
	menuBar()->setItemEnabled(pgmm, 0);
	menuBar()->setItemEnabled(exmn, 0);
	menuBar()->setItemEnabled(Obm, 0);
	WerkTools->setEnabled(false);
	ColorMenu->clear();
	Cpal->SetColors(Prefs.DColors);
  if (CMSavail)
		{
  	OpenCMSProfiles();
		if ((Prefs.DCMSset.CMSinUse) && (Prefs.DCMSset.SoftProofOn))
			RecalcColors();
		}
  FMess->setText(tr("Ready"));
  setCaption(tr("Scribus " VERSION));
  Tpal->ListView1->clear();
	Lpal->ClearInhalt();
	DatPri->setEnabled(false);
	DatPDF->setEnabled(false);
	DatSav->setEnabled(false);
	DatClo->setEnabled(false);
  PrinterUsed = false;
	return true;
}

void ScribusApp::slotFilePrint()
{
  QString fna, prn, cmd, scmd, cc, data, SepNam;
  int Anf, Ende, Nr;
  bool fil, sep, farbe, NoRaster;
  NoRaster = true;
  FMess->setText(tr("Printing..."));
  if (PrinterUsed)
  	{
  	prn = PDef.Pname;
  	fna = PDef.Dname;
  	}
  else
  	{
  	prn = "";
  	if (!doc->DocName.startsWith("Document"))
  		{
  		QFileInfo fi(doc->DocName);
  		fna = fi.dirPath()+"/"+fi.baseName()+".ps";
  		}
  	else
  		{
  		QDir di = QDir();
  		fna = di.currentDirPath()+"/"+doc->DocName+".ps";
  		}
  	}
	scmd = PDef.Command;
  for (uint p=0; p<view->Pages.count(); p++)
   	{
   	for (uint i=0; i<view->Pages.at(p)->Items.count(); i++)
   		{
   		if (view->Pages.at(p)->Items.at(i)->PType == 2)
   			if (view->Pages.at(p)->Items.at(i)->isRaster)
   				NoRaster = false;
   		}
   	}
  Druck *printer = new Druck(this, fna, prn, scmd, NoRaster);
  printer->setMinMax(1, view->Pages.count());
  printer->setFromTo(1, view->Pages.count());
  if (printer->exec())
  	{
  	qApp->setOverrideCursor(QCursor(waitCursor), true);
  	prn = printer->printerName();
  	fna = printer->outputFileName();
  	fil = printer->outputToFile();
  	Anf = printer->fromPage();
  	Ende = printer->toPage();
  	Nr = printer->numCopies();
  	sep = printer->outputSeparations();
  	SepNam = printer->separationName();
  	farbe = printer->color();
  	PDef.Pname = prn;
  	PDef.Dname = fna;
		if (printer->OtherCom->isChecked())
			PDef.Command = printer->Command->text();
  	PrinterUsed = true;
		PSLib *dd = getPSDriver(true, Prefs.AvailFonts, doc->UsedFonts, doc->PageColors, false);
		if (dd != NULL)
			{
 			if (printer->pageOrder() == QPrinter::FirstPageFirst)
				data =  view->CreatePS(dd, Anf-1, Ende, 1, sep, SepNam, farbe);
			else
				data =  view->CreatePS(dd, Ende-1, Anf-2, -1, sep, SepNam, farbe);
			if (fil)
				{
				QFile f(fna);	
				if (f.open(IO_WriteOnly))
					{
					QTextStream t(&f);
					t.writeRawBytes(data, data.length());
					f.close();	
					}
				}
			else
				{
				QFile f("/tmp/sc.ps");	
				if (f.open(IO_WriteOnly))
					{
					QTextStream t(&f);
					t.writeRawBytes(data, data.length());
					f.close();	
					}
				if (printer->OtherCom->isChecked())
					{
					cmd = printer->Command->text()+ " /tmp/sc.ps";
					system(cmd);
					}
				else
					{
					cmd = "lpr -P" + prn;
					if (Nr > 1)
						cmd += " -#" + cc.setNum(Nr);
					cmd += " /tmp/sc.ps";
					system(cmd);
					}
				system("rm -f /tmp/sc.ps");
				}
			delete dd;
			closePSDriver();
 			qApp->setOverrideCursor(QCursor(arrowCursor), true);
 			}
  	}
  delete printer;
	FMess->setText(tr("Ready"));
}

void ScribusApp::slotFileQuit()
{
	Mpal->UnsetDoc();
	close();
}

void ScribusApp::slotEditCut()
{
	uint a;
	NoFrameEdit();
	if ((HaveDoc) && (doc->ActPage->SelItem.count() != 0))
		{
		Buffer2 = "";
		PageItem *b = doc->ActPage->SelItem.at(0);
		if ((doc->AppMode == 7) && (b->HasSel))
			{
			for (a = 0; a < b->Ptext.count(); a++)
				{
				if (b->Ptext.at(a)->cselect)
					{
					Buffer2 += b->Ptext.at(a)->ch+"\t";
					Buffer2 += b->Ptext.at(a)->cfont+"\t";
					Buffer2 += QString::number(b->Ptext.at(a)->csize)+"\t";
					Buffer2 += b->Ptext.at(a)->ccolor+"\t";
					Buffer2 += QString::number(b->Ptext.at(a)->cextra)+"\t";
					Buffer2 += QString::number(b->Ptext.at(a)->cshade)+'\t';
					Buffer2 += QString::number(b->Ptext.at(a)->cstyle)+'\t';
					Buffer2 += QString::number(b->Ptext.at(a)->cab)+'\n';
					}
				}
			DeleteSel(b);
			b->Dirty = true;
			b->paintObj();
			BufferSet2 = true;
			}
		else
			{
  		ScriXmlDoc *ss = new ScriXmlDoc();
			Buffer3 = ss->WriteElem(&doc->ActPage->SelItem, doc);
			BufferSet = true;
			doc->ActPage->DeleteItem();
			}
		slotDocCh();
		editMenu->setItemEnabled(edid3, 1);
		}
}

void ScribusApp::slotEditCopy()
{
	uint a;
	NoFrameEdit();
	if ((HaveDoc) && (doc->ActPage->SelItem.count() != 0))
		{
		Buffer2 = "";
		PageItem *b = doc->ActPage->SelItem.at(0);
		if ((doc->AppMode == 7) && (b->HasSel))
			{
			for (a = 0; a < b->Ptext.count(); a++)
				{
				if (b->Ptext.at(a)->cselect)
					{
					Buffer2 += b->Ptext.at(a)->ch+"\t";
					Buffer2 += b->Ptext.at(a)->cfont+"\t";
					Buffer2 += QString::number(b->Ptext.at(a)->csize)+"\t";
					Buffer2 += b->Ptext.at(a)->ccolor+"\t";
					Buffer2 += QString::number(b->Ptext.at(a)->cextra)+"\t";
					Buffer2 += QString::number(b->Ptext.at(a)->cshade)+'\t';
					Buffer2 += QString::number(b->Ptext.at(a)->cstyle)+'\t';
					Buffer2 += QString::number(b->Ptext.at(a)->cab)+'\n';
					}
				}
			BufferSet2 = true;
			}
		else
			{
  		ScriXmlDoc *ss = new ScriXmlDoc();
			Buffer3 = ss->WriteElem(&doc->ActPage->SelItem, doc);
			delete ss;
			BufferSet = true;
			}
		editMenu->setItemEnabled(edid3, 1);
		}
}

void ScribusApp::slotEditPaste()
{
	struct Pti *hg;
	NoFrameEdit();
	if (HaveDoc)
		{
		if ((doc->AppMode == 7) && (BufferSet2))
			{
			PageItem *b = doc->ActPage->SelItem.at(0);
			QTextStream t(&Buffer2, IO_ReadOnly);
			QString cc;
			while (!t.atEnd())
				{
				cc = t.readLine();
				QStringList wt;
				QStringList::Iterator it;
				wt = QStringList::split("\t", cc);
				it = wt.begin();
				hg = new Pti;
				hg->ch = (*it);
				it++;
				hg->cfont = *it;
				it++;
				hg->csize = (*it).toInt();
				it++;
				hg->ccolor = *it;
				it++;
				hg->cextra = (*it).toInt();
				it++;
				hg->cshade = (*it).toInt();
				hg->cselect = false;
				it++;
				hg->cstyle = (*it).toInt();
				it++;
				hg->cab = (*it).toInt();
 				b->Ptext.insert(b->CPos, hg);
 				b->CPos += 1;
				hg->PRot = 0;
				hg->PtransX = 0;
				hg->PtransY = 0;
 				}
 			if (b->CPos < int(b->Ptext.count())) { b->Dirty = true; }
 			b->paintObj();
			}
		else
			{
			if (BufferSet);
				{
				slotElemRead(Buffer3, 0, 0, false, true);
				doc->ActPage->SelectItemNr(doc->ActPage->Items.count()-1);
				}	
			}
		slotDocCh();
		}
}

void ScribusApp::SelectAll()
{
	uint a;
	PageItem *b = doc->ActPage->SelItem.at(0);
	for (a = 0; a < b->Ptext.count(); a++)
		{
		b->Ptext.at(a)->cselect = true;
		}
	b->HasSel = true;
	b->Dirty = true;
	b->paintObj();
	EnableTxEdit();
}

void ScribusApp::DeleteText()
{
	PageItem *b = doc->ActPage->SelItem.at(0);
	DeleteSel(b);
	b->Dirty = true;
	b->paintObj();
	slotDocCh();
}

void ScribusApp::EnableTxEdit()
{
	editMenu->setItemEnabled(edid1, 1);
	editMenu->setItemEnabled(edid2, 1);
	editMenu->setItemEnabled(edid4, 1);
}

void ScribusApp::DisableTxEdit()
{
	editMenu->setItemEnabled(edid1, 0);
	editMenu->setItemEnabled(edid2, 0);
	editMenu->setItemEnabled(edid4, 0);
}

void ScribusApp::slotHelpAbout()
{
	void *mo;
	char *error;
	typedef About* (*sdem)(QWidget *d);
	sdem demo;
	QString pfad = PREL;
	pfad += "/share/scribus/libs/libabout.so";
	mo = dlopen(pfad, RTLD_LAZY);
	if (!mo)
		{
		cout << "Can't find Plugin" << endl;
		return;
		}
	dlerror();
	demo = (sdem)dlsym(mo, "Run");
	if ((error = dlerror()) != NULL)
		{
		cout << "Can't find Symbol" << endl;
		dlclose(mo);
		return;
		}
	About* dia = (*demo)(this);
	dia->exec();
	delete dia;
	dlclose(mo);
}

void ScribusApp::slotHelpAboutQt()
{
  QMessageBox::aboutQt(this,tr("About Qt"));
}

void ScribusApp::slotOnlineHelp()
{
	HelpBrowser *dia = new HelpBrowser(this, tr("Scribus Manual"));
	dia->show();
}

void ScribusApp::ToggleTips()
{
  tipsOn = !tipsOn;
  helpMenu->setItemChecked(tip, tipsOn);
  QToolTip::setEnabled(tipsOn);
}

void ScribusApp::SaveText()
{
  QString fn = CFileDialog(tr("Save as"), tr("Textfiles (*.txt);;All Files (*)"), "", false, false);
  if (!fn.isEmpty())
  	{
    Serializer *se = new Serializer(fn);
    se->PutText(doc->ActPage->SelItem.at(0));
    se->Write();
    delete se;
  	}
}

void ScribusApp::applyNewMaster(QString name)
{
	if (name == tr("Normal"))
		name = "Normal";
	doc->ActPage->MPageNam = name;
}

void ScribusApp::slotNewPageP(int wo, QString templ)
{
	NoFrameEdit();
	doc->ActPage->Deselect();
	doc->UnDoValid = false;
	CanUndo();
	slotNewPage(wo);
	applyNewMaster(templ);
	Sepal->RebuildPage();
}

/** Erzeugt eine neue Seite */
void ScribusApp::slotNewPageM()
{
	int wo, cc;
	NoFrameEdit();
	doc->ActPage->Deselect();
	InsPage *dia = new InsPage(this, view, doc->ActPage->PageNr, view->Pages.count(), doc->PageFP);
	if (dia->exec())
		{
		doc->UnDoValid = false;
		CanUndo();
		wo = dia->ActualPage->value();
		switch (dia->Where->currentItem())
			{
			case 0:
				wo -= 1;
				for (cc = 0; cc < dia->NumPages->value(); cc++)
					{
					slotNewPage(wo);
					if (doc->PageFP)
						{
 						if ((doc->ActPage->PageNr % 2 == 0) && (doc->FirstPageLeft))
							applyNewMaster(dia->Based->currentText());
 						if ((doc->ActPage->PageNr % 2 == 1) && (doc->FirstPageLeft))
							applyNewMaster(dia->Based2->currentText());
 						if ((doc->ActPage->PageNr % 2 == 0) && (!doc->FirstPageLeft))
							applyNewMaster(dia->Based2->currentText());
 						if ((doc->ActPage->PageNr % 2 == 1) && (!doc->FirstPageLeft))
							applyNewMaster(dia->Based->currentText());
						}
					else
						applyNewMaster(dia->Based->currentText());
					wo ++;
					}
				break;
			case 1:
				for (cc = 0; cc < dia->NumPages->value(); cc++)
					{
					slotNewPage(wo);
					if (doc->PageFP)
						{
 						if ((doc->ActPage->PageNr % 2 == 0) && (doc->FirstPageLeft))
							applyNewMaster(dia->Based->currentText());
 						if ((doc->ActPage->PageNr % 2 == 1) && (doc->FirstPageLeft))
							applyNewMaster(dia->Based2->currentText());
 						if ((doc->ActPage->PageNr % 2 == 0) && (!doc->FirstPageLeft))
							applyNewMaster(dia->Based2->currentText());
 						if ((doc->ActPage->PageNr % 2 == 1) && (!doc->FirstPageLeft))
							applyNewMaster(dia->Based->currentText());
						}
					else
						applyNewMaster(dia->Based->currentText());
					wo ++;
					}
				break;
			case 2:
				for (cc = 0; cc < dia->NumPages->value(); cc++)
					{
					slotNewPage(view->Pages.count());
					if (doc->PageFP)
						{
 						if ((doc->ActPage->PageNr % 2 == 0) && (doc->FirstPageLeft))
							applyNewMaster(dia->Based->currentText());
 						if ((doc->ActPage->PageNr % 2 == 1) && (doc->FirstPageLeft))
							applyNewMaster(dia->Based2->currentText());
 						if ((doc->ActPage->PageNr % 2 == 0) && (!doc->FirstPageLeft))
							applyNewMaster(dia->Based2->currentText());
 						if ((doc->ActPage->PageNr % 2 == 1) && (!doc->FirstPageLeft))
							applyNewMaster(dia->Based->currentText());
						}
					else
						applyNewMaster(dia->Based->currentText());
					}
				break;
			}
		Sepal->RebuildPage();
		}
	delete dia;
}

void ScribusApp::slotNewPage(int w)
{
	view->addPage(w);
	if (view->Pages.count() > 1)
		{
		pageMenu->setItemEnabled(pgmd, 1);
		pageMenu->setItemEnabled(pgmv, 1);
		}
	connect(doc->ActPage, SIGNAL(Amode(int)), this, SLOT(setAppMode(int)));
	connect(doc->ActPage, SIGNAL(PaintingDone()), this, SLOT(slotSelect()));
	connect(doc->ActPage, SIGNAL(HaveSel(int)), this, SLOT(HaveNewSel(int)));
	connect(doc->ActPage, SIGNAL(DocChanged()), this, SLOT(slotDocCh()));
	connect(doc->ActPage, SIGNAL(ClipPo(float, float)), Npal, SLOT(SetXY(float, float)));
	connect(doc->ActPage, SIGNAL(HavePoint(bool, bool)), Npal, SLOT(HaveNode(bool, bool)));
	connect(doc->ActPage, SIGNAL(PolyOpen()), Npal, SLOT(IsOpen()));
	connect(doc->ActPage, SIGNAL(PStatus(int, uint)), Npal, SLOT(PolyStatus(int, uint)));
	connect(doc->ActPage, SIGNAL(MousePos(float, float)), this, SLOT(ReportMP(float, float)));
	connect(doc->ActPage, SIGNAL(ItemPos(float, float)), Mpal, SLOT(setXY(float, float)));
	connect(doc->ActPage, SIGNAL(ItemGeom(float, float)), Mpal, SLOT(setBH(float, float)));
	connect(doc->ActPage, SIGNAL(SetAngle(float)), Mpal, SLOT(setR(float)));
	connect(doc->ActPage, SIGNAL(ItemRadius(float)), Mpal, SLOT(setRR(float)));
	connect(doc->ActPage, SIGNAL(ItemTextAttr(float)), Mpal, SLOT(setLsp(float)));
	connect(doc->ActPage, SIGNAL(ItemTextSize(int)), Mpal, SLOT(setSize(int)));
	connect(doc->ActPage, SIGNAL(ItemTextUSval(float)), Mpal, SLOT(setExtra(float)));
	connect(doc->ActPage, SIGNAL(HaveSel(int)), Mpal, SLOT(NewSel(int)));
	connect(doc->ActPage, SIGNAL(SetLocalValues(float, float, float, float)), Mpal, SLOT(setLvalue(float, float, float, float)));
	connect(doc->ActPage, SIGNAL(SetSizeValue(float)), Mpal, SLOT(setSvalue(float)));
	connect(doc->ActPage, SIGNAL(ItemTextStil(int)), Mpal, SLOT(setStil(int)));
	connect(doc->ActPage, SIGNAL(ItemTextAbs(int)), Mpal, SLOT(setAli(int)));
	connect(doc->ActPage, SIGNAL(SetLineArt(PenStyle, PenCapStyle, PenJoinStyle)), Mpal, SLOT( setLIvalue(PenStyle, PenCapStyle, PenJoinStyle)));
	connect(doc->ActPage, SIGNAL(ItemFarben(QString, QString, int, int)), this, SLOT(setCSMenu(QString, QString, int, int)));
	connect(doc->ActPage, SIGNAL(ItemFarben(QString, QString, int, int)), Cpal, SLOT(setActFarben(QString, QString, int, int)));
	connect(doc->ActPage, SIGNAL(ItemTextFont(QString)), this, SLOT(AdjustFontMenu(QString)));
	connect(doc->ActPage, SIGNAL(ItemTextSize(int)), this, SLOT(setFSizeMenu(int)));
	connect(doc->ActPage, SIGNAL(ItemTextStil(int)), this, SLOT(setStilvalue(int)));
	connect(doc->ActPage, SIGNAL(ItemTextAbs(int)), this, SLOT(setAbsValue(int)));
	connect(doc->ActPage, SIGNAL(HasTextSel()), this, SLOT(EnableTxEdit()));
	connect(doc->ActPage, SIGNAL(HasNoTextSel()), this, SLOT(DisableTxEdit()));
	connect(doc->ActPage, SIGNAL(CopyItem()), this, SLOT(slotEditCopy()));
	connect(doc->ActPage, SIGNAL(CutItem()), this, SLOT(slotEditCut()));
	connect(doc->ActPage, SIGNAL(LoadPic()), this, SLOT(slotFileOpen()));
	connect(doc->ActPage, SIGNAL(ModifyIt()), this, SLOT(ModifyObject()));
	connect(doc->ActPage, SIGNAL(AnnotProps()), this, SLOT(ModifyAnnot()));
	connect(doc->ActPage, SIGNAL(ToScrap(QString)), this, SLOT(PutScrap(QString)));
	connect(doc->ActPage, SIGNAL(UndoAvail()), this, SLOT(CanUndo()));
	connect(doc->ActPage, SIGNAL(LoadElem(QString, int ,int, bool, bool)), this, SLOT(slotElemRead(QString, int, int, bool, bool)));
	slotDocCh(!doc->loading);
}

/** Ansicht absolut zoomen */
void ScribusApp::slotZoomAbs(float z)
{
	doc->Scale = z;
	view->slotDoZoom();
}

void ScribusApp::slotZoomFit()
{
	float dx = (view->width()-50) / (doc->PageB+30);
	float dy = (view->height()-70) / (doc->PageH+30);
	if (dx > dy)
		{
		slotZoomAbs(dy);
		}
	else
		{
		slotZoomAbs(dx);
		}
}

/** Ansicht 20 % */
void ScribusApp::slotZoom20()
{
	slotZoomAbs(0.2);
}

/** Ansicht 50 % */
void ScribusApp::slotZoom50()
{
	slotZoomAbs(0.5);
}

/** Ansicht 75 % */
void ScribusApp::slotZoom75()
{
	slotZoomAbs(0.75);
}

/** Ansicht 100 % */
void ScribusApp::slotZoom100()
{
	slotZoomAbs(1.0);
}

/** Ansicht 200 % */
void ScribusApp::slotZoom200()
{
	slotZoomAbs(2.0);
}

void ScribusApp::ToggleMarks()
{
	if (doc->Marks)
	{
		doc->Marks = FALSE;
		viewMenu->changeItem(Markers, tr("Show Margins"));
	}
	else
	{
		doc->Marks = TRUE;
		viewMenu->changeItem(Markers, tr("Hide Margins"));
	}
	view->DrawNew();
}

void ScribusApp::ToggleFrames()
{
	if (doc->ShFrames)
	{
		doc->ShFrames = FALSE;
		viewMenu->changeItem(FrameDr, tr("Show Frames"));
	}
	else
	{
		doc->ShFrames = TRUE;
		viewMenu->changeItem(FrameDr, tr("Hide Frames"));
	}
	view->DrawNew();
}

void ScribusApp::ToggleMpal()
{
	if (Mpal->Sichtbar)
	{
  	Prefs.Mpalx = Mpal->pos().x();
  	Prefs.Mpaly = Mpal->pos().y();
		Mpal->hide();
		toolMenu->changeItem(viewMpal, tr("Show Measurements"));
	}
	else
	{
		Mpal->show();
		toolMenu->changeItem(viewMpal, tr("Hide Measurements"));
	}
}

void ScribusApp::ToggleTpal()
{
	if (Tpal->isVisible())
		{
  	Prefs.Tpalx = Tpal->pos().x();
  	Prefs.Tpaly = Tpal->pos().y();
		Tpal->close();
		toolMenu->changeItem(viewTpal, tr("Show Outline"));
		}
	else
		{
		if (HaveDoc)
			Tpal->BuildTree(view);
		Tpal->show();
		toolMenu->changeItem(viewTpal, tr("Hide Outline"));
		}
}

void ScribusApp::ToggleBpal()
{
	if (ScBook->isVisible())
		{
  	Prefs.SCpalx = ScBook->pos().x();
  	Prefs.SCpaly = ScBook->pos().y();
  	Prefs.SCpalw = ScBook->size().width();
  	Prefs.SCpalh = ScBook->size().height();
		ScBook->close();
		toolMenu->changeItem(viewBpal, tr("Show Scrapbook"));
		}
	else
		{
		ScBook->show();
		toolMenu->changeItem(viewBpal, tr("Hide Scrapbook"));
		}
}

void ScribusApp::ToggleLpal()
{
	if (Lpal->isVisible())
		{
  	Prefs.Lpalx = Lpal->pos().x();
  	Prefs.Lpaly = Lpal->pos().y();
		Lpal->close();
		toolMenu->changeItem(viewLpal, tr("Show Layers"));
		}
	else
		{
		if (HaveDoc)
			Lpal->setLayers(&doc->Layers, &doc->ActiveLayer);
		Lpal->show();
		toolMenu->changeItem(viewLpal, tr("Hide Layers"));
		}
}

void ScribusApp::ToggleSepal()
{
	if (Sepal->isVisible())
		{
  	Prefs.Sepalx = Sepal->pos().x();
  	Prefs.Sepaly = Sepal->pos().y();
		Prefs.SepalT = Sepal->TemplList->Thumb;
		Prefs.SepalN = Sepal->PageView->Namen;
		Sepal->close();
		toolMenu->changeItem(viewSepal, tr("Show Page Palette"));
		}
	else
		{
		Sepal->show();
		toolMenu->changeItem(viewSepal, tr("Hide Page Palette"));
		}
}

void ScribusApp::ToggleSpal()
{
	if (Spal->Sichtbar)
	{
  	Prefs.Spalx = Spal->pos().x();
  	Prefs.Spaly = Spal->pos().y();
		Spal->hide();
		toolMenu->changeItem(viewSpal, tr("Show Styles"));
	}
	else
	{
		if (HaveDoc)
			Spal->SetFormats(doc);
		Spal->show();
		toolMenu->changeItem(viewSpal, tr("Hide Styles"));
	}
}

void ScribusApp::ToggleCpal()
{
	if (Cpal->Sichtbar)
	{
  	Prefs.Cpalx = Cpal->pos().x();
  	Prefs.Cpaly = Cpal->pos().y();
		Cpal->hide();
		toolMenu->changeItem(viewCpal, tr("Show Colors"));
	}
	else
	{
		Cpal->show();
		toolMenu->changeItem(viewCpal, tr("Hide Colors"));
	}
}

void ScribusApp::ToggleTools()
{
	if (WerkTools->Sichtbar)
	{
		WerkTools->hide();
		toolMenu->changeItem(viewTools, tr("Show Tools"));
	}
	else
	{
		WerkTools->show();
		toolMenu->changeItem(viewTools, tr("Hide Tools"));
	}
}

void ScribusApp::TogglePics()
{
	uint a, b;
	if (doc->ShowPic)
		{
		viewMenu->changeItem(Bilder, tr("Show Images"));
		doc->ShowPic = FALSE;
		}
	else
		{
		viewMenu->changeItem(Bilder, tr("Hide Images"));
		doc->ShowPic = TRUE;
		}
	for (a=0; a<view->Pages.count(); a++)
		{
		for (b=0; b<view->Pages.at(a)->Items.count(); b++)
			{
			if (view->Pages.at(a)->Items.at(b)->PType == 2)
				{
				view->Pages.at(a)->Items.at(b)->PicArt = doc->ShowPic;
				}
			}
		view->Pages.at(a)->update();
		}
}

void ScribusApp::ToggleRaster()
{
	uint a;
	if (doc->Raster)
		{
		viewMenu->changeItem(Ras, tr("Show Guides"));
		doc->Raster = FALSE;
		}
	else
		{
		viewMenu->changeItem(Ras, tr("Hide Guides"));
		doc->Raster = TRUE;
		}
	for (a=0; a<view->Pages.count(); a++)
		{
		view->Pages.at(a)->update();
		}
}

void ScribusApp::ToggleURaster()
{
	doc->useRaster = !doc->useRaster;
	viewMenu->setItemChecked(uRas, doc->useRaster);
}

void ScribusApp::ToggleFrameEdit()
{
	if (doc->EditClip)
		{
		NoFrameEdit();
		}
	else
		{
		Npal->setDoc(doc);
		Npal->MoveN();
		Npal->HaveNode(false, false);
		Npal->MoveNode->setOn(true);
		Npal->show();
		doc->EditClipMode = 0;
		doc->EditClip = TRUE;
		WerkTools->Select->setEnabled(false);
		WerkTools->Rotiere->setEnabled(false);
		WerkTools->Textedit->setEnabled(false);
		WerkTools->Zoom->setEnabled(false);
		WerkTools->Texte->setEnabled(false);
		WerkTools->BildB->setEnabled(false);
		WerkTools->Rechteck->setEnabled(false);
		WerkTools->Kreis->setEnabled(false);
		WerkTools->Linien->setEnabled(false);
		WerkTools->Polygon->setEnabled(false);
		WerkTools->PolyLin->setEnabled(false);
		WerkTools->KetteEin->setEnabled(false);
		WerkTools->KetteAus->setEnabled(false);
		WerkTools->PDFTool->setEnabled(false);
		WerkTools->PDFaTool->setEnabled(false);
		ObjMenu->setItemEnabled(Loesch, false);
		if (doc->ActPage->SelItem.count() != 0)
			{
			doc->ActPage->MarkClip(doc->ActPage->SelItem.at(0));
			Npal->PolyStatus(doc->ActPage->SelItem.at(0)->PType, doc->ActPage->SelItem.at(0)->PoLine.size());
			}
		}
	ShapeMenu->setItemChecked(ShapeEdit, doc->EditClip);
}

void ScribusApp::NoFrameEdit()
{
  Prefs.Npalx = Npal->pos().x();
  Prefs.Npaly = Npal->pos().y();
	Npal->hide();
	doc->EditClip = FALSE;
	WerkTools->Select->setEnabled(true);
	WerkTools->Select->setOn(true);
	WerkTools->Zoom->setEnabled(true);
	WerkTools->Texte->setEnabled(true);
	WerkTools->BildB->setEnabled(true);
	WerkTools->Rechteck->setEnabled(true);
	WerkTools->Kreis->setEnabled(true);
	WerkTools->Linien->setEnabled(true);
	WerkTools->Polygon->setEnabled(true);
	WerkTools->PolyLin->setEnabled(true);
	WerkTools->PDFTool->setEnabled(true);
	WerkTools->PDFaTool->setEnabled(true);
	WerkTools->Textedit->setOn(false);
	ObjMenu->setItemEnabled(Loesch, true);
	ShapeMenu->setItemChecked(ShapeEdit, doc->EditClip);
	if (doc->ActPage->SelItem.count() != 0)
		{
		HaveNewSel(doc->ActPage->SelItem.at(0)->PType);
		doc->ActPage->RefreshItem(doc->ActPage->SelItem.at(0));
		}
	else
		HaveNewSel(-1);
}

void ScribusApp::slotSelect()
{
  WerkTools->Select->setOn(true);
	WerkTools->Rotiere->setOn(false);
	WerkTools->Textedit->setOn(false);
	WerkTools->Zoom->setOn(false);
	WerkTools->Texte->setOn(false);
	WerkTools->BildB->setOn(false);
	WerkTools->Rechteck->setOn(false);
	WerkTools->Kreis->setOn(false);
	WerkTools->Linien->setOn(false);
	WerkTools->Polygon->setOn(false);
	WerkTools->PolyLin->setOn(false);
	WerkTools->KetteEin->setOn(false);
	WerkTools->KetteAus->setOn(false);
	WerkTools->PDFTool->setOn(false);
	WerkTools->PDFaTool->setOn(false);
  setAppMode(1);
}

void ScribusApp::ModeFromTB(int m)
{
	if (m == 10)
		doc->ElemToLink = doc->ActPage->SelItem.at(0);
	if (doc->AppMode == 13)
		return;
	setAppMode(m);
}

void ScribusApp::setAppMode(int mode)
{
	PageItem *b;
	setActiveWindow();
	if (HaveDoc)
		{
		if (doc->ActPage->SelItem.count() != 0)
			b = doc->ActPage->SelItem.at(0);
		else
			b = 0;
		int oldMode = doc->AppMode;
		doc->AppMode = mode;
		if (oldMode == 7)
			{
			disconnect(CurTimer, SIGNAL(timeout()), doc->ActPage, SLOT(BlinkCurs()));
			CurTimer->stop();
			delete CurTimer;
			menuBar()->setItemEnabled(Obm, 1);
			if (BufferSet)
				{
				editMenu->setItemEnabled(edid3, 1);
				}
			else
				{
				editMenu->setItemEnabled(edid3, 0);
				}
			editMenu->setItemEnabled(edid4, 0);
			editMenu->setItemEnabled(edid5, 0);
			doc->ActPage->slotDoCurs(false);
			if (b != 0)
				doc->ActPage->RefreshItem(b);
			}
		if (mode == 7)
			{
			if (b != 0)
				{
				if ((b->PType == 6) || (b->PType == 7) || (b->PType == 8))
					{
					doc->AppMode = 1;
					ToggleFrameEdit();
					return;
					}
				}
  		WerkTools->Select->setOn(false);
			WerkTools->Textedit->setOn(true);
			doc->ActPage->slotDoCurs(true);
			menuBar()->setItemEnabled(Obm, 0);
			CurTimer = new QTimer(doc->ActPage);
			connect(CurTimer, SIGNAL(timeout()), doc->ActPage, SLOT(BlinkCurs()));
			CurTimer->start(500);
			if (b != 0)
				{
				if (b->HasSel)
					{
					editMenu->setItemEnabled(edid1, 1);
					editMenu->setItemEnabled(edid2, 1);
					editMenu->setItemEnabled(edid4, 1);
					editMenu->setItemEnabled(edid5, 1);
					}
				else
					{
					editMenu->setItemEnabled(edid1, 0);
					editMenu->setItemEnabled(edid2, 0);
					editMenu->setItemEnabled(edid4, 0);
					editMenu->setItemEnabled(edid5, 1);
					}
				doc->ActPage->RefreshItem(b);
				}
			if (BufferSet2)
				{
				editMenu->setItemEnabled(edid3, 1);
				}
			else
				{
				editMenu->setItemEnabled(edid3, 0);
				}
			}
		if (mode == 13)
			{
			if (doc->ActPage->SelItem.count() != 0)
				doc->ActPage->Deselect();
			}
		if (mode == 6)
			qApp->setOverrideCursor(QCursor(loadIcon("LupeZ.xpm")), true);
		else
			qApp->setOverrideCursor(QCursor(ArrowCursor), true);
		}
}

void ScribusApp::Aktiv()
{
	setActiveWindow();
	raise();
}

void ScribusApp::setItemTypeStyle(int id)
{
	int a = TypeStyleMenu->indexOf(id);
	int b = 0;
	switch (a)
		{
		case 0:
			b = 0;
			break;
		case 1:
			b = 32;
			break;
		case 2:
			b = 4;
			break;
		case 3:
			b = 8;
			break;
		case 4:
			b = 16;
			break;
		case 5:
			b = 64;
			break;
		case 6:
			b = 1;
			break;
		case 7:
			b = 2;
			break;
		}
	setItemHoch(b);
}

void ScribusApp::setStilvalue(int s)
{
	uint a;
	doc->CurrentStyle = s;
	for (a = 0; a < TypeStyleMenu->count(); a++)
		{
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(a), false);
		}
	if (s == 0)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(0), true);
	if (s & 32)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(1), true);
	if (s & 4)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(2), true);
	if (s & 8)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(3), true);
	if (s & 16)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(4), true);
	if (s & 64)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(5), true);
	if (s & 1)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(6), true);
	if (s & 2)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(7), true);
	emit TextStil(s);
}

void ScribusApp::setItemHoch(int h)
{
	if (doc->ActPage->SelItem.count() != 0)
		{
		setActiveWindow();
		if (h == 0)
			doc->CurrentStyle = 0;
		else
			{
			doc->CurrentStyle = doc->CurrentStyle ^ h;
			if ((h == 1) && (doc->CurrentStyle & 2))
				doc->CurrentStyle = doc->CurrentStyle & ~2;
			if ((h == 2) && (doc->CurrentStyle & 1))
				doc->CurrentStyle = doc->CurrentStyle & ~1;
			}
		setStilvalue(doc->CurrentStyle);
		doc->ActPage->chTyStyle(h);
		slotDocCh();
		}
}

void ScribusApp::DeletePage2(int pg)
{
	NoFrameEdit();
	if (view->Pages.count() == 1)
		return;
	view->delPage(pg);
	view->reformPages();
	if (view->Pages.count() == 1)
		{
		pageMenu->setItemEnabled(pgmd, 0);
		pageMenu->setItemEnabled(pgmv, 0);
		}
	slotDocCh();
	doc->UnDoValid = false;
	CanUndo();
	Sepal->RebuildPage();
}

void ScribusApp::DeletePage()
{
	int a, pg;
	NoFrameEdit();
	DelPages *dia = new DelPages(this, doc->ActPage->PageNr+1, view->Pages.count());
	if (dia->exec())
		{
		pg = dia->FromPage->value()-1;
		for (a = pg; a < dia->ToPage->value(); a++)
			{
			view->delPage(pg);
			}
		view->reformPages();
		if (view->Pages.count() == 1)
			{
			pageMenu->setItemEnabled(pgmd, 0);
			pageMenu->setItemEnabled(pgmv, 0);
			}
		slotDocCh();
		doc->UnDoValid = false;
		CanUndo();
		Sepal->RebuildPage();
		}
	delete dia;
}

void ScribusApp::MovePage()
{
	NoFrameEdit();
	MovePages *dia = new MovePages(this, doc->ActPage->PageNr+1, view->Pages.count(), true);
	if (dia->exec())
		{
		int from = dia->FromPage->value();
		int to = dia->ToPage->value();
		int wie = dia->Where->currentItem();
		int wo = dia->ActualPage->value();
		if (from != wo)
			view->movePage(from-1, to, wo-1, wie);
		slotDocCh();
		doc->UnDoValid = false;
		CanUndo();
		Sepal->RebuildPage();
		}
	delete dia;
}

void ScribusApp::CopyPage()
{
	NoFrameEdit();
	MovePages *dia = new MovePages(this, doc->ActPage->PageNr+1, view->Pages.count(), false);
	if (dia->exec())
		{
		Page* from = view->Pages.at(dia->FromPage->value()-1);
		int wo = dia->ActualPage->value();
		switch (dia->Where->currentItem())
			{
			case 0:
				slotNewPage(wo-1);
				break;
			case 1:
				slotNewPage(wo);
				break;
			case 2:
				slotNewPage(view->Pages.count());
				break;
			}
		Page* Ziel = doc->ActPage;
		for (uint ite = 0; ite < from->Items.count(); ite++)
			{
			from->Items.at(ite)->CopyIt(&Buffer);
			Ziel->PasteItem(&Buffer, true);
			}
		Ziel->MPageNam = from->MPageNam;
		Ziel->Deselect();
		view->DrawNew();
		slotDocCh();
		doc->UnDoValid = false;
		CanUndo();
		Sepal->RebuildPage();
		}
	delete dia;
}

void ScribusApp::setItemFont(int id)
{
	QString nf;
	nf = *FontID[long(id)];
	SetNewFont(nf);
}

void ScribusApp::SetNewFont(QString nf)
{
	Aktiv();
	int a;
	if (!doc->UsedFonts.contains(nf))
		{
		doc->AddFont(nf, Prefs.AvailFonts[nf]->Font);
		a = FontMenu->insertItem(new FmItem(nf, Prefs.AvailFonts[nf]->Font));
		FontID.insert(long(a), &Prefs.AvailFonts[nf]->SCName);
		}
	AdjustFontMenu(nf);
	doc->ActPage->ItemFont(nf);
	slotDocCh();
}

void ScribusApp::AdjustFontMenu(QString nf)
{
	uint a;
	QString df;
	Mpal->Fonts->setText(nf);
	for (a = 2; a < FontMenu->count(); a++)
		{
		df = *FontID[long(FontMenu->idAt(a))];
		if (df == nf)
			{
			FontMenu->setItemChecked(FontMenu->idAt(a), true);
			}
		else
			{
			FontMenu->setItemChecked(FontMenu->idAt(a), false);
			}
		}
}

void ScribusApp::setItemFSize(int id)
{
	int c = SizeTMenu->indexOf(id);
	bool ok = false;
	if (c > 0)
		doc->ActPage->chFSize(SizeTMenu->text(id).left(2).toInt());
	else
		{
    Query* dia = new Query(this, "New", 1, 0, "Size:", "Size");
    if (dia->exec())
    	{
			c = dia->Answer->text().toInt(&ok);
			if ((ok) && (c < 513))
				doc->ActPage->chFSize(c);
			delete dia;
     	}
		}
	slotDocCh();
}

void ScribusApp::setFSizeMenu(int size)
{
	uint a;
	for (a = 0; a < SizeTMenu->count(); a++)
		{
		SizeTMenu->setItemChecked(SizeTMenu->idAt(a), false);
		if (SizeTMenu->text(SizeTMenu->idAt(a)).left(2).toInt() == size)
			{
			SizeTMenu->setItemChecked(SizeTMenu->idAt(a), true);
			}
		}
}

void ScribusApp::setItemFarbe(int id)
{
	uint a;
	for (a = 0; a < ColorMenu->count(); a++)
		{
		ColorMenu->setItemChecked(ColorMenu->idAt(a), false);
		}
	ColorMenu->setItemChecked(id, true);
	doc->ActPage->ItemBrush(ColorMenu->text(id));
	slotDocCh();
}

void ScribusApp::setItemShade(int id)
{
	int c = ShadeMenu->indexOf(id);
	uint a;
	bool ok = false;
	for (a = 0; a < ShadeMenu->count(); a++)
		{
		ShadeMenu->setItemChecked(ShadeMenu->idAt(a), false);
		}
	ShadeMenu->setItemChecked(id, true);
	if (c > 0)
		{		
		doc->ActPage->ItemBrushShade((c-1) * 10);
		}
	else
		{
    Query* dia = new Query(this, "New", 1, 0, "Shade:", "Shade");
    if (dia->exec())
    	{
			c = dia->Answer->text().toInt(&ok);
			if (ok)
				{		
				doc->ActPage->ItemBrushShade(c);
				}
			delete dia;
     	}
		}
	slotDocCh();
}

void ScribusApp::setCSMenu(QString k, QString l, int lk , int ls)
{
	uint a;
	QString la;
	int lb;
	if (doc->ActPage->SelItem.count() != 0)
		{
		if (doc->ActPage->SelItem.at(0)->PType == 4)
			{
			la = k;
			lb = lk;
			}
		else
			{
			la = l;
			lb = ls;
			}	
		}
	else
		{
		la = l;
		lb = ls;
		}	
	if (la == "None")
		la = tr("None");
	for (a = 0; a < ColorMenu->count(); a++)
		{
		ColorMenu->setItemChecked(ColorMenu->idAt(a), false);
		if (ColorMenu->text(ColorMenu->idAt(a)) == la)
			ColorMenu->setItemChecked(ColorMenu->idAt(a), true);
		}
	for (a = 0; a < ShadeMenu->count(); a++)
		{
		ShadeMenu->setItemChecked(ShadeMenu->idAt(a), false);
		}
	ShadeMenu->setItemChecked(ShadeMenu->idAt(lb/10+1), true);
}

void ScribusApp::slotEditStyles()
{
	QValueList<uint> ers;
	QString nn;
	bool ff;
	uint nr;
	ers.clear();
	if (HaveDoc)
		{
		StilFormate *dia = new StilFormate(this, doc);
		if (dia->exec())
			{
			for (uint a=0; a<doc->Vorlagen.count(); a++)
				{
				ff = false;
				nn = doc->Vorlagen[a].Vname;
				for (uint b=0; b<dia->TempVorl.count(); b++)
					{
					if (nn == dia->TempVorl[b].Vname)
						{
						nr = b;
						ff = true;
						break;
						}
					}
				if (ff)
					ers.append(nr);
				else
					ers.append(0);
				}
			doc->Vorlagen = dia->TempVorl;
			for (uint c=0; c<view->Pages.count(); c++)
				{
				for (uint d=0; d<view->Pages.at(c)->Items.count(); d++)
					{
					if (view->Pages.at(c)->Items.at(d)->PType == 4)
						{
						for (uint e=0; e<view->Pages.at(c)->Items.at(d)->Ptext.count(); e++)
							{
							if (view->Pages.at(c)->Items.at(d)->Ptext.at(e)->cab > 4)
								view->Pages.at(c)->Items.at(d)->Ptext.at(e)->cab = ers[view->Pages.at(c)->Items.at(d)->Ptext.at(e)->cab];
							}
						}
					}
				}
			Spal->updateFList();
			view->DrawNew();
			slotDocCh();
			}
		delete dia;
		}
}

void ScribusApp::setItemTextAli(int id)
{
	int a = AliMenu->indexOf(id);
	setNewAbStyle(a);
}

void ScribusApp::setNewAbStyle(int a)
{
	setActiveWindow();
	if (HaveDoc)
		{
		doc->ActPage->SetAbStyle(a);
		doc->CurrentABStil = a;
		slotDocCh();
		}
}

void ScribusApp::setAbsValue(int a)
{
	doc->CurrentABStil = a;
	Mpal->setAli(a);
	for (int b = 0; b < 5; b++)
		{
		AliMenu->setItemChecked(AliMenu->idAt(b), false);
		}
	if (a < 5)
		{
		Spal->ListBox1->setCurrentItem(0);
		AliMenu->setItemChecked(AliMenu->idAt(a), true);
		}
	else
		Spal->ListBox1->setCurrentItem(a-4);
}

void ScribusApp::slotEditColors()
{
	int a;
	uint b, c, d;
	CListe edc;
	QMap<QString,QString> ers;
	if (HaveDoc)
		{
		edc = doc->PageColors;
		}
	else
		{
		edc = Prefs.DColors;
		}
	Farbmanager* dia = new Farbmanager(this, edc);
	if (dia->exec())
		{
		if (HaveDoc)
			{
			slotDocCh();
			doc->PageColors = dia->EditColors;
			Cpal->SetColors(doc->PageColors);
			CListe::Iterator it;
			ColorMenu->clear();
			QPixmap pm = QPixmap(15, 15);
			a = 0;
			ColorMenu->insertItem(tr("None"));
			for (it = doc->PageColors.begin(); it != doc->PageColors.end(); ++it)
				{
				pm.fill(doc->PageColors[it.key()].getRGBColor());
				ColorMenu->insertItem(QIconSet(pm), it.key());
				if (it.key() == doc->Dbrush)
					{
					ColorMenu->setItemChecked(ColorMenu->idAt(a), true);
					}
				a++;
				}
			ers = dia->Ersatzliste;
			if (!ers.isEmpty())
				{
				for (it = doc->PageColors.begin(); it != doc->PageColors.end(); ++it)
					{
					ers.remove(it.key());
					}
				if (!ers.isEmpty())
					{
					QMap<QString,QString>::Iterator it;
					for (it = ers.begin(); it != ers.end(); ++it)
						{
						for (b=0; b<view->Pages.count(); b++)
							{
							for (c=0; c<view->Pages.at(b)->Items.count(); c++)
								{
								if (view->Pages.at(b)->Items.at(c)->PType == 4)
									{
									for (d=0; d<view->Pages.at(b)->Items.at(c)->Ptext.count(); d++)
										{
										if (it.key() == view->Pages.at(b)->Items.at(c)->Ptext.at(d)->ccolor)
											{
											view->Pages.at(b)->Items.at(c)->Ptext.at(d)->ccolor = it.data();
											}
										}
									}
								if (it.key() == view->Pages.at(b)->Items.at(c)->Pcolor)
									{
									view->Pages.at(b)->Items.at(c)->Pcolor = it.data();
									}
								if (it.key() == view->Pages.at(b)->Items.at(c)->Pcolor2)
									{
									view->Pages.at(b)->Items.at(c)->Pcolor2 = it.data();
									}
								}
							}
						}
					}
				}
			view->DrawNew();
			}
		else
			{
			Prefs.DColors = dia->EditColors;
			Cpal->SetColors(Prefs.DColors);
			}
		}
	delete dia;
}

void ScribusApp::setPenFarbe(QString farbe)
{
	setActiveWindow();
	if (HaveDoc)
		{
		doc->ActPage->ItemPen(farbe);
		slotDocCh();
		}
}

void ScribusApp::setPenShade(int sh)
{
	setActiveWindow();
	if (HaveDoc)
		{
		doc->ActPage->ItemPenShade(sh);
		slotDocCh();
		}
}

void ScribusApp::setBrushFarbe(QString farbe)
{
	setActiveWindow();
	if (HaveDoc)
		{
		doc->ActPage->ItemBrush(farbe);
		slotDocCh();
		}
}

void ScribusApp::setBrushShade(int sh)
{
	setActiveWindow();
	if (HaveDoc)
		{
		doc->ActPage->ItemBrushShade(sh);
		slotDocCh();
		}
}

void ScribusApp::GetBrushPen()
{
	setActiveWindow();
	if (HaveDoc)
		{
		doc->ActPage->QueryFarben();
		slotDocCh();
		}
}

void ScribusApp::RectFrame()
{
	doc->ActPage->SetFrameRect();
	slotDocCh();
	doc->UnDoValid = false;
	CanUndo();
}

void ScribusApp::RoundedFrame()
{
	doc->ActPage->SetFrameRounded();
	slotDocCh();
	doc->UnDoValid = false;
	CanUndo();
}

void ScribusApp::OvalFrame()
{
	doc->ActPage->SetFrameOval();
	slotDocCh();
	doc->UnDoValid = false;
	CanUndo();
}

void ScribusApp::DeleteObjekt()
{
	if (!doc->EditClip)
		doc->ActPage->DeleteItem();
}

void ScribusApp::Objekt2Back()
{
	doc->ActPage->ToBack();
}

void ScribusApp::Objekt2Front()
{
	doc->ActPage->ToFront();
}

void ScribusApp::ObjektRaise()
{
	doc->ActPage->RaiseItem();
}

void ScribusApp::ObjektLower()
{
	doc->ActPage->LowerItem();
}

void ScribusApp::ObjektDup()
{
	slotEditCopy();
	doc->ActPage->Deselect();
	slotEditPaste();
	for (uint b=0; b<doc->ActPage->SelItem.count(); b++)
		{
		doc->ActPage->MoveItem(DispX, DispY, doc->ActPage->SelItem.at(b));
		}
	doc->UnDoValid = false;
	CanUndo();
}

void ScribusApp::ObjektDupM()
{
	NoFrameEdit();
	Mdup *dia = new Mdup(this, DispX * UmReFaktor, DispY * UmReFaktor, doc->Einheit);
	if (dia->exec())
		{
		int anz = dia->Ncopies->value();
		float dH = float(dia->ShiftH->value()) / UmReFaktor / 100.0;
		float dV = float(dia->ShiftV->value()) / UmReFaktor / 100.0;
		int a;
		if (anz>0)
			{
			for (a=0; a<anz; a++)
				{
				slotEditCopy();
				doc->ActPage->Deselect();
				slotEditPaste();
				for (uint b=0; b<doc->ActPage->SelItem.count(); b++)
					{
					doc->ActPage->MoveItem(dH, dV, doc->ActPage->SelItem.at(b));
					}
				DispX = dH;
				DispY = dV;
				}
			slotDocCh();
			doc->UnDoValid = false;
			CanUndo();
			}
		}
	delete dia;
}

void ScribusApp::SelectFromOutl(int Page, int Item)
{
	NoFrameEdit();
	setActiveWindow();
	doc->ActPage->Deselect();
	view->GotoPage(Page);
	doc->ActPage->SelectItemNr(Item);
}

void ScribusApp::SelectFromOutlS(int Page)
{
	NoFrameEdit();
	setActiveWindow();
	doc->ActPage->Deselect();
	view->GotoPage(Page);
}

void ScribusApp::InfoDoc()
{
	DocInfos *dia = new DocInfos(this, doc->DocAutor, doc->DocTitel, doc->DocComments);
	if (dia->exec())
		{
		doc->DocAutor = dia->AutorInfo->text();
		doc->DocTitel = dia->TitelInfo->text();
		doc->DocComments = dia->MultiLineEdit1->text();
		slotDocCh();
		}
	delete dia;
}

void ScribusApp::ObjektAlign()
{
	float xdp, ydp;
	bool xa, ya, Vth, Vtv;
	int xart, yart, ein;
	if (HaveDoc)
		ein = doc->Einheit;
	else
		ein = Prefs.Einheit;
	NoFrameEdit();
	Align *dia = new Align(this, doc->ActPage->SelItem.count(), ein);
	connect(dia, SIGNAL(ApplyDist(bool, bool, bool, bool, float, float, int, int)),
	        this, SLOT(DoAlign(bool, bool, bool, bool, float, float, int, int)));
	if (dia->exec())
		{
		xdp = float(dia->AHor->value()) / UmReFaktor / 100.0;
		xa = (dia->CheckH->isChecked() || dia->VerteilenH->isChecked());
		ydp = float(dia->AVert->value()) / UmReFaktor/ 100.0;
		ya = (dia->CheckV->isChecked() || dia->VerteilenV->isChecked());
		xart = dia->VartH->currentItem();
		yart = dia->VartV->currentItem();
		Vth = dia->VerteilenH->isChecked();
		Vtv = dia->VerteilenV->isChecked();
		doc->ActPage->AlignObj(xa, ya, Vth, Vtv, xdp, ydp, xart, yart);
		slotDocCh();
		doc->UnDoValid = false;
		CanUndo();
		}
	delete dia;
}

void ScribusApp::DoAlign(bool xa, bool ya, bool Vth, bool Vtv, float xdp, float ydp, int xart, int yart)
{
	doc->ActPage->AlignObj(xa, ya, Vth, Vtv, xdp, ydp, xart, yart);
	slotDocCh();
	doc->UnDoValid = false;
	CanUndo();
}

void ScribusApp::BuildFontMenu()
{
	QPopupMenu *pm;
	FontID.clear();
	FontMenu->clear();
	FStyleMenu->clear();
	int a;
	QString b = " ";

	QMap<QString,QStrList> Fami;
	SCFontsIterator it(Prefs.AvailFonts);
	for ( ; it.current(); ++it)
	{
		QString family,style;
		QString &fn=it.current()->SCName;
		int	pos=fn.find(" ");
		family=fn.left(pos);
		style=fn.right(fn.length()-pos);
		Fami[family].inSort(fn);
	}

	QMapIterator<QString,QStrList> qmi;
	for (qmi = Fami.begin(); qmi != Fami.end(); ++qmi)
	{
		pm = new QPopupMenu();
		QString family=qmi.key();
		QStrList &qsl=qmi.data();
		for( QStrListIterator sli(qsl) ; sli.current() ; ++sli)
		{
			QString &fn=Prefs.AvailFonts[sli.current()]->SCName;
			a = pm->insertItem(new FmItem(fn, Prefs.AvailFonts[fn]->Font));
			FontID.insert(long(a), &fn);
		}
		connect(pm, SIGNAL(activated(int)), this, SLOT(setItemFont(int)));
		FStyleMenu->insertItem(family, pm);
	}

	a = FontMenu->insertItem(tr("Face"), FStyleMenu);
	FontID.insert(long(a), &b);
	a = FontMenu->insertSeparator();
	FontID.insert(long(a), &b);
	if (!HaveDoc)
		{
		it.toFirst();
		a = FontMenu->insertItem(new FmItem(it.currentKey(), it.current()->Font));
		FontMenu->setItemChecked(a, true);
		FontID.insert(long(a), &it.current()->SCName);
		}
	else
		{
		QMap<QString,QFont>::Iterator it3;
		for (it3 = doc->UsedFonts.begin(); it3 != doc->UsedFonts.end(); ++it3)
			{
			a = FontMenu->insertItem(new FmItem(it3.key(), it3.data()));
			if (it3.key() == doc->Dfont)
				{
				FontMenu->setItemChecked(a, true);
				}
			FontID.insert(long(a), &it3.key());
			}
		}
}

void ScribusApp::GetAllFonts()
{
	Prefs.AvailFonts.GetFonts();
	if (Prefs.AvailFonts.isEmpty())
		NoFonts = true;
}

void ScribusApp::slotFontOrg()
{
	uint a;
	FontPrefs *dia = new FontPrefs(this, Prefs.AvailFonts);
	if (dia->exec())
		{
		a = 0;
		SCFontsIterator it(Prefs.AvailFonts);
		for ( ; it.current() ; ++it)
			{
			it.current()->EmbedPS = dia->FlagsPS.at(a)->isChecked();
			a++;
			}
		}
	delete dia;
}

void ScribusApp::slotPrefsOrg()
{
	void *mo;
	char *error;
	typedef Preferences* (*sdem)(QWidget *d, preV *Vor);
	sdem demo;
	QString pfad = PREL;
	pfad += "/share/scribus/libs/libpreferences.so";
	mo = dlopen(pfad, RTLD_LAZY);
	if (!mo)
		{
		cout << "Can't find Plugin" << endl;
		return;
		}
	dlerror();
	demo = (sdem)dlsym(mo, "Run");
	if ((error = dlerror()) != NULL)
		{
		cout << "Can't find Symbol" << endl;
		dlclose(mo);
		return;
		}
	Preferences *dia = (*demo)(this, &Prefs);
	if (dia->exec())
		{
		Prefs.Einheit = dia->UnitCombo->currentItem();
		switch (Prefs.Einheit)
			{
			case 0:
				UmReFaktor = 1.0;
				break;
			case 1:
				UmReFaktor = 1.0 / 72.0 * 25.4;
				break;
			case 2:
				UmReFaktor = 1.0 / 72.0;
				break;
			case 3:
				UmReFaktor = 1.0 / 12.0;
				break;
			}
		Prefs.KeyActions = dia->KKC;
		SetShortCut();
		Prefs.AppFontSize = dia->GFsize->value();
		Prefs.DefFont = dia->FontCombo->currentText();
		Prefs.DefSize = dia->SizeCombo->currentText().left(2).toInt();
		Prefs.Wheelval = dia->SpinBox3->value();
		Prefs.GrabRad = dia->SpinBox3_2->value();
		Prefs.RecentDCount = dia->Recen->value();
		Prefs.DminGrid = dia->SpinBox1->value() / UmReFaktor / 100;
		Prefs.DmajGrid = dia->SpinBox2->value() / UmReFaktor / 100;
		Prefs.DminColor = dia->Cmin;
		Prefs.DmajColor = dia->Cmax;
		Prefs.DpapColor = dia->Cpaper;
		Prefs.DmargColor = dia->Crand;
		Prefs.DVHoch = dia->VHochW->value();
		Prefs.DVHochSc = dia->VHochWSc->value();
		Prefs.DVTief = dia->VTiefW->value();
		Prefs.DVTiefSc = dia->VTiefWSc->value();
		Prefs.DVKapit = dia->SmallCaps->value();
  	Prefs.Dpen = dia->Foreground->currentText();
		if (Prefs.Dpen == tr("None"))
			Prefs.Dpen = "None";
  	Prefs.DpenText = dia->ForegroundT->currentText();
		if (Prefs.DpenText == tr("None"))
			Prefs.DpenText = "None";
  	Prefs.Dbrush = dia->Background->currentText();
		if (Prefs.Dbrush == tr("None"))
			Prefs.Dbrush = "None";
  	Prefs.Dshade = dia->Shade->value();
  	Prefs.Dshade2 = dia->Shade2->value();
		switch (dia->Linestyle->currentItem())
			{
			case 0:
				Prefs.DLineArt = SolidLine;
				break;
			case 1:
				Prefs.DLineArt = DashLine;
				break;
			case 2:
				Prefs.DLineArt = DotLine;
				break;
			case 3:
				Prefs.DLineArt = DashDotLine;
				break;
			case 4:
				Prefs.DLineArt = DashDotDotLine;
				break;
			}
  	Prefs.DpenLine = dia->Foreground2->currentText();
		if (Prefs.DpenLine == tr("None"))
			Prefs.DpenLine = "None";
  	Prefs.DshadeLine = dia->Shade22->value();
		switch (dia->Linestyle2->currentItem())
			{
			case 0:
				Prefs.DLstyleLine = SolidLine;
				break;
			case 1:
				Prefs.DLstyleLine = DashLine;
				break;
			case 2:
				Prefs.DLstyleLine = DotLine;
				break;
			case 3:
				Prefs.DLstyleLine = DashDotLine;
				break;
			case 4:
				Prefs.DLstyleLine = DashDotDotLine;
				break;
			}
  	Prefs.Dwidth = dia->LineW->value()/10;
  	Prefs.DwidthLine = dia->LineW2->value()/10;
  	Prefs.MagMin = dia->MinMag->value();
  	Prefs.MagMax = dia->MaxMag->value();
  	Prefs.MagStep = dia->StepMag->value();
  	Prefs.DbrushPict = dia->BackgroundP->currentText();
		if (Prefs.DbrushPict == tr("None"))
			Prefs.DbrushPict = "None";
		Prefs.ShadePict = dia->ShadeP->value();
		Prefs.ScaleX = float(dia->XScale->value()) / 100;
		Prefs.ScaleY = float(dia->YScale->value()) / 100;
		Prefs.ScaleType = dia->FreeScale->isChecked();
		Prefs.AspectRatio = dia->Aspect->isChecked();
		Prefs.Before = dia->RadioButton6->isChecked();
		switch (dia->PreviewSize->currentItem())
			{
			case 0:
				Prefs.PSize = 40;
				break;
			case 1:
				Prefs.PSize = 60;
				break;
			case 2:
				Prefs.PSize = 80;
				break;
			}
		Prefs.SaveAtQ = dia->SaveAtQuit->isChecked();
		Prefs.PagesSbS = dia->SidebySide->isChecked();
		Prefs.ShFrames = dia->FramesVisible->isChecked();
		Prefs.RandFarbig = dia->RandFarb->isChecked();
		Prefs.AutoLine = dia->AutoLineV->value();
		ScBook->BibWin->RebuildView();
		ScBook->AdjustMenu();
		if (Prefs.GUI != dia->GUICombo->currentText())
			{
			Prefs.GUI = dia->GUICombo->currentText();
    	qApp->setStyle(QStyleFactory::create(Prefs.GUI));
			}
		Mpal->setResizeEnabled(true);
		int MpTop = Mpal->Fram->id(Mpal->Fram->visibleWidget());
		int MpTab = Mpal->TabWidget3->currentPageIndex();
		Mpal->TabWidget3->showPage(Mpal->tab_2);
    Mpal->Fram->raiseWidget(3);
		qApp->setFont(QFont("helvetica", Prefs.AppFontSize),true);
		Mpal->setResizeEnabled(false);
    Mpal->Fram->raiseWidget(MpTop);
		Mpal->TabWidget3->showPage(Mpal->TabWidget3->page(MpTab));
		PolyC = dia->T6_Ecken->value();
		PolyF = dia->PFactor;
		PolyR = dia->T6_Faktor2->value();
		PolyS = dia->T6_Konvex->isChecked();
		PolyFd = dia->T6_Slider1->value();
		Prefs.PolyC = PolyC;
		Prefs.PolyF = PolyF;
		Prefs.PolyFd = PolyFd;
		Prefs.PolyS = PolyS;
		Prefs.PolyR = PolyR;
		Prefs.PageFormat = dia->GZComboF->currentItem();
		Prefs.Ausrichtung = dia->GZComboO->currentItem();
		Prefs.PageBreite = dia->Pagebr;
		Prefs.PageHoehe = dia->Pageho;
		Prefs.RandOben = dia->TopR->value() / UmReFaktor / 100;
		Prefs.RandUnten = dia->BottomR->value() / UmReFaktor / 100;
		Prefs.RandLinks = dia->LeftR->value() / UmReFaktor / 100;
		Prefs.RandRechts = dia->RightR->value() / UmReFaktor / 100;
		Prefs.DoppelSeiten = dia->Doppelseiten->isChecked();
		Prefs.ErsteLinks = dia->Linkszuerst->isChecked();
		if (HaveDoc)
			{
			doc->GrabRad = Prefs.GrabRad;
			doc->Dfont = Prefs.DefFont;
			doc->Dsize = Prefs.DefSize;
			doc->minorGrid = Prefs.DminGrid;
			doc->majorGrid = Prefs.DmajGrid;
			doc->minorColor = Prefs.DminColor;
			doc->majorColor = Prefs.DmajColor;
			doc->papColor = Prefs.DpapColor;
			doc->margColor = Prefs.DmargColor;
			doc->VHoch = Prefs.DVHoch;
			doc->VHochSc = Prefs.DVHochSc;
			doc->VTief = Prefs.DVTief;
			doc->VTiefSc = Prefs.DVTiefSc;
			doc->VKapit = Prefs.DVKapit;
  		doc->Dpen = Prefs.Dpen;
  		doc->DpenText = Prefs.DpenText;
  		doc->Dbrush = Prefs.Dbrush;
  		doc->Dshade = Prefs.Dshade;
  		doc->Dshade2 = Prefs.Dshade2;
  		doc->DLineArt = PenStyle(Prefs.DLineArt);
  		doc->Dwidth = Prefs.Dwidth;
  		doc->DpenLine = Prefs.DpenLine;
  		doc->DshadeLine = Prefs.DshadeLine;
  		doc->DLstyleLine = PenStyle(Prefs.DLstyleLine);
  		doc->DwidthLine = Prefs.DwidthLine;
  		doc->MagMin = Prefs.MagMin;
  		doc->MagMax = Prefs.MagMax;
  		doc->MagStep = Prefs.MagStep;
  		doc->DbrushPict = Prefs.DbrushPict;
			doc->ShadePict = Prefs.ShadePict;
			doc->ScaleX = Prefs.ScaleX;
			doc->ScaleY = Prefs.ScaleY;
			doc->ScaleType = Prefs.ScaleType;
			doc->AspectRatio = Prefs.AspectRatio;
			doc->Before = Prefs.Before;
			doc->Einheit = Prefs.Einheit;
			doc->PagesSbS = Prefs.PagesSbS;
			doc->ShFrames = Prefs.ShFrames;
			doc->RandFarbig = Prefs.RandFarbig;
			doc->AutoLine = Prefs.AutoLine;
			switch (doc->Einheit)
				{
				case 0:
					view->UN->setText("pt");
					break;
				case 1:
					view->UN->setText("mm");
					break;
				case 2:
					view->UN->setText("in");
					break;
				case 3:
					view->UN->setText("p");
					break;
				}
			Mpal->UnitChange();
			view->reformPages();
			view->DrawNew();
			}
		SavePrefs();
		}
	delete dia;
	dlclose(mo);
}

void ScribusApp::SavePrefs()
{
  Prefs.MainX = abs(pos().x());
  Prefs.MainY = abs(pos().y());
  Prefs.MainW = size().width();
  Prefs.MainH = size().height();
  Prefs.Werkv = WerkTools->isVisible();
  Prefs.Mpalv = Mpal->isVisible();
  Prefs.Cpalv = Cpal->isVisible();
  Prefs.Tpalv = Tpal->isVisible();
	Prefs.Spalv = Spal->isVisible();
  Prefs.SCpalv = ScBook->isVisible();
  Prefs.Lpalv = Lpal->isVisible();
  Prefs.Sepalv = Sepal->isVisible();
  if (Mpal->isVisible())
  	{
	  Prefs.Mpalx = abs(Mpal->pos().x());
	  Prefs.Mpaly = abs(Mpal->pos().y());
	  }
	if (Cpal->isVisible())
		{
	  Prefs.Cpalx = abs(Cpal->pos().x());
	  Prefs.Cpaly = abs(Cpal->pos().y());
	  }
	if (Tpal->isVisible())
		{
		Prefs.Tpalx = abs(Tpal->pos().x());
		Prefs.Tpaly = abs(Tpal->pos().y());
		}
	if (Spal->isVisible())
		{
		Prefs.Spalx = abs(Spal->pos().x());
		Prefs.Spaly = abs(Spal->pos().y());
		}
	if (ScBook->isVisible())
		{
		Prefs.SCpalx = abs(ScBook->pos().x());
		Prefs.SCpaly = abs(ScBook->pos().y());
		Prefs.SCpalw = abs(ScBook->size().width());
		Prefs.SCpalh = abs(ScBook->size().height());
		}
	if (Sepal->isVisible())
		{
		Prefs.Sepalx = abs(Sepal->pos().x());
		Prefs.Sepaly = abs(Sepal->pos().y());
		}
	if (Lpal->isVisible())
		{
		Prefs.Lpalx = abs(Lpal->pos().x());
		Prefs.Lpaly = abs(Lpal->pos().y());
		}
  Prefs.RecentDocs.clear();
	uint max = QMIN(Prefs.RecentDCount, RecentDocs.count());
	for (uint m = 0; m < max; m++)
		{
		Prefs.RecentDocs.append(RecentDocs[m]);
		}
	Prefs.PrinterName = PDef.Pname;
	Prefs.PrinterFile = PDef.Dname;
	Prefs.PrinterCommand = PDef.Command;
  ScriXmlDoc *ss = new ScriXmlDoc();
  ss->WritePref(&Prefs);
  delete ss;
}

void ScribusApp::ReadPrefs()
{
	Mpal->setResizeEnabled(true);
	int MpTop = Mpal->Fram->id(Mpal->Fram->visibleWidget());
	int MpTab = Mpal->TabWidget3->currentPageIndex();
	Mpal->TabWidget3->showPage(Mpal->tab_2);
  Mpal->Fram->raiseWidget(3);
  ScriXmlDoc *ss = new ScriXmlDoc();
  bool erg = ss->ReadPref(&Prefs);
  delete ss;
  if (!erg)
		{
		Mpal->setResizeEnabled(false);
    Mpal->Fram->raiseWidget(MpTop);
		Mpal->TabWidget3->showPage(Mpal->TabWidget3->page(MpTab));
  	return;
		}
	PDef.Pname = Prefs.PrinterName;
	PDef.Dname = Prefs.PrinterFile;
	PDef.Command = Prefs.PrinterCommand;
	PolyC = Prefs.PolyC;
	PolyF = Prefs.PolyF;
	PolyFd = Prefs.PolyFd;
	PolyS = Prefs.PolyS;
	PolyR = Prefs.PolyR;
  recentMenu->clear();
	uint max = QMIN(Prefs.RecentDCount, Prefs.RecentDocs.count());
	for (uint m = 0; m < max; m++)
		{
		QFileInfo fd(Prefs.RecentDocs[m]);
		if (fd.exists())
			{
			RecentDocs.append(Prefs.RecentDocs[m]);
			recentMenu->insertItem(Prefs.RecentDocs[m]);
			}
		}
  if (!Prefs.Werkv)
		toolMenu->changeItem(viewTools, tr("Show Tools"));
	if (Prefs.Mpalv)
		toolMenu->changeItem(viewMpal, tr("Hide Measurements"));
	if (Prefs.Cpalv)
		toolMenu->changeItem(viewCpal, tr("Hide Colors"));
	if (Prefs.Tpalv)
		toolMenu->changeItem(viewTpal, tr("Hide Outline"));
	if (Prefs.Spalv)
		toolMenu->changeItem(viewSpal, tr("Hide Styles"));
	if (Prefs.SCpalv)
		toolMenu->changeItem(viewBpal, tr("Hide Scrapbook"));
	if (Prefs.Lpalv)
		toolMenu->changeItem(viewLpal, tr("Hide Layers"));
	if (Prefs.Sepalv)
		toolMenu->changeItem(viewSepal, tr("Hide Page Palette"));
	Mpal->move(Prefs.Mpalx, Prefs.Mpaly);
	Cpal->move(Prefs.Cpalx, Prefs.Cpaly);
	Tpal->move(Prefs.Tpalx, Prefs.Tpaly);
	Spal->move(Prefs.Spalx, Prefs.Spaly);
	Lpal->move(Prefs.Lpalx, Prefs.Lpaly);
	Sepal->move(Prefs.Sepalx, Prefs.Sepaly);
	ScBook->move(Prefs.SCpalx, Prefs.SCpaly);
	ScBook->resize(Prefs.SCpalw, Prefs.SCpalh);
	Npal->move(Prefs.Npalx, Prefs.Npaly);
	move(Prefs.MainX, Prefs.MainY);
	resize(Prefs.MainW, Prefs.MainH);
	Mpal->setResizeEnabled(false);
  Mpal->Fram->raiseWidget(MpTop);
	Mpal->TabWidget3->showPage(Mpal->TabWidget3->page(MpTab));
}

void ScribusApp::ShowSubs()
{
	QString mess;
	if (HaveGS != 0)
		{
		mess = tr("The following Programs are missing:")+"\n\n";
		if (HaveGS != 0)
			{
			mess += tr("Ghostscript : You cannot use EPS-Images")+"\n\n";
			PDFavailable = false;
			}
    QMessageBox::warning(this, tr("Warning"), mess, 1, 0, 0);
    }
	if (!Prefs.Werkv)
		WerkTools->hide();
	if (Prefs.Mpalv)
		Mpal->show();
	if (Prefs.Cpalv)
		Cpal->show();
	if (Prefs.Tpalv)
		Tpal->show();
	if (Prefs.Spalv)
		Spal->show();
	if (Prefs.SCpalv)
		ScBook->show();
	if (Prefs.Lpalv)
		Lpal->show();
	if (Prefs.Sepalv)
		Sepal->show();
	setActiveWindow();
	raise();
}

PSLib* ScribusApp::getPSDriver(bool psart, SCFonts &AllFonts, QMap<QString,QFont> DocFonts, CListe DocColors, bool pdf)
{
	char *error;
	typedef PSLib* (*sdem)(bool psart, SCFonts &AllFonts, QMap<QString,QFont> DocFonts, CListe DocColors, bool pdf);
	sdem demo;
	QString pfad = PREL;
	pfad += "/share/scribus/libs/libpostscript.so";
	PSDriver = dlopen(pfad, RTLD_LAZY);
	if (!PSDriver)
		{
		cout << "Can't find Plugin" << endl;
		return NULL;
		}
	dlerror();
	demo = (sdem)dlsym(PSDriver, "Run");
	if ((error = dlerror()) != NULL)
		{
		cout << "Can't find Symbol" << endl;
		dlclose(PSDriver);
		return NULL;
		}
	PSLib *dia = (*demo)(psart, AllFonts, DocFonts, DocColors, pdf);
	return dia;
}

void ScribusApp::closePSDriver()
{
	dlclose(PSDriver);
}

PDFlib* ScribusApp::getPDFDriver()
{
	char *error;
	typedef PDFlib* (*sdem)();
	sdem demo;
	QString pfad = PREL;
	pfad += "/share/scribus/libs/libpdf.so";
	PDFDriver = dlopen(pfad, RTLD_LAZY);
	if (!PDFDriver)
		{
		cout << "Can't find Plugin" << endl;
		return NULL;
		}
	dlerror();
	demo = (sdem)dlsym(PDFDriver, "Run");
	if ((error = dlerror()) != NULL)
		{
		cout << "Can't find Symbol" << endl;
		dlclose(PDFDriver);
		return NULL;
		}
	PDFlib *dia = (*demo)();
	return dia;
}

void ScribusApp::closePDFDriver()
{
	dlclose(PDFDriver);
}

bool ScribusApp::DoSaveAsEps(QString fn)
{
	qApp->setOverrideCursor(QCursor(waitCursor), true);
	PSLib *dd = getPSDriver(false, Prefs.AvailFonts, doc->UsedFonts, doc->PageColors, false);
	if (dd != NULL)
		{
		QString data = view->CreatePS(dd, doc->ActPage->PageNr, doc->ActPage->PageNr+1, 1, false, tr("All"), true);
		QFile f(fn);
		if (f.open(IO_WriteOnly))
			{
			QTextStream t(&f);
			t.writeRawBytes(data, data.length());
			f.close();
			delete dd;
			}
		else
			{
			delete dd;
			return false;
			}
		closePSDriver();
		qApp->setOverrideCursor(QCursor(arrowCursor), true);
		return true;
		}
	else
		return false;
}

void ScribusApp::SaveAsEps()
{
	QString fna;
  if (!doc->DocName.startsWith("Document"))
  	{
  	QFileInfo fi(doc->DocName);
  	fna = fi.dirPath()+"/"+fi.baseName()+".eps";
  	}
  else
  	{
  	QDir di = QDir();
  	fna = di.currentDirPath()+"/"+doc->DocName+".eps";
  	}
  QString fn = CFileDialog(tr("Save as"), tr("EPS-Files (*.eps);; All Files (*)"), "", false, false);
  if (!fn.isEmpty())
  	{
		DoSaveAsEps(fn);
  	}
}

void ScribusApp::SaveAsPDF()
{
	struct PDFOpt Optionen;
	Optionen.Version = 13;
	Optionen.PresentVals.clear();
  QString fn;
	uint frPa, toPa;
  PDF_Opts *dia = new PDF_Opts(this, doc->DocName, doc->UsedFonts, view, Optionen.PresentVals);
  if (dia->exec())
  	{
  	qApp->setOverrideCursor(QCursor(waitCursor), true);
  	fn = dia->Datei->text();
		Optionen.Thumbnails = dia->CheckBox1->isChecked();
		Optionen.Compress = dia->Compression->isChecked();
		Optionen.Resolution = dia->Resolution->value();
		Optionen.EmbedList = dia->FontsToEmbed;
		Optionen.RecalcPic = dia->DSColor->isChecked();
		Optionen.PicRes = dia->ValC->value();
		Optionen.Bookmarks = dia->CheckBM->isChecked();
		Optionen.Binding = dia->ComboBind->currentItem();
		Optionen.PresentMode = dia->CheckBox10->isChecked();
		Optionen.PresentVals = dia->EffVal;
		Optionen.Articles = dia->Article->isChecked();
		if (dia->ComboBox1->currentItem() == 0)
			Optionen.Version = 13;
		if (dia->ComboBox1->currentItem() == 1)
			Optionen.Version = 14;
		if (dia->AllPages->isChecked())
			{
			frPa = 0;
			toPa = view->Pages.count();
			}
		else
			{
			frPa = uint(dia->FirstPage->value()-1);
			toPa = uint(dia->LastPage->value());
			}
		PDFlib *pd = getPDFDriver();
		pd->PDF_Begin_Doc(doc, view, &Optionen, Prefs.AvailFonts, doc->UsedFonts, dia->BView);
		for (uint a = frPa; a < toPa; a++)
			{
			pd->PDF_Begin_Page(view->Pages.at(a));
			if (view->Pages.at(a)->MPageNam != "")
				pd->PDF_ProcessPage(view->MasterPages.at(view->MasterNames[view->Pages.at(a)->MPageNam]), a);
			pd->PDF_ProcessPage(view->Pages.at(a), a);
			pd->PDF_End_Page();
			}
		QString dd = pd->PDF_End_Doc();
		QFile f(fn);	
		if (f.open(IO_WriteOnly))
			{
			QTextStream t(&f);
			t.writeRawBytes(dd, dd.length());
			f.close();	
			}
		delete pd;
		closePDFDriver();
 		qApp->setOverrideCursor(QCursor(arrowCursor), true);
		}
  delete dia;
}

void ScribusApp::ModifyObject()
{
	NoFrameEdit();
	PageItem* b = doc->ActPage->SelItem.at(0);
  ModObj *dia = new ModObj(this, b, doc->PageColors, doc, &InputProfiles);
	connect(dia, SIGNAL(DocChanged()), this, SLOT(slotDocCh()));
  dia->exec();
	delete dia;
	doc->UnDoValid = false;
	CanUndo();
	Mpal->setLvalue(b->LocalScX, b->LocalScY, b->LocalX, b->LocalY );
}

void ScribusApp::slotElemRead(QString Name, int x, int y, bool art, bool loca)
{
	NoFrameEdit();
  ScriXmlDoc *ss = new ScriXmlDoc();
  if(ss->ReadElem(Name, Prefs.AvailFonts, doc, x, y, art, loca))
  	{
  	BuildFontMenu();
		Spal->updateFList();
  	doc->ActPage->update();
  	slotDocCh();
		doc->UnDoValid = false;
		CanUndo();
  	}
  delete ss;
}

void ScribusApp::slotChangeUnit(int art)
{
	doc->Einheit = art;
	switch (art)
		{
		case 0:
			UmReFaktor = 1.0;
			view->UN->setText("pt");
			break;
		case 1:
			UmReFaktor = 0.3527777;
			view->UN->setText("mm");
			break;
		case 2:
			UmReFaktor = 1.0 / 72.0;
			view->UN->setText("in");
			break;
		case 3:
			UmReFaktor = 1.0 / 12.0;
			view->UN->setText("p");
			break;
		}
	Mpal->UnitChange();
	view->DrawNew();
}

void ScribusApp::ManageJava()
{
	JavaDocs *dia = new JavaDocs(this, doc, view);
	dia->exec();
	delete dia;
}

void ScribusApp::ManageTemp(QString temp)
{
	MusterSeiten *dia = new MusterSeiten(this, doc, view, temp);
	connect(dia, SIGNAL(CreateNew(int)), this, SLOT(slotNewPage(int)));
	connect(dia, SIGNAL(Fertig()), this, SLOT(ManTempEnd()));
	menuBar()->setItemEnabled(pgmm, 0);
	editMenu->setItemEnabled(tman, 0);
	MenuStat[0] = DatSav->isEnabled();
	MenuStat[1] = fileMenu->isItemEnabled(fid1);
	MenuStat[2] = fileMenu->isItemEnabled(fid4);
	MenuStat[3] = fileMenu->isItemEnabled(fid5);
	DatNeu->setEnabled(false);
	DatSav->setEnabled(false);
	DatOpe->setEnabled(false);
	DatClo->setEnabled(false);
	fileMenu->setItemEnabled(fid1, 0);
	fileMenu->setItemEnabled(fid4, 0);
	fileMenu->setItemEnabled(fid5, 0);
	fileMenu->setItemEnabled(fid12, 0);
	fileMenu->setItemEnabled(fid13, 0);
	fileMenu->setItemEnabled(fid14, 0);
	TemplateMode = true;
	Sepal->DisablePal();
	doc->UnDoValid = false;
	CanUndo();
	dia->show();
}

void ScribusApp::ManTempEnd()
{
	TemplateMode = false;
	menuBar()->setItemEnabled(pgmm, 1);
	editMenu->setItemEnabled(tman, 1);
	DatNeu->setEnabled(true);
	DatSav->setEnabled(MenuStat[0]);
	DatOpe->setEnabled(true);
	DatClo->setEnabled(true);
	fileMenu->setItemEnabled(fid1, MenuStat[1]);
	fileMenu->setItemEnabled(fid4, MenuStat[2]);
	fileMenu->setItemEnabled(fid5, MenuStat[3]);
	fileMenu->setItemEnabled(fid12, 1);
	fileMenu->setItemEnabled(fid13, 1);
	fileMenu->setItemEnabled(fid14, 1);
	if (view->Pages.count() > 1)
		{
		pageMenu->setItemEnabled(pgmd, 1);
		pageMenu->setItemEnabled(pgmv, 1);
		}
	else
		{
		pageMenu->setItemEnabled(pgmd, 0);
		pageMenu->setItemEnabled(pgmv, 0);
		}
	if (doc->isModified())
		slotDocCh();
	Sepal->EnablePal();
	Sepal->RebuildTemp();
}

void ScribusApp::ApplyTemp()
{
	QString mna;
	ApplyT *dia = new ApplyT(this, view);
	if (dia->exec())
		{
		mna = dia->Templ->currentText();
		Apply_Temp(mna, doc->ActPage->PageNr);
		}
	delete dia;
}

void ScribusApp::Apply_Temp(QString in, int Snr)
{
	QString mna = in;
	if (mna == tr("Normal"))
		mna = "Normal";
	view->Pages.at(Snr)->MPageNam = mna;
	view->DrawNew();
	slotDocCh();
	doc->UnDoValid = false;
	CanUndo();
	Sepal->Rebuild();
}

void ScribusApp::GroupObj()
{
	PageItem* b;
	float x, y, w, h;
	for (uint a=0; a<doc->ActPage->SelItem.count(); a++)
		{
		b = doc->ActPage->SelItem.at(a);
		b->Groups.push(doc->GroupCounter);
		}
	doc->GroupCounter++;
	doc->ActPage->getGroupRect(&x, &y, &w, &h);
	doc->ActPage->repaint(QRect(int(x-5), int(y-5), int(w+10), int(h+10)));
	slotDocCh();
	doc->UnDoValid = false;
	CanUndo();
}

void ScribusApp::UnGroupObj()
{
	PageItem* b;
	for (uint a=0; a<doc->ActPage->SelItem.count(); a++)
		{
		b = doc->ActPage->SelItem.at(a);
		b->Groups.pop();
		}
	doc->ActPage->Deselect();
	slotDocCh();
	doc->UnDoValid = false;
	CanUndo();
}

void ScribusApp::StatusPic()
{
	if (HaveDoc)
		{
		PicStatus *dia = new PicStatus(this, doc, view);
		connect(dia, SIGNAL(GotoSeite(int)), this, SLOT(SelectFromOutlS(int)));
		dia->exec();
		delete dia;
		}
}

QString ScribusApp::CFileDialog(QString caption, QString filter, QString defNa, bool Pre, bool mod, bool comp)
{
	CustomFDialog dia(this, caption, filter, Pre, mod, comp);
	if (defNa != "")
		dia.setSelection(defNa);
	if (dia.exec() == QDialog::Accepted)
		if (mod)
			return dia.selectedFiles()[0];
		else
			return dia.selectedFile();
	else
		return "";
}

void ScribusApp::RunPlug(int id)
{
	int a = extraMenu->indexOf(id);
	if (a > 1)
		CallDLL(extraMenu->text(id));
}

void ScribusApp::RunImportPlug(int id)
{
	int a = importMenu->indexOf(id);
	if (a > 0)
		CallDLL(importMenu->text(id));
}

void ScribusApp::RunExportPlug(int id)
{
	int a = exportMenu->indexOf(id);
	if (a > 2)
		CallDLL(exportMenu->text(id));
}

void ScribusApp::RunHelpPlug(int id)
{
	int a = helpMenu->indexOf(id);
	if (a > 4)
		CallDLL(helpMenu->text(id));
}

void ScribusApp::FinalizePlugs()
{
	char *error;
	QMap<QString, PlugData>::Iterator it;
	struct PlugData pda;
	typedef void (*sdem2)();
	sdem2 demo2;
	for (it = PluginMap.begin(); it != PluginMap.end(); ++it)
		{
		if (it.data().Typ == 4)
			{
			dlerror();
			demo2 = (sdem2)dlsym(it.data().Zeiger, "CleanUpPlug");
			if ((error = dlerror()) != NULL)
				{
				dlclose(it.data().Zeiger);
				continue;
				}
			else
				{
				(*demo2)();
				}
			}
		}
}

void ScribusApp::InitPlugs()
{
	QString pfad = PREL;
	QString nam = "";
	int ty = 0;
	struct PlugData pda;
	pfad += "/share/scribus/plugins/";
	QDir d(pfad, "*.so*", QDir::Name, QDir::Files | QDir::Executable | QDir::NoSymLinks);
	if ((d.exists()) && (d.count() != 0))
		{
		extraMenu->insertSeparator();
		for (uint dc = 0; dc < d.count(); dc++)
			{
			pda.Zeiger = 0;
			pda.Datei = "";
			pda.Typ = 0;
			if (DLLName(d[dc], &nam, &ty, pda.Zeiger))
				{
				if (ty == 1)
					extraMenu->insertItem(tr(nam));
				if (ty == 2)
					importMenu->insertItem(tr(nam));
				if (ty == 3)
					exportMenu->insertItem(tr(nam));
				if (ty == 4)
					helpMenu->insertItem(tr(nam));
				pda.Datei = d[dc];
				pda.Typ = ty;
				PluginMap[tr(nam)] = pda;
				}
			}
	 	connect(extraMenu, SIGNAL(activated(int)), this, SLOT(RunPlug(int)));
	 	connect(importMenu, SIGNAL(activated(int)), this, SLOT(RunImportPlug(int)));
	 	connect(exportMenu, SIGNAL(activated(int)), this, SLOT(RunExportPlug(int)));
	 	connect(helpMenu, SIGNAL(activated(int)), this, SLOT(RunHelpPlug(int)));
	 	}
}

void ScribusApp::CallDLL(QString name)
{
	void *mo;
	char *error;
	struct PlugData pda;
	pda = PluginMap[name];
	typedef void (*sdem)(QWidget *d, ScribusApp *plug);
	sdem demo;
	QString pfad = PREL;
	if (pda.Typ != 4)
		{
		pfad += "/share/scribus/plugins/" + pda.Datei;
		mo = dlopen(pfad, RTLD_LAZY | RTLD_GLOBAL);
		if (!mo)
			{
			cout << "Can't find Plugin" << endl;
			return;
			}
		}
	else
		mo = pda.Zeiger;
	dlerror();
	demo = (sdem)dlsym(mo, "Run");
	if ((error = dlerror()) != NULL)
		{
		cout << "Can't find Symbol" << endl;
		dlclose(mo);
		return;
		}
	(*demo)(this, this);
	if (pda.Typ != 4)
		dlclose(mo);
}

bool ScribusApp::DLLName(QString name, QString *PName, int *typ, void *Zeig)
{
	void *mo;
	char *error;
	typedef QString (*sdem0)();
	typedef int (*sdem1)();
	typedef void (*sdem2)(QWidget *d, ScribusApp *plug);
	sdem0 demo;
	sdem1 demo1;
	sdem2 demo2;
	QString pfad = PREL;
	pfad += "/share/scribus/plugins/" + name;
	mo = dlopen(pfad, RTLD_LAZY | RTLD_GLOBAL);
	if (!mo)
		return false;
	dlerror();
	demo = (sdem0)dlsym(mo, "Name");
	if ((error = dlerror()) != NULL)
		{
		dlclose(mo);
		return false;
		}
	*PName = (*demo)();
	dlerror();
	demo1 = (sdem1)dlsym(mo, "Type");
	if ((error = dlerror()) != NULL)
		{
		dlclose(mo);
		return false;
		}
	*typ = (*demo1)();
	Zeig = mo;
	if (*typ != 4)
		dlclose(mo);
	else
		{
		dlerror();
		demo2 = (sdem2)dlsym(mo, "InitPlug");
		if ((error = dlerror()) != NULL)
			{
			dlclose(mo);
			return false;
			}
		(*demo2)(this, this);
		}
	return true;
}

void ScribusApp::GetCMSProfiles()
{
	MonitorProfiles.clear();
	PrinterProfiles.clear();
	InputProfiles.clear();
#ifdef HAVE_CMS
	QString pfad = PREL;
	QString nam = "";
	const char *Descriptor;
	cmsHPROFILE hIn;
	pfad += "/share/scribus/profiles/";
	QDir d(pfad, "*.*", QDir::Name, QDir::Files | QDir::NoSymLinks);
	if ((d.exists()) && (d.count() != 0))
		{
		for (uint dc = 0; dc < d.count(); dc++)
			{
			QFileInfo fi(pfad + d[dc]);
			QString ext = fi.extension(false).lower();
			if ((ext == "icm") || (ext == "icc"))
				{
				hIn = cmsOpenProfileFromFile(pfad + d[dc], "r");
  			Descriptor = cmsTakeProductDesc(hIn);
				nam = QString(Descriptor);
				switch ((int) cmsGetDeviceClass(hIn))
					{
					case icSigInputClass:
						if ((int) cmsGetColorSpace(hIn) == icSigRgbData)
							InputProfiles[nam] = pfad + d[dc];
						break;
					case icSigColorSpaceClass:
						if ((int) cmsGetColorSpace(hIn) == icSigRgbData)
							InputProfiles[nam] = pfad + d[dc];
						break;
					case icSigDisplayClass:
						MonitorProfiles[nam] = d[dc];
						InputProfiles[nam] = pfad + d[dc];
						break;
					case icSigOutputClass:
						PrinterProfiles[nam] = d[dc];
						break;
					}
				cmsCloseProfile(hIn);
				}
			}
		if ((!PrinterProfiles.isEmpty()) && (!InputProfiles.isEmpty()) && (!MonitorProfiles.isEmpty()))
			CMSavail = true;
		}
	else
		CMSavail = false;
#else
	CMSavail = false;
#endif
}

void ScribusApp::SetCMSPrefs()
{
	struct CMSset *CM;
	if (CMSavail)
		{
		if (HaveDoc)
			CM = &doc->CMSSettings;
		else
			CM = &Prefs.DCMSset;
		CMSPrefs *dia = new CMSPrefs(this, CM, &InputProfiles, &PrinterProfiles, &MonitorProfiles);
		if(dia->exec())
			{
			int cc = Prefs.DColors.count();
			FMess->setText(tr("Adjusting Colors"));
			FProg->reset();
			if (HaveDoc)
				{
				if (dia->Changed)
					{
  				cc = doc->PageColors.count() + view->CountElements();
					FProg->setTotalSteps(cc);
					slotDocCh();
#ifdef HAVE_CMS
					doc->HasCMS = doc->CMSSettings.CMSinUse;
					SoftProofing = doc->CMSSettings.SoftProofOn;
					Gamut = doc->CMSSettings.GamutCheck;
					CMSuse = doc->CMSSettings.CMSinUse;
					IntentPrinter = doc->CMSSettings.DefaultIntentPrinter;
					IntentMonitor = doc->CMSSettings.DefaultIntentMonitor;
#endif
  				qApp->setOverrideCursor(QCursor(waitCursor), true);
  				CloseCMSProfiles();
  				OpenCMSProfiles();
					RecalcColors(FProg);
					view->RecalcPictures(&InputProfiles, FProg);
					view->DrawNew();
					FProg->setProgress(cc);
 					qApp->setOverrideCursor(QCursor(arrowCursor), true);
 					}
				}
			else
				{
				if (dia->Changed)
					{
#ifdef HAVE_CMS
					SoftProofing = Prefs.DCMSset.SoftProofOn;
					Gamut = Prefs.DCMSset.GamutCheck;
					CMSuse = Prefs.DCMSset.CMSinUse;
					IntentPrinter = Prefs.DCMSset.DefaultIntentPrinter;
					IntentMonitor = Prefs.DCMSset.DefaultIntentMonitor;
#endif
  				qApp->setOverrideCursor(QCursor(waitCursor), true);
  				CloseCMSProfiles();
  				OpenCMSProfiles();
					RecalcColors(FProg);
 					qApp->setOverrideCursor(QCursor(arrowCursor), true);
 					}
				}
			FMess->setText("");
			FProg->reset();
			}
		delete dia;
		}
}

void ScribusApp::OpenCMSProfiles()
{
#ifdef HAVE_CMS
	QString pfad = PREL;
	pfad += "/share/scribus/profiles/";
	if (HaveDoc)
		{
		doc->DocInputProf = cmsOpenProfileFromFile(InputProfiles[doc->CMSSettings.DefaultInputProfile2], "r");
		doc->DocOutputProf = cmsOpenProfileFromFile(pfad + MonitorProfiles[doc->CMSSettings.DefaultMonitorProfile], "r");
		doc->DocPrinterProf = cmsOpenProfileFromFile(pfad + PrinterProfiles[doc->CMSSettings.DefaultPrinterProfile], "r");
		CMSDinputProf = CMSinputProf;
		CMSinputProf = doc->DocInputProf;
		CMSDoutputProf = CMSoutputProf;
		CMSoutputProf = doc->DocOutputProf;
		CMSDprinterProf = CMSprinterProf;
		CMSprinterProf = doc->DocPrinterProf;
		}
	else
		{
		CMSinputProf = cmsOpenProfileFromFile(InputProfiles[Prefs.DCMSset.DefaultInputProfile2], "r");
		CMSoutputProf = cmsOpenProfileFromFile(pfad + MonitorProfiles[Prefs.DCMSset.DefaultMonitorProfile], "r");
		CMSprinterProf = cmsOpenProfileFromFile(pfad + PrinterProfiles[Prefs.DCMSset.DefaultPrinterProfile], "r");
		}
	int dcmsFlags = 0;
	if (Gamut)
		dcmsFlags |= cmsFLAGS_GAMUTCHECK;
	else
		dcmsFlags |= cmsFLAGS_SOFTPROOFING;
	stdProof = cmsCreateProofingTransform(CMSinputProf, TYPE_RGB_16,
														 				 		CMSoutputProf, TYPE_RGB_16,
														 				 		CMSprinterProf,
														 				 		IntentPrinter,
														 				 		IntentMonitor, dcmsFlags);
	stdTrans = cmsCreateTransform(CMSinputProf, TYPE_RGB_16,
														 	  CMSoutputProf, TYPE_RGB_16,
														 	  IntentMonitor,
														 	  cmsFLAGS_NOTPRECALC);
	stdProofImg = cmsCreateProofingTransform(CMSinputProf, TYPE_RGBA_8,
														 				 			 CMSoutputProf, TYPE_RGBA_8,
														 				 			 CMSprinterProf,
														 				 			 IntentPrinter,
														 				 			 IntentMonitor, dcmsFlags);
	stdTransImg = cmsCreateTransform(CMSinputProf, TYPE_RGBA_8,
														 	  	 CMSoutputProf, TYPE_RGBA_8,
														 	  	 IntentMonitor,
														 	  	 cmsFLAGS_NOTPRECALC);
#endif
}

void ScribusApp::CloseCMSProfiles()
{
#ifdef HAVE_CMS
	QString pfad = PREL;
	pfad += "/share/scribus/profiles/";
	if (HaveDoc)
		{
		cmsCloseProfile(doc->DocInputProf);
		cmsCloseProfile(doc->DocOutputProf);
		cmsCloseProfile(doc->DocPrinterProf);
		CMSinputProf = CMSDinputProf;
		CMSoutputProf = CMSDoutputProf;
		CMSprinterProf = CMSDprinterProf;
		}
	else
		{
		cmsCloseProfile(CMSinputProf);
		cmsCloseProfile(CMSoutputProf);
		cmsCloseProfile(CMSprinterProf);
		}
	cmsDeleteTransform(stdTrans);
	cmsDeleteTransform(stdProof);
	cmsDeleteTransform(stdTransImg);
	cmsDeleteTransform(stdProofImg);
#endif
}

void ScribusApp::RecalcColors(QProgressBar *dia)
{
	CListe::Iterator it;
	if (HaveDoc)
		{
		ColorMenu->clear();
		QPixmap pm = QPixmap(15, 15);
		int a = 0;
		ColorMenu->insertItem(tr("None"));
		for (it = doc->PageColors.begin(); it != doc->PageColors.end(); ++it)
			{
			doc->PageColors[it.key()].RecalcRGB();
			pm.fill(doc->PageColors[it.key()].getRGBColor());
			ColorMenu->insertItem(QIconSet(pm), it.key());
			if (it.key() == doc->Dbrush)
				{
				ColorMenu->setItemChecked(ColorMenu->idAt(a), true);
				}
			a++;
			if (dia != NULL)
				dia->setProgress(a);
			}
		Cpal->SetColors(doc->PageColors);
		}
	else
		{
		int a = 0;
		for (it = Prefs.DColors.begin(); it != Prefs.DColors.end(); ++it)
			{
			a++;
			if (dia != NULL)
				dia->setProgress(a);
			Prefs.DColors[it.key()].RecalcRGB();
			}
		Cpal->SetColors(Prefs.DColors);
		}
}

void ScribusApp::ModifyAnnot()
{
	PageItem *b;
  if (doc->ActPage->SelItem.count() != 0)
  	{
  	b = doc->ActPage->SelItem.at(0);
		if ((b->AnType == 0) || (b->AnType == 1) || (b->AnType > 9))
			{
  		Annota *dia = new Annota(this, b, doc->PageC, doc->PageB, doc->PageH, doc->PageColors, view);
  		if (dia->exec())
				slotDocCh();
  		delete dia;
			}
		else
			{
  		Annot *dia = new Annot(this, b, doc->PageC, doc->PageB, doc->PageH, doc->PageColors, view);
  		if (dia->exec())
				slotDocCh();
  		delete dia;
			}
  	}
}

void ScribusApp::SetShortCut()
{
	uint a;
	for (a = 0; a < 9; a++)
		{
		fileMenu->setAccel(Prefs.KeyActions[a].KeyID, Prefs.KeyActions[a].MenuID);
		}
	for (a = 9; a < 19; a++)
		{
		editMenu->setAccel(Prefs.KeyActions[a].KeyID, Prefs.KeyActions[a].MenuID);
		}
	for (a = 19; a < 30; a++)
		{
		ObjMenu->setAccel(Prefs.KeyActions[a].KeyID, Prefs.KeyActions[a].MenuID);
		}
	for (a = 30; a < 34; a++)
		{
		pageMenu->setAccel(Prefs.KeyActions[a].KeyID, Prefs.KeyActions[a].MenuID);
		}
	pageMenu->setAccel(Prefs.KeyActions[61].KeyID, Prefs.KeyActions[61].MenuID);
	for (a = 34; a < 45; a++)
		{
		viewMenu->setAccel(Prefs.KeyActions[a].KeyID, Prefs.KeyActions[a].MenuID);
		}
	for (a = 45; a < 51; a++)
		{
		toolMenu->setAccel(Prefs.KeyActions[a].KeyID, Prefs.KeyActions[a].MenuID);
		}
	extraMenu->setAccel(Prefs.KeyActions[51].KeyID, Prefs.KeyActions[51].MenuID);
	for (a = 52; a < 56; a++)
		{
		helpMenu->setAccel(Prefs.KeyActions[a].KeyID, Prefs.KeyActions[a].MenuID);
		}
	ObjMenu->setAccel(Prefs.KeyActions[61].KeyID, Prefs.KeyActions[61].MenuID);
	toolMenu->setAccel(Prefs.KeyActions[62].KeyID, Prefs.KeyActions[62].MenuID);
	editMenu->setAccel(Prefs.KeyActions[63].KeyID, Prefs.KeyActions[63].MenuID);
	editMenu->setAccel(Prefs.KeyActions[64].KeyID, Prefs.KeyActions[64].MenuID);
	toolMenu->setAccel(Prefs.KeyActions[65].KeyID, Prefs.KeyActions[65].MenuID);
}

void ScribusApp::PutScrap(QString t)
{
	ScBook->ObjFromMenu(t);
}

void ScribusApp::Pfadtext()
{
	doc->ActPage->ToPathText();
	doc->UnDoValid = false;
	CanUndo();
}

void ScribusApp::changeLayer(int l)
{
	doc->ActPage->Deselect();
	view->setLayMenTxt(l);
	view->LaMenu();
	view->DrawNew();
}

void ScribusApp::showLayer()
{
	view->DrawNew();
}

void ScribusApp::LayerRemove(int l)
{
	for (uint a = 0; a < view->Pages.count(); a++)
		{
		for (uint b = 0; b < view->Pages.at(a)->Items.count(); b++)
			{
			if (view->Pages.at(a)->Items.at(b)->LayerNr == l)
				view->Pages.at(a)->Items.at(b)->LayerNr = 0;
			}
		}
	for (uint a = 0; a < view->MasterPages.count(); a++)
		{
		for (uint b = 0; b < view->MasterPages.at(a)->Items.count(); b++)
			{
			if (view->MasterPages.at(a)->Items.at(b)->LayerNr == l)
				view->MasterPages.at(a)->Items.at(b)->LayerNr = 0;
			}
		}
	for (uint a = 0; a < view->DocPages.count(); a++)
		{
		for (uint b = 0; b < view->DocPages.at(a)->Items.count(); b++)
			{
			if (view->DocPages.at(a)->Items.at(b)->LayerNr == l)
				view->DocPages.at(a)->Items.at(b)->LayerNr = 0;
			}
		}
	view->LaMenu();
}

void ScribusApp::UnDoAction()
{
	PageItem* b;
	uint a;
	bool mp = false;
	if (doc->UnDoValid)
		{
		b = doc->UnData.Item;
		b->Select = false;
		view->Pages.at(doc->UnData.PageNr)->SelItem.clear();
		switch (doc->UnData.UnCode)
			{
			case 0:
				view->Pages.at(doc->UnData.PageNr)->Items.insert(b->ItemNr, b);
				for (a = 0; a < view->Pages.at(doc->UnData.PageNr)->Items.count(); a++)
					{
					view->Pages.at(doc->UnData.PageNr)->Items.at(a)->ItemNr = a;
					}
				break;
			case 1:
				b->Xpos = doc->UnData.Xpos;
				b->Ypos = doc->UnData.Ypos;
				break;
			case 2:
				b->Xpos = doc->UnData.Xpos;
				b->Ypos = doc->UnData.Ypos;
				b->Rot = doc->UnData.Rot;
				if (b->PType == 5)
					mp = true;
				view->Pages.at(doc->UnData.PageNr)->SizeItem(doc->UnData.Width, doc->UnData.Height, b->ItemNr, mp);
				break;
			case 3:
				b->Rot = doc->UnData.Rot;
				break;
			case 4:
				view->Pages.at(doc->UnData.PageNr)->Items.take(b->ItemNr);
				view->Pages.at(doc->UnData.PageNr)->Items.insert(doc->UnData.ItemNr, b);
				for (a = 0; a < view->Pages.at(doc->UnData.PageNr)->Items.count(); a++)
					{
					view->Pages.at(doc->UnData.PageNr)->Items.at(a)->ItemNr = a;
					}
				break;
			}
		view->DrawNew();
		doc->UnDoValid = false;
		editMenu->setItemEnabled(edUndo, 0);
		slotDocCh();
		}
}

void ScribusApp::CanUndo()
{
	switch (doc->UnData.UnCode)
		{
		case 0:
			editMenu->changeItem(edUndo, tr("Undo Delete Object"));
			break;
		case 1:
		case 4:
			editMenu->changeItem(edUndo, tr("Undo Object Move"));
			break;
		case 2:
		case 3:
			editMenu->changeItem(edUndo, tr("Undo Object Change"));
			break;
		}
	if (doc->UnDoValid)	
		editMenu->setItemEnabled(edUndo, 1);
	else
		editMenu->setItemEnabled(edUndo, 0);
}

void ScribusApp::slotTest()
{
}

void ScribusApp::slotTest2()
{
}
