/***************************************************************************
                          pageitem.h  -  description
                             -------------------
    begin                : Sat Apr 7 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PAGEITEM_H
#define PAGEITEM_H

#include <qobject.h>
#include <qwidget.h>
#include <qpointarray.h>
#include <qptrlist.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qfont.h>
#include <qvaluestack.h>
#include "scribusdoc.h"
/**
  *@author Franz Schmid
  */
							
class PageItem : public QObject  {

public: 
	PageItem(Page* pa, int art, float x, float y, float w, float h, float w2, QString fill, QString outline, ScribusDoc *doc);
	~PageItem();
  /** Zeichnet das Item */
  void paintObj(QRect e=QRect(), QPixmap *ppX = 0);
  void CopyIt(struct CLBuf *Buffer);
	void SetZeichAttr(QPainter *p, QFont *ffo, struct Pti *hl, int *chs, QString *chx);
	void SetFarbe(QColor *tmp, QString farbe, int shad);
	QString ExpandToken(uint base);
  /** X-Position auf der Seite */
  float Xpos;
  /** Y-Position auf der Seite */
  float Ypos;
  /** Breite des Elements */
  float Width;
  /** Hhe des Elements */
  float Height;
  /** Eckrundung von Rechtecken */
  float RadRect;
  /** Art des Items */
  int PType;
  /** Winkel um den das Item gedreht wird */
  float Rot;
  /** Enthlt das bergeordnete Objekt */
  QWidget *Parent;
  /** Enthlt das Dokument */
  ScribusDoc *Doc;
  /** Fllfarbe */
  QString Pcolor;
  /** Abstufung fr Fllfarbe */
  int Shade;
  /** Zeichenfarbe fr Elemente */
  QString Pcolor2;
  /** Abstufung fr Zeichenfarbe */
  int Shade2;
  /** Strichstrke */
  float Pwidth;
  /** Linienart */
  PenStyle PLineArt;
  PenCapStyle PLineEnd;
  PenJoinStyle PLineJoin;
  /** Element selektiert Ja/Nein */
  bool Select;
  /** Definiert die Clipping-Region des Elements; */
  QPointArray Clip;
	FPointArray PoLine;
	bool PoShow;
	float BaseOffs;
  bool ClipEdited;
  int FrameType;
  /** Interne Item-Nummer */
  uint ItemNr;
  /** Hat Element Rahmen? */
  bool Frame;
  /** Seite zu der das Element gehrt */
  Page *OwnPage;
  /** Darzustellendes Bild */
  QImage pixm;
//  QPixmap pixm;
  /** Dateiname des Bildes */
  QString Pfile;
  QString Pfile2;
  QString Pfile3;
  QString IProfile;
  bool UseEmbedded;
  QString EmProfile;
  int IRender;
  /** Darstellungsart Bild/Titel */
  bool PicArt;
  /** Bild verfgbar */
  bool PicAvail;
  /** Lokales Scaling x*/
  float LocalScX;
  /** Lokales Scaling y*/
  float LocalScY;
  /** Lokales X */
  float LocalX;
  /** Lokales Y */
  float LocalY;
  /** Anzahl horizontaler Spiegelungen */
  int flippedH;
  /** Anzahl vertikaler Spiegelungen */
  int flippedV;
  /** BoundigBox-X */
  float BBoxX;
  /** BoundingBox-H */
  float BBoxH;
  /** Extra Abstand vom Rand */
  float Extra;
  /** Linespacing */
  float LineSp;
  /** Zeichen X-Position */
  float CurX;
  /** Zeichen Y-Position */
  float CurY;
  /** Cursorposition */
  int CPos;
  /** Text des Elements */
  QPtrList<Pti> Ptext;
  /** Flag ob Element gedruckt wird */
  bool isPrintable;
  /** Flag fr PDF-Bookmark */
  bool isBookmark;
  int BMnr;
  /** Flag fr PDF-Annotation */
  bool isAnnotation;
  int AnType;
	int AnActType;
  QString AnAction;
	QString An_E_act;
	QString An_X_act;
	QString An_D_act;
	QString An_Fo_act;
	QString An_Bl_act;
	QString An_K_act;
	QString An_F_act;
	QString An_V_act;
	QString An_C_act;
	QString AnName;
	QString AnToolTip;
	QString AnRollOver;
	QString AnDown;
	QString AnBColor;
	int AnBsty;
	int AnBwid;
	int AnFeed;
  int AnZiel;
	int AnFlag;
	int AnMaxChar;
	int AnVis;
	int AnChkStil;
	int AnFont;
	bool AnIsChk;
	bool AnAAact;
	bool AnHTML;
	bool AnUseIcons;
	int AnIPlace;
	int AnScaleW;
	int AnFormat;
  /** Flag fr neuzeichnen im EditMode */
  bool Dirty;
  /** Item Font */
  QString IFont;
  /** Item Fontgre */
  int ISize;
  /** Flag fr Auswahl */
  bool HasSel;
  /** Flag fr Textfluss */
  bool Textflow;
  bool FrameOnly;
  PageItem *BackBox;
  PageItem *NextBox;
  int NextIt;
  int NextPg;
  bool Tinput;
  bool isAutoText;
  int Ausrich;
  uint MaxChars;
  bool Redrawn;
  float ExtraV;
  bool isRaster;
  float OldB;
  float OldH;
  float OldB2;
  float OldH2;
  bool Sizing;
  bool toPixmap;
  float DevRes;
	int LayerNr;
	bool ScaleType;
	bool AspectRatio;
  QValueStack<int> Groups;
	struct ZZ { QString Zeich;
					 QColor Farb;
					 QFont Zsatz;
					 QString ZFo;
					 float xco;
					 float yco;
					 bool Sele;
					 int Siz;
				  };
};

#endif
