/***************************************************************************
                          pslib.cpp  -  description
                             -------------------
    begin                : Sat May 26 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qfileinfo.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qimage.h>
#include <qcolor.h>
#include <qcstring.h>
#include <qfontinfo.h>
#include <stdlib.h>
#include "config.h"
#include "pslib.h"
#include "scfonts.h"

extern bool loadText(QString nam, QString *Buffer);
extern QImage LoadPict(QString fn);
#include <iostream.h>

extern "C" void* Run(bool psart, SCFonts &AllFonts, QMap<QString,QFont> DocFonts, CListe DocColors, bool pdf);

void* Run(bool psart, SCFonts &AllFonts, QMap<QString,QFont> DocFonts, CListe DocColors, bool pdf)
{
	PSLib *dia = new PSLib(psart, AllFonts, DocFonts, DocColors, pdf);
	return dia;
}

PSLib::PSLib(bool psart, SCFonts &AllFonts, QMap<QString,QFont> DocFonts, CListe DocColors, bool pdf)
{
	QString tmp, tmp2, tmp3, tmp4, CHset;
	Seiten = 0;
	Seite = "";
	Dokument = "";
	User = "";
	Creator = "PSlib-0.1";
	Titel = "";
	FillColor = "0.0 0.0 0.0 0.0";
	StrokeColor = "0.0 0.0 0.0 0.0";
  if (psart)
  	{
  	Header = "%!PS-Adobe-3.0\n";
  	}
  else
  	{
  	Header = "%!PS-Adobe-3.0 EPSF-3.0\n";
  	}
	BBox = "";
	BBoxH = "";
	Art = psart;
	isPDF = pdf;
	UsedFonts.clear();
	Fonts = "";
	FontDesc = "";
	GraySc = false;
	GrayCalc =  "/setcmykcolor {exch 0.11 mul add exch 0.59 mul add exch 0.3 mul add\n";
	GrayCalc += "               dup 1 gt {pop 1} if 1 exch sub oldsetgray} bind def\n";
	GrayCalc += "/setrgbcolor {0.11 mul exch 0.59 mul add exch 0.3 mul add\n";
	GrayCalc += "              oldsetgray} bind def\n";
	Farben = "%%CMYKCustomColor: ";
	FNamen = "%%DocumentCustomColors: ";
	CListe::Iterator itf;
	int c, m, y, k;
	bool erst = true;
	for (itf = DocColors.begin(); itf != DocColors.end(); ++itf)
		{
		if ((itf.key() != "Cyan") && (itf.key() != "Magenta") && (itf.key() != "Yellow") && (itf.key() != "Black"))
			{
			DocColors[itf.key()].getCMYK(&c, &m, &y, &k);
			if (!erst)
				{
				Farben += "%%+ ";
				FNamen += "%%+ ";
				}
			Farben += ToStr(float(c) / 255) + " " +  ToStr(float(m) / 255) + " ";
			Farben += ToStr(float(y) / 255) + " " +  ToStr(float(k) / 255) + " (" + itf.key() + ")\n";
			FNamen += "(" + itf.key() + ")\n";
			erst = false;
			}
		}
	QMap<QString,QFont>::Iterator it;
	int a = 0;
	for (it = DocFonts.begin(); it != DocFonts.end(); ++it)
		{
		UsedFonts.insert(it.key(), "/Fo"+IToStr(a));
//		QFontInfo foni = QFontInfo(AllFonts[it.key()]->Font);
		CHset = AllFonts[it.key()]->FontEnc;  //.encodingName(foni.charSet());
		if ((CHset == "iso8859-1") || (CHset == "ascii-0") || (CHset == "iso8859-15"))
			Fonts += "/"+AllFonts[it.key()]->RealName()+" /Fo"+IToStr(a)+" cf ef\n";
		if (CHset == "iso8859-2")
			Fonts += "/"+AllFonts[it.key()]->RealName()+" /Fo"+IToStr(a)+" iso2f ef\n";
		if (CHset == "adobe-fontspecific")
			Fonts += "/Fo"+IToStr(a)+" /"+AllFonts[it.key()]->RealName()+" findfont definefont pop\n";
		if (AllFonts[it.key()]->EmbedPS)
			{
			QString tmp;
			if(AllFonts[it.key()]->EmbedFont(tmp))
				{
				FontDesc += "%%BeginFont: " + AllFonts[it.key()]->RealName() + "\n";
				FontDesc += tmp + "\n%%EndFont\n";
				}
			}
		a++;
		}
	Prolog = "%%BeginProlog\n";
	Prolog += "/Scribusdict 100 dict def\n";
	Prolog += "Scribusdict begin\n";
	Prolog += "/oldsetgray /setgray load def\n";
	Prolog += "/cmyk {setcmykcolor} def\n";
	Prolog += "/m {moveto} bind def\n";
	Prolog += "/li {lineto} bind def\n";
	Prolog += "/cl {closepath} bind def\n";
	Prolog += "/gs {gsave} bind def\n";
	Prolog += "/gr {grestore} bind def\n";
	Prolog += "/tr {translate} bind def\n";
	Prolog += "/ro {rotate} bind def\n";
	Prolog += "/sh {show} bind def\n";
	Prolog += "/ftt {currentfont /FontType get 42 eq { 1000 } { 1 } ifelse div} bind def\n";
	Prolog += "/shm {setcmykcolor moveto\n";
	Prolog += "      dup (\\244) eq\n";
	Prolog += "        {pop /Euro glyphshow}\n";
	Prolog += "        {dup (\\55) eq\n";
	Prolog += "          {pop /hyphen glyphshow}\n";
	Prolog += "          {show}\n";
	Prolog += "        ifelse}\n";
	Prolog += "      ifelse} def\n";
	Prolog += "/shb {cmyk newpath m true charpath 1 setlinejoin\n";
	Prolog += "      currentfont dup /FontMatrix get exch /FontInfo get\n";
	Prolog += "      dup /UnderlinePosition get ftt exch /UnderlineThickness get ftt\n";
	Prolog += "      3 -1 roll dtransform setlinewidth pop gs stroke gr fill} bind def\n";
	Prolog += "/sc {scale} bind def\n";
	Prolog += "/se {selectfont} bind def\n";
	Prolog += "/sf {setfont} bind def\n";
	Prolog += "/sw {setlinewidth} bind def\n";
	Prolog += "/srt {2 setlinecap currentfont dup /FontMatrix get\n";
	Prolog += "      exch /FontInfo get dup /UnderlinePosition get ftt exch\n";
	Prolog += "      /UnderlineThickness get ftt 3 -1 roll dtransform\n";
	Prolog += "      setlinewidth 0 exch rmoveto stringwidth rlineto stroke} bind def\n";
	Prolog += "/srd {2 setlinecap currentfont dup /FontMatrix get\n";
	Prolog += "      exch /FontInfo get dup /UnderlinePosition get ftt exch\n";
	Prolog += "      /UnderlineThickness get ftt 3 -1 roll dtransform\n";
	Prolog += "      setlinewidth pop stringwidth rlineto stroke} bind def\n";
	Prolog += "/f  {findfont} bind def\n";
	Prolog += "/mf {makefont} bind def\n";
	Prolog += "/ss {scalefont setfont} bind def\n";
	Prolog += "/ci {newpath 0 0 1 0 360 arc} bind def\n";
	Prolog += "/fi {fill} bind def\n";
	Prolog += "/st {stroke} bind def\n";
	Prolog += "/iso2f [\n";
	QString iso2enc;
  QString Epfad = PREL;
  Epfad += "/share/scribus/iso8859-2ps.enc";
	loadText(Epfad, &iso2enc);
	Prolog += iso2enc;
	Prolog += "] def\n";
	Prolog += "/cf [\n";
	Prolog += "    16#2d /hyphen\n";
	Prolog += "    16#80 /euro\n";
	Prolog += "    16#82 /quotesinglbase\n";
	Prolog += "    16#83 /florin\n";
	Prolog += "    16#84 /quotedblbase\n";
	Prolog += "    16#85 /ellipsis\n";
	Prolog += "    16#86 /dagger\n";
	Prolog += "    16#87 /daggerdbl\n";
	Prolog += "    16#88 /circumflex\n";
	Prolog += "    16#89 /perthousand\n";
	Prolog += "    16#8a /Scaron\n";
	Prolog += "    16#8b /guilsinglleft\n";
	Prolog += "    16#8c /OE\n";
	Prolog += "    16#8e /zcaron\n";
	Prolog += "    16#91 /quoteleft\n";
	Prolog += "    16#92 /quoteright\n";
	Prolog += "    16#93 /quotedblleft\n";
	Prolog += "    16#94 /quotedblright\n";
	Prolog += "    16#95 /bullet\n";
	Prolog += "    16#96 /endash\n";
	Prolog += "    16#97 /emdash\n";
	Prolog += "    16#98 /tilde\n";
	Prolog += "    16#99 /trademark\n";
	Prolog += "    16#9a /scaron\n";
	Prolog += "    16#9b /guilsinglright\n";
	Prolog += "    16#9c /oe\n";
	Prolog += "    16#9e /zcaron\n";
	Prolog += "    16#9f /Ydieresis\n";
	Prolog += "] def\n";
	Prolog += "/ski /ISOLatin1Encoding where{pop true}{false}ifelse def\n";
	Prolog += "/reencodesmalldict 12 dict def\n";
	Prolog += "/ef {\n";
	Prolog += "    reencodesmalldict begin\n";
	Prolog += "    /newcodesandnames exch def\n";
	Prolog += "    /newfontname exch def\n";
	Prolog += "    /basefontname exch def\n";
	Prolog += "    /basefontdict basefontname findfont def\n";
	Prolog += "    /newfont basefontdict maxlength dict def\n";
	Prolog += "    basefontdict\n";
	Prolog += "    {\n";
	Prolog += "        exch dup /FID ne\n";
	Prolog += "        {\n";
	Prolog += "            dup /Encoding eq\n";
	Prolog += "            {\n";
	Prolog += "                ski\n";
	Prolog += "                {\n";
	Prolog += "                    exch pop\n";
	Prolog += "                    ISOLatin1Encoding dup length array copy\n";
	Prolog += "                }{\n";
	Prolog += "                exch dup length array copy\n";
	Prolog += "            }\n";
	Prolog += "            ifelse\n";
	Prolog += "            newfont 3 1 roll put\n";
	Prolog += "            }{\n";
	Prolog += "                exch newfont 3 1 roll put\n";
	Prolog += "            }\n";
	Prolog += "            ifelse\n";
	Prolog += "        }{\n";
	Prolog += "        pop pop\n";
	Prolog += "    }\n";
	Prolog += "    ifelse\n";
	Prolog += "    } forall\n";
	Prolog += "    newfont /FontName newfontname put\n";
	Prolog += "    newcodesandnames aload pop\n";
	Prolog += "    newcodesandnames length 2 idiv\n";
	Prolog += "    {\n";
	Prolog += "        newfont /Encoding get 3 1 roll put\n";
	Prolog += "    } repeat\n";
	Prolog += "    newfontname newfont definefont pop\n";
	Prolog += "    end\n";
	Prolog += "    } def\n";
	Prolog += "/bEPS {\n";
	Prolog += "    /b4_Inc_state save def\n";
	Prolog += "    /dict_count countdictstack def\n";
	Prolog += "    /op_count count 1 sub def\n";
	Prolog += "    userdict begin\n";
	Prolog += "    /showpage { } def\n";
	Prolog += "    0 setgray 0 setlinecap\n";
	Prolog += "    1 setlinewidth 0 setlinejoin\n";
	Prolog += "    10 setmiterlimit [ ] 0 setdash newpath\n";
	Prolog += "    /languagelevel where\n";
	Prolog += "    {pop languagelevel\n";
	Prolog += "    1 ne\n";
	Prolog += "    {false setstrokeadjust false setoverprint\n";
	Prolog += "    } if } if } bind def\n";
	Prolog += "/eEPS { count op_count sub {pop} repeat\n";
	Prolog += "    countdictstack dict_count sub {end} repeat\n";
	Prolog += "    b4_Inc_state restore } bind def\n";
	Prolog += "    end\n";
	Prolog += "%%EndProlog\n";
}
PSLib::~PSLib()
{
}

void PSLib::PutSeite(QString c)
{
	Seite += c;
}

void PSLib::PutDoc(QString c)
{
	Dokument += c;
}

QString PSLib::ToStr(float c)
{
	QString cc;
	return cc.setNum(c);
}

QString PSLib::IToStr(int c)
{
	QString cc;
	return cc.setNum(c);
}

void PSLib::PS_set_Info(QString art, QString was)
{
	if (art == "Author")
		User = was;
	if (art == "Creator")
		Creator = was;
	if (art == "Title")
		Titel = was;
}

void PSLib::PS_begin_page(int Ori, float breite, float hoehe, struct Margs* Ma)
{
	BBox = "%%BoundingBox: 0 0 " + IToStr(qRound(breite)) + " " + IToStr(qRound(hoehe)) + "\n";
	BBoxH = "%%HiResBoundingBox: 0 0 " + ToStr(breite) + " " + ToStr(hoehe) + "\n";
  if (Art)
  	{
		PutSeite("<< /PageSize [ "+ToStr(breite)+" "+ToStr(hoehe)+" ]\n");
		if (Ori != 0)
			PutSeite("/Orientation 3\n");
		PutSeite(">> setpagedevice\n");
		}
	PDev = ToStr(Ma->Left) + " " + ToStr(Ma->Bottom) + " m\n";
	PDev += ToStr(breite - Ma->Right) + " " + ToStr(Ma->Bottom) + " li\n";
	PDev += ToStr(breite - Ma->Right) + " " + ToStr(hoehe - Ma->Top) + " li\n";
	PDev += ToStr(Ma->Left) + " " + ToStr(hoehe - Ma->Top) + " li cl clip newpath\n";
	Seiten++;
	PutSeite("%%Page: " + IToStr(Seiten) + " " + IToStr(Seiten) + "\nsave\n" + PDev);
}

void PSLib::PS_end_page()
{
	PutSeite("%%PageTrailer\nrestore\nshowpage\n");
}

void PSLib::PS_rect(float x, float y, float b, float h)
{
	PutSeite(ToStr(x) + " " + ToStr(y) + " m\n");
	PutSeite(ToStr(x) + " " + ToStr(y+h) + " li\n");
	PutSeite(ToStr(x+b) + " " + ToStr(y+h) + " li\n");
	PutSeite(ToStr(x+b) + " " + ToStr(y) + " li\n");
	PutSeite("cl\n");
}

void PSLib::PS_RoundRect(float x, float y, float b, float h, float r)
{
	PutSeite(ToStr(x+r) + " " + ToStr(y) + " m\n");
	PutSeite(ToStr(x+b) + " " + ToStr(y) + " " + ToStr(x+b) + " " + ToStr(y+h) + " " + ToStr(r) + " arct\n");
	PutSeite(ToStr(x+b) + " " + ToStr(y+h) + " " + ToStr(x) + " " + ToStr(y+h) + " " + ToStr(r) + " arct\n");
	PutSeite(ToStr(x) + " " + ToStr(y+h) + " " + ToStr(x) + " " + ToStr(y) + " " + ToStr(r) + " arct\n");
	PutSeite(ToStr(x) + " " + ToStr(y) + " " + ToStr(x+b) + " " + ToStr(y) + " " + ToStr(r) + " arct\n");
	PutSeite("cl\n");
}

void PSLib::PS_circle(float r, float r2)
{
	PutSeite("/cmtx matrix currentmatrix def\n");
	PutSeite(ToStr(r) + " " + ToStr(r2) + " scale ci\n");
	PutSeite("cmtx setmatrix\n");
}

void PSLib::PS_curve(float x1, float y1, float x2, float y2, float x3, float y3)
{
	PutSeite(ToStr(x1) + " " + ToStr(y1) + " " + ToStr(x2) + " " + ToStr(y2) + " " + ToStr(x3) + " " + ToStr(y3) + " curveto\n");
}

void PSLib::PS_moveto(float x, float y)
{
	PutSeite(ToStr(x) + " " + ToStr(y) + " m\n");
}

void PSLib::PS_lineto(float x, float y)
{
	PutSeite(ToStr(x) + " " + ToStr(y) + " li\n");
}

void PSLib::PS_closepath()
{
	PutSeite("cl\n");
}

void PSLib::PS_translate(float x, float y)
{
	PutSeite(ToStr(x) + " " + ToStr(y) + " tr\n");
}

void PSLib::PS_scale(float x, float y)
{
	PutSeite(ToStr(x) + " " + ToStr(y) + " sc\n");
}

void PSLib::PS_rotate(float x)
{
	PutSeite(ToStr(x) + " ro\n");
}

void PSLib::PS_clip()
{
	PutSeite("clip newpath\n");
}

void PSLib::PS_save()
{
	PutSeite("gs\n");
}

void PSLib::PS_restore()
{
	PutSeite("gr\n");
}

void PSLib::PS_setcmykcolor_fill(float c, float m, float y, float k)
{
	FillColor = ToStr(c) + " " + ToStr(m) + " " + ToStr(y) + " " + ToStr(k);
}

void PSLib::PS_setcmykcolor_stroke(float c, float m, float y, float k)
{
	StrokeColor = ToStr(c) + " " + ToStr(m) + " " + ToStr(y) + " " + ToStr(k);
}

void PSLib::PS_setlinewidth(float w)
{
	PutSeite(ToStr(w) + " sw\n");
	LineW = w;
}

void PSLib::PS_setdash(Qt::PenStyle st, Qt::PenCapStyle ca, Qt::PenJoinStyle jo)
{
	QString Dt = ToStr(QMAX(LineW, 1));
	QString Da = ToStr(QMAX(3*LineW, 1));
	switch (st)
		{
		case Qt::SolidLine:
			PutSeite("[] 0 setdash\n");
			break;
		case Qt::DashLine:
			PutSeite("["+Da+" "+Dt+"] 0 setdash\n");
			break;
		case Qt::DotLine:
			PutSeite("["+Dt+"] 0 setdash\n");
			break;
		case Qt::DashDotLine:
			PutSeite("["+Da+" "+Dt+" "+Dt+" "+Dt+"] 0 setdash\n");
			break;
		case Qt::DashDotDotLine:
			PutSeite("["+Da+" "+Dt+" "+Dt+" "+Dt+" "+Dt+" "+Dt+"] 0 setdash\n");
			break;
		default:
			PutSeite("[] 0 setdash\n");
			break;
		}
	switch (ca)
		{
		case Qt::FlatCap:
			PutSeite("0 setlinecap\n");
			break;
		case Qt::SquareCap:
			PutSeite("2 setlinecap\n");
			break;
		case Qt::RoundCap:
			PutSeite("1 setlinecap\n");
			break;
		default:
			PutSeite("0 setlinecap\n");
			break;
		}
	switch (jo)
		{
		case Qt::MiterJoin:
			PutSeite("0 setlinejoin\n");
			break;
		case Qt::BevelJoin:
			PutSeite("2 setlinejoin\n");
			break;
		case Qt::RoundJoin:
			PutSeite("1 setlinejoin\n");
			break;
		default:
			PutSeite("0 setlinejoin\n");
			break;
		}
}

void PSLib::PS_selectfont(QString f, int s)
{
	PutSeite(UsedFonts[f] + " " + IToStr(s) + " se\n");
}

void PSLib::PS_selectfontItalic(QString f, int s)
{
	PutSeite(UsedFonts[f] + " f [" + IToStr(s) + " 0 7 " + IToStr(s) + " 0 0] mf sf\n");
}

void PSLib::PS_fill()
{
	PutSeite(FillColor + " cmyk fi\n");
}

void PSLib::PS_stroke()
{
	PutSeite(StrokeColor + " cmyk st\n");
}

void PSLib::PS_fill_stroke()
{
	PS_save();
	PS_stroke();
	PS_restore();
	PS_fill();
}

void PSLib::PS_underline(QCString ch, float x, float y)
{
//	QString cc;
	PS_moveto(x, y);
//	PutSeite("(\\"+cc.setNum(ch, 8)+") srt\n");
	PutSeite("("+QString(ch)+") srt\n");
}

void PSLib::PS_strikeout(QCString ch, float x, float y)
{
//	QString cc;
	PS_moveto(x, y);
//	PutSeite("(\\"+cc.setNum(ch, 8)+") srd\n");
	PutSeite("("+QString(ch)+") srd\n");
}

void PSLib::PS_show_xyBold(QCString ch, float x, float y)
{
//	QString cc;
//	PutSeite("(\\"+cc.setNum(ch, 8)+") "+ToStr(x)+" "+ToStr(y)+" "+StrokeColor+" shb\n");
	PutSeite("("+QString(ch)+") "+ToStr(x)+" "+ToStr(y)+" "+StrokeColor+" shb\n");
}

void PSLib::PS_show_xy(QCString ch, float x, float y)
{
//	QString cc;
//	PutSeite("(\\"+cc.setNum(ch, 8)+") "+ToStr(x)+" "+ToStr(y)+" "+StrokeColor+" shm\n");
	PutSeite("("+QString(ch)+") "+ToStr(x)+" "+ToStr(y)+" "+StrokeColor+" shm\n");
}

void PSLib::PS_show()
{
	PutSeite("/hyphen glyphshow\n");
}

char *PSLib::toHex( uchar u )
{
    static char hexVal[3];
    int i = 1;
    while ( i >= 0 )
			{
			ushort hex = (u & 0x000f);
			if ( hex < 0x0a )
	    	hexVal[i] = '0'+hex;
			else
	    	hexVal[i] = 'A'+(hex-0x0a);
			u = u >> 4;
			i--;
    	}
    hexVal[2] = '\0';
    return hexVal;
}

void PSLib::PS_image(float x, float y, QString fn, float scalex, float scaley)
{
	QString tmp;
	QFileInfo fi = QFileInfo(fn);
	QString ext = fi.extension(false).lower();
	if (ext == "eps")
		{
		if (loadText(fn, &tmp))
			{
      PutSeite("bEPS\n");
      PutSeite(ToStr(scalex) + " " + ToStr(scaley) + " sc\n");
      PutSeite(ToStr(x) + " " + ToStr(y) + " tr\n");
      PutSeite("%%BeginDocument: " + fi.fileName() + "\n");
      PutSeite(tmp);
      PutSeite("%%EndDocument\n");
      PutSeite("eEPS\n");
			}
		}
	else
		{
    QString ImgStr = "";
		QImage image;
		image = LoadPict(fn);
  	image = image.convertDepth(32);
		int w = image.width();
		int h = image.height();
    PutSeite(ToStr(x*scalex) + " " + ToStr(y*scaley) + " tr\n");
    PutSeite(ToStr(scalex*w) + " " + ToStr(scaley*h) + " sc\n");
    PutSeite("/DeviceRGB setcolorspace\n");
    if (image.hasAlphaBuffer())
    	{
			QImage iMask = image.createAlphaMask();
			PutSeite("currentfile /ASCIIHexDecode filter /ReusableStreamDecode filter\n");
    	int i = 0;
			for( int yi=0; yi < h; yi++ )
				{
				QRgb * s = (QRgb*)(image.scanLine( yi ));
				for( int xi=0; xi < w; xi++ )
					{
					QRgb r=*s++;
					unsigned char u=qRed(r);
					ImgStr += toHex(u);
					++i;
					u=qGreen(r);
					ImgStr += toHex(u);
					++i;
					u=qBlue(r);
					ImgStr += toHex(u);
					++i;
					if (i>40)
						{
						ImgStr += '\n';
						i=0;
						}     
					}
				}
			PutSeite(ImgStr);
			PutSeite("\n>\n");
			PutSeite("/Bild exch def\n");
			PutSeite("currentfile /ASCIIHexDecode filter /ReusableStreamDecode filter\n");
			ImgStr = "";
    	i = 0;
    	int w2;
    	w2 = w / 8;
    	if ((w % 8) != 0)
    		w2++;
			for( int yi=0; yi < h; yi++ )
				{
				uchar * s = iMask.scanLine( yi );
				for( int xi=0; xi < w2; xi++ )
					{
					unsigned char u = *(s+xi);
					ImgStr += toHex(u);
					++i;
					if (i>40)
						{
						ImgStr += '\n';
						i=0;
						}
					}
				}
			PutSeite(ImgStr);
			PutSeite("\n>\n");
			PutSeite("/Mask exch def\n");
			if (isPDF)
				{
				PutSeite("/BildDict 8 dict def\n");
				PutSeite("BildDict begin\n");
				PutSeite(" /ImageType   1 def\n");
				PutSeite(" /Height    " + IToStr(h) + " def\n");
				PutSeite(" /Width     " + IToStr(w) + " def\n");
				PutSeite(" /ImageMatrix [" + IToStr(w) + " 0 0 " + IToStr(-h) + " 0 " + IToStr(h) +"] def\n");
				PutSeite(" /Decode [0 1 0 1 0 1] def\n");
				PutSeite(" /BitsPerComponent 8 def\n");
				PutSeite(" /MultipleDataSources false def\n");
				PutSeite(" /DataSource Bild def\n");
				PutSeite("end\n");
				PutSeite("/MaskeDict 8 dict def\n");
				PutSeite("MaskeDict begin\n");
				PutSeite(" /ImageType 1 def\n");
				PutSeite(" /Height    " + IToStr(h) + " def\n");
				PutSeite(" /Width     " + IToStr(w) + " def\n");
				PutSeite(" /ImageMatrix [" + IToStr(w) + " 0 0 " + IToStr(-h) + " 0 " + IToStr(h) +"] def\n");
				PutSeite(" /Decode [1 0] def\n");
				PutSeite(" /BitsPerComponent 1 def\n");
				PutSeite(" /MultipleDataSources false def\n");
				PutSeite(" /DataSource Mask def\n");
				PutSeite("end\n");
				PutSeite("/ImageDict 7 dict def\n");
				PutSeite("ImageDict begin\n");
				PutSeite(" /ImageType 3 def\n");			
				PutSeite(" /InterleaveType 3 def\n");
				PutSeite(" /MaskDict MaskeDict def\n");
				PutSeite(" /DataDict BildDict def\n");
				PutSeite("end\n");
				PutSeite("ImageDict image\n");
				}
			else
				{
				PutSeite("<<\n");
				PutSeite("  /PaintType   1\n");
				PutSeite("  /PatternType 1\n");
				PutSeite("  /TilingType  3\n");
				PutSeite("  /BBox        [ 0 0 1 1 ]\n");
				PutSeite("  /XStep       2\n");
				PutSeite("  /YStep       2\n");
				PutSeite("  /PaintProc   {\n");
				PutSeite("   pop\n");
				PutSeite("   1 1 1 setrgbcolor\n");
				PutSeite("   <<\n");
				PutSeite("   /ImageType 1\n");
				PutSeite("   /Height    " + IToStr(h) + "\n");
				PutSeite("   /Width     " + IToStr(w) + "\n");
				PutSeite("   /ImageMatrix [" + IToStr(w) + " 0 0 " + IToStr(-h) + " 0 " + IToStr(h) +"]\n");
				PutSeite("   /Decode [0 1 0 1 0 1]\n");
				PutSeite("   /BitsPerComponent 8\n");
				PutSeite("   /DataSource Bild\n");
				PutSeite("   >>\n");
				PutSeite("   image\n");
				PutSeite("   }\n");
				PutSeite(">> matrix makepattern setpattern\n");
				PutSeite("<< /ImageType 1\n");			
				PutSeite("   /Width " + IToStr(w) + "\n");
				PutSeite("   /Height " + IToStr(h) + "\n");
				PutSeite("   /BitsPerComponent 1\n");
				PutSeite("   /Decode [1 0]\n");
				PutSeite("   /ImageMatrix [" + IToStr(w) + " 0 0 " + IToStr(-h) + " 0 " + IToStr(h) + "]\n");
				PutSeite("   /DataSource Mask\n");
				PutSeite(">>\n");
				PutSeite("imagemask\n");
				}
			}
		else
			{
			PutSeite("<< /ImageType 1\n");		
			PutSeite("   /Width " + IToStr(w) + "\n");
			PutSeite("   /Height " + IToStr(h) + "\n");
			PutSeite("   /BitsPerComponent 8\n");
			PutSeite("   /Decode [0 1 0 1 0 1]\n");
			PutSeite("   /ImageMatrix [" + IToStr(w) + " 0 0 " + IToStr(-h) + " 0 " + IToStr(h) + "]\n");
			PutSeite("   /DataSource currentfile /ASCIIHexDecode filter >>\n");
			PutSeite("image\n");
    	int i = 0;
			for( int yi=0; yi < h; yi++ )
				{
				QRgb * s = (QRgb*)(image.scanLine( yi ));
				for( int xi=0; xi < w; xi++ )
					{
					QRgb r=*s++;
					unsigned char u=qRed(r);
					ImgStr += toHex(u);
					++i;
					u=qGreen(r);
					ImgStr += toHex(u);
					++i;
					u=qBlue(r);
					ImgStr += toHex(u);
					++i;
					if (i>40)
						{
						ImgStr += '\n';
						i=0;
						}
					}
				}
			PutSeite(ImgStr);
			PutSeite("\n>\n");
			}
		}
}

void PSLib::PS_plate(int nr)
{
	switch (nr)
		{
		case 0:
			PutSeite("/setcmykcolor {exch pop exch pop exch pop 1 exch sub oldsetgray} bind def\n");
			PutSeite("/setrgbcolor {pop pop pop 1 oldsetgray} bind def\n");
			break;
		case 1:
			PutSeite("/setcmykcolor {pop pop pop 1 exch sub oldsetgray} bind def\n");
			PutSeite("/setrgbcolor {pop pop oldsetgray} bind def\n");
			break;
		case 2:
			PutSeite("/setcmykcolor {pop pop exch pop 1 exch sub oldsetgray} bind def\n");
			PutSeite("/setrgbcolor {pop exch pop oldsetgray} bind def\n");
			break;
		case 3:
			PutSeite("/setcmykcolor {pop exch pop exch pop 1 exch sub oldsetgray} bind def\n");
			PutSeite("/setrgbcolor {exch pop exch pop oldsetgray} bind def\n");
			break;
		}
}

void PSLib::PS_setGray()
{
	GraySc = true;
}

void PSLib::PDF_Bookmark(QString text, uint Seite)
{
	PutSeite("[/Title ("+text+") /Page "+IToStr(Seite)+" /View [/Fit]\n");
	PutSeite("/OUT pdfmark\n");
	isPDF = true;
}

void PSLib::PDF_Annotation(QString text, float x, float y, float b, float h)
{
	PutSeite("[ /Rect [ "+ToStr(int(x))+" "+ToStr(int(y))+" "+ToStr(int(b))+" "+ToStr(int(h))+" ]\n");
	PutSeite("  /Contents ("+text+")\n  /Open false\n");
	PutSeite("/ANN pdfmark\n");
	isPDF = true;
}


QString PSLib::PS_close()
{
	Dokument = Header;
	PutDoc("%%For: " + User + "\n");
	PutDoc("%%Title: " + Titel + "\n");
	PutDoc("%%Creator: " + Creator + "\n");
	PutDoc("%%Pages: " + IToStr(Seiten) + "\n");
	if (!Art)
		{
		PutDoc(BBox);
		PutDoc(BBoxH);
		}
	PutDoc(FNamen);
	PutDoc(Farben);
	PutDoc("%%LanguageLevel: 2\n");
	PutDoc("%%EndComments\n");
	PutDoc(Prolog);
	PutDoc("%%BeginSetup\n");
	if (isPDF)
		{
		PutDoc("/pdfmark where {pop} {userdict /pdfmark /cleartomark load put} ifelse\n");
		}
	if (FontDesc != "")
		{
		PutDoc(FontDesc);
		}
	PutDoc("Scribusdict begin\n");
	PutDoc(Fonts);
	if (GraySc)
		PutDoc(GrayCalc);
	PutDoc("%%EndSetup\n");
	PutDoc(Seite);
	PutDoc("%%Trailer\n");
	PutDoc("end\n");
	PutDoc("%%EOF\n");
	return Dokument;
}
