/***************************************************************************
                          cpalette.cpp  -  description
                             -------------------
    begin                : Wed Apr 25 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cpalette.h"
#include "cpalette.moc"
#include "query.h"
#include <qmainwindow.h>
extern QPixmap loadIcon(QString nam);

Cpalette::Cpalette(QWidget* parent)
        : QDockWindow( InDock, parent, "Cfloat", WStyle_Customize | WStyle_DialogBorder)
{
	setName("Cfloat");
	resize(150,214);
  setCaption(tr("Colors"));
 	setIcon(loadIcon("AppIcon.xpm"));
 	setOrientation(Vertical);
  QMainWindow* pa = (QMainWindow*)parent;
  pa->moveDockWindow(this, DockLeft);
  setMinimumSize(QSize(150,214));
  setMaximumSize(QSize(150,214));
	Layout1 = new QHBoxLayout;
	Layout1->setSpacing( 4 );
	Layout1->setMargin( 0 );
  Inhalt = new QToolButton(this, "t1");
  Inhalt->setPixmap(loadIcon("Text2.xpm"));
	Inhalt->setToggleButton(true);
	Inhalt->setAutoRaise(true);
	Inhalt->setBackgroundMode(PaletteBackground);
	Layout1->addWidget(Inhalt);
  Innen = new QToolButton(this, "t2");
  Innen->setPixmap(loadIcon("Rechtecke.xpm"));
  Innen->setToggleButton(true);
	Innen->setAutoRaise(true);
	Innen->setBackgroundMode(PaletteBackground);
  Innen->setOn(true);
	Layout1->addWidget(Innen);
	QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	Layout1->addItem( spacer );
  Mode = 2;
  ShaMenu = new QPopupMenu();
	ShaMenu->insertItem(tr("Other..."));
	ShaMenu->insertItem("0 %");
	ShaMenu->insertItem("10 %");
	ShaMenu->insertItem("20 %");
	ShaMenu->insertItem("30 %");
	ShaMenu->insertItem("40 %");
	ShaMenu->insertItem("50 %");
	ShaMenu->insertItem("60 %");
	ShaMenu->insertItem("70 %");
	ShaMenu->insertItem("80 %");
	ShaMenu->insertItem("90 %");
	ShaMenu->insertItem("100 %");
	PM1 = new QToolButton(this, "Colors");
	PM1->setBackgroundMode(PaletteBackground);
	PM1->setPopup(ShaMenu);
	PM1->setPopupDelay(1);
	PM1->setText("100 %");
	PM1->setAutoRaise(true);
	Layout1->addWidget(PM1);
	boxLayout()->addLayout(Layout1);
	ListBox1 = new QListBox(this, "ListBox1");
  ListBox1->setMinimumSize( QSize( 150, 210 ) );
  ListBox1->setMaximumSize( QSize( 150, 210 ) );
	boxLayout()->addWidget(ListBox1);
  connect(Inhalt, SIGNAL(clicked()), this, SLOT(InhaltButton()));
  connect(Innen, SIGNAL(clicked()), this, SLOT(InnenButton()));
  connect(ListBox1, SIGNAL(clicked(QListBoxItem*)), this, SLOT(selFarbe(QListBoxItem*)));
  connect(ShaMenu, SIGNAL(activated(int)), this, SLOT(setActShade(int)));
  connect(this, SIGNAL(visibilityChanged(bool)), this, SLOT(Verbergen(bool)));
  pa->moveDockWindow(this, DockTornOff);
  setCloseMode(Always);
}
Cpalette::~Cpalette(){
}

void Cpalette::Verbergen(bool vis)
{
	if (!vis)
		emit Schliessen();
	Sichtbar = vis;
}

void Cpalette::InhaltButton()
{
	if (Inhalt->isOn())
		{
		Mode = 1;
		Innen->setOn(false);
		}
	emit QueryItem();
}

void Cpalette::InnenButton()
{
	if (Innen->isOn())
		{
		Mode = 2;
		Inhalt->setOn(false);
		}
	emit QueryItem();
}

void Cpalette::SetColors(CListe farben)
{
	Farbliste.clear();
	Farbliste = farben;
	updateCList();
}	

void Cpalette::updateCList()
{
	ListBox1->clear();
	CListe::Iterator it;
	QPixmap pm = QPixmap(30, 15);
	ListBox1->insertItem(tr("None"));
	for (it = Farbliste.begin(); it != Farbliste.end(); ++it)
		{
		pm.fill(Farbliste[it.key()].getRGBColor());
		ListBox1->insertItem(pm, it.key());
		}
	ListBox1->setSelected(ListBox1->currentItem(), false);
}

void Cpalette::selFarbe(QListBoxItem *c)
{
    if (c == NULL) { return; }
    sFarbe = c->text();
    switch (Mode)
    	{
    	case 1:
    		emit NewPen(sFarbe);
    		break;
    	case 2:
    		emit NewBrush(sFarbe);
    		break;
    	}
}	

void Cpalette::updateBoxS(QString Farbe)
{
	CListe::Iterator it;
	int c = 0;
	if (Farbe != "None")
		{
		c++;
		for (it = Farbliste.begin(); it != Farbliste.end(); ++it)
			{
			if (it.key() == Farbe)
				break;
			c++;
			}
		}
	ListBox1->setCurrentItem(c);
}

void Cpalette::setActFarben(QString p, QString b, int shp, int shb)
{
	switch (Mode)
		{
		case 1:
			if ((shp % 10) == 0)
				{
				SetMen(shp/10+1);
				}
			else
				{
				SetMen(0);
				PM1->setText(QString::number(shp)+" %");
				}
			updateBoxS(p);
			break;
		case 2:
			if ((shb % 10) == 0)
				{
				SetMen(shb/10+1);
				}
			else
				{
				SetMen(0);
				PM1->setText(QString::number(shp)+" %");
				}
			updateBoxS(b);
			break;
		}
}

int Cpalette::SetMen(int c)
{
	int b = 0;
	uint a;
	for (a = 0; a < ShaMenu->count(); a++)
		{
		ShaMenu->setItemChecked(ShaMenu->idAt(a), false);
		}
	ShaMenu->setItemChecked(ShaMenu->idAt(c), true);
	if (c > 0)
		{
		b = (c-1) * 10;
		}
	PM1->setText(QString::number(b)+" %");
	return b;
}

void Cpalette::setActShade(int id)
{
	QString antw;
	bool ok = FALSE;
	int c = ShaMenu->indexOf(id);
	int b = SetMen(c);
	if (c == 0)
		{
    Query* dia = new Query(this, "New", 1, 0, "Shade:", "Shade");
    if (dia->exec())
    	{
			c = dia->Answer->text().toInt(&ok);
			if (ok)
				{
				b = c;
				PM1->setText(dia->Answer->text()+" %");
				}
			delete dia;
      }
     else
     	{
     	delete dia;
     	return;
     	}
		}
	switch (Mode)
		{
    	case 1:
    		emit NewPenShade(b);
    		break;
    	case 2:
    		emit NewBrushShade(b);
    		break;
		}
}
