#ifndef HYPLUG_H
#define HYPLUG_H

#include "scribus.h"


/** Calls the Plugin with the main Application window as parent
  * and the main Application Class as parameter */
extern "C" void Run(QWidget *d, ScribusApp *plug);

/** Returns the Name of the Plugin.
  * This name appears in the relevant Menue-Entrys */
extern "C" QString Name();

/** Returns the Type of the Plugin.
  * 1 = the Plugin is a normal Plugin, which appears in the Extras Menue
  * 2 = the Plugin is a Import Plugin, which appears in the Import Menue
  * 3 = the Plugin is a Export Plugin, which appears in the Export Menue
  * 4 = the Plugin is a resident Plugin   */
extern "C" int Type();

/** Initializes the Plugin if it's a Plugin of Type 4 */
extern "C" void InitPlug(QWidget *d, ScribusApp *plug);

/** Possible CleanUpOperations when closing the Plugin */
extern "C" void CleanUpPlug();

/** Some useful Subroutines */
void ReadPlugPrefs();
void SavePlugPrefs();

/** Global Pointer to the Scribus Application */
static ScribusApp* Carrier;
static QPopupMenu* hymen;

class MenuH : public QObject
{
    Q_OBJECT

public:
    MenuH(QWidget* parent);
    ~MenuH();
		int MinWordLen;
		QString Language;
		bool Automatic;
		QMap<QString,QString> Sprachen;

public slots:
		void slotConfig();
		void slotTest();
};

static MenuH* Tes;
#endif
