/***************************************************************************
                          hyphenplugin.cpp  -  description
                             -------------------
    begin                : Thu Oct 26 08:00:00 CEST 2002
    copyright            : (C) 2002 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "hyphenplugin.h"
#include "hyphenplugin.moc"
#include "hysettings.h"
#include "hyask.h"
#include "config.h"
#include "hyphen.h"
#include <qmessagebox.h>
#include <qregexp.h>
#include <qtextcodec.h>
#include <qcursor.h>
#include <qdom.h>
#include <qdir.h>
#include <stdlib.h>

QString Name()
{
  return QObject::tr("About Hyphenator...");
}

int Type()
{
	return 4;
}

void InitPlug(QWidget *d, ScribusApp *plug)
{
	Carrier = plug;
	Tes = new MenuH(d);
	hymen = new QPopupMenu();
	ReadPlugPrefs();
	hymen->insertItem(QObject::tr("Hyphenate Text"), Tes, SLOT(slotTest()));
	hymen->insertItem(QObject::tr("Settings..."), Tes, SLOT(slotConfig()));
	plug->menuBar()->insertItem(QObject::tr("Hyphenate"), hymen, -1, plug->menuBar()->count() - 2);
}

void CleanUpPlug()
{
	SavePlugPrefs();
}

void Run(QWidget *d, ScribusApp *plug)
{
	QString mess = QObject::tr("Hyphenator");
	mess += "\n\n" + QObject::tr("This Plugin does Hyphenation of");
	mess += "\n" + QObject::tr("selected Text Frames.");
	mess += "\n\n" + QObject::tr("It is based on libhnj by Raph Levin and the");
	mess += "\n" + QObject::tr("Modifications made by ALTLinux and OpenOffice.");
	mess += "\n\n" + QObject::tr("Programming:");
	mess += "\n\t" + QObject::tr("Franz Schmid <Franz.Schmid@altmuehlnet.de>");
	QMessageBox::about(d, QObject::tr("About Hyphenator"), mess);
}

void ReadPlugPrefs()
{
	QDomDocument docu("hyrc");
	QString ho = getenv("HOME");
	QFile f(ho+"/.scribushy.rc");
	if(!f.open(IO_ReadOnly))
		return;
	if(!docu.setContent(&f))
		{
		f.close();
		return;
		}
	f.close();
	QDomElement elem=docu.documentElement();
	if (elem.tagName() != "HYRC")
		return;
	QDomNode DOC=elem.firstChild();
	QDomElement dc=DOC.toElement();
	Tes->Language = dc.attribute("LANG");
	Tes->MinWordLen = dc.attribute("WORDLEN").toInt();
	Tes->Automatic = bool(dc.attribute("MODE").toInt());
}

void SavePlugPrefs()
{
	QDomDocument docu("hyrc");
	QString st="<HYRC></HYRC>";
	docu.setContent(st);
	QDomElement elem=docu.documentElement();
	QDomElement rde=docu.createElement("HYPHEN");
	rde.setAttribute("LANG", Tes->Language);
	rde.setAttribute("WORDLEN", Tes->MinWordLen);
	rde.setAttribute("MODE", int(Tes->Automatic));
	elem.appendChild(rde);
	QString ho = getenv("HOME");
	QFile f(ho+"/.scribushy.rc");
	if(!f.open(IO_WriteOnly))
		return;
	QTextStream s(&f);
	s<<docu.toCString();
	f.close();
}

MenuH::MenuH(QWidget* parent) : QObject( parent, "bu")
{
	MinWordLen = 3;
	Language = "";
	QString datein = "";
	Automatic = true;
	QString	lang = QString(QTextCodec::locale()).left(2);
	QString pfad = PREL;
	pfad += "/share/scribus/dicts/";
	QDir d(pfad, "*.dic", QDir::Name, QDir::Files | QDir::NoSymLinks);
	if ((d.exists()) && (d.count() != 0))
		{
		for (uint dc = 0; dc < d.count(); dc++)
			{
			if (d[dc] == "hyph_en.dic")
				datein = QObject::tr("English");
			if (d[dc] == "hyph_de.dic")
				datein = QObject::tr("German");
			if (d[dc] == "hyph_es.dic")
				datein = QObject::tr("Spanish");
			if (d[dc] == "hyph_it.dic")
				datein = QObject::tr("Italian");
			if (d[dc] == "hyph_fr.dic")
				datein = QObject::tr("French");
			Sprachen.insert(datein, d[dc]);
			if (d[dc] == "hyph_"+lang+".dic")
				Language = datein;
			}
		if (datein == "")
			Language = QObject::tr("English");
		}
}

MenuH::~MenuH()
{
}

void MenuH::slotConfig()
{
	HySettings *dia = new HySettings((QWidget*)parent(), &Sprachen);
	dia->Verbose->setChecked(Automatic);
	dia->Language->setCurrentText(Language);
	dia->WordLen->setValue(MinWordLen);
	if (dia->exec())
		{
		MinWordLen = dia->WordLen->value();
		Language = dia->Language->currentText();
		Automatic = dia->Verbose->isChecked();
		}
	delete dia;
}

void MenuH::slotTest()
{
	const char *word;
  char *buffer;
  const int BORDER = 2;
  char *filename = NULL;
	HyphenDict *hdict;
	QString text = "";
	QString buf;
	QCString te;
	PageItem *it;
	if (!Carrier->HaveDoc)
		return;
	if (Carrier->doc->ActPage->SelItem.count() == 0)
		return;
 	QString pfad = PREL;
	pfad += "/share/scribus/dicts/" + Sprachen[Language];
	QCString fn = pfad.latin1();
	filename = fn.data();
	if((hdict = hnj_hyphen_load(filename)) == NULL)
		return;
	it = Carrier->doc->ActPage->SelItem.at(0);
	if (it->PType != 4)
		return;
	if (it->Ptext.count() == 0)
		return;
	for (uint a = 0; a < it->Ptext.count(); a++)
		{
		if (it->HasSel)
			{
			if (it->Ptext.at(a)->cselect)
				text += it->Ptext.at(a)->ch;
			}
		else
			text += it->Ptext.at(a)->ch;
		}
	int firstC = 0;
	if (it->HasSel)
		{
		for (uint a = 0; a < it->Ptext.count(); a++)
			{
			if (it->Ptext.at(a)->cselect)
				{
				firstC = int(a);
				break;
				}
			}
		}
	int lastC = 0;
	int Ccount = 0;
	QString found = "";
	QString found2 = "";
  qApp->setOverrideCursor(QCursor(waitCursor), true);
	while ((firstC+Ccount < int(text.length())) && (firstC != -1) && (lastC < int(text.length())))
		{
		firstC = text.find(QRegExp("\\w"), firstC+Ccount);
		if (firstC < 0)
			break;
		lastC = text.find(QRegExp("\\s|\\W|\\d|\\n|\\r"), firstC);
		if (lastC < 0)
			lastC = int(text.length());
		Ccount = lastC - firstC;
		if (Ccount > MinWordLen)
			{
			found = text.mid(firstC, Ccount).lower();
			found2 = text.mid(firstC, Ccount);
			te = found.latin1();
			word = te.data();
			buffer = (char*) malloc(sizeof(char) * (strlen(word)+BORDER+3));
			if (buffer == NULL)
				break;
			if (!hnj_hyphen_hyphenate(hdict, word, strlen(word), buffer));
				{
	  		uint i = 0;
  			buffer[strlen(word)] = '\0';
				for (i = 1; i < strlen(word)-1; i++)
					{
					it->Ptext.at(i+firstC)->cstyle &= 127;		// Delete any old Hyphens
					}
				bool hasHyphen = false;
				for (i = 1; i < strlen(word)-1; i++)
					{
					if(buffer[i] & 1)
						{
						hasHyphen = true;
						break;
						}
					}
				if (hasHyphen)
					{
					if (!Automatic)
						{
						QString outs = "";
						outs += found2[0];
						for (i = 1; i < strlen(word)-1; i++)
							{
							outs += found2[i];
							if(buffer[i] & 1)
								outs += "-";
							}
						outs += found2.right(1);
						qApp->setOverrideCursor(QCursor(ArrowCursor), true);
						HyAsk *dia = new HyAsk((QWidget*)parent(), outs);
						if (dia->exec())
							{
							outs = dia->Wort->text();
							uint ii = 0;
							for (i = 1; i < outs.length()-1; i++)
								{
								QChar cht = outs[i];
								if (cht == "-")
									it->Ptext.at(ii+firstC)->cstyle ^= 128;	// Set new Hyphens according Buffer
								else
									ii++;
								}
							}
						else
							{
							free(buffer);
							delete dia;
							break;
							}
						delete dia;
  					qApp->setOverrideCursor(QCursor(waitCursor), true);
						}
					else
						{
						for (i = 1; i < strlen(word)-1; i++)
							{
							if(buffer[i] & 1)
								{
								it->Ptext.at(i+firstC)->cstyle ^= 128;	// Set new Hyphens according Buffer
								}
							}
	  				}
					}
				}
			free(buffer);
			buffer = NULL;
			}
		if (Ccount == 0)
			Ccount++;
		}
	hnj_hyphen_free(hdict);
	hdict = NULL;
	it->Dirty = true;
	qApp->setOverrideCursor(QCursor(ArrowCursor), true);
	Carrier->doc->ActPage->RefreshItem(it);
}
