#include <ruby.h>
#include <extractor.h>

EXTRACTOR_ExtractorList *rb_extractor_libraries;

/* Extracts from the filename parameter a hash of metadata. */
VALUE rb_extractor_extract(VALUE module, VALUE filename)
{
  EXTRACTOR_KeywordList *keywords, *k;
  VALUE new_value, old_value, hash_key, hash = rb_hash_new();
  
  
  keywords = EXTRACTOR_getKeywords(rb_extractor_libraries, STR2CSTR(filename));
  
  for(k = keywords; k; k = k->next) {
    hash_key = rb_str_new2(EXTRACTOR_getKeywordTypeAsString(k->keywordType));  
    old_value = rb_hash_aref(hash, hash_key);
    new_value = rb_str_new2(k->keyword);
    
    // if there is no value yet, then set it    
    if(TYPE(old_value) == T_NIL) { 
      rb_hash_aset(hash, hash_key, new_value);
    
    // if we have a string, then create an array with both values  
    } else if(TYPE(old_value) == T_STRING) { 
      rb_hash_aset(hash, hash_key,
        rb_ary_new3(2, old_value, new_value));
    
    // if we have an array already, add the new value    
    } else { 
      rb_ary_push(old_value, new_value);
    }  
  }
  
  EXTRACTOR_freeKeywords(keywords);
  
  return hash;
}

void Init_extractor ()
{
  VALUE mExtractor;
  rb_extractor_libraries = EXTRACTOR_loadDefaultLibraries();
  mExtractor = rb_define_module("Extractor");
  rb_define_module_function (mExtractor, "extract", rb_extractor_extract, 1);
}