/* -*- Mode: Java; c-basic-offset: 4; tab-width: 20; indent-tabs-mode: nil; -*-
 * ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Android code.
 *
 * The Initial Developer of the Original Code is Mozilla Foundation.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Sriram Ramasubramanian <sriram@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package org.mozilla.gecko;

import android.app.Activity;
import android.graphics.drawable.Drawable;
import android.view.View;

public class GeckoActionBar {

    public static View getCustomView(Activity activity) {
        return activity.getActionBar().getCustomView();
    }
 
    public static void hide(Activity activity) {
        activity.getActionBar().hide();
    }

    public static void setBackgroundDrawable(Activity activity, Drawable drawable) {
         activity.getActionBar().setBackgroundDrawable(drawable);
    }

    public static void setDisplayOptions(Activity activity, int options, int mask) {
         activity.getActionBar().setDisplayOptions(options, mask);
    }

    public static void setCustomView(Activity activity, View view) {
         activity.getActionBar().setCustomView(view);
    }

    public static void setDisplayHomeAsUpEnabled(Activity activity, boolean enabled) {
         activity.getActionBar().setDisplayHomeAsUpEnabled(enabled);
    } 
 
    public static void show(Activity activity) {
        activity.getActionBar().show();
    }
}
