/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pad;

import gnu.crypto.pad.BasePad;
import gnu.crypto.pad.WrongPaddingException;
import gnu.crypto.sig.rsa.EME_PKCS1_V1_5;
import gnu.crypto.util.PRNG;
import java.io.PrintWriter;

public class PKCS1_V1_5
extends BasePad {
    private static final String NAME = "eme-pkcs1-v1.5";
    private static final boolean DEBUG = false;
    private static final int debuglevel = 9;
    private static final PrintWriter err;
    private EME_PKCS1_V1_5 codec;

    private static void debug(String s) {
        err.println(">>> eme-pkcs1-v1.5: " + s);
    }

    PKCS1_V1_5() {
        super(NAME);
    }

    public void setup() {
        this.codec = EME_PKCS1_V1_5.getInstance(this.blockSize);
    }

    public byte[] pad(byte[] in, int offset, int length) {
        byte[] M = new byte[length];
        System.arraycopy(in, offset, M, 0, length);
        byte[] EM = this.codec.encode(M);
        byte[] result = new byte[this.blockSize - length];
        System.arraycopy(EM, 0, result, 0, result.length);
        return result;
    }

    public int unpad(byte[] in, int offset, int length) throws WrongPaddingException {
        byte[] EM = new byte[length];
        System.arraycopy(in, offset, EM, 0, length);
        int result = length - this.codec.decode(EM).length;
        return result;
    }

    public boolean selfTest() {
        int[] mLen = new int[]{16, 20, 32, 48, 64};
        byte[] M = new byte[mLen[mLen.length - 1]];
        PRNG.nextBytes(M);
        byte[] EM = new byte[1024];
        for (int bs = 256; bs < 1025; bs += 256) {
            this.init(bs);
            for (int i = 0; i < mLen.length; ++i) {
                int j = mLen[i];
                byte[] p = this.pad(M, 0, j);
                if (j + p.length != this.blockSize) {
                    new RuntimeException(this.name()).printStackTrace(System.err);
                    return false;
                }
                System.arraycopy(p, 0, EM, 0, p.length);
                System.arraycopy(M, 0, EM, p.length, j);
                try {
                    if (p.length == this.unpad(EM, 0, this.blockSize)) continue;
                    new RuntimeException(this.name()).printStackTrace(System.err);
                    return false;
                }
                catch (WrongPaddingException x) {
                    x.printStackTrace(System.err);
                    return false;
                }
            }
            this.reset();
        }
        return true;
    }

    static {
        NAME = NAME;
        err = new PrintWriter(System.out, true);
    }
}

