/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.mac;

import gnu.crypto.mac.HMacFactory;
import gnu.crypto.mac.IMac;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class TestOfHMac
implements Testlet {
    private static final Random prng = new Random(System.currentTimeMillis());
    private String mac;
    private IMac algorithm;
    private IMac clone;

    private static final byte[] makeKey(int length) {
        byte[] result = new byte[length];
        prng.nextBytes(result);
        return result;
    }

    public void test(TestHarness harness) {
        harness.checkPoint("TestOfHMac");
        HashMap<String, byte[]> attr = new HashMap<String, byte[]>();
        Iterator it = HMacFactory.getNames().iterator();
        while (it.hasNext()) {
            byte[] md2;
            byte[] md1;
            this.algorithm = null;
            this.mac = (String)it.next();
            try {
                this.algorithm = HMacFactory.getInstance((String)this.mac);
                harness.check(this.algorithm != null, "getInstance(" + String.valueOf(this.mac) + ")");
            }
            catch (InternalError x) {
                harness.debug(x);
                harness.fail("TestOfHMac.getInstance(" + String.valueOf(this.mac) + ") - " + String.valueOf(x));
            }
            attr.put("gnu.crypto.mac.key.material", TestOfHMac.makeKey(this.algorithm.macSize()));
            try {
                this.algorithm.init(attr);
                this.algorithm.update((byte)97);
                this.algorithm.update((byte)98);
                this.algorithm.update((byte)99);
                this.clone = (IMac)this.algorithm.clone();
                this.algorithm.update((byte)100);
                this.clone.update((byte)100);
                this.algorithm.update((byte)101);
                this.clone.update((byte)101);
                this.algorithm.update((byte)102);
                this.clone.update((byte)102);
                md1 = this.algorithm.digest();
                md2 = this.clone.digest();
                harness.check(Util.areEqual((byte[])md1, (byte[])md2), "clone(" + this.algorithm.name() + ")");
            }
            catch (Exception x) {
                harness.debug(x);
                harness.fail("TestOfHMac.clone(" + this.algorithm.name() + ") - " + String.valueOf(x));
            }
            try {
                this.algorithm.init(attr);
                this.algorithm.update((byte)97);
                this.algorithm.update((byte)98);
                this.algorithm.update((byte)99);
                md1 = this.algorithm.digest();
                this.algorithm.reset();
                this.algorithm.update((byte)97);
                this.algorithm.update((byte)98);
                this.algorithm.update((byte)99);
                md2 = this.algorithm.digest();
                harness.check(Util.areEqual((byte[])md1, (byte[])md2), "reset(" + this.algorithm.name() + ")");
            }
            catch (Exception x) {
                harness.debug(x);
                harness.fail("TestOfHMac.reset(" + this.algorithm.name() + ") - " + String.valueOf(x));
            }
        }
    }
}

