/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import rdr.JavaInStream;
import rdr.JavaOutStream;
import rfb.CConnection;
import rfb.CSecurity;
import rfb.LogWriter;

public class CSecurityTls
extends CSecurity {
    Socket sock;
    static LogWriter tlog = new LogWriter("TLS");

    public CSecurityTls(Socket socket) {
        this.sock = socket;
    }

    public int processMsg(CConnection cConnection) {
        try {
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.sock, this.sock.getInetAddress().getHostName(), this.sock.getPort(), true);
            CSecurityTls.setAnonDHKeyExchangeEnabled(sSLSocket);
            sSLSocket.startHandshake();
            tlog.debug("Completed handshake with server " + sSLSocket.toString());
            cConnection.setStreams(new JavaInStream(sSLSocket.getInputStream()), new JavaOutStream(sSLSocket.getOutputStream()));
            return 3;
        }
        catch (IOException iOException) {
            tlog.error("TLS handshake failed " + iOException.toString());
            return 0;
        }
    }

    private static void setAnonDHKeyExchangeEnabled(SSLSocket sSLSocket) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = sSLSocket.getSupportedCipherSuites();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].matches(".*DH_anon.*")) continue;
            arrayList.add(stringArray[i]);
        }
        sSLSocket.setEnabledCipherSuites(arrayList.toArray(new String[0]));
    }

    public String getDescription() {
        return "TLS Encryption";
    }
}

