/* valanamespace.c generated by valac, the Vala compiler
 * generated from valanamespace.vala, do not modify */

/* valanamespace.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaNamespacePrivate {
	ValaList* classes;
	ValaList* interfaces;
	ValaList* structs;
	ValaList* enums;
	ValaList* error_domains;
	ValaList* delegates;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* comments;
	ValaList* namespaces;
	ValaList* using_directives;
};

static gint ValaNamespace_private_offset;
static gpointer vala_namespace_parent_class = NULL;

static void vala_namespace_real_add_namespace (ValaSymbol* base,
                                        ValaNamespace* ns);
static void vala_namespace_real_add_class (ValaSymbol* base,
                                    ValaClass* cl);
static void vala_namespace_real_add_interface (ValaSymbol* base,
                                        ValaInterface* iface);
static void vala_namespace_real_add_struct (ValaSymbol* base,
                                     ValaStruct* st);
static void vala_namespace_real_add_enum (ValaSymbol* base,
                                   ValaEnum* en);
static void vala_namespace_real_add_error_domain (ValaSymbol* base,
                                           ValaErrorDomain* edomain);
static void vala_namespace_real_add_delegate (ValaSymbol* base,
                                       ValaDelegate* d);
static void vala_namespace_real_add_constant (ValaSymbol* base,
                                       ValaConstant* constant);
static void vala_namespace_real_add_field (ValaSymbol* base,
                                    ValaField* f);
static void vala_namespace_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static void vala_namespace_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_namespace_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_namespace_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static gchar* vala_namespace_real_to_string (ValaCodeNode* base);
static void vala_namespace_finalize (ValaCodeNode * obj);
static GType vala_namespace_get_type_once (void);

static inline gpointer
vala_namespace_get_instance_private (ValaNamespace* self)
{
	return G_STRUCT_MEMBER_P (self, ValaNamespace_private_offset);
}

/**
 * Creates a new namespace.
 *
 * @param name             namespace name
 * @param source_reference reference to source code
 * @return                 newly created namespace
 */
ValaNamespace*
vala_namespace_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference)
{
	ValaNamespace* self = NULL;
	self = (ValaNamespace*) vala_symbol_construct (object_type, name, source_reference, NULL);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}

ValaNamespace*
vala_namespace_new (const gchar* name,
                    ValaSourceReference* source_reference)
{
	return vala_namespace_construct (VALA_TYPE_NAMESPACE, name, source_reference);
}

/**
 * Adds a new using directive with the specified namespace.
 *
 * @param ns reference to namespace
 */
void
vala_namespace_add_using_directive (ValaNamespace* self,
                                    ValaUsingDirective* ns)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = self->priv->using_directives;
	vala_collection_add ((ValaCollection*) _tmp0_, ns);
}

void
vala_namespace_add_comment (ValaNamespace* self,
                            ValaComment* comment)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	_tmp0_ = self->priv->comments;
	vala_collection_add ((ValaCollection*) _tmp0_, comment);
}

/**
 * Returns the list of namespaces.
 *
 * @return comment list
 */
ValaList*
vala_namespace_get_comments (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->comments;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified namespace to this source file.
 *
 * @param ns a namespace
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_namespace_real_add_namespace (ValaSymbol* base,
                                   ValaNamespace* ns)
{
	ValaNamespace * self;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp6_;
	ValaScope* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	gboolean _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = vala_symbol_get_owner ((ValaSymbol*) ns);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaSourceFile* _tmp4_;
		ValaSourceFile* _tmp5_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_source_reference_get_file (_tmp3_);
		_tmp5_ = _tmp4_;
		vala_source_file_add_node (_tmp5_, (ValaCodeNode*) ns);
	}
	_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_symbol_get_name ((ValaSymbol*) ns);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_scope_lookup (_tmp7_, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = VALA_IS_NAMESPACE (_tmp11_);
	_vala_code_node_unref0 (_tmp11_);
	if (_tmp12_) {
		ValaNamespace* old_ns = NULL;
		ValaScope* _tmp13_;
		ValaScope* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		ValaSymbol* _tmp17_;
		gboolean _tmp18_ = FALSE;
		ValaNamespace* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		GList* _tmp159_;
		_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_symbol_get_name ((ValaSymbol*) ns);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_scope_lookup (_tmp14_, _tmp16_);
		old_ns = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_NAMESPACE, ValaNamespace);
		_tmp19_ = old_ns;
		_tmp20_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp19_);
		_tmp21_ = _tmp20_;
		if (_tmp21_) {
			gboolean _tmp22_;
			gboolean _tmp23_;
			_tmp22_ = vala_symbol_get_external_package ((ValaSymbol*) ns);
			_tmp23_ = _tmp22_;
			_tmp18_ = !_tmp23_;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			ValaNamespace* _tmp24_;
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			_tmp24_ = old_ns;
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
			_tmp26_ = _tmp25_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp24_, _tmp26_);
		}
		{
			ValaList* _using_directive_list = NULL;
			ValaList* _tmp27_;
			ValaList* _tmp28_;
			gint _using_directive_size = 0;
			ValaList* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gint _using_directive_index = 0;
			_tmp27_ = ns->priv->using_directives;
			_tmp28_ = _vala_iterable_ref0 (_tmp27_);
			_using_directive_list = _tmp28_;
			_tmp29_ = _using_directive_list;
			_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
			_tmp31_ = _tmp30_;
			_using_directive_size = _tmp31_;
			_using_directive_index = -1;
			while (TRUE) {
				gint _tmp32_;
				gint _tmp33_;
				ValaUsingDirective* using_directive = NULL;
				ValaList* _tmp34_;
				gpointer _tmp35_;
				ValaNamespace* _tmp36_;
				ValaUsingDirective* _tmp37_;
				_using_directive_index = _using_directive_index + 1;
				_tmp32_ = _using_directive_index;
				_tmp33_ = _using_directive_size;
				if (!(_tmp32_ < _tmp33_)) {
					break;
				}
				_tmp34_ = _using_directive_list;
				_tmp35_ = vala_list_get (_tmp34_, _using_directive_index);
				using_directive = (ValaUsingDirective*) _tmp35_;
				_tmp36_ = old_ns;
				_tmp37_ = using_directive;
				vala_namespace_add_using_directive (_tmp36_, _tmp37_);
				_vala_code_node_unref0 (using_directive);
			}
			_vala_iterable_unref0 (_using_directive_list);
		}
		{
			ValaList* _sub_ns_list = NULL;
			ValaList* _tmp38_;
			ValaList* _tmp39_;
			gint _sub_ns_size = 0;
			ValaList* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _sub_ns_index = 0;
			_tmp38_ = vala_namespace_get_namespaces (ns);
			_tmp39_ = _vala_iterable_ref0 (_tmp38_);
			_sub_ns_list = _tmp39_;
			_tmp40_ = _sub_ns_list;
			_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
			_tmp42_ = _tmp41_;
			_sub_ns_size = _tmp42_;
			_sub_ns_index = -1;
			while (TRUE) {
				gint _tmp43_;
				gint _tmp44_;
				ValaNamespace* sub_ns = NULL;
				ValaList* _tmp45_;
				gpointer _tmp46_;
				ValaNamespace* _tmp47_;
				ValaNamespace* _tmp48_;
				_sub_ns_index = _sub_ns_index + 1;
				_tmp43_ = _sub_ns_index;
				_tmp44_ = _sub_ns_size;
				if (!(_tmp43_ < _tmp44_)) {
					break;
				}
				_tmp45_ = _sub_ns_list;
				_tmp46_ = vala_list_get (_tmp45_, _sub_ns_index);
				sub_ns = (ValaNamespace*) _tmp46_;
				_tmp47_ = old_ns;
				_tmp48_ = sub_ns;
				vala_symbol_add_namespace ((ValaSymbol*) _tmp47_, _tmp48_);
				_vala_code_node_unref0 (sub_ns);
			}
			_vala_iterable_unref0 (_sub_ns_list);
		}
		{
			ValaList* _cl_list = NULL;
			ValaList* _tmp49_;
			ValaList* _tmp50_;
			gint _cl_size = 0;
			ValaList* _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			gint _cl_index = 0;
			_tmp49_ = vala_namespace_get_classes (ns);
			_tmp50_ = _vala_iterable_ref0 (_tmp49_);
			_cl_list = _tmp50_;
			_tmp51_ = _cl_list;
			_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
			_tmp53_ = _tmp52_;
			_cl_size = _tmp53_;
			_cl_index = -1;
			while (TRUE) {
				gint _tmp54_;
				gint _tmp55_;
				ValaClass* cl = NULL;
				ValaList* _tmp56_;
				gpointer _tmp57_;
				ValaNamespace* _tmp58_;
				ValaClass* _tmp59_;
				_cl_index = _cl_index + 1;
				_tmp54_ = _cl_index;
				_tmp55_ = _cl_size;
				if (!(_tmp54_ < _tmp55_)) {
					break;
				}
				_tmp56_ = _cl_list;
				_tmp57_ = vala_list_get (_tmp56_, _cl_index);
				cl = (ValaClass*) _tmp57_;
				_tmp58_ = old_ns;
				_tmp59_ = cl;
				vala_symbol_add_class ((ValaSymbol*) _tmp58_, _tmp59_);
				_vala_code_node_unref0 (cl);
			}
			_vala_iterable_unref0 (_cl_list);
		}
		{
			ValaList* _st_list = NULL;
			ValaList* _tmp60_;
			ValaList* _tmp61_;
			gint _st_size = 0;
			ValaList* _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			gint _st_index = 0;
			_tmp60_ = vala_namespace_get_structs (ns);
			_tmp61_ = _vala_iterable_ref0 (_tmp60_);
			_st_list = _tmp61_;
			_tmp62_ = _st_list;
			_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
			_tmp64_ = _tmp63_;
			_st_size = _tmp64_;
			_st_index = -1;
			while (TRUE) {
				gint _tmp65_;
				gint _tmp66_;
				ValaStruct* st = NULL;
				ValaList* _tmp67_;
				gpointer _tmp68_;
				ValaNamespace* _tmp69_;
				ValaStruct* _tmp70_;
				_st_index = _st_index + 1;
				_tmp65_ = _st_index;
				_tmp66_ = _st_size;
				if (!(_tmp65_ < _tmp66_)) {
					break;
				}
				_tmp67_ = _st_list;
				_tmp68_ = vala_list_get (_tmp67_, _st_index);
				st = (ValaStruct*) _tmp68_;
				_tmp69_ = old_ns;
				_tmp70_ = st;
				vala_symbol_add_struct ((ValaSymbol*) _tmp69_, _tmp70_);
				_vala_code_node_unref0 (st);
			}
			_vala_iterable_unref0 (_st_list);
		}
		{
			ValaList* _iface_list = NULL;
			ValaList* _tmp71_;
			ValaList* _tmp72_;
			gint _iface_size = 0;
			ValaList* _tmp73_;
			gint _tmp74_;
			gint _tmp75_;
			gint _iface_index = 0;
			_tmp71_ = vala_namespace_get_interfaces (ns);
			_tmp72_ = _vala_iterable_ref0 (_tmp71_);
			_iface_list = _tmp72_;
			_tmp73_ = _iface_list;
			_tmp74_ = vala_collection_get_size ((ValaCollection*) _tmp73_);
			_tmp75_ = _tmp74_;
			_iface_size = _tmp75_;
			_iface_index = -1;
			while (TRUE) {
				gint _tmp76_;
				gint _tmp77_;
				ValaInterface* iface = NULL;
				ValaList* _tmp78_;
				gpointer _tmp79_;
				ValaNamespace* _tmp80_;
				ValaInterface* _tmp81_;
				_iface_index = _iface_index + 1;
				_tmp76_ = _iface_index;
				_tmp77_ = _iface_size;
				if (!(_tmp76_ < _tmp77_)) {
					break;
				}
				_tmp78_ = _iface_list;
				_tmp79_ = vala_list_get (_tmp78_, _iface_index);
				iface = (ValaInterface*) _tmp79_;
				_tmp80_ = old_ns;
				_tmp81_ = iface;
				vala_symbol_add_interface ((ValaSymbol*) _tmp80_, _tmp81_);
				_vala_code_node_unref0 (iface);
			}
			_vala_iterable_unref0 (_iface_list);
		}
		{
			ValaList* _d_list = NULL;
			ValaList* _tmp82_;
			ValaList* _tmp83_;
			gint _d_size = 0;
			ValaList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _d_index = 0;
			_tmp82_ = vala_namespace_get_delegates (ns);
			_tmp83_ = _vala_iterable_ref0 (_tmp82_);
			_d_list = _tmp83_;
			_tmp84_ = _d_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_d_size = _tmp86_;
			_d_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				ValaDelegate* d = NULL;
				ValaList* _tmp89_;
				gpointer _tmp90_;
				ValaNamespace* _tmp91_;
				ValaDelegate* _tmp92_;
				_d_index = _d_index + 1;
				_tmp87_ = _d_index;
				_tmp88_ = _d_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _d_list;
				_tmp90_ = vala_list_get (_tmp89_, _d_index);
				d = (ValaDelegate*) _tmp90_;
				_tmp91_ = old_ns;
				_tmp92_ = d;
				vala_symbol_add_delegate ((ValaSymbol*) _tmp91_, _tmp92_);
				_vala_code_node_unref0 (d);
			}
			_vala_iterable_unref0 (_d_list);
		}
		{
			ValaList* _en_list = NULL;
			ValaList* _tmp93_;
			ValaList* _tmp94_;
			gint _en_size = 0;
			ValaList* _tmp95_;
			gint _tmp96_;
			gint _tmp97_;
			gint _en_index = 0;
			_tmp93_ = vala_namespace_get_enums (ns);
			_tmp94_ = _vala_iterable_ref0 (_tmp93_);
			_en_list = _tmp94_;
			_tmp95_ = _en_list;
			_tmp96_ = vala_collection_get_size ((ValaCollection*) _tmp95_);
			_tmp97_ = _tmp96_;
			_en_size = _tmp97_;
			_en_index = -1;
			while (TRUE) {
				gint _tmp98_;
				gint _tmp99_;
				ValaEnum* en = NULL;
				ValaList* _tmp100_;
				gpointer _tmp101_;
				ValaNamespace* _tmp102_;
				ValaEnum* _tmp103_;
				_en_index = _en_index + 1;
				_tmp98_ = _en_index;
				_tmp99_ = _en_size;
				if (!(_tmp98_ < _tmp99_)) {
					break;
				}
				_tmp100_ = _en_list;
				_tmp101_ = vala_list_get (_tmp100_, _en_index);
				en = (ValaEnum*) _tmp101_;
				_tmp102_ = old_ns;
				_tmp103_ = en;
				vala_symbol_add_enum ((ValaSymbol*) _tmp102_, _tmp103_);
				_vala_code_node_unref0 (en);
			}
			_vala_iterable_unref0 (_en_list);
		}
		{
			ValaList* _ed_list = NULL;
			ValaList* _tmp104_;
			ValaList* _tmp105_;
			gint _ed_size = 0;
			ValaList* _tmp106_;
			gint _tmp107_;
			gint _tmp108_;
			gint _ed_index = 0;
			_tmp104_ = vala_namespace_get_error_domains (ns);
			_tmp105_ = _vala_iterable_ref0 (_tmp104_);
			_ed_list = _tmp105_;
			_tmp106_ = _ed_list;
			_tmp107_ = vala_collection_get_size ((ValaCollection*) _tmp106_);
			_tmp108_ = _tmp107_;
			_ed_size = _tmp108_;
			_ed_index = -1;
			while (TRUE) {
				gint _tmp109_;
				gint _tmp110_;
				ValaErrorDomain* ed = NULL;
				ValaList* _tmp111_;
				gpointer _tmp112_;
				ValaNamespace* _tmp113_;
				ValaErrorDomain* _tmp114_;
				_ed_index = _ed_index + 1;
				_tmp109_ = _ed_index;
				_tmp110_ = _ed_size;
				if (!(_tmp109_ < _tmp110_)) {
					break;
				}
				_tmp111_ = _ed_list;
				_tmp112_ = vala_list_get (_tmp111_, _ed_index);
				ed = (ValaErrorDomain*) _tmp112_;
				_tmp113_ = old_ns;
				_tmp114_ = ed;
				vala_symbol_add_error_domain ((ValaSymbol*) _tmp113_, _tmp114_);
				_vala_code_node_unref0 (ed);
			}
			_vala_iterable_unref0 (_ed_list);
		}
		{
			ValaList* _c_list = NULL;
			ValaList* _tmp115_;
			ValaList* _tmp116_;
			gint _c_size = 0;
			ValaList* _tmp117_;
			gint _tmp118_;
			gint _tmp119_;
			gint _c_index = 0;
			_tmp115_ = vala_namespace_get_constants (ns);
			_tmp116_ = _vala_iterable_ref0 (_tmp115_);
			_c_list = _tmp116_;
			_tmp117_ = _c_list;
			_tmp118_ = vala_collection_get_size ((ValaCollection*) _tmp117_);
			_tmp119_ = _tmp118_;
			_c_size = _tmp119_;
			_c_index = -1;
			while (TRUE) {
				gint _tmp120_;
				gint _tmp121_;
				ValaConstant* c = NULL;
				ValaList* _tmp122_;
				gpointer _tmp123_;
				ValaNamespace* _tmp124_;
				ValaConstant* _tmp125_;
				_c_index = _c_index + 1;
				_tmp120_ = _c_index;
				_tmp121_ = _c_size;
				if (!(_tmp120_ < _tmp121_)) {
					break;
				}
				_tmp122_ = _c_list;
				_tmp123_ = vala_list_get (_tmp122_, _c_index);
				c = (ValaConstant*) _tmp123_;
				_tmp124_ = old_ns;
				_tmp125_ = c;
				vala_symbol_add_constant ((ValaSymbol*) _tmp124_, _tmp125_);
				_vala_code_node_unref0 (c);
			}
			_vala_iterable_unref0 (_c_list);
		}
		{
			ValaList* _f_list = NULL;
			ValaList* _tmp126_;
			ValaList* _tmp127_;
			gint _f_size = 0;
			ValaList* _tmp128_;
			gint _tmp129_;
			gint _tmp130_;
			gint _f_index = 0;
			_tmp126_ = vala_namespace_get_fields (ns);
			_tmp127_ = _vala_iterable_ref0 (_tmp126_);
			_f_list = _tmp127_;
			_tmp128_ = _f_list;
			_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
			_tmp130_ = _tmp129_;
			_f_size = _tmp130_;
			_f_index = -1;
			while (TRUE) {
				gint _tmp131_;
				gint _tmp132_;
				ValaField* f = NULL;
				ValaList* _tmp133_;
				gpointer _tmp134_;
				ValaNamespace* _tmp135_;
				ValaField* _tmp136_;
				_f_index = _f_index + 1;
				_tmp131_ = _f_index;
				_tmp132_ = _f_size;
				if (!(_tmp131_ < _tmp132_)) {
					break;
				}
				_tmp133_ = _f_list;
				_tmp134_ = vala_list_get (_tmp133_, _f_index);
				f = (ValaField*) _tmp134_;
				_tmp135_ = old_ns;
				_tmp136_ = f;
				vala_symbol_add_field ((ValaSymbol*) _tmp135_, _tmp136_);
				_vala_code_node_unref0 (f);
			}
			_vala_iterable_unref0 (_f_list);
		}
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp137_;
			ValaList* _tmp138_;
			gint _m_size = 0;
			ValaList* _tmp139_;
			gint _tmp140_;
			gint _tmp141_;
			gint _m_index = 0;
			_tmp137_ = vala_namespace_get_methods (ns);
			_tmp138_ = _vala_iterable_ref0 (_tmp137_);
			_m_list = _tmp138_;
			_tmp139_ = _m_list;
			_tmp140_ = vala_collection_get_size ((ValaCollection*) _tmp139_);
			_tmp141_ = _tmp140_;
			_m_size = _tmp141_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp142_;
				gint _tmp143_;
				ValaMethod* m = NULL;
				ValaList* _tmp144_;
				gpointer _tmp145_;
				ValaNamespace* _tmp146_;
				ValaMethod* _tmp147_;
				_m_index = _m_index + 1;
				_tmp142_ = _m_index;
				_tmp143_ = _m_size;
				if (!(_tmp142_ < _tmp143_)) {
					break;
				}
				_tmp144_ = _m_list;
				_tmp145_ = vala_list_get (_tmp144_, _m_index);
				m = (ValaMethod*) _tmp145_;
				_tmp146_ = old_ns;
				_tmp147_ = m;
				vala_symbol_add_method ((ValaSymbol*) _tmp146_, _tmp147_);
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _c_list = NULL;
			ValaList* _tmp148_;
			ValaList* _tmp149_;
			gint _c_size = 0;
			ValaList* _tmp150_;
			gint _tmp151_;
			gint _tmp152_;
			gint _c_index = 0;
			_tmp148_ = vala_namespace_get_comments (ns);
			_tmp149_ = _vala_iterable_ref0 (_tmp148_);
			_c_list = _tmp149_;
			_tmp150_ = _c_list;
			_tmp151_ = vala_collection_get_size ((ValaCollection*) _tmp150_);
			_tmp152_ = _tmp151_;
			_c_size = _tmp152_;
			_c_index = -1;
			while (TRUE) {
				gint _tmp153_;
				gint _tmp154_;
				ValaComment* c = NULL;
				ValaList* _tmp155_;
				gpointer _tmp156_;
				ValaNamespace* _tmp157_;
				ValaComment* _tmp158_;
				_c_index = _c_index + 1;
				_tmp153_ = _c_index;
				_tmp154_ = _c_size;
				if (!(_tmp153_ < _tmp154_)) {
					break;
				}
				_tmp155_ = _c_list;
				_tmp156_ = vala_list_get (_tmp155_, _c_index);
				c = (ValaComment*) _tmp156_;
				_tmp157_ = old_ns;
				_tmp158_ = c;
				vala_namespace_add_comment (_tmp157_, _tmp158_);
				_vala_comment_unref0 (c);
			}
			_vala_iterable_unref0 (_c_list);
		}
		_tmp159_ = ((ValaCodeNode*) ns)->attributes;
		{
			GList* a_collection = NULL;
			GList* a_it = NULL;
			a_collection = _tmp159_;
			for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
				ValaAttribute* _tmp160_;
				ValaAttribute* a = NULL;
				_tmp160_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
				a = _tmp160_;
				{
					ValaNamespace* _tmp161_;
					ValaAttribute* _tmp162_;
					const gchar* _tmp163_;
					const gchar* _tmp164_;
					ValaAttribute* _tmp165_;
					_tmp161_ = old_ns;
					_tmp162_ = a;
					_tmp163_ = vala_attribute_get_name (_tmp162_);
					_tmp164_ = _tmp163_;
					_tmp165_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp161_, _tmp164_);
					if (_tmp165_ == NULL) {
						ValaNamespace* _tmp166_;
						ValaAttribute* _tmp167_;
						ValaAttribute* _tmp168_;
						_tmp166_ = old_ns;
						_tmp167_ = a;
						_tmp168_ = _vala_code_node_ref0 (_tmp167_);
						((ValaCodeNode*) _tmp166_)->attributes = g_list_append (((ValaCodeNode*) _tmp166_)->attributes, _tmp168_);
					}
					_vala_code_node_unref0 (a);
				}
			}
		}
		_vala_code_node_unref0 (old_ns);
	} else {
		ValaList* _tmp169_;
		ValaScope* _tmp170_;
		ValaScope* _tmp171_;
		const gchar* _tmp172_;
		const gchar* _tmp173_;
		_tmp169_ = self->priv->namespaces;
		vala_collection_add ((ValaCollection*) _tmp169_, ns);
		_tmp170_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp171_ = _tmp170_;
		_tmp172_ = vala_symbol_get_name ((ValaSymbol*) ns);
		_tmp173_ = _tmp172_;
		vala_scope_add (_tmp171_, _tmp173_, (ValaSymbol*) ns);
	}
}

/**
 * Returns the list of namespaces.
 *
 * @return namespace list
 */
ValaList*
vala_namespace_get_namespaces (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->namespaces;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified class to this namespace.
 *
 * @param cl a class
 */
static void
vala_namespace_real_add_class (ValaSymbol* base,
                               ValaClass* cl)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) cl);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) cl);
	}
	_tmp8_ = self->priv->classes;
	vala_collection_add ((ValaCollection*) _tmp8_, cl);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) cl);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) cl);
}

/**
 * Adds the specified interface to this namespace.
 *
 * @param iface an interface
 */
static void
vala_namespace_real_add_interface (ValaSymbol* base,
                                   ValaInterface* iface)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) iface);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) iface, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) iface);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) iface);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) iface);
	}
	_tmp8_ = self->priv->interfaces;
	vala_collection_add ((ValaCollection*) _tmp8_, iface);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) iface);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) iface);
}

/**
 * Adds the specified struct to this namespace.
 *
 * @param st a struct
 */
static void
vala_namespace_real_add_struct (ValaSymbol* base,
                                ValaStruct* st)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) st);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) st);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) st);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) st);
	}
	_tmp8_ = self->priv->structs;
	vala_collection_add ((ValaCollection*) _tmp8_, st);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) st);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) st);
}

/**
 * Adds the specified enum to this namespace.
 *
 * @param en an enum
 */
static void
vala_namespace_real_add_enum (ValaSymbol* base,
                              ValaEnum* en)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) en);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) en, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) en);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) en);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) en);
	}
	_tmp8_ = self->priv->enums;
	vala_collection_add ((ValaCollection*) _tmp8_, en);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) en);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) en);
}

/**
 * Adds the specified error domain to this namespace.
 *
 * @param edomain an error domain
 */
static void
vala_namespace_real_add_error_domain (ValaSymbol* base,
                                      ValaErrorDomain* edomain)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) edomain);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) edomain, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) edomain);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) edomain);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) edomain);
	}
	_tmp8_ = self->priv->error_domains;
	vala_collection_add ((ValaCollection*) _tmp8_, edomain);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) edomain);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) edomain);
}

/**
 * Adds the specified delegate to this namespace.
 *
 * @param d a delegate
 */
static void
vala_namespace_real_add_delegate (ValaSymbol* base,
                                  ValaDelegate* d)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) d);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) d, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) d);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) d);
	}
	_tmp8_ = self->priv->delegates;
	vala_collection_add ((ValaCollection*) _tmp8_, d);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) d);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) d);
}

/**
 * Returns the list of structs.
 *
 * @return struct list
 */
ValaList*
vala_namespace_get_structs (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->structs;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of classes.
 *
 * @return class list
 */
ValaList*
vala_namespace_get_classes (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->classes;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of interfaces.
 *
 * @return interface list
 */
ValaList*
vala_namespace_get_interfaces (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->interfaces;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of enums.
 *
 * @return enum list
 */
ValaList*
vala_namespace_get_enums (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->enums;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of error domains.
 *
 * @return error domain list
 */
ValaList*
vala_namespace_get_error_domains (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->error_domains;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of fields.
 *
 * @return field list
 */
ValaList*
vala_namespace_get_fields (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->fields;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of constants.
 *
 * @return constant list
 */
ValaList*
vala_namespace_get_constants (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of delegates.
 *
 * @return delegate list
 */
ValaList*
vala_namespace_get_delegates (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->delegates;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of methods.
 *
 * @return method list
 */
ValaList*
vala_namespace_get_methods (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->methods;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified constant to this namespace.
 *
 * @param constant a constant
 */
static void
vala_namespace_real_add_constant (ValaSymbol* base,
                                  ValaConstant* constant)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (constant != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) constant);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) constant, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) constant);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) constant);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) constant);
	}
	_tmp8_ = self->priv->constants;
	vala_collection_add ((ValaCollection*) _tmp8_, constant);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) constant);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) constant);
}

/**
 * Adds the specified field to this namespace.
 *
 * @param f a field
 */
static void
vala_namespace_real_add_field (ValaSymbol* base,
                               ValaField* f)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) f, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) f);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) f);
	}
	_tmp8_ = self->priv->fields;
	vala_collection_add ((ValaCollection*) _tmp8_, f);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) f);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) f);
}

/**
 * Adds the specified method to this namespace.
 *
 * @param m a method
 */
static void
vala_namespace_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaDataType* _tmp3_;
	ValaDataType* _tmp4_;
	ValaScope* _tmp18_;
	ValaScope* _tmp19_;
	ValaList* _tmp24_;
	ValaScope* _tmp25_;
	ValaScope* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	self = (ValaNamespace*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp3_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp4_ = _tmp3_;
	if (!VALA_IS_VOID_TYPE (_tmp4_)) {
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = vala_method_get_postconditions (m);
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaLocalVariable* _tmp14_;
		ValaLocalVariable* _tmp15_;
		ValaLocalVariable* _tmp16_;
		ValaLocalVariable* _tmp17_;
		_tmp8_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_data_type_copy (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_local_variable_new (_tmp11_, "result", NULL, _tmp13_);
		_tmp15_ = _tmp14_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp15_);
		_vala_code_node_unref0 (_tmp15_);
		_vala_code_node_unref0 (_tmp11_);
		_tmp16_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp17_ = _tmp16_;
		vala_local_variable_set_is_result (_tmp17_, TRUE);
	}
	_tmp18_ = vala_symbol_get_owner ((ValaSymbol*) m);
	_tmp19_ = _tmp18_;
	if (_tmp19_ == NULL) {
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceFile* _tmp22_;
		ValaSourceFile* _tmp23_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_source_reference_get_file (_tmp21_);
		_tmp23_ = _tmp22_;
		vala_source_file_add_node (_tmp23_, (ValaCodeNode*) m);
	}
	_tmp24_ = self->priv->methods;
	vala_collection_add ((ValaCollection*) _tmp24_, m);
	_tmp25_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_symbol_get_name ((ValaSymbol*) m);
	_tmp28_ = _tmp27_;
	vala_scope_add (_tmp26_, _tmp28_, (ValaSymbol*) m);
}

static void
vala_namespace_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_namespace (visitor, self);
}

static void
vala_namespace_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _ns_ref_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _ns_ref_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _ns_ref_index = 0;
		_tmp0_ = self->priv->using_directives;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_ns_ref_list = _tmp1_;
		_tmp2_ = _ns_ref_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_ns_ref_size = _tmp4_;
		_ns_ref_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaUsingDirective* ns_ref = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaUsingDirective* _tmp9_;
			_ns_ref_index = _ns_ref_index + 1;
			_tmp5_ = _ns_ref_index;
			_tmp6_ = _ns_ref_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _ns_ref_list;
			_tmp8_ = vala_list_get (_tmp7_, _ns_ref_index);
			ns_ref = (ValaUsingDirective*) _tmp8_;
			_tmp9_ = ns_ref;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (ns_ref);
		}
		_vala_iterable_unref0 (_ns_ref_list);
	}
	{
		ValaList* _ns_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _ns_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _ns_index = 0;
		_tmp10_ = self->priv->namespaces;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_ns_list = _tmp11_;
		_tmp12_ = _ns_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_ns_size = _tmp14_;
		_ns_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaNamespace* ns = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaNamespace* _tmp19_;
			_ns_index = _ns_index + 1;
			_tmp15_ = _ns_index;
			_tmp16_ = _ns_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _ns_list;
			_tmp18_ = vala_list_get (_tmp17_, _ns_index);
			ns = (ValaNamespace*) _tmp18_;
			_tmp19_ = ns;
			vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterable_unref0 (_ns_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _en_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _en_index = 0;
		_tmp20_ = self->priv->enums;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_en_list = _tmp21_;
		_tmp22_ = _en_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_en_size = _tmp24_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			ValaEnum* en = NULL;
			ValaList* _tmp27_;
			gpointer _tmp28_;
			ValaEnum* _tmp29_;
			_en_index = _en_index + 1;
			_tmp25_ = _en_index;
			_tmp26_ = _en_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _en_list;
			_tmp28_ = vala_list_get (_tmp27_, _en_index);
			en = (ValaEnum*) _tmp28_;
			_tmp29_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp29_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _edomain_list = NULL;
		ValaList* _tmp30_;
		ValaList* _tmp31_;
		gint _edomain_size = 0;
		ValaList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _edomain_index = 0;
		_tmp30_ = self->priv->error_domains;
		_tmp31_ = _vala_iterable_ref0 (_tmp30_);
		_edomain_list = _tmp31_;
		_tmp32_ = _edomain_list;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_edomain_size = _tmp34_;
		_edomain_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			ValaErrorDomain* edomain = NULL;
			ValaList* _tmp37_;
			gpointer _tmp38_;
			ValaErrorDomain* _tmp39_;
			_edomain_index = _edomain_index + 1;
			_tmp35_ = _edomain_index;
			_tmp36_ = _edomain_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _edomain_list;
			_tmp38_ = vala_list_get (_tmp37_, _edomain_index);
			edomain = (ValaErrorDomain*) _tmp38_;
			_tmp39_ = edomain;
			vala_code_node_accept ((ValaCodeNode*) _tmp39_, visitor);
			_vala_code_node_unref0 (edomain);
		}
		_vala_iterable_unref0 (_edomain_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp40_;
		ValaList* _tmp41_;
		gint _cl_size = 0;
		ValaList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _cl_index = 0;
		_tmp40_ = self->priv->classes;
		_tmp41_ = _vala_iterable_ref0 (_tmp40_);
		_cl_list = _tmp41_;
		_tmp42_ = _cl_list;
		_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
		_tmp44_ = _tmp43_;
		_cl_size = _tmp44_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp45_;
			gint _tmp46_;
			ValaClass* cl = NULL;
			ValaList* _tmp47_;
			gpointer _tmp48_;
			ValaClass* _tmp49_;
			_cl_index = _cl_index + 1;
			_tmp45_ = _cl_index;
			_tmp46_ = _cl_size;
			if (!(_tmp45_ < _tmp46_)) {
				break;
			}
			_tmp47_ = _cl_list;
			_tmp48_ = vala_list_get (_tmp47_, _cl_index);
			cl = (ValaClass*) _tmp48_;
			_tmp49_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp49_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp50_;
		ValaList* _tmp51_;
		gint _iface_size = 0;
		ValaList* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _iface_index = 0;
		_tmp50_ = self->priv->interfaces;
		_tmp51_ = _vala_iterable_ref0 (_tmp50_);
		_iface_list = _tmp51_;
		_tmp52_ = _iface_list;
		_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
		_tmp54_ = _tmp53_;
		_iface_size = _tmp54_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp55_;
			gint _tmp56_;
			ValaInterface* iface = NULL;
			ValaList* _tmp57_;
			gpointer _tmp58_;
			ValaInterface* _tmp59_;
			_iface_index = _iface_index + 1;
			_tmp55_ = _iface_index;
			_tmp56_ = _iface_size;
			if (!(_tmp55_ < _tmp56_)) {
				break;
			}
			_tmp57_ = _iface_list;
			_tmp58_ = vala_list_get (_tmp57_, _iface_index);
			iface = (ValaInterface*) _tmp58_;
			_tmp59_ = iface;
			vala_code_node_accept ((ValaCodeNode*) _tmp59_, visitor);
			_vala_code_node_unref0 (iface);
		}
		_vala_iterable_unref0 (_iface_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp60_;
		ValaList* _tmp61_;
		gint _st_size = 0;
		ValaList* _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
		gint _st_index = 0;
		_tmp60_ = self->priv->structs;
		_tmp61_ = _vala_iterable_ref0 (_tmp60_);
		_st_list = _tmp61_;
		_tmp62_ = _st_list;
		_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
		_tmp64_ = _tmp63_;
		_st_size = _tmp64_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp65_;
			gint _tmp66_;
			ValaStruct* st = NULL;
			ValaList* _tmp67_;
			gpointer _tmp68_;
			ValaStruct* _tmp69_;
			_st_index = _st_index + 1;
			_tmp65_ = _st_index;
			_tmp66_ = _st_size;
			if (!(_tmp65_ < _tmp66_)) {
				break;
			}
			_tmp67_ = _st_list;
			_tmp68_ = vala_list_get (_tmp67_, _st_index);
			st = (ValaStruct*) _tmp68_;
			_tmp69_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp69_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp70_;
		ValaList* _tmp71_;
		gint _d_size = 0;
		ValaList* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		gint _d_index = 0;
		_tmp70_ = self->priv->delegates;
		_tmp71_ = _vala_iterable_ref0 (_tmp70_);
		_d_list = _tmp71_;
		_tmp72_ = _d_list;
		_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
		_tmp74_ = _tmp73_;
		_d_size = _tmp74_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp75_;
			gint _tmp76_;
			ValaDelegate* d = NULL;
			ValaList* _tmp77_;
			gpointer _tmp78_;
			ValaDelegate* _tmp79_;
			_d_index = _d_index + 1;
			_tmp75_ = _d_index;
			_tmp76_ = _d_size;
			if (!(_tmp75_ < _tmp76_)) {
				break;
			}
			_tmp77_ = _d_list;
			_tmp78_ = vala_list_get (_tmp77_, _d_index);
			d = (ValaDelegate*) _tmp78_;
			_tmp79_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp79_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp80_;
		ValaList* _tmp81_;
		gint _c_size = 0;
		ValaList* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _c_index = 0;
		_tmp80_ = self->priv->constants;
		_tmp81_ = _vala_iterable_ref0 (_tmp80_);
		_c_list = _tmp81_;
		_tmp82_ = _c_list;
		_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
		_tmp84_ = _tmp83_;
		_c_size = _tmp84_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp85_;
			gint _tmp86_;
			ValaConstant* c = NULL;
			ValaList* _tmp87_;
			gpointer _tmp88_;
			ValaConstant* _tmp89_;
			_c_index = _c_index + 1;
			_tmp85_ = _c_index;
			_tmp86_ = _c_size;
			if (!(_tmp85_ < _tmp86_)) {
				break;
			}
			_tmp87_ = _c_list;
			_tmp88_ = vala_list_get (_tmp87_, _c_index);
			c = (ValaConstant*) _tmp88_;
			_tmp89_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp89_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp90_;
		ValaList* _tmp91_;
		gint _f_size = 0;
		ValaList* _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		gint _f_index = 0;
		_tmp90_ = self->priv->fields;
		_tmp91_ = _vala_iterable_ref0 (_tmp90_);
		_f_list = _tmp91_;
		_tmp92_ = _f_list;
		_tmp93_ = vala_collection_get_size ((ValaCollection*) _tmp92_);
		_tmp94_ = _tmp93_;
		_f_size = _tmp94_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp95_;
			gint _tmp96_;
			ValaField* f = NULL;
			ValaList* _tmp97_;
			gpointer _tmp98_;
			ValaField* _tmp99_;
			_f_index = _f_index + 1;
			_tmp95_ = _f_index;
			_tmp96_ = _f_size;
			if (!(_tmp95_ < _tmp96_)) {
				break;
			}
			_tmp97_ = _f_list;
			_tmp98_ = vala_list_get (_tmp97_, _f_index);
			f = (ValaField*) _tmp98_;
			_tmp99_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp99_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp100_;
		ValaList* _tmp101_;
		gint _m_size = 0;
		ValaList* _tmp102_;
		gint _tmp103_;
		gint _tmp104_;
		gint _m_index = 0;
		_tmp100_ = self->priv->methods;
		_tmp101_ = _vala_iterable_ref0 (_tmp100_);
		_m_list = _tmp101_;
		_tmp102_ = _m_list;
		_tmp103_ = vala_collection_get_size ((ValaCollection*) _tmp102_);
		_tmp104_ = _tmp103_;
		_m_size = _tmp104_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp105_;
			gint _tmp106_;
			ValaMethod* m = NULL;
			ValaList* _tmp107_;
			gpointer _tmp108_;
			ValaMethod* _tmp109_;
			_m_index = _m_index + 1;
			_tmp105_ = _m_index;
			_tmp106_ = _m_size;
			if (!(_tmp105_ < _tmp106_)) {
				break;
			}
			_tmp107_ = _m_list;
			_tmp108_ = vala_list_get (_tmp107_, _m_index);
			m = (ValaMethod*) _tmp108_;
			_tmp109_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp109_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
}

static gboolean
vala_namespace_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaNamespace * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp4_;
	ValaAttribute* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaAttribute* _tmp7_;
	gboolean _tmp31_ = FALSE;
	ValaAttribute* _tmp32_;
	gboolean _tmp102_;
	gboolean _tmp103_;
	gboolean result = FALSE;
	self = (ValaNamespace*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "CCode");
	_tmp5_ = _vala_code_node_ref0 (_tmp4_);
	a = _tmp5_;
	_tmp7_ = a;
	if (_tmp7_ != NULL) {
		ValaAttribute* _tmp8_;
		_tmp8_ = a;
		_tmp6_ = vala_attribute_has_argument (_tmp8_, "gir_namespace");
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gchar* new_gir = NULL;
		ValaAttribute* _tmp9_;
		gchar* _tmp10_;
		gchar* old_gir = NULL;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSourceFile* _tmp13_;
		ValaSourceFile* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gboolean _tmp18_ = FALSE;
		const gchar* _tmp19_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaSourceFile* _tmp28_;
		ValaSourceFile* _tmp29_;
		const gchar* _tmp30_;
		_tmp9_ = a;
		_tmp10_ = vala_attribute_get_string (_tmp9_, "gir_namespace", NULL);
		new_gir = _tmp10_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_source_reference_get_file (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_source_file_get_gir_namespace (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup (_tmp16_);
		old_gir = _tmp17_;
		_tmp19_ = old_gir;
		if (_tmp19_ != NULL) {
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			_tmp20_ = old_gir;
			_tmp21_ = new_gir;
			_tmp18_ = g_strcmp0 (_tmp20_, _tmp21_) != 0;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			ValaSourceReference* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaSourceFile* _tmp24_;
			ValaSourceFile* _tmp25_;
			_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_source_reference_get_file (_tmp23_);
			_tmp25_ = _tmp24_;
			vala_source_file_set_gir_ambiguous (_tmp25_, TRUE);
		}
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_source_reference_get_file (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = new_gir;
		vala_source_file_set_gir_namespace (_tmp29_, _tmp30_);
		_g_free0 (old_gir);
		_g_free0 (new_gir);
	}
	_tmp32_ = a;
	if (_tmp32_ != NULL) {
		ValaAttribute* _tmp33_;
		_tmp33_ = a;
		_tmp31_ = vala_attribute_has_argument (_tmp33_, "gir_version");
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		ValaSourceReference* _tmp34_;
		ValaSourceReference* _tmp35_;
		ValaSourceFile* _tmp36_;
		ValaSourceFile* _tmp37_;
		ValaAttribute* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_source_reference_get_file (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = a;
		_tmp39_ = vala_attribute_get_string (_tmp38_, "gir_version", NULL);
		_tmp40_ = _tmp39_;
		vala_source_file_set_gir_version (_tmp37_, _tmp40_);
		_g_free0 (_tmp40_);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp41_;
		ValaList* _tmp42_;
		gint _f_size = 0;
		ValaList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _f_index = 0;
		_tmp41_ = self->priv->fields;
		_tmp42_ = _vala_iterable_ref0 (_tmp41_);
		_f_list = _tmp42_;
		_tmp43_ = _f_list;
		_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_f_size = _tmp45_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp46_;
			gint _tmp47_;
			ValaField* f = NULL;
			ValaList* _tmp48_;
			gpointer _tmp49_;
			ValaField* _tmp50_;
			ValaMemberBinding _tmp51_;
			ValaMemberBinding _tmp52_;
			_f_index = _f_index + 1;
			_tmp46_ = _f_index;
			_tmp47_ = _f_size;
			if (!(_tmp46_ < _tmp47_)) {
				break;
			}
			_tmp48_ = _f_list;
			_tmp49_ = vala_list_get (_tmp48_, _f_index);
			f = (ValaField*) _tmp49_;
			_tmp50_ = f;
			_tmp51_ = vala_field_get_binding (_tmp50_);
			_tmp52_ = _tmp51_;
			if (_tmp52_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp53_;
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				ValaField* _tmp56_;
				_tmp53_ = f;
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp53_);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp55_, "instance fields are not allowed outside of data types");
				_tmp56_ = f;
				vala_code_node_set_error ((ValaCodeNode*) _tmp56_, TRUE);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			} else {
				ValaField* _tmp57_;
				ValaMemberBinding _tmp58_;
				ValaMemberBinding _tmp59_;
				_tmp57_ = f;
				_tmp58_ = vala_field_get_binding (_tmp57_);
				_tmp59_ = _tmp58_;
				if (_tmp59_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp60_;
					ValaSourceReference* _tmp61_;
					ValaSourceReference* _tmp62_;
					ValaField* _tmp63_;
					_tmp60_ = f;
					_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp60_);
					_tmp62_ = _tmp61_;
					vala_report_error (_tmp62_, "class fields are not allowed outside of classes");
					_tmp63_ = f;
					vala_code_node_set_error ((ValaCodeNode*) _tmp63_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp64_;
		ValaList* _tmp65_;
		gint _m_size = 0;
		ValaList* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		gint _m_index = 0;
		_tmp64_ = self->priv->methods;
		_tmp65_ = _vala_iterable_ref0 (_tmp64_);
		_m_list = _tmp65_;
		_tmp66_ = _m_list;
		_tmp67_ = vala_collection_get_size ((ValaCollection*) _tmp66_);
		_tmp68_ = _tmp67_;
		_m_size = _tmp68_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp69_;
			gint _tmp70_;
			ValaMethod* m = NULL;
			ValaList* _tmp71_;
			gpointer _tmp72_;
			ValaMethod* _tmp73_;
			ValaMethod* _tmp78_;
			ValaMemberBinding _tmp79_;
			ValaMemberBinding _tmp80_;
			_m_index = _m_index + 1;
			_tmp69_ = _m_index;
			_tmp70_ = _m_size;
			if (!(_tmp69_ < _tmp70_)) {
				break;
			}
			_tmp71_ = _m_list;
			_tmp72_ = vala_list_get (_tmp71_, _m_index);
			m = (ValaMethod*) _tmp72_;
			_tmp73_ = m;
			if (VALA_IS_CREATION_METHOD (_tmp73_)) {
				ValaMethod* _tmp74_;
				ValaSourceReference* _tmp75_;
				ValaSourceReference* _tmp76_;
				ValaMethod* _tmp77_;
				_tmp74_ = m;
				_tmp75_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp74_);
				_tmp76_ = _tmp75_;
				vala_report_error (_tmp76_, "construction methods may only be declared within classes and structs");
				_tmp77_ = m;
				vala_code_node_set_error ((ValaCodeNode*) _tmp77_, TRUE);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp78_ = m;
			_tmp79_ = vala_method_get_binding (_tmp78_);
			_tmp80_ = _tmp79_;
			if (_tmp80_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaMethod* _tmp81_;
				ValaSourceReference* _tmp82_;
				ValaSourceReference* _tmp83_;
				ValaMethod* _tmp84_;
				_tmp81_ = m;
				_tmp82_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp81_);
				_tmp83_ = _tmp82_;
				vala_report_error (_tmp83_, "instance methods are not allowed outside of data types");
				_tmp84_ = m;
				vala_code_node_set_error ((ValaCodeNode*) _tmp84_, TRUE);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			} else {
				ValaMethod* _tmp85_;
				ValaMemberBinding _tmp86_;
				ValaMemberBinding _tmp87_;
				_tmp85_ = m;
				_tmp86_ = vala_method_get_binding (_tmp85_);
				_tmp87_ = _tmp86_;
				if (_tmp87_ == VALA_MEMBER_BINDING_CLASS) {
					ValaMethod* _tmp88_;
					ValaSourceReference* _tmp89_;
					ValaSourceReference* _tmp90_;
					ValaMethod* _tmp91_;
					_tmp88_ = m;
					_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp88_);
					_tmp90_ = _tmp89_;
					vala_report_error (_tmp90_, "class methods are not allowed outside of classes");
					_tmp91_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp91_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _ns_list = NULL;
		ValaList* _tmp92_;
		ValaList* _tmp93_;
		gint _ns_size = 0;
		ValaList* _tmp94_;
		gint _tmp95_;
		gint _tmp96_;
		gint _ns_index = 0;
		_tmp92_ = self->priv->namespaces;
		_tmp93_ = _vala_iterable_ref0 (_tmp92_);
		_ns_list = _tmp93_;
		_tmp94_ = _ns_list;
		_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
		_tmp96_ = _tmp95_;
		_ns_size = _tmp96_;
		_ns_index = -1;
		while (TRUE) {
			gint _tmp97_;
			gint _tmp98_;
			ValaNamespace* ns = NULL;
			ValaList* _tmp99_;
			gpointer _tmp100_;
			ValaNamespace* _tmp101_;
			_ns_index = _ns_index + 1;
			_tmp97_ = _ns_index;
			_tmp98_ = _ns_size;
			if (!(_tmp97_ < _tmp98_)) {
				break;
			}
			_tmp99_ = _ns_list;
			_tmp100_ = vala_list_get (_tmp99_, _ns_index);
			ns = (ValaNamespace*) _tmp100_;
			_tmp101_ = ns;
			vala_code_node_check ((ValaCodeNode*) _tmp101_, context);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterable_unref0 (_ns_list);
	}
	_tmp102_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp103_ = _tmp102_;
	result = !_tmp103_;
	_vala_code_node_unref0 (a);
	return result;
}

static gchar*
vala_namespace_real_to_string (ValaCodeNode* base)
{
	ValaNamespace * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result = NULL;
	self = (ValaNamespace*) base;
	_tmp0_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("(root namespace)");
		result = _tmp2_;
		return result;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("namespace %s", _tmp4_);
		result = _tmp5_;
		return result;
	}
}

static void
vala_namespace_class_init (ValaNamespaceClass * klass,
                           gpointer klass_data)
{
	vala_namespace_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_namespace_finalize;
	g_type_class_adjust_private_offset (klass, &ValaNamespace_private_offset);
	((ValaSymbolClass *) klass)->add_namespace = (void (*) (ValaSymbol*, ValaNamespace*)) vala_namespace_real_add_namespace;
	((ValaSymbolClass *) klass)->add_class = (void (*) (ValaSymbol*, ValaClass*)) vala_namespace_real_add_class;
	((ValaSymbolClass *) klass)->add_interface = (void (*) (ValaSymbol*, ValaInterface*)) vala_namespace_real_add_interface;
	((ValaSymbolClass *) klass)->add_struct = (void (*) (ValaSymbol*, ValaStruct*)) vala_namespace_real_add_struct;
	((ValaSymbolClass *) klass)->add_enum = (void (*) (ValaSymbol*, ValaEnum*)) vala_namespace_real_add_enum;
	((ValaSymbolClass *) klass)->add_error_domain = (void (*) (ValaSymbol*, ValaErrorDomain*)) vala_namespace_real_add_error_domain;
	((ValaSymbolClass *) klass)->add_delegate = (void (*) (ValaSymbol*, ValaDelegate*)) vala_namespace_real_add_delegate;
	((ValaSymbolClass *) klass)->add_constant = (void (*) (ValaSymbol*, ValaConstant*)) vala_namespace_real_add_constant;
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_namespace_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_namespace_real_add_method;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_namespace_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_namespace_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_namespace_real_check;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_namespace_real_to_string;
}

static void
vala_namespace_instance_init (ValaNamespace * self,
                              gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	GEqualFunc _tmp10_;
	ValaArrayList* _tmp11_;
	GEqualFunc _tmp12_;
	ValaArrayList* _tmp13_;
	GEqualFunc _tmp14_;
	ValaArrayList* _tmp15_;
	GEqualFunc _tmp16_;
	ValaArrayList* _tmp17_;
	GEqualFunc _tmp18_;
	ValaArrayList* _tmp19_;
	GEqualFunc _tmp20_;
	ValaArrayList* _tmp21_;
	GEqualFunc _tmp22_;
	ValaArrayList* _tmp23_;
	self->priv = vala_namespace_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->classes = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_INTERFACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->interfaces = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->structs = (ValaList*) _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp6_);
	self->priv->enums = (ValaList*) _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_ERROR_DOMAIN, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp8_);
	self->priv->error_domains = (ValaList*) _tmp9_;
	_tmp10_ = g_direct_equal;
	_tmp11_ = vala_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp10_);
	self->priv->delegates = (ValaList*) _tmp11_;
	_tmp12_ = g_direct_equal;
	_tmp13_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp12_);
	self->priv->constants = (ValaList*) _tmp13_;
	_tmp14_ = g_direct_equal;
	_tmp15_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp14_);
	self->priv->fields = (ValaList*) _tmp15_;
	_tmp16_ = g_direct_equal;
	_tmp17_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp16_);
	self->priv->methods = (ValaList*) _tmp17_;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_array_list_new (VALA_TYPE_COMMENT, (GBoxedCopyFunc) vala_comment_ref, (GDestroyNotify) vala_comment_unref, _tmp18_);
	self->priv->comments = (ValaList*) _tmp19_;
	_tmp20_ = g_direct_equal;
	_tmp21_ = vala_array_list_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp20_);
	self->priv->namespaces = (ValaList*) _tmp21_;
	_tmp22_ = g_direct_equal;
	_tmp23_ = vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp22_);
	self->priv->using_directives = (ValaList*) _tmp23_;
}

static void
vala_namespace_finalize (ValaCodeNode * obj)
{
	ValaNamespace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_NAMESPACE, ValaNamespace);
	_vala_iterable_unref0 (self->priv->classes);
	_vala_iterable_unref0 (self->priv->interfaces);
	_vala_iterable_unref0 (self->priv->structs);
	_vala_iterable_unref0 (self->priv->enums);
	_vala_iterable_unref0 (self->priv->error_domains);
	_vala_iterable_unref0 (self->priv->delegates);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->comments);
	_vala_iterable_unref0 (self->priv->namespaces);
	_vala_iterable_unref0 (self->priv->using_directives);
	VALA_CODE_NODE_CLASS (vala_namespace_parent_class)->finalize (obj);
}

/**
 * Represents a namespace declaration in the source code.
 */
static GType
vala_namespace_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaNamespaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_namespace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaNamespace), 0, (GInstanceInitFunc) vala_namespace_instance_init, NULL };
	GType vala_namespace_type_id;
	vala_namespace_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaNamespace", &g_define_type_info, 0);
	ValaNamespace_private_offset = g_type_add_instance_private (vala_namespace_type_id, sizeof (ValaNamespacePrivate));
	return vala_namespace_type_id;
}

GType
vala_namespace_get_type (void)
{
	static volatile gsize vala_namespace_type_id__volatile = 0;
	if (g_once_init_enter (&vala_namespace_type_id__volatile)) {
		GType vala_namespace_type_id;
		vala_namespace_type_id = vala_namespace_get_type_once ();
		g_once_init_leave (&vala_namespace_type_id__volatile, vala_namespace_type_id);
	}
	return vala_namespace_type_id__volatile;
}

