/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
	gboolean is_with_variable_access;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaDataType* _tmp13_;
			_type_arg_index = _type_arg_index + 1;
			_tmp9_ = _type_arg_index;
			_tmp10_ = _type_arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _type_arg_list;
			_tmp12_ = vala_list_get (_tmp11_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp12_;
			_tmp13_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp18_;
	ValaArrayList* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp667_ = FALSE;
	gboolean _tmp668_ = FALSE;
	gboolean _tmp669_ = FALSE;
	ValaExpression* _tmp670_;
	ValaExpression* _tmp671_;
	ValaSymbol* _tmp699_;
	ValaSymbol* _tmp700_;
	ValaSymbol* _tmp772_;
	ValaSymbol* _tmp773_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp811_;
	ValaSymbol* _tmp812_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp813_;
	ValaSymbol* _tmp814_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1277_;
	ValaSymbol* _tmp1278_;
	ValaSymbol* _tmp1280_;
	ValaVersionAttribute* _tmp1281_;
	ValaVersionAttribute* _tmp1282_;
	ValaSourceReference* _tmp1283_;
	ValaSourceReference* _tmp1284_;
	gboolean _tmp1285_ = FALSE;
	ValaSymbolAccessibility _tmp1286_;
	gboolean _tmp1342_ = FALSE;
	gboolean _tmp1369_ = FALSE;
	gboolean _tmp1370_ = FALSE;
	ValaDataType* _tmp1650_;
	ValaDataType* _tmp1651_;
	gboolean _tmp1654_;
	gboolean _tmp1655_;
	gboolean _tmp1656_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaDataType* _tmp17_;
			_type_arg_index = _type_arg_index + 1;
			_tmp13_ = _type_arg_index;
			_tmp14_ = _type_arg_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _type_arg_list;
			_tmp16_ = vala_list_get (_tmp15_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp16_;
			_tmp17_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp17_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp18_);
	visited_types = _tmp19_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp20_ = self->priv->_qualified;
	if (_tmp20_) {
		ValaNamespace* _tmp21_;
		ValaNamespace* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaScope* _tmp24_;
		ValaScope* _tmp25_;
		const gchar* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaSymbol* _tmp28_;
		_tmp21_ = vala_code_context_get_root (context);
		_tmp22_ = _tmp21_;
		base_symbol = (ValaSymbol*) _tmp22_;
		_tmp23_ = base_symbol;
		_tmp24_ = vala_symbol_get_scope (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = self->priv->_member_name;
		_tmp27_ = vala_scope_lookup (_tmp25_, _tmp26_);
		_tmp28_ = _tmp27_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp28_);
		_vala_code_node_unref0 (_tmp28_);
	} else {
		ValaExpression* _tmp29_;
		ValaExpression* _tmp30_;
		_tmp29_ = vala_member_access_get_inner (self);
		_tmp30_ = _tmp29_;
		if (_tmp30_ == NULL) {
			const gchar* _tmp31_;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp40_;
			ValaSemanticAnalyzer* _tmp41_;
			ValaSymbol* _tmp42_;
			ValaSymbol* _tmp43_;
			gboolean _tmp180_ = FALSE;
			ValaSymbol* _tmp181_;
			ValaSymbol* _tmp182_;
			_tmp31_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp31_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp32_;
				ValaSemanticAnalyzer* _tmp33_;
				_tmp32_ = vala_code_context_get_analyzer (context);
				_tmp33_ = _tmp32_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp33_)) {
					ValaSourceReference* _tmp34_;
					ValaSourceReference* _tmp35_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp35_ = _tmp34_;
					vala_report_error (_tmp35_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp36_ = vala_code_context_get_analyzer (context);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_semantic_analyzer_get_current_symbol (_tmp37_);
			_tmp39_ = _tmp38_;
			base_symbol = _tmp39_;
			method_found = FALSE;
			_tmp40_ = vala_code_context_get_analyzer (context);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_semantic_analyzer_get_current_symbol (_tmp41_);
			_tmp43_ = _tmp42_;
			sym = _tmp43_;
			while (TRUE) {
				gboolean _tmp44_ = FALSE;
				ValaSymbol* _tmp45_;
				ValaSymbol* _tmp91_;
				const gchar* _tmp92_;
				ValaSymbol* _tmp93_;
				ValaSymbol* _tmp94_;
				gboolean _tmp95_ = FALSE;
				gboolean _tmp96_ = FALSE;
				gboolean _tmp133_ = FALSE;
				gboolean _tmp134_ = FALSE;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp136_;
				ValaSymbol* _tmp174_;
				ValaSymbol* _tmp175_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				ValaSymbol* _tmp179_;
				_tmp45_ = sym;
				if (_tmp45_ != NULL) {
					ValaSymbol* _tmp46_;
					ValaSymbol* _tmp47_;
					_tmp46_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp47_ = _tmp46_;
					_tmp44_ = _tmp47_ == NULL;
				} else {
					_tmp44_ = FALSE;
				}
				if (!_tmp44_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp48_;
					_tmp48_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp48_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp49_;
						ValaCreationMethod* _tmp50_;
						ValaParameter* _tmp51_;
						ValaParameter* _tmp52_;
						_tmp49_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp50_ = cm;
						_tmp51_ = vala_method_get_this_parameter ((ValaMethod*) _tmp50_);
						_tmp52_ = _tmp51_;
						this_parameter = _tmp52_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp53_;
						_tmp53_ = sym;
						if (VALA_IS_PROPERTY (_tmp53_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp54_;
							ValaProperty* _tmp55_;
							ValaParameter* _tmp56_;
							ValaParameter* _tmp57_;
							ValaProperty* _tmp58_;
							ValaMemberBinding _tmp59_;
							ValaMemberBinding _tmp60_;
							ValaProperty* _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaMemberBinding _tmp63_;
							_tmp54_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp55_ = prop;
							_tmp56_ = vala_property_get_this_parameter (_tmp55_);
							_tmp57_ = _tmp56_;
							this_parameter = _tmp57_;
							_tmp58_ = prop;
							_tmp59_ = vala_property_get_binding (_tmp58_);
							_tmp60_ = _tmp59_;
							may_access_instance_members = _tmp60_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp61_ = prop;
							_tmp62_ = vala_property_get_binding (_tmp61_);
							_tmp63_ = _tmp62_;
							may_access_klass_members = _tmp63_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp64_;
							_tmp64_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp64_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp65_;
								ValaConstructor* _tmp66_;
								ValaParameter* _tmp67_;
								ValaParameter* _tmp68_;
								ValaConstructor* _tmp69_;
								ValaMemberBinding _tmp70_;
								ValaMemberBinding _tmp71_;
								_tmp65_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp66_ = c;
								_tmp67_ = vala_constructor_get_this_parameter (_tmp66_);
								_tmp68_ = _tmp67_;
								this_parameter = _tmp68_;
								_tmp69_ = c;
								_tmp70_ = vala_constructor_get_binding (_tmp69_);
								_tmp71_ = _tmp70_;
								may_access_instance_members = _tmp71_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp72_;
								_tmp72_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp72_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp73_;
									ValaDestructor* _tmp74_;
									ValaParameter* _tmp75_;
									ValaParameter* _tmp76_;
									ValaDestructor* _tmp77_;
									ValaMemberBinding _tmp78_;
									ValaMemberBinding _tmp79_;
									_tmp73_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp74_ = d;
									_tmp75_ = vala_destructor_get_this_parameter (_tmp74_);
									_tmp76_ = _tmp75_;
									this_parameter = _tmp76_;
									_tmp77_ = d;
									_tmp78_ = vala_destructor_get_binding (_tmp77_);
									_tmp79_ = _tmp78_;
									may_access_instance_members = _tmp79_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp80_;
									_tmp80_ = sym;
									if (VALA_IS_METHOD (_tmp80_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp81_;
										ValaMethod* _tmp82_;
										ValaParameter* _tmp83_;
										ValaParameter* _tmp84_;
										ValaMethod* _tmp85_;
										ValaMemberBinding _tmp86_;
										ValaMemberBinding _tmp87_;
										ValaMethod* _tmp88_;
										ValaMemberBinding _tmp89_;
										ValaMemberBinding _tmp90_;
										_tmp81_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, VALA_TYPE_METHOD, ValaMethod);
										_tmp82_ = m;
										_tmp83_ = vala_method_get_this_parameter (_tmp82_);
										_tmp84_ = _tmp83_;
										this_parameter = _tmp84_;
										_tmp85_ = m;
										_tmp86_ = vala_method_get_binding (_tmp85_);
										_tmp87_ = _tmp86_;
										may_access_instance_members = _tmp87_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp88_ = m;
										_tmp89_ = vala_method_get_binding (_tmp88_);
										_tmp90_ = _tmp89_;
										may_access_klass_members = _tmp90_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp91_ = sym;
				_tmp92_ = self->priv->_member_name;
				_tmp93_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp91_, _tmp92_);
				_tmp94_ = _tmp93_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp94_);
				_vala_code_node_unref0 (_tmp94_);
				if (!self->priv->is_with_variable_access) {
					ValaSymbol* _tmp97_;
					ValaSymbol* _tmp98_;
					_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp98_ = _tmp97_;
					_tmp96_ = _tmp98_ == NULL;
				} else {
					_tmp96_ = FALSE;
				}
				if (_tmp96_) {
					ValaSymbol* _tmp99_;
					_tmp99_ = sym;
					_tmp95_ = VALA_IS_WITH_STATEMENT (_tmp99_);
				} else {
					_tmp95_ = FALSE;
				}
				if (_tmp95_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp100_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp101_;
					ValaLocalVariable* _tmp102_;
					ValaLocalVariable* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaDataType* _tmp106_;
					ValaDataType* _tmp107_;
					ValaArrayList* _tmp112_;
					ValaDataType* _tmp113_;
					ValaDataType* _tmp114_;
					const gchar* _tmp115_;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					ValaSymbol* _tmp118_;
					ValaSymbol* _tmp119_;
					_tmp100_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp101_ = w;
					_tmp102_ = vala_with_statement_get_with_variable (_tmp101_);
					_tmp103_ = _tmp102_;
					_tmp104_ = vala_variable_get_variable_type ((ValaVariable*) _tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = _vala_code_node_ref0 (_tmp105_);
					variable_type = _tmp106_;
					_tmp107_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp107_)) {
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaDataType* _tmp110_;
						ValaDataType* _tmp111_;
						_tmp108_ = variable_type;
						_tmp109_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp108_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp110_ = _tmp109_;
						_tmp111_ = _vala_code_node_ref0 (_tmp110_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp111_;
					}
					_tmp112_ = visited_types;
					_tmp113_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp112_, _tmp113_);
					_tmp114_ = variable_type;
					_tmp115_ = self->priv->_member_name;
					_tmp116_ = vala_data_type_get_member (_tmp114_, _tmp115_);
					_tmp117_ = _tmp116_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp117_);
					_vala_code_node_unref0 (_tmp117_);
					_tmp118_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp119_ = _tmp118_;
					if (_tmp119_ != NULL) {
						ValaWithStatement* _tmp120_;
						ValaLocalVariable* _tmp121_;
						ValaLocalVariable* _tmp122_;
						const gchar* _tmp123_;
						const gchar* _tmp124_;
						ValaSourceReference* _tmp125_;
						ValaSourceReference* _tmp126_;
						ValaMemberAccess* _tmp127_;
						ValaMemberAccess* _tmp128_;
						ValaExpression* _tmp129_;
						ValaExpression* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						_tmp120_ = w;
						_tmp121_ = vala_with_statement_get_with_variable (_tmp120_);
						_tmp122_ = _tmp121_;
						_tmp123_ = vala_symbol_get_name ((ValaSymbol*) _tmp122_);
						_tmp124_ = _tmp123_;
						_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_member_access_new (NULL, _tmp124_, _tmp126_);
						_tmp128_ = _tmp127_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp128_);
						_vala_code_node_unref0 (_tmp128_);
						_tmp129_ = vala_member_access_get_inner (self);
						_tmp130_ = _tmp129_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp130_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess)->priv->is_with_variable_access = TRUE;
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						vala_code_node_check ((ValaCodeNode*) _tmp132_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp135_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp136_ = _tmp135_;
				if (_tmp136_ == NULL) {
					ValaSymbol* _tmp137_;
					_tmp137_ = sym;
					_tmp134_ = VALA_IS_TYPESYMBOL (_tmp137_);
				} else {
					_tmp134_ = FALSE;
				}
				if (_tmp134_) {
					_tmp133_ = may_access_instance_members;
				} else {
					_tmp133_ = FALSE;
				}
				if (_tmp133_) {
					ValaParameter* _tmp138_;
					ValaDataType* _tmp139_;
					ValaDataType* _tmp140_;
					const gchar* _tmp141_;
					ValaSymbol* _tmp142_;
					ValaSymbol* _tmp143_;
					gboolean _tmp144_ = FALSE;
					ValaSymbol* _tmp145_;
					ValaSymbol* _tmp146_;
					_tmp138_ = this_parameter;
					_tmp139_ = vala_variable_get_variable_type ((ValaVariable*) _tmp138_);
					_tmp140_ = _tmp139_;
					_tmp141_ = self->priv->_member_name;
					_tmp142_ = vala_data_type_get_member (_tmp140_, _tmp141_);
					_tmp143_ = _tmp142_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp143_);
					_vala_code_node_unref0 (_tmp143_);
					_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp146_ = _tmp145_;
					if (_tmp146_ != NULL) {
						ValaSymbol* _tmp147_;
						ValaSymbol* _tmp148_;
						_tmp147_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp148_ = _tmp147_;
						_tmp144_ = vala_member_access_is_instance_symbol (_tmp148_);
					} else {
						_tmp144_ = FALSE;
					}
					if (_tmp144_) {
						ValaSourceReference* _tmp149_;
						ValaSourceReference* _tmp150_;
						ValaMemberAccess* _tmp151_;
						ValaMemberAccess* _tmp152_;
						ValaExpression* _tmp153_;
						ValaExpression* _tmp154_;
						ValaParameter* _tmp155_;
						ValaDataType* _tmp156_;
						ValaDataType* _tmp157_;
						ValaDataType* _tmp158_;
						ValaDataType* _tmp159_;
						ValaExpression* _tmp160_;
						ValaExpression* _tmp161_;
						ValaDataType* _tmp162_;
						ValaDataType* _tmp163_;
						ValaExpression* _tmp164_;
						ValaExpression* _tmp165_;
						ValaParameter* _tmp166_;
						ValaExpression* _tmp167_;
						ValaExpression* _tmp168_;
						ValaDataType* _tmp169_;
						ValaDataType* _tmp170_;
						const gchar* _tmp171_;
						ValaSymbol* _tmp172_;
						ValaSymbol* _tmp173_;
						_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp150_ = _tmp149_;
						_tmp151_ = vala_member_access_new (NULL, "this", _tmp150_);
						_tmp152_ = _tmp151_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp152_);
						_vala_code_node_unref0 (_tmp152_);
						_tmp153_ = vala_member_access_get_inner (self);
						_tmp154_ = _tmp153_;
						_tmp155_ = this_parameter;
						_tmp156_ = vala_variable_get_variable_type ((ValaVariable*) _tmp155_);
						_tmp157_ = _tmp156_;
						_tmp158_ = vala_data_type_copy (_tmp157_);
						_tmp159_ = _tmp158_;
						vala_expression_set_value_type (_tmp154_, _tmp159_);
						_vala_code_node_unref0 (_tmp159_);
						_tmp160_ = vala_member_access_get_inner (self);
						_tmp161_ = _tmp160_;
						_tmp162_ = vala_expression_get_value_type (_tmp161_);
						_tmp163_ = _tmp162_;
						vala_data_type_set_value_owned (_tmp163_, FALSE);
						_tmp164_ = vala_member_access_get_inner (self);
						_tmp165_ = _tmp164_;
						_tmp166_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp165_, (ValaSymbol*) _tmp166_);
						_tmp167_ = vala_member_access_get_inner (self);
						_tmp168_ = _tmp167_;
						_tmp169_ = vala_expression_get_value_type (_tmp168_);
						_tmp170_ = _tmp169_;
						_tmp171_ = self->priv->_member_name;
						_tmp172_ = vala_data_type_get_member (_tmp170_, _tmp171_);
						_tmp173_ = _tmp172_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp173_);
						_vala_code_node_unref0 (_tmp173_);
					}
				}
				_tmp174_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp175_ = _tmp174_;
				if (_tmp175_ == NULL) {
					ValaSymbol* _tmp176_;
					_tmp176_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp176_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp177_ = sym;
				_tmp178_ = vala_symbol_get_parent_symbol (_tmp177_);
				_tmp179_ = _tmp178_;
				sym = _tmp179_;
			}
			_tmp181_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp182_ = _tmp181_;
			if (_tmp182_ == NULL) {
				ValaSourceReference* _tmp183_;
				ValaSourceReference* _tmp184_;
				_tmp183_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp184_ = _tmp183_;
				_tmp180_ = _tmp184_ != NULL;
			} else {
				_tmp180_ = FALSE;
			}
			if (_tmp180_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp185_;
					ValaSourceReference* _tmp186_;
					ValaList* _tmp187_;
					ValaList* _tmp188_;
					ValaList* _tmp189_;
					gint _ns_size = 0;
					ValaList* _tmp190_;
					gint _tmp191_;
					gint _tmp192_;
					gint _ns_index = 0;
					_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp186_ = _tmp185_;
					_tmp187_ = vala_source_reference_get_using_directives (_tmp186_);
					_tmp188_ = _tmp187_;
					_tmp189_ = _vala_iterable_ref0 (_tmp188_);
					_ns_list = _tmp189_;
					_tmp190_ = _ns_list;
					_tmp191_ = vala_collection_get_size ((ValaCollection*) _tmp190_);
					_tmp192_ = _tmp191_;
					_ns_size = _tmp192_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp193_;
						gint _tmp194_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp195_;
						gpointer _tmp196_;
						ValaUsingDirective* _tmp197_;
						gboolean _tmp198_;
						gboolean _tmp199_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp200_;
						ValaSymbol* _tmp201_;
						ValaSymbol* _tmp202_;
						ValaScope* _tmp203_;
						ValaScope* _tmp204_;
						const gchar* _tmp205_;
						ValaSymbol* _tmp206_;
						ValaSymbol* _tmp207_;
						_ns_index = _ns_index + 1;
						_tmp193_ = _ns_index;
						_tmp194_ = _ns_size;
						if (!(_tmp193_ < _tmp194_)) {
							break;
						}
						_tmp195_ = _ns_list;
						_tmp196_ = vala_list_get (_tmp195_, _ns_index);
						ns = (ValaUsingDirective*) _tmp196_;
						_tmp197_ = ns;
						_tmp198_ = vala_code_node_get_error ((ValaCodeNode*) _tmp197_);
						_tmp199_ = _tmp198_;
						if (_tmp199_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp200_ = ns;
						_tmp201_ = vala_using_directive_get_namespace_symbol (_tmp200_);
						_tmp202_ = _tmp201_;
						_tmp203_ = vala_symbol_get_scope (_tmp202_);
						_tmp204_ = _tmp203_;
						_tmp205_ = self->priv->_member_name;
						_tmp206_ = vala_scope_lookup (_tmp204_, _tmp205_);
						local_sym = _tmp206_;
						_tmp207_ = local_sym;
						if (_tmp207_ != NULL) {
							gboolean _tmp208_ = FALSE;
							ValaSymbol* _tmp209_;
							ValaSymbol* _tmp210_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp226_;
							ValaSymbol* _tmp227_;
							ValaSymbol* _tmp228_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp248_;
							ValaExpression* _tmp249_;
							ValaExpression* _tmp250_;
							ValaSymbol* _tmp251_;
							_tmp209_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp210_ = _tmp209_;
							if (_tmp210_ != NULL) {
								ValaSymbol* _tmp211_;
								ValaSymbol* _tmp212_;
								ValaSymbol* _tmp213_;
								_tmp211_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp212_ = _tmp211_;
								_tmp213_ = local_sym;
								_tmp208_ = _tmp212_ != _tmp213_;
							} else {
								_tmp208_ = FALSE;
							}
							if (_tmp208_) {
								ValaSourceReference* _tmp214_;
								ValaSourceReference* _tmp215_;
								const gchar* _tmp216_;
								ValaSymbol* _tmp217_;
								ValaSymbol* _tmp218_;
								gchar* _tmp219_;
								gchar* _tmp220_;
								ValaSymbol* _tmp221_;
								gchar* _tmp222_;
								gchar* _tmp223_;
								gchar* _tmp224_;
								gchar* _tmp225_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp215_ = _tmp214_;
								_tmp216_ = self->priv->_member_name;
								_tmp217_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp218_ = _tmp217_;
								_tmp219_ = vala_symbol_get_full_name (_tmp218_);
								_tmp220_ = _tmp219_;
								_tmp221_ = local_sym;
								_tmp222_ = vala_symbol_get_full_name (_tmp221_);
								_tmp223_ = _tmp222_;
								_tmp224_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp216_, _tmp220_, _tmp223_);
								_tmp225_ = _tmp224_;
								vala_report_error (_tmp215_, _tmp225_);
								_g_free0 (_tmp225_);
								_g_free0 (_tmp223_);
								_g_free0 (_tmp220_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp226_ = local_sym;
							_tmp227_ = vala_symbol_get_parent_symbol (_tmp226_);
							_tmp228_ = _tmp227_;
							inner_sym = _tmp228_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp229_ = FALSE;
								ValaSymbol* _tmp230_;
								ValaMemberAccess* _tmp234_;
								ValaSymbol* _tmp235_;
								const gchar* _tmp236_;
								const gchar* _tmp237_;
								ValaSourceReference* _tmp238_;
								ValaSourceReference* _tmp239_;
								ValaMemberAccess* _tmp240_;
								ValaMemberAccess* _tmp241_;
								ValaMemberAccess* _tmp242_;
								ValaExpression* _tmp243_;
								ValaExpression* _tmp244_;
								ValaSymbol* _tmp245_;
								ValaSymbol* _tmp246_;
								ValaSymbol* _tmp247_;
								_tmp230_ = inner_sym;
								if (_tmp230_ != NULL) {
									ValaSymbol* _tmp231_;
									const gchar* _tmp232_;
									const gchar* _tmp233_;
									_tmp231_ = inner_sym;
									_tmp232_ = vala_symbol_get_name (_tmp231_);
									_tmp233_ = _tmp232_;
									_tmp229_ = _tmp233_ != NULL;
								} else {
									_tmp229_ = FALSE;
								}
								if (!_tmp229_) {
									break;
								}
								_tmp234_ = inner_ma;
								_tmp235_ = inner_sym;
								_tmp236_ = vala_symbol_get_name (_tmp235_);
								_tmp237_ = _tmp236_;
								_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp239_ = _tmp238_;
								_tmp240_ = vala_member_access_new (NULL, _tmp237_, _tmp239_);
								_tmp241_ = _tmp240_;
								vala_member_access_set_inner (_tmp234_, (ValaExpression*) _tmp241_);
								_vala_code_node_unref0 (_tmp241_);
								_tmp242_ = inner_ma;
								_tmp243_ = vala_member_access_get_inner (_tmp242_);
								_tmp244_ = _tmp243_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp244_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp245_ = inner_sym;
								_tmp246_ = vala_symbol_get_parent_symbol (_tmp245_);
								_tmp247_ = _tmp246_;
								inner_sym = _tmp247_;
							}
							_tmp248_ = inner_ma;
							vala_member_access_set_qualified (_tmp248_, TRUE);
							_tmp249_ = vala_member_access_get_inner (self);
							_tmp250_ = _tmp249_;
							vala_code_node_check ((ValaCodeNode*) _tmp250_, context);
							_tmp251_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp251_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp252_;
			ValaExpression* _tmp253_;
			gboolean _tmp254_;
			gboolean _tmp255_;
			ValaExpression* _tmp256_;
			ValaExpression* _tmp257_;
			ValaDataType* _tmp258_;
			ValaDataType* _tmp259_;
			ValaExpression* _tmp290_;
			ValaExpression* _tmp291_;
			gboolean _tmp306_ = FALSE;
			ValaExpression* _tmp307_;
			ValaExpression* _tmp308_;
			gboolean _tmp315_ = FALSE;
			ValaExpression* _tmp316_;
			ValaExpression* _tmp317_;
			gboolean _tmp338_ = FALSE;
			ValaExpression* _tmp339_;
			ValaExpression* _tmp340_;
			gboolean _tmp359_ = FALSE;
			ValaSymbol* _tmp360_;
			ValaSymbol* _tmp361_;
			gboolean _tmp395_ = FALSE;
			gboolean _tmp396_ = FALSE;
			ValaSymbol* _tmp397_;
			ValaSymbol* _tmp398_;
			ValaSymbol* _tmp633_;
			ValaSymbol* _tmp634_;
			_tmp252_ = vala_member_access_get_inner (self);
			_tmp253_ = _tmp252_;
			_tmp254_ = vala_code_node_get_error ((ValaCodeNode*) _tmp253_);
			_tmp255_ = _tmp254_;
			if (_tmp255_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp256_ = vala_member_access_get_inner (self);
			_tmp257_ = _tmp256_;
			_tmp258_ = vala_expression_get_value_type (_tmp257_);
			_tmp259_ = _tmp258_;
			if (VALA_IS_POINTER_TYPE (_tmp259_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp260_;
				ValaExpression* _tmp261_;
				ValaDataType* _tmp262_;
				ValaDataType* _tmp263_;
				gboolean _tmp264_ = FALSE;
				ValaPointerType* _tmp265_;
				_tmp260_ = vala_member_access_get_inner (self);
				_tmp261_ = _tmp260_;
				_tmp262_ = vala_expression_get_value_type (_tmp261_);
				_tmp263_ = _tmp262_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp263_) ? ((ValaPointerType*) _tmp263_) : NULL;
				_tmp265_ = pointer_type;
				if (_tmp265_ != NULL) {
					ValaPointerType* _tmp266_;
					ValaDataType* _tmp267_;
					ValaDataType* _tmp268_;
					_tmp266_ = pointer_type;
					_tmp267_ = vala_pointer_type_get_base_type (_tmp266_);
					_tmp268_ = _tmp267_;
					_tmp264_ = VALA_IS_VALUE_TYPE (_tmp268_);
				} else {
					_tmp264_ = FALSE;
				}
				if (_tmp264_) {
					ValaExpression* _tmp269_;
					ValaExpression* _tmp270_;
					ValaDataType* _tmp271_;
					ValaDataType* _tmp272_;
					ValaExpression* _tmp282_;
					ValaExpression* _tmp283_;
					ValaSourceReference* _tmp284_;
					ValaSourceReference* _tmp285_;
					ValaPointerIndirection* _tmp286_;
					ValaPointerIndirection* _tmp287_;
					ValaExpression* _tmp288_;
					ValaExpression* _tmp289_;
					_tmp269_ = vala_member_access_get_inner (self);
					_tmp270_ = _tmp269_;
					_tmp271_ = vala_expression_get_formal_value_type (_tmp270_);
					_tmp272_ = _tmp271_;
					if (VALA_IS_GENERIC_TYPE (_tmp272_)) {
						ValaExpression* _tmp273_;
						ValaExpression* _tmp274_;
						ValaPointerType* _tmp275_;
						ValaDataType* _tmp276_;
						ValaDataType* _tmp277_;
						ValaSourceReference* _tmp278_;
						ValaSourceReference* _tmp279_;
						ValaCastExpression* _tmp280_;
						ValaCastExpression* _tmp281_;
						_tmp273_ = vala_member_access_get_inner (self);
						_tmp274_ = _tmp273_;
						_tmp275_ = pointer_type;
						_tmp276_ = vala_data_type_copy ((ValaDataType*) _tmp275_);
						_tmp277_ = _tmp276_;
						_tmp278_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp279_ = _tmp278_;
						_tmp280_ = vala_cast_expression_new (_tmp274_, _tmp277_, _tmp279_);
						_tmp281_ = _tmp280_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp281_);
						_vala_code_node_unref0 (_tmp281_);
						_vala_code_node_unref0 (_tmp277_);
					}
					_tmp282_ = vala_member_access_get_inner (self);
					_tmp283_ = _tmp282_;
					_tmp284_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp285_ = _tmp284_;
					_tmp286_ = vala_pointer_indirection_new (_tmp283_, _tmp285_);
					_tmp287_ = _tmp286_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp287_);
					_vala_code_node_unref0 (_tmp287_);
					_tmp288_ = vala_member_access_get_inner (self);
					_tmp289_ = _tmp288_;
					vala_code_node_check ((ValaCodeNode*) _tmp289_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp290_ = vala_member_access_get_inner (self);
			_tmp291_ = _tmp290_;
			if (VALA_IS_MEMBER_ACCESS (_tmp291_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp292_;
				ValaExpression* _tmp293_;
				ValaMemberAccess* _tmp294_;
				gboolean _tmp295_;
				_tmp292_ = vala_member_access_get_inner (self);
				_tmp293_ = _tmp292_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp293_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp294_ = ma;
				_tmp295_ = _tmp294_->priv->_prototype_access;
				if (_tmp295_) {
					ValaSourceReference* _tmp296_;
					ValaSourceReference* _tmp297_;
					ValaExpression* _tmp298_;
					ValaExpression* _tmp299_;
					ValaSymbol* _tmp300_;
					ValaSymbol* _tmp301_;
					gchar* _tmp302_;
					gchar* _tmp303_;
					gchar* _tmp304_;
					gchar* _tmp305_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp296_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp297_ = _tmp296_;
					_tmp298_ = vala_member_access_get_inner (self);
					_tmp299_ = _tmp298_;
					_tmp300_ = vala_expression_get_symbol_reference (_tmp299_);
					_tmp301_ = _tmp300_;
					_tmp302_ = vala_symbol_get_full_name (_tmp301_);
					_tmp303_ = _tmp302_;
					_tmp304_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp303_);
					_tmp305_ = _tmp304_;
					vala_report_error (_tmp297_, _tmp305_);
					_g_free0 (_tmp305_);
					_g_free0 (_tmp303_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp307_ = vala_member_access_get_inner (self);
			_tmp308_ = _tmp307_;
			if (VALA_IS_CAST_EXPRESSION (_tmp308_)) {
				ValaExpression* _tmp309_;
				ValaExpression* _tmp310_;
				gboolean _tmp311_;
				gboolean _tmp312_;
				_tmp309_ = vala_member_access_get_inner (self);
				_tmp310_ = _tmp309_;
				_tmp311_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp310_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp312_ = _tmp311_;
				_tmp306_ = _tmp312_;
			} else {
				_tmp306_ = FALSE;
			}
			if (_tmp306_) {
				ValaSourceReference* _tmp313_;
				ValaSourceReference* _tmp314_;
				_tmp313_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp314_ = _tmp313_;
				vala_report_warning (_tmp314_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp316_ = vala_member_access_get_inner (self);
			_tmp317_ = _tmp316_;
			if (VALA_IS_MEMBER_ACCESS (_tmp317_)) {
				_tmp315_ = TRUE;
			} else {
				ValaExpression* _tmp318_;
				ValaExpression* _tmp319_;
				_tmp318_ = vala_member_access_get_inner (self);
				_tmp319_ = _tmp318_;
				_tmp315_ = VALA_IS_BASE_ACCESS (_tmp319_);
			}
			if (_tmp315_) {
				ValaExpression* _tmp320_;
				ValaExpression* _tmp321_;
				ValaSymbol* _tmp322_;
				ValaSymbol* _tmp323_;
				gboolean _tmp324_ = FALSE;
				ValaSymbol* _tmp325_;
				ValaSymbol* _tmp326_;
				_tmp320_ = vala_member_access_get_inner (self);
				_tmp321_ = _tmp320_;
				_tmp322_ = vala_expression_get_symbol_reference (_tmp321_);
				_tmp323_ = _tmp322_;
				base_symbol = _tmp323_;
				_tmp325_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp326_ = _tmp325_;
				if (_tmp326_ == NULL) {
					gboolean _tmp327_ = FALSE;
					ValaSymbol* _tmp328_;
					_tmp328_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp328_)) {
						_tmp327_ = TRUE;
					} else {
						ValaSymbol* _tmp329_;
						_tmp329_ = base_symbol;
						_tmp327_ = VALA_IS_TYPESYMBOL (_tmp329_);
					}
					_tmp324_ = _tmp327_;
				} else {
					_tmp324_ = FALSE;
				}
				if (_tmp324_) {
					ValaSymbol* _tmp330_;
					ValaScope* _tmp331_;
					ValaScope* _tmp332_;
					const gchar* _tmp333_;
					ValaSymbol* _tmp334_;
					ValaSymbol* _tmp335_;
					ValaExpression* _tmp336_;
					ValaExpression* _tmp337_;
					_tmp330_ = base_symbol;
					_tmp331_ = vala_symbol_get_scope (_tmp330_);
					_tmp332_ = _tmp331_;
					_tmp333_ = self->priv->_member_name;
					_tmp334_ = vala_scope_lookup (_tmp332_, _tmp333_);
					_tmp335_ = _tmp334_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp335_);
					_vala_code_node_unref0 (_tmp335_);
					_tmp336_ = vala_member_access_get_inner (self);
					_tmp337_ = _tmp336_;
					if (VALA_IS_BASE_ACCESS (_tmp337_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp339_ = vala_member_access_get_inner (self);
			_tmp340_ = _tmp339_;
			if (VALA_IS_MEMBER_ACCESS (_tmp340_)) {
				ValaExpression* _tmp341_;
				ValaExpression* _tmp342_;
				ValaSymbol* _tmp343_;
				ValaSymbol* _tmp344_;
				_tmp341_ = vala_member_access_get_inner (self);
				_tmp342_ = _tmp341_;
				_tmp343_ = vala_expression_get_symbol_reference (_tmp342_);
				_tmp344_ = _tmp343_;
				_tmp338_ = VALA_IS_TYPEPARAMETER (_tmp344_);
			} else {
				_tmp338_ = FALSE;
			}
			if (_tmp338_) {
				ValaExpression* _tmp345_;
				ValaExpression* _tmp346_;
				ValaExpression* _tmp347_;
				ValaExpression* _tmp348_;
				ValaSymbol* _tmp349_;
				ValaSymbol* _tmp350_;
				ValaGenericType* _tmp351_;
				ValaGenericType* _tmp352_;
				ValaExpression* _tmp353_;
				ValaExpression* _tmp354_;
				ValaDataType* _tmp355_;
				ValaDataType* _tmp356_;
				ValaSourceReference* _tmp357_;
				ValaSourceReference* _tmp358_;
				_tmp345_ = vala_member_access_get_inner (self);
				_tmp346_ = _tmp345_;
				_tmp347_ = vala_member_access_get_inner (self);
				_tmp348_ = _tmp347_;
				_tmp349_ = vala_expression_get_symbol_reference (_tmp348_);
				_tmp350_ = _tmp349_;
				_tmp351_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp350_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp352_ = _tmp351_;
				vala_expression_set_value_type (_tmp346_, (ValaDataType*) _tmp352_);
				_vala_code_node_unref0 (_tmp352_);
				_tmp353_ = vala_member_access_get_inner (self);
				_tmp354_ = _tmp353_;
				_tmp355_ = vala_expression_get_value_type (_tmp354_);
				_tmp356_ = _tmp355_;
				_tmp357_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp358_ = _tmp357_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp356_, _tmp358_);
			}
			_tmp360_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp361_ = _tmp360_;
			if (_tmp361_ == NULL) {
				ValaExpression* _tmp362_;
				ValaExpression* _tmp363_;
				ValaDataType* _tmp364_;
				ValaDataType* _tmp365_;
				_tmp362_ = vala_member_access_get_inner (self);
				_tmp363_ = _tmp362_;
				_tmp364_ = vala_expression_get_value_type (_tmp363_);
				_tmp365_ = _tmp364_;
				_tmp359_ = _tmp365_ != NULL;
			} else {
				_tmp359_ = FALSE;
			}
			if (_tmp359_) {
				gboolean _tmp366_;
				ValaSymbol* _tmp393_;
				ValaSymbol* _tmp394_;
				_tmp366_ = self->priv->_pointer_member_access;
				if (_tmp366_) {
					ValaExpression* _tmp367_;
					ValaExpression* _tmp368_;
					ValaDataType* _tmp369_;
					ValaDataType* _tmp370_;
					const gchar* _tmp371_;
					ValaSymbol* _tmp372_;
					ValaSymbol* _tmp373_;
					_tmp367_ = vala_member_access_get_inner (self);
					_tmp368_ = _tmp367_;
					_tmp369_ = vala_expression_get_value_type (_tmp368_);
					_tmp370_ = _tmp369_;
					_tmp371_ = self->priv->_member_name;
					_tmp372_ = vala_data_type_get_pointer_member (_tmp370_, _tmp371_);
					_tmp373_ = _tmp372_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp373_);
					_vala_code_node_unref0 (_tmp373_);
				} else {
					ValaExpression* _tmp374_;
					ValaExpression* _tmp375_;
					ValaDataType* _tmp376_;
					ValaDataType* _tmp377_;
					ValaTypeSymbol* _tmp378_;
					ValaTypeSymbol* _tmp379_;
					ValaExpression* _tmp386_;
					ValaExpression* _tmp387_;
					ValaDataType* _tmp388_;
					ValaDataType* _tmp389_;
					const gchar* _tmp390_;
					ValaSymbol* _tmp391_;
					ValaSymbol* _tmp392_;
					_tmp374_ = vala_member_access_get_inner (self);
					_tmp375_ = _tmp374_;
					_tmp376_ = vala_expression_get_value_type (_tmp375_);
					_tmp377_ = _tmp376_;
					_tmp378_ = vala_data_type_get_type_symbol (_tmp377_);
					_tmp379_ = _tmp378_;
					if (_tmp379_ != NULL) {
						ValaExpression* _tmp380_;
						ValaExpression* _tmp381_;
						ValaDataType* _tmp382_;
						ValaDataType* _tmp383_;
						ValaTypeSymbol* _tmp384_;
						ValaTypeSymbol* _tmp385_;
						_tmp380_ = vala_member_access_get_inner (self);
						_tmp381_ = _tmp380_;
						_tmp382_ = vala_expression_get_value_type (_tmp381_);
						_tmp383_ = _tmp382_;
						_tmp384_ = vala_data_type_get_type_symbol (_tmp383_);
						_tmp385_ = _tmp384_;
						base_symbol = (ValaSymbol*) _tmp385_;
					}
					_tmp386_ = vala_member_access_get_inner (self);
					_tmp387_ = _tmp386_;
					_tmp388_ = vala_expression_get_value_type (_tmp387_);
					_tmp389_ = _tmp388_;
					_tmp390_ = self->priv->_member_name;
					_tmp391_ = vala_data_type_get_member (_tmp389_, _tmp390_);
					_tmp392_ = _tmp391_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp392_);
					_vala_code_node_unref0 (_tmp392_);
				}
				_tmp393_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp394_ = _tmp393_;
				if (_tmp394_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp397_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp398_ = _tmp397_;
			if (_tmp398_ == NULL) {
				ValaExpression* _tmp399_;
				ValaExpression* _tmp400_;
				ValaDataType* _tmp401_;
				ValaDataType* _tmp402_;
				_tmp399_ = vala_member_access_get_inner (self);
				_tmp400_ = _tmp399_;
				_tmp401_ = vala_expression_get_value_type (_tmp400_);
				_tmp402_ = _tmp401_;
				_tmp396_ = _tmp402_ != NULL;
			} else {
				_tmp396_ = FALSE;
			}
			if (_tmp396_) {
				ValaExpression* _tmp403_;
				ValaExpression* _tmp404_;
				ValaDataType* _tmp405_;
				ValaDataType* _tmp406_;
				gboolean _tmp407_;
				gboolean _tmp408_;
				_tmp403_ = vala_member_access_get_inner (self);
				_tmp404_ = _tmp403_;
				_tmp405_ = vala_expression_get_value_type (_tmp404_);
				_tmp406_ = _tmp405_;
				_tmp407_ = vala_data_type_get_is_dynamic (_tmp406_);
				_tmp408_ = _tmp407_;
				_tmp395_ = _tmp408_;
			} else {
				_tmp395_ = FALSE;
			}
			if (_tmp395_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp409_;
				ValaExpression* _tmp410_;
				ValaDataType* _tmp411_;
				ValaDataType* _tmp412_;
				ValaObjectType* _tmp413_;
				ValaCodeNode* _tmp414_;
				ValaCodeNode* _tmp415_;
				ValaSymbol* _tmp581_;
				ValaSymbol* _tmp582_;
				ValaSymbol* _tmp631_;
				ValaSymbol* _tmp632_;
				_tmp409_ = vala_member_access_get_inner (self);
				_tmp410_ = _tmp409_;
				_tmp411_ = vala_expression_get_value_type (_tmp410_);
				_tmp412_ = _tmp411_;
				_tmp413_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp412_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp413_;
				_tmp414_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp415_ = _tmp414_;
				if (VALA_IS_METHOD_CALL (_tmp415_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp416_;
					ValaCodeNode* _tmp417_;
					ValaMethodCall* _tmp418_;
					ValaExpression* _tmp419_;
					ValaExpression* _tmp420_;
					_tmp416_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp417_ = _tmp416_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp417_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp418_ = invoc;
					_tmp419_ = vala_method_call_get_call (_tmp418_);
					_tmp420_ = _tmp419_;
					if (_tmp420_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp421_;
						ValaDataType* _tmp422_;
						ValaDataType* _tmp423_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp438_;
						ValaExpression* _tmp439_;
						ValaDataType* _tmp440_;
						ValaDataType* _tmp441_;
						const gchar* _tmp442_;
						ValaDataType* _tmp443_;
						ValaSourceReference* _tmp444_;
						ValaSourceReference* _tmp445_;
						ValaDynamicMethod* _tmp446_;
						ValaDynamicMethod* _tmp447_;
						ValaMethodCall* _tmp448_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp449_;
						ValaErrorType* _tmp450_;
						ValaDynamicMethod* _tmp451_;
						ValaErrorType* _tmp452_;
						ValaDynamicMethod* _tmp453_;
						ValaDynamicMethod* _tmp454_;
						ValaParameter* _tmp455_;
						ValaParameter* _tmp456_;
						ValaDynamicMethod* _tmp457_;
						ValaObjectType* _tmp458_;
						ValaDataType* _tmp459_;
						ValaDataType* _tmp460_;
						ValaDynamicMethod* _tmp461_;
						ValaSourceReference* _tmp462_;
						ValaSourceReference* _tmp463_;
						ValaParameter* _tmp464_;
						ValaParameter* _tmp465_;
						ValaObjectType* _tmp466_;
						ValaTypeSymbol* _tmp467_;
						ValaTypeSymbol* _tmp468_;
						ValaScope* _tmp469_;
						ValaScope* _tmp470_;
						ValaDynamicMethod* _tmp471_;
						ValaDynamicMethod* _tmp472_;
						_tmp421_ = invoc;
						_tmp422_ = vala_expression_get_target_type ((ValaExpression*) _tmp421_);
						_tmp423_ = _tmp422_;
						if (_tmp423_ != NULL) {
							ValaMethodCall* _tmp424_;
							ValaDataType* _tmp425_;
							ValaDataType* _tmp426_;
							ValaDataType* _tmp427_;
							ValaDataType* _tmp428_;
							_tmp424_ = invoc;
							_tmp425_ = vala_expression_get_target_type ((ValaExpression*) _tmp424_);
							_tmp426_ = _tmp425_;
							_tmp427_ = vala_data_type_copy (_tmp426_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp427_;
							_tmp428_ = ret_type;
							vala_data_type_set_value_owned (_tmp428_, TRUE);
						} else {
							ValaMethodCall* _tmp429_;
							ValaCodeNode* _tmp430_;
							ValaCodeNode* _tmp431_;
							_tmp429_ = invoc;
							_tmp430_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp429_);
							_tmp431_ = _tmp430_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp431_)) {
								ValaVoidType* _tmp432_;
								_tmp432_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp432_;
							} else {
								ValaExpression* _tmp433_;
								ValaExpression* _tmp434_;
								ValaDataType* _tmp435_;
								ValaDataType* _tmp436_;
								ValaDataType* _tmp437_;
								_tmp433_ = vala_member_access_get_inner (self);
								_tmp434_ = _tmp433_;
								_tmp435_ = vala_expression_get_value_type (_tmp434_);
								_tmp436_ = _tmp435_;
								_tmp437_ = vala_data_type_copy (_tmp436_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp437_;
							}
						}
						_tmp438_ = vala_member_access_get_inner (self);
						_tmp439_ = _tmp438_;
						_tmp440_ = vala_expression_get_value_type (_tmp439_);
						_tmp441_ = _tmp440_;
						_tmp442_ = self->priv->_member_name;
						_tmp443_ = ret_type;
						_tmp444_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp445_ = _tmp444_;
						_tmp446_ = vala_dynamic_method_new (_tmp441_, _tmp442_, _tmp443_, _tmp445_, NULL);
						m = _tmp446_;
						_tmp447_ = m;
						_tmp448_ = invoc;
						vala_dynamic_method_set_invocation (_tmp447_, _tmp448_);
						_tmp449_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp449_;
						_tmp450_ = err;
						vala_error_type_set_dynamic_error (_tmp450_, TRUE);
						_tmp451_ = m;
						_tmp452_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp451_, (ValaDataType*) _tmp452_);
						_tmp453_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp453_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp454_ = m;
						_tmp455_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp456_ = _tmp455_;
						vala_callable_add_parameter ((ValaCallable*) _tmp454_, _tmp456_);
						_vala_code_node_unref0 (_tmp456_);
						_tmp457_ = m;
						_tmp458_ = dynamic_object_type;
						_tmp459_ = vala_data_type_copy ((ValaDataType*) _tmp458_);
						_tmp460_ = _tmp459_;
						_tmp461_ = m;
						_tmp462_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp461_);
						_tmp463_ = _tmp462_;
						_tmp464_ = vala_parameter_new ("this", _tmp460_, _tmp463_);
						_tmp465_ = _tmp464_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp457_, _tmp465_);
						_vala_code_node_unref0 (_tmp465_);
						_vala_code_node_unref0 (_tmp460_);
						_tmp466_ = dynamic_object_type;
						_tmp467_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp466_);
						_tmp468_ = _tmp467_;
						_tmp469_ = vala_symbol_get_scope ((ValaSymbol*) _tmp468_);
						_tmp470_ = _tmp469_;
						_tmp471_ = m;
						vala_scope_add (_tmp470_, NULL, (ValaSymbol*) _tmp471_);
						_tmp472_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp472_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp473_;
					ValaCodeNode* _tmp474_;
					_tmp473_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp474_ = _tmp473_;
					if (VALA_IS_ASSIGNMENT (_tmp474_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp475_;
						ValaCodeNode* _tmp476_;
						ValaAssignment* _tmp477_;
						ValaExpression* _tmp478_;
						ValaExpression* _tmp479_;
						_tmp475_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp476_ = _tmp475_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp476_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp477_ = a;
						_tmp478_ = vala_assignment_get_left (_tmp477_);
						_tmp479_ = _tmp478_;
						if (_tmp479_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp480_;
							ValaExpression* _tmp481_;
							ValaDataType* _tmp482_;
							ValaDataType* _tmp483_;
							const gchar* _tmp484_;
							ValaSourceReference* _tmp485_;
							ValaSourceReference* _tmp486_;
							ValaDynamicProperty* _tmp487_;
							ValaDynamicProperty* _tmp488_;
							ValaDynamicProperty* _tmp489_;
							ValaDynamicProperty* _tmp490_;
							ValaSourceReference* _tmp491_;
							ValaSourceReference* _tmp492_;
							ValaPropertyAccessor* _tmp493_;
							ValaPropertyAccessor* _tmp494_;
							ValaDynamicProperty* _tmp495_;
							ValaExpression* _tmp496_;
							ValaExpression* _tmp497_;
							ValaDataType* _tmp498_;
							ValaDataType* _tmp499_;
							ValaTypeSymbol* _tmp500_;
							ValaTypeSymbol* _tmp501_;
							ValaScope* _tmp502_;
							ValaScope* _tmp503_;
							ValaObjectType* _tmp504_;
							ValaTypeSymbol* _tmp505_;
							ValaTypeSymbol* _tmp506_;
							ValaScope* _tmp507_;
							ValaScope* _tmp508_;
							ValaDynamicProperty* _tmp509_;
							ValaDynamicProperty* _tmp510_;
							_tmp480_ = vala_member_access_get_inner (self);
							_tmp481_ = _tmp480_;
							_tmp482_ = vala_expression_get_value_type (_tmp481_);
							_tmp483_ = _tmp482_;
							_tmp484_ = self->priv->_member_name;
							_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp486_ = _tmp485_;
							_tmp487_ = vala_dynamic_property_new (_tmp483_, _tmp484_, _tmp486_, NULL);
							prop = _tmp487_;
							_tmp488_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp488_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp489_ = prop;
							_tmp490_ = prop;
							_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp490_);
							_tmp492_ = _tmp491_;
							_tmp493_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp492_, NULL);
							_tmp494_ = _tmp493_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp489_, _tmp494_);
							_vala_code_node_unref0 (_tmp494_);
							_tmp495_ = prop;
							_tmp496_ = vala_member_access_get_inner (self);
							_tmp497_ = _tmp496_;
							_tmp498_ = vala_expression_get_value_type (_tmp497_);
							_tmp499_ = _tmp498_;
							_tmp500_ = vala_data_type_get_type_symbol (_tmp499_);
							_tmp501_ = _tmp500_;
							_tmp502_ = vala_symbol_get_scope ((ValaSymbol*) _tmp501_);
							_tmp503_ = _tmp502_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp495_, _tmp503_);
							_tmp504_ = dynamic_object_type;
							_tmp505_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp504_);
							_tmp506_ = _tmp505_;
							_tmp507_ = vala_symbol_get_scope ((ValaSymbol*) _tmp506_);
							_tmp508_ = _tmp507_;
							_tmp509_ = prop;
							vala_scope_add (_tmp508_, NULL, (ValaSymbol*) _tmp509_);
							_tmp510_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp510_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp511_ = FALSE;
						gboolean _tmp512_ = FALSE;
						ValaCodeNode* _tmp513_;
						ValaCodeNode* _tmp514_;
						_tmp513_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp514_ = _tmp513_;
						if (VALA_IS_MEMBER_ACCESS (_tmp514_)) {
							ValaExpression* _tmp515_;
							ValaExpression* _tmp516_;
							_tmp515_ = vala_member_access_get_inner (self);
							_tmp516_ = _tmp515_;
							_tmp512_ = VALA_IS_MEMBER_ACCESS (_tmp516_);
						} else {
							_tmp512_ = FALSE;
						}
						if (_tmp512_) {
							ValaCodeNode* _tmp517_;
							ValaCodeNode* _tmp518_;
							ValaCodeNode* _tmp519_;
							ValaCodeNode* _tmp520_;
							_tmp517_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp518_ = _tmp517_;
							_tmp519_ = vala_code_node_get_parent_node (_tmp518_);
							_tmp520_ = _tmp519_;
							_tmp511_ = VALA_IS_METHOD_CALL (_tmp520_);
						} else {
							_tmp511_ = FALSE;
						}
						if (_tmp511_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp521_;
							ValaCodeNode* _tmp522_;
							gboolean _tmp523_ = FALSE;
							ValaMemberAccess* _tmp524_;
							const gchar* _tmp525_;
							_tmp521_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp522_ = _tmp521_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp522_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp524_ = ma;
							_tmp525_ = _tmp524_->priv->_member_name;
							if (g_strcmp0 (_tmp525_, "connect") == 0) {
								_tmp523_ = TRUE;
							} else {
								ValaMemberAccess* _tmp526_;
								const gchar* _tmp527_;
								_tmp526_ = ma;
								_tmp527_ = _tmp526_->priv->_member_name;
								_tmp523_ = g_strcmp0 (_tmp527_, "connect_after") == 0;
							}
							if (_tmp523_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp528_;
								ValaExpression* _tmp529_;
								ValaDataType* _tmp530_;
								ValaDataType* _tmp531_;
								const gchar* _tmp532_;
								ValaVoidType* _tmp533_;
								ValaVoidType* _tmp534_;
								ValaSourceReference* _tmp535_;
								ValaSourceReference* _tmp536_;
								ValaDynamicSignal* _tmp537_;
								ValaDynamicSignal* _tmp538_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp539_;
								ValaCodeNode* _tmp540_;
								ValaCodeNode* _tmp541_;
								ValaCodeNode* _tmp542_;
								ValaMethodCall* _tmp543_;
								ValaMethodCall* _tmp544_;
								ValaList* _tmp545_;
								gint _tmp546_;
								gint _tmp547_;
								ValaDynamicSignal* _tmp573_;
								ValaObjectType* _tmp574_;
								ValaTypeSymbol* _tmp575_;
								ValaTypeSymbol* _tmp576_;
								ValaScope* _tmp577_;
								ValaScope* _tmp578_;
								ValaDynamicSignal* _tmp579_;
								ValaDynamicSignal* _tmp580_;
								_tmp528_ = vala_member_access_get_inner (self);
								_tmp529_ = _tmp528_;
								_tmp530_ = vala_expression_get_value_type (_tmp529_);
								_tmp531_ = _tmp530_;
								_tmp532_ = self->priv->_member_name;
								_tmp533_ = vala_void_type_new (NULL);
								_tmp534_ = _tmp533_;
								_tmp535_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp536_ = _tmp535_;
								_tmp537_ = vala_dynamic_signal_new (_tmp531_, _tmp532_, (ValaDataType*) _tmp534_, _tmp536_, NULL);
								_tmp538_ = _tmp537_;
								_vala_code_node_unref0 (_tmp534_);
								s = _tmp538_;
								_tmp539_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp540_ = _tmp539_;
								_tmp541_ = vala_code_node_get_parent_node (_tmp540_);
								_tmp542_ = _tmp541_;
								_tmp543_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp542_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp543_;
								_tmp544_ = mcall;
								_tmp545_ = vala_method_call_get_argument_list (_tmp544_);
								_tmp546_ = vala_collection_get_size ((ValaCollection*) _tmp545_);
								_tmp547_ = _tmp546_;
								if (_tmp547_ > 0) {
									ValaDynamicSignal* _tmp548_;
									ValaMethodCall* _tmp549_;
									ValaList* _tmp550_;
									gpointer _tmp551_;
									ValaExpression* _tmp552_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp553_;
									ValaExpression* _tmp554_;
									ValaExpression* _tmp555_;
									gboolean _tmp556_ = FALSE;
									gboolean _tmp557_ = FALSE;
									ValaMemberAccess* _tmp558_;
									_tmp548_ = s;
									_tmp549_ = mcall;
									_tmp550_ = vala_method_call_get_argument_list (_tmp549_);
									_tmp551_ = vala_list_get (_tmp550_, 0);
									_tmp552_ = (ValaExpression*) _tmp551_;
									vala_dynamic_signal_set_handler (_tmp548_, _tmp552_);
									_vala_code_node_unref0 (_tmp552_);
									_tmp553_ = s;
									_tmp554_ = vala_dynamic_signal_get_handler (_tmp553_);
									_tmp555_ = _tmp554_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp555_) ? ((ValaMemberAccess*) _tmp555_) : NULL;
									_tmp558_ = arg;
									if (_tmp558_ == NULL) {
										_tmp557_ = TRUE;
									} else {
										ValaMemberAccess* _tmp559_;
										_tmp559_ = arg;
										_tmp557_ = !vala_code_node_check ((ValaCodeNode*) _tmp559_, context);
									}
									if (_tmp557_) {
										_tmp556_ = TRUE;
									} else {
										ValaMemberAccess* _tmp560_;
										ValaSymbol* _tmp561_;
										ValaSymbol* _tmp562_;
										_tmp560_ = arg;
										_tmp561_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp560_);
										_tmp562_ = _tmp561_;
										_tmp556_ = !VALA_IS_METHOD (_tmp562_);
									}
									if (_tmp556_) {
										ValaDynamicSignal* _tmp563_;
										ValaExpression* _tmp564_;
										ValaExpression* _tmp565_;
										ValaSourceReference* _tmp566_;
										ValaSourceReference* _tmp567_;
										ValaDynamicSignal* _tmp568_;
										gchar* _tmp569_;
										gchar* _tmp570_;
										gchar* _tmp571_;
										gchar* _tmp572_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp563_ = s;
										_tmp564_ = vala_dynamic_signal_get_handler (_tmp563_);
										_tmp565_ = _tmp564_;
										_tmp566_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp565_);
										_tmp567_ = _tmp566_;
										_tmp568_ = s;
										_tmp569_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp568_);
										_tmp570_ = _tmp569_;
										_tmp571_ = g_strdup_printf ("Invalid handler for `%s'", _tmp570_);
										_tmp572_ = _tmp571_;
										vala_report_error (_tmp567_, _tmp572_);
										_g_free0 (_tmp572_);
										_g_free0 (_tmp570_);
									}
								}
								_tmp573_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp573_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp574_ = dynamic_object_type;
								_tmp575_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp574_);
								_tmp576_ = _tmp575_;
								_tmp577_ = vala_symbol_get_scope ((ValaSymbol*) _tmp576_);
								_tmp578_ = _tmp577_;
								_tmp579_ = s;
								vala_scope_add (_tmp578_, NULL, (ValaSymbol*) _tmp579_);
								_tmp580_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp580_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp581_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp582_ = _tmp581_;
				if (_tmp582_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp583_;
					ValaExpression* _tmp584_;
					ValaDataType* _tmp585_;
					ValaDataType* _tmp586_;
					const gchar* _tmp587_;
					ValaSourceReference* _tmp588_;
					ValaSourceReference* _tmp589_;
					ValaDynamicProperty* _tmp590_;
					ValaDataType* _tmp591_;
					ValaDataType* _tmp592_;
					ValaDynamicProperty* _tmp603_;
					ValaDynamicProperty* _tmp604_;
					ValaDynamicProperty* _tmp605_;
					ValaDataType* _tmp606_;
					ValaDataType* _tmp607_;
					ValaDataType* _tmp608_;
					ValaDataType* _tmp609_;
					ValaDynamicProperty* _tmp610_;
					ValaSourceReference* _tmp611_;
					ValaSourceReference* _tmp612_;
					ValaPropertyAccessor* _tmp613_;
					ValaPropertyAccessor* _tmp614_;
					ValaDynamicProperty* _tmp615_;
					ValaExpression* _tmp616_;
					ValaExpression* _tmp617_;
					ValaDataType* _tmp618_;
					ValaDataType* _tmp619_;
					ValaTypeSymbol* _tmp620_;
					ValaTypeSymbol* _tmp621_;
					ValaScope* _tmp622_;
					ValaScope* _tmp623_;
					ValaObjectType* _tmp624_;
					ValaTypeSymbol* _tmp625_;
					ValaTypeSymbol* _tmp626_;
					ValaScope* _tmp627_;
					ValaScope* _tmp628_;
					ValaDynamicProperty* _tmp629_;
					ValaDynamicProperty* _tmp630_;
					_tmp583_ = vala_member_access_get_inner (self);
					_tmp584_ = _tmp583_;
					_tmp585_ = vala_expression_get_value_type (_tmp584_);
					_tmp586_ = _tmp585_;
					_tmp587_ = self->priv->_member_name;
					_tmp588_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp589_ = _tmp588_;
					_tmp590_ = vala_dynamic_property_new (_tmp586_, _tmp587_, _tmp589_, NULL);
					prop = _tmp590_;
					_tmp591_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp592_ = _tmp591_;
					if (_tmp592_ != NULL) {
						ValaDynamicProperty* _tmp593_;
						ValaDataType* _tmp594_;
						ValaDataType* _tmp595_;
						_tmp593_ = prop;
						_tmp594_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp595_ = _tmp594_;
						vala_property_set_property_type ((ValaProperty*) _tmp593_, _tmp595_);
					} else {
						ValaDynamicProperty* _tmp596_;
						ValaExpression* _tmp597_;
						ValaExpression* _tmp598_;
						ValaDataType* _tmp599_;
						ValaDataType* _tmp600_;
						ValaDataType* _tmp601_;
						ValaDataType* _tmp602_;
						_tmp596_ = prop;
						_tmp597_ = vala_member_access_get_inner (self);
						_tmp598_ = _tmp597_;
						_tmp599_ = vala_expression_get_value_type (_tmp598_);
						_tmp600_ = _tmp599_;
						_tmp601_ = vala_data_type_copy (_tmp600_);
						_tmp602_ = _tmp601_;
						vala_property_set_property_type ((ValaProperty*) _tmp596_, _tmp602_);
						_vala_code_node_unref0 (_tmp602_);
					}
					_tmp603_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp603_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp604_ = prop;
					_tmp605_ = prop;
					_tmp606_ = vala_property_get_property_type ((ValaProperty*) _tmp605_);
					_tmp607_ = _tmp606_;
					_tmp608_ = vala_data_type_copy (_tmp607_);
					_tmp609_ = _tmp608_;
					_tmp610_ = prop;
					_tmp611_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp610_);
					_tmp612_ = _tmp611_;
					_tmp613_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp609_, NULL, _tmp612_, NULL);
					_tmp614_ = _tmp613_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp604_, _tmp614_);
					_vala_code_node_unref0 (_tmp614_);
					_vala_code_node_unref0 (_tmp609_);
					_tmp615_ = prop;
					_tmp616_ = vala_member_access_get_inner (self);
					_tmp617_ = _tmp616_;
					_tmp618_ = vala_expression_get_value_type (_tmp617_);
					_tmp619_ = _tmp618_;
					_tmp620_ = vala_data_type_get_type_symbol (_tmp619_);
					_tmp621_ = _tmp620_;
					_tmp622_ = vala_symbol_get_scope ((ValaSymbol*) _tmp621_);
					_tmp623_ = _tmp622_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp615_, _tmp623_);
					_tmp624_ = dynamic_object_type;
					_tmp625_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp624_);
					_tmp626_ = _tmp625_;
					_tmp627_ = vala_symbol_get_scope ((ValaSymbol*) _tmp626_);
					_tmp628_ = _tmp627_;
					_tmp629_ = prop;
					vala_scope_add (_tmp628_, NULL, (ValaSymbol*) _tmp629_);
					_tmp630_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp630_);
					_vala_code_node_unref0 (prop);
				}
				_tmp631_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp632_ = _tmp631_;
				if (_tmp632_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp633_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp634_ = _tmp633_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp634_)) {
				ValaExpression* _tmp635_;
				ValaExpression* _tmp636_;
				ValaSymbol* _tmp637_;
				ValaSymbol* _tmp638_;
				_tmp635_ = vala_member_access_get_inner (self);
				_tmp636_ = _tmp635_;
				_tmp637_ = vala_expression_get_symbol_reference (_tmp636_);
				_tmp638_ = _tmp637_;
				if (VALA_IS_VARIABLE (_tmp638_)) {
					ValaArrayType* inner_type = NULL;
					ValaSemanticAnalyzer* _tmp639_;
					ValaSemanticAnalyzer* _tmp640_;
					ValaExpression* _tmp641_;
					ValaExpression* _tmp642_;
					ValaSymbol* _tmp643_;
					ValaSymbol* _tmp644_;
					ValaDataType* _tmp645_;
					ValaArrayType* _tmp646_;
					gboolean _tmp647_ = FALSE;
					ValaArrayType* _tmp648_;
					_tmp639_ = vala_code_context_get_analyzer (context);
					_tmp640_ = _tmp639_;
					_tmp641_ = vala_member_access_get_inner (self);
					_tmp642_ = _tmp641_;
					_tmp643_ = vala_expression_get_symbol_reference (_tmp642_);
					_tmp644_ = _tmp643_;
					_tmp645_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp640_, _tmp644_, TRUE);
					_tmp646_ = VALA_IS_ARRAY_TYPE (_tmp645_) ? ((ValaArrayType*) _tmp645_) : NULL;
					if (_tmp646_ == NULL) {
						_vala_code_node_unref0 (_tmp645_);
					}
					inner_type = _tmp646_;
					_tmp648_ = inner_type;
					if (_tmp648_ != NULL) {
						ValaArrayType* _tmp649_;
						gboolean _tmp650_;
						gboolean _tmp651_;
						_tmp649_ = inner_type;
						_tmp650_ = vala_array_type_get_inline_allocated (_tmp649_);
						_tmp651_ = _tmp650_;
						_tmp647_ = _tmp651_;
					} else {
						_tmp647_ = FALSE;
					}
					if (_tmp647_) {
						ValaSourceReference* _tmp652_;
						ValaSourceReference* _tmp653_;
						_tmp652_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp653_ = _tmp652_;
						vala_report_error (_tmp653_, "`resize' is not supported for arrays with fixed length");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					} else {
						gboolean _tmp654_ = FALSE;
						ValaArrayType* _tmp655_;
						_tmp655_ = inner_type;
						if (_tmp655_ != NULL) {
							ValaArrayType* _tmp656_;
							gboolean _tmp657_;
							gboolean _tmp658_;
							_tmp656_ = inner_type;
							_tmp657_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp656_);
							_tmp658_ = _tmp657_;
							_tmp654_ = !_tmp658_;
						} else {
							_tmp654_ = FALSE;
						}
						if (_tmp654_) {
							ValaSourceReference* _tmp659_;
							ValaSourceReference* _tmp660_;
							_tmp659_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp660_ = _tmp659_;
							vala_report_error (_tmp660_, "`resize' is not allowed for unowned array references");
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						}
					}
					_vala_code_node_unref0 (inner_type);
				} else {
					ValaExpression* _tmp661_;
					ValaExpression* _tmp662_;
					ValaSymbol* _tmp663_;
					ValaSymbol* _tmp664_;
					_tmp661_ = vala_member_access_get_inner (self);
					_tmp662_ = _tmp661_;
					_tmp663_ = vala_expression_get_symbol_reference (_tmp662_);
					_tmp664_ = _tmp663_;
					if (VALA_IS_CONSTANT (_tmp664_)) {
						ValaSourceReference* _tmp665_;
						ValaSourceReference* _tmp666_;
						_tmp665_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp666_ = _tmp665_;
						vala_report_error (_tmp666_, "`resize' is not allowed for constant arrays");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
			}
		}
	}
	_tmp670_ = vala_member_access_get_inner (self);
	_tmp671_ = _tmp670_;
	if (_tmp671_ == NULL) {
		ValaSymbol* _tmp672_;
		ValaSymbol* _tmp673_;
		_tmp672_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp673_ = _tmp672_;
		_tmp669_ = _tmp673_ == NULL;
	} else {
		_tmp669_ = FALSE;
	}
	if (_tmp669_) {
		ValaDataType* _tmp674_;
		ValaDataType* _tmp675_;
		_tmp674_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp675_ = _tmp674_;
		_tmp668_ = _tmp675_ != NULL;
	} else {
		_tmp668_ = FALSE;
	}
	if (_tmp668_) {
		ValaDataType* _tmp676_;
		ValaDataType* _tmp677_;
		ValaTypeSymbol* _tmp678_;
		ValaTypeSymbol* _tmp679_;
		_tmp676_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp677_ = _tmp676_;
		_tmp678_ = vala_data_type_get_type_symbol (_tmp677_);
		_tmp679_ = _tmp678_;
		_tmp667_ = VALA_IS_ENUM (_tmp679_);
	} else {
		_tmp667_ = FALSE;
	}
	if (_tmp667_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp680_;
		ValaDataType* _tmp681_;
		ValaTypeSymbol* _tmp682_;
		ValaTypeSymbol* _tmp683_;
		_tmp680_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp681_ = _tmp680_;
		_tmp682_ = vala_data_type_get_type_symbol (_tmp681_);
		_tmp683_ = _tmp682_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp683_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp684_;
			ValaList* _tmp685_;
			ValaList* _tmp686_;
			gint _val_size = 0;
			ValaList* _tmp687_;
			gint _tmp688_;
			gint _tmp689_;
			gint _val_index = 0;
			_tmp684_ = enum_type;
			_tmp685_ = vala_enum_get_values (_tmp684_);
			_tmp686_ = _vala_iterable_ref0 (_tmp685_);
			_val_list = _tmp686_;
			_tmp687_ = _val_list;
			_tmp688_ = vala_collection_get_size ((ValaCollection*) _tmp687_);
			_tmp689_ = _tmp688_;
			_val_size = _tmp689_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp690_;
				gint _tmp691_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp692_;
				gpointer _tmp693_;
				const gchar* _tmp694_;
				ValaEnumValue* _tmp695_;
				const gchar* _tmp696_;
				const gchar* _tmp697_;
				_val_index = _val_index + 1;
				_tmp690_ = _val_index;
				_tmp691_ = _val_size;
				if (!(_tmp690_ < _tmp691_)) {
					break;
				}
				_tmp692_ = _val_list;
				_tmp693_ = vala_list_get (_tmp692_, _val_index);
				val = (ValaEnumValue*) _tmp693_;
				_tmp694_ = self->priv->_member_name;
				_tmp695_ = val;
				_tmp696_ = vala_symbol_get_name ((ValaSymbol*) _tmp695_);
				_tmp697_ = _tmp696_;
				if (g_strcmp0 (_tmp694_, _tmp697_) == 0) {
					ValaEnumValue* _tmp698_;
					_tmp698_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp698_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp699_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp700_ = _tmp699_;
	if (_tmp700_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp701_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp702_ = FALSE;
		ValaExpression* _tmp703_;
		ValaExpression* _tmp704_;
		gchar* base_type_package = NULL;
		gchar* _tmp724_;
		gboolean _tmp725_ = FALSE;
		ValaSymbol* _tmp726_;
		gchar* visited_types_string = NULL;
		gchar* _tmp741_;
		ValaSourceReference* _tmp758_;
		ValaSourceReference* _tmp759_;
		const gchar* _tmp760_;
		const gchar* _tmp761_;
		const gchar* _tmp762_;
		const gchar* _tmp763_;
		gchar* _tmp764_;
		gchar* _tmp765_;
		ValaInvalidType* _tmp766_;
		ValaInvalidType* _tmp767_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp701_ = g_strdup ("(null)");
		base_type_name = _tmp701_;
		base_type = NULL;
		_tmp703_ = vala_member_access_get_inner (self);
		_tmp704_ = _tmp703_;
		if (_tmp704_ != NULL) {
			ValaExpression* _tmp705_;
			ValaExpression* _tmp706_;
			ValaDataType* _tmp707_;
			ValaDataType* _tmp708_;
			_tmp705_ = vala_member_access_get_inner (self);
			_tmp706_ = _tmp705_;
			_tmp707_ = vala_expression_get_value_type (_tmp706_);
			_tmp708_ = _tmp707_;
			_tmp702_ = _tmp708_ != NULL;
		} else {
			_tmp702_ = FALSE;
		}
		if (_tmp702_) {
			ValaExpression* _tmp709_;
			ValaExpression* _tmp710_;
			ValaDataType* _tmp711_;
			ValaDataType* _tmp712_;
			gchar* _tmp713_;
			ValaExpression* _tmp714_;
			ValaExpression* _tmp715_;
			ValaDataType* _tmp716_;
			ValaDataType* _tmp717_;
			ValaTypeSymbol* _tmp718_;
			ValaTypeSymbol* _tmp719_;
			_tmp709_ = vala_member_access_get_inner (self);
			_tmp710_ = _tmp709_;
			_tmp711_ = vala_expression_get_value_type (_tmp710_);
			_tmp712_ = _tmp711_;
			_tmp713_ = vala_code_node_to_string ((ValaCodeNode*) _tmp712_);
			_g_free0 (base_type_name);
			base_type_name = _tmp713_;
			_tmp714_ = vala_member_access_get_inner (self);
			_tmp715_ = _tmp714_;
			_tmp716_ = vala_expression_get_value_type (_tmp715_);
			_tmp717_ = _tmp716_;
			_tmp718_ = vala_data_type_get_type_symbol (_tmp717_);
			_tmp719_ = _tmp718_;
			base_type = (ValaSymbol*) _tmp719_;
		} else {
			ValaSymbol* _tmp720_;
			_tmp720_ = base_symbol;
			if (_tmp720_ != NULL) {
				ValaSymbol* _tmp721_;
				gchar* _tmp722_;
				ValaSymbol* _tmp723_;
				_tmp721_ = base_symbol;
				_tmp722_ = vala_symbol_get_full_name (_tmp721_);
				_g_free0 (base_type_name);
				base_type_name = _tmp722_;
				_tmp723_ = base_symbol;
				base_type = _tmp723_;
			}
		}
		_tmp724_ = g_strdup ("");
		base_type_package = _tmp724_;
		_tmp726_ = base_type;
		if (_tmp726_ != NULL) {
			ValaSymbol* _tmp727_;
			gboolean _tmp728_;
			gboolean _tmp729_;
			_tmp727_ = base_type;
			_tmp728_ = vala_symbol_get_external_package (_tmp727_);
			_tmp729_ = _tmp728_;
			_tmp725_ = _tmp729_;
		} else {
			_tmp725_ = FALSE;
		}
		if (_tmp725_) {
			ValaSymbol* _tmp730_;
			ValaSourceReference* _tmp731_;
			ValaSourceReference* _tmp732_;
			ValaSourceFile* _tmp733_;
			ValaSourceFile* _tmp734_;
			const gchar* _tmp735_;
			const gchar* _tmp736_;
			gchar* _tmp737_;
			const gchar* _tmp738_;
			_tmp730_ = base_symbol;
			_tmp731_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp730_);
			_tmp732_ = _tmp731_;
			_tmp733_ = vala_source_reference_get_file (_tmp732_);
			_tmp734_ = _tmp733_;
			_tmp735_ = vala_source_file_get_package_name (_tmp734_);
			_tmp736_ = _tmp735_;
			_tmp737_ = g_strdup (_tmp736_);
			_g_free0 (base_type_package);
			base_type_package = _tmp737_;
			_tmp738_ = base_type_package;
			if (_tmp738_ != NULL) {
				const gchar* _tmp739_;
				gchar* _tmp740_;
				_tmp739_ = base_type_package;
				_tmp740_ = g_strdup_printf (" (%s)", _tmp739_);
				_g_free0 (base_type_package);
				base_type_package = _tmp740_;
			}
		}
		_tmp741_ = g_strdup ("");
		visited_types_string = _tmp741_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp742_;
			ValaArrayList* _tmp743_;
			gint _type_size = 0;
			ValaArrayList* _tmp744_;
			gint _tmp745_;
			gint _tmp746_;
			gint _type_index = 0;
			_tmp742_ = visited_types;
			_tmp743_ = _vala_iterable_ref0 (_tmp742_);
			_type_list = _tmp743_;
			_tmp744_ = _type_list;
			_tmp745_ = vala_collection_get_size ((ValaCollection*) _tmp744_);
			_tmp746_ = _tmp745_;
			_type_size = _tmp746_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp747_;
				gint _tmp748_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp749_;
				gpointer _tmp750_;
				const gchar* _tmp751_;
				ValaDataType* _tmp752_;
				gchar* _tmp753_;
				gchar* _tmp754_;
				gchar* _tmp755_;
				gchar* _tmp756_;
				gchar* _tmp757_;
				_type_index = _type_index + 1;
				_tmp747_ = _type_index;
				_tmp748_ = _type_size;
				if (!(_tmp747_ < _tmp748_)) {
					break;
				}
				_tmp749_ = _type_list;
				_tmp750_ = vala_list_get ((ValaList*) _tmp749_, _type_index);
				type = (ValaDataType*) _tmp750_;
				_tmp751_ = visited_types_string;
				_tmp752_ = type;
				_tmp753_ = vala_code_node_to_string ((ValaCodeNode*) _tmp752_);
				_tmp754_ = _tmp753_;
				_tmp755_ = g_strdup_printf (" or `%s'", _tmp754_);
				_tmp756_ = _tmp755_;
				_tmp757_ = g_strconcat (_tmp751_, _tmp756_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp757_;
				_g_free0 (_tmp756_);
				_g_free0 (_tmp754_);
				_vala_code_node_unref0 (type);
			}
			_vala_iterable_unref0 (_type_list);
		}
		_tmp758_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp759_ = _tmp758_;
		_tmp760_ = self->priv->_member_name;
		_tmp761_ = base_type_name;
		_tmp762_ = base_type_package;
		_tmp763_ = visited_types_string;
		_tmp764_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s%s", _tmp760_, _tmp761_, _tmp762_, _tmp763_);
		_tmp765_ = _tmp764_;
		vala_report_error (_tmp759_, _tmp765_);
		_g_free0 (_tmp765_);
		_tmp766_ = vala_invalid_type_new ();
		_tmp767_ = _tmp766_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp767_);
		_vala_code_node_unref0 (_tmp767_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp768_;
		ValaSymbol* _tmp769_;
		gboolean _tmp770_;
		gboolean _tmp771_;
		_tmp768_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp769_ = _tmp768_;
		_tmp770_ = vala_code_node_get_error ((ValaCodeNode*) _tmp769_);
		_tmp771_ = _tmp770_;
		if (_tmp771_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp772_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp773_ = _tmp772_;
	if (VALA_IS_SIGNAL (_tmp773_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp774_;
		ValaSymbol* _tmp775_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp782_;
		ValaCodeNode* _tmp783_;
		ValaCodeNode* _tmp784_;
		gboolean _tmp785_ = FALSE;
		gboolean _tmp786_ = FALSE;
		gboolean _tmp787_ = FALSE;
		ValaCodeNode* _tmp788_;
		_tmp774_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp775_ = _tmp774_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp775_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp776_;
			ValaCodeNode* _tmp777_;
			ValaCodeNode* _tmp778_;
			ValaCodeNode* _tmp779_;
			ValaCodeNode* _tmp780_;
			ValaCodeNode* _tmp781_;
			_tmp776_ = ma;
			_tmp777_ = vala_code_node_get_parent_node (_tmp776_);
			_tmp778_ = _tmp777_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp778_)) {
				break;
			}
			_tmp779_ = ma;
			_tmp780_ = vala_code_node_get_parent_node (_tmp779_);
			_tmp781_ = _tmp780_;
			ma = _tmp781_;
		}
		_tmp782_ = ma;
		_tmp783_ = vala_code_node_get_parent_node (_tmp782_);
		_tmp784_ = _tmp783_;
		parent = _tmp784_;
		_tmp788_ = parent;
		if (_tmp788_ != NULL) {
			ValaCodeNode* _tmp789_;
			_tmp789_ = parent;
			_tmp787_ = !VALA_IS_ELEMENT_ACCESS (_tmp789_);
		} else {
			_tmp787_ = FALSE;
		}
		if (_tmp787_) {
			ValaCodeNode* _tmp790_;
			ValaExpression* _tmp791_;
			ValaExpression* _tmp792_;
			_tmp790_ = ma;
			_tmp791_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp790_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp792_ = _tmp791_;
			_tmp786_ = !VALA_IS_BASE_ACCESS (_tmp792_);
		} else {
			_tmp786_ = FALSE;
		}
		if (_tmp786_) {
			gboolean _tmp793_ = FALSE;
			ValaCodeNode* _tmp794_;
			_tmp794_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp794_)) {
				_tmp793_ = TRUE;
			} else {
				ValaCodeNode* _tmp795_;
				ValaList* _tmp796_;
				_tmp795_ = parent;
				_tmp796_ = vala_method_call_get_argument_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp795_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp793_ = vala_collection_contains ((ValaCollection*) _tmp796_, (ValaExpression*) self);
			}
			_tmp785_ = _tmp793_;
		} else {
			_tmp785_ = FALSE;
		}
		if (_tmp785_) {
			ValaSignal* _tmp797_;
			ValaAttribute* _tmp798_;
			_tmp797_ = sig;
			_tmp798_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp797_, "HasEmitter");
			if (_tmp798_ != NULL) {
				ValaSignal* _tmp799_;
				ValaSignal* _tmp800_;
				ValaMethod* _tmp801_;
				ValaMethod* _tmp802_;
				_tmp799_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp799_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp800_ = sig;
				_tmp801_ = vala_signal_get_emitter (_tmp800_);
				_tmp802_ = _tmp801_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp802_);
			} else {
				ValaSourceReference* _tmp803_;
				ValaSourceReference* _tmp804_;
				ValaSymbol* _tmp805_;
				ValaSymbol* _tmp806_;
				gchar* _tmp807_;
				gchar* _tmp808_;
				gchar* _tmp809_;
				gchar* _tmp810_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp803_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp804_ = _tmp803_;
				_tmp805_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp806_ = _tmp805_;
				_tmp807_ = vala_symbol_get_full_name (_tmp806_);
				_tmp808_ = _tmp807_;
				_tmp809_ = g_strdup_printf ("Signal `%s' requires emitter in this context", _tmp808_);
				_tmp810_ = _tmp809_;
				vala_report_error (_tmp804_, _tmp810_);
				_g_free0 (_tmp810_);
				_g_free0 (_tmp808_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp811_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp812_ = _tmp811_;
	member = _tmp812_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp813_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp813_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp814_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp814_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp815_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp816_;
		ValaSymbol* _tmp817_;
		ValaSymbol* _tmp818_;
		gboolean _tmp819_ = FALSE;
		ValaBlock* _tmp820_;
		_tmp815_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp815_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp816_ = local;
		_tmp817_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp816_);
		_tmp818_ = _tmp817_;
		block = VALA_IS_BLOCK (_tmp818_) ? ((ValaBlock*) _tmp818_) : NULL;
		_tmp820_ = block;
		if (_tmp820_ != NULL) {
			ValaBlock* _tmp821_;
			ValaSymbol* _tmp822_;
			ValaSemanticAnalyzer* _tmp823_;
			ValaSemanticAnalyzer* _tmp824_;
			ValaSymbol* _tmp825_;
			ValaSymbol* _tmp826_;
			_tmp821_ = block;
			_tmp822_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp821_);
			_tmp823_ = vala_code_context_get_analyzer (context);
			_tmp824_ = _tmp823_;
			_tmp825_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp824_);
			_tmp826_ = _tmp825_;
			_tmp819_ = _tmp822_ != _tmp826_;
		} else {
			_tmp819_ = FALSE;
		}
		if (_tmp819_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp827_;
			ValaSemanticAnalyzer* _tmp828_;
			ValaSymbol* _tmp829_;
			ValaSymbol* _tmp830_;
			ValaLocalVariable* _tmp841_;
			ValaBlock* _tmp842_;
			ValaLocalVariable* _tmp843_;
			ValaDataType* _tmp844_;
			ValaDataType* _tmp845_;
			ValaTypeSymbol* _tmp846_;
			ValaTypeSymbol* _tmp847_;
			ValaSemanticAnalyzer* _tmp848_;
			ValaSemanticAnalyzer* _tmp849_;
			ValaDataType* _tmp850_;
			ValaTypeSymbol* _tmp851_;
			ValaTypeSymbol* _tmp852_;
			_tmp827_ = vala_code_context_get_analyzer (context);
			_tmp828_ = _tmp827_;
			_tmp829_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp828_);
			_tmp830_ = _tmp829_;
			sym = _tmp830_;
			while (TRUE) {
				ValaSymbol* _tmp831_;
				ValaBlock* _tmp832_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp833_;
				ValaMethod* _tmp834_;
				ValaSymbol* _tmp838_;
				ValaSymbol* _tmp839_;
				ValaSymbol* _tmp840_;
				_tmp831_ = sym;
				_tmp832_ = block;
				if (!(_tmp831_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp832_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp833_ = sym;
				method = VALA_IS_METHOD (_tmp833_) ? ((ValaMethod*) _tmp833_) : NULL;
				_tmp834_ = method;
				if (_tmp834_ != NULL) {
					ValaMethod* _tmp835_;
					ValaMethod* _tmp836_;
					ValaLocalVariable* _tmp837_;
					_tmp835_ = method;
					vala_method_set_closure (_tmp835_, TRUE);
					_tmp836_ = method;
					_tmp837_ = local;
					vala_method_add_captured_variable (_tmp836_, _tmp837_);
				}
				_tmp838_ = sym;
				_tmp839_ = vala_symbol_get_parent_symbol (_tmp838_);
				_tmp840_ = _tmp839_;
				sym = _tmp840_;
			}
			_tmp841_ = local;
			vala_local_variable_set_captured (_tmp841_, TRUE);
			_tmp842_ = block;
			vala_block_set_captured (_tmp842_, TRUE);
			_tmp843_ = local;
			_tmp844_ = vala_variable_get_variable_type ((ValaVariable*) _tmp843_);
			_tmp845_ = _tmp844_;
			_tmp846_ = vala_data_type_get_type_symbol (_tmp845_);
			_tmp847_ = _tmp846_;
			_tmp848_ = vala_code_context_get_analyzer (context);
			_tmp849_ = _tmp848_;
			_tmp850_ = _tmp849_->va_list_type;
			_tmp851_ = vala_data_type_get_type_symbol (_tmp850_);
			_tmp852_ = _tmp851_;
			if (_tmp847_ == _tmp852_) {
				ValaSourceReference* _tmp853_;
				ValaSourceReference* _tmp854_;
				ValaLocalVariable* _tmp855_;
				gchar* _tmp856_;
				gchar* _tmp857_;
				gchar* _tmp858_;
				gchar* _tmp859_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp853_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp854_ = _tmp853_;
				_tmp855_ = local;
				_tmp856_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp855_);
				_tmp857_ = _tmp856_;
				_tmp858_ = g_strdup_printf ("Capturing `va_list' variable `%s' is not allowed", _tmp857_);
				_tmp859_ = _tmp858_;
				vala_report_error (_tmp854_, _tmp859_);
				_g_free0 (_tmp859_);
				_g_free0 (_tmp857_);
			}
		}
	} else {
		ValaSymbol* _tmp860_;
		_tmp860_ = member;
		if (VALA_IS_PARAMETER (_tmp860_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp861_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp862_;
			ValaSymbol* _tmp863_;
			ValaSymbol* _tmp864_;
			gboolean _tmp865_ = FALSE;
			gboolean _tmp866_ = FALSE;
			ValaMethod* _tmp867_;
			_tmp861_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp861_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp862_ = param;
			_tmp863_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp862_);
			_tmp864_ = _tmp863_;
			m = VALA_IS_METHOD (_tmp864_) ? ((ValaMethod*) _tmp864_) : NULL;
			_tmp867_ = m;
			if (_tmp867_ != NULL) {
				ValaMethod* _tmp868_;
				ValaSemanticAnalyzer* _tmp869_;
				ValaSemanticAnalyzer* _tmp870_;
				ValaSymbol* _tmp871_;
				ValaSymbol* _tmp872_;
				_tmp868_ = m;
				_tmp869_ = vala_code_context_get_analyzer (context);
				_tmp870_ = _tmp869_;
				_tmp871_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp870_);
				_tmp872_ = _tmp871_;
				_tmp866_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp868_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp872_;
			} else {
				_tmp866_ = FALSE;
			}
			if (_tmp866_) {
				ValaParameter* _tmp873_;
				ValaMethod* _tmp874_;
				ValaParameter* _tmp875_;
				ValaParameter* _tmp876_;
				_tmp873_ = param;
				_tmp874_ = m;
				_tmp875_ = vala_method_get_this_parameter (_tmp874_);
				_tmp876_ = _tmp875_;
				_tmp865_ = _tmp873_ != _tmp876_;
			} else {
				_tmp865_ = FALSE;
			}
			if (_tmp865_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp877_;
				ValaSemanticAnalyzer* _tmp878_;
				ValaSymbol* _tmp879_;
				ValaSymbol* _tmp880_;
				ValaParameter* _tmp889_;
				ValaMethod* _tmp890_;
				ValaBlock* _tmp891_;
				ValaBlock* _tmp892_;
				ValaParameter* _tmp893_;
				ValaParameterDirection _tmp894_;
				ValaParameterDirection _tmp895_;
				ValaParameter* _tmp903_;
				ValaDataType* _tmp904_;
				ValaDataType* _tmp905_;
				ValaTypeSymbol* _tmp906_;
				ValaTypeSymbol* _tmp907_;
				ValaSemanticAnalyzer* _tmp908_;
				ValaSemanticAnalyzer* _tmp909_;
				ValaDataType* _tmp910_;
				ValaTypeSymbol* _tmp911_;
				ValaTypeSymbol* _tmp912_;
				_tmp877_ = vala_code_context_get_analyzer (context);
				_tmp878_ = _tmp877_;
				_tmp879_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp878_);
				_tmp880_ = _tmp879_;
				sym = _tmp880_;
				while (TRUE) {
					ValaSymbol* _tmp881_;
					ValaMethod* _tmp882_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp883_;
					ValaMethod* _tmp884_;
					ValaSymbol* _tmp886_;
					ValaSymbol* _tmp887_;
					ValaSymbol* _tmp888_;
					_tmp881_ = sym;
					_tmp882_ = m;
					if (!(_tmp881_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp882_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp883_ = sym;
					method = VALA_IS_METHOD (_tmp883_) ? ((ValaMethod*) _tmp883_) : NULL;
					_tmp884_ = method;
					if (_tmp884_ != NULL) {
						ValaMethod* _tmp885_;
						_tmp885_ = method;
						vala_method_set_closure (_tmp885_, TRUE);
					}
					_tmp886_ = sym;
					_tmp887_ = vala_symbol_get_parent_symbol (_tmp886_);
					_tmp888_ = _tmp887_;
					sym = _tmp888_;
				}
				_tmp889_ = param;
				vala_parameter_set_captured (_tmp889_, TRUE);
				_tmp890_ = m;
				_tmp891_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp890_);
				_tmp892_ = _tmp891_;
				vala_block_set_captured (_tmp892_, TRUE);
				_tmp893_ = param;
				_tmp894_ = vala_parameter_get_direction (_tmp893_);
				_tmp895_ = _tmp894_;
				if (_tmp895_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp896_;
					ValaSourceReference* _tmp897_;
					ValaParameter* _tmp898_;
					gchar* _tmp899_;
					gchar* _tmp900_;
					gchar* _tmp901_;
					gchar* _tmp902_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp896_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp897_ = _tmp896_;
					_tmp898_ = param;
					_tmp899_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp898_);
					_tmp900_ = _tmp899_;
					_tmp901_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp900_);
					_tmp902_ = _tmp901_;
					vala_report_error (_tmp897_, _tmp902_);
					_g_free0 (_tmp902_);
					_g_free0 (_tmp900_);
				}
				_tmp903_ = param;
				_tmp904_ = vala_variable_get_variable_type ((ValaVariable*) _tmp903_);
				_tmp905_ = _tmp904_;
				_tmp906_ = vala_data_type_get_type_symbol (_tmp905_);
				_tmp907_ = _tmp906_;
				_tmp908_ = vala_code_context_get_analyzer (context);
				_tmp909_ = _tmp908_;
				_tmp910_ = _tmp909_->va_list_type;
				_tmp911_ = vala_data_type_get_type_symbol (_tmp910_);
				_tmp912_ = _tmp911_;
				if (_tmp907_ == _tmp912_) {
					ValaSourceReference* _tmp913_;
					ValaSourceReference* _tmp914_;
					ValaParameter* _tmp915_;
					gchar* _tmp916_;
					gchar* _tmp917_;
					gchar* _tmp918_;
					gchar* _tmp919_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp913_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp914_ = _tmp913_;
					_tmp915_ = param;
					_tmp916_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp915_);
					_tmp917_ = _tmp916_;
					_tmp918_ = g_strdup_printf ("Capturing `va_list' parameter `%s' is not allowed", _tmp917_);
					_tmp919_ = _tmp918_;
					vala_report_error (_tmp914_, _tmp919_);
					_g_free0 (_tmp919_);
					_g_free0 (_tmp917_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp920_;
				ValaSymbol* _tmp921_;
				ValaSymbol* _tmp922_;
				ValaSymbol* _tmp923_;
				ValaSymbol* _tmp924_;
				gboolean _tmp925_ = FALSE;
				gboolean _tmp926_ = FALSE;
				ValaPropertyAccessor* _tmp927_;
				_tmp920_ = param;
				_tmp921_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp920_);
				_tmp922_ = _tmp921_;
				_tmp923_ = vala_symbol_get_parent_symbol (_tmp922_);
				_tmp924_ = _tmp923_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp924_) ? ((ValaPropertyAccessor*) _tmp924_) : NULL;
				_tmp927_ = acc;
				if (_tmp927_ != NULL) {
					ValaPropertyAccessor* _tmp928_;
					ValaSemanticAnalyzer* _tmp929_;
					ValaSemanticAnalyzer* _tmp930_;
					ValaSymbol* _tmp931_;
					ValaSymbol* _tmp932_;
					_tmp928_ = acc;
					_tmp929_ = vala_code_context_get_analyzer (context);
					_tmp930_ = _tmp929_;
					_tmp931_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp930_);
					_tmp932_ = _tmp931_;
					_tmp926_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp928_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp932_;
				} else {
					_tmp926_ = FALSE;
				}
				if (_tmp926_) {
					ValaParameter* _tmp933_;
					ValaPropertyAccessor* _tmp934_;
					ValaProperty* _tmp935_;
					ValaProperty* _tmp936_;
					ValaParameter* _tmp937_;
					ValaParameter* _tmp938_;
					_tmp933_ = param;
					_tmp934_ = acc;
					_tmp935_ = vala_property_accessor_get_prop (_tmp934_);
					_tmp936_ = _tmp935_;
					_tmp937_ = vala_property_get_this_parameter (_tmp936_);
					_tmp938_ = _tmp937_;
					_tmp925_ = _tmp933_ != _tmp938_;
				} else {
					_tmp925_ = FALSE;
				}
				if (_tmp925_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp939_;
					ValaSemanticAnalyzer* _tmp940_;
					ValaSymbol* _tmp941_;
					ValaSymbol* _tmp942_;
					ValaParameter* _tmp951_;
					ValaPropertyAccessor* _tmp952_;
					ValaBlock* _tmp953_;
					ValaBlock* _tmp954_;
					_tmp939_ = vala_code_context_get_analyzer (context);
					_tmp940_ = _tmp939_;
					_tmp941_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp940_);
					_tmp942_ = _tmp941_;
					sym = _tmp942_;
					while (TRUE) {
						ValaSymbol* _tmp943_;
						ValaMethod* _tmp944_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp945_;
						ValaMethod* _tmp946_;
						ValaSymbol* _tmp948_;
						ValaSymbol* _tmp949_;
						ValaSymbol* _tmp950_;
						_tmp943_ = sym;
						_tmp944_ = m;
						if (!(_tmp943_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp944_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp945_ = sym;
						method = VALA_IS_METHOD (_tmp945_) ? ((ValaMethod*) _tmp945_) : NULL;
						_tmp946_ = method;
						if (_tmp946_ != NULL) {
							ValaMethod* _tmp947_;
							_tmp947_ = method;
							vala_method_set_closure (_tmp947_, TRUE);
						}
						_tmp948_ = sym;
						_tmp949_ = vala_symbol_get_parent_symbol (_tmp948_);
						_tmp950_ = _tmp949_;
						sym = _tmp950_;
					}
					_tmp951_ = param;
					vala_parameter_set_captured (_tmp951_, TRUE);
					_tmp952_ = acc;
					_tmp953_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp952_);
					_tmp954_ = _tmp953_;
					vala_block_set_captured (_tmp954_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp955_;
			_tmp955_ = member;
			if (VALA_IS_FIELD (_tmp955_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp956_;
				ValaField* _tmp957_;
				ValaSymbolAccessibility _tmp958_;
				ValaSymbolAccessibility _tmp959_;
				ValaField* _tmp960_;
				ValaMemberBinding _tmp961_;
				ValaMemberBinding _tmp962_;
				ValaField* _tmp963_;
				ValaMemberBinding _tmp964_;
				ValaMemberBinding _tmp965_;
				ValaField* _tmp966_;
				ValaDataType* _tmp967_;
				ValaDataType* _tmp968_;
				_tmp956_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp956_, VALA_TYPE_FIELD, ValaField);
				_tmp957_ = f;
				_tmp958_ = vala_symbol_get_access ((ValaSymbol*) _tmp957_);
				_tmp959_ = _tmp958_;
				access = _tmp959_;
				_tmp960_ = f;
				_tmp961_ = vala_field_get_binding (_tmp960_);
				_tmp962_ = _tmp961_;
				instance = _tmp962_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp963_ = f;
				_tmp964_ = vala_field_get_binding (_tmp963_);
				_tmp965_ = _tmp964_;
				klass = _tmp965_ == VALA_MEMBER_BINDING_CLASS;
				_tmp966_ = f;
				_tmp967_ = vala_variable_get_variable_type ((ValaVariable*) _tmp966_);
				_tmp968_ = _tmp967_;
				if (VALA_IS_GENERIC_TYPE (_tmp968_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp969_;
				_tmp969_ = member;
				if (VALA_IS_CONSTANT (_tmp969_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp970_;
					ValaConstant* _tmp971_;
					ValaSymbolAccessibility _tmp972_;
					ValaSymbolAccessibility _tmp973_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp974_;
					ValaSymbol* _tmp975_;
					ValaSymbol* _tmp976_;
					gboolean _tmp977_ = FALSE;
					ValaBlock* _tmp978_;
					_tmp970_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp970_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp971_ = c;
					_tmp972_ = vala_symbol_get_access ((ValaSymbol*) _tmp971_);
					_tmp973_ = _tmp972_;
					access = _tmp973_;
					_tmp974_ = c;
					_tmp975_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp974_);
					_tmp976_ = _tmp975_;
					block = VALA_IS_BLOCK (_tmp976_) ? ((ValaBlock*) _tmp976_) : NULL;
					_tmp978_ = block;
					if (_tmp978_ != NULL) {
						ValaBlock* _tmp979_;
						ValaSymbol* _tmp980_;
						ValaSemanticAnalyzer* _tmp981_;
						ValaSemanticAnalyzer* _tmp982_;
						ValaSymbol* _tmp983_;
						ValaSymbol* _tmp984_;
						_tmp979_ = block;
						_tmp980_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp979_);
						_tmp981_ = vala_code_context_get_analyzer (context);
						_tmp982_ = _tmp981_;
						_tmp983_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp982_);
						_tmp984_ = _tmp983_;
						_tmp977_ = _tmp980_ != _tmp984_;
					} else {
						_tmp977_ = FALSE;
					}
					if (_tmp977_) {
						ValaSourceReference* _tmp985_;
						ValaSourceReference* _tmp986_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp985_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp986_ = _tmp985_;
						vala_report_error (_tmp986_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp987_;
					_tmp987_ = member;
					if (VALA_IS_METHOD (_tmp987_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp988_;
						ValaMethod* _tmp989_;
						gboolean _tmp990_;
						gboolean _tmp991_;
						ValaMethod* _tmp1080_;
						ValaSymbolAccessibility _tmp1081_;
						ValaSymbolAccessibility _tmp1082_;
						ValaMethod* _tmp1083_;
						ValaMethod* _tmp1087_;
						ValaMemberBinding _tmp1088_;
						ValaMemberBinding _tmp1089_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1110_;
						ValaDataType* _tmp1111_;
						ValaDataType* _tmp1112_;
						gboolean _tmp1113_ = FALSE;
						ValaGenericType* _tmp1114_;
						_tmp988_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp988_, VALA_TYPE_METHOD, ValaMethod);
						_tmp989_ = m;
						_tmp990_ = vala_method_get_is_async_callback (_tmp989_);
						_tmp991_ = _tmp990_;
						if (_tmp991_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp992_;
							ValaSemanticAnalyzer* _tmp993_;
							ValaMethod* _tmp994_;
							ValaMethod* _tmp995_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp996_;
							ValaMethod* _tmp1025_;
							ValaSemanticAnalyzer* _tmp1026_;
							ValaSemanticAnalyzer* _tmp1027_;
							ValaMethod* _tmp1028_;
							ValaMethod* _tmp1029_;
							ValaMethod* _tmp1045_;
							ValaMethod* _tmp1046_;
							ValaMethod* _tmp1047_;
							ValaSymbol* _tmp1048_;
							ValaSymbol* _tmp1049_;
							_tmp992_ = vala_code_context_get_analyzer (context);
							_tmp993_ = _tmp992_;
							_tmp994_ = vala_semantic_analyzer_get_current_async_method (_tmp993_);
							_tmp995_ = _tmp994_;
							async_method = _tmp995_;
							is_valid_access = FALSE;
							_tmp996_ = async_method;
							if (_tmp996_ != NULL) {
								ValaMethod* _tmp997_;
								ValaMethod* _tmp998_;
								ValaMethod* _tmp999_;
								_tmp997_ = m;
								_tmp998_ = async_method;
								_tmp999_ = vala_method_get_callback_method (_tmp998_);
								if (_tmp997_ == _tmp999_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp1000_ = FALSE;
									ValaMethod* _tmp1001_;
									ValaMethod* _tmp1002_;
									ValaMethod* _tmp1003_;
									_tmp1001_ = async_method;
									_tmp1002_ = vala_method_get_base_method (_tmp1001_);
									_tmp1003_ = _tmp1002_;
									if (_tmp1003_ != NULL) {
										ValaMethod* _tmp1004_;
										ValaMethod* _tmp1005_;
										ValaMethod* _tmp1006_;
										ValaMethod* _tmp1007_;
										ValaMethod* _tmp1008_;
										_tmp1004_ = m;
										_tmp1005_ = async_method;
										_tmp1006_ = vala_method_get_base_method (_tmp1005_);
										_tmp1007_ = _tmp1006_;
										_tmp1008_ = vala_method_get_callback_method (_tmp1007_);
										_tmp1000_ = _tmp1004_ == _tmp1008_;
									} else {
										_tmp1000_ = FALSE;
									}
									if (_tmp1000_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp1009_ = FALSE;
										ValaMethod* _tmp1010_;
										ValaMethod* _tmp1011_;
										ValaMethod* _tmp1012_;
										_tmp1010_ = async_method;
										_tmp1011_ = vala_method_get_base_interface_method (_tmp1010_);
										_tmp1012_ = _tmp1011_;
										if (_tmp1012_ != NULL) {
											ValaMethod* _tmp1013_;
											ValaMethod* _tmp1014_;
											ValaMethod* _tmp1015_;
											ValaMethod* _tmp1016_;
											ValaMethod* _tmp1017_;
											_tmp1013_ = m;
											_tmp1014_ = async_method;
											_tmp1015_ = vala_method_get_base_interface_method (_tmp1014_);
											_tmp1016_ = _tmp1015_;
											_tmp1017_ = vala_method_get_callback_method (_tmp1016_);
											_tmp1009_ = _tmp1013_ == _tmp1017_;
										} else {
											_tmp1009_ = FALSE;
										}
										if (_tmp1009_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp1018_;
								ValaSourceReference* _tmp1019_;
								ValaMethod* _tmp1020_;
								gchar* _tmp1021_;
								gchar* _tmp1022_;
								gchar* _tmp1023_;
								gchar* _tmp1024_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp1018_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp1019_ = _tmp1018_;
								_tmp1020_ = m;
								_tmp1021_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1020_);
								_tmp1022_ = _tmp1021_;
								_tmp1023_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp1022_);
								_tmp1024_ = _tmp1023_;
								vala_report_error (_tmp1019_, _tmp1024_);
								_g_free0 (_tmp1024_);
								_g_free0 (_tmp1022_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1025_ = async_method;
							_tmp1026_ = vala_code_context_get_analyzer (context);
							_tmp1027_ = _tmp1026_;
							_tmp1028_ = vala_semantic_analyzer_get_current_method (_tmp1027_);
							_tmp1029_ = _tmp1028_;
							if (_tmp1025_ != _tmp1029_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp1030_;
								ValaSemanticAnalyzer* _tmp1031_;
								ValaMethod* _tmp1032_;
								ValaMethod* _tmp1033_;
								ValaMethod* _tmp1042_;
								ValaBlock* _tmp1043_;
								ValaBlock* _tmp1044_;
								_tmp1030_ = vala_code_context_get_analyzer (context);
								_tmp1031_ = _tmp1030_;
								_tmp1032_ = vala_semantic_analyzer_get_current_method (_tmp1031_);
								_tmp1033_ = _tmp1032_;
								sym = (ValaSymbol*) _tmp1033_;
								while (TRUE) {
									ValaSymbol* _tmp1034_;
									ValaMethod* _tmp1035_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp1036_;
									ValaMethod* _tmp1037_;
									ValaSymbol* _tmp1039_;
									ValaSymbol* _tmp1040_;
									ValaSymbol* _tmp1041_;
									_tmp1034_ = sym;
									_tmp1035_ = async_method;
									if (!(_tmp1034_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1035_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp1036_ = sym;
									method = VALA_IS_METHOD (_tmp1036_) ? ((ValaMethod*) _tmp1036_) : NULL;
									_tmp1037_ = method;
									if (_tmp1037_ != NULL) {
										ValaMethod* _tmp1038_;
										_tmp1038_ = method;
										vala_method_set_closure (_tmp1038_, TRUE);
									}
									_tmp1039_ = sym;
									_tmp1040_ = vala_symbol_get_parent_symbol (_tmp1039_);
									_tmp1041_ = _tmp1040_;
									sym = _tmp1041_;
								}
								_tmp1042_ = async_method;
								_tmp1043_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1042_);
								_tmp1044_ = _tmp1043_;
								vala_block_set_captured (_tmp1044_, TRUE);
							}
							_tmp1045_ = async_method;
							_tmp1046_ = vala_method_get_callback_method (_tmp1045_);
							m = _tmp1046_;
							_tmp1047_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1047_);
							_tmp1048_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1049_ = _tmp1048_;
							member = _tmp1049_;
						} else {
							ValaMethod* _tmp1050_;
							ValaMethod* _tmp1051_;
							ValaMethod* _tmp1052_;
							_tmp1050_ = m;
							_tmp1051_ = vala_method_get_base_method (_tmp1050_);
							_tmp1052_ = _tmp1051_;
							if (_tmp1052_ != NULL) {
								ValaMethod* _tmp1053_;
								ValaMethod* _tmp1054_;
								ValaMethod* _tmp1055_;
								ValaMethod* _tmp1056_;
								ValaSignal* _tmp1057_;
								ValaSignal* _tmp1058_;
								ValaSymbol* _tmp1063_;
								ValaSymbol* _tmp1064_;
								_tmp1053_ = m;
								_tmp1054_ = vala_method_get_base_method (_tmp1053_);
								_tmp1055_ = _tmp1054_;
								m = _tmp1055_;
								_tmp1056_ = m;
								_tmp1057_ = vala_method_get_signal_reference (_tmp1056_);
								_tmp1058_ = _tmp1057_;
								if (_tmp1058_ != NULL) {
									ValaMethod* _tmp1059_;
									ValaSignal* _tmp1060_;
									ValaSignal* _tmp1061_;
									_tmp1059_ = m;
									_tmp1060_ = vala_method_get_signal_reference (_tmp1059_);
									_tmp1061_ = _tmp1060_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1061_);
								} else {
									ValaMethod* _tmp1062_;
									_tmp1062_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1062_);
								}
								_tmp1063_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1064_ = _tmp1063_;
								member = _tmp1064_;
							} else {
								ValaMethod* _tmp1065_;
								ValaMethod* _tmp1066_;
								ValaMethod* _tmp1067_;
								_tmp1065_ = m;
								_tmp1066_ = vala_method_get_base_interface_method (_tmp1065_);
								_tmp1067_ = _tmp1066_;
								if (_tmp1067_ != NULL) {
									ValaMethod* _tmp1068_;
									ValaMethod* _tmp1069_;
									ValaMethod* _tmp1070_;
									ValaMethod* _tmp1071_;
									ValaSignal* _tmp1072_;
									ValaSignal* _tmp1073_;
									ValaSymbol* _tmp1078_;
									ValaSymbol* _tmp1079_;
									_tmp1068_ = m;
									_tmp1069_ = vala_method_get_base_interface_method (_tmp1068_);
									_tmp1070_ = _tmp1069_;
									m = _tmp1070_;
									_tmp1071_ = m;
									_tmp1072_ = vala_method_get_signal_reference (_tmp1071_);
									_tmp1073_ = _tmp1072_;
									if (_tmp1073_ != NULL) {
										ValaMethod* _tmp1074_;
										ValaSignal* _tmp1075_;
										ValaSignal* _tmp1076_;
										_tmp1074_ = m;
										_tmp1075_ = vala_method_get_signal_reference (_tmp1074_);
										_tmp1076_ = _tmp1075_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1076_);
									} else {
										ValaMethod* _tmp1077_;
										_tmp1077_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1077_);
									}
									_tmp1078_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1079_ = _tmp1078_;
									member = _tmp1079_;
								}
							}
						}
						_tmp1080_ = m;
						_tmp1081_ = vala_symbol_get_access ((ValaSymbol*) _tmp1080_);
						_tmp1082_ = _tmp1081_;
						access = _tmp1082_;
						_tmp1083_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1083_)) {
							ValaMethod* _tmp1084_;
							ValaMemberBinding _tmp1085_;
							ValaMemberBinding _tmp1086_;
							_tmp1084_ = m;
							_tmp1085_ = vala_method_get_binding (_tmp1084_);
							_tmp1086_ = _tmp1085_;
							instance = _tmp1086_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1087_ = m;
						_tmp1088_ = vala_method_get_binding (_tmp1087_);
						_tmp1089_ = _tmp1088_;
						klass = _tmp1089_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1090_;
							ValaList* _tmp1091_;
							ValaList* _tmp1092_;
							gint _param_size = 0;
							ValaList* _tmp1093_;
							gint _tmp1094_;
							gint _tmp1095_;
							gint _param_index = 0;
							_tmp1090_ = m;
							_tmp1091_ = vala_callable_get_parameters ((ValaCallable*) _tmp1090_);
							_tmp1092_ = _vala_iterable_ref0 (_tmp1091_);
							_param_list = _tmp1092_;
							_tmp1093_ = _param_list;
							_tmp1094_ = vala_collection_get_size ((ValaCollection*) _tmp1093_);
							_tmp1095_ = _tmp1094_;
							_param_size = _tmp1095_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1096_;
								gint _tmp1097_;
								ValaParameter* param = NULL;
								ValaList* _tmp1098_;
								gpointer _tmp1099_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1100_;
								ValaDataType* _tmp1101_;
								ValaDataType* _tmp1102_;
								gboolean _tmp1103_ = FALSE;
								ValaGenericType* _tmp1104_;
								_param_index = _param_index + 1;
								_tmp1096_ = _param_index;
								_tmp1097_ = _param_size;
								if (!(_tmp1096_ < _tmp1097_)) {
									break;
								}
								_tmp1098_ = _param_list;
								_tmp1099_ = vala_list_get (_tmp1098_, _param_index);
								param = (ValaParameter*) _tmp1099_;
								_tmp1100_ = param;
								_tmp1101_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1100_);
								_tmp1102_ = _tmp1101_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1102_) ? ((ValaGenericType*) _tmp1102_) : NULL;
								_tmp1104_ = generic_type;
								if (_tmp1104_ != NULL) {
									ValaGenericType* _tmp1105_;
									ValaTypeParameter* _tmp1106_;
									ValaTypeParameter* _tmp1107_;
									ValaSymbol* _tmp1108_;
									ValaSymbol* _tmp1109_;
									_tmp1105_ = generic_type;
									_tmp1106_ = vala_generic_type_get_type_parameter (_tmp1105_);
									_tmp1107_ = _tmp1106_;
									_tmp1108_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1107_);
									_tmp1109_ = _tmp1108_;
									_tmp1103_ = VALA_IS_TYPESYMBOL (_tmp1109_);
								} else {
									_tmp1103_ = FALSE;
								}
								if (_tmp1103_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp1110_ = m;
						_tmp1111_ = vala_callable_get_return_type ((ValaCallable*) _tmp1110_);
						_tmp1112_ = _tmp1111_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1112_) ? ((ValaGenericType*) _tmp1112_) : NULL;
						_tmp1114_ = generic_type;
						if (_tmp1114_ != NULL) {
							ValaGenericType* _tmp1115_;
							ValaTypeParameter* _tmp1116_;
							ValaTypeParameter* _tmp1117_;
							ValaSymbol* _tmp1118_;
							ValaSymbol* _tmp1119_;
							_tmp1115_ = generic_type;
							_tmp1116_ = vala_generic_type_get_type_parameter (_tmp1115_);
							_tmp1117_ = _tmp1116_;
							_tmp1118_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1117_);
							_tmp1119_ = _tmp1118_;
							_tmp1113_ = VALA_IS_TYPESYMBOL (_tmp1119_);
						} else {
							_tmp1113_ = FALSE;
						}
						if (_tmp1113_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1120_;
						_tmp1120_ = member;
						if (VALA_IS_PROPERTY (_tmp1120_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1121_;
							ValaProperty* _tmp1122_;
							ValaProperty* _tmp1123_;
							ValaProperty* _tmp1124_;
							ValaProperty* _tmp1125_;
							ValaProperty* _tmp1141_;
							ValaSymbolAccessibility _tmp1142_;
							ValaSymbolAccessibility _tmp1143_;
							gboolean _tmp1144_;
							gboolean _tmp1145_;
							ValaProperty* _tmp1250_;
							ValaMemberBinding _tmp1251_;
							ValaMemberBinding _tmp1252_;
							ValaProperty* _tmp1253_;
							ValaDataType* _tmp1254_;
							ValaDataType* _tmp1255_;
							_tmp1121_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1121_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1122_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1122_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1123_ = prop;
							_tmp1124_ = vala_property_get_base_property (_tmp1123_);
							_tmp1125_ = _tmp1124_;
							if (_tmp1125_ != NULL) {
								ValaProperty* _tmp1126_;
								ValaProperty* _tmp1127_;
								ValaProperty* _tmp1128_;
								ValaProperty* _tmp1129_;
								ValaSymbol* _tmp1130_;
								ValaSymbol* _tmp1131_;
								_tmp1126_ = prop;
								_tmp1127_ = vala_property_get_base_property (_tmp1126_);
								_tmp1128_ = _tmp1127_;
								prop = _tmp1128_;
								_tmp1129_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1129_);
								_tmp1130_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1131_ = _tmp1130_;
								member = _tmp1131_;
							} else {
								ValaProperty* _tmp1132_;
								ValaProperty* _tmp1133_;
								ValaProperty* _tmp1134_;
								_tmp1132_ = prop;
								_tmp1133_ = vala_property_get_base_interface_property (_tmp1132_);
								_tmp1134_ = _tmp1133_;
								if (_tmp1134_ != NULL) {
									ValaProperty* _tmp1135_;
									ValaProperty* _tmp1136_;
									ValaProperty* _tmp1137_;
									ValaProperty* _tmp1138_;
									ValaSymbol* _tmp1139_;
									ValaSymbol* _tmp1140_;
									_tmp1135_ = prop;
									_tmp1136_ = vala_property_get_base_interface_property (_tmp1135_);
									_tmp1137_ = _tmp1136_;
									prop = _tmp1137_;
									_tmp1138_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1138_);
									_tmp1139_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1140_ = _tmp1139_;
									member = _tmp1140_;
								}
							}
							_tmp1141_ = prop;
							_tmp1142_ = vala_symbol_get_access ((ValaSymbol*) _tmp1141_);
							_tmp1143_ = _tmp1142_;
							access = _tmp1143_;
							_tmp1144_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1145_ = _tmp1144_;
							if (_tmp1145_) {
								ValaProperty* _tmp1146_;
								ValaPropertyAccessor* _tmp1147_;
								ValaPropertyAccessor* _tmp1148_;
								ValaProperty* _tmp1196_;
								ValaSymbolAccessibility _tmp1197_;
								ValaSymbolAccessibility _tmp1198_;
								_tmp1146_ = prop;
								_tmp1147_ = vala_property_get_set_accessor (_tmp1146_);
								_tmp1148_ = _tmp1147_;
								if (_tmp1148_ == NULL) {
									ValaSourceReference* _tmp1149_;
									ValaSourceReference* _tmp1150_;
									ValaProperty* _tmp1151_;
									gchar* _tmp1152_;
									gchar* _tmp1153_;
									gchar* _tmp1154_;
									gchar* _tmp1155_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1150_ = _tmp1149_;
									_tmp1151_ = prop;
									_tmp1152_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1151_);
									_tmp1153_ = _tmp1152_;
									_tmp1154_ = g_strdup_printf ("Property `%s' is read-only", _tmp1153_);
									_tmp1155_ = _tmp1154_;
									vala_report_error (_tmp1150_, _tmp1155_);
									_g_free0 (_tmp1155_);
									_g_free0 (_tmp1153_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								} else {
									gboolean _tmp1156_ = FALSE;
									ValaProperty* _tmp1157_;
									ValaPropertyAccessor* _tmp1158_;
									ValaPropertyAccessor* _tmp1159_;
									gboolean _tmp1160_;
									gboolean _tmp1161_;
									_tmp1157_ = prop;
									_tmp1158_ = vala_property_get_set_accessor (_tmp1157_);
									_tmp1159_ = _tmp1158_;
									_tmp1160_ = vala_property_accessor_get_writable (_tmp1159_);
									_tmp1161_ = _tmp1160_;
									if (!_tmp1161_) {
										ValaProperty* _tmp1162_;
										ValaPropertyAccessor* _tmp1163_;
										ValaPropertyAccessor* _tmp1164_;
										gboolean _tmp1165_;
										gboolean _tmp1166_;
										_tmp1162_ = prop;
										_tmp1163_ = vala_property_get_set_accessor (_tmp1162_);
										_tmp1164_ = _tmp1163_;
										_tmp1165_ = vala_property_accessor_get_construction (_tmp1164_);
										_tmp1166_ = _tmp1165_;
										_tmp1156_ = _tmp1166_;
									} else {
										_tmp1156_ = FALSE;
									}
									if (_tmp1156_) {
										ValaSemanticAnalyzer* _tmp1167_;
										ValaSemanticAnalyzer* _tmp1168_;
										ValaMethod* _tmp1169_;
										_tmp1167_ = vala_code_context_get_analyzer (context);
										_tmp1168_ = _tmp1167_;
										_tmp1169_ = vala_semantic_analyzer_find_current_method (_tmp1168_);
										if (VALA_IS_CREATION_METHOD (_tmp1169_)) {
											ValaSourceReference* _tmp1170_;
											ValaSourceReference* _tmp1171_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1170_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1171_ = _tmp1170_;
											vala_report_error (_tmp1171_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											_vala_iterable_unref0 (visited_types);
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1172_;
											ValaSemanticAnalyzer* _tmp1173_;
											_tmp1172_ = vala_code_context_get_analyzer (context);
											_tmp1173_ = _tmp1172_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1173_)) {
												ValaSemanticAnalyzer* _tmp1174_;
												ValaSemanticAnalyzer* _tmp1175_;
												ValaTypeSymbol* _tmp1176_;
												ValaTypeSymbol* _tmp1177_;
												ValaProperty* _tmp1178_;
												ValaSymbol* _tmp1179_;
												ValaSymbol* _tmp1180_;
												_tmp1174_ = vala_code_context_get_analyzer (context);
												_tmp1175_ = _tmp1174_;
												_tmp1176_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1175_);
												_tmp1177_ = _tmp1176_;
												_tmp1178_ = prop;
												_tmp1179_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1178_);
												_tmp1180_ = _tmp1179_;
												if (!vala_typesymbol_is_subtype_of (_tmp1177_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1180_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1181_;
													ValaSourceReference* _tmp1182_;
													ValaProperty* _tmp1183_;
													gchar* _tmp1184_;
													gchar* _tmp1185_;
													ValaSemanticAnalyzer* _tmp1186_;
													ValaSemanticAnalyzer* _tmp1187_;
													ValaTypeSymbol* _tmp1188_;
													ValaTypeSymbol* _tmp1189_;
													gchar* _tmp1190_;
													gchar* _tmp1191_;
													gchar* _tmp1192_;
													gchar* _tmp1193_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1182_ = _tmp1181_;
													_tmp1183_ = prop;
													_tmp1184_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1183_);
													_tmp1185_ = _tmp1184_;
													_tmp1186_ = vala_code_context_get_analyzer (context);
													_tmp1187_ = _tmp1186_;
													_tmp1188_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1187_);
													_tmp1189_ = _tmp1188_;
													_tmp1190_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1189_);
													_tmp1191_ = _tmp1190_;
													_tmp1192_ = g_strdup_printf ("Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1185_, _tmp1191_);
													_tmp1193_ = _tmp1192_;
													vala_report_error (_tmp1182_, _tmp1193_);
													_g_free0 (_tmp1193_);
													_g_free0 (_tmp1191_);
													_g_free0 (_tmp1185_);
													result = FALSE;
													_vala_iterable_unref0 (visited_types);
													return result;
												}
											} else {
												ValaSourceReference* _tmp1194_;
												ValaSourceReference* _tmp1195_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1194_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1195_ = _tmp1194_;
												vala_report_error (_tmp1195_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												_vala_iterable_unref0 (visited_types);
												return result;
											}
										}
									}
								}
								_tmp1196_ = prop;
								_tmp1197_ = vala_symbol_get_access ((ValaSymbol*) _tmp1196_);
								_tmp1198_ = _tmp1197_;
								if (_tmp1198_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1199_;
									ValaPropertyAccessor* _tmp1200_;
									ValaPropertyAccessor* _tmp1201_;
									ValaSymbolAccessibility _tmp1202_;
									ValaSymbolAccessibility _tmp1203_;
									_tmp1199_ = prop;
									_tmp1200_ = vala_property_get_set_accessor (_tmp1199_);
									_tmp1201_ = _tmp1200_;
									_tmp1202_ = vala_symbol_get_access ((ValaSymbol*) _tmp1201_);
									_tmp1203_ = _tmp1202_;
									access = _tmp1203_;
								} else {
									gboolean _tmp1204_ = FALSE;
									ValaProperty* _tmp1205_;
									ValaSymbolAccessibility _tmp1206_;
									ValaSymbolAccessibility _tmp1207_;
									_tmp1205_ = prop;
									_tmp1206_ = vala_symbol_get_access ((ValaSymbol*) _tmp1205_);
									_tmp1207_ = _tmp1206_;
									if (_tmp1207_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1208_;
										ValaPropertyAccessor* _tmp1209_;
										ValaPropertyAccessor* _tmp1210_;
										ValaSymbolAccessibility _tmp1211_;
										ValaSymbolAccessibility _tmp1212_;
										_tmp1208_ = prop;
										_tmp1209_ = vala_property_get_set_accessor (_tmp1208_);
										_tmp1210_ = _tmp1209_;
										_tmp1211_ = vala_symbol_get_access ((ValaSymbol*) _tmp1210_);
										_tmp1212_ = _tmp1211_;
										_tmp1204_ = _tmp1212_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1204_ = FALSE;
									}
									if (_tmp1204_) {
										ValaProperty* _tmp1213_;
										ValaPropertyAccessor* _tmp1214_;
										ValaPropertyAccessor* _tmp1215_;
										ValaSymbolAccessibility _tmp1216_;
										ValaSymbolAccessibility _tmp1217_;
										_tmp1213_ = prop;
										_tmp1214_ = vala_property_get_set_accessor (_tmp1213_);
										_tmp1215_ = _tmp1214_;
										_tmp1216_ = vala_symbol_get_access ((ValaSymbol*) _tmp1215_);
										_tmp1217_ = _tmp1216_;
										access = _tmp1217_;
									}
								}
							} else {
								ValaProperty* _tmp1218_;
								ValaPropertyAccessor* _tmp1219_;
								ValaPropertyAccessor* _tmp1220_;
								ValaProperty* _tmp1228_;
								ValaSymbolAccessibility _tmp1229_;
								ValaSymbolAccessibility _tmp1230_;
								_tmp1218_ = prop;
								_tmp1219_ = vala_property_get_get_accessor (_tmp1218_);
								_tmp1220_ = _tmp1219_;
								if (_tmp1220_ == NULL) {
									ValaSourceReference* _tmp1221_;
									ValaSourceReference* _tmp1222_;
									ValaProperty* _tmp1223_;
									gchar* _tmp1224_;
									gchar* _tmp1225_;
									gchar* _tmp1226_;
									gchar* _tmp1227_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1221_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1222_ = _tmp1221_;
									_tmp1223_ = prop;
									_tmp1224_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1223_);
									_tmp1225_ = _tmp1224_;
									_tmp1226_ = g_strdup_printf ("Property `%s' is write-only", _tmp1225_);
									_tmp1227_ = _tmp1226_;
									vala_report_error (_tmp1222_, _tmp1227_);
									_g_free0 (_tmp1227_);
									_g_free0 (_tmp1225_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1228_ = prop;
								_tmp1229_ = vala_symbol_get_access ((ValaSymbol*) _tmp1228_);
								_tmp1230_ = _tmp1229_;
								if (_tmp1230_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1231_;
									ValaPropertyAccessor* _tmp1232_;
									ValaPropertyAccessor* _tmp1233_;
									ValaSymbolAccessibility _tmp1234_;
									ValaSymbolAccessibility _tmp1235_;
									_tmp1231_ = prop;
									_tmp1232_ = vala_property_get_get_accessor (_tmp1231_);
									_tmp1233_ = _tmp1232_;
									_tmp1234_ = vala_symbol_get_access ((ValaSymbol*) _tmp1233_);
									_tmp1235_ = _tmp1234_;
									access = _tmp1235_;
								} else {
									gboolean _tmp1236_ = FALSE;
									ValaProperty* _tmp1237_;
									ValaSymbolAccessibility _tmp1238_;
									ValaSymbolAccessibility _tmp1239_;
									_tmp1237_ = prop;
									_tmp1238_ = vala_symbol_get_access ((ValaSymbol*) _tmp1237_);
									_tmp1239_ = _tmp1238_;
									if (_tmp1239_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1240_;
										ValaPropertyAccessor* _tmp1241_;
										ValaPropertyAccessor* _tmp1242_;
										ValaSymbolAccessibility _tmp1243_;
										ValaSymbolAccessibility _tmp1244_;
										_tmp1240_ = prop;
										_tmp1241_ = vala_property_get_get_accessor (_tmp1240_);
										_tmp1242_ = _tmp1241_;
										_tmp1243_ = vala_symbol_get_access ((ValaSymbol*) _tmp1242_);
										_tmp1244_ = _tmp1243_;
										_tmp1236_ = _tmp1244_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1236_ = FALSE;
									}
									if (_tmp1236_) {
										ValaProperty* _tmp1245_;
										ValaPropertyAccessor* _tmp1246_;
										ValaPropertyAccessor* _tmp1247_;
										ValaSymbolAccessibility _tmp1248_;
										ValaSymbolAccessibility _tmp1249_;
										_tmp1245_ = prop;
										_tmp1246_ = vala_property_get_get_accessor (_tmp1245_);
										_tmp1247_ = _tmp1246_;
										_tmp1248_ = vala_symbol_get_access ((ValaSymbol*) _tmp1247_);
										_tmp1249_ = _tmp1248_;
										access = _tmp1249_;
									}
								}
							}
							_tmp1250_ = prop;
							_tmp1251_ = vala_property_get_binding (_tmp1250_);
							_tmp1252_ = _tmp1251_;
							instance = _tmp1252_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1253_ = prop;
							_tmp1254_ = vala_property_get_property_type (_tmp1253_);
							_tmp1255_ = _tmp1254_;
							if (VALA_IS_GENERIC_TYPE (_tmp1255_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1256_;
							_tmp1256_ = member;
							if (VALA_IS_SIGNAL (_tmp1256_)) {
								ValaSymbol* _tmp1257_;
								ValaSymbolAccessibility _tmp1258_;
								ValaSymbolAccessibility _tmp1259_;
								instance = TRUE;
								_tmp1257_ = member;
								_tmp1258_ = vala_symbol_get_access (_tmp1257_);
								_tmp1259_ = _tmp1258_;
								access = _tmp1259_;
							} else {
								gboolean _tmp1260_ = FALSE;
								gboolean _tmp1261_;
								_tmp1261_ = self->priv->_creation_member;
								if (!_tmp1261_) {
									ValaSymbol* _tmp1262_;
									_tmp1262_ = member;
									_tmp1260_ = VALA_IS_ERROR_CODE (_tmp1262_);
								} else {
									_tmp1260_ = FALSE;
								}
								if (_tmp1260_) {
									ValaSymbol* _tmp1263_;
									ValaConstant* _tmp1264_;
									ValaConstant* _tmp1265_;
									ValaSymbol* _tmp1266_;
									ValaSymbol* _tmp1267_;
									_tmp1263_ = member;
									_tmp1264_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1263_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1265_ = _tmp1264_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1265_);
									_tmp1266_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1267_ = _tmp1266_;
									member = _tmp1267_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1268_;
		ValaSymbol* _tmp1269_;
		ValaCodeNode* _tmp1270_;
		ValaCodeNode* _tmp1271_;
		ValaCodeNode* _tmp1272_;
		gboolean _tmp1273_ = FALSE;
		ValaCodeNode* _tmp1274_;
		_tmp1268_ = parent;
		_tmp1269_ = member;
		if (!(_tmp1268_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1269_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1270_ = parent;
		_tmp1271_ = vala_code_node_get_parent_node (_tmp1270_);
		_tmp1272_ = _tmp1271_;
		parent = _tmp1272_;
		_tmp1274_ = parent;
		if (_tmp1274_ == NULL) {
			_tmp1273_ = TRUE;
		} else {
			ValaCodeNode* _tmp1275_;
			ValaSymbol* _tmp1276_;
			_tmp1275_ = parent;
			_tmp1276_ = member;
			_tmp1273_ = _tmp1275_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1276_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1273_) {
			break;
		}
	}
	_tmp1277_ = parent;
	_tmp1278_ = member;
	if (_tmp1277_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1278_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1279_;
		_tmp1279_ = member;
		vala_symbol_set_used (_tmp1279_, TRUE);
	}
	_tmp1280_ = member;
	_tmp1281_ = vala_symbol_get_version (_tmp1280_);
	_tmp1282_ = _tmp1281_;
	_tmp1283_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1284_ = _tmp1283_;
	vala_version_attribute_check (_tmp1282_, context, _tmp1284_);
	_tmp1286_ = access;
	if (_tmp1286_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1287_;
		ValaSymbol* _tmp1288_;
		ValaSymbol* _tmp1289_;
		_tmp1287_ = member;
		_tmp1288_ = vala_symbol_get_parent_symbol (_tmp1287_);
		_tmp1289_ = _tmp1288_;
		_tmp1285_ = VALA_IS_TYPESYMBOL (_tmp1289_);
	} else {
		_tmp1285_ = FALSE;
	}
	if (_tmp1285_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1290_;
		ValaSymbol* _tmp1291_;
		ValaSymbol* _tmp1292_;
		gboolean in_subtype = FALSE;
		_tmp1290_ = member;
		_tmp1291_ = vala_symbol_get_parent_symbol (_tmp1290_);
		_tmp1292_ = _tmp1291_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1292_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1293_;
			ValaSemanticAnalyzer* _tmp1294_;
			ValaSymbol* _tmp1295_;
			ValaSymbol* _tmp1296_;
			ValaSymbol* _tmp1297_;
			_tmp1293_ = vala_code_context_get_analyzer (context);
			_tmp1294_ = _tmp1293_;
			_tmp1295_ = vala_semantic_analyzer_get_current_symbol (_tmp1294_);
			_tmp1296_ = _tmp1295_;
			_tmp1297_ = _vala_code_node_ref0 (_tmp1296_);
			this_symbol = _tmp1297_;
			{
				gboolean _tmp1298_ = FALSE;
				_tmp1298_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1303_;
					ValaSymbol* _tmp1304_;
					ValaTypeSymbol* _tmp1305_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1306_;
					gboolean _tmp1307_ = FALSE;
					ValaClass* _tmp1308_;
					if (!_tmp1298_) {
						ValaSymbol* _tmp1299_;
						ValaSymbol* _tmp1300_;
						ValaSymbol* _tmp1301_;
						ValaSymbol* _tmp1302_;
						_tmp1299_ = this_symbol;
						_tmp1300_ = vala_symbol_get_parent_symbol (_tmp1299_);
						_tmp1301_ = _tmp1300_;
						_tmp1302_ = _vala_code_node_ref0 (_tmp1301_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1302_;
					}
					_tmp1298_ = FALSE;
					_tmp1303_ = this_symbol;
					if (!(_tmp1303_ != NULL)) {
						break;
					}
					_tmp1304_ = this_symbol;
					_tmp1305_ = target_type;
					if (_tmp1304_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1305_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1306_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1306_) ? ((ValaClass*) _tmp1306_) : NULL;
					_tmp1308_ = cl;
					if (_tmp1308_ != NULL) {
						ValaClass* _tmp1309_;
						ValaTypeSymbol* _tmp1310_;
						_tmp1309_ = cl;
						_tmp1310_ = target_type;
						_tmp1307_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1309_, _tmp1310_);
					} else {
						_tmp1307_ = FALSE;
					}
					if (_tmp1307_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1311_;
			ValaSourceReference* _tmp1312_;
			ValaSymbol* _tmp1313_;
			gchar* _tmp1314_;
			gchar* _tmp1315_;
			gchar* _tmp1316_;
			gchar* _tmp1317_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1311_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1312_ = _tmp1311_;
			_tmp1313_ = member;
			_tmp1314_ = vala_symbol_get_full_name (_tmp1313_);
			_tmp1315_ = _tmp1314_;
			_tmp1316_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1315_);
			_tmp1317_ = _tmp1316_;
			vala_report_error (_tmp1312_, _tmp1317_);
			_g_free0 (_tmp1317_);
			_g_free0 (_tmp1315_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1318_;
		_tmp1318_ = access;
		if (_tmp1318_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1319_;
			ValaSymbol* _tmp1320_;
			ValaSymbol* _tmp1321_;
			gboolean in_target_type = FALSE;
			_tmp1319_ = member;
			_tmp1320_ = vala_symbol_get_parent_symbol (_tmp1319_);
			_tmp1321_ = _tmp1320_;
			target_type = _tmp1321_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1322_;
				ValaSemanticAnalyzer* _tmp1323_;
				ValaSymbol* _tmp1324_;
				ValaSymbol* _tmp1325_;
				ValaSymbol* _tmp1326_;
				_tmp1322_ = vala_code_context_get_analyzer (context);
				_tmp1323_ = _tmp1322_;
				_tmp1324_ = vala_semantic_analyzer_get_current_symbol (_tmp1323_);
				_tmp1325_ = _tmp1324_;
				_tmp1326_ = _vala_code_node_ref0 (_tmp1325_);
				this_symbol = _tmp1326_;
				{
					gboolean _tmp1327_ = FALSE;
					_tmp1327_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1332_;
						ValaSymbol* _tmp1333_;
						ValaSymbol* _tmp1334_;
						if (!_tmp1327_) {
							ValaSymbol* _tmp1328_;
							ValaSymbol* _tmp1329_;
							ValaSymbol* _tmp1330_;
							ValaSymbol* _tmp1331_;
							_tmp1328_ = this_symbol;
							_tmp1329_ = vala_symbol_get_parent_symbol (_tmp1328_);
							_tmp1330_ = _tmp1329_;
							_tmp1331_ = _vala_code_node_ref0 (_tmp1330_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1331_;
						}
						_tmp1327_ = FALSE;
						_tmp1332_ = this_symbol;
						if (!(_tmp1332_ != NULL)) {
							break;
						}
						_tmp1333_ = target_type;
						_tmp1334_ = this_symbol;
						if (_tmp1333_ == _tmp1334_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1335_;
				ValaSourceReference* _tmp1336_;
				ValaSymbol* _tmp1337_;
				gchar* _tmp1338_;
				gchar* _tmp1339_;
				gchar* _tmp1340_;
				gchar* _tmp1341_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1335_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1336_ = _tmp1335_;
				_tmp1337_ = member;
				_tmp1338_ = vala_symbol_get_full_name (_tmp1337_);
				_tmp1339_ = _tmp1338_;
				_tmp1340_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1339_);
				_tmp1341_ = _tmp1340_;
				vala_report_error (_tmp1336_, _tmp1341_);
				_g_free0 (_tmp1341_);
				_g_free0 (_tmp1339_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1343_;
		ValaExpression* _tmp1344_;
		_tmp1343_ = vala_member_access_get_inner (self);
		_tmp1344_ = _tmp1343_;
		_tmp1342_ = _tmp1344_ != NULL;
	} else {
		_tmp1342_ = FALSE;
	}
	if (_tmp1342_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1345_;
		ValaExpression* _tmp1346_;
		ValaDataType* _tmp1347_;
		ValaDataType* _tmp1348_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1349_;
		ValaExpression* _tmp1350_;
		ValaDataType* _tmp1351_;
		ValaDataType* _tmp1352_;
		ValaPointerType* _tmp1353_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1357_;
		gboolean _tmp1358_ = FALSE;
		gboolean _tmp1359_ = FALSE;
		ValaObjectType* _tmp1360_;
		_tmp1345_ = vala_member_access_get_inner (self);
		_tmp1346_ = _tmp1345_;
		_tmp1347_ = vala_expression_get_value_type (_tmp1346_);
		_tmp1348_ = _tmp1347_;
		instance_type = _tmp1348_;
		_tmp1349_ = vala_member_access_get_inner (self);
		_tmp1350_ = _tmp1349_;
		_tmp1351_ = vala_expression_get_value_type (_tmp1350_);
		_tmp1352_ = _tmp1351_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1352_) ? ((ValaPointerType*) _tmp1352_) : NULL;
		_tmp1353_ = pointer_type;
		if (_tmp1353_ != NULL) {
			ValaPointerType* _tmp1354_;
			ValaDataType* _tmp1355_;
			ValaDataType* _tmp1356_;
			_tmp1354_ = pointer_type;
			_tmp1355_ = vala_pointer_type_get_base_type (_tmp1354_);
			_tmp1356_ = _tmp1355_;
			instance_type = _tmp1356_;
		}
		_tmp1357_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1357_) ? ((ValaObjectType*) _tmp1357_) : NULL;
		_tmp1360_ = object_type;
		if (_tmp1360_ != NULL) {
			ValaObjectType* _tmp1361_;
			ValaObjectTypeSymbol* _tmp1362_;
			ValaObjectTypeSymbol* _tmp1363_;
			_tmp1361_ = object_type;
			_tmp1362_ = vala_object_type_get_object_type_symbol (_tmp1361_);
			_tmp1363_ = _tmp1362_;
			_tmp1359_ = vala_object_type_symbol_has_type_parameters (_tmp1363_);
		} else {
			_tmp1359_ = FALSE;
		}
		if (_tmp1359_) {
			ValaDataType* _tmp1364_;
			_tmp1364_ = instance_type;
			_tmp1358_ = !vala_data_type_has_type_arguments (_tmp1364_);
		} else {
			_tmp1358_ = FALSE;
		}
		if (_tmp1358_) {
			ValaExpression* _tmp1365_;
			ValaExpression* _tmp1366_;
			ValaSourceReference* _tmp1367_;
			ValaSourceReference* _tmp1368_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1365_ = vala_member_access_get_inner (self);
			_tmp1366_ = _tmp1365_;
			_tmp1367_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1366_);
			_tmp1368_ = _tmp1367_;
			vala_report_error (_tmp1368_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1370_ = !may_access_instance_members;
	} else {
		_tmp1370_ = FALSE;
	}
	if (_tmp1370_) {
		_tmp1369_ = TRUE;
	} else {
		gboolean _tmp1371_ = FALSE;
		if (klass) {
			_tmp1371_ = !may_access_klass_members;
		} else {
			_tmp1371_ = FALSE;
		}
		_tmp1369_ = _tmp1371_;
	}
	if (_tmp1369_) {
		ValaSymbol* _tmp1372_;
		ValaSymbol* _tmp1373_;
		ValaDataType* _tmp1396_;
		ValaDataType* _tmp1397_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1372_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1373_ = _tmp1372_;
		if (VALA_IS_METHOD (_tmp1373_)) {
			ValaSemanticAnalyzer* _tmp1374_;
			ValaSemanticAnalyzer* _tmp1375_;
			ValaSymbol* _tmp1376_;
			ValaSymbol* _tmp1377_;
			gboolean _tmp1378_;
			gboolean _tmp1379_;
			ValaDataType* _tmp1380_;
			ValaDataType* _tmp1381_;
			_tmp1374_ = vala_code_context_get_analyzer (context);
			_tmp1375_ = _tmp1374_;
			_tmp1376_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1377_ = _tmp1376_;
			_tmp1378_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1379_ = _tmp1378_;
			_tmp1380_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1375_, _tmp1377_, _tmp1379_);
			_tmp1381_ = _tmp1380_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1381_);
			_vala_code_node_unref0 (_tmp1381_);
		} else {
			ValaSymbol* _tmp1382_;
			ValaSymbol* _tmp1383_;
			_tmp1382_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1383_ = _tmp1382_;
			if (VALA_IS_FIELD (_tmp1383_)) {
				ValaSymbol* _tmp1384_;
				ValaSymbol* _tmp1385_;
				ValaFieldPrototype* _tmp1386_;
				ValaFieldPrototype* _tmp1387_;
				_tmp1384_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1385_ = _tmp1384_;
				_tmp1386_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1385_, VALA_TYPE_FIELD, ValaField));
				_tmp1387_ = _tmp1386_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1387_);
				_vala_code_node_unref0 (_tmp1387_);
			} else {
				ValaSymbol* _tmp1388_;
				ValaSymbol* _tmp1389_;
				_tmp1388_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1389_ = _tmp1388_;
				if (VALA_IS_PROPERTY (_tmp1389_)) {
					ValaSymbol* _tmp1390_;
					ValaSymbol* _tmp1391_;
					ValaPropertyPrototype* _tmp1392_;
					ValaPropertyPrototype* _tmp1393_;
					_tmp1390_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1391_ = _tmp1390_;
					_tmp1392_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1391_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1393_ = _tmp1392_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1393_);
					_vala_code_node_unref0 (_tmp1393_);
				} else {
					ValaInvalidType* _tmp1394_;
					ValaInvalidType* _tmp1395_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1394_ = vala_invalid_type_new ();
					_tmp1395_ = _tmp1394_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1395_);
					_vala_code_node_unref0 (_tmp1395_);
				}
			}
		}
		_tmp1396_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1397_ = _tmp1396_;
		if (_tmp1397_ != NULL) {
			ValaDataType* _tmp1398_;
			ValaDataType* _tmp1399_;
			ValaDataType* _tmp1400_;
			ValaDataType* _tmp1401_;
			gboolean _tmp1402_;
			gboolean _tmp1403_;
			_tmp1398_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1399_ = _tmp1398_;
			_tmp1400_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1401_ = _tmp1400_;
			_tmp1402_ = vala_data_type_get_value_owned (_tmp1401_);
			_tmp1403_ = _tmp1402_;
			vala_data_type_set_value_owned (_tmp1399_, _tmp1403_);
		}
	} else {
		gboolean _tmp1404_ = FALSE;
		gboolean _tmp1425_ = FALSE;
		gboolean _tmp1426_ = FALSE;
		gboolean _tmp1427_ = FALSE;
		gboolean _tmp1428_ = FALSE;
		gboolean _tmp1471_ = FALSE;
		gboolean _tmp1472_ = FALSE;
		gboolean _tmp1473_ = FALSE;
		gboolean _tmp1474_ = FALSE;
		gboolean _tmp1475_ = FALSE;
		gboolean _tmp1476_;
		gboolean _tmp1477_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1504_;
		ValaSymbol* _tmp1505_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1506_;
		ValaExpression* _tmp1507_;
		gboolean _tmp1508_ = FALSE;
		gboolean _tmp1509_ = FALSE;
		gboolean _tmp1510_ = FALSE;
		gboolean _tmp1511_ = FALSE;
		gboolean _tmp1512_ = FALSE;
		ValaMethod* _tmp1513_;
		ValaSemanticAnalyzer* _tmp1552_;
		ValaSemanticAnalyzer* _tmp1553_;
		ValaSymbol* _tmp1554_;
		ValaSymbol* _tmp1555_;
		gboolean _tmp1556_;
		gboolean _tmp1557_;
		ValaDataType* _tmp1558_;
		ValaDataType* _tmp1559_;
		gboolean _tmp1560_ = FALSE;
		ValaExpression* _tmp1561_;
		ValaExpression* _tmp1562_;
		ValaSymbol* _tmp1575_;
		ValaSymbol* _tmp1576_;
		if (instance) {
			ValaExpression* _tmp1405_;
			ValaExpression* _tmp1406_;
			_tmp1405_ = vala_member_access_get_inner (self);
			_tmp1406_ = _tmp1405_;
			_tmp1404_ = _tmp1406_ == NULL;
		} else {
			_tmp1404_ = FALSE;
		}
		if (_tmp1404_) {
			ValaSourceReference* _tmp1407_;
			ValaSourceReference* _tmp1408_;
			ValaMemberAccess* _tmp1409_;
			ValaMemberAccess* _tmp1410_;
			ValaExpression* _tmp1411_;
			ValaExpression* _tmp1412_;
			ValaParameter* _tmp1413_;
			ValaDataType* _tmp1414_;
			ValaDataType* _tmp1415_;
			ValaDataType* _tmp1416_;
			ValaDataType* _tmp1417_;
			ValaExpression* _tmp1418_;
			ValaExpression* _tmp1419_;
			ValaDataType* _tmp1420_;
			ValaDataType* _tmp1421_;
			ValaExpression* _tmp1422_;
			ValaExpression* _tmp1423_;
			ValaParameter* _tmp1424_;
			_tmp1407_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1408_ = _tmp1407_;
			_tmp1409_ = vala_member_access_new (NULL, "this", _tmp1408_);
			_tmp1410_ = _tmp1409_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1410_);
			_vala_code_node_unref0 (_tmp1410_);
			_tmp1411_ = vala_member_access_get_inner (self);
			_tmp1412_ = _tmp1411_;
			_tmp1413_ = this_parameter;
			_tmp1414_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1413_);
			_tmp1415_ = _tmp1414_;
			_tmp1416_ = vala_data_type_copy (_tmp1415_);
			_tmp1417_ = _tmp1416_;
			vala_expression_set_value_type (_tmp1412_, _tmp1417_);
			_vala_code_node_unref0 (_tmp1417_);
			_tmp1418_ = vala_member_access_get_inner (self);
			_tmp1419_ = _tmp1418_;
			_tmp1420_ = vala_expression_get_value_type (_tmp1419_);
			_tmp1421_ = _tmp1420_;
			vala_data_type_set_value_owned (_tmp1421_, FALSE);
			_tmp1422_ = vala_member_access_get_inner (self);
			_tmp1423_ = _tmp1422_;
			_tmp1424_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1423_, (ValaSymbol*) _tmp1424_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1428_ = !klass;
		} else {
			_tmp1428_ = FALSE;
		}
		if (_tmp1428_) {
			ValaSymbol* _tmp1429_;
			ValaSymbol* _tmp1430_;
			_tmp1429_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1430_ = _tmp1429_;
			_tmp1427_ = !VALA_IS_CREATION_METHOD (_tmp1430_);
		} else {
			_tmp1427_ = FALSE;
		}
		if (_tmp1427_) {
			_tmp1426_ = may_access_instance_members;
		} else {
			_tmp1426_ = FALSE;
		}
		if (_tmp1426_) {
			ValaExpression* _tmp1431_;
			ValaExpression* _tmp1432_;
			_tmp1431_ = vala_member_access_get_inner (self);
			_tmp1432_ = _tmp1431_;
			_tmp1425_ = _tmp1432_ != NULL;
		} else {
			_tmp1425_ = FALSE;
		}
		if (_tmp1425_) {
			ValaExpression* _tmp1433_;
			ValaExpression* _tmp1434_;
			ValaSymbol* _tmp1435_;
			ValaSymbol* _tmp1436_;
			_tmp1433_ = vala_member_access_get_inner (self);
			_tmp1434_ = _tmp1433_;
			_tmp1435_ = vala_expression_get_symbol_reference (_tmp1434_);
			_tmp1436_ = _tmp1435_;
			if (VALA_IS_METHOD (_tmp1436_)) {
			} else {
				ValaSourceReference* _tmp1437_;
				ValaSourceReference* _tmp1438_;
				ValaSymbol* _tmp1439_;
				ValaSymbol* _tmp1440_;
				gchar* _tmp1441_;
				gchar* _tmp1442_;
				gchar* _tmp1443_;
				gchar* _tmp1444_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1445_;
				ValaSymbol* _tmp1446_;
				ValaSymbol* _tmp1447_;
				ValaSymbol* _tmp1448_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1468_;
				ValaExpression* _tmp1469_;
				ValaExpression* _tmp1470_;
				_tmp1437_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1438_ = _tmp1437_;
				_tmp1439_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1440_ = _tmp1439_;
				_tmp1441_ = vala_symbol_get_full_name (_tmp1440_);
				_tmp1442_ = _tmp1441_;
				_tmp1443_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1442_);
				_tmp1444_ = _tmp1443_;
				vala_report_warning (_tmp1438_, _tmp1444_);
				_g_free0 (_tmp1444_);
				_g_free0 (_tmp1442_);
				_tmp1445_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1446_ = _tmp1445_;
				_tmp1447_ = vala_symbol_get_parent_symbol (_tmp1446_);
				_tmp1448_ = _tmp1447_;
				inner_sym = _tmp1448_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1449_ = FALSE;
					ValaSymbol* _tmp1450_;
					ValaMemberAccess* _tmp1454_;
					ValaSymbol* _tmp1455_;
					const gchar* _tmp1456_;
					const gchar* _tmp1457_;
					ValaSourceReference* _tmp1458_;
					ValaSourceReference* _tmp1459_;
					ValaMemberAccess* _tmp1460_;
					ValaMemberAccess* _tmp1461_;
					ValaMemberAccess* _tmp1462_;
					ValaExpression* _tmp1463_;
					ValaExpression* _tmp1464_;
					ValaSymbol* _tmp1465_;
					ValaSymbol* _tmp1466_;
					ValaSymbol* _tmp1467_;
					_tmp1450_ = inner_sym;
					if (_tmp1450_ != NULL) {
						ValaSymbol* _tmp1451_;
						const gchar* _tmp1452_;
						const gchar* _tmp1453_;
						_tmp1451_ = inner_sym;
						_tmp1452_ = vala_symbol_get_name (_tmp1451_);
						_tmp1453_ = _tmp1452_;
						_tmp1449_ = _tmp1453_ != NULL;
					} else {
						_tmp1449_ = FALSE;
					}
					if (!_tmp1449_) {
						break;
					}
					_tmp1454_ = inner_ma;
					_tmp1455_ = inner_sym;
					_tmp1456_ = vala_symbol_get_name (_tmp1455_);
					_tmp1457_ = _tmp1456_;
					_tmp1458_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1459_ = _tmp1458_;
					_tmp1460_ = vala_member_access_new (NULL, _tmp1457_, _tmp1459_);
					_tmp1461_ = _tmp1460_;
					vala_member_access_set_inner (_tmp1454_, (ValaExpression*) _tmp1461_);
					_vala_code_node_unref0 (_tmp1461_);
					_tmp1462_ = inner_ma;
					_tmp1463_ = vala_member_access_get_inner (_tmp1462_);
					_tmp1464_ = _tmp1463_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1464_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1465_ = inner_sym;
					_tmp1466_ = vala_symbol_get_parent_symbol (_tmp1465_);
					_tmp1467_ = _tmp1466_;
					inner_sym = _tmp1467_;
				}
				_tmp1468_ = inner_ma;
				vala_member_access_set_qualified (_tmp1468_, TRUE);
				_tmp1469_ = vala_member_access_get_inner (self);
				_tmp1470_ = _tmp1469_;
				vala_code_node_check ((ValaCodeNode*) _tmp1470_, context);
			}
		}
		_tmp1476_ = vala_code_context_get_experimental_non_null (context);
		_tmp1477_ = _tmp1476_;
		if (_tmp1477_) {
			_tmp1475_ = instance;
		} else {
			_tmp1475_ = FALSE;
		}
		if (_tmp1475_) {
			ValaExpression* _tmp1478_;
			ValaExpression* _tmp1479_;
			ValaDataType* _tmp1480_;
			ValaDataType* _tmp1481_;
			gboolean _tmp1482_;
			gboolean _tmp1483_;
			_tmp1478_ = vala_member_access_get_inner (self);
			_tmp1479_ = _tmp1478_;
			_tmp1480_ = vala_expression_get_value_type (_tmp1479_);
			_tmp1481_ = _tmp1480_;
			_tmp1482_ = vala_data_type_get_nullable (_tmp1481_);
			_tmp1483_ = _tmp1482_;
			_tmp1474_ = _tmp1483_;
		} else {
			_tmp1474_ = FALSE;
		}
		if (_tmp1474_) {
			ValaExpression* _tmp1484_;
			ValaExpression* _tmp1485_;
			ValaDataType* _tmp1486_;
			ValaDataType* _tmp1487_;
			_tmp1484_ = vala_member_access_get_inner (self);
			_tmp1485_ = _tmp1484_;
			_tmp1486_ = vala_expression_get_value_type (_tmp1485_);
			_tmp1487_ = _tmp1486_;
			_tmp1473_ = !VALA_IS_POINTER_TYPE (_tmp1487_);
		} else {
			_tmp1473_ = FALSE;
		}
		if (_tmp1473_) {
			ValaExpression* _tmp1488_;
			ValaExpression* _tmp1489_;
			ValaDataType* _tmp1490_;
			ValaDataType* _tmp1491_;
			_tmp1488_ = vala_member_access_get_inner (self);
			_tmp1489_ = _tmp1488_;
			_tmp1490_ = vala_expression_get_value_type (_tmp1489_);
			_tmp1491_ = _tmp1490_;
			_tmp1472_ = !VALA_IS_GENERIC_TYPE (_tmp1491_);
		} else {
			_tmp1472_ = FALSE;
		}
		if (_tmp1472_) {
			ValaExpression* _tmp1492_;
			ValaExpression* _tmp1493_;
			ValaDataType* _tmp1494_;
			ValaDataType* _tmp1495_;
			_tmp1492_ = vala_member_access_get_inner (self);
			_tmp1493_ = _tmp1492_;
			_tmp1494_ = vala_expression_get_value_type (_tmp1493_);
			_tmp1495_ = _tmp1494_;
			_tmp1471_ = !VALA_IS_ARRAY_TYPE (_tmp1495_);
		} else {
			_tmp1471_ = FALSE;
		}
		if (_tmp1471_) {
			ValaSourceReference* _tmp1496_;
			ValaSourceReference* _tmp1497_;
			ValaSymbol* _tmp1498_;
			ValaSymbol* _tmp1499_;
			gchar* _tmp1500_;
			gchar* _tmp1501_;
			gchar* _tmp1502_;
			gchar* _tmp1503_;
			_tmp1496_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1497_ = _tmp1496_;
			_tmp1498_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1499_ = _tmp1498_;
			_tmp1500_ = vala_symbol_get_full_name (_tmp1499_);
			_tmp1501_ = _tmp1500_;
			_tmp1502_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1501_);
			_tmp1503_ = _tmp1502_;
			vala_report_error (_tmp1497_, _tmp1503_);
			_g_free0 (_tmp1503_);
			_g_free0 (_tmp1501_);
		}
		_tmp1504_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1505_ = _tmp1504_;
		m = VALA_IS_METHOD (_tmp1505_) ? ((ValaMethod*) _tmp1505_) : NULL;
		_tmp1506_ = vala_member_access_get_inner (self);
		_tmp1507_ = _tmp1506_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1507_) ? ((ValaMemberAccess*) _tmp1507_) : NULL;
		_tmp1513_ = m;
		if (_tmp1513_ != NULL) {
			ValaMethod* _tmp1514_;
			ValaMemberBinding _tmp1515_;
			ValaMemberBinding _tmp1516_;
			_tmp1514_ = m;
			_tmp1515_ = vala_method_get_binding (_tmp1514_);
			_tmp1516_ = _tmp1515_;
			_tmp1512_ = _tmp1516_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1512_ = FALSE;
		}
		if (_tmp1512_) {
			ValaMethod* _tmp1517_;
			ValaSymbol* _tmp1518_;
			ValaSymbol* _tmp1519_;
			_tmp1517_ = m;
			_tmp1518_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1517_);
			_tmp1519_ = _tmp1518_;
			_tmp1511_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1519_);
		} else {
			_tmp1511_ = FALSE;
		}
		if (_tmp1511_) {
			ValaExpression* _tmp1520_;
			ValaExpression* _tmp1521_;
			_tmp1520_ = vala_member_access_get_inner (self);
			_tmp1521_ = _tmp1520_;
			_tmp1510_ = _tmp1521_ != NULL;
		} else {
			_tmp1510_ = FALSE;
		}
		if (_tmp1510_) {
			ValaExpression* _tmp1522_;
			ValaExpression* _tmp1523_;
			ValaDataType* _tmp1524_;
			ValaDataType* _tmp1525_;
			_tmp1522_ = vala_member_access_get_inner (self);
			_tmp1523_ = _tmp1522_;
			_tmp1524_ = vala_expression_get_value_type (_tmp1523_);
			_tmp1525_ = _tmp1524_;
			_tmp1509_ = _tmp1525_ == NULL;
		} else {
			_tmp1509_ = FALSE;
		}
		if (_tmp1509_) {
			ValaMemberAccess* _tmp1526_;
			ValaList* _tmp1527_;
			gint _tmp1528_;
			gint _tmp1529_;
			_tmp1526_ = inner_ma;
			_tmp1527_ = _tmp1526_->priv->type_argument_list;
			_tmp1528_ = vala_collection_get_size ((ValaCollection*) _tmp1527_);
			_tmp1529_ = _tmp1528_;
			_tmp1508_ = _tmp1529_ > 0;
		} else {
			_tmp1508_ = FALSE;
		}
		if (_tmp1508_) {
			ValaExpression* _tmp1530_;
			ValaExpression* _tmp1531_;
			ValaMethod* _tmp1532_;
			ValaSymbol* _tmp1533_;
			ValaSymbol* _tmp1534_;
			ValaObjectType* _tmp1535_;
			ValaObjectType* _tmp1536_;
			_tmp1530_ = vala_member_access_get_inner (self);
			_tmp1531_ = _tmp1530_;
			_tmp1532_ = m;
			_tmp1533_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1532_);
			_tmp1534_ = _tmp1533_;
			_tmp1535_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1534_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1536_ = _tmp1535_;
			vala_expression_set_value_type (_tmp1531_, (ValaDataType*) _tmp1536_);
			_vala_code_node_unref0 (_tmp1536_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1537_;
				ValaList* _tmp1538_;
				ValaList* _tmp1539_;
				gint _type_argument_size = 0;
				ValaList* _tmp1540_;
				gint _tmp1541_;
				gint _tmp1542_;
				gint _type_argument_index = 0;
				_tmp1537_ = inner_ma;
				_tmp1538_ = _tmp1537_->priv->type_argument_list;
				_tmp1539_ = _vala_iterable_ref0 (_tmp1538_);
				_type_argument_list = _tmp1539_;
				_tmp1540_ = _type_argument_list;
				_tmp1541_ = vala_collection_get_size ((ValaCollection*) _tmp1540_);
				_tmp1542_ = _tmp1541_;
				_type_argument_size = _tmp1542_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1543_;
					gint _tmp1544_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1545_;
					gpointer _tmp1546_;
					ValaExpression* _tmp1547_;
					ValaExpression* _tmp1548_;
					ValaDataType* _tmp1549_;
					ValaDataType* _tmp1550_;
					ValaDataType* _tmp1551_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1543_ = _type_argument_index;
					_tmp1544_ = _type_argument_size;
					if (!(_tmp1543_ < _tmp1544_)) {
						break;
					}
					_tmp1545_ = _type_argument_list;
					_tmp1546_ = vala_list_get (_tmp1545_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1546_;
					_tmp1547_ = vala_member_access_get_inner (self);
					_tmp1548_ = _tmp1547_;
					_tmp1549_ = vala_expression_get_value_type (_tmp1548_);
					_tmp1550_ = _tmp1549_;
					_tmp1551_ = type_argument;
					vala_data_type_add_type_argument (_tmp1550_, _tmp1551_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1552_ = vala_code_context_get_analyzer (context);
		_tmp1553_ = _tmp1552_;
		_tmp1554_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1555_ = _tmp1554_;
		_tmp1556_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1557_ = _tmp1556_;
		_tmp1558_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1553_, _tmp1555_, _tmp1557_);
		_tmp1559_ = _tmp1558_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1559_);
		_vala_code_node_unref0 (_tmp1559_);
		_tmp1561_ = vala_member_access_get_inner (self);
		_tmp1562_ = _tmp1561_;
		if (_tmp1562_ != NULL) {
			ValaDataType* _tmp1563_;
			ValaDataType* _tmp1564_;
			_tmp1563_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1564_ = _tmp1563_;
			_tmp1560_ = _tmp1564_ != NULL;
		} else {
			_tmp1560_ = FALSE;
		}
		if (_tmp1560_) {
			ValaDataType* _tmp1565_;
			ValaDataType* _tmp1566_;
			ValaExpression* _tmp1567_;
			ValaExpression* _tmp1568_;
			ValaDataType* _tmp1569_;
			ValaDataType* _tmp1570_;
			ValaDataType* _tmp1571_;
			ValaDataType* _tmp1572_;
			_tmp1565_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1566_ = _tmp1565_;
			_tmp1567_ = vala_member_access_get_inner (self);
			_tmp1568_ = _tmp1567_;
			_tmp1569_ = vala_expression_get_value_type (_tmp1568_);
			_tmp1570_ = _tmp1569_;
			_tmp1571_ = vala_data_type_get_actual_type (_tmp1566_, _tmp1570_, NULL, (ValaCodeNode*) self);
			_tmp1572_ = _tmp1571_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1572_);
			_vala_code_node_unref0 (_tmp1572_);
		} else {
			ValaDataType* _tmp1573_;
			ValaDataType* _tmp1574_;
			_tmp1573_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1574_ = _tmp1573_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1574_);
		}
		_tmp1575_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1576_ = _tmp1575_;
		if (VALA_IS_METHOD (_tmp1576_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1577_;
			ValaSymbol* _tmp1578_;
			ValaDataType* _tmp1579_;
			ValaDataType* _tmp1580_;
			gboolean _tmp1587_ = FALSE;
			_tmp1577_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1578_ = _tmp1577_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1578_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1579_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1580_ = _tmp1579_;
			if (_tmp1580_ != NULL) {
				ValaDataType* _tmp1581_;
				ValaDataType* _tmp1582_;
				ValaDataType* _tmp1583_;
				ValaDataType* _tmp1584_;
				gboolean _tmp1585_;
				gboolean _tmp1586_;
				_tmp1581_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1582_ = _tmp1581_;
				_tmp1583_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1584_ = _tmp1583_;
				_tmp1585_ = vala_data_type_get_value_owned (_tmp1584_);
				_tmp1586_ = _tmp1585_;
				vala_data_type_set_value_owned (_tmp1582_, _tmp1586_);
			}
			if (instance) {
				ValaMethod* _tmp1588_;
				ValaSymbol* _tmp1589_;
				ValaSymbol* _tmp1590_;
				_tmp1588_ = method;
				_tmp1589_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1588_);
				_tmp1590_ = _tmp1589_;
				_tmp1587_ = VALA_IS_TYPESYMBOL (_tmp1590_);
			} else {
				_tmp1587_ = FALSE;
			}
			if (_tmp1587_) {
				ValaExpression* _tmp1591_;
				ValaExpression* _tmp1592_;
				ValaMethod* _tmp1593_;
				ValaSymbol* _tmp1594_;
				ValaSymbol* _tmp1595_;
				ValaDataType* _tmp1596_;
				ValaDataType* _tmp1597_;
				ValaExpression* _tmp1598_;
				ValaExpression* _tmp1599_;
				ValaDataType* _tmp1600_;
				ValaDataType* _tmp1601_;
				ValaMethod* _tmp1602_;
				ValaParameter* _tmp1603_;
				ValaParameter* _tmp1604_;
				ValaDataType* _tmp1605_;
				ValaDataType* _tmp1606_;
				gboolean _tmp1607_;
				gboolean _tmp1608_;
				_tmp1591_ = vala_member_access_get_inner (self);
				_tmp1592_ = _tmp1591_;
				_tmp1593_ = method;
				_tmp1594_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1593_);
				_tmp1595_ = _tmp1594_;
				_tmp1596_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1595_);
				_tmp1597_ = _tmp1596_;
				vala_expression_set_target_type (_tmp1592_, _tmp1597_);
				_vala_code_node_unref0 (_tmp1597_);
				_tmp1598_ = vala_member_access_get_inner (self);
				_tmp1599_ = _tmp1598_;
				_tmp1600_ = vala_expression_get_target_type (_tmp1599_);
				_tmp1601_ = _tmp1600_;
				_tmp1602_ = method;
				_tmp1603_ = vala_method_get_this_parameter (_tmp1602_);
				_tmp1604_ = _tmp1603_;
				_tmp1605_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1604_);
				_tmp1606_ = _tmp1605_;
				_tmp1607_ = vala_data_type_get_value_owned (_tmp1606_);
				_tmp1608_ = _tmp1607_;
				vala_data_type_set_value_owned (_tmp1601_, _tmp1608_);
			}
		} else {
			gboolean _tmp1609_ = FALSE;
			gboolean _tmp1610_ = FALSE;
			ValaSymbol* _tmp1611_;
			ValaSymbol* _tmp1612_;
			_tmp1611_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1612_ = _tmp1611_;
			if (VALA_IS_PROPERTY (_tmp1612_)) {
				_tmp1610_ = instance;
			} else {
				_tmp1610_ = FALSE;
			}
			if (_tmp1610_) {
				ValaSymbol* _tmp1613_;
				ValaSymbol* _tmp1614_;
				ValaSymbol* _tmp1615_;
				ValaSymbol* _tmp1616_;
				_tmp1613_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1614_ = _tmp1613_;
				_tmp1615_ = vala_symbol_get_parent_symbol (_tmp1614_);
				_tmp1616_ = _tmp1615_;
				_tmp1609_ = _tmp1616_ != NULL;
			} else {
				_tmp1609_ = FALSE;
			}
			if (_tmp1609_) {
				ValaExpression* _tmp1617_;
				ValaExpression* _tmp1618_;
				ValaSymbol* _tmp1619_;
				ValaSymbol* _tmp1620_;
				ValaSymbol* _tmp1621_;
				ValaSymbol* _tmp1622_;
				ValaDataType* _tmp1623_;
				ValaDataType* _tmp1624_;
				_tmp1617_ = vala_member_access_get_inner (self);
				_tmp1618_ = _tmp1617_;
				_tmp1619_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1620_ = _tmp1619_;
				_tmp1621_ = vala_symbol_get_parent_symbol (_tmp1620_);
				_tmp1622_ = _tmp1621_;
				_tmp1623_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1622_);
				_tmp1624_ = _tmp1623_;
				vala_expression_set_target_type (_tmp1618_, _tmp1624_);
				_vala_code_node_unref0 (_tmp1624_);
			} else {
				gboolean _tmp1625_ = FALSE;
				gboolean _tmp1626_ = FALSE;
				gboolean _tmp1627_ = FALSE;
				ValaSymbol* _tmp1628_;
				ValaSymbol* _tmp1629_;
				_tmp1628_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1629_ = _tmp1628_;
				if (VALA_IS_FIELD (_tmp1629_)) {
					_tmp1627_ = TRUE;
				} else {
					ValaSymbol* _tmp1630_;
					ValaSymbol* _tmp1631_;
					_tmp1630_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1631_ = _tmp1630_;
					_tmp1627_ = VALA_IS_SIGNAL (_tmp1631_);
				}
				if (_tmp1627_) {
					_tmp1626_ = instance;
				} else {
					_tmp1626_ = FALSE;
				}
				if (_tmp1626_) {
					ValaSymbol* _tmp1632_;
					ValaSymbol* _tmp1633_;
					ValaSymbol* _tmp1634_;
					ValaSymbol* _tmp1635_;
					_tmp1632_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1633_ = _tmp1632_;
					_tmp1634_ = vala_symbol_get_parent_symbol (_tmp1633_);
					_tmp1635_ = _tmp1634_;
					_tmp1625_ = _tmp1635_ != NULL;
				} else {
					_tmp1625_ = FALSE;
				}
				if (_tmp1625_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1636_;
					ValaSymbol* _tmp1637_;
					ValaSymbol* _tmp1638_;
					ValaSymbol* _tmp1639_;
					ValaDataType* _tmp1640_;
					ValaExpression* _tmp1641_;
					ValaExpression* _tmp1642_;
					ValaDataType* _tmp1643_;
					ValaExpression* _tmp1644_;
					ValaExpression* _tmp1645_;
					ValaDataType* _tmp1646_;
					ValaDataType* _tmp1647_;
					ValaDataType* _tmp1648_;
					ValaDataType* _tmp1649_;
					_tmp1636_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1637_ = _tmp1636_;
					_tmp1638_ = vala_symbol_get_parent_symbol (_tmp1637_);
					_tmp1639_ = _tmp1638_;
					_tmp1640_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1639_);
					parent_type = _tmp1640_;
					_tmp1641_ = vala_member_access_get_inner (self);
					_tmp1642_ = _tmp1641_;
					_tmp1643_ = parent_type;
					_tmp1644_ = vala_member_access_get_inner (self);
					_tmp1645_ = _tmp1644_;
					_tmp1646_ = vala_expression_get_value_type (_tmp1645_);
					_tmp1647_ = _tmp1646_;
					_tmp1648_ = vala_data_type_get_actual_type (_tmp1643_, _tmp1647_, NULL, (ValaCodeNode*) self);
					_tmp1649_ = _tmp1648_;
					vala_expression_set_target_type (_tmp1642_, _tmp1649_);
					_vala_code_node_unref0 (_tmp1649_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1650_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1651_ = _tmp1650_;
	if (_tmp1651_ != NULL) {
		ValaDataType* _tmp1652_;
		ValaDataType* _tmp1653_;
		_tmp1652_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1653_ = _tmp1652_;
		vala_code_node_check ((ValaCodeNode*) _tmp1653_, context);
	}
	_tmp1654_ = self->priv->_tainted_access;
	if (!_tmp1654_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1655_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1656_ = _tmp1655_;
	result = !_tmp1656_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

