/* valaproperty.c generated by valac, the Vala compiler
 * generated from valaproperty.vala, do not modify */

/* valaproperty.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaPropertyPrivate {
	ValaParameter* _this_parameter;
	gboolean _interface_only;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	ValaMemberBinding _binding;
	gboolean _lock_used;
	ValaExpression* _initializer;
	ValaDataType* _data_type;
	ValaProperty* _base_property;
	ValaProperty* _base_interface_property;
	gboolean base_properties_valid;
	ValaPropertyAccessor* _get_accessor;
	ValaPropertyAccessor* _set_accessor;
	gchar* _nick;
	gchar* _blurb;
	gboolean* _notify;
	ValaField* _field;
	gboolean _field_checked;
};

static gint ValaProperty_private_offset;
static gpointer vala_property_parent_class = NULL;
static ValaLockableIface * vala_property_vala_lockable_parent_iface = NULL;

static gboolean* _bool_dup (gboolean* self);
static void vala_property_find_base_properties (ValaProperty* self);
static void vala_property_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor);
static void vala_property_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_property_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type);
static void vala_property_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node);
static void vala_property_find_base_interface_property (ValaProperty* self,
                                                 ValaClass* cl);
static void vala_property_find_base_class_property (ValaProperty* self,
                                             ValaClass* cl);
static gboolean vala_property_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context);
static void vala_property_finalize (ValaCodeNode * obj);
static GType vala_property_get_type_once (void);

static inline gpointer
vala_property_get_instance_private (ValaProperty* self)
{
	return G_STRUCT_MEMBER_P (self, ValaProperty_private_offset);
}

ValaDataType*
vala_property_get_property_type (ValaProperty* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_property_set_property_type (ValaProperty* self,
                                 ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	if (value != NULL) {
		ValaDataType* _tmp1_;
		_tmp1_ = self->priv->_data_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
	}
}

ValaPropertyAccessor*
vala_property_get_get_accessor (ValaProperty* self)
{
	ValaPropertyAccessor* result;
	ValaPropertyAccessor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_get_accessor;
	result = _tmp0_;
	return result;
}

void
vala_property_set_get_accessor (ValaProperty* self,
                                ValaPropertyAccessor* value)
{
	ValaPropertyAccessor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_get_accessor);
	self->priv->_get_accessor = _tmp0_;
	if (value != NULL) {
		ValaScope* _tmp1_;
		ValaScope* _tmp2_;
		_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp2_ = _tmp1_;
		vala_symbol_set_owner ((ValaSymbol*) value, _tmp2_);
	}
}

ValaPropertyAccessor*
vala_property_get_set_accessor (ValaProperty* self)
{
	ValaPropertyAccessor* result;
	ValaPropertyAccessor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_set_accessor;
	result = _tmp0_;
	return result;
}

void
vala_property_set_set_accessor (ValaProperty* self,
                                ValaPropertyAccessor* value)
{
	ValaPropertyAccessor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_set_accessor);
	self->priv->_set_accessor = _tmp0_;
	if (value != NULL) {
		ValaScope* _tmp1_;
		ValaScope* _tmp2_;
		_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp2_ = _tmp1_;
		vala_symbol_set_owner ((ValaSymbol*) value, _tmp2_);
	}
}

ValaParameter*
vala_property_get_this_parameter (ValaProperty* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}

void
vala_property_set_this_parameter (ValaProperty* self,
                                  ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}

gboolean
vala_property_get_interface_only (ValaProperty* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_interface_only;
	return result;
}

void
vala_property_set_interface_only (ValaProperty* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_interface_only = value;
}

gboolean
vala_property_get_is_abstract (ValaProperty* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_property_set_is_abstract (ValaProperty* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_property_get_is_virtual (ValaProperty* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_property_set_is_virtual (ValaProperty* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

gboolean
vala_property_get_overrides (ValaProperty* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}

void
vala_property_set_overrides (ValaProperty* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}

ValaField*
vala_property_get_field (ValaProperty* self)
{
	ValaField* result;
	ValaField* _tmp50_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->_field_checked) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp1_ = self->priv->_is_abstract;
		if (!_tmp1_) {
			ValaSourceFileType _tmp2_;
			ValaSourceFileType _tmp3_;
			_tmp2_ = vala_symbol_get_source_type ((ValaSymbol*) self);
			_tmp3_ = _tmp2_;
			_tmp0_ = _tmp3_ == VALA_SOURCE_FILE_TYPE_SOURCE;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gboolean has_get = FALSE;
			ValaPropertyAccessor* _tmp4_;
			ValaPropertyAccessor* _tmp5_;
			gboolean _tmp6_ = FALSE;
			gboolean get_has_body = FALSE;
			gboolean has_set = FALSE;
			ValaPropertyAccessor* _tmp11_;
			ValaPropertyAccessor* _tmp12_;
			gboolean _tmp13_ = FALSE;
			gboolean set_has_body = FALSE;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp22_ = FALSE;
			gboolean _tmp26_ = FALSE;
			_tmp4_ = vala_property_get_get_accessor (self);
			_tmp5_ = _tmp4_;
			has_get = _tmp5_ != NULL;
			if (has_get) {
				ValaPropertyAccessor* _tmp7_;
				ValaPropertyAccessor* _tmp8_;
				ValaBlock* _tmp9_;
				ValaBlock* _tmp10_;
				_tmp7_ = vala_property_get_get_accessor (self);
				_tmp8_ = _tmp7_;
				_tmp9_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp6_ = _tmp10_ != NULL;
			} else {
				_tmp6_ = FALSE;
			}
			get_has_body = _tmp6_;
			_tmp11_ = vala_property_get_set_accessor (self);
			_tmp12_ = _tmp11_;
			has_set = _tmp12_ != NULL;
			if (has_set) {
				ValaPropertyAccessor* _tmp14_;
				ValaPropertyAccessor* _tmp15_;
				ValaBlock* _tmp16_;
				ValaBlock* _tmp17_;
				_tmp14_ = vala_property_get_set_accessor (self);
				_tmp15_ = _tmp14_;
				_tmp16_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp13_ = _tmp17_ != NULL;
			} else {
				_tmp13_ = FALSE;
			}
			set_has_body = _tmp13_;
			if (set_has_body) {
				gboolean _tmp19_ = FALSE;
				if (has_get) {
					_tmp19_ = !get_has_body;
				} else {
					_tmp19_ = FALSE;
				}
				_tmp18_ = _tmp19_;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				ValaSourceReference* _tmp20_;
				ValaSourceReference* _tmp21_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp21_ = _tmp20_;
				vala_report_error (_tmp21_, "Property getter must have a body");
			}
			if (get_has_body) {
				gboolean _tmp23_ = FALSE;
				if (has_set) {
					_tmp23_ = !set_has_body;
				} else {
					_tmp23_ = FALSE;
				}
				_tmp22_ = _tmp23_;
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				ValaSourceReference* _tmp24_;
				ValaSourceReference* _tmp25_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp25_ = _tmp24_;
				vala_report_error (_tmp25_, "Property setter must have a body");
			}
			if (!get_has_body) {
				_tmp26_ = !set_has_body;
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				ValaDataType* _tmp31_;
				ValaDataType* _tmp32_;
				ValaDataType* _tmp33_;
				ValaDataType* _tmp34_;
				ValaExpression* _tmp35_;
				ValaExpression* _tmp36_;
				ValaSourceReference* _tmp37_;
				ValaSourceReference* _tmp38_;
				ValaField* _tmp39_;
				ValaField* _tmp40_;
				ValaField* _tmp41_;
				ValaMemberBinding _tmp42_;
				ValaAttribute* _tmp43_;
				_tmp27_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strdup_printf ("_%s", _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = vala_property_get_property_type (self);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_data_type_copy (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_property_get_initializer (self);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_field_new (_tmp30_, _tmp34_, _tmp36_, _tmp38_, NULL);
				_vala_code_node_unref0 (self->priv->_field);
				self->priv->_field = _tmp39_;
				_vala_code_node_unref0 (_tmp34_);
				_g_free0 (_tmp30_);
				_tmp40_ = self->priv->_field;
				vala_symbol_set_access ((ValaSymbol*) _tmp40_, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
				_tmp41_ = self->priv->_field;
				_tmp42_ = self->priv->_binding;
				vala_field_set_binding (_tmp41_, _tmp42_);
				_tmp43_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkChild");
				if (_tmp43_ != NULL) {
					ValaField* _tmp44_;
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					ValaField* _tmp49_;
					_tmp44_ = self->priv->_field;
					_tmp45_ = vala_symbol_get_name ((ValaSymbol*) self);
					_tmp46_ = _tmp45_;
					_tmp47_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "GtkChild", "name", _tmp46_);
					_tmp48_ = _tmp47_;
					vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp44_, "GtkChild", "name", _tmp48_, NULL);
					_g_free0 (_tmp48_);
					_tmp49_ = self->priv->_field;
					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp49_, "GtkChild", "internal", vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "GtkChild", "internal", FALSE), NULL);
				}
			}
		}
		self->priv->_field_checked = TRUE;
	}
	_tmp50_ = self->priv->_field;
	result = _tmp50_;
	return result;
}

ValaMemberBinding
vala_property_get_binding (ValaProperty* self)
{
	ValaMemberBinding result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_binding;
	return result;
}

void
vala_property_set_binding (ValaProperty* self,
                           ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

const gchar*
vala_property_get_nick (ValaProperty* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nick;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "Description", "nick", NULL);
		_g_free0 (self->priv->_nick);
		self->priv->_nick = _tmp1_;
		_tmp2_ = self->priv->_nick;
		if (_tmp2_ == NULL) {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp4_ = _tmp3_;
			_tmp5_ = string_replace (_tmp4_, "_", "-");
			_g_free0 (self->priv->_nick);
			self->priv->_nick = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_nick;
	result = _tmp6_;
	return result;
}

const gchar*
vala_property_get_blurb (ValaProperty* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_blurb;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "Description", "blurb", NULL);
		_g_free0 (self->priv->_blurb);
		self->priv->_blurb = _tmp1_;
		_tmp2_ = self->priv->_blurb;
		if (_tmp2_ == NULL) {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp4_ = _tmp3_;
			_tmp5_ = string_replace (_tmp4_, "_", "-");
			_g_free0 (self->priv->_blurb);
			self->priv->_blurb = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_blurb;
	result = _tmp6_;
	return result;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_property_get_notify (ValaProperty* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_notify;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "notify", TRUE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_notify);
		self->priv->_notify = _tmp2_;
	}
	_tmp3_ = self->priv->_notify;
	result = *_tmp3_;
	return result;
}

ValaProperty*
vala_property_get_base_property (ValaProperty* self)
{
	ValaProperty* result;
	ValaProperty* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_property_find_base_properties (self);
	_tmp0_ = self->priv->_base_property;
	result = _tmp0_;
	return result;
}

ValaProperty*
vala_property_get_base_interface_property (ValaProperty* self)
{
	ValaProperty* result;
	ValaProperty* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_property_find_base_properties (self);
	_tmp0_ = self->priv->_base_interface_property;
	result = _tmp0_;
	return result;
}

ValaExpression*
vala_property_get_initializer (ValaProperty* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initializer;
	result = _tmp0_;
	return result;
}

void
vala_property_set_initializer (ValaProperty* self,
                               ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_initializer);
	self->priv->_initializer = _tmp0_;
	_tmp1_ = self->priv->_initializer;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_property_real_get_lock_used (ValaLockable* base)
{
	gboolean result;
	ValaProperty* self;
	self = (ValaProperty*) base;
	result = self->priv->_lock_used;
	return result;
}

static void
vala_property_real_set_lock_used (ValaLockable* base,
                                  gboolean value)
{
	ValaProperty* self;
	self = (ValaProperty*) base;
	self->priv->_lock_used = value;
}

/**
 * Creates a new property.
 *
 * @param name              property name
 * @param property_type     property type
 * @param get_accessor      get accessor
 * @param set_accessor      set/construct accessor
 * @param source_reference  reference to source code
 * @return                  newly created property
 */
ValaProperty*
vala_property_construct (GType object_type,
                         const gchar* name,
                         ValaDataType* property_type,
                         ValaPropertyAccessor* get_accessor,
                         ValaPropertyAccessor* set_accessor,
                         ValaSourceReference* source_reference,
                         ValaComment* comment)
{
	ValaProperty* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaProperty*) vala_symbol_construct (object_type, name, source_reference, comment);
	vala_property_set_property_type (self, property_type);
	vala_property_set_get_accessor (self, get_accessor);
	vala_property_set_set_accessor (self, set_accessor);
	return self;
}

ValaProperty*
vala_property_new (const gchar* name,
                   ValaDataType* property_type,
                   ValaPropertyAccessor* get_accessor,
                   ValaPropertyAccessor* set_accessor,
                   ValaSourceReference* source_reference,
                   ValaComment* comment)
{
	return vala_property_construct (VALA_TYPE_PROPERTY, name, property_type, get_accessor, set_accessor, source_reference, comment);
}

static void
vala_property_real_accept (ValaCodeNode* base,
                           ValaCodeVisitor* visitor)
{
	ValaProperty * self;
	self = (ValaProperty*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_property (visitor, self);
}

static void
vala_property_real_accept_children (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaProperty * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaPropertyAccessor* _tmp2_;
	ValaPropertyAccessor* _tmp3_;
	ValaPropertyAccessor* _tmp6_;
	ValaPropertyAccessor* _tmp7_;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	self = (ValaProperty*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_property_get_property_type (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_property_get_get_accessor (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaPropertyAccessor* _tmp4_;
		ValaPropertyAccessor* _tmp5_;
		_tmp4_ = vala_property_get_get_accessor (self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
	_tmp6_ = vala_property_get_set_accessor (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaPropertyAccessor* _tmp8_;
		ValaPropertyAccessor* _tmp9_;
		_tmp8_ = vala_property_get_set_accessor (self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
	_tmp10_ = vala_property_get_initializer (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		_tmp12_ = vala_property_get_initializer (self);
		_tmp13_ = _tmp12_;
		vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
	}
}

/**
 * Checks whether the accessors of this property are compatible
 * with the specified base property.
 *
 * @param base_property a property
 * @param invalid_match error string about which check failed
 * @return true if the specified property is compatible to this property
 */
gboolean
vala_property_compatible (ValaProperty* self,
                          ValaProperty* base_property,
                          gchar** invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaPropertyAccessor* _tmp2_;
	ValaPropertyAccessor* _tmp3_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	ValaPropertyAccessor* _tmp14_;
	ValaPropertyAccessor* _tmp15_;
	ValaDataType* object_type = NULL;
	ValaSymbol* _tmp24_;
	ValaSymbol* _tmp25_;
	ValaDataType* _tmp26_;
	ValaPropertyAccessor* _tmp27_;
	ValaPropertyAccessor* _tmp28_;
	ValaPropertyAccessor* _tmp41_;
	ValaPropertyAccessor* _tmp42_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_property != NULL, FALSE);
	_tmp2_ = vala_property_get_get_accessor (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaPropertyAccessor* _tmp4_;
		ValaPropertyAccessor* _tmp5_;
		_tmp4_ = vala_property_get_get_accessor (base_property);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		ValaPropertyAccessor* _tmp7_;
		ValaPropertyAccessor* _tmp8_;
		_tmp7_ = vala_property_get_get_accessor (self);
		_tmp8_ = _tmp7_;
		if (_tmp8_ != NULL) {
			ValaPropertyAccessor* _tmp9_;
			ValaPropertyAccessor* _tmp10_;
			_tmp9_ = vala_property_get_get_accessor (base_property);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ == NULL;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp0_ = _tmp6_;
	}
	if (_tmp0_) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("incompatible get accessor");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp11_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp14_ = vala_property_get_set_accessor (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == NULL) {
		ValaPropertyAccessor* _tmp16_;
		ValaPropertyAccessor* _tmp17_;
		_tmp16_ = vala_property_get_set_accessor (base_property);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_ != NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		ValaPropertyAccessor* _tmp19_;
		ValaPropertyAccessor* _tmp20_;
		_tmp19_ = vala_property_get_set_accessor (self);
		_tmp20_ = _tmp19_;
		if (_tmp20_ != NULL) {
			ValaPropertyAccessor* _tmp21_;
			ValaPropertyAccessor* _tmp22_;
			_tmp21_ = vala_property_get_set_accessor (base_property);
			_tmp22_ = _tmp21_;
			_tmp18_ = _tmp22_ == NULL;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp12_ = _tmp18_;
	}
	if (_tmp12_) {
		gchar* _tmp23_;
		_tmp23_ = g_strdup ("incompatible set accessor");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp23_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp24_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp25_);
	object_type = _tmp26_;
	_tmp27_ = vala_property_get_get_accessor (self);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != NULL) {
		ValaDataType* actual_base_type = NULL;
		ValaPropertyAccessor* _tmp29_;
		ValaPropertyAccessor* _tmp30_;
		ValaDataType* _tmp31_;
		ValaDataType* _tmp32_;
		ValaDataType* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		ValaPropertyAccessor* _tmp36_;
		ValaPropertyAccessor* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		_tmp29_ = vala_property_get_get_accessor (base_property);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_property_accessor_get_value_type (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = object_type;
		_tmp34_ = vala_data_type_get_actual_type (_tmp32_, _tmp33_, NULL, (ValaCodeNode*) self);
		actual_base_type = _tmp34_;
		_tmp35_ = actual_base_type;
		_tmp36_ = vala_property_get_get_accessor (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_property_accessor_get_value_type (_tmp37_);
		_tmp39_ = _tmp38_;
		if (!vala_data_type_equals (_tmp35_, _tmp39_)) {
			gchar* _tmp40_;
			_tmp40_ = g_strdup ("incompatible get accessor type");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp40_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_vala_code_node_unref0 (actual_base_type);
	}
	_tmp41_ = vala_property_get_set_accessor (self);
	_tmp42_ = _tmp41_;
	if (_tmp42_ != NULL) {
		ValaDataType* actual_base_type = NULL;
		ValaPropertyAccessor* _tmp43_;
		ValaPropertyAccessor* _tmp44_;
		ValaDataType* _tmp45_;
		ValaDataType* _tmp46_;
		ValaDataType* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		ValaPropertyAccessor* _tmp50_;
		ValaPropertyAccessor* _tmp51_;
		ValaDataType* _tmp52_;
		ValaDataType* _tmp53_;
		ValaPropertyAccessor* _tmp55_;
		ValaPropertyAccessor* _tmp56_;
		gboolean _tmp57_;
		gboolean _tmp58_;
		ValaPropertyAccessor* _tmp59_;
		ValaPropertyAccessor* _tmp60_;
		gboolean _tmp61_;
		gboolean _tmp62_;
		ValaPropertyAccessor* _tmp64_;
		ValaPropertyAccessor* _tmp65_;
		gboolean _tmp66_;
		gboolean _tmp67_;
		ValaPropertyAccessor* _tmp68_;
		ValaPropertyAccessor* _tmp69_;
		gboolean _tmp70_;
		gboolean _tmp71_;
		_tmp43_ = vala_property_get_set_accessor (base_property);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_property_accessor_get_value_type (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = object_type;
		_tmp48_ = vala_data_type_get_actual_type (_tmp46_, _tmp47_, NULL, (ValaCodeNode*) self);
		actual_base_type = _tmp48_;
		_tmp49_ = actual_base_type;
		_tmp50_ = vala_property_get_set_accessor (self);
		_tmp51_ = _tmp50_;
		_tmp52_ = vala_property_accessor_get_value_type (_tmp51_);
		_tmp53_ = _tmp52_;
		if (!vala_data_type_equals (_tmp49_, _tmp53_)) {
			gchar* _tmp54_;
			_tmp54_ = g_strdup ("incompatible set accessor type");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp54_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_tmp55_ = vala_property_get_set_accessor (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_property_accessor_get_writable (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_property_get_set_accessor (base_property);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_property_accessor_get_writable (_tmp60_);
		_tmp62_ = _tmp61_;
		if (_tmp58_ != _tmp62_) {
			gchar* _tmp63_;
			_tmp63_ = g_strdup ("incompatible set accessor");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp63_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_tmp64_ = vala_property_get_set_accessor (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_property_accessor_get_construction (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_property_get_set_accessor (base_property);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_property_accessor_get_construction (_tmp69_);
		_tmp71_ = _tmp70_;
		if (_tmp67_ != _tmp71_) {
			gchar* _tmp72_;
			_tmp72_ = g_strdup ("incompatible set accessor");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp72_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_vala_code_node_unref0 (actual_base_type);
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

static void
vala_property_real_replace_type (ValaCodeNode* base,
                                 ValaDataType* old_type,
                                 ValaDataType* new_type)
{
	ValaProperty * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaProperty*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_property_get_property_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_property_set_property_type (self, new_type);
	}
}

static void
vala_property_real_replace_expression (ValaCodeNode* base,
                                       ValaExpression* old_node,
                                       ValaExpression* new_node)
{
	ValaProperty * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaProperty*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_property_get_initializer (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_property_set_initializer (self, new_node);
	}
}

static void
vala_property_find_base_properties (ValaProperty* self)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->base_properties_valid) {
		return;
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_CLASS (_tmp1_)) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp3_ = _tmp2_;
		vala_property_find_base_interface_property (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
		_tmp5_ = self->priv->_is_virtual;
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			gboolean _tmp6_;
			_tmp6_ = self->priv->_overrides;
			_tmp4_ = _tmp6_;
		}
		if (_tmp4_) {
			ValaSymbol* _tmp7_;
			ValaSymbol* _tmp8_;
			_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			vala_property_find_base_class_property (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_CLASS, ValaClass));
		}
	} else {
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		if (VALA_IS_INTERFACE (_tmp10_)) {
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_;
			_tmp12_ = self->priv->_is_virtual;
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				gboolean _tmp13_;
				_tmp13_ = self->priv->_is_abstract;
				_tmp11_ = _tmp13_;
			}
			if (_tmp11_) {
				self->priv->_base_interface_property = self;
			}
		}
	}
	self->priv->base_properties_valid = TRUE;
}

static void
vala_property_find_base_class_property (ValaProperty* self,
                                        ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaClass* _tmp27_;
	ValaClass* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (VALA_IS_PROPERTY (_tmp5_)) {
		ValaProperty* base_property = NULL;
		ValaSymbol* _tmp6_;
		ValaProperty* _tmp7_;
		gboolean _tmp8_ = FALSE;
		ValaProperty* _tmp9_;
		gboolean _tmp10_;
		_tmp6_ = sym;
		_tmp7_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_PROPERTY, ValaProperty));
		base_property = _tmp7_;
		_tmp9_ = base_property;
		_tmp10_ = _tmp9_->priv->_is_abstract;
		if (_tmp10_) {
			_tmp8_ = TRUE;
		} else {
			ValaProperty* _tmp11_;
			gboolean _tmp12_;
			_tmp11_ = base_property;
			_tmp12_ = _tmp11_->priv->_is_virtual;
			_tmp8_ = _tmp12_;
		}
		if (_tmp8_) {
			gchar* invalid_match = NULL;
			ValaProperty* _tmp13_;
			gchar* _tmp14_ = NULL;
			gboolean _tmp15_;
			ValaProperty* _tmp26_;
			_tmp13_ = base_property;
			_tmp15_ = vala_property_compatible (self, _tmp13_, &_tmp14_);
			_g_free0 (invalid_match);
			invalid_match = _tmp14_;
			if (!_tmp15_) {
				ValaSourceReference* _tmp16_;
				ValaSourceReference* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				ValaProperty* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp17_ = _tmp16_;
				_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp19_ = _tmp18_;
				_tmp20_ = base_property;
				_tmp21_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = invalid_match;
				_tmp24_ = g_strdup_printf ("Type and/or accessors of overriding property `%s' do not match overrid" \
"den property `%s': %s.", _tmp19_, _tmp22_, _tmp23_);
				_tmp25_ = _tmp24_;
				vala_report_error (_tmp17_, _tmp25_);
				_g_free0 (_tmp25_);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp19_);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (base_property);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp26_ = base_property;
			self->priv->_base_property = _tmp26_;
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (base_property);
			_vala_code_node_unref0 (sym);
			return;
		}
		_vala_code_node_unref0 (base_property);
	}
	_tmp27_ = vala_class_get_base_class (cl);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != NULL) {
		ValaClass* _tmp29_;
		ValaClass* _tmp30_;
		_tmp29_ = vala_class_get_base_class (cl);
		_tmp30_ = _tmp29_;
		vala_property_find_base_class_property (self, _tmp30_);
	}
	_vala_code_node_unref0 (sym);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_property_find_base_interface_property (ValaProperty* self,
                                            ValaClass* cl)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* type = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_type_index = _type_index + 1;
			_tmp5_ = _type_index;
			_tmp6_ = _type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _type_list;
			_tmp8_ = vala_list_get (_tmp7_, _type_index);
			type = (ValaDataType*) _tmp8_;
			_tmp9_ = type;
			_tmp10_ = vala_data_type_get_type_symbol (_tmp9_);
			_tmp11_ = _tmp10_;
			if (VALA_IS_INTERFACE (_tmp11_)) {
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaScope* _tmp15_;
				ValaScope* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				ValaSymbol* _tmp19_;
				ValaSymbol* _tmp20_;
				_tmp12_ = type;
				_tmp13_ = vala_data_type_get_type_symbol (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) _tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp18_ = _tmp17_;
				_tmp19_ = vala_scope_lookup (_tmp16_, _tmp18_);
				sym = _tmp19_;
				_tmp20_ = sym;
				if (VALA_IS_PROPERTY (_tmp20_)) {
					ValaProperty* base_property = NULL;
					ValaSymbol* _tmp21_;
					ValaProperty* _tmp22_;
					gboolean _tmp23_ = FALSE;
					ValaProperty* _tmp24_;
					gboolean _tmp25_;
					_tmp21_ = sym;
					_tmp22_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_PROPERTY, ValaProperty));
					base_property = _tmp22_;
					_tmp24_ = base_property;
					_tmp25_ = _tmp24_->priv->_is_abstract;
					if (_tmp25_) {
						_tmp23_ = TRUE;
					} else {
						ValaProperty* _tmp26_;
						gboolean _tmp27_;
						_tmp26_ = base_property;
						_tmp27_ = _tmp26_->priv->_is_virtual;
						_tmp23_ = _tmp27_;
					}
					if (_tmp23_) {
						gchar* invalid_match = NULL;
						ValaProperty* _tmp28_;
						gchar* _tmp29_ = NULL;
						gboolean _tmp30_;
						ValaProperty* _tmp41_;
						_tmp28_ = base_property;
						_tmp30_ = vala_property_compatible (self, _tmp28_, &_tmp29_);
						_g_free0 (invalid_match);
						invalid_match = _tmp29_;
						if (!_tmp30_) {
							ValaSourceReference* _tmp31_;
							ValaSourceReference* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							ValaProperty* _tmp35_;
							gchar* _tmp36_;
							gchar* _tmp37_;
							const gchar* _tmp38_;
							gchar* _tmp39_;
							gchar* _tmp40_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp32_ = _tmp31_;
							_tmp33_ = vala_symbol_get_full_name ((ValaSymbol*) self);
							_tmp34_ = _tmp33_;
							_tmp35_ = base_property;
							_tmp36_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp35_);
							_tmp37_ = _tmp36_;
							_tmp38_ = invalid_match;
							_tmp39_ = g_strdup_printf ("Type and/or accessors of overriding property `%s' do not match overrid" \
"den property `%s': %s.", _tmp34_, _tmp37_, _tmp38_);
							_tmp40_ = _tmp39_;
							vala_report_error (_tmp32_, _tmp40_);
							_g_free0 (_tmp40_);
							_g_free0 (_tmp37_);
							_g_free0 (_tmp34_);
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (base_property);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							_vala_iterable_unref0 (_type_list);
							return;
						}
						_tmp41_ = base_property;
						self->priv->_base_interface_property = _tmp41_;
						_g_free0 (invalid_match);
						_vala_code_node_unref0 (base_property);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						_vala_iterable_unref0 (_type_list);
						return;
					}
					_vala_code_node_unref0 (base_property);
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_property_real_check (ValaCodeNode* base,
                          ValaCodeContext* context)
{
	ValaProperty * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaParameter* _tmp4_;
	gboolean _tmp6_ = FALSE;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	gboolean _tmp24_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp61_;
	ValaSemanticAnalyzer* _tmp62_;
	ValaSourceFile* _tmp63_;
	ValaSourceFile* _tmp64_;
	ValaSourceFile* _tmp65_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp66_;
	ValaSemanticAnalyzer* _tmp67_;
	ValaSymbol* _tmp68_;
	ValaSymbol* _tmp69_;
	ValaSymbol* _tmp70_;
	ValaSourceReference* _tmp71_;
	ValaSourceReference* _tmp72_;
	ValaSemanticAnalyzer* _tmp79_;
	ValaSemanticAnalyzer* _tmp80_;
	ValaDataType* _tmp81_;
	ValaDataType* _tmp82_;
	ValaDataType* _tmp85_;
	ValaDataType* _tmp86_;
	gboolean _tmp87_;
	gboolean _tmp88_;
	gboolean _tmp93_ = FALSE;
	ValaPropertyAccessor* _tmp94_;
	ValaPropertyAccessor* _tmp95_;
	ValaPropertyAccessor* _tmp104_;
	ValaPropertyAccessor* _tmp105_;
	ValaPropertyAccessor* _tmp108_;
	ValaPropertyAccessor* _tmp109_;
	gboolean _tmp112_ = FALSE;
	gboolean _tmp113_ = FALSE;
	ValaExpression* _tmp114_;
	ValaExpression* _tmp115_;
	ValaExpression* _tmp125_;
	ValaExpression* _tmp126_;
	ValaSemanticAnalyzer* _tmp129_;
	ValaSemanticAnalyzer* _tmp130_;
	ValaDataType* _tmp131_;
	ValaDataType* _tmp132_;
	gboolean _tmp143_ = FALSE;
	gboolean _tmp144_ = FALSE;
	gboolean _tmp145_;
	gboolean _tmp156_ = FALSE;
	gboolean _tmp157_ = FALSE;
	gboolean _tmp158_ = FALSE;
	gboolean _tmp159_;
	gboolean _tmp160_;
	gboolean _tmp176_ = FALSE;
	ValaPropertyAccessor* _tmp177_;
	ValaPropertyAccessor* _tmp178_;
	gboolean _tmp191_ = FALSE;
	gboolean _tmp192_ = FALSE;
	gboolean _tmp193_ = FALSE;
	ValaExpression* _tmp194_;
	ValaExpression* _tmp195_;
	ValaSemanticAnalyzer* _tmp226_;
	ValaSemanticAnalyzer* _tmp227_;
	ValaSourceFile* _tmp228_;
	ValaSemanticAnalyzer* _tmp229_;
	ValaSemanticAnalyzer* _tmp230_;
	ValaSymbol* _tmp231_;
	gboolean _tmp232_;
	gboolean _tmp233_;
	gboolean result = FALSE;
	self = (ValaProperty*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_this_parameter;
	if (_tmp4_ != NULL) {
		ValaParameter* _tmp5_;
		_tmp5_ = self->priv->_this_parameter;
		vala_code_node_check ((ValaCodeNode*) _tmp5_, context);
	}
	_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp8_ = _tmp7_;
	if (VALA_IS_CLASS (_tmp8_)) {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_;
		_tmp10_ = self->priv->_is_abstract;
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			gboolean _tmp11_;
			_tmp11_ = self->priv->_is_virtual;
			_tmp9_ = _tmp11_;
		}
		_tmp6_ = _tmp9_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaClass* _tmp14_;
		gboolean _tmp15_ = FALSE;
		ValaClass* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp12_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp14_;
		_tmp16_ = cl;
		_tmp17_ = vala_class_get_is_compact (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_) {
			ValaClass* _tmp19_;
			ValaClass* _tmp20_;
			ValaClass* _tmp21_;
			_tmp19_ = cl;
			_tmp20_ = vala_class_get_base_class (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp15_ = _tmp21_ != NULL;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			ValaSourceReference* _tmp22_;
			ValaSourceReference* _tmp23_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp23_ = _tmp22_;
			vala_report_error (_tmp23_, "Abstract and virtual properties may not be declared in derived compact" \
" classes");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			return result;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp24_ = self->priv->_is_abstract;
	if (_tmp24_) {
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		_tmp25_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp26_ = _tmp25_;
		if (VALA_IS_CLASS (_tmp26_)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp27_;
			ValaSymbol* _tmp28_;
			ValaClass* _tmp29_;
			ValaClass* _tmp30_;
			gboolean _tmp31_;
			gboolean _tmp32_;
			_tmp27_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp28_ = _tmp27_;
			_tmp29_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp29_;
			_tmp30_ = cl;
			_tmp31_ = vala_class_get_is_abstract (_tmp30_);
			_tmp32_ = _tmp31_;
			if (!_tmp32_) {
				ValaSourceReference* _tmp33_;
				ValaSourceReference* _tmp34_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp34_ = _tmp33_;
				vala_report_error (_tmp34_, "Abstract properties may not be declared in non-abstract classes");
				result = FALSE;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			_tmp35_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp36_ = _tmp35_;
			if (!VALA_IS_INTERFACE (_tmp36_)) {
				ValaSourceReference* _tmp37_;
				ValaSourceReference* _tmp38_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp38_ = _tmp37_;
				vala_report_error (_tmp38_, "Abstract properties may not be declared outside of classes and interfa" \
"ces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp39_;
		_tmp39_ = self->priv->_is_virtual;
		if (_tmp39_) {
			gboolean _tmp40_ = FALSE;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			_tmp41_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp42_ = _tmp41_;
			if (!VALA_IS_CLASS (_tmp42_)) {
				ValaSymbol* _tmp43_;
				ValaSymbol* _tmp44_;
				_tmp43_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp44_ = _tmp43_;
				_tmp40_ = !VALA_IS_INTERFACE (_tmp44_);
			} else {
				_tmp40_ = FALSE;
			}
			if (_tmp40_) {
				ValaSourceReference* _tmp45_;
				ValaSourceReference* _tmp46_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp46_ = _tmp45_;
				vala_report_error (_tmp46_, "Virtual properties may not be declared outside of classes and interfac" \
"es");
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp47_;
			_tmp47_ = self->priv->_overrides;
			if (_tmp47_) {
				ValaSymbol* _tmp48_;
				ValaSymbol* _tmp49_;
				_tmp48_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp49_ = _tmp48_;
				if (!VALA_IS_CLASS (_tmp49_)) {
					ValaSourceReference* _tmp50_;
					ValaSourceReference* _tmp51_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp50_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp51_ = _tmp50_;
					vala_report_error (_tmp51_, "Properties may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp52_;
				ValaSymbolAccessibility _tmp53_;
				_tmp52_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp53_ = _tmp52_;
				if (_tmp53_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp54_ = FALSE;
					ValaSymbol* _tmp55_;
					ValaSymbol* _tmp56_;
					_tmp55_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp56_ = _tmp55_;
					if (!VALA_IS_CLASS (_tmp56_)) {
						ValaSymbol* _tmp57_;
						ValaSymbol* _tmp58_;
						_tmp57_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp58_ = _tmp57_;
						_tmp54_ = !VALA_IS_INTERFACE (_tmp58_);
					} else {
						_tmp54_ = FALSE;
					}
					if (_tmp54_) {
						ValaSourceReference* _tmp59_;
						ValaSourceReference* _tmp60_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp60_ = _tmp59_;
						vala_report_error (_tmp60_, "Protected properties may not be declared outside of classes and interf" \
"aces");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp61_ = vala_code_context_get_analyzer (context);
	_tmp62_ = _tmp61_;
	_tmp63_ = vala_semantic_analyzer_get_current_source_file (_tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = _vala_source_file_ref0 (_tmp64_);
	old_source_file = _tmp65_;
	_tmp66_ = vala_code_context_get_analyzer (context);
	_tmp67_ = _tmp66_;
	_tmp68_ = vala_semantic_analyzer_get_current_symbol (_tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = _vala_code_node_ref0 (_tmp69_);
	old_symbol = _tmp70_;
	_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp72_ = _tmp71_;
	if (_tmp72_ != NULL) {
		ValaSemanticAnalyzer* _tmp73_;
		ValaSemanticAnalyzer* _tmp74_;
		ValaSourceReference* _tmp75_;
		ValaSourceReference* _tmp76_;
		ValaSourceFile* _tmp77_;
		ValaSourceFile* _tmp78_;
		_tmp73_ = vala_code_context_get_analyzer (context);
		_tmp74_ = _tmp73_;
		_tmp75_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp76_ = _tmp75_;
		_tmp77_ = vala_source_reference_get_file (_tmp76_);
		_tmp78_ = _tmp77_;
		vala_semantic_analyzer_set_current_source_file (_tmp74_, _tmp78_);
	}
	_tmp79_ = vala_code_context_get_analyzer (context);
	_tmp80_ = _tmp79_;
	vala_semantic_analyzer_set_current_symbol (_tmp80_, (ValaSymbol*) self);
	_tmp81_ = vala_property_get_property_type (self);
	_tmp82_ = _tmp81_;
	if (VALA_IS_VOID_TYPE (_tmp82_)) {
		ValaSourceReference* _tmp83_;
		ValaSourceReference* _tmp84_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp83_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp84_ = _tmp83_;
		vala_report_error (_tmp84_, "'void' not supported as property type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp85_ = vala_property_get_property_type (self);
	_tmp86_ = _tmp85_;
	vala_code_node_check ((ValaCodeNode*) _tmp86_, context);
	_tmp87_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp88_ = _tmp87_;
	if (!_tmp88_) {
		ValaSemanticAnalyzer* _tmp89_;
		ValaSemanticAnalyzer* _tmp90_;
		ValaDataType* _tmp91_;
		ValaDataType* _tmp92_;
		_tmp89_ = vala_code_context_get_analyzer (context);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_property_get_property_type (self);
		_tmp92_ = _tmp91_;
		vala_semantic_analyzer_check_type (_tmp90_, _tmp92_);
	}
	_tmp94_ = vala_property_get_get_accessor (self);
	_tmp95_ = _tmp94_;
	if (_tmp95_ == NULL) {
		ValaPropertyAccessor* _tmp96_;
		ValaPropertyAccessor* _tmp97_;
		_tmp96_ = vala_property_get_set_accessor (self);
		_tmp97_ = _tmp96_;
		_tmp93_ = _tmp97_ == NULL;
	} else {
		_tmp93_ = FALSE;
	}
	if (_tmp93_) {
		ValaSourceReference* _tmp98_;
		ValaSourceReference* _tmp99_;
		gchar* _tmp100_;
		gchar* _tmp101_;
		gchar* _tmp102_;
		gchar* _tmp103_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp98_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp101_ = _tmp100_;
		_tmp102_ = g_strdup_printf ("Property `%s' must have a `get' accessor and/or a `set' mutator", _tmp101_);
		_tmp103_ = _tmp102_;
		vala_report_error (_tmp99_, _tmp103_);
		_g_free0 (_tmp103_);
		_g_free0 (_tmp101_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp104_ = vala_property_get_get_accessor (self);
	_tmp105_ = _tmp104_;
	if (_tmp105_ != NULL) {
		ValaPropertyAccessor* _tmp106_;
		ValaPropertyAccessor* _tmp107_;
		_tmp106_ = vala_property_get_get_accessor (self);
		_tmp107_ = _tmp106_;
		vala_code_node_check ((ValaCodeNode*) _tmp107_, context);
	}
	_tmp108_ = vala_property_get_set_accessor (self);
	_tmp109_ = _tmp108_;
	if (_tmp109_ != NULL) {
		ValaPropertyAccessor* _tmp110_;
		ValaPropertyAccessor* _tmp111_;
		_tmp110_ = vala_property_get_set_accessor (self);
		_tmp111_ = _tmp110_;
		vala_code_node_check ((ValaCodeNode*) _tmp111_, context);
	}
	_tmp114_ = vala_property_get_initializer (self);
	_tmp115_ = _tmp114_;
	if (_tmp115_ != NULL) {
		ValaField* _tmp116_;
		ValaField* _tmp117_;
		_tmp116_ = vala_property_get_field (self);
		_tmp117_ = _tmp116_;
		_tmp113_ = _tmp117_ == NULL;
	} else {
		_tmp113_ = FALSE;
	}
	if (_tmp113_) {
		gboolean _tmp118_;
		_tmp118_ = self->priv->_is_abstract;
		_tmp112_ = !_tmp118_;
	} else {
		_tmp112_ = FALSE;
	}
	if (_tmp112_) {
		ValaSourceReference* _tmp119_;
		ValaSourceReference* _tmp120_;
		gchar* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		gchar* _tmp124_;
		_tmp119_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp122_ = _tmp121_;
		_tmp123_ = g_strdup_printf ("Property `%s' with custom `get' accessor and/or `set' mutator cannot h" \
"ave `default' value", _tmp122_);
		_tmp124_ = _tmp123_;
		vala_report_error (_tmp120_, _tmp124_);
		_g_free0 (_tmp124_);
		_g_free0 (_tmp122_);
	}
	_tmp125_ = vala_property_get_initializer (self);
	_tmp126_ = _tmp125_;
	if (_tmp126_ != NULL) {
		ValaExpression* _tmp127_;
		ValaExpression* _tmp128_;
		_tmp127_ = vala_property_get_initializer (self);
		_tmp128_ = _tmp127_;
		vala_code_node_check ((ValaCodeNode*) _tmp128_, context);
	}
	_tmp129_ = vala_code_context_get_analyzer (context);
	_tmp130_ = _tmp129_;
	_tmp131_ = vala_property_get_property_type (self);
	_tmp132_ = _tmp131_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp130_, (ValaSymbol*) self, _tmp132_)) {
		ValaSourceReference* _tmp133_;
		ValaSourceReference* _tmp134_;
		ValaDataType* _tmp135_;
		ValaDataType* _tmp136_;
		gchar* _tmp137_;
		gchar* _tmp138_;
		gchar* _tmp139_;
		gchar* _tmp140_;
		gchar* _tmp141_;
		gchar* _tmp142_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp133_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp134_ = _tmp133_;
		_tmp135_ = vala_property_get_property_type (self);
		_tmp136_ = _tmp135_;
		_tmp137_ = vala_code_node_to_string ((ValaCodeNode*) _tmp136_);
		_tmp138_ = _tmp137_;
		_tmp139_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp140_ = _tmp139_;
		_tmp141_ = g_strdup_printf ("property type `%s' is less accessible than property `%s'", _tmp138_, _tmp140_);
		_tmp142_ = _tmp141_;
		vala_report_error (_tmp134_, _tmp142_);
		_g_free0 (_tmp142_);
		_g_free0 (_tmp140_);
		_g_free0 (_tmp138_);
	}
	_tmp145_ = self->priv->_overrides;
	if (_tmp145_) {
		ValaProperty* _tmp146_;
		ValaProperty* _tmp147_;
		_tmp146_ = vala_property_get_base_property (self);
		_tmp147_ = _tmp146_;
		_tmp144_ = _tmp147_ == NULL;
	} else {
		_tmp144_ = FALSE;
	}
	if (_tmp144_) {
		ValaProperty* _tmp148_;
		ValaProperty* _tmp149_;
		_tmp148_ = vala_property_get_base_interface_property (self);
		_tmp149_ = _tmp148_;
		_tmp143_ = _tmp149_ == NULL;
	} else {
		_tmp143_ = FALSE;
	}
	if (_tmp143_) {
		ValaSourceReference* _tmp150_;
		ValaSourceReference* _tmp151_;
		gchar* _tmp152_;
		gchar* _tmp153_;
		gchar* _tmp154_;
		gchar* _tmp155_;
		_tmp150_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp153_ = _tmp152_;
		_tmp154_ = g_strdup_printf ("%s: no suitable property found to override", _tmp153_);
		_tmp155_ = _tmp154_;
		vala_report_error (_tmp151_, _tmp155_);
		_g_free0 (_tmp155_);
		_g_free0 (_tmp153_);
	}
	_tmp159_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp160_ = _tmp159_;
	if (!_tmp160_) {
		gboolean _tmp161_;
		_tmp161_ = self->priv->_overrides;
		_tmp158_ = !_tmp161_;
	} else {
		_tmp158_ = FALSE;
	}
	if (_tmp158_) {
		gboolean _tmp162_;
		gboolean _tmp163_;
		_tmp162_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp163_ = _tmp162_;
		_tmp157_ = !_tmp163_;
	} else {
		_tmp157_ = FALSE;
	}
	if (_tmp157_) {
		ValaSymbol* _tmp164_;
		ValaSymbol* _tmp165_;
		_tmp164_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp165_ = _tmp164_;
		_tmp156_ = _tmp165_ != NULL;
		_vala_code_node_unref0 (_tmp165_);
	} else {
		_tmp156_ = FALSE;
	}
	if (_tmp156_) {
		ValaSourceReference* _tmp166_;
		ValaSourceReference* _tmp167_;
		gchar* _tmp168_;
		gchar* _tmp169_;
		ValaSymbol* _tmp170_;
		ValaSymbol* _tmp171_;
		gchar* _tmp172_;
		gchar* _tmp173_;
		gchar* _tmp174_;
		gchar* _tmp175_;
		_tmp166_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp167_ = _tmp166_;
		_tmp168_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp169_ = _tmp168_;
		_tmp170_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp171_ = _tmp170_;
		_tmp172_ = vala_symbol_get_full_name (_tmp171_);
		_tmp173_ = _tmp172_;
		_tmp174_ = g_strdup_printf ("%s hides inherited property `%s'. Use the `new' keyword if hiding was " \
"intentional", _tmp169_, _tmp173_);
		_tmp175_ = _tmp174_;
		vala_report_warning (_tmp167_, _tmp175_);
		_g_free0 (_tmp175_);
		_g_free0 (_tmp173_);
		_vala_code_node_unref0 (_tmp171_);
		_g_free0 (_tmp169_);
	}
	_tmp177_ = vala_property_get_set_accessor (self);
	_tmp178_ = _tmp177_;
	if (_tmp178_ != NULL) {
		ValaPropertyAccessor* _tmp179_;
		ValaPropertyAccessor* _tmp180_;
		gboolean _tmp181_;
		gboolean _tmp182_;
		_tmp179_ = vala_property_get_set_accessor (self);
		_tmp180_ = _tmp179_;
		_tmp181_ = vala_property_accessor_get_construction (_tmp180_);
		_tmp182_ = _tmp181_;
		_tmp176_ = _tmp182_;
	} else {
		_tmp176_ = FALSE;
	}
	if (_tmp176_) {
		ValaSymbolAccessibility _tmp183_;
		ValaSymbolAccessibility _tmp184_;
		_tmp183_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp184_ = _tmp183_;
		if (_tmp184_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
			ValaSourceReference* _tmp185_;
			ValaSourceReference* _tmp186_;
			gchar* _tmp187_;
			gchar* _tmp188_;
			gchar* _tmp189_;
			gchar* _tmp190_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp186_ = _tmp185_;
			_tmp187_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp188_ = _tmp187_;
			_tmp189_ = g_strdup_printf ("%s: construct properties must be public", _tmp188_);
			_tmp190_ = _tmp189_;
			vala_report_error (_tmp186_, _tmp190_);
			_g_free0 (_tmp190_);
			_g_free0 (_tmp188_);
		}
	}
	_tmp194_ = vala_property_get_initializer (self);
	_tmp195_ = _tmp194_;
	if (_tmp195_ != NULL) {
		ValaExpression* _tmp196_;
		ValaExpression* _tmp197_;
		gboolean _tmp198_;
		gboolean _tmp199_;
		_tmp196_ = vala_property_get_initializer (self);
		_tmp197_ = _tmp196_;
		_tmp198_ = vala_code_node_get_error ((ValaCodeNode*) _tmp197_);
		_tmp199_ = _tmp198_;
		_tmp193_ = !_tmp199_;
	} else {
		_tmp193_ = FALSE;
	}
	if (_tmp193_) {
		ValaExpression* _tmp200_;
		ValaExpression* _tmp201_;
		ValaDataType* _tmp202_;
		ValaDataType* _tmp203_;
		_tmp200_ = vala_property_get_initializer (self);
		_tmp201_ = _tmp200_;
		_tmp202_ = vala_expression_get_value_type (_tmp201_);
		_tmp203_ = _tmp202_;
		_tmp192_ = _tmp203_ != NULL;
	} else {
		_tmp192_ = FALSE;
	}
	if (_tmp192_) {
		ValaExpression* _tmp204_;
		ValaExpression* _tmp205_;
		ValaDataType* _tmp206_;
		ValaDataType* _tmp207_;
		ValaDataType* _tmp208_;
		ValaDataType* _tmp209_;
		_tmp204_ = vala_property_get_initializer (self);
		_tmp205_ = _tmp204_;
		_tmp206_ = vala_expression_get_value_type (_tmp205_);
		_tmp207_ = _tmp206_;
		_tmp208_ = vala_property_get_property_type (self);
		_tmp209_ = _tmp208_;
		_tmp191_ = !vala_data_type_compatible (_tmp207_, _tmp209_);
	} else {
		_tmp191_ = FALSE;
	}
	if (_tmp191_) {
		ValaExpression* _tmp210_;
		ValaExpression* _tmp211_;
		ValaSourceReference* _tmp212_;
		ValaSourceReference* _tmp213_;
		ValaDataType* _tmp214_;
		ValaDataType* _tmp215_;
		gchar* _tmp216_;
		gchar* _tmp217_;
		ValaExpression* _tmp218_;
		ValaExpression* _tmp219_;
		ValaDataType* _tmp220_;
		ValaDataType* _tmp221_;
		gchar* _tmp222_;
		gchar* _tmp223_;
		gchar* _tmp224_;
		gchar* _tmp225_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp210_ = vala_property_get_initializer (self);
		_tmp211_ = _tmp210_;
		_tmp212_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp211_);
		_tmp213_ = _tmp212_;
		_tmp214_ = vala_property_get_property_type (self);
		_tmp215_ = _tmp214_;
		_tmp216_ = vala_code_node_to_string ((ValaCodeNode*) _tmp215_);
		_tmp217_ = _tmp216_;
		_tmp218_ = vala_property_get_initializer (self);
		_tmp219_ = _tmp218_;
		_tmp220_ = vala_expression_get_value_type (_tmp219_);
		_tmp221_ = _tmp220_;
		_tmp222_ = vala_code_node_to_string ((ValaCodeNode*) _tmp221_);
		_tmp223_ = _tmp222_;
		_tmp224_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp217_, _tmp223_);
		_tmp225_ = _tmp224_;
		vala_report_error (_tmp213_, _tmp225_);
		_g_free0 (_tmp225_);
		_g_free0 (_tmp223_);
		_g_free0 (_tmp217_);
	}
	_tmp226_ = vala_code_context_get_analyzer (context);
	_tmp227_ = _tmp226_;
	_tmp228_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp227_, _tmp228_);
	_tmp229_ = vala_code_context_get_analyzer (context);
	_tmp230_ = _tmp229_;
	_tmp231_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp230_, _tmp231_);
	_tmp232_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp233_ = _tmp232_;
	result = !_tmp233_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_property_class_init (ValaPropertyClass * klass,
                          gpointer klass_data)
{
	vala_property_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_property_finalize;
	g_type_class_adjust_private_offset (klass, &ValaProperty_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_property_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_property_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_property_real_replace_type;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_property_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_property_real_check;
}

static void
vala_property_vala_lockable_interface_init (ValaLockableIface * iface,
                                            gpointer iface_data)
{
	vala_property_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_property_real_get_lock_used;
	iface->set_lock_used = vala_property_real_set_lock_used;
}

static void
vala_property_instance_init (ValaProperty * self,
                             gpointer klass)
{
	self->priv = vala_property_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
}

static void
vala_property_finalize (ValaCodeNode * obj)
{
	ValaProperty * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PROPERTY, ValaProperty);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_code_node_unref0 (self->priv->_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_get_accessor);
	_vala_code_node_unref0 (self->priv->_set_accessor);
	_g_free0 (self->priv->_nick);
	_g_free0 (self->priv->_blurb);
	_g_free0 (self->priv->_notify);
	_vala_code_node_unref0 (self->priv->_field);
	VALA_CODE_NODE_CLASS (vala_property_parent_class)->finalize (obj);
}

/**
 * Represents a property declaration in the source code.
 */
static GType
vala_property_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaPropertyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_property_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaProperty), 0, (GInstanceInitFunc) vala_property_instance_init, NULL };
	static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_property_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_property_type_id;
	vala_property_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaProperty", &g_define_type_info, 0);
	g_type_add_interface_static (vala_property_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
	ValaProperty_private_offset = g_type_add_instance_private (vala_property_type_id, sizeof (ValaPropertyPrivate));
	return vala_property_type_id;
}

GType
vala_property_get_type (void)
{
	static volatile gsize vala_property_type_id__volatile = 0;
	if (g_once_init_enter (&vala_property_type_id__volatile)) {
		GType vala_property_type_id;
		vala_property_type_id = vala_property_get_type_once ();
		g_once_init_leave (&vala_property_type_id__volatile, vala_property_type_id);
	}
	return vala_property_type_id__volatile;
}

