/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;

static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);
static GType vala_method_call_get_type_once (void);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_call_get_is_yield_expression (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_yield_expression;
	return result;
}

void
vala_method_call_set_is_yield_expression (ValaMethodCall* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_method_call_add_argument (ValaMethodCall* self,
                               ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
ValaList*
vala_method_call_get_argument_list (ValaMethodCall* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _expr_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_expr_list = _tmp3_;
		_tmp4_ = _expr_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_expr_size = _tmp6_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaExpression* expr = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_expr_index = _expr_index + 1;
			_tmp7_ = _expr_index;
			_tmp8_ = _expr_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _expr_list;
			_tmp10_ = vala_list_get (_tmp9_, _expr_index);
			expr = (ValaExpression*) _tmp10_;
			_tmp11_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->argument_list;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = method_type;
	if (_tmp4_ != NULL) {
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = method_type;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strcmp0 (_tmp9_, "GLib.N_") == 0;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			gboolean _tmp14_;
			_tmp11_ = self->priv->argument_list;
			_tmp12_ = vala_list_get (_tmp11_, 0);
			_tmp13_ = (ValaExpression*) _tmp12_;
			_tmp14_ = vala_expression_is_constant (_tmp13_);
			_vala_code_node_unref0 (_tmp13_);
			result = _tmp14_;
			return result;
		} else {
			ValaMethodType* _tmp15_;
			ValaMethod* _tmp16_;
			ValaMethod* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = method_type;
			_tmp16_ = vala_method_type_get_method_symbol (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "GLib.NC_") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				gboolean _tmp21_ = FALSE;
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 0);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gpointer _tmp27_;
					ValaExpression* _tmp28_;
					_tmp26_ = self->priv->argument_list;
					_tmp27_ = vala_list_get (_tmp26_, 1);
					_tmp28_ = (ValaExpression*) _tmp27_;
					_tmp21_ = vala_expression_is_constant (_tmp28_);
					_vala_code_node_unref0 (_tmp28_);
				} else {
					_tmp21_ = FALSE;
				}
				result = _tmp21_;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			if (!vala_expression_is_accessible (_tmp9_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp10_ = vala_method_call_get_call (self);
	_tmp11_ = _tmp10_;
	result = vala_expression_is_accessible (_tmp11_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_method_call_get_call (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	mtype = _tmp5_;
	_tmp6_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp6_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp7_ = mtype;
		_tmp8_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp9_ = _tmp8_;
		m = _tmp9_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_coroutine (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			gboolean _tmp15_;
			_tmp15_ = self->priv->_is_yield_expression;
			_tmp11_ = !_tmp15_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			_tmp16_ = vala_method_call_get_call (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp19_ = _tmp18_;
			_tmp10_ = g_strcmp0 (_tmp19_, "end") != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			ValaMethod* _tmp20_;
			_tmp20_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp20_, collection, source_reference);
		}
	} else {
		ValaDataType* _tmp21_;
		_tmp21_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp21_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp22_;
			ValaTypeSymbol* _tmp23_;
			ValaTypeSymbol* _tmp24_;
			ValaMethod* m = NULL;
			ValaClass* _tmp25_;
			ValaCreationMethod* _tmp26_;
			ValaCreationMethod* _tmp27_;
			ValaMethod* _tmp28_;
			_tmp22_ = mtype;
			_tmp23_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp24_ = _tmp23_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_CLASS, ValaClass);
			_tmp25_ = cl;
			_tmp26_ = vala_class_get_default_construction_method (_tmp25_);
			_tmp27_ = _tmp26_;
			m = (ValaMethod*) _tmp27_;
			_tmp28_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp28_, collection, source_reference);
		} else {
			ValaDataType* _tmp29_;
			_tmp29_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp29_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp30_;
				ValaDelegate* _tmp31_;
				ValaDelegate* _tmp32_;
				ValaDelegate* _tmp33_;
				_tmp30_ = mtype;
				_tmp31_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp32_ = _tmp31_;
				d = _tmp32_;
				_tmp33_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp33_, collection, source_reference);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp34_;
		ValaList* _tmp35_;
		gint _expr_size = 0;
		ValaList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _expr_index = 0;
		_tmp34_ = self->priv->argument_list;
		_tmp35_ = _vala_iterable_ref0 (_tmp34_);
		_expr_list = _tmp35_;
		_tmp36_ = _expr_list;
		_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_expr_size = _tmp38_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp39_;
			gint _tmp40_;
			ValaExpression* expr = NULL;
			ValaList* _tmp41_;
			gpointer _tmp42_;
			ValaExpression* _tmp43_;
			_expr_index = _expr_index + 1;
			_tmp39_ = _expr_index;
			_tmp40_ = _expr_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _expr_list;
			_tmp42_ = vala_list_get (_tmp41_, _expr_index);
			expr = (ValaExpression*) _tmp42_;
			_tmp43_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp43_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp104_;
	ValaExpression* _tmp105_;
	ValaDataType* _tmp106_;
	ValaDataType* _tmp107_;
	ValaDataType* _tmp108_;
	gboolean _tmp109_ = FALSE;
	ValaProfile _tmp110_;
	ValaProfile _tmp111_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp137_;
	gboolean _tmp229_ = FALSE;
	ValaExpression* _tmp230_;
	ValaExpression* _tmp231_;
	gboolean _tmp305_ = FALSE;
	gboolean _tmp306_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp321_;
	ValaDataType* _tmp322_;
	ValaDataType* _tmp323_;
	ValaList* params = NULL;
	ValaDataType* _tmp324_;
	ValaList* _tmp325_;
	ValaList* _tmp326_;
	ValaDataType* _tmp327_;
	ValaExpression* last_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp382_;
	ValaIterator* _tmp383_;
	gboolean _tmp434_ = FALSE;
	ValaDataType* _tmp435_;
	gboolean _tmp457_ = FALSE;
	ValaDataType* _tmp458_;
	gboolean force_lambda_method_closure = FALSE;
	gboolean _tmp540_ = FALSE;
	gboolean _tmp541_;
	gboolean _tmp542_;
	ValaDataType* _tmp563_;
	ValaDataType* _tmp574_;
	ValaDataType* _tmp575_;
	ValaDataType* _tmp576_;
	ValaDataType* _tmp577_;
	ValaDataType* _tmp578_;
	ValaDataType* _tmp579_;
	ValaList* _tmp580_;
	ValaDataType* _tmp581_;
	ValaDataType* _tmp582_;
	gboolean _tmp583_;
	ValaDataType* _tmp606_;
	ValaSemanticAnalyzer* _tmp863_;
	ValaSemanticAnalyzer* _tmp864_;
	ValaDataType* _tmp865_;
	ValaList* _tmp866_;
	ValaList* _tmp867_;
	gboolean _tmp895_ = FALSE;
	gboolean _tmp896_ = FALSE;
	ValaCreationMethod* _tmp897_;
	ValaDataType* _tmp925_;
	ValaDataType* _tmp926_;
	gboolean _tmp927_;
	gboolean _tmp928_;
	gboolean _tmp989_;
	gboolean _tmp990_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp6_ = vala_method_call_get_call (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (VALA_IS_DELEGATE_TYPE (_tmp9_)) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp10_ = vala_method_call_get_call (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp14_;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		if (VALA_IS_MEMBER_ACCESS (_tmp16_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaMemberAccess* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			ValaMemberAccess* _tmp32_;
			ValaList* _tmp33_;
			ValaList* _tmp34_;
			ValaMemberAccess* _tmp35_;
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			gboolean _tmp88_ = FALSE;
			ValaMemberAccess* _tmp89_;
			ValaSymbol* _tmp90_;
			ValaSymbol* _tmp91_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp19_ = ma;
			_tmp20_ = vala_member_access_get_prototype_access (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				ValaSourceReference* _tmp22_;
				ValaSourceReference* _tmp23_;
				ValaExpression* _tmp24_;
				ValaExpression* _tmp25_;
				ValaSymbol* _tmp26_;
				ValaSymbol* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_method_call_get_call (self);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_symbol_get_full_name (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp29_);
				_tmp31_ = _tmp30_;
				vala_report_error (_tmp23_, _tmp31_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp29_);
				result = FALSE;
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_type_arguments (_tmp32_);
			_tmp34_ = _vala_iterable_ref0 (_tmp33_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp34_;
			_tmp35_ = ma;
			_tmp36_ = vala_member_access_get_inner (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaDataType* _tmp41_;
				ValaDataType* _tmp42_;
				ValaDataType* _tmp43_;
				ValaMemberAccess* _tmp44_;
				ValaExpression* _tmp45_;
				ValaExpression* _tmp46_;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp48_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp59_;
				ValaSymbol* _tmp60_;
				ValaSymbol* _tmp61_;
				gboolean _tmp62_ = FALSE;
				ValaMethod* _tmp63_;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_expression_get_value_type (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _vala_code_node_ref0 (_tmp42_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp43_;
				_tmp44_ = ma;
				_tmp45_ = vala_member_access_get_inner (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_expression_get_symbol_reference (_tmp46_);
				_tmp48_ = _tmp47_;
				if (VALA_IS_SIGNAL (_tmp48_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp49_;
					ValaExpression* _tmp50_;
					ValaExpression* _tmp51_;
					ValaMemberAccess* _tmp52_;
					_tmp49_ = ma;
					_tmp50_ = vala_member_access_get_inner (_tmp49_);
					_tmp51_ = _tmp50_;
					sig = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
					_tmp52_ = sig;
					if (_tmp52_ != NULL) {
						ValaMemberAccess* _tmp53_;
						ValaExpression* _tmp54_;
						ValaExpression* _tmp55_;
						ValaDataType* _tmp56_;
						ValaDataType* _tmp57_;
						ValaDataType* _tmp58_;
						_tmp53_ = sig;
						_tmp54_ = vala_member_access_get_inner (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = vala_expression_get_value_type (_tmp55_);
						_tmp57_ = _tmp56_;
						_tmp58_ = _vala_code_node_ref0 (_tmp57_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp58_;
					}
				}
				_tmp59_ = ma;
				_tmp60_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp59_);
				_tmp61_ = _tmp60_;
				m = VALA_IS_METHOD (_tmp61_) ? ((ValaMethod*) _tmp61_) : NULL;
				_tmp63_ = m;
				if (_tmp63_ != NULL) {
					ValaMethod* _tmp64_;
					gboolean _tmp65_;
					gboolean _tmp66_;
					_tmp64_ = m;
					_tmp65_ = vala_method_get_coroutine (_tmp64_);
					_tmp66_ = _tmp65_;
					_tmp62_ = _tmp66_;
				} else {
					_tmp62_ = FALSE;
				}
				if (_tmp62_) {
					gboolean _tmp67_ = FALSE;
					ValaMemberAccess* _tmp68_;
					const gchar* _tmp69_;
					const gchar* _tmp70_;
					_tmp68_ = ma;
					_tmp69_ = vala_member_access_get_member_name (_tmp68_);
					_tmp70_ = _tmp69_;
					if (g_strcmp0 (_tmp70_, "begin") == 0) {
						_tmp67_ = TRUE;
					} else {
						ValaMemberAccess* _tmp71_;
						const gchar* _tmp72_;
						const gchar* _tmp73_;
						_tmp71_ = ma;
						_tmp72_ = vala_member_access_get_member_name (_tmp71_);
						_tmp73_ = _tmp72_;
						_tmp67_ = g_strcmp0 (_tmp73_, "end") == 0;
					}
					if (_tmp67_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp74_;
						ValaExpression* _tmp75_;
						ValaExpression* _tmp76_;
						gboolean _tmp77_ = FALSE;
						ValaMemberAccess* _tmp78_;
						_tmp74_ = ma;
						_tmp75_ = vala_member_access_get_inner (_tmp74_);
						_tmp76_ = _tmp75_;
						method_access = VALA_IS_MEMBER_ACCESS (_tmp76_) ? ((ValaMemberAccess*) _tmp76_) : NULL;
						_tmp78_ = method_access;
						if (_tmp78_ != NULL) {
							ValaMemberAccess* _tmp79_;
							ValaExpression* _tmp80_;
							ValaExpression* _tmp81_;
							_tmp79_ = method_access;
							_tmp80_ = vala_member_access_get_inner (_tmp79_);
							_tmp81_ = _tmp80_;
							_tmp77_ = _tmp81_ != NULL;
						} else {
							_tmp77_ = FALSE;
						}
						if (_tmp77_) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							ValaDataType* _tmp85_;
							ValaDataType* _tmp86_;
							ValaDataType* _tmp87_;
							_tmp82_ = method_access;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = vala_expression_get_value_type (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp87_ = _vala_code_node_ref0 (_tmp86_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp87_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
					}
				}
			}
			_tmp89_ = ma;
			_tmp90_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp89_);
			_tmp91_ = _tmp90_;
			if (_tmp91_ != NULL) {
				ValaMemberAccess* _tmp92_;
				ValaSymbol* _tmp93_;
				ValaSymbol* _tmp94_;
				ValaAttribute* _tmp95_;
				_tmp92_ = ma;
				_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp94_, "Assert");
				_tmp88_ = _tmp95_ != NULL;
			} else {
				_tmp88_ = FALSE;
			}
			if (_tmp88_) {
				ValaList* _tmp96_;
				gint _tmp97_;
				gint _tmp98_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp96_ = self->priv->argument_list;
				_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
				_tmp98_ = _tmp97_;
				if (_tmp98_ == 1) {
					ValaList* _tmp99_;
					gpointer _tmp100_;
					ValaExpression* _tmp101_;
					ValaSourceReference* _tmp102_;
					ValaSourceReference* _tmp103_;
					_tmp99_ = self->priv->argument_list;
					_tmp100_ = vala_list_get (_tmp99_, 0);
					_tmp101_ = (ValaExpression*) _tmp100_;
					_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp101_);
					_tmp103_ = _tmp102_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp103_);
					_vala_code_node_unref0 (_tmp101_);
				}
			}
		}
	}
	_tmp104_ = vala_method_call_get_call (self);
	_tmp105_ = _tmp104_;
	_tmp106_ = vala_expression_get_value_type (_tmp105_);
	_tmp107_ = _tmp106_;
	_tmp108_ = _vala_code_node_ref0 (_tmp107_);
	mtype = _tmp108_;
	_tmp110_ = vala_code_context_get_profile (context);
	_tmp111_ = _tmp110_;
	if (_tmp111_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp112_;
		ValaExpression* _tmp113_;
		ValaSymbol* _tmp114_;
		ValaSymbol* _tmp115_;
		ValaSemanticAnalyzer* _tmp116_;
		ValaSemanticAnalyzer* _tmp117_;
		ValaClass* _tmp118_;
		_tmp112_ = vala_method_call_get_call (self);
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_expression_get_symbol_reference (_tmp113_);
		_tmp115_ = _tmp114_;
		_tmp116_ = vala_code_context_get_analyzer (context);
		_tmp117_ = _tmp116_;
		_tmp118_ = _tmp117_->object_type;
		_tmp109_ = _tmp115_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp109_ = FALSE;
	}
	gobject_chainup = _tmp109_;
	vala_method_call_set_is_chainup (self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp121_;
		gboolean _tmp122_ = FALSE;
		ValaMemberAccess* _tmp123_;
		gboolean _tmp131_ = FALSE;
		ValaMemberAccess* _tmp132_;
		_tmp119_ = vala_method_call_get_call (self);
		_tmp120_ = _tmp119_;
		expr = _tmp120_;
		_tmp121_ = expr;
		ma = VALA_IS_MEMBER_ACCESS (_tmp121_) ? ((ValaMemberAccess*) _tmp121_) : NULL;
		_tmp123_ = ma;
		if (_tmp123_ != NULL) {
			ValaMemberAccess* _tmp124_;
			ValaSymbol* _tmp125_;
			ValaSymbol* _tmp126_;
			_tmp124_ = ma;
			_tmp125_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp124_);
			_tmp126_ = _tmp125_;
			_tmp122_ = VALA_IS_CREATION_METHOD (_tmp126_);
		} else {
			_tmp122_ = FALSE;
		}
		if (_tmp122_) {
			ValaMemberAccess* _tmp127_;
			ValaExpression* _tmp128_;
			ValaExpression* _tmp129_;
			ValaExpression* _tmp130_;
			_tmp127_ = ma;
			_tmp128_ = vala_member_access_get_inner (_tmp127_);
			_tmp129_ = _tmp128_;
			expr = _tmp129_;
			_tmp130_ = expr;
			ma = VALA_IS_MEMBER_ACCESS (_tmp130_) ? ((ValaMemberAccess*) _tmp130_) : NULL;
		}
		_tmp132_ = ma;
		if (_tmp132_ != NULL) {
			ValaMemberAccess* _tmp133_;
			const gchar* _tmp134_;
			const gchar* _tmp135_;
			_tmp133_ = ma;
			_tmp134_ = vala_member_access_get_member_name (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp131_ = g_strcmp0 (_tmp135_, "this") == 0;
		} else {
			_tmp131_ = FALSE;
		}
		if (_tmp131_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp136_;
			_tmp136_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp136_)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
	}
	base_cm = NULL;
	_tmp137_ = self->priv->_is_chainup;
	if (_tmp137_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp138_;
		ValaSemanticAnalyzer* _tmp139_;
		ValaMethod* _tmp140_;
		ValaCreationMethod* _tmp141_;
		ValaCreationMethod* _tmp149_;
		ValaDataType* _tmp150_;
		_tmp138_ = vala_code_context_get_analyzer (context);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_semantic_analyzer_find_current_method (_tmp139_);
		cm = VALA_IS_CREATION_METHOD (_tmp140_) ? ((ValaCreationMethod*) _tmp140_) : NULL;
		_tmp141_ = cm;
		if (_tmp141_ == NULL) {
			ValaSourceReference* _tmp142_;
			ValaSourceReference* _tmp143_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp143_ = _tmp142_;
			vala_report_error (_tmp143_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp144_;
			gboolean _tmp145_;
			gboolean _tmp146_;
			_tmp144_ = cm;
			_tmp145_ = vala_creation_method_get_chain_up (_tmp144_);
			_tmp146_ = _tmp145_;
			if (_tmp146_) {
				ValaSourceReference* _tmp147_;
				ValaSourceReference* _tmp148_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp148_ = _tmp147_;
				vala_report_error (_tmp148_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp149_ = cm;
		vala_creation_method_set_chain_up (_tmp149_, TRUE);
		_tmp150_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp150_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp151_;
			ValaTypeSymbol* _tmp152_;
			ValaTypeSymbol* _tmp153_;
			ValaClass* _tmp154_;
			ValaCreationMethod* _tmp155_;
			ValaCreationMethod* _tmp156_;
			ValaCreationMethod* _tmp157_;
			_tmp151_ = mtype;
			_tmp152_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp153_ = _tmp152_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp153_, VALA_TYPE_CLASS, ValaClass);
			_tmp154_ = cl;
			_tmp155_ = vala_class_get_default_construction_method (_tmp154_);
			_tmp156_ = _tmp155_;
			base_cm = _tmp156_;
			_tmp157_ = base_cm;
			if (_tmp157_ == NULL) {
				ValaSourceReference* _tmp158_;
				ValaSourceReference* _tmp159_;
				ValaClass* _tmp160_;
				gchar* _tmp161_;
				gchar* _tmp162_;
				gchar* _tmp163_;
				gchar* _tmp164_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp159_ = _tmp158_;
				_tmp160_ = cl;
				_tmp161_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp160_);
				_tmp162_ = _tmp161_;
				_tmp163_ = g_strdup_printf ("chain up to `%s' not supported", _tmp162_);
				_tmp164_ = _tmp163_;
				vala_report_error (_tmp159_, _tmp164_);
				_g_free0 (_tmp164_);
				_g_free0 (_tmp162_);
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp165_;
				gboolean _tmp166_;
				gboolean _tmp167_;
				_tmp165_ = base_cm;
				_tmp166_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp165_);
				_tmp167_ = _tmp166_;
				if (!_tmp167_) {
					ValaSourceReference* _tmp168_;
					ValaSourceReference* _tmp169_;
					ValaCreationMethod* _tmp170_;
					gchar* _tmp171_;
					gchar* _tmp172_;
					gchar* _tmp173_;
					gchar* _tmp174_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp168_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp169_ = _tmp168_;
					_tmp170_ = base_cm;
					_tmp171_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp170_);
					_tmp172_ = _tmp171_;
					_tmp173_ = g_strdup_printf ("chain up to `%s' not supported", _tmp172_);
					_tmp174_ = _tmp173_;
					vala_report_error (_tmp169_, _tmp174_);
					_g_free0 (_tmp174_);
					_g_free0 (_tmp172_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
		} else {
			gboolean _tmp175_ = FALSE;
			ValaExpression* _tmp176_;
			ValaExpression* _tmp177_;
			ValaSymbol* _tmp178_;
			ValaSymbol* _tmp179_;
			_tmp176_ = vala_method_call_get_call (self);
			_tmp177_ = _tmp176_;
			_tmp178_ = vala_expression_get_symbol_reference (_tmp177_);
			_tmp179_ = _tmp178_;
			if (VALA_IS_CREATION_METHOD (_tmp179_)) {
				ValaExpression* _tmp180_;
				ValaExpression* _tmp181_;
				ValaSymbol* _tmp182_;
				ValaSymbol* _tmp183_;
				ValaSymbol* _tmp184_;
				ValaSymbol* _tmp185_;
				_tmp180_ = vala_method_call_get_call (self);
				_tmp181_ = _tmp180_;
				_tmp182_ = vala_expression_get_symbol_reference (_tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_symbol_get_parent_symbol (_tmp183_);
				_tmp185_ = _tmp184_;
				_tmp175_ = VALA_IS_CLASS (_tmp185_);
			} else {
				_tmp175_ = FALSE;
			}
			if (_tmp175_) {
				ValaExpression* _tmp186_;
				ValaExpression* _tmp187_;
				ValaSymbol* _tmp188_;
				ValaSymbol* _tmp189_;
				ValaCreationMethod* _tmp190_;
				gboolean _tmp191_;
				gboolean _tmp192_;
				_tmp186_ = vala_method_call_get_call (self);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_expression_get_symbol_reference (_tmp187_);
				_tmp189_ = _tmp188_;
				base_cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp189_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
				_tmp190_ = base_cm;
				_tmp191_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp190_);
				_tmp192_ = _tmp191_;
				if (!_tmp192_) {
					ValaSourceReference* _tmp193_;
					ValaSourceReference* _tmp194_;
					ValaCreationMethod* _tmp195_;
					gchar* _tmp196_;
					gchar* _tmp197_;
					gchar* _tmp198_;
					gchar* _tmp199_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp193_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp194_ = _tmp193_;
					_tmp195_ = base_cm;
					_tmp196_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp195_);
					_tmp197_ = _tmp196_;
					_tmp198_ = g_strdup_printf ("chain up to `%s' not supported", _tmp197_);
					_tmp199_ = _tmp198_;
					vala_report_error (_tmp194_, _tmp199_);
					_g_free0 (_tmp199_);
					_g_free0 (_tmp197_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp200_;
					ValaSymbol* _tmp201_;
					ValaSymbol* _tmp202_;
					gboolean _tmp203_ = FALSE;
					ValaClass* _tmp204_;
					ValaExpression* _tmp211_;
					ValaExpression* _tmp212_;
					ValaSemanticAnalyzer* _tmp213_;
					ValaSemanticAnalyzer* _tmp214_;
					ValaClass* _tmp215_;
					ValaObjectType* _tmp216_;
					ValaObjectType* _tmp217_;
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					ValaDataType* _tmp220_;
					ValaDataType* _tmp221_;
					ValaSourceReference* _tmp222_;
					ValaSourceReference* _tmp223_;
					ValaExpression* _tmp224_;
					ValaExpression* _tmp225_;
					ValaDataType* _tmp226_;
					ValaDataType* _tmp227_;
					ValaDataType* _tmp228_;
					_tmp200_ = cm;
					_tmp201_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp200_);
					_tmp202_ = _tmp201_;
					cl = VALA_IS_CLASS (_tmp202_) ? ((ValaClass*) _tmp202_) : NULL;
					_tmp204_ = cl;
					if (_tmp204_ == NULL) {
						_tmp203_ = TRUE;
					} else {
						ValaClass* _tmp205_;
						ValaSemanticAnalyzer* _tmp206_;
						ValaSemanticAnalyzer* _tmp207_;
						ValaClass* _tmp208_;
						_tmp205_ = cl;
						_tmp206_ = vala_code_context_get_analyzer (context);
						_tmp207_ = _tmp206_;
						_tmp208_ = _tmp207_->object_type;
						_tmp203_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp205_, (ValaTypeSymbol*) _tmp208_);
					}
					if (_tmp203_) {
						ValaSourceReference* _tmp209_;
						ValaSourceReference* _tmp210_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp210_ = _tmp209_;
						vala_report_error (_tmp210_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp211_ = vala_method_call_get_call (self);
					_tmp212_ = _tmp211_;
					_tmp213_ = vala_code_context_get_analyzer (context);
					_tmp214_ = _tmp213_;
					_tmp215_ = _tmp214_->object_type;
					_tmp216_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp215_);
					_tmp217_ = _tmp216_;
					vala_expression_set_value_type (_tmp212_, (ValaDataType*) _tmp217_);
					_vala_code_node_unref0 (_tmp217_);
					_tmp218_ = vala_method_call_get_call (self);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_expression_get_value_type (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp223_ = _tmp222_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp221_, _tmp223_);
					_tmp224_ = vala_method_call_get_call (self);
					_tmp225_ = _tmp224_;
					_tmp226_ = vala_expression_get_value_type (_tmp225_);
					_tmp227_ = _tmp226_;
					_tmp228_ = _vala_code_node_ref0 (_tmp227_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp228_;
				}
			}
		}
	}
	_tmp230_ = vala_method_call_get_call (self);
	_tmp231_ = _tmp230_;
	if (VALA_IS_MEMBER_ACCESS (_tmp231_)) {
		gboolean _tmp232_ = FALSE;
		gboolean _tmp233_ = FALSE;
		ValaExpression* _tmp234_;
		ValaExpression* _tmp235_;
		ValaSymbol* _tmp236_;
		ValaSymbol* _tmp237_;
		_tmp234_ = vala_method_call_get_call (self);
		_tmp235_ = _tmp234_;
		_tmp236_ = vala_expression_get_symbol_reference (_tmp235_);
		_tmp237_ = _tmp236_;
		if (VALA_IS_CREATION_METHOD (_tmp237_)) {
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			ValaSymbol* _tmp240_;
			ValaSymbol* _tmp241_;
			ValaSymbol* _tmp242_;
			ValaSymbol* _tmp243_;
			_tmp238_ = vala_method_call_get_call (self);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_expression_get_symbol_reference (_tmp239_);
			_tmp241_ = _tmp240_;
			_tmp242_ = vala_symbol_get_parent_symbol (_tmp241_);
			_tmp243_ = _tmp242_;
			_tmp233_ = VALA_IS_STRUCT (_tmp243_);
		} else {
			_tmp233_ = FALSE;
		}
		if (_tmp233_) {
			_tmp232_ = TRUE;
		} else {
			ValaExpression* _tmp244_;
			ValaExpression* _tmp245_;
			ValaSymbol* _tmp246_;
			ValaSymbol* _tmp247_;
			_tmp244_ = vala_method_call_get_call (self);
			_tmp245_ = _tmp244_;
			_tmp246_ = vala_expression_get_symbol_reference (_tmp245_);
			_tmp247_ = _tmp246_;
			_tmp232_ = VALA_IS_STRUCT (_tmp247_);
		}
		_tmp229_ = _tmp232_;
	} else {
		_tmp229_ = FALSE;
	}
	if (_tmp229_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp248_;
		ValaExpression* _tmp249_;
		ValaSymbol* _tmp250_;
		ValaSymbol* _tmp251_;
		gboolean _tmp252_ = FALSE;
		gboolean _tmp253_ = FALSE;
		ValaStruct* _tmp254_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp265_;
		ValaExpression* _tmp266_;
		ValaSourceReference* _tmp267_;
		ValaSourceReference* _tmp268_;
		ValaObjectCreationExpression* _tmp269_;
		ValaObjectCreationExpression* _tmp270_;
		ValaObjectCreationExpression* _tmp271_;
		gboolean _tmp272_;
		ValaObjectCreationExpression* _tmp284_;
		ValaDataType* _tmp285_;
		ValaDataType* _tmp286_;
		ValaSemanticAnalyzer* _tmp287_;
		ValaSemanticAnalyzer* _tmp288_;
		ValaList* _tmp289_;
		ValaCodeNode* _tmp290_;
		ValaCodeNode* _tmp291_;
		ValaObjectCreationExpression* _tmp292_;
		ValaObjectCreationExpression* _tmp293_;
		_tmp248_ = vala_method_call_get_call (self);
		_tmp249_ = _tmp248_;
		_tmp250_ = vala_expression_get_symbol_reference (_tmp249_);
		_tmp251_ = _tmp250_;
		st = VALA_IS_STRUCT (_tmp251_) ? ((ValaStruct*) _tmp251_) : NULL;
		_tmp254_ = st;
		if (_tmp254_ != NULL) {
			ValaStruct* _tmp255_;
			ValaCreationMethod* _tmp256_;
			ValaCreationMethod* _tmp257_;
			_tmp255_ = st;
			_tmp256_ = vala_struct_get_default_construction_method (_tmp255_);
			_tmp257_ = _tmp256_;
			_tmp253_ = _tmp257_ == NULL;
		} else {
			_tmp253_ = FALSE;
		}
		if (_tmp253_) {
			gboolean _tmp258_ = FALSE;
			gboolean _tmp259_ = FALSE;
			ValaStruct* _tmp260_;
			_tmp260_ = st;
			if (vala_struct_is_boolean_type (_tmp260_)) {
				_tmp259_ = TRUE;
			} else {
				ValaStruct* _tmp261_;
				_tmp261_ = st;
				_tmp259_ = vala_struct_is_integer_type (_tmp261_);
			}
			if (_tmp259_) {
				_tmp258_ = TRUE;
			} else {
				ValaStruct* _tmp262_;
				_tmp262_ = st;
				_tmp258_ = vala_struct_is_floating_type (_tmp262_);
			}
			_tmp252_ = _tmp258_;
		} else {
			_tmp252_ = FALSE;
		}
		if (_tmp252_) {
			ValaSourceReference* _tmp263_;
			ValaSourceReference* _tmp264_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp263_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp264_ = _tmp263_;
			vala_report_error (_tmp264_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp265_ = vala_method_call_get_call (self);
		_tmp266_ = _tmp265_;
		_tmp267_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp268_ = _tmp267_;
		_tmp269_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp266_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp268_);
		struct_creation_expression = _tmp269_;
		_tmp270_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp270_, TRUE);
		_tmp271_ = struct_creation_expression;
		_tmp272_ = self->priv->_is_chainup;
		vala_object_creation_expression_set_is_chainup (_tmp271_, _tmp272_);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp273_;
			ValaList* _tmp274_;
			gint _arg_size = 0;
			ValaList* _tmp275_;
			gint _tmp276_;
			gint _tmp277_;
			gint _arg_index = 0;
			_tmp273_ = self->priv->argument_list;
			_tmp274_ = _vala_iterable_ref0 (_tmp273_);
			_arg_list = _tmp274_;
			_tmp275_ = _arg_list;
			_tmp276_ = vala_collection_get_size ((ValaCollection*) _tmp275_);
			_tmp277_ = _tmp276_;
			_arg_size = _tmp277_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp278_;
				gint _tmp279_;
				ValaExpression* arg = NULL;
				ValaList* _tmp280_;
				gpointer _tmp281_;
				ValaObjectCreationExpression* _tmp282_;
				ValaExpression* _tmp283_;
				_arg_index = _arg_index + 1;
				_tmp278_ = _arg_index;
				_tmp279_ = _arg_size;
				if (!(_tmp278_ < _tmp279_)) {
					break;
				}
				_tmp280_ = _arg_list;
				_tmp281_ = vala_list_get (_tmp280_, _arg_index);
				arg = (ValaExpression*) _tmp281_;
				_tmp282_ = struct_creation_expression;
				_tmp283_ = arg;
				vala_object_creation_expression_add_argument (_tmp282_, _tmp283_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp284_ = struct_creation_expression;
		_tmp285_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp286_ = _tmp285_;
		vala_expression_set_target_type ((ValaExpression*) _tmp284_, _tmp286_);
		_tmp287_ = vala_code_context_get_analyzer (context);
		_tmp288_ = _tmp287_;
		_tmp289_ = _tmp288_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp289_, (ValaCodeNode*) self);
		_tmp290_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp291_ = _tmp290_;
		_tmp292_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp291_, (ValaExpression*) self, (ValaExpression*) _tmp292_);
		_tmp293_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp293_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp294_ = FALSE;
		gboolean _tmp295_ = FALSE;
		gboolean _tmp296_;
		_tmp296_ = self->priv->_is_chainup;
		if (!_tmp296_) {
			ValaExpression* _tmp297_;
			ValaExpression* _tmp298_;
			_tmp297_ = vala_method_call_get_call (self);
			_tmp298_ = _tmp297_;
			_tmp295_ = VALA_IS_MEMBER_ACCESS (_tmp298_);
		} else {
			_tmp295_ = FALSE;
		}
		if (_tmp295_) {
			ValaExpression* _tmp299_;
			ValaExpression* _tmp300_;
			ValaSymbol* _tmp301_;
			ValaSymbol* _tmp302_;
			_tmp299_ = vala_method_call_get_call (self);
			_tmp300_ = _tmp299_;
			_tmp301_ = vala_expression_get_symbol_reference (_tmp300_);
			_tmp302_ = _tmp301_;
			_tmp294_ = VALA_IS_CREATION_METHOD (_tmp302_);
		} else {
			_tmp294_ = FALSE;
		}
		if (_tmp294_) {
			ValaSourceReference* _tmp303_;
			ValaSourceReference* _tmp304_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp303_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp304_ = _tmp303_;
			vala_report_error (_tmp304_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp306_ = self->priv->_is_chainup;
	if (!_tmp306_) {
		ValaDataType* _tmp307_;
		_tmp307_ = mtype;
		_tmp305_ = VALA_IS_OBJECT_TYPE (_tmp307_);
	} else {
		_tmp305_ = FALSE;
	}
	if (_tmp305_) {
		ValaSourceReference* _tmp308_;
		ValaSourceReference* _tmp309_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp308_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp309_ = _tmp308_;
		vala_report_error (_tmp309_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp310_ = FALSE;
		ValaDataType* _tmp311_;
		_tmp311_ = mtype;
		if (_tmp311_ != NULL) {
			ValaDataType* _tmp312_;
			_tmp312_ = mtype;
			_tmp310_ = vala_data_type_is_invokable (_tmp312_);
		} else {
			_tmp310_ = FALSE;
		}
		if (_tmp310_) {
		} else {
			ValaExpression* _tmp313_;
			ValaExpression* _tmp314_;
			ValaSymbol* _tmp315_;
			ValaSymbol* _tmp316_;
			_tmp313_ = vala_method_call_get_call (self);
			_tmp314_ = _tmp313_;
			_tmp315_ = vala_expression_get_symbol_reference (_tmp314_);
			_tmp316_ = _tmp315_;
			if (VALA_IS_CLASS (_tmp316_)) {
				ValaSourceReference* _tmp317_;
				ValaSourceReference* _tmp318_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp317_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp318_ = _tmp317_;
				vala_report_error (_tmp318_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp319_;
				ValaSourceReference* _tmp320_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp319_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp320_ = _tmp319_;
				vala_report_error (_tmp320_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp321_ = mtype;
	_tmp322_ = vala_data_type_get_return_type (_tmp321_);
	_tmp323_ = _vala_code_node_ref0 (_tmp322_);
	ret_type = _tmp323_;
	_tmp324_ = mtype;
	_tmp325_ = vala_data_type_get_parameters (_tmp324_);
	_tmp326_ = _vala_iterable_ref0 (_tmp325_);
	params = _tmp326_;
	_tmp327_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp327_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp328_;
		ValaExpression* _tmp329_;
		ValaMethod* m = NULL;
		ValaDataType* _tmp330_;
		ValaMethod* _tmp331_;
		ValaMethod* _tmp332_;
		ValaMethod* _tmp333_;
		gboolean _tmp334_;
		gboolean _tmp335_;
		gint n_type_params = 0;
		ValaMethod* _tmp366_;
		ValaList* _tmp367_;
		gint _tmp368_;
		gint _tmp369_;
		gint n_type_args = 0;
		ValaMemberAccess* _tmp370_;
		ValaList* _tmp371_;
		gint _tmp372_;
		gint _tmp373_;
		gboolean _tmp374_ = FALSE;
		_tmp328_ = vala_method_call_get_call (self);
		_tmp329_ = _tmp328_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp329_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp330_ = mtype;
		_tmp331_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp330_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp332_ = _tmp331_;
		m = _tmp332_;
		_tmp333_ = m;
		_tmp334_ = vala_method_get_coroutine (_tmp333_);
		_tmp335_ = _tmp334_;
		if (_tmp335_) {
			gboolean _tmp336_;
			_tmp336_ = self->priv->_is_yield_expression;
			if (!_tmp336_) {
				ValaMemberAccess* _tmp337_;
				const gchar* _tmp338_;
				const gchar* _tmp339_;
				_tmp337_ = ma;
				_tmp338_ = vala_member_access_get_member_name (_tmp337_);
				_tmp339_ = _tmp338_;
				if (g_strcmp0 (_tmp339_, "end") != 0) {
					ValaMemberAccess* _tmp340_;
					const gchar* _tmp341_;
					const gchar* _tmp342_;
					ValaMethod* _tmp346_;
					ValaList* _tmp347_;
					ValaVoidType* _tmp348_;
					_tmp340_ = ma;
					_tmp341_ = vala_member_access_get_member_name (_tmp340_);
					_tmp342_ = _tmp341_;
					if (g_strcmp0 (_tmp342_, "begin") != 0) {
						ValaMemberAccess* _tmp343_;
						ValaSourceReference* _tmp344_;
						ValaSourceReference* _tmp345_;
						_tmp343_ = ma;
						_tmp344_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp343_);
						_tmp345_ = _tmp344_;
						vala_report_deprecated (_tmp345_, "implicit .begin is deprecated");
					}
					_tmp346_ = m;
					_tmp347_ = vala_method_get_async_begin_parameters (_tmp346_);
					_vala_iterable_unref0 (params);
					params = _tmp347_;
					_tmp348_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp348_;
				} else {
					ValaMethod* _tmp349_;
					ValaList* _tmp350_;
					_tmp349_ = m;
					_tmp350_ = vala_method_get_async_end_parameters (_tmp349_);
					_vala_iterable_unref0 (params);
					params = _tmp350_;
				}
			} else {
				gboolean _tmp351_ = FALSE;
				ValaMemberAccess* _tmp352_;
				const gchar* _tmp353_;
				const gchar* _tmp354_;
				_tmp352_ = ma;
				_tmp353_ = vala_member_access_get_member_name (_tmp352_);
				_tmp354_ = _tmp353_;
				if (g_strcmp0 (_tmp354_, "begin") == 0) {
					_tmp351_ = TRUE;
				} else {
					ValaMemberAccess* _tmp355_;
					const gchar* _tmp356_;
					const gchar* _tmp357_;
					_tmp355_ = ma;
					_tmp356_ = vala_member_access_get_member_name (_tmp355_);
					_tmp357_ = _tmp356_;
					_tmp351_ = g_strcmp0 (_tmp357_, "end") == 0;
				}
				if (_tmp351_) {
					ValaMemberAccess* _tmp358_;
					ValaSourceReference* _tmp359_;
					ValaSourceReference* _tmp360_;
					ValaMemberAccess* _tmp361_;
					const gchar* _tmp362_;
					const gchar* _tmp363_;
					gchar* _tmp364_;
					gchar* _tmp365_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp358_ = ma;
					_tmp359_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp358_);
					_tmp360_ = _tmp359_;
					_tmp361_ = ma;
					_tmp362_ = vala_member_access_get_member_name (_tmp361_);
					_tmp363_ = _tmp362_;
					_tmp364_ = g_strdup_printf ("use of `%s' not allowed in yield statement", _tmp363_);
					_tmp365_ = _tmp364_;
					vala_report_error (_tmp360_, _tmp365_);
					_g_free0 (_tmp365_);
				}
			}
		}
		_tmp366_ = m;
		_tmp367_ = vala_method_get_type_parameters (_tmp366_);
		_tmp368_ = vala_collection_get_size ((ValaCollection*) _tmp367_);
		_tmp369_ = _tmp368_;
		n_type_params = _tmp369_;
		_tmp370_ = ma;
		_tmp371_ = vala_member_access_get_type_arguments (_tmp370_);
		_tmp372_ = vala_collection_get_size ((ValaCollection*) _tmp371_);
		_tmp373_ = _tmp372_;
		n_type_args = _tmp373_;
		if (n_type_args > 0) {
			_tmp374_ = n_type_args < n_type_params;
		} else {
			_tmp374_ = FALSE;
		}
		if (_tmp374_) {
			ValaMemberAccess* _tmp375_;
			ValaSourceReference* _tmp376_;
			ValaSourceReference* _tmp377_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp375_ = ma;
			_tmp376_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp375_);
			_tmp377_ = _tmp376_;
			vala_report_error (_tmp377_, "too few type arguments");
			result = FALSE;
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			gboolean _tmp378_ = FALSE;
			if (n_type_args > 0) {
				_tmp378_ = n_type_args > n_type_params;
			} else {
				_tmp378_ = FALSE;
			}
			if (_tmp378_) {
				ValaMemberAccess* _tmp379_;
				ValaSourceReference* _tmp380_;
				ValaSourceReference* _tmp381_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp379_ = ma;
				_tmp380_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp379_);
				_tmp381_ = _tmp380_;
				vala_report_error (_tmp381_, "too many type arguments");
				result = FALSE;
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	last_arg = NULL;
	_tmp382_ = self->priv->argument_list;
	_tmp383_ = vala_iterable_iterator ((ValaIterable*) _tmp382_);
	arg_it = _tmp383_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp384_;
		ValaList* _tmp385_;
		gint _param_size = 0;
		ValaList* _tmp386_;
		gint _tmp387_;
		gint _tmp388_;
		gint _param_index = 0;
		_tmp384_ = params;
		_tmp385_ = _vala_iterable_ref0 (_tmp384_);
		_param_list = _tmp385_;
		_tmp386_ = _param_list;
		_tmp387_ = vala_collection_get_size ((ValaCollection*) _tmp386_);
		_tmp388_ = _tmp387_;
		_param_size = _tmp388_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp389_;
			gint _tmp390_;
			ValaParameter* param = NULL;
			ValaList* _tmp391_;
			gpointer _tmp392_;
			ValaParameter* _tmp393_;
			ValaParameter* _tmp394_;
			gboolean _tmp395_;
			gboolean _tmp396_;
			ValaParameter* _tmp397_;
			gboolean _tmp398_;
			gboolean _tmp399_;
			ValaIterator* _tmp417_;
			_param_index = _param_index + 1;
			_tmp389_ = _param_index;
			_tmp390_ = _param_size;
			if (!(_tmp389_ < _tmp390_)) {
				break;
			}
			_tmp391_ = _param_list;
			_tmp392_ = vala_list_get (_tmp391_, _param_index);
			param = (ValaParameter*) _tmp392_;
			_tmp393_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp393_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp394_ = param;
			_tmp395_ = vala_parameter_get_ellipsis (_tmp394_);
			_tmp396_ = _tmp395_;
			if (_tmp396_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp397_ = param;
			_tmp398_ = vala_parameter_get_params_array (_tmp397_);
			_tmp399_ = _tmp398_;
			if (_tmp399_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp400_;
				ValaDataType* _tmp401_;
				ValaDataType* _tmp402_;
				ValaArrayType* _tmp403_;
				_tmp400_ = param;
				_tmp401_ = vala_variable_get_variable_type ((ValaVariable*) _tmp400_);
				_tmp402_ = _tmp401_;
				_tmp403_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp402_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp403_;
				while (TRUE) {
					ValaIterator* _tmp404_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp405_;
					gpointer _tmp406_;
					ValaExpression* _tmp407_;
					ValaArrayType* _tmp408_;
					ValaDataType* _tmp409_;
					ValaDataType* _tmp410_;
					ValaExpression* _tmp411_;
					ValaDataType* _tmp412_;
					ValaDataType* _tmp413_;
					ValaArrayType* _tmp414_;
					gboolean _tmp415_;
					gboolean _tmp416_;
					_tmp404_ = arg_it;
					if (!vala_iterator_next (_tmp404_)) {
						break;
					}
					_tmp405_ = arg_it;
					_tmp406_ = vala_iterator_get (_tmp405_);
					arg = (ValaExpression*) _tmp406_;
					_tmp407_ = arg;
					_tmp408_ = array_type;
					_tmp409_ = vala_array_type_get_element_type (_tmp408_);
					_tmp410_ = _tmp409_;
					vala_expression_set_target_type (_tmp407_, _tmp410_);
					_tmp411_ = arg;
					_tmp412_ = vala_expression_get_target_type (_tmp411_);
					_tmp413_ = _tmp412_;
					_tmp414_ = array_type;
					_tmp415_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp414_);
					_tmp416_ = _tmp415_;
					vala_data_type_set_value_owned (_tmp413_, _tmp416_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp417_ = arg_it;
			if (vala_iterator_next (_tmp417_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp418_;
				gpointer _tmp419_;
				ValaExpression* _tmp420_;
				ValaParameter* _tmp421_;
				ValaDataType* _tmp422_;
				ValaDataType* _tmp423_;
				ValaExpression* _tmp424_;
				ValaExpression* _tmp425_;
				ValaDataType* _tmp426_;
				ValaDataType* _tmp427_;
				ValaDataType* _tmp428_;
				ValaList* _tmp429_;
				ValaDataType* _tmp430_;
				ValaDataType* _tmp431_;
				ValaExpression* _tmp432_;
				ValaExpression* _tmp433_;
				_tmp418_ = arg_it;
				_tmp419_ = vala_iterator_get (_tmp418_);
				arg = (ValaExpression*) _tmp419_;
				_tmp420_ = arg;
				_tmp421_ = param;
				_tmp422_ = vala_variable_get_variable_type ((ValaVariable*) _tmp421_);
				_tmp423_ = _tmp422_;
				vala_expression_set_formal_target_type (_tmp420_, _tmp423_);
				_tmp424_ = arg;
				_tmp425_ = arg;
				_tmp426_ = vala_expression_get_formal_target_type (_tmp425_);
				_tmp427_ = _tmp426_;
				_tmp428_ = target_object_type;
				_tmp429_ = method_type_args;
				_tmp430_ = vala_data_type_get_actual_type (_tmp427_, _tmp428_, _tmp429_, (ValaCodeNode*) self);
				_tmp431_ = _tmp430_;
				vala_expression_set_target_type (_tmp424_, _tmp431_);
				_vala_code_node_unref0 (_tmp431_);
				_tmp432_ = arg;
				_tmp433_ = _vala_code_node_ref0 (_tmp432_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp433_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp435_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp435_)) {
		ValaDataType* _tmp436_;
		ValaMethod* _tmp437_;
		ValaMethod* _tmp438_;
		ValaAttribute* _tmp439_;
		_tmp436_ = mtype;
		_tmp437_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp436_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp438_ = _tmp437_;
		_tmp439_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp438_, "Print");
		_tmp434_ = _tmp439_ != NULL;
	} else {
		_tmp434_ = FALSE;
	}
	if (_tmp434_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp440_;
		ValaSourceReference* _tmp441_;
		ValaTemplate* _tmp442_;
		ValaList* _tmp455_;
		ValaTemplate* _tmp456_;
		_tmp440_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp441_ = _tmp440_;
		_tmp442_ = vala_template_new (_tmp441_);
		template = _tmp442_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp443_;
			ValaList* _tmp444_;
			gint _arg_size = 0;
			ValaList* _tmp445_;
			gint _tmp446_;
			gint _tmp447_;
			gint _arg_index = 0;
			_tmp443_ = self->priv->argument_list;
			_tmp444_ = _vala_iterable_ref0 (_tmp443_);
			_arg_list = _tmp444_;
			_tmp445_ = _arg_list;
			_tmp446_ = vala_collection_get_size ((ValaCollection*) _tmp445_);
			_tmp447_ = _tmp446_;
			_arg_size = _tmp447_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp448_;
				gint _tmp449_;
				ValaExpression* arg = NULL;
				ValaList* _tmp450_;
				gpointer _tmp451_;
				ValaExpression* _tmp452_;
				ValaTemplate* _tmp453_;
				ValaExpression* _tmp454_;
				_arg_index = _arg_index + 1;
				_tmp448_ = _arg_index;
				_tmp449_ = _arg_size;
				if (!(_tmp448_ < _tmp449_)) {
					break;
				}
				_tmp450_ = _arg_list;
				_tmp451_ = vala_list_get (_tmp450_, _arg_index);
				arg = (ValaExpression*) _tmp451_;
				_tmp452_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp452_, NULL);
				_tmp453_ = template;
				_tmp454_ = arg;
				vala_template_add_expression (_tmp453_, _tmp454_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp455_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp455_);
		_tmp456_ = template;
		vala_method_call_add_argument (self, (ValaExpression*) _tmp456_);
		_vala_code_node_unref0 (template);
	}
	_tmp458_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp458_)) {
		ValaDataType* _tmp459_;
		ValaMethod* _tmp460_;
		ValaMethod* _tmp461_;
		gboolean _tmp462_;
		gboolean _tmp463_;
		_tmp459_ = mtype;
		_tmp460_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp459_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp461_ = _tmp460_;
		_tmp462_ = vala_method_get_printf_format (_tmp461_);
		_tmp463_ = _tmp462_;
		_tmp457_ = _tmp463_;
	} else {
		_tmp457_ = FALSE;
	}
	if (_tmp457_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp464_;
		ValaStringLiteral* _tmp514_;
		format_literal = NULL;
		_tmp464_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp464_)) {
		} else {
			ValaExpression* _tmp465_;
			_tmp465_ = last_arg;
			if (_tmp465_ != NULL) {
				ValaExpression* _tmp466_;
				ValaStringLiteral* _tmp467_;
				gboolean _tmp468_ = FALSE;
				ValaStringLiteral* _tmp469_;
				_tmp466_ = last_arg;
				_tmp467_ = vala_string_literal_get_format_literal (_tmp466_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp467_;
				_tmp469_ = format_literal;
				if (_tmp469_ == NULL) {
					ValaList* _tmp470_;
					gint _tmp471_;
					gint _tmp472_;
					ValaList* _tmp473_;
					gint _tmp474_;
					gint _tmp475_;
					_tmp470_ = self->priv->argument_list;
					_tmp471_ = vala_collection_get_size ((ValaCollection*) _tmp470_);
					_tmp472_ = _tmp471_;
					_tmp473_ = params;
					_tmp474_ = vala_collection_get_size ((ValaCollection*) _tmp473_);
					_tmp475_ = _tmp474_;
					_tmp468_ = _tmp472_ == (_tmp475_ - 1);
				} else {
					_tmp468_ = FALSE;
				}
				if (_tmp468_) {
					ValaStringLiteral* _tmp476_;
					ValaStringLiteral* _tmp477_;
					ValaSemanticAnalyzer* _tmp478_;
					ValaSemanticAnalyzer* _tmp479_;
					ValaDataType* _tmp480_;
					ValaDataType* _tmp481_;
					ValaDataType* _tmp482_;
					ValaList* _tmp483_;
					ValaList* _tmp484_;
					gint _tmp485_;
					gint _tmp486_;
					ValaStringLiteral* _tmp487_;
					ValaList* _tmp488_;
					ValaIterator* _tmp489_;
					_tmp476_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp476_;
					_tmp477_ = format_literal;
					_tmp478_ = vala_code_context_get_analyzer (context);
					_tmp479_ = _tmp478_;
					_tmp480_ = _tmp479_->string_type;
					_tmp481_ = vala_data_type_copy (_tmp480_);
					_tmp482_ = _tmp481_;
					vala_expression_set_target_type ((ValaExpression*) _tmp477_, _tmp482_);
					_vala_code_node_unref0 (_tmp482_);
					_tmp483_ = self->priv->argument_list;
					_tmp484_ = self->priv->argument_list;
					_tmp485_ = vala_collection_get_size ((ValaCollection*) _tmp484_);
					_tmp486_ = _tmp485_;
					_tmp487_ = format_literal;
					vala_list_insert (_tmp483_, _tmp486_ - 1, (ValaExpression*) _tmp487_);
					_tmp488_ = self->priv->argument_list;
					_tmp489_ = vala_iterable_iterator ((ValaIterable*) _tmp488_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp489_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp490_;
						ValaList* _tmp491_;
						gint _param_size = 0;
						ValaList* _tmp492_;
						gint _tmp493_;
						gint _tmp494_;
						gint _param_index = 0;
						_tmp490_ = params;
						_tmp491_ = _vala_iterable_ref0 (_tmp490_);
						_param_list = _tmp491_;
						_tmp492_ = _param_list;
						_tmp493_ = vala_collection_get_size ((ValaCollection*) _tmp492_);
						_tmp494_ = _tmp493_;
						_param_size = _tmp494_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp495_;
							gint _tmp496_;
							ValaParameter* param = NULL;
							ValaList* _tmp497_;
							gpointer _tmp498_;
							gboolean _tmp499_ = FALSE;
							ValaParameter* _tmp500_;
							gboolean _tmp501_;
							gboolean _tmp502_;
							ValaIterator* _tmp506_;
							_param_index = _param_index + 1;
							_tmp495_ = _param_index;
							_tmp496_ = _param_size;
							if (!(_tmp495_ < _tmp496_)) {
								break;
							}
							_tmp497_ = _param_list;
							_tmp498_ = vala_list_get (_tmp497_, _param_index);
							param = (ValaParameter*) _tmp498_;
							_tmp500_ = param;
							_tmp501_ = vala_parameter_get_ellipsis (_tmp500_);
							_tmp502_ = _tmp501_;
							if (_tmp502_) {
								_tmp499_ = TRUE;
							} else {
								ValaParameter* _tmp503_;
								gboolean _tmp504_;
								gboolean _tmp505_;
								_tmp503_ = param;
								_tmp504_ = vala_parameter_get_params_array (_tmp503_);
								_tmp505_ = _tmp504_;
								_tmp499_ = _tmp505_;
							}
							if (_tmp499_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp506_ = arg_it;
							vala_iterator_next (_tmp506_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp507_;
				ValaExpression* _tmp508_;
				ValaMemberAccess* _tmp509_;
				_tmp507_ = vala_method_call_get_call (self);
				_tmp508_ = _tmp507_;
				ma = VALA_IS_MEMBER_ACCESS (_tmp508_) ? ((ValaMemberAccess*) _tmp508_) : NULL;
				_tmp509_ = ma;
				if (_tmp509_ != NULL) {
					ValaMemberAccess* _tmp510_;
					ValaExpression* _tmp511_;
					ValaExpression* _tmp512_;
					ValaStringLiteral* _tmp513_;
					_tmp510_ = ma;
					_tmp511_ = vala_member_access_get_inner (_tmp510_);
					_tmp512_ = _tmp511_;
					_tmp513_ = vala_string_literal_get_format_literal (_tmp512_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp513_;
				}
			}
		}
		_tmp514_ = format_literal;
		if (_tmp514_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp515_;
			gchar* _tmp516_;
			ValaSemanticAnalyzer* _tmp517_;
			ValaSemanticAnalyzer* _tmp518_;
			const gchar* _tmp519_;
			ValaIterator* _tmp520_;
			ValaSourceReference* _tmp521_;
			ValaSourceReference* _tmp522_;
			_tmp515_ = format_literal;
			_tmp516_ = vala_string_literal_eval (_tmp515_);
			format = _tmp516_;
			_tmp517_ = vala_code_context_get_analyzer (context);
			_tmp518_ = _tmp517_;
			_tmp519_ = format;
			_tmp520_ = arg_it;
			_tmp521_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp522_ = _tmp521_;
			if (!vala_semantic_analyzer_check_print_format (_tmp518_, _tmp519_, _tmp520_, _tmp522_)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp523_;
		ValaList* _tmp524_;
		gint _arg_size = 0;
		ValaList* _tmp525_;
		gint _tmp526_;
		gint _tmp527_;
		gint _arg_index = 0;
		_tmp523_ = self->priv->argument_list;
		_tmp524_ = _vala_iterable_ref0 (_tmp523_);
		_arg_list = _tmp524_;
		_tmp525_ = _arg_list;
		_tmp526_ = vala_collection_get_size ((ValaCollection*) _tmp525_);
		_tmp527_ = _tmp526_;
		_arg_size = _tmp527_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp528_;
			gint _tmp529_;
			ValaExpression* arg = NULL;
			ValaList* _tmp530_;
			gpointer _tmp531_;
			ValaExpression* _tmp532_;
			gboolean _tmp533_ = FALSE;
			ValaExpression* _tmp534_;
			_arg_index = _arg_index + 1;
			_tmp528_ = _arg_index;
			_tmp529_ = _arg_size;
			if (!(_tmp528_ < _tmp529_)) {
				break;
			}
			_tmp530_ = _arg_list;
			_tmp531_ = vala_list_get (_tmp530_, _arg_index);
			arg = (ValaExpression*) _tmp531_;
			_tmp532_ = arg;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp532_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp534_ = arg;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp534_)) {
				ValaExpression* _tmp535_;
				ValaMethod* _tmp536_;
				ValaMethod* _tmp537_;
				gboolean _tmp538_;
				gboolean _tmp539_;
				_tmp535_ = arg;
				_tmp536_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp535_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp537_ = _tmp536_;
				_tmp538_ = vala_method_get_closure (_tmp537_);
				_tmp539_ = _tmp538_;
				_tmp533_ = _tmp539_;
			} else {
				_tmp533_ = FALSE;
			}
			if (_tmp533_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp541_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp542_ = _tmp541_;
	if (!_tmp542_) {
		_tmp540_ = force_lambda_method_closure;
	} else {
		_tmp540_ = FALSE;
	}
	if (_tmp540_) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp543_;
			ValaList* _tmp544_;
			gint _arg_size = 0;
			ValaList* _tmp545_;
			gint _tmp546_;
			gint _tmp547_;
			gint _arg_index = 0;
			_tmp543_ = self->priv->argument_list;
			_tmp544_ = _vala_iterable_ref0 (_tmp543_);
			_arg_list = _tmp544_;
			_tmp545_ = _arg_list;
			_tmp546_ = vala_collection_get_size ((ValaCollection*) _tmp545_);
			_tmp547_ = _tmp546_;
			_arg_size = _tmp547_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp548_;
				gint _tmp549_;
				ValaExpression* arg = NULL;
				ValaList* _tmp550_;
				gpointer _tmp551_;
				ValaLambdaExpression* lambda = NULL;
				ValaExpression* _tmp552_;
				gboolean _tmp553_ = FALSE;
				ValaLambdaExpression* _tmp554_;
				_arg_index = _arg_index + 1;
				_tmp548_ = _arg_index;
				_tmp549_ = _arg_size;
				if (!(_tmp548_ < _tmp549_)) {
					break;
				}
				_tmp550_ = _arg_list;
				_tmp551_ = vala_list_get (_tmp550_, _arg_index);
				arg = (ValaExpression*) _tmp551_;
				_tmp552_ = arg;
				lambda = VALA_IS_LAMBDA_EXPRESSION (_tmp552_) ? ((ValaLambdaExpression*) _tmp552_) : NULL;
				_tmp554_ = lambda;
				if (_tmp554_ != NULL) {
					ValaLambdaExpression* _tmp555_;
					ValaMethod* _tmp556_;
					ValaMethod* _tmp557_;
					ValaMemberBinding _tmp558_;
					ValaMemberBinding _tmp559_;
					_tmp555_ = lambda;
					_tmp556_ = vala_lambda_expression_get_method (_tmp555_);
					_tmp557_ = _tmp556_;
					_tmp558_ = vala_method_get_binding (_tmp557_);
					_tmp559_ = _tmp558_;
					_tmp553_ = _tmp559_ != VALA_MEMBER_BINDING_STATIC;
				} else {
					_tmp553_ = FALSE;
				}
				if (_tmp553_) {
					ValaLambdaExpression* _tmp560_;
					ValaMethod* _tmp561_;
					ValaMethod* _tmp562_;
					_tmp560_ = lambda;
					_tmp561_ = vala_lambda_expression_get_method (_tmp560_);
					_tmp562_ = _tmp561_;
					vala_method_set_closure (_tmp562_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
	}
	_tmp563_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp563_)) {
		gboolean _tmp564_ = FALSE;
		gboolean _tmp565_ = FALSE;
		ValaCodeNode* _tmp566_;
		ValaCodeNode* _tmp567_;
		_tmp566_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp567_ = _tmp566_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp567_)) {
			ValaCodeNode* _tmp568_;
			ValaCodeNode* _tmp569_;
			_tmp568_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp569_ = _tmp568_;
			_tmp565_ = !VALA_IS_FOR_STATEMENT (_tmp569_);
		} else {
			_tmp565_ = FALSE;
		}
		if (_tmp565_) {
			ValaCodeNode* _tmp570_;
			ValaCodeNode* _tmp571_;
			_tmp570_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp571_ = _tmp570_;
			_tmp564_ = !VALA_IS_YIELD_STATEMENT (_tmp571_);
		} else {
			_tmp564_ = FALSE;
		}
		if (_tmp564_) {
			ValaSourceReference* _tmp572_;
			ValaSourceReference* _tmp573_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp572_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp573_ = _tmp572_;
			vala_report_error (_tmp573_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp574_ = ret_type;
	_tmp575_ = vala_data_type_copy (_tmp574_);
	_tmp576_ = _tmp575_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp576_);
	_vala_code_node_unref0 (_tmp576_);
	_tmp577_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp578_ = _tmp577_;
	_tmp579_ = target_object_type;
	_tmp580_ = method_type_args;
	_tmp581_ = vala_data_type_get_actual_type (_tmp578_, _tmp579_, _tmp580_, (ValaCodeNode*) self);
	_tmp582_ = _tmp581_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp582_);
	_vala_code_node_unref0 (_tmp582_);
	_tmp583_ = self->priv->_is_yield_expression;
	if (_tmp583_) {
		gboolean _tmp584_ = FALSE;
		ValaDataType* _tmp585_;
		gboolean _tmp593_ = FALSE;
		ValaSemanticAnalyzer* _tmp594_;
		ValaSemanticAnalyzer* _tmp595_;
		ValaMethod* _tmp596_;
		ValaMethod* _tmp597_;
		_tmp585_ = mtype;
		if (!VALA_IS_METHOD_TYPE (_tmp585_)) {
			_tmp584_ = TRUE;
		} else {
			ValaDataType* _tmp586_;
			ValaMethod* _tmp587_;
			ValaMethod* _tmp588_;
			gboolean _tmp589_;
			gboolean _tmp590_;
			_tmp586_ = mtype;
			_tmp587_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp586_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
			_tmp588_ = _tmp587_;
			_tmp589_ = vala_method_get_coroutine (_tmp588_);
			_tmp590_ = _tmp589_;
			_tmp584_ = !_tmp590_;
		}
		if (_tmp584_) {
			ValaSourceReference* _tmp591_;
			ValaSourceReference* _tmp592_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp591_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp592_ = _tmp591_;
			vala_report_error (_tmp592_, "yield expression requires async method");
		}
		_tmp594_ = vala_code_context_get_analyzer (context);
		_tmp595_ = _tmp594_;
		_tmp596_ = vala_semantic_analyzer_get_current_method (_tmp595_);
		_tmp597_ = _tmp596_;
		if (_tmp597_ == NULL) {
			_tmp593_ = TRUE;
		} else {
			ValaSemanticAnalyzer* _tmp598_;
			ValaSemanticAnalyzer* _tmp599_;
			ValaMethod* _tmp600_;
			ValaMethod* _tmp601_;
			gboolean _tmp602_;
			gboolean _tmp603_;
			_tmp598_ = vala_code_context_get_analyzer (context);
			_tmp599_ = _tmp598_;
			_tmp600_ = vala_semantic_analyzer_get_current_method (_tmp599_);
			_tmp601_ = _tmp600_;
			_tmp602_ = vala_method_get_coroutine (_tmp601_);
			_tmp603_ = _tmp602_;
			_tmp593_ = !_tmp603_;
		}
		if (_tmp593_) {
			ValaSourceReference* _tmp604_;
			ValaSourceReference* _tmp605_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp604_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp605_ = _tmp604_;
			vala_report_error (_tmp605_, "yield expression not available outside async method");
		}
	}
	_tmp606_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp606_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp607_;
		ValaMethod* _tmp608_;
		ValaMethod* _tmp609_;
		ValaMethod* _tmp610_;
		gboolean _tmp611_;
		gboolean _tmp612_;
		ValaMethod* _tmp615_;
		gboolean _tmp616_;
		gboolean _tmp617_;
		gboolean _tmp645_ = FALSE;
		gboolean _tmp646_ = FALSE;
		gboolean _tmp647_ = FALSE;
		gboolean _tmp648_;
		gboolean _tmp649_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp661_;
		ValaSymbol* _tmp662_;
		ValaSymbol* _tmp663_;
		gboolean _tmp664_ = FALSE;
		ValaSignal* _tmp665_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp678_;
		ValaSymbol* _tmp679_;
		ValaSymbol* _tmp680_;
		gboolean _tmp681_ = FALSE;
		ValaDynamicSignal* _tmp682_;
		gboolean _tmp733_ = FALSE;
		ValaMethod* _tmp734_;
		gboolean _tmp847_ = FALSE;
		ValaMethod* _tmp848_;
		_tmp607_ = mtype;
		_tmp608_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp607_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp609_ = _tmp608_;
		m = _tmp609_;
		_tmp610_ = m;
		_tmp611_ = vala_method_get_returns_floating_reference (_tmp610_);
		_tmp612_ = _tmp611_;
		if (_tmp612_) {
			ValaDataType* _tmp613_;
			ValaDataType* _tmp614_;
			_tmp613_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp614_ = _tmp613_;
			vala_data_type_set_floating_reference (_tmp614_, TRUE);
		}
		_tmp615_ = m;
		_tmp616_ = vala_method_get_returns_modified_pointer (_tmp615_);
		_tmp617_ = _tmp616_;
		if (_tmp617_) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp618_;
			ValaExpression* _tmp619_;
			ValaExpression* _tmp620_;
			ValaExpression* _tmp621_;
			ValaExpression* _tmp622_;
			ValaProperty* prop = NULL;
			ValaExpression* _tmp623_;
			ValaSymbol* _tmp624_;
			ValaSymbol* _tmp625_;
			gboolean _tmp626_ = FALSE;
			ValaProperty* _tmp627_;
			_tmp618_ = vala_method_call_get_call (self);
			_tmp619_ = _tmp618_;
			_tmp620_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp619_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp621_ = _tmp620_;
			inner = _tmp621_;
			_tmp622_ = inner;
			vala_expression_set_lvalue (_tmp622_, TRUE);
			_tmp623_ = inner;
			_tmp624_ = vala_expression_get_symbol_reference (_tmp623_);
			_tmp625_ = _tmp624_;
			prop = VALA_IS_PROPERTY (_tmp625_) ? ((ValaProperty*) _tmp625_) : NULL;
			_tmp627_ = prop;
			if (_tmp627_ != NULL) {
				gboolean _tmp628_ = FALSE;
				ValaProperty* _tmp629_;
				ValaPropertyAccessor* _tmp630_;
				ValaPropertyAccessor* _tmp631_;
				_tmp629_ = prop;
				_tmp630_ = vala_property_get_set_accessor (_tmp629_);
				_tmp631_ = _tmp630_;
				if (_tmp631_ == NULL) {
					_tmp628_ = TRUE;
				} else {
					ValaProperty* _tmp632_;
					ValaPropertyAccessor* _tmp633_;
					ValaPropertyAccessor* _tmp634_;
					gboolean _tmp635_;
					gboolean _tmp636_;
					_tmp632_ = prop;
					_tmp633_ = vala_property_get_set_accessor (_tmp632_);
					_tmp634_ = _tmp633_;
					_tmp635_ = vala_property_accessor_get_writable (_tmp634_);
					_tmp636_ = _tmp635_;
					_tmp628_ = !_tmp636_;
				}
				_tmp626_ = _tmp628_;
			} else {
				_tmp626_ = FALSE;
			}
			if (_tmp626_) {
				ValaExpression* _tmp637_;
				ValaSourceReference* _tmp638_;
				ValaSourceReference* _tmp639_;
				ValaProperty* _tmp640_;
				gchar* _tmp641_;
				gchar* _tmp642_;
				gchar* _tmp643_;
				gchar* _tmp644_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp637_ = inner;
				_tmp638_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp637_);
				_tmp639_ = _tmp638_;
				_tmp640_ = prop;
				_tmp641_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp640_);
				_tmp642_ = _tmp641_;
				_tmp643_ = g_strdup_printf ("Property `%s' is read-only", _tmp642_);
				_tmp644_ = _tmp643_;
				vala_report_error (_tmp639_, _tmp644_);
				_g_free0 (_tmp644_);
				_g_free0 (_tmp642_);
			}
		}
		_tmp648_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp649_ = _tmp648_;
		if (_tmp649_) {
			ValaDataType* _tmp650_;
			ValaDataType* _tmp651_;
			gboolean _tmp652_;
			gboolean _tmp653_;
			_tmp650_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp651_ = _tmp650_;
			_tmp652_ = vala_data_type_get_nullable (_tmp651_);
			_tmp653_ = _tmp652_;
			_tmp647_ = !_tmp653_;
		} else {
			_tmp647_ = FALSE;
		}
		if (_tmp647_) {
			ValaDataType* _tmp654_;
			ValaDataType* _tmp655_;
			gboolean _tmp656_;
			gboolean _tmp657_;
			_tmp654_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp655_ = _tmp654_;
			_tmp656_ = vala_data_type_get_floating_reference (_tmp655_);
			_tmp657_ = _tmp656_;
			_tmp646_ = _tmp657_;
		} else {
			_tmp646_ = FALSE;
		}
		if (_tmp646_) {
			ValaDataType* _tmp658_;
			_tmp658_ = ret_type;
			_tmp645_ = VALA_IS_OBJECT_TYPE (_tmp658_);
		} else {
			_tmp645_ = FALSE;
		}
		if (_tmp645_) {
			ValaDataType* _tmp659_;
			ValaDataType* _tmp660_;
			_tmp659_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp660_ = _tmp659_;
			vala_data_type_set_nullable (_tmp660_, TRUE);
		}
		_tmp661_ = m;
		_tmp662_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp661_);
		_tmp663_ = _tmp662_;
		sig = VALA_IS_SIGNAL (_tmp663_) ? ((ValaSignal*) _tmp663_) : NULL;
		_tmp665_ = sig;
		if (_tmp665_ != NULL) {
			ValaMethod* _tmp666_;
			const gchar* _tmp667_;
			const gchar* _tmp668_;
			_tmp666_ = m;
			_tmp667_ = vala_symbol_get_name ((ValaSymbol*) _tmp666_);
			_tmp668_ = _tmp667_;
			_tmp664_ = g_strcmp0 (_tmp668_, "disconnect") == 0;
		} else {
			_tmp664_ = FALSE;
		}
		if (_tmp664_) {
			gboolean _tmp669_ = FALSE;
			ValaList* _tmp670_;
			gboolean _tmp671_;
			gboolean _tmp672_;
			_tmp670_ = self->priv->argument_list;
			_tmp671_ = vala_collection_get_is_empty ((ValaCollection*) _tmp670_);
			_tmp672_ = _tmp671_;
			if (!_tmp672_) {
				ValaList* _tmp673_;
				gpointer _tmp674_;
				ValaExpression* _tmp675_;
				_tmp673_ = self->priv->argument_list;
				_tmp674_ = vala_list_get (_tmp673_, 0);
				_tmp675_ = (ValaExpression*) _tmp674_;
				_tmp669_ = VALA_IS_LAMBDA_EXPRESSION (_tmp675_);
				_vala_code_node_unref0 (_tmp675_);
			} else {
				_tmp669_ = FALSE;
			}
			if (_tmp669_) {
				ValaSourceReference* _tmp676_;
				ValaSourceReference* _tmp677_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp676_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp677_ = _tmp676_;
				vala_report_error (_tmp677_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp678_ = m;
		_tmp679_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp678_);
		_tmp680_ = _tmp679_;
		dynamic_sig = VALA_IS_DYNAMIC_SIGNAL (_tmp680_) ? ((ValaDynamicSignal*) _tmp680_) : NULL;
		_tmp682_ = dynamic_sig;
		if (_tmp682_ != NULL) {
			ValaDynamicSignal* _tmp683_;
			ValaExpression* _tmp684_;
			ValaExpression* _tmp685_;
			_tmp683_ = dynamic_sig;
			_tmp684_ = vala_dynamic_signal_get_handler (_tmp683_);
			_tmp685_ = _tmp684_;
			_tmp681_ = _tmp685_ != NULL;
		} else {
			_tmp681_ = FALSE;
		}
		if (_tmp681_) {
			ValaDynamicSignal* _tmp686_;
			ValaDynamicSignal* _tmp687_;
			ValaExpression* _tmp688_;
			ValaExpression* _tmp689_;
			ValaDataType* _tmp690_;
			ValaDataType* _tmp691_;
			ValaDataType* _tmp692_;
			ValaDataType* _tmp693_;
			ValaDataType* _tmp694_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp713_;
			ValaExpression* _tmp714_;
			ValaExpression* _tmp715_;
			ValaDynamicSignal* _tmp716_;
			ValaDynamicSignal* _tmp717_;
			ValaSymbol* _tmp718_;
			ValaSymbol* _tmp719_;
			ValaObjectType* _tmp720_;
			ValaObjectType* _tmp721_;
			ValaDelegate* _tmp722_;
			ValaDelegate* _tmp723_;
			ValaDelegateType* _tmp724_;
			ValaDelegateType* _tmp725_;
			ValaDynamicSignal* _tmp726_;
			ValaExpression* _tmp727_;
			ValaExpression* _tmp728_;
			ValaDataType* _tmp729_;
			ValaDataType* _tmp730_;
			ValaSourceReference* _tmp731_;
			ValaSourceReference* _tmp732_;
			_tmp686_ = dynamic_sig;
			_tmp687_ = dynamic_sig;
			_tmp688_ = vala_dynamic_signal_get_handler (_tmp687_);
			_tmp689_ = _tmp688_;
			_tmp690_ = vala_expression_get_value_type (_tmp689_);
			_tmp691_ = _tmp690_;
			_tmp692_ = vala_data_type_get_return_type (_tmp691_);
			_tmp693_ = vala_data_type_copy (_tmp692_);
			_tmp694_ = _tmp693_;
			vala_callable_set_return_type ((ValaCallable*) _tmp686_, _tmp694_);
			_vala_code_node_unref0 (_tmp694_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp695_;
				ValaExpression* _tmp696_;
				ValaExpression* _tmp697_;
				ValaDataType* _tmp698_;
				ValaDataType* _tmp699_;
				ValaList* _tmp700_;
				ValaList* _tmp701_;
				gint _param_size = 0;
				ValaList* _tmp702_;
				gint _tmp703_;
				gint _tmp704_;
				gint _param_index = 0;
				_tmp695_ = dynamic_sig;
				_tmp696_ = vala_dynamic_signal_get_handler (_tmp695_);
				_tmp697_ = _tmp696_;
				_tmp698_ = vala_expression_get_value_type (_tmp697_);
				_tmp699_ = _tmp698_;
				_tmp700_ = vala_data_type_get_parameters (_tmp699_);
				_tmp701_ = _vala_iterable_ref0 (_tmp700_);
				_param_list = _tmp701_;
				_tmp702_ = _param_list;
				_tmp703_ = vala_collection_get_size ((ValaCollection*) _tmp702_);
				_tmp704_ = _tmp703_;
				_param_size = _tmp704_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp705_;
					gint _tmp706_;
					ValaParameter* param = NULL;
					ValaList* _tmp707_;
					gpointer _tmp708_;
					_param_index = _param_index + 1;
					_tmp705_ = _param_index;
					_tmp706_ = _param_size;
					if (!(_tmp705_ < _tmp706_)) {
						break;
					}
					_tmp707_ = _param_list;
					_tmp708_ = vala_list_get (_tmp707_, _param_index);
					param = (ValaParameter*) _tmp708_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp709_;
						ValaParameter* _tmp710_;
						ValaParameter* _tmp711_;
						ValaParameter* _tmp712_;
						_tmp709_ = dynamic_sig;
						_tmp710_ = param;
						_tmp711_ = vala_parameter_copy (_tmp710_);
						_tmp712_ = _tmp711_;
						vala_callable_add_parameter ((ValaCallable*) _tmp709_, _tmp712_);
						_vala_code_node_unref0 (_tmp712_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp713_ = dynamic_sig;
			_tmp714_ = vala_dynamic_signal_get_handler (_tmp713_);
			_tmp715_ = _tmp714_;
			_tmp716_ = dynamic_sig;
			_tmp717_ = dynamic_sig;
			_tmp718_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp717_);
			_tmp719_ = _tmp718_;
			_tmp720_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp719_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp721_ = _tmp720_;
			_tmp722_ = vala_signal_get_delegate ((ValaSignal*) _tmp716_, (ValaDataType*) _tmp721_, (ValaCodeNode*) self);
			_tmp723_ = _tmp722_;
			_tmp724_ = vala_delegate_type_new (_tmp723_);
			_tmp725_ = _tmp724_;
			vala_expression_set_target_type (_tmp715_, (ValaDataType*) _tmp725_);
			_vala_code_node_unref0 (_tmp725_);
			_vala_code_node_unref0 (_tmp723_);
			_vala_code_node_unref0 (_tmp721_);
			_tmp726_ = dynamic_sig;
			_tmp727_ = vala_dynamic_signal_get_handler (_tmp726_);
			_tmp728_ = _tmp727_;
			_tmp729_ = vala_expression_get_target_type (_tmp728_);
			_tmp730_ = _tmp729_;
			_tmp731_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp732_ = _tmp731_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp730_, _tmp732_);
		}
		_tmp734_ = m;
		if (_tmp734_ != NULL) {
			ValaMethod* _tmp735_;
			_tmp735_ = m;
			_tmp733_ = vala_method_has_type_parameters (_tmp735_);
		} else {
			_tmp733_ = FALSE;
		}
		if (_tmp733_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp736_;
			ValaExpression* _tmp737_;
			ValaMemberAccess* _tmp738_;
			ValaList* _tmp739_;
			gint _tmp740_;
			gint _tmp741_;
			_tmp736_ = vala_method_call_get_call (self);
			_tmp737_ = _tmp736_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp737_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp738_ = ma;
			_tmp739_ = vala_member_access_get_type_arguments (_tmp738_);
			_tmp740_ = vala_collection_get_size ((ValaCollection*) _tmp739_);
			_tmp741_ = _tmp740_;
			if (_tmp741_ == 0) {
				ValaList* _tmp812_;
				ValaIterator* _tmp813_;
				ValaDataType* _tmp841_;
				ValaDataType* _tmp842_;
				ValaDataType* _tmp843_;
				ValaList* _tmp844_;
				ValaDataType* _tmp845_;
				ValaDataType* _tmp846_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp742_;
					ValaList* _tmp743_;
					ValaList* _tmp744_;
					gint _type_param_size = 0;
					ValaList* _tmp745_;
					gint _tmp746_;
					gint _tmp747_;
					gint _type_param_index = 0;
					_tmp742_ = m;
					_tmp743_ = vala_method_get_type_parameters (_tmp742_);
					_tmp744_ = _vala_iterable_ref0 (_tmp743_);
					_type_param_list = _tmp744_;
					_tmp745_ = _type_param_list;
					_tmp746_ = vala_collection_get_size ((ValaCollection*) _tmp745_);
					_tmp747_ = _tmp746_;
					_type_param_size = _tmp747_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp748_;
						gint _tmp749_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp750_;
						gpointer _tmp751_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp752_;
						ValaIterator* _tmp753_;
						gboolean _tmp790_ = FALSE;
						ValaDataType* _tmp791_;
						ValaDataType* _tmp801_;
						ValaMemberAccess* _tmp810_;
						ValaDataType* _tmp811_;
						_type_param_index = _type_param_index + 1;
						_tmp748_ = _type_param_index;
						_tmp749_ = _type_param_size;
						if (!(_tmp748_ < _tmp749_)) {
							break;
						}
						_tmp750_ = _type_param_list;
						_tmp751_ = vala_list_get (_tmp750_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp751_;
						type_arg = NULL;
						_tmp752_ = self->priv->argument_list;
						_tmp753_ = vala_iterable_iterator ((ValaIterable*) _tmp752_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp753_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp754_;
							ValaList* _tmp755_;
							gint _param_size = 0;
							ValaList* _tmp756_;
							gint _tmp757_;
							gint _tmp758_;
							gint _param_index = 0;
							_tmp754_ = params;
							_tmp755_ = _vala_iterable_ref0 (_tmp754_);
							_param_list = _tmp755_;
							_tmp756_ = _param_list;
							_tmp757_ = vala_collection_get_size ((ValaCollection*) _tmp756_);
							_tmp758_ = _tmp757_;
							_param_size = _tmp758_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp759_;
								gint _tmp760_;
								ValaParameter* param = NULL;
								ValaList* _tmp761_;
								gpointer _tmp762_;
								gboolean _tmp763_ = FALSE;
								ValaParameter* _tmp764_;
								gboolean _tmp765_;
								gboolean _tmp766_;
								ValaIterator* _tmp770_;
								_param_index = _param_index + 1;
								_tmp759_ = _param_index;
								_tmp760_ = _param_size;
								if (!(_tmp759_ < _tmp760_)) {
									break;
								}
								_tmp761_ = _param_list;
								_tmp762_ = vala_list_get (_tmp761_, _param_index);
								param = (ValaParameter*) _tmp762_;
								_tmp764_ = param;
								_tmp765_ = vala_parameter_get_ellipsis (_tmp764_);
								_tmp766_ = _tmp765_;
								if (_tmp766_) {
									_tmp763_ = TRUE;
								} else {
									ValaParameter* _tmp767_;
									gboolean _tmp768_;
									gboolean _tmp769_;
									_tmp767_ = param;
									_tmp768_ = vala_parameter_get_params_array (_tmp767_);
									_tmp769_ = _tmp768_;
									_tmp763_ = _tmp769_;
								}
								if (_tmp763_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp770_ = arg_it;
								if (vala_iterator_next (_tmp770_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp771_;
									gpointer _tmp772_;
									ValaParameter* _tmp773_;
									ValaDataType* _tmp774_;
									ValaDataType* _tmp775_;
									ValaTypeParameter* _tmp776_;
									ValaExpression* _tmp777_;
									ValaDataType* _tmp778_;
									ValaDataType* _tmp779_;
									ValaDataType* _tmp780_;
									ValaDataType* _tmp781_;
									ValaExpression* _tmp782_;
									ValaExpression* _tmp783_;
									ValaDataType* _tmp784_;
									ValaDataType* _tmp785_;
									ValaDataType* _tmp786_;
									ValaList* _tmp787_;
									ValaDataType* _tmp788_;
									ValaDataType* _tmp789_;
									_tmp771_ = arg_it;
									_tmp772_ = vala_iterator_get (_tmp771_);
									arg = (ValaExpression*) _tmp772_;
									_tmp773_ = param;
									_tmp774_ = vala_variable_get_variable_type ((ValaVariable*) _tmp773_);
									_tmp775_ = _tmp774_;
									_tmp776_ = type_param;
									_tmp777_ = arg;
									_tmp778_ = vala_expression_get_value_type (_tmp777_);
									_tmp779_ = _tmp778_;
									_tmp780_ = vala_data_type_infer_type_argument (_tmp775_, _tmp776_, _tmp779_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp780_;
									_tmp781_ = type_arg;
									if (_tmp781_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp782_ = arg;
									_tmp783_ = arg;
									_tmp784_ = vala_expression_get_formal_target_type (_tmp783_);
									_tmp785_ = _tmp784_;
									_tmp786_ = target_object_type;
									_tmp787_ = method_type_args;
									_tmp788_ = vala_data_type_get_actual_type (_tmp785_, _tmp786_, _tmp787_, (ValaCodeNode*) self);
									_tmp789_ = _tmp788_;
									vala_expression_set_target_type (_tmp782_, _tmp789_);
									_vala_code_node_unref0 (_tmp789_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp791_ = type_arg;
						if (_tmp791_ == NULL) {
							ValaDataType* _tmp792_;
							ValaDataType* _tmp793_;
							_tmp792_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp793_ = _tmp792_;
							_tmp790_ = _tmp793_ != NULL;
						} else {
							_tmp790_ = FALSE;
						}
						if (_tmp790_) {
							ValaMethod* _tmp794_;
							ValaDataType* _tmp795_;
							ValaDataType* _tmp796_;
							ValaTypeParameter* _tmp797_;
							ValaDataType* _tmp798_;
							ValaDataType* _tmp799_;
							ValaDataType* _tmp800_;
							_tmp794_ = m;
							_tmp795_ = vala_callable_get_return_type ((ValaCallable*) _tmp794_);
							_tmp796_ = _tmp795_;
							_tmp797_ = type_param;
							_tmp798_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp799_ = _tmp798_;
							_tmp800_ = vala_data_type_infer_type_argument (_tmp796_, _tmp797_, _tmp799_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp800_;
						}
						_tmp801_ = type_arg;
						if (_tmp801_ == NULL) {
							ValaMemberAccess* _tmp802_;
							ValaSourceReference* _tmp803_;
							ValaSourceReference* _tmp804_;
							ValaTypeParameter* _tmp805_;
							gchar* _tmp806_;
							gchar* _tmp807_;
							gchar* _tmp808_;
							gchar* _tmp809_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp802_ = ma;
							_tmp803_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp802_);
							_tmp804_ = _tmp803_;
							_tmp805_ = type_param;
							_tmp806_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp805_);
							_tmp807_ = _tmp806_;
							_tmp808_ = g_strdup_printf ("cannot infer generic type argument for type parameter `%s'", _tmp807_);
							_tmp809_ = _tmp808_;
							vala_report_error (_tmp804_, _tmp809_);
							_g_free0 (_tmp809_);
							_g_free0 (_tmp807_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterable_unref0 (_type_param_list);
							_vala_iterator_unref0 (arg_it);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp810_ = ma;
						_tmp811_ = type_arg;
						vala_member_access_add_type_argument (_tmp810_, _tmp811_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_tmp812_ = self->priv->argument_list;
				_tmp813_ = vala_iterable_iterator ((ValaIterable*) _tmp812_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp813_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp814_;
					ValaList* _tmp815_;
					gint _param_size = 0;
					ValaList* _tmp816_;
					gint _tmp817_;
					gint _tmp818_;
					gint _param_index = 0;
					_tmp814_ = params;
					_tmp815_ = _vala_iterable_ref0 (_tmp814_);
					_param_list = _tmp815_;
					_tmp816_ = _param_list;
					_tmp817_ = vala_collection_get_size ((ValaCollection*) _tmp816_);
					_tmp818_ = _tmp817_;
					_param_size = _tmp818_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp819_;
						gint _tmp820_;
						ValaParameter* param = NULL;
						ValaList* _tmp821_;
						gpointer _tmp822_;
						gboolean _tmp823_ = FALSE;
						ValaParameter* _tmp824_;
						gboolean _tmp825_;
						gboolean _tmp826_;
						ValaIterator* _tmp830_;
						_param_index = _param_index + 1;
						_tmp819_ = _param_index;
						_tmp820_ = _param_size;
						if (!(_tmp819_ < _tmp820_)) {
							break;
						}
						_tmp821_ = _param_list;
						_tmp822_ = vala_list_get (_tmp821_, _param_index);
						param = (ValaParameter*) _tmp822_;
						_tmp824_ = param;
						_tmp825_ = vala_parameter_get_ellipsis (_tmp824_);
						_tmp826_ = _tmp825_;
						if (_tmp826_) {
							_tmp823_ = TRUE;
						} else {
							ValaParameter* _tmp827_;
							gboolean _tmp828_;
							gboolean _tmp829_;
							_tmp827_ = param;
							_tmp828_ = vala_parameter_get_params_array (_tmp827_);
							_tmp829_ = _tmp828_;
							_tmp823_ = _tmp829_;
						}
						if (_tmp823_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp830_ = arg_it;
						if (vala_iterator_next (_tmp830_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp831_;
							gpointer _tmp832_;
							ValaExpression* _tmp833_;
							ValaExpression* _tmp834_;
							ValaDataType* _tmp835_;
							ValaDataType* _tmp836_;
							ValaDataType* _tmp837_;
							ValaList* _tmp838_;
							ValaDataType* _tmp839_;
							ValaDataType* _tmp840_;
							_tmp831_ = arg_it;
							_tmp832_ = vala_iterator_get (_tmp831_);
							arg = (ValaExpression*) _tmp832_;
							_tmp833_ = arg;
							_tmp834_ = arg;
							_tmp835_ = vala_expression_get_formal_target_type (_tmp834_);
							_tmp836_ = _tmp835_;
							_tmp837_ = target_object_type;
							_tmp838_ = method_type_args;
							_tmp839_ = vala_data_type_get_actual_type (_tmp836_, _tmp837_, _tmp838_, (ValaCodeNode*) self);
							_tmp840_ = _tmp839_;
							vala_expression_set_target_type (_tmp833_, _tmp840_);
							_vala_code_node_unref0 (_tmp840_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
					_vala_iterable_unref0 (_param_list);
				}
				_tmp841_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp842_ = _tmp841_;
				_tmp843_ = target_object_type;
				_tmp844_ = method_type_args;
				_tmp845_ = vala_data_type_get_actual_type (_tmp842_, _tmp843_, _tmp844_, (ValaCodeNode*) self);
				_tmp846_ = _tmp845_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp846_);
				_vala_code_node_unref0 (_tmp846_);
			}
		}
		_tmp848_ = m;
		if (_tmp848_ != NULL) {
			ValaMethod* _tmp849_;
			gboolean _tmp850_;
			gboolean _tmp851_;
			_tmp849_ = m;
			_tmp850_ = vala_method_get_coroutine (_tmp849_);
			_tmp851_ = _tmp850_;
			_tmp847_ = _tmp851_;
		} else {
			_tmp847_ = FALSE;
		}
		if (_tmp847_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp852_;
			ValaExpression* _tmp853_;
			ValaMemberAccess* _tmp854_;
			const gchar* _tmp855_;
			const gchar* _tmp856_;
			_tmp852_ = vala_method_call_get_call (self);
			_tmp853_ = _tmp852_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp853_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp854_ = ma;
			_tmp855_ = vala_member_access_get_member_name (_tmp854_);
			_tmp856_ = _tmp855_;
			if (g_strcmp0 (_tmp856_, "end") == 0) {
				ValaMethod* _tmp857_;
				ValaMethod* _tmp858_;
				ValaMethodType* _tmp859_;
				ValaDataType* _tmp860_;
				ValaSourceReference* _tmp861_;
				ValaSourceReference* _tmp862_;
				_tmp857_ = m;
				_tmp858_ = vala_method_get_end_method (_tmp857_);
				_tmp859_ = vala_method_type_new (_tmp858_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp859_;
				_tmp860_ = mtype;
				_tmp861_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp862_ = _tmp861_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp860_, _tmp862_);
			}
		}
	}
	_tmp863_ = vala_code_context_get_analyzer (context);
	_tmp864_ = _tmp863_;
	_tmp865_ = mtype;
	_tmp866_ = params;
	_tmp867_ = self->priv->argument_list;
	if (!vala_semantic_analyzer_check_arguments (_tmp864_, (ValaExpression*) self, _tmp865_, _tmp866_, _tmp867_)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp868_;
		ValaList* _tmp869_;
		gint _arg_size = 0;
		ValaList* _tmp870_;
		gint _tmp871_;
		gint _tmp872_;
		gint _arg_index = 0;
		_tmp868_ = self->priv->argument_list;
		_tmp869_ = _vala_iterable_ref0 (_tmp868_);
		_arg_list = _tmp869_;
		_tmp870_ = _arg_list;
		_tmp871_ = vala_collection_get_size ((ValaCollection*) _tmp870_);
		_tmp872_ = _tmp871_;
		_arg_size = _tmp872_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp873_;
			gint _tmp874_;
			ValaExpression* arg = NULL;
			ValaList* _tmp875_;
			gpointer _tmp876_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp877_;
			gboolean _tmp878_ = FALSE;
			ValaSizeofExpression* _tmp879_;
			_arg_index = _arg_index + 1;
			_tmp873_ = _arg_index;
			_tmp874_ = _arg_size;
			if (!(_tmp873_ < _tmp874_)) {
				break;
			}
			_tmp875_ = _arg_list;
			_tmp876_ = vala_list_get (_tmp875_, _arg_index);
			arg = (ValaExpression*) _tmp876_;
			_tmp877_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp877_) ? ((ValaSizeofExpression*) _tmp877_) : NULL;
			_tmp879_ = sizeof_expr;
			if (_tmp879_ != NULL) {
				ValaSizeofExpression* _tmp880_;
				ValaDataType* _tmp881_;
				ValaDataType* _tmp882_;
				_tmp880_ = sizeof_expr;
				_tmp881_ = vala_sizeof_expression_get_type_reference (_tmp880_);
				_tmp882_ = _tmp881_;
				_tmp878_ = VALA_IS_GENERIC_TYPE (_tmp882_);
			} else {
				_tmp878_ = FALSE;
			}
			if (_tmp878_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp883_;
				ValaDataType* _tmp884_;
				ValaDataType* _tmp885_;
				ValaDataType* _tmp886_;
				ValaList* _tmp887_;
				ValaDataType* _tmp888_;
				ValaExpression* _tmp889_;
				ValaDataType* _tmp890_;
				ValaSourceReference* _tmp891_;
				ValaSourceReference* _tmp892_;
				ValaSizeofExpression* _tmp893_;
				ValaSizeofExpression* _tmp894_;
				_tmp883_ = sizeof_expr;
				_tmp884_ = vala_sizeof_expression_get_type_reference (_tmp883_);
				_tmp885_ = _tmp884_;
				_tmp886_ = target_object_type;
				_tmp887_ = method_type_args;
				_tmp888_ = vala_data_type_get_actual_type (_tmp885_, _tmp886_, _tmp887_, (ValaCodeNode*) self);
				sizeof_type = _tmp888_;
				_tmp889_ = arg;
				_tmp890_ = sizeof_type;
				_tmp891_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp892_ = _tmp891_;
				_tmp893_ = vala_sizeof_expression_new (_tmp890_, _tmp892_);
				_tmp894_ = _tmp893_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp889_, (ValaExpression*) _tmp894_);
				_vala_code_node_unref0 (_tmp894_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp897_ = base_cm;
	if (_tmp897_ != NULL) {
		ValaCreationMethod* _tmp898_;
		_tmp898_ = base_cm;
		_tmp896_ = vala_method_is_variadic ((ValaMethod*) _tmp898_);
	} else {
		_tmp896_ = FALSE;
	}
	if (_tmp896_) {
		ValaList* _tmp899_;
		gint _tmp900_;
		gint _tmp901_;
		ValaCreationMethod* _tmp902_;
		ValaList* _tmp903_;
		gint _tmp904_;
		gint _tmp905_;
		_tmp899_ = self->priv->argument_list;
		_tmp900_ = vala_collection_get_size ((ValaCollection*) _tmp899_);
		_tmp901_ = _tmp900_;
		_tmp902_ = base_cm;
		_tmp903_ = vala_callable_get_parameters ((ValaCallable*) _tmp902_);
		_tmp904_ = vala_collection_get_size ((ValaCollection*) _tmp903_);
		_tmp905_ = _tmp904_;
		_tmp895_ = _tmp901_ == _tmp905_;
	} else {
		_tmp895_ = FALSE;
	}
	if (_tmp895_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp906_;
		ValaList* _tmp907_;
		gint _tmp908_;
		gint _tmp909_;
		gpointer _tmp910_;
		gboolean _tmp911_ = FALSE;
		ValaExpression* _tmp912_;
		ValaDataType* _tmp913_;
		ValaDataType* _tmp914_;
		_tmp906_ = self->priv->argument_list;
		_tmp907_ = self->priv->argument_list;
		_tmp908_ = vala_collection_get_size ((ValaCollection*) _tmp907_);
		_tmp909_ = _tmp908_;
		_tmp910_ = vala_list_get (_tmp906_, _tmp909_ - 1);
		this_last_arg = (ValaExpression*) _tmp910_;
		_tmp912_ = this_last_arg;
		_tmp913_ = vala_expression_get_value_type (_tmp912_);
		_tmp914_ = _tmp913_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp914_)) {
			ValaExpression* _tmp915_;
			ValaDataType* _tmp916_;
			ValaDataType* _tmp917_;
			ValaTypeSymbol* _tmp918_;
			ValaTypeSymbol* _tmp919_;
			ValaSemanticAnalyzer* _tmp920_;
			ValaSemanticAnalyzer* _tmp921_;
			ValaDataType* _tmp922_;
			ValaTypeSymbol* _tmp923_;
			ValaTypeSymbol* _tmp924_;
			_tmp915_ = this_last_arg;
			_tmp916_ = vala_expression_get_value_type (_tmp915_);
			_tmp917_ = _tmp916_;
			_tmp918_ = vala_data_type_get_type_symbol (_tmp917_);
			_tmp919_ = _tmp918_;
			_tmp920_ = vala_code_context_get_analyzer (context);
			_tmp921_ = _tmp920_;
			_tmp922_ = _tmp921_->va_list_type;
			_tmp923_ = vala_data_type_get_type_symbol (_tmp922_);
			_tmp924_ = _tmp923_;
			_tmp911_ = _tmp919_ == _tmp924_;
		} else {
			_tmp911_ = FALSE;
		}
		if (_tmp911_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp925_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp926_ = _tmp925_;
	vala_code_node_check ((ValaCodeNode*) _tmp926_, context);
	_tmp927_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp928_ = _tmp927_;
	if (_tmp928_) {
		gboolean _tmp929_ = FALSE;
		ValaCodeNode* _tmp930_;
		ValaCodeNode* _tmp931_;
		_tmp930_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp931_ = _tmp930_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp931_)) {
			_tmp929_ = TRUE;
		} else {
			ValaCodeNode* _tmp932_;
			ValaCodeNode* _tmp933_;
			_tmp932_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp933_ = _tmp932_;
			_tmp929_ = VALA_IS_EXPRESSION_STATEMENT (_tmp933_);
		}
		if (_tmp929_) {
		} else {
			ValaSemanticAnalyzer* _tmp934_;
			ValaSemanticAnalyzer* _tmp935_;
			ValaSymbol* _tmp936_;
			ValaSymbol* _tmp937_;
			_tmp934_ = vala_code_context_get_analyzer (context);
			_tmp935_ = _tmp934_;
			_tmp936_ = vala_semantic_analyzer_get_current_symbol (_tmp935_);
			_tmp937_ = _tmp936_;
			if (!VALA_IS_BLOCK (_tmp937_)) {
				ValaSourceReference* _tmp938_;
				ValaSourceReference* _tmp939_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp938_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp939_ = _tmp938_;
				vala_report_error (_tmp939_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp940_;
				ValaCodeNode* _tmp941_;
				ValaCodeNode* _tmp942_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp943_;
				ValaDataType* _tmp944_;
				ValaDataType* _tmp945_;
				ValaDataType* _tmp946_;
				gchar* _tmp947_;
				gchar* _tmp948_;
				ValaSourceReference* _tmp949_;
				ValaSourceReference* _tmp950_;
				ValaLocalVariable* _tmp951_;
				ValaLocalVariable* _tmp952_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp953_;
				ValaSourceReference* _tmp954_;
				ValaSourceReference* _tmp955_;
				ValaDeclarationStatement* _tmp956_;
				ValaDataType* _tmp957_;
				ValaDataType* _tmp958_;
				ValaSemanticAnalyzer* _tmp962_;
				ValaSemanticAnalyzer* _tmp963_;
				ValaBlock* _tmp964_;
				ValaDeclarationStatement* _tmp965_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp966_;
				ValaDataType* _tmp967_;
				ValaDataType* _tmp968_;
				ValaExpression* _tmp969_;
				ValaExpression* _tmp970_;
				ValaDataType* _tmp971_;
				ValaDataType* _tmp972_;
				ValaLocalVariable* _tmp973_;
				ValaDeclarationStatement* _tmp974_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp975_;
				ValaSemanticAnalyzer* _tmp976_;
				ValaSymbol* _tmp977_;
				ValaSymbol* _tmp978_;
				ValaBlock* _tmp979_;
				ValaBlock* _tmp980_;
				ValaLocalVariable* _tmp981_;
				ValaSemanticAnalyzer* _tmp982_;
				ValaSemanticAnalyzer* _tmp983_;
				ValaBlock* _tmp984_;
				ValaLocalVariable* _tmp985_;
				ValaCodeNode* _tmp986_;
				ValaExpression* _tmp987_;
				ValaExpression* _tmp988_;
				_tmp940_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp941_ = _tmp940_;
				_tmp942_ = _vala_code_node_ref0 (_tmp941_);
				old_parent_node = _tmp942_;
				_tmp943_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp944_ = _tmp943_;
				_tmp945_ = vala_data_type_copy (_tmp944_);
				_tmp946_ = _tmp945_;
				_tmp947_ = vala_code_node_get_temp_name ();
				_tmp948_ = _tmp947_;
				_tmp949_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp950_ = _tmp949_;
				_tmp951_ = vala_local_variable_new (_tmp946_, _tmp948_, NULL, _tmp950_);
				_tmp952_ = _tmp951_;
				_g_free0 (_tmp948_);
				_vala_code_node_unref0 (_tmp946_);
				local = _tmp952_;
				_tmp953_ = local;
				_tmp954_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp955_ = _tmp954_;
				_tmp956_ = vala_declaration_statement_new ((ValaSymbol*) _tmp953_, _tmp955_);
				decl = _tmp956_;
				_tmp957_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp958_ = _tmp957_;
				if (_tmp958_ == NULL) {
					ValaLocalVariable* _tmp959_;
					ValaDataType* _tmp960_;
					ValaDataType* _tmp961_;
					_tmp959_ = local;
					_tmp960_ = vala_variable_get_variable_type ((ValaVariable*) _tmp959_);
					_tmp961_ = _tmp960_;
					vala_data_type_set_floating_reference (_tmp961_, FALSE);
				}
				_tmp962_ = vala_code_context_get_analyzer (context);
				_tmp963_ = _tmp962_;
				_tmp964_ = _tmp963_->insert_block;
				_tmp965_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp964_, (ValaStatement*) _tmp965_);
				_tmp966_ = local;
				_tmp967_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp968_ = _tmp967_;
				_tmp969_ = vala_semantic_analyzer_create_temp_access (_tmp966_, _tmp968_);
				temp_access = _tmp969_;
				_tmp970_ = temp_access;
				_tmp971_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp972_ = _tmp971_;
				vala_expression_set_formal_target_type (_tmp970_, _tmp972_);
				_tmp973_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp973_, (ValaExpression*) self);
				_tmp974_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp974_, context);
				_tmp975_ = vala_code_context_get_analyzer (context);
				_tmp976_ = _tmp975_;
				_tmp977_ = vala_semantic_analyzer_get_current_symbol (_tmp976_);
				_tmp978_ = _tmp977_;
				_tmp979_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp978_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp979_;
				_tmp980_ = block;
				_tmp981_ = local;
				vala_block_remove_local_variable (_tmp980_, _tmp981_);
				_tmp982_ = vala_code_context_get_analyzer (context);
				_tmp983_ = _tmp982_;
				_tmp984_ = _tmp983_->insert_block;
				_tmp985_ = local;
				vala_block_add_local_variable (_tmp984_, _tmp985_);
				_tmp986_ = old_parent_node;
				_tmp987_ = temp_access;
				vala_code_node_replace_expression (_tmp986_, (ValaExpression*) self, _tmp987_);
				_tmp988_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp988_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp989_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp990_ = _tmp989_;
	result = !_tmp990_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_SIGNAL (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		_tmp11_ = vala_method_call_get_call (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp14_ = _tmp13_;
		vala_code_node_emit ((ValaCodeNode*) _tmp14_, codegen);
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		vala_code_node_emit ((ValaCodeNode*) _tmp16_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _expr_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _expr_index = 0;
		_tmp17_ = self->priv->argument_list;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_expr_list = _tmp18_;
		_tmp19_ = _expr_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_expr_size = _tmp21_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			ValaExpression* expr = NULL;
			ValaList* _tmp24_;
			gpointer _tmp25_;
			ValaExpression* _tmp26_;
			_expr_index = _expr_index + 1;
			_tmp22_ = _expr_index;
			_tmp23_ = _expr_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _expr_list;
			_tmp25_ = vala_list_get (_tmp24_, _expr_index);
			expr = (ValaExpression*) _tmp25_;
			_tmp26_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp26_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaExpression* arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_arg_index = _arg_index + 1;
			_tmp7_ = _arg_index;
			_tmp8_ = _arg_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _arg_index);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaExpression* arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_arg_index = _arg_index + 1;
			_tmp7_ = _arg_index;
			_tmp8_ = _arg_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _arg_index);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaStringLiteral* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	mtype = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = mtype;
	if (_tmp4_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = mtype;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		format_arg = vala_method_get_format_arg_index (_tmp7_);
		if (format_arg >= 0) {
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->argument_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp8_ = format_arg < _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaStringLiteral* _tmp15_;
			ValaStringLiteral* _tmp16_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, format_arg);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_string_literal_get_format_literal (_tmp14_);
			_tmp16_ = _tmp15_;
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp16_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	GString* b = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp24_;
	GString* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = b;
	g_string_append_c (_tmp1_, '(');
	_tmp2_ = self->priv->_is_yield_expression;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _expr_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_expr_list = _tmp11_;
		_tmp12_ = _expr_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_expr_size = _tmp14_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaExpression* expr = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			GString* _tmp20_;
			ValaExpression* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_expr_index = _expr_index + 1;
			_tmp15_ = _expr_index;
			_tmp16_ = _expr_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _expr_list;
			_tmp18_ = vala_list_get (_tmp17_, _expr_index);
			expr = (ValaExpression*) _tmp18_;
			if (!first) {
				GString* _tmp19_;
				_tmp19_ = b;
				g_string_append (_tmp19_, ", ");
			}
			_tmp20_ = b;
			_tmp21_ = expr;
			_tmp22_ = vala_code_node_to_string ((ValaCodeNode*) _tmp21_);
			_tmp23_ = _tmp22_;
			g_string_append (_tmp20_, _tmp23_);
			_g_free0 (_tmp23_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp24_ = b;
	g_string_append (_tmp24_, "))");
	_tmp25_ = b;
	_tmp26_ = _tmp25_->str;
	_tmp27_ = g_strdup (_tmp26_);
	result = _tmp27_;
	_g_string_free0 (b);
	return result;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
static GType
vala_method_call_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
	GType vala_method_call_type_id;
	vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
	ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
	return vala_method_call_type_id;
}

GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		GType vala_method_call_type_id;
		vala_method_call_type_id = vala_method_call_get_type_once ();
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}

