/* valamethod.c generated by valac, the Vala compiler
 * generated from valamethod.vala, do not modify */

/* valamethod.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaMethodPrivate {
	ValaList* type_parameters;
	ValaMemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _entry_point;
	ValaParameter* _this_parameter;
	ValaLocalVariable* _params_array_var;
	ValaSignal* _signal_reference;
	gboolean _closure;
	gboolean _coroutine;
	gboolean _is_async_callback;
	ValaList* parameters;
	ValaList* preconditions;
	ValaList* postconditions;
	ValaDataType* _return_type;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	ValaDataType* _base_interface_type;
	gboolean base_methods_valid;
	ValaMethod* callback_method;
	ValaMethod* end_method;
	ValaList* captured_variables;
};

static gint ValaMethod_private_offset;
static gpointer vala_method_parent_class = NULL;
static ValaList* vala_method__empty_expression_list;
static ValaList* vala_method__empty_expression_list = NULL;
static ValaList* vala_method__empty_type_parameter_list;
static ValaList* vala_method__empty_type_parameter_list = NULL;
static ValaCallableIface * vala_method_vala_callable_parent_iface = NULL;

static void vala_method_find_base_methods (ValaMethod* self);
static void vala_method_set_entry_point (ValaMethod* self,
                                  gboolean value);
static void vala_method_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_method_real_get_parameters (ValaCallable* base);
static void vala_method_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_method_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gboolean vala_method_compatible_internal (ValaMethod* self,
                                          ValaMethod* base_method,
                                          gchar** invalid_match,
                                          ValaCodeNode* node_reference);
static void vala_method_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference);
static void vala_method_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node);
static void vala_method_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static void vala_method_find_base_interface_method (ValaMethod* self,
                                             ValaClass* cl);
static void vala_method_find_base_class_method (ValaMethod* self,
                                         ValaClass* cl);
static gboolean vala_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self,
                                              ValaCodeContext* context);
static void vala_method_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection);
static void vala_method_finalize (ValaCodeNode * obj);
static GType vala_method_get_type_once (void);

static inline gpointer
vala_method_get_instance_private (ValaMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethod_private_offset);
}

static ValaDataType*
vala_method_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	result = !VALA_IS_VOID_TYPE (_tmp1_);
	return result;
}

ValaMemberBinding
vala_method_get_binding (ValaMethod* self)
{
	ValaMemberBinding result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_binding;
	return result;
}

void
vala_method_set_binding (ValaMethod* self,
                         ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_method_get_is_abstract (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_method_set_is_abstract (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_method_get_is_virtual (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_method_set_is_virtual (ValaMethod* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

gboolean
vala_method_get_overrides (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}

void
vala_method_set_overrides (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}

gboolean
vala_method_get_is_inline (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_inline;
	return result;
}

void
vala_method_set_is_inline (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}

gboolean
vala_method_get_returns_floating_reference (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", FALSE);
	return result;
}

void
vala_method_set_returns_floating_reference (ValaMethod* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", value, NULL);
}

gboolean
vala_method_get_returns_modified_pointer (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_returns_modified_pointer (ValaMethod* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer", value, NULL);
}

ValaMethod*
vala_method_get_base_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_method;
	result = _tmp0_;
	return result;
}

ValaMethod*
vala_method_get_base_interface_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_interface_method;
	result = _tmp0_;
	return result;
}

ValaDataType*
vala_method_get_base_interface_type (ValaMethod* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_interface_type;
	result = _tmp0_;
	return result;
}

void
vala_method_set_base_interface_type (ValaMethod* self,
                                     ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	self->priv->_base_interface_type = _tmp0_;
	_tmp1_ = self->priv->_base_interface_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_get_entry_point (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_entry_point;
	return result;
}

static void
vala_method_set_entry_point (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}

ValaParameter*
vala_method_get_this_parameter (ValaMethod* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}

void
vala_method_set_this_parameter (ValaMethod* self,
                                ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}

gboolean
vala_method_get_printf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "PrintfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_printf_format (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "PrintfFormat", value, NULL);
}

gboolean
vala_method_get_scanf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ScanfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_scanf_format (ValaMethod* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ScanfFormat", value, NULL);
}

gboolean
vala_method_get_has_construct_function (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", TRUE);
	return result;
}

void
vala_method_set_has_construct_function (ValaMethod* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", value, NULL);
}

ValaLocalVariable*
vala_method_get_params_array_var (ValaMethod* self)
{
	ValaLocalVariable* result;
	ValaLocalVariable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_params_array_var;
	result = _tmp0_;
	return result;
}

void
vala_method_set_params_array_var (ValaMethod* self,
                                  ValaLocalVariable* value)
{
	ValaLocalVariable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_params_array_var);
	self->priv->_params_array_var = _tmp0_;
}

ValaSignal*
vala_method_get_signal_reference (ValaMethod* self)
{
	ValaSignal* result;
	ValaSignal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_reference;
	result = _tmp0_;
	return result;
}

void
vala_method_set_signal_reference (ValaMethod* self,
                                  ValaSignal* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}

gboolean
vala_method_get_closure (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_closure;
	return result;
}

void
vala_method_set_closure (ValaMethod* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_closure = value;
}

gboolean
vala_method_get_coroutine (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coroutine;
	return result;
}

void
vala_method_set_coroutine (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}

gboolean
vala_method_get_is_async_callback (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_async_callback;
	return result;
}

void
vala_method_set_is_async_callback (ValaMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_async_callback = value;
}

/**
 * Creates a new method.
 *
 * @param name              method name
 * @param return_type       method return type
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaMethod* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_subroutine_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaMethod*
vala_method_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference, comment);
}

/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
static void
vala_method_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

static ValaList*
vala_method_real_get_parameters (ValaCallable* base)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->parameters;
	result = _tmp0_;
	return result;
}

/**
 * Remove all parameters from this method.
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

void
vala_method_clear_parameters (ValaMethod* self)
{
	ValaList* _tmp17_;
	g_return_if_fail (self != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaParameter* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_param_index = _param_index + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = vala_list_get (_tmp7_, _param_index);
			param = (ValaParameter*) _tmp8_;
			_tmp9_ = param;
			_tmp10_ = vala_parameter_get_ellipsis (_tmp9_);
			_tmp11_ = _tmp10_;
			if (!_tmp11_) {
				ValaScope* _tmp12_;
				ValaScope* _tmp13_;
				ValaParameter* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp12_ = vala_symbol_get_scope ((ValaSymbol*) self);
				_tmp13_ = _tmp12_;
				_tmp14_ = param;
				_tmp15_ = vala_symbol_get_name ((ValaSymbol*) _tmp14_);
				_tmp16_ = _tmp15_;
				vala_scope_remove (_tmp13_, _tmp16_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp17_ = self->priv->parameters;
	vala_collection_clear ((ValaCollection*) _tmp17_);
}

gboolean
vala_method_is_variadic (ValaMethod* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			ValaParameter* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_param_index = _param_index + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = vala_list_get (_tmp7_, _param_index);
			param = (ValaParameter*) _tmp8_;
			_tmp10_ = param;
			_tmp11_ = vala_parameter_get_ellipsis (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_) {
				_tmp9_ = TRUE;
			} else {
				ValaParameter* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				_tmp13_ = param;
				_tmp14_ = vala_parameter_get_params_array (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = _tmp15_;
			}
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}

static void
vala_method_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}

static void
vala_method_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	ValaList* _tmp28_;
	ValaLocalVariable* _tmp39_;
	ValaLocalVariable* _tmp40_;
	ValaList* _tmp43_;
	ValaList* _tmp54_;
	ValaBlock* _tmp65_;
	ValaBlock* _tmp66_;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _p_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = vala_method_get_type_parameters (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaTypeParameter* _tmp9_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = vala_list_get (_tmp7_, _p_index);
			p = (ValaTypeParameter*) _tmp8_;
			_tmp9_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp10_ = vala_method_get_base_interface_type (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		_tmp12_ = vala_method_get_base_interface_type (self);
		_tmp13_ = _tmp12_;
		vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
	}
	_tmp14_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		_tmp16_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp17_ = _tmp16_;
		vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp18_;
		ValaList* _tmp19_;
		gint _param_size = 0;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _param_index = 0;
		_tmp18_ = self->priv->parameters;
		_tmp19_ = _vala_iterable_ref0 (_tmp18_);
		_param_list = _tmp19_;
		_tmp20_ = _param_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_param_size = _tmp22_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			ValaParameter* param = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaParameter* _tmp27_;
			_param_index = _param_index + 1;
			_tmp23_ = _param_index;
			_tmp24_ = _param_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _param_list;
			_tmp26_ = vala_list_get (_tmp25_, _param_index);
			param = (ValaParameter*) _tmp26_;
			_tmp27_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp27_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp28_ = self->error_types;
	if (_tmp28_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp29_;
			ValaList* _tmp30_;
			gint _error_type_size = 0;
			ValaList* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			gint _error_type_index = 0;
			_tmp29_ = self->error_types;
			_tmp30_ = _vala_iterable_ref0 (_tmp29_);
			_error_type_list = _tmp30_;
			_tmp31_ = _error_type_list;
			_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
			_tmp33_ = _tmp32_;
			_error_type_size = _tmp33_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp34_;
				gint _tmp35_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp36_;
				gpointer _tmp37_;
				ValaDataType* _tmp38_;
				_error_type_index = _error_type_index + 1;
				_tmp34_ = _error_type_index;
				_tmp35_ = _error_type_size;
				if (!(_tmp34_ < _tmp35_)) {
					break;
				}
				_tmp36_ = _error_type_list;
				_tmp37_ = vala_list_get (_tmp36_, _error_type_index);
				error_type = (ValaDataType*) _tmp37_;
				_tmp38_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp38_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp39_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp40_ = _tmp39_;
	if (_tmp40_ != NULL) {
		ValaLocalVariable* _tmp41_;
		ValaLocalVariable* _tmp42_;
		_tmp41_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp42_ = _tmp41_;
		vala_code_node_accept ((ValaCodeNode*) _tmp42_, visitor);
	}
	_tmp43_ = self->priv->preconditions;
	if (_tmp43_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp44_;
			ValaList* _tmp45_;
			gint _precondition_size = 0;
			ValaList* _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			gint _precondition_index = 0;
			_tmp44_ = self->priv->preconditions;
			_tmp45_ = _vala_iterable_ref0 (_tmp44_);
			_precondition_list = _tmp45_;
			_tmp46_ = _precondition_list;
			_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
			_tmp48_ = _tmp47_;
			_precondition_size = _tmp48_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp49_;
				gint _tmp50_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp51_;
				gpointer _tmp52_;
				ValaExpression* _tmp53_;
				_precondition_index = _precondition_index + 1;
				_tmp49_ = _precondition_index;
				_tmp50_ = _precondition_size;
				if (!(_tmp49_ < _tmp50_)) {
					break;
				}
				_tmp51_ = _precondition_list;
				_tmp52_ = vala_list_get (_tmp51_, _precondition_index);
				precondition = (ValaExpression*) _tmp52_;
				_tmp53_ = precondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp53_, visitor);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp54_ = self->priv->postconditions;
	if (_tmp54_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp55_;
			ValaList* _tmp56_;
			gint _postcondition_size = 0;
			ValaList* _tmp57_;
			gint _tmp58_;
			gint _tmp59_;
			gint _postcondition_index = 0;
			_tmp55_ = self->priv->postconditions;
			_tmp56_ = _vala_iterable_ref0 (_tmp55_);
			_postcondition_list = _tmp56_;
			_tmp57_ = _postcondition_list;
			_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
			_tmp59_ = _tmp58_;
			_postcondition_size = _tmp59_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp60_;
				gint _tmp61_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp62_;
				gpointer _tmp63_;
				ValaExpression* _tmp64_;
				_postcondition_index = _postcondition_index + 1;
				_tmp60_ = _postcondition_index;
				_tmp61_ = _postcondition_size;
				if (!(_tmp60_ < _tmp61_)) {
					break;
				}
				_tmp62_ = _postcondition_list;
				_tmp63_ = vala_list_get (_tmp62_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp63_;
				_tmp64_ = postcondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp64_, visitor);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp65_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp66_ = _tmp65_;
	if (_tmp66_ != NULL) {
		ValaBlock* _tmp67_;
		ValaBlock* _tmp68_;
		_tmp67_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp68_ = _tmp67_;
		vala_code_node_accept ((ValaCodeNode*) _tmp68_, visitor);
	}
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible (ValaMethod* self,
                        ValaMethod* base_method,
                        gchar** invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	_tmp1_ = vala_method_compatible_internal (self, base_method, &_tmp0_, (ValaCodeNode*) self);
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = _tmp0_;
	result = _tmp1_;
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible_no_error (ValaMethod* self,
                                 ValaMethod* base_method)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	result = vala_method_compatible_internal (self, base_method, NULL, NULL);
	return result;
}

static gboolean
vala_method_compatible_internal (ValaMethod* self,
                                 ValaMethod* base_method,
                                 gchar** invalid_match,
                                 ValaCodeNode* node_reference)
{
	gchar* _vala_invalid_match = NULL;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaObjectType* object_type = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	ValaList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	ValaList* method_type_args = NULL;
	ValaDataType* return_type = NULL;
	ValaDataType* _tmp55_;
	ValaDataType* _tmp56_;
	ValaDataType* _tmp57_;
	ValaDataType* actual_base_type = NULL;
	ValaDataType* _tmp64_;
	ValaDataType* _tmp65_;
	ValaObjectType* _tmp66_;
	ValaList* _tmp67_;
	ValaDataType* _tmp68_;
	ValaDataType* _tmp69_;
	ValaDataType* _tmp70_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp78_;
	ValaIterator* _tmp79_;
	gint param_index = 0;
	ValaIterator* _tmp129_;
	ValaArrayList* base_method_errors = NULL;
	GEqualFunc _tmp131_;
	ValaArrayList* _tmp132_;
	ValaArrayList* _tmp133_;
	ValaList* _tmp134_;
	gboolean _tmp159_;
	gboolean _tmp160_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (self == base_method) {
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = NULL;
		result = TRUE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp0_ = self->priv->_binding;
	_tmp1_ = base_method->priv->_binding;
	if (_tmp0_ != _tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("incompatible binding");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp2_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	object_type = NULL;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaObjectType* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		_vala_code_node_unref0 (object_type);
		object_type = _tmp7_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaObjectType* _tmp8_;
			ValaObjectTypeSymbol* _tmp9_;
			ValaObjectTypeSymbol* _tmp10_;
			ValaList* _tmp11_;
			ValaList* _tmp12_;
			gint _type_parameter_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _type_parameter_index = 0;
			_tmp8_ = object_type;
			_tmp9_ = vala_object_type_get_object_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_object_type_symbol_get_type_parameters (_tmp10_);
			_tmp12_ = _vala_iterable_ref0 (_tmp11_);
			_type_parameter_list = _tmp12_;
			_tmp13_ = _type_parameter_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_type_parameter_size = _tmp15_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp18_;
				gpointer _tmp19_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp20_;
				ValaGenericType* _tmp21_;
				ValaGenericType* _tmp22_;
				ValaObjectType* _tmp23_;
				ValaGenericType* _tmp24_;
				_type_parameter_index = _type_parameter_index + 1;
				_tmp16_ = _type_parameter_index;
				_tmp17_ = _type_parameter_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _type_parameter_list;
				_tmp19_ = vala_list_get (_tmp18_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp19_;
				_tmp20_ = type_parameter;
				_tmp21_ = vala_generic_type_new (_tmp20_);
				type_arg = _tmp21_;
				_tmp22_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp22_, TRUE);
				_tmp23_ = object_type;
				_tmp24_ = type_arg;
				vala_data_type_add_type_argument ((ValaDataType*) _tmp23_, (ValaDataType*) _tmp24_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp25_ = vala_method_get_type_parameters (self);
	_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_method_get_type_parameters (base_method);
	_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp27_ < _tmp30_) {
		gchar* _tmp31_;
		_tmp31_ = g_strdup ("too few type parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp31_;
		result = FALSE;
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	} else {
		ValaList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		ValaList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		_tmp32_ = vala_method_get_type_parameters (self);
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_method_get_type_parameters (base_method);
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		if (_tmp34_ > _tmp37_) {
			gchar* _tmp38_;
			_tmp38_ = g_strdup ("too many type parameters");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp38_;
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
	}
	method_type_args = NULL;
	if (vala_method_has_type_parameters (self)) {
		GEqualFunc _tmp39_;
		ValaArrayList* _tmp40_;
		_tmp39_ = g_direct_equal;
		_tmp40_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp39_);
		_vala_iterable_unref0 (method_type_args);
		method_type_args = (ValaList*) _tmp40_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaList* _tmp41_;
			ValaList* _tmp42_;
			gint _type_parameter_size = 0;
			ValaList* _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			gint _type_parameter_index = 0;
			_tmp41_ = vala_method_get_type_parameters (self);
			_tmp42_ = _vala_iterable_ref0 (_tmp41_);
			_type_parameter_list = _tmp42_;
			_tmp43_ = _type_parameter_list;
			_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
			_tmp45_ = _tmp44_;
			_type_parameter_size = _tmp45_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp46_;
				gint _tmp47_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp48_;
				gpointer _tmp49_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp50_;
				ValaGenericType* _tmp51_;
				ValaGenericType* _tmp52_;
				ValaList* _tmp53_;
				ValaGenericType* _tmp54_;
				_type_parameter_index = _type_parameter_index + 1;
				_tmp46_ = _type_parameter_index;
				_tmp47_ = _type_parameter_size;
				if (!(_tmp46_ < _tmp47_)) {
					break;
				}
				_tmp48_ = _type_parameter_list;
				_tmp49_ = vala_list_get (_tmp48_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp49_;
				_tmp50_ = type_parameter;
				_tmp51_ = vala_generic_type_new (_tmp50_);
				type_arg = _tmp51_;
				_tmp52_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp52_, TRUE);
				_tmp53_ = method_type_args;
				_tmp54_ = type_arg;
				vala_collection_add ((ValaCollection*) _tmp53_, (ValaDataType*) _tmp54_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp55_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp56_ = _tmp55_;
	_tmp57_ = vala_data_type_copy (_tmp56_);
	return_type = _tmp57_;
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "CCode", "returns_floating_reference")) {
		ValaDataType* _tmp58_;
		gboolean _tmp59_;
		gboolean _tmp60_;
		_tmp58_ = return_type;
		_tmp59_ = vala_method_get_returns_floating_reference (self);
		_tmp60_ = _tmp59_;
		vala_data_type_set_floating_reference (_tmp58_, _tmp60_);
	} else {
		ValaDataType* _tmp61_;
		gboolean _tmp62_;
		gboolean _tmp63_;
		_tmp61_ = return_type;
		_tmp62_ = vala_method_get_returns_floating_reference (base_method);
		_tmp63_ = _tmp62_;
		vala_data_type_set_floating_reference (_tmp61_, _tmp63_);
	}
	_tmp64_ = vala_callable_get_return_type ((ValaCallable*) base_method);
	_tmp65_ = _tmp64_;
	_tmp66_ = object_type;
	_tmp67_ = method_type_args;
	_tmp68_ = vala_data_type_get_actual_type (_tmp65_, (ValaDataType*) _tmp66_, _tmp67_, node_reference);
	actual_base_type = _tmp68_;
	_tmp69_ = return_type;
	_tmp70_ = actual_base_type;
	if (!vala_data_type_equals (_tmp69_, _tmp70_)) {
		ValaDataType* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		ValaDataType* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		_tmp71_ = actual_base_type;
		_tmp72_ = vala_data_type_to_prototype_string (_tmp71_, NULL);
		_tmp73_ = _tmp72_;
		_tmp74_ = return_type;
		_tmp75_ = vala_data_type_to_prototype_string (_tmp74_, NULL);
		_tmp76_ = _tmp75_;
		_tmp77_ = g_strdup_printf ("Base method expected return type `%s', but `%s' was provided", _tmp73_, _tmp76_);
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp77_;
		_g_free0 (_tmp76_);
		_g_free0 (_tmp73_);
		result = FALSE;
		_vala_code_node_unref0 (actual_base_type);
		_vala_code_node_unref0 (return_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp78_ = self->priv->parameters;
	_tmp79_ = vala_iterable_iterator ((ValaIterable*) _tmp78_);
	method_params_it = _tmp79_;
	param_index = 1;
	{
		ValaList* _base_param_list = NULL;
		ValaList* _tmp80_;
		ValaList* _tmp81_;
		gint _base_param_size = 0;
		ValaList* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _base_param_index = 0;
		_tmp80_ = base_method->priv->parameters;
		_tmp81_ = _vala_iterable_ref0 (_tmp80_);
		_base_param_list = _tmp81_;
		_tmp82_ = _base_param_list;
		_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
		_tmp84_ = _tmp83_;
		_base_param_size = _tmp84_;
		_base_param_index = -1;
		while (TRUE) {
			gint _tmp85_;
			gint _tmp86_;
			ValaParameter* base_param = NULL;
			ValaList* _tmp87_;
			gpointer _tmp88_;
			ValaIterator* _tmp89_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp91_;
			gpointer _tmp92_;
			ValaParameter* _tmp93_;
			gboolean _tmp94_;
			gboolean _tmp95_;
			ValaParameter* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			ValaParameter* _tmp100_;
			gboolean _tmp101_;
			gboolean _tmp102_;
			ValaParameter* _tmp103_;
			gboolean _tmp104_;
			gboolean _tmp105_;
			ValaParameter* _tmp107_;
			gboolean _tmp108_;
			gboolean _tmp109_;
			gint _tmp128_;
			_base_param_index = _base_param_index + 1;
			_tmp85_ = _base_param_index;
			_tmp86_ = _base_param_size;
			if (!(_tmp85_ < _tmp86_)) {
				break;
			}
			_tmp87_ = _base_param_list;
			_tmp88_ = vala_list_get (_tmp87_, _base_param_index);
			base_param = (ValaParameter*) _tmp88_;
			_tmp89_ = method_params_it;
			if (!vala_iterator_next (_tmp89_)) {
				gchar* _tmp90_;
				_tmp90_ = g_strdup ("too few parameters");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp90_;
				result = FALSE;
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_code_node_unref0 (return_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp91_ = method_params_it;
			_tmp92_ = vala_iterator_get (_tmp91_);
			param = (ValaParameter*) _tmp92_;
			_tmp93_ = base_param;
			_tmp94_ = vala_parameter_get_ellipsis (_tmp93_);
			_tmp95_ = _tmp94_;
			_tmp96_ = param;
			_tmp97_ = vala_parameter_get_ellipsis (_tmp96_);
			_tmp98_ = _tmp97_;
			if (_tmp95_ != _tmp98_) {
				gchar* _tmp99_;
				_tmp99_ = g_strdup ("ellipsis parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp99_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_code_node_unref0 (return_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp100_ = base_param;
			_tmp101_ = vala_parameter_get_params_array (_tmp100_);
			_tmp102_ = _tmp101_;
			_tmp103_ = param;
			_tmp104_ = vala_parameter_get_params_array (_tmp103_);
			_tmp105_ = _tmp104_;
			if (_tmp102_ != _tmp105_) {
				gchar* _tmp106_;
				_tmp106_ = g_strdup ("params array parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp106_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_code_node_unref0 (return_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp107_ = base_param;
			_tmp108_ = vala_parameter_get_ellipsis (_tmp107_);
			_tmp109_ = _tmp108_;
			if (!_tmp109_) {
				ValaParameter* _tmp110_;
				ValaParameterDirection _tmp111_;
				ValaParameterDirection _tmp112_;
				ValaParameter* _tmp113_;
				ValaParameterDirection _tmp114_;
				ValaParameterDirection _tmp115_;
				ValaParameter* _tmp117_;
				ValaDataType* _tmp118_;
				ValaDataType* _tmp119_;
				ValaObjectType* _tmp120_;
				ValaList* _tmp121_;
				ValaDataType* _tmp122_;
				ValaDataType* _tmp123_;
				ValaParameter* _tmp124_;
				ValaDataType* _tmp125_;
				ValaDataType* _tmp126_;
				_tmp110_ = base_param;
				_tmp111_ = vala_parameter_get_direction (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp113_ = param;
				_tmp114_ = vala_parameter_get_direction (_tmp113_);
				_tmp115_ = _tmp114_;
				if (_tmp112_ != _tmp115_) {
					gchar* _tmp116_;
					_tmp116_ = g_strdup_printf ("incompatible direction of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp116_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_code_node_unref0 (return_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_tmp117_ = base_param;
				_tmp118_ = vala_variable_get_variable_type ((ValaVariable*) _tmp117_);
				_tmp119_ = _tmp118_;
				_tmp120_ = object_type;
				_tmp121_ = method_type_args;
				_tmp122_ = vala_data_type_get_actual_type (_tmp119_, (ValaDataType*) _tmp120_, _tmp121_, node_reference);
				_vala_code_node_unref0 (actual_base_type);
				actual_base_type = _tmp122_;
				_tmp123_ = actual_base_type;
				_tmp124_ = param;
				_tmp125_ = vala_variable_get_variable_type ((ValaVariable*) _tmp124_);
				_tmp126_ = _tmp125_;
				if (!vala_data_type_equals (_tmp123_, _tmp126_)) {
					gchar* _tmp127_;
					_tmp127_ = g_strdup_printf ("incompatible type of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp127_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_code_node_unref0 (return_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
			}
			_tmp128_ = param_index;
			param_index = _tmp128_ + 1;
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (base_param);
		}
		_vala_iterable_unref0 (_base_param_list);
	}
	_tmp129_ = method_params_it;
	if (vala_iterator_next (_tmp129_)) {
		gchar* _tmp130_;
		_tmp130_ = g_strdup ("too many parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp130_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_code_node_unref0 (return_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp131_ = g_direct_equal;
	_tmp132_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp131_);
	base_method_errors = _tmp132_;
	_tmp133_ = base_method_errors;
	vala_code_node_get_error_types ((ValaCodeNode*) base_method, (ValaCollection*) _tmp133_, NULL);
	_tmp134_ = self->error_types;
	if (_tmp134_ != NULL) {
		{
			ValaList* _method_error_type_list = NULL;
			ValaList* _tmp135_;
			ValaList* _tmp136_;
			gint _method_error_type_size = 0;
			ValaList* _tmp137_;
			gint _tmp138_;
			gint _tmp139_;
			gint _method_error_type_index = 0;
			_tmp135_ = self->error_types;
			_tmp136_ = _vala_iterable_ref0 (_tmp135_);
			_method_error_type_list = _tmp136_;
			_tmp137_ = _method_error_type_list;
			_tmp138_ = vala_collection_get_size ((ValaCollection*) _tmp137_);
			_tmp139_ = _tmp138_;
			_method_error_type_size = _tmp139_;
			_method_error_type_index = -1;
			while (TRUE) {
				gint _tmp140_;
				gint _tmp141_;
				ValaDataType* method_error_type = NULL;
				ValaList* _tmp142_;
				gpointer _tmp143_;
				gboolean match = FALSE;
				_method_error_type_index = _method_error_type_index + 1;
				_tmp140_ = _method_error_type_index;
				_tmp141_ = _method_error_type_size;
				if (!(_tmp140_ < _tmp141_)) {
					break;
				}
				_tmp142_ = _method_error_type_list;
				_tmp143_ = vala_list_get (_tmp142_, _method_error_type_index);
				method_error_type = (ValaDataType*) _tmp143_;
				match = FALSE;
				{
					ValaArrayList* _base_method_error_type_list = NULL;
					ValaArrayList* _tmp144_;
					ValaArrayList* _tmp145_;
					gint _base_method_error_type_size = 0;
					ValaArrayList* _tmp146_;
					gint _tmp147_;
					gint _tmp148_;
					gint _base_method_error_type_index = 0;
					_tmp144_ = base_method_errors;
					_tmp145_ = _vala_iterable_ref0 (_tmp144_);
					_base_method_error_type_list = _tmp145_;
					_tmp146_ = _base_method_error_type_list;
					_tmp147_ = vala_collection_get_size ((ValaCollection*) _tmp146_);
					_tmp148_ = _tmp147_;
					_base_method_error_type_size = _tmp148_;
					_base_method_error_type_index = -1;
					while (TRUE) {
						gint _tmp149_;
						gint _tmp150_;
						ValaDataType* base_method_error_type = NULL;
						ValaArrayList* _tmp151_;
						gpointer _tmp152_;
						ValaDataType* _tmp153_;
						ValaDataType* _tmp154_;
						_base_method_error_type_index = _base_method_error_type_index + 1;
						_tmp149_ = _base_method_error_type_index;
						_tmp150_ = _base_method_error_type_size;
						if (!(_tmp149_ < _tmp150_)) {
							break;
						}
						_tmp151_ = _base_method_error_type_list;
						_tmp152_ = vala_list_get ((ValaList*) _tmp151_, _base_method_error_type_index);
						base_method_error_type = (ValaDataType*) _tmp152_;
						_tmp153_ = method_error_type;
						_tmp154_ = base_method_error_type;
						if (vala_data_type_compatible (_tmp153_, _tmp154_)) {
							match = TRUE;
							_vala_code_node_unref0 (base_method_error_type);
							break;
						}
						_vala_code_node_unref0 (base_method_error_type);
					}
					_vala_iterable_unref0 (_base_method_error_type_list);
				}
				if (!match) {
					ValaDataType* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					gchar* _tmp158_;
					_tmp155_ = method_error_type;
					_tmp156_ = vala_code_node_to_string ((ValaCodeNode*) _tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = g_strdup_printf ("incompatible error type `%s'", _tmp157_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp158_;
					_g_free0 (_tmp157_);
					result = FALSE;
					_vala_code_node_unref0 (method_error_type);
					_vala_iterable_unref0 (_method_error_type_list);
					_vala_iterable_unref0 (base_method_errors);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_code_node_unref0 (return_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_vala_code_node_unref0 (method_error_type);
			}
			_vala_iterable_unref0 (_method_error_type_list);
		}
	}
	_tmp159_ = base_method->priv->_coroutine;
	_tmp160_ = self->priv->_coroutine;
	if (_tmp159_ != _tmp160_) {
		gchar* _tmp161_;
		_tmp161_ = g_strdup ("async mismatch");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp161_;
		result = FALSE;
		_vala_iterable_unref0 (base_method_errors);
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_code_node_unref0 (return_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_iterable_unref0 (base_method_errors);
	_vala_iterator_unref0 (method_params_it);
	_vala_code_node_unref0 (actual_base_type);
	_vala_code_node_unref0 (return_type);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_method_add_type_parameter (ValaMethod* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_parameters);
		self->priv->type_parameters = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp3_, p);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp7_ = _tmp6_;
	vala_scope_add (_tmp5_, _tmp7_, (ValaSymbol*) p);
}

/**
 * Returns the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_method_get_type_parameters (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->type_parameters;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_type_parameter_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_type_parameter_list);
		vala_method__empty_type_parameter_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_type_parameter_list;
	result = _tmp5_;
	return result;
}

gint
vala_method_get_type_parameter_index (ValaMethod* self,
                                      const gchar* name)
{
	ValaList* _tmp0_;
	gint i = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _parameter_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _parameter_index = 0;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_parameter_list = _tmp2_;
		_tmp3_ = _parameter_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_parameter_size = _tmp5_;
		_parameter_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaTypeParameter* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gint _tmp13_;
			_parameter_index = _parameter_index + 1;
			_tmp6_ = _parameter_index;
			_tmp7_ = _parameter_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _parameter_list;
			_tmp9_ = vala_list_get (_tmp8_, _parameter_index);
			parameter = (ValaTypeParameter*) _tmp9_;
			_tmp10_ = parameter;
			_tmp11_ = vala_symbol_get_name ((ValaSymbol*) _tmp10_);
			_tmp12_ = _tmp11_;
			if (g_strcmp0 (_tmp12_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp13_ = i;
			i = _tmp13_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_type_parameters (ValaMethod* self)
{
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->type_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_parameters;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void
vala_method_add_precondition (ValaMethod* self,
                              ValaExpression* precondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->preconditions);
		self->priv->preconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->preconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}

/**
 * Returns the list of preconditions of this method.
 *
 * @return list of preconditions
 */
ValaList*
vala_method_get_preconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->preconditions;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_expression_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_expression_list;
	result = _tmp5_;
	return result;
}

/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void
vala_method_add_postcondition (ValaMethod* self,
                               ValaExpression* postcondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->postconditions);
		self->priv->postconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->postconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}

/**
 * Returns the list of postconditions of this method.
 *
 * @return list of postconditions
 */
ValaList*
vala_method_get_postconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->postconditions;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_expression_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_expression_list;
	result = _tmp5_;
	return result;
}

/**
 * Adds an error type to the exceptions that can be
 * thrown by this method.
 */
void
vala_method_add_error_type (ValaMethod* self,
                            ValaDataType* error_type)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->error_types);
		self->error_types = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->error_types;
	vala_collection_add ((ValaCollection*) _tmp3_, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, (ValaCodeNode*) self);
}

static void
vala_method_real_get_error_types (ValaCodeNode* base,
                                  ValaCollection* collection,
                                  ValaSourceReference* source_reference)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _error_type_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _error_type_index = 0;
			_tmp1_ = self->error_types;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_error_type_list = _tmp2_;
			_tmp3_ = _error_type_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_error_type_size = _tmp5_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp8_;
				gpointer _tmp9_;
				_error_type_index = _error_type_index + 1;
				_tmp6_ = _error_type_index;
				_tmp7_ = _error_type_size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _error_type_list;
				_tmp9_ = vala_list_get (_tmp8_, _error_type_index);
				error_type = (ValaDataType*) _tmp9_;
				if (source_reference != NULL) {
					ValaDataType* type = NULL;
					ValaDataType* _tmp10_;
					ValaDataType* _tmp11_;
					ValaDataType* _tmp12_;
					ValaDataType* _tmp13_;
					_tmp10_ = error_type;
					_tmp11_ = vala_data_type_copy (_tmp10_);
					type = _tmp11_;
					_tmp12_ = type;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp12_, source_reference);
					_tmp13_ = type;
					vala_collection_add (collection, _tmp13_);
					_vala_code_node_unref0 (type);
				} else {
					ValaDataType* _tmp14_;
					_tmp14_ = error_type;
					vala_collection_add (collection, _tmp14_);
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
}

static void
vala_method_real_replace_expression (ValaCodeNode* base,
                                     ValaExpression* old_node,
                                     ValaExpression* new_node)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		gint index = 0;
		ValaList* _tmp1_;
		_tmp1_ = self->priv->preconditions;
		index = vala_list_index_of (_tmp1_, old_node);
		if (index >= 0) {
			ValaList* _tmp2_;
			_tmp2_ = self->priv->preconditions;
			vala_list_set (_tmp2_, index, new_node);
			vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
		}
	}
	_tmp3_ = self->priv->postconditions;
	if (_tmp3_ != NULL) {
		gint index = 0;
		ValaList* _tmp4_;
		_tmp4_ = self->priv->postconditions;
		index = vala_list_index_of (_tmp4_, old_node);
		if (index >= 0) {
			ValaList* _tmp5_;
			_tmp5_ = self->priv->postconditions;
			vala_list_set (_tmp5_, index, new_node);
			vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
		}
	}
}

static void
vala_method_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaMethod * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaList* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_method_get_base_interface_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_method_set_base_interface_type (self, new_type);
		return;
	}
	_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp4_ = self->error_types;
	if (_tmp4_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					ValaList* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					ValaList* _tmp10_;
					gpointer _tmp11_;
					ValaDataType* _tmp12_;
					gboolean _tmp13_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = self->error_types;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					if (!(i < _tmp9_)) {
						break;
					}
					_tmp10_ = self->error_types;
					_tmp11_ = vala_list_get (_tmp10_, i);
					_tmp12_ = (ValaDataType*) _tmp11_;
					_tmp13_ = _tmp12_ == old_type;
					_vala_code_node_unref0 (_tmp12_);
					if (_tmp13_) {
						ValaList* _tmp14_;
						_tmp14_ = self->error_types;
						vala_list_set (_tmp14_, i, new_type);
						return;
					}
				}
			}
		}
	}
}

static void
vala_method_find_base_methods (ValaMethod* self)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->base_methods_valid) {
		return;
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_CLASS (_tmp1_)) {
		if (!VALA_IS_CREATION_METHOD (self)) {
			ValaSymbol* _tmp2_;
			ValaSymbol* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp3_ = _tmp2_;
			vala_method_find_base_interface_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
			_tmp6_ = self->priv->_is_virtual;
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp7_;
				_tmp7_ = self->priv->_is_abstract;
				_tmp5_ = _tmp7_;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				gboolean _tmp8_;
				_tmp8_ = self->priv->_overrides;
				_tmp4_ = _tmp8_;
			}
			if (_tmp4_) {
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp10_ = _tmp9_;
				vala_method_find_base_class_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CLASS, ValaClass));
			}
		}
	} else {
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		if (VALA_IS_INTERFACE (_tmp12_)) {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp15_;
				_tmp15_ = self->priv->_is_abstract;
				_tmp13_ = _tmp15_;
			}
			if (_tmp13_) {
				self->priv->_base_interface_method = self;
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}

static void
vala_method_find_base_class_method (ValaMethod* self,
                                    ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp11_;
	ValaClass* _tmp36_;
	ValaClass* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (VALA_IS_SIGNAL (_tmp5_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp6_;
		ValaSignal* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = sym;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_SIGNAL, ValaSignal);
		_tmp7_ = sig;
		_tmp8_ = vala_signal_get_default_handler (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp9_);
		_vala_code_node_unref0 (sym);
		sym = _tmp10_;
	}
	_tmp11_ = sym;
	if (VALA_IS_METHOD (_tmp11_)) {
		ValaMethod* base_method = NULL;
		ValaSymbol* _tmp12_;
		gboolean _tmp13_ = FALSE;
		ValaMethod* _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = sym;
		base_method = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_METHOD, ValaMethod);
		_tmp14_ = base_method;
		_tmp15_ = _tmp14_->priv->_is_abstract;
		if (_tmp15_) {
			_tmp13_ = TRUE;
		} else {
			ValaMethod* _tmp16_;
			gboolean _tmp17_;
			_tmp16_ = base_method;
			_tmp17_ = _tmp16_->priv->_is_virtual;
			_tmp13_ = _tmp17_;
		}
		if (_tmp13_) {
			gchar* invalid_match = NULL;
			ValaMethod* _tmp18_;
			gchar* _tmp19_ = NULL;
			gboolean _tmp20_;
			ValaMethod* _tmp33_;
			ValaMethod* _tmp34_;
			ValaMethod* _tmp35_;
			_tmp18_ = base_method;
			_tmp20_ = vala_method_compatible (self, _tmp18_, &_tmp19_);
			_g_free0 (invalid_match);
			invalid_match = _tmp19_;
			if (!_tmp20_) {
				ValaMethodType* base_method_type = NULL;
				ValaMethod* _tmp21_;
				ValaMethodType* _tmp22_;
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				ValaMethodType* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp21_ = base_method;
				_tmp22_ = vala_method_type_new (_tmp21_);
				base_method_type = _tmp22_;
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = base_method_type;
				_tmp28_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp27_, NULL);
				_tmp29_ = _tmp28_;
				_tmp30_ = invalid_match;
				_tmp31_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp26_, _tmp29_, _tmp30_);
				_tmp32_ = _tmp31_;
				vala_report_error (_tmp24_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp26_);
				_vala_code_node_unref0 (base_method_type);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp33_ = base_method;
			self->priv->_base_method = _tmp33_;
			_tmp34_ = base_method;
			vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp34_, "CCode", "instance_pos");
			_tmp35_ = base_method;
			vala_code_node_copy_attribute_bool ((ValaCodeNode*) self, (ValaCodeNode*) _tmp35_, "CCode", "returns_floating_reference");
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (sym);
			return;
		}
	}
	_tmp36_ = vala_class_get_base_class (cl);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		ValaClass* _tmp38_;
		ValaClass* _tmp39_;
		_tmp38_ = vala_class_get_base_class (cl);
		_tmp39_ = _tmp38_;
		vala_method_find_base_class_method (self, _tmp39_);
	}
	_vala_code_node_unref0 (sym);
}

static void
vala_method_find_base_interface_method (ValaMethod* self,
                                        ValaClass* cl)
{
	ValaMethod* base_match = NULL;
	gchar* invalid_error = NULL;
	ValaMethod* invalid_base_match = NULL;
	ValaMethod* _tmp71_;
	ValaDataType* _tmp91_;
	ValaDataType* _tmp92_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	base_match = NULL;
	invalid_error = NULL;
	invalid_base_match = NULL;
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* type = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_type_index = _type_index + 1;
			_tmp5_ = _type_index;
			_tmp6_ = _type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _type_list;
			_tmp8_ = vala_list_get (_tmp7_, _type_index);
			type = (ValaDataType*) _tmp8_;
			_tmp9_ = type;
			_tmp10_ = vala_data_type_get_type_symbol (_tmp9_);
			_tmp11_ = _tmp10_;
			if (VALA_IS_INTERFACE (_tmp11_)) {
				gboolean _tmp12_ = FALSE;
				ValaDataType* _tmp13_;
				ValaDataType* _tmp14_;
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp22_;
				ValaTypeSymbol* _tmp23_;
				ValaTypeSymbol* _tmp24_;
				ValaScope* _tmp25_;
				ValaScope* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				ValaSymbol* _tmp29_;
				ValaSymbol* _tmp30_;
				ValaSymbol* _tmp36_;
				_tmp13_ = vala_method_get_base_interface_type (self);
				_tmp14_ = _tmp13_;
				if (_tmp14_ != NULL) {
					ValaDataType* _tmp15_;
					ValaDataType* _tmp16_;
					ValaTypeSymbol* _tmp17_;
					ValaTypeSymbol* _tmp18_;
					ValaDataType* _tmp19_;
					ValaTypeSymbol* _tmp20_;
					ValaTypeSymbol* _tmp21_;
					_tmp15_ = vala_method_get_base_interface_type (self);
					_tmp16_ = _tmp15_;
					_tmp17_ = vala_data_type_get_type_symbol (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = type;
					_tmp20_ = vala_data_type_get_type_symbol (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp12_ = _tmp18_ != _tmp21_;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_vala_code_node_unref0 (type);
					continue;
				}
				_tmp22_ = type;
				_tmp23_ = vala_data_type_get_type_symbol (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_scope ((ValaSymbol*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_scope_lookup (_tmp26_, _tmp28_);
				sym = _tmp29_;
				_tmp30_ = sym;
				if (VALA_IS_SIGNAL (_tmp30_)) {
					ValaSignal* sig = NULL;
					ValaSymbol* _tmp31_;
					ValaSignal* _tmp32_;
					ValaMethod* _tmp33_;
					ValaMethod* _tmp34_;
					ValaSymbol* _tmp35_;
					_tmp31_ = sym;
					sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_SIGNAL, ValaSignal);
					_tmp32_ = sig;
					_tmp33_ = vala_signal_get_default_handler (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp34_);
					_vala_code_node_unref0 (sym);
					sym = _tmp35_;
				}
				_tmp36_ = sym;
				if (VALA_IS_METHOD (_tmp36_)) {
					ValaMethod* base_method = NULL;
					ValaSymbol* _tmp37_;
					gboolean _tmp38_ = FALSE;
					ValaMethod* _tmp39_;
					gboolean _tmp40_;
					_tmp37_ = sym;
					base_method = G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_METHOD, ValaMethod);
					_tmp39_ = base_method;
					_tmp40_ = _tmp39_->priv->_is_abstract;
					if (_tmp40_) {
						_tmp38_ = TRUE;
					} else {
						ValaMethod* _tmp41_;
						gboolean _tmp42_;
						_tmp41_ = base_method;
						_tmp42_ = _tmp41_->priv->_is_virtual;
						_tmp38_ = _tmp42_;
					}
					if (_tmp38_) {
						ValaDataType* _tmp43_;
						ValaDataType* _tmp44_;
						gchar* invalid_match = NULL;
						ValaMethod* _tmp62_;
						gchar* _tmp63_ = NULL;
						gboolean _tmp64_;
						_tmp43_ = vala_method_get_base_interface_type (self);
						_tmp44_ = _tmp43_;
						if (_tmp44_ == NULL) {
							gboolean has_explicit_implementation = FALSE;
							has_explicit_implementation = FALSE;
							{
								ValaList* _m_list = NULL;
								ValaList* _tmp45_;
								ValaList* _tmp46_;
								gint _m_size = 0;
								ValaList* _tmp47_;
								gint _tmp48_;
								gint _tmp49_;
								gint _m_index = 0;
								_tmp45_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
								_tmp46_ = _vala_iterable_ref0 (_tmp45_);
								_m_list = _tmp46_;
								_tmp47_ = _m_list;
								_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
								_tmp49_ = _tmp48_;
								_m_size = _tmp49_;
								_m_index = -1;
								while (TRUE) {
									gint _tmp50_;
									gint _tmp51_;
									ValaMethod* m = NULL;
									ValaList* _tmp52_;
									gpointer _tmp53_;
									gboolean _tmp54_ = FALSE;
									ValaMethod* _tmp55_;
									ValaDataType* _tmp56_;
									ValaDataType* _tmp57_;
									_m_index = _m_index + 1;
									_tmp50_ = _m_index;
									_tmp51_ = _m_size;
									if (!(_tmp50_ < _tmp51_)) {
										break;
									}
									_tmp52_ = _m_list;
									_tmp53_ = vala_list_get (_tmp52_, _m_index);
									m = (ValaMethod*) _tmp53_;
									_tmp55_ = m;
									_tmp56_ = vala_method_get_base_interface_type (_tmp55_);
									_tmp57_ = _tmp56_;
									if (_tmp57_ != NULL) {
										ValaMethod* _tmp58_;
										ValaMethod* _tmp59_;
										ValaMethod* _tmp60_;
										ValaMethod* _tmp61_;
										_tmp58_ = base_method;
										_tmp59_ = m;
										_tmp60_ = vala_method_get_base_interface_method (_tmp59_);
										_tmp61_ = _tmp60_;
										_tmp54_ = _tmp58_ == _tmp61_;
									} else {
										_tmp54_ = FALSE;
									}
									if (_tmp54_) {
										has_explicit_implementation = TRUE;
										_vala_code_node_unref0 (m);
										break;
									}
									_vala_code_node_unref0 (m);
								}
								_vala_iterable_unref0 (_m_list);
							}
							if (has_explicit_implementation) {
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (type);
								continue;
							}
						}
						invalid_match = NULL;
						_tmp62_ = base_method;
						_tmp64_ = vala_method_compatible (self, _tmp62_, &_tmp63_);
						_g_free0 (invalid_match);
						invalid_match = _tmp63_;
						if (!_tmp64_) {
							const gchar* _tmp65_;
							gchar* _tmp66_;
							ValaMethod* _tmp67_;
							ValaMethod* _tmp68_;
							_tmp65_ = invalid_match;
							_tmp66_ = g_strdup (_tmp65_);
							_g_free0 (invalid_error);
							invalid_error = _tmp66_;
							_tmp67_ = base_method;
							_tmp68_ = _vala_code_node_ref0 (_tmp67_);
							_vala_code_node_unref0 (invalid_base_match);
							invalid_base_match = _tmp68_;
						} else {
							ValaMethod* _tmp69_;
							ValaMethod* _tmp70_;
							_tmp69_ = base_method;
							_tmp70_ = _vala_code_node_ref0 (_tmp69_);
							_vala_code_node_unref0 (base_match);
							base_match = _tmp70_;
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							break;
						}
						_g_free0 (invalid_match);
					}
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	_tmp71_ = base_match;
	if (_tmp71_ != NULL) {
		ValaMethod* _tmp72_;
		ValaMethod* _tmp73_;
		ValaMethod* _tmp74_;
		_tmp72_ = base_match;
		self->priv->_base_interface_method = _tmp72_;
		_tmp73_ = base_match;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp73_, "CCode", "instance_pos");
		_tmp74_ = base_match;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) self, (ValaCodeNode*) _tmp74_, "CCode", "returns_floating_reference");
		_vala_code_node_unref0 (invalid_base_match);
		_g_free0 (invalid_error);
		_vala_code_node_unref0 (base_match);
		return;
	} else {
		gboolean _tmp75_ = FALSE;
		gboolean _tmp76_;
		gboolean _tmp77_;
		_tmp76_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp77_ = _tmp76_;
		if (!_tmp77_) {
			ValaMethod* _tmp78_;
			_tmp78_ = invalid_base_match;
			_tmp75_ = _tmp78_ != NULL;
		} else {
			_tmp75_ = FALSE;
		}
		if (_tmp75_) {
			ValaMethodType* base_method_type = NULL;
			ValaMethod* _tmp79_;
			ValaMethodType* _tmp80_;
			ValaSourceReference* _tmp81_;
			ValaSourceReference* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			ValaMethodType* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			const gchar* _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp79_ = invalid_base_match;
			_tmp80_ = vala_method_type_new (_tmp79_);
			base_method_type = _tmp80_;
			_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp82_ = _tmp81_;
			_tmp83_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp84_ = _tmp83_;
			_tmp85_ = base_method_type;
			_tmp86_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp85_, NULL);
			_tmp87_ = _tmp86_;
			_tmp88_ = invalid_error;
			_tmp89_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp84_, _tmp87_, _tmp88_);
			_tmp90_ = _tmp89_;
			vala_report_error (_tmp82_, _tmp90_);
			_g_free0 (_tmp90_);
			_g_free0 (_tmp87_);
			_g_free0 (_tmp84_);
			_vala_code_node_unref0 (base_method_type);
			_vala_code_node_unref0 (invalid_base_match);
			_g_free0 (invalid_error);
			_vala_code_node_unref0 (base_match);
			return;
		}
	}
	_tmp91_ = vala_method_get_base_interface_type (self);
	_tmp92_ = _tmp91_;
	if (_tmp92_ != NULL) {
		ValaSourceReference* _tmp93_;
		ValaSourceReference* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp94_ = _tmp93_;
		_tmp95_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp96_ = _tmp95_;
		_tmp97_ = g_strdup_printf ("`%s': no suitable interface method found to implement", _tmp96_);
		_tmp98_ = _tmp97_;
		vala_report_error (_tmp94_, _tmp98_);
		_g_free0 (_tmp98_);
		_g_free0 (_tmp96_);
	}
	_vala_code_node_unref0 (invalid_base_match);
	_g_free0 (invalid_error);
	_vala_code_node_unref0 (base_match);
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_method_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaParameter* _tmp4_;
	ValaAttribute* _tmp6_;
	ValaAttribute* _tmp10_;
	gboolean _tmp11_ = FALSE;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp34_ = FALSE;
	ValaAttribute* _tmp35_;
	gboolean _tmp41_;
	gboolean _tmp77_ = FALSE;
	gboolean _tmp78_;
	gboolean _tmp110_ = FALSE;
	gboolean _tmp111_ = FALSE;
	gboolean _tmp112_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp117_;
	ValaSemanticAnalyzer* _tmp118_;
	ValaSourceFile* _tmp119_;
	ValaSourceFile* _tmp120_;
	ValaSourceFile* _tmp121_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp122_;
	ValaSemanticAnalyzer* _tmp123_;
	ValaSymbol* _tmp124_;
	ValaSymbol* _tmp125_;
	ValaSymbol* _tmp126_;
	ValaSourceReference* _tmp127_;
	ValaSourceReference* _tmp128_;
	ValaSemanticAnalyzer* _tmp135_;
	ValaSemanticAnalyzer* _tmp136_;
	ValaDataType* _tmp137_;
	ValaDataType* _tmp138_;
	gboolean _tmp139_;
	gboolean _tmp140_;
	ValaDataType* _tmp141_;
	ValaDataType* _tmp142_;
	gboolean _tmp143_;
	gboolean _tmp144_;
	ValaDataType* _tmp149_;
	ValaDataType* _tmp150_;
	ValaTypeSymbol* _tmp151_;
	ValaTypeSymbol* _tmp152_;
	ValaSemanticAnalyzer* _tmp153_;
	ValaSemanticAnalyzer* _tmp154_;
	ValaDataType* _tmp155_;
	ValaTypeSymbol* _tmp156_;
	ValaTypeSymbol* _tmp157_;
	ValaAttribute* init_attr = NULL;
	ValaAttribute* _tmp168_;
	ValaAttribute* _tmp169_;
	ValaAttribute* _tmp170_;
	gboolean _tmp177_ = FALSE;
	gboolean _tmp178_ = FALSE;
	gboolean _tmp179_ = FALSE;
	ValaList* _tmp180_;
	gint _tmp181_;
	gint _tmp182_;
	gboolean _tmp196_ = FALSE;
	ValaAttribute* _tmp197_;
	gboolean optional_param = FALSE;
	gboolean params_array_param = FALSE;
	gboolean ellipsis_param = FALSE;
	gboolean _tmp348_;
	ValaList* _tmp362_;
	ValaLocalVariable* _tmp394_;
	ValaLocalVariable* _tmp395_;
	ValaList* _tmp398_;
	ValaList* _tmp409_;
	ValaBlock* _tmp420_;
	ValaBlock* _tmp421_;
	ValaSemanticAnalyzer* _tmp424_;
	ValaSemanticAnalyzer* _tmp425_;
	ValaStruct* _tmp426_;
	ValaStruct* _tmp427_;
	gboolean _tmp485_ = FALSE;
	gboolean _tmp486_ = FALSE;
	ValaDataType* _tmp487_;
	ValaDataType* _tmp488_;
	ValaSemanticAnalyzer* _tmp534_;
	ValaSemanticAnalyzer* _tmp535_;
	ValaSourceFile* _tmp536_;
	ValaSemanticAnalyzer* _tmp537_;
	ValaSemanticAnalyzer* _tmp538_;
	ValaSymbol* _tmp539_;
	gboolean _tmp540_ = FALSE;
	gboolean _tmp541_ = FALSE;
	gboolean _tmp542_ = FALSE;
	gboolean _tmp543_;
	gboolean _tmp544_;
	ValaSemanticAnalyzer* _tmp560_;
	ValaSemanticAnalyzer* _tmp561_;
	ValaDataType* _tmp562_;
	ValaDataType* _tmp563_;
	gboolean _tmp616_ = FALSE;
	ValaBlock* _tmp617_;
	ValaBlock* _tmp618_;
	gboolean _tmp663_ = FALSE;
	gboolean _tmp664_ = FALSE;
	gboolean _tmp665_ = FALSE;
	gboolean _tmp666_ = FALSE;
	gboolean _tmp667_ = FALSE;
	ValaAttribute* _tmp727_;
	gboolean _tmp728_;
	gboolean _tmp729_;
	gboolean result = FALSE;
	self = (ValaMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_this_parameter;
	if (_tmp4_ != NULL) {
		ValaParameter* _tmp5_;
		_tmp5_ = self->priv->_this_parameter;
		vala_code_node_check ((ValaCodeNode*) _tmp5_, context);
	}
	_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DestroysInstance");
	if (_tmp6_ != NULL) {
		ValaParameter* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp7_ = self->priv->_this_parameter;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) _tmp7_);
		_tmp9_ = _tmp8_;
		vala_data_type_set_value_owned (_tmp9_, TRUE);
	}
	_tmp10_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoThrow");
	if (_tmp10_ != NULL) {
		_vala_iterable_unref0 (self->error_types);
		self->error_types = NULL;
	}
	_tmp12_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp13_ = _tmp12_;
	if (VALA_IS_CLASS (_tmp13_)) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		_tmp15_ = self->priv->_is_abstract;
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			gboolean _tmp16_;
			_tmp16_ = self->priv->_is_virtual;
			_tmp14_ = _tmp16_;
		}
		_tmp11_ = _tmp14_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		gboolean _tmp19_ = FALSE;
		ValaClass* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp17_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp18_ = _tmp17_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_CLASS, ValaClass);
		_tmp20_ = cl;
		_tmp21_ = vala_class_get_is_compact (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			ValaClass* _tmp23_;
			ValaClass* _tmp24_;
			ValaClass* _tmp25_;
			_tmp23_ = cl;
			_tmp24_ = vala_class_get_base_class (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp19_ = _tmp25_ != NULL;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			ValaSourceReference* _tmp26_;
			ValaSourceReference* _tmp27_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp27_ = _tmp26_;
			vala_report_error (_tmp27_, "Abstract and virtual methods may not be declared in derived compact cl" \
"asses");
			result = FALSE;
			return result;
		}
	}
	if (vala_method_is_variadic (self)) {
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_;
		_tmp30_ = self->priv->_is_abstract;
		if (_tmp30_) {
			_tmp29_ = TRUE;
		} else {
			gboolean _tmp31_;
			_tmp31_ = self->priv->_is_virtual;
			_tmp29_ = _tmp31_;
		}
		_tmp28_ = _tmp29_;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp33_ = _tmp32_;
		vala_report_error (_tmp33_, "Abstract and virtual methods may not be variadic. Use a `va_list' para" \
"meter instead of `...' or params-array.");
		result = FALSE;
		return result;
	}
	_tmp35_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoWrapper");
	if (_tmp35_ != NULL) {
		gboolean _tmp36_ = FALSE;
		gboolean _tmp37_;
		_tmp37_ = self->priv->_is_abstract;
		if (_tmp37_) {
			_tmp36_ = TRUE;
		} else {
			gboolean _tmp38_;
			_tmp38_ = self->priv->_is_virtual;
			_tmp36_ = _tmp38_;
		}
		_tmp34_ = !_tmp36_;
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		ValaSourceReference* _tmp39_;
		ValaSourceReference* _tmp40_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp40_ = _tmp39_;
		vala_report_error (_tmp40_, "[NoWrapper] methods must be declared abstract or virtual");
		result = FALSE;
		return result;
	}
	_tmp41_ = self->priv->_is_abstract;
	if (_tmp41_) {
		ValaSymbol* _tmp42_;
		ValaSymbol* _tmp43_;
		_tmp42_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp43_ = _tmp42_;
		if (VALA_IS_CLASS (_tmp43_)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			ValaClass* _tmp46_;
			gboolean _tmp47_;
			gboolean _tmp48_;
			_tmp44_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp45_ = _tmp44_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_CLASS, ValaClass);
			_tmp46_ = cl;
			_tmp47_ = vala_class_get_is_abstract (_tmp46_);
			_tmp48_ = _tmp47_;
			if (!_tmp48_) {
				ValaSourceReference* _tmp49_;
				ValaSourceReference* _tmp50_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp50_ = _tmp49_;
				vala_report_error (_tmp50_, "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				return result;
			}
		} else {
			ValaSymbol* _tmp51_;
			ValaSymbol* _tmp52_;
			_tmp51_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp52_ = _tmp51_;
			if (!VALA_IS_INTERFACE (_tmp52_)) {
				ValaSourceReference* _tmp53_;
				ValaSourceReference* _tmp54_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp54_ = _tmp53_;
				vala_report_error (_tmp54_, "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp55_;
		_tmp55_ = self->priv->_is_virtual;
		if (_tmp55_) {
			gboolean _tmp56_ = FALSE;
			ValaSymbol* _tmp57_;
			ValaSymbol* _tmp58_;
			_tmp57_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp58_ = _tmp57_;
			if (!VALA_IS_CLASS (_tmp58_)) {
				ValaSymbol* _tmp59_;
				ValaSymbol* _tmp60_;
				_tmp59_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp60_ = _tmp59_;
				_tmp56_ = !VALA_IS_INTERFACE (_tmp60_);
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				ValaSourceReference* _tmp61_;
				ValaSourceReference* _tmp62_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp62_ = _tmp61_;
				vala_report_error (_tmp62_, "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp63_;
			_tmp63_ = self->priv->_overrides;
			if (_tmp63_) {
				ValaSymbol* _tmp64_;
				ValaSymbol* _tmp65_;
				_tmp64_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp65_ = _tmp64_;
				if (!VALA_IS_CLASS (_tmp65_)) {
					ValaSourceReference* _tmp66_;
					ValaSourceReference* _tmp67_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp67_ = _tmp66_;
					vala_report_error (_tmp67_, "Methods may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp68_;
				ValaSymbolAccessibility _tmp69_;
				_tmp68_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp69_ = _tmp68_;
				if (_tmp69_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp70_ = FALSE;
					ValaSymbol* _tmp71_;
					ValaSymbol* _tmp72_;
					_tmp71_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp72_ = _tmp71_;
					if (!VALA_IS_CLASS (_tmp72_)) {
						ValaSymbol* _tmp73_;
						ValaSymbol* _tmp74_;
						_tmp73_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp74_ = _tmp73_;
						_tmp70_ = !VALA_IS_INTERFACE (_tmp74_);
					} else {
						_tmp70_ = FALSE;
					}
					if (_tmp70_) {
						ValaSourceReference* _tmp75_;
						ValaSourceReference* _tmp76_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp75_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp76_ = _tmp75_;
						vala_report_error (_tmp76_, "Protected methods may not be declared outside of classes and interface" \
"s");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp78_ = self->priv->_is_abstract;
	if (_tmp78_) {
		ValaBlock* _tmp79_;
		ValaBlock* _tmp80_;
		_tmp79_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp80_ = _tmp79_;
		_tmp77_ = _tmp80_ != NULL;
	} else {
		_tmp77_ = FALSE;
	}
	if (_tmp77_) {
		ValaSourceReference* _tmp81_;
		ValaSourceReference* _tmp82_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp82_ = _tmp81_;
		vala_report_error (_tmp82_, "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp83_ = FALSE;
		gboolean _tmp84_ = FALSE;
		gboolean _tmp85_;
		_tmp85_ = self->priv->_is_abstract;
		if (_tmp85_) {
			_tmp84_ = TRUE;
		} else {
			gboolean _tmp86_;
			_tmp86_ = self->priv->_is_virtual;
			_tmp84_ = _tmp86_;
		}
		if (_tmp84_) {
			gboolean _tmp87_;
			gboolean _tmp88_;
			_tmp87_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp88_ = _tmp87_;
			_tmp83_ = _tmp88_;
		} else {
			_tmp83_ = FALSE;
		}
		if (_tmp83_) {
			ValaSourceReference* _tmp89_;
			ValaSourceReference* _tmp90_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp90_ = _tmp89_;
			vala_report_error (_tmp90_, "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp91_ = FALSE;
			gboolean _tmp92_;
			gboolean _tmp93_;
			_tmp92_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp93_ = _tmp92_;
			if (_tmp93_) {
				ValaBlock* _tmp94_;
				ValaBlock* _tmp95_;
				_tmp94_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp95_ = _tmp94_;
				_tmp91_ = _tmp95_ != NULL;
			} else {
				_tmp91_ = FALSE;
			}
			if (_tmp91_) {
				ValaSourceReference* _tmp96_;
				ValaSourceReference* _tmp97_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp96_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp97_ = _tmp96_;
				vala_report_error (_tmp97_, "Extern methods cannot have bodies");
			} else {
				gboolean _tmp98_ = FALSE;
				gboolean _tmp99_ = FALSE;
				gboolean _tmp100_ = FALSE;
				gboolean _tmp101_;
				_tmp101_ = self->priv->_is_abstract;
				if (!_tmp101_) {
					gboolean _tmp102_;
					gboolean _tmp103_;
					_tmp102_ = vala_symbol_get_external ((ValaSymbol*) self);
					_tmp103_ = _tmp102_;
					_tmp100_ = !_tmp103_;
				} else {
					_tmp100_ = FALSE;
				}
				if (_tmp100_) {
					ValaSourceFileType _tmp104_;
					ValaSourceFileType _tmp105_;
					_tmp104_ = vala_symbol_get_source_type ((ValaSymbol*) self);
					_tmp105_ = _tmp104_;
					_tmp99_ = _tmp105_ == VALA_SOURCE_FILE_TYPE_SOURCE;
				} else {
					_tmp99_ = FALSE;
				}
				if (_tmp99_) {
					ValaBlock* _tmp106_;
					ValaBlock* _tmp107_;
					_tmp106_ = vala_subroutine_get_body ((ValaSubroutine*) self);
					_tmp107_ = _tmp106_;
					_tmp98_ = _tmp107_ == NULL;
				} else {
					_tmp98_ = FALSE;
				}
				if (_tmp98_) {
					ValaSourceReference* _tmp108_;
					ValaSourceReference* _tmp109_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp109_ = _tmp108_;
					vala_report_error (_tmp109_, "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp112_ = self->priv->_coroutine;
	if (_tmp112_) {
		gboolean _tmp113_;
		gboolean _tmp114_;
		_tmp113_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp114_ = _tmp113_;
		_tmp111_ = !_tmp114_;
	} else {
		_tmp111_ = FALSE;
	}
	if (_tmp111_) {
		_tmp110_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp110_ = FALSE;
	}
	if (_tmp110_) {
		ValaSourceReference* _tmp115_;
		ValaSourceReference* _tmp116_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp116_ = _tmp115_;
		vala_report_error (_tmp116_, "gio-2.0 package required for async methods");
		result = FALSE;
		return result;
	}
	_tmp117_ = vala_code_context_get_analyzer (context);
	_tmp118_ = _tmp117_;
	_tmp119_ = vala_semantic_analyzer_get_current_source_file (_tmp118_);
	_tmp120_ = _tmp119_;
	_tmp121_ = _vala_source_file_ref0 (_tmp120_);
	old_source_file = _tmp121_;
	_tmp122_ = vala_code_context_get_analyzer (context);
	_tmp123_ = _tmp122_;
	_tmp124_ = vala_semantic_analyzer_get_current_symbol (_tmp123_);
	_tmp125_ = _tmp124_;
	_tmp126_ = _vala_code_node_ref0 (_tmp125_);
	old_symbol = _tmp126_;
	_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp128_ = _tmp127_;
	if (_tmp128_ != NULL) {
		ValaSemanticAnalyzer* _tmp129_;
		ValaSemanticAnalyzer* _tmp130_;
		ValaSourceReference* _tmp131_;
		ValaSourceReference* _tmp132_;
		ValaSourceFile* _tmp133_;
		ValaSourceFile* _tmp134_;
		_tmp129_ = vala_code_context_get_analyzer (context);
		_tmp130_ = _tmp129_;
		_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp132_ = _tmp131_;
		_tmp133_ = vala_source_reference_get_file (_tmp132_);
		_tmp134_ = _tmp133_;
		vala_semantic_analyzer_set_current_source_file (_tmp130_, _tmp134_);
	}
	_tmp135_ = vala_code_context_get_analyzer (context);
	_tmp136_ = _tmp135_;
	vala_semantic_analyzer_set_current_symbol (_tmp136_, (ValaSymbol*) self);
	_tmp137_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp138_ = _tmp137_;
	_tmp139_ = vala_method_get_returns_floating_reference (self);
	_tmp140_ = _tmp139_;
	vala_data_type_set_floating_reference (_tmp138_, _tmp140_);
	_tmp141_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp142_ = _tmp141_;
	vala_code_node_check ((ValaCodeNode*) _tmp142_, context);
	_tmp143_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp144_ = _tmp143_;
	if (!_tmp144_) {
		ValaSemanticAnalyzer* _tmp145_;
		ValaSemanticAnalyzer* _tmp146_;
		ValaDataType* _tmp147_;
		ValaDataType* _tmp148_;
		_tmp145_ = vala_code_context_get_analyzer (context);
		_tmp146_ = _tmp145_;
		_tmp147_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp148_ = _tmp147_;
		vala_semantic_analyzer_check_type (_tmp146_, _tmp148_);
	}
	_tmp149_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp150_ = _tmp149_;
	_tmp151_ = vala_data_type_get_type_symbol (_tmp150_);
	_tmp152_ = _tmp151_;
	_tmp153_ = vala_code_context_get_analyzer (context);
	_tmp154_ = _tmp153_;
	_tmp155_ = _tmp154_->va_list_type;
	_tmp156_ = vala_data_type_get_type_symbol (_tmp155_);
	_tmp157_ = _tmp156_;
	if (_tmp152_ == _tmp157_) {
		ValaSourceReference* _tmp158_;
		ValaSourceReference* _tmp159_;
		ValaDataType* _tmp160_;
		ValaDataType* _tmp161_;
		ValaTypeSymbol* _tmp162_;
		ValaTypeSymbol* _tmp163_;
		gchar* _tmp164_;
		gchar* _tmp165_;
		gchar* _tmp166_;
		gchar* _tmp167_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp159_ = _tmp158_;
		_tmp160_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp161_ = _tmp160_;
		_tmp162_ = vala_data_type_get_type_symbol (_tmp161_);
		_tmp163_ = _tmp162_;
		_tmp164_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp163_);
		_tmp165_ = _tmp164_;
		_tmp166_ = g_strdup_printf ("`%s' not supported as return type", _tmp165_);
		_tmp167_ = _tmp166_;
		vala_report_error (_tmp159_, _tmp167_);
		_g_free0 (_tmp167_);
		_g_free0 (_tmp165_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp168_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ModuleInit");
	_tmp169_ = _vala_code_node_ref0 (_tmp168_);
	init_attr = _tmp169_;
	_tmp170_ = init_attr;
	if (_tmp170_ != NULL) {
		ValaSourceReference* _tmp171_;
		ValaSourceReference* _tmp172_;
		ValaSourceFile* _tmp173_;
		ValaSourceFile* _tmp174_;
		ValaCodeContext* _tmp175_;
		ValaCodeContext* _tmp176_;
		_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp172_ = _tmp171_;
		_tmp173_ = vala_source_reference_get_file (_tmp172_);
		_tmp174_ = _tmp173_;
		_tmp175_ = vala_source_file_get_context (_tmp174_);
		_tmp176_ = _tmp175_;
		vala_code_context_set_module_init_method (_tmp176_, self);
	}
	_tmp180_ = self->priv->parameters;
	_tmp181_ = vala_collection_get_size ((ValaCollection*) _tmp180_);
	_tmp182_ = _tmp181_;
	if (_tmp182_ == 1) {
		ValaList* _tmp183_;
		gpointer _tmp184_;
		ValaParameter* _tmp185_;
		gboolean _tmp186_;
		gboolean _tmp187_;
		_tmp183_ = self->priv->parameters;
		_tmp184_ = vala_list_get (_tmp183_, 0);
		_tmp185_ = (ValaParameter*) _tmp184_;
		_tmp186_ = vala_parameter_get_ellipsis (_tmp185_);
		_tmp187_ = _tmp186_;
		_tmp179_ = _tmp187_;
		_vala_code_node_unref0 (_tmp185_);
	} else {
		_tmp179_ = FALSE;
	}
	if (_tmp179_) {
		ValaBlock* _tmp188_;
		ValaBlock* _tmp189_;
		_tmp188_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp189_ = _tmp188_;
		_tmp178_ = _tmp189_ != NULL;
	} else {
		_tmp178_ = FALSE;
	}
	if (_tmp178_) {
		ValaMemberBinding _tmp190_;
		_tmp190_ = self->priv->_binding;
		_tmp177_ = _tmp190_ != VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp177_ = FALSE;
	}
	if (_tmp177_) {
		ValaList* _tmp191_;
		gpointer _tmp192_;
		ValaParameter* _tmp193_;
		ValaSourceReference* _tmp194_;
		ValaSourceReference* _tmp195_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp191_ = self->priv->parameters;
		_tmp192_ = vala_list_get (_tmp191_, 0);
		_tmp193_ = (ValaParameter*) _tmp192_;
		_tmp194_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp193_);
		_tmp195_ = _tmp194_;
		vala_report_error (_tmp195_, "Named parameter required before `...'");
		_vala_code_node_unref0 (_tmp193_);
	}
	_tmp197_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Print");
	if (_tmp197_ != NULL) {
		gboolean _tmp198_ = FALSE;
		ValaList* _tmp199_;
		gint _tmp200_;
		gint _tmp201_;
		_tmp199_ = self->priv->parameters;
		_tmp200_ = vala_collection_get_size ((ValaCollection*) _tmp199_);
		_tmp201_ = _tmp200_;
		if (_tmp201_ != 1) {
			_tmp198_ = TRUE;
		} else {
			ValaList* _tmp202_;
			gpointer _tmp203_;
			ValaParameter* _tmp204_;
			ValaDataType* _tmp205_;
			ValaDataType* _tmp206_;
			ValaTypeSymbol* _tmp207_;
			ValaTypeSymbol* _tmp208_;
			ValaSemanticAnalyzer* _tmp209_;
			ValaSemanticAnalyzer* _tmp210_;
			ValaDataType* _tmp211_;
			ValaTypeSymbol* _tmp212_;
			ValaTypeSymbol* _tmp213_;
			_tmp202_ = self->priv->parameters;
			_tmp203_ = vala_list_get (_tmp202_, 0);
			_tmp204_ = (ValaParameter*) _tmp203_;
			_tmp205_ = vala_variable_get_variable_type ((ValaVariable*) _tmp204_);
			_tmp206_ = _tmp205_;
			_tmp207_ = vala_data_type_get_type_symbol (_tmp206_);
			_tmp208_ = _tmp207_;
			_tmp209_ = vala_code_context_get_analyzer (context);
			_tmp210_ = _tmp209_;
			_tmp211_ = _tmp210_->string_type;
			_tmp212_ = vala_data_type_get_type_symbol (_tmp211_);
			_tmp213_ = _tmp212_;
			_tmp198_ = _tmp208_ != _tmp213_;
			_vala_code_node_unref0 (_tmp204_);
		}
		_tmp196_ = _tmp198_;
	} else {
		_tmp196_ = FALSE;
	}
	if (_tmp196_) {
		ValaSourceReference* _tmp214_;
		ValaSourceReference* _tmp215_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp215_ = _tmp214_;
		vala_report_error (_tmp215_, "[Print] methods must have exactly one parameter of type `string'");
	}
	optional_param = FALSE;
	params_array_param = FALSE;
	ellipsis_param = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp216_;
		ValaList* _tmp217_;
		gint _param_size = 0;
		ValaList* _tmp218_;
		gint _tmp219_;
		gint _tmp220_;
		gint _param_index = 0;
		_tmp216_ = self->priv->parameters;
		_tmp217_ = _vala_iterable_ref0 (_tmp216_);
		_param_list = _tmp217_;
		_tmp218_ = _param_list;
		_tmp219_ = vala_collection_get_size ((ValaCollection*) _tmp218_);
		_tmp220_ = _tmp219_;
		_param_size = _tmp220_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp221_;
			gint _tmp222_;
			ValaParameter* param = NULL;
			ValaList* _tmp223_;
			gpointer _tmp224_;
			ValaParameter* _tmp225_;
			gboolean _tmp226_ = FALSE;
			gboolean _tmp227_;
			gboolean _tmp234_ = FALSE;
			gboolean _tmp235_ = FALSE;
			gboolean _tmp236_;
			gboolean _tmp237_;
			gboolean _tmp260_;
			gboolean _tmp261_ = FALSE;
			gboolean _tmp262_ = FALSE;
			gboolean _tmp287_ = FALSE;
			ValaParameter* _tmp288_;
			gboolean _tmp289_;
			gboolean _tmp290_;
			_param_index = _param_index + 1;
			_tmp221_ = _param_index;
			_tmp222_ = _param_size;
			if (!(_tmp221_ < _tmp222_)) {
				break;
			}
			_tmp223_ = _param_list;
			_tmp224_ = vala_list_get (_tmp223_, _param_index);
			param = (ValaParameter*) _tmp224_;
			_tmp225_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp225_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp227_ = self->priv->_coroutine;
			if (_tmp227_) {
				ValaParameter* _tmp228_;
				ValaParameterDirection _tmp229_;
				ValaParameterDirection _tmp230_;
				_tmp228_ = param;
				_tmp229_ = vala_parameter_get_direction (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp226_ = _tmp230_ == VALA_PARAMETER_DIRECTION_REF;
			} else {
				_tmp226_ = FALSE;
			}
			if (_tmp226_) {
				ValaParameter* _tmp231_;
				ValaSourceReference* _tmp232_;
				ValaSourceReference* _tmp233_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp231_ = param;
				_tmp232_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp231_);
				_tmp233_ = _tmp232_;
				vala_report_error (_tmp233_, "Reference parameters are not supported for async methods");
			}
			_tmp236_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp237_ = _tmp236_;
			if (!_tmp237_) {
				gboolean _tmp238_;
				_tmp238_ = self->priv->_coroutine;
				_tmp235_ = _tmp238_;
			} else {
				_tmp235_ = FALSE;
			}
			if (_tmp235_) {
				gboolean _tmp239_ = FALSE;
				gboolean _tmp240_ = FALSE;
				ValaParameter* _tmp241_;
				gboolean _tmp242_;
				gboolean _tmp243_;
				_tmp241_ = param;
				_tmp242_ = vala_parameter_get_ellipsis (_tmp241_);
				_tmp243_ = _tmp242_;
				if (_tmp243_) {
					_tmp240_ = TRUE;
				} else {
					ValaParameter* _tmp244_;
					gboolean _tmp245_;
					gboolean _tmp246_;
					_tmp244_ = param;
					_tmp245_ = vala_parameter_get_params_array (_tmp244_);
					_tmp246_ = _tmp245_;
					_tmp240_ = _tmp246_;
				}
				if (_tmp240_) {
					_tmp239_ = TRUE;
				} else {
					ValaParameter* _tmp247_;
					ValaDataType* _tmp248_;
					ValaDataType* _tmp249_;
					ValaTypeSymbol* _tmp250_;
					ValaTypeSymbol* _tmp251_;
					ValaSemanticAnalyzer* _tmp252_;
					ValaSemanticAnalyzer* _tmp253_;
					ValaDataType* _tmp254_;
					ValaTypeSymbol* _tmp255_;
					ValaTypeSymbol* _tmp256_;
					_tmp247_ = param;
					_tmp248_ = vala_variable_get_variable_type ((ValaVariable*) _tmp247_);
					_tmp249_ = _tmp248_;
					_tmp250_ = vala_data_type_get_type_symbol (_tmp249_);
					_tmp251_ = _tmp250_;
					_tmp252_ = vala_code_context_get_analyzer (context);
					_tmp253_ = _tmp252_;
					_tmp254_ = _tmp253_->va_list_type;
					_tmp255_ = vala_data_type_get_type_symbol (_tmp254_);
					_tmp256_ = _tmp255_;
					_tmp239_ = _tmp251_ == _tmp256_;
				}
				_tmp234_ = _tmp239_;
			} else {
				_tmp234_ = FALSE;
			}
			if (_tmp234_) {
				ValaParameter* _tmp257_;
				ValaSourceReference* _tmp258_;
				ValaSourceReference* _tmp259_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp257_ = param;
				_tmp258_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp257_);
				_tmp259_ = _tmp258_;
				vala_report_error (_tmp259_, "Variadic parameters are not supported for async methods");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp260_ = self->priv->_coroutine;
			if (_tmp260_) {
				_vala_code_node_unref0 (param);
				continue;
			}
			if (optional_param) {
				ValaParameter* _tmp263_;
				ValaExpression* _tmp264_;
				ValaExpression* _tmp265_;
				_tmp263_ = param;
				_tmp264_ = vala_variable_get_initializer ((ValaVariable*) _tmp263_);
				_tmp265_ = _tmp264_;
				_tmp262_ = _tmp265_ == NULL;
			} else {
				_tmp262_ = FALSE;
			}
			if (_tmp262_) {
				ValaParameter* _tmp266_;
				gboolean _tmp267_;
				gboolean _tmp268_;
				_tmp266_ = param;
				_tmp267_ = vala_parameter_get_ellipsis (_tmp266_);
				_tmp268_ = _tmp267_;
				_tmp261_ = !_tmp268_;
			} else {
				_tmp261_ = FALSE;
			}
			if (_tmp261_) {
				ValaParameter* _tmp269_;
				ValaSourceReference* _tmp270_;
				ValaSourceReference* _tmp271_;
				_tmp269_ = param;
				_tmp270_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp269_);
				_tmp271_ = _tmp270_;
				vala_report_warning (_tmp271_, "parameter without default follows parameter with default");
			} else {
				ValaParameter* _tmp272_;
				ValaExpression* _tmp273_;
				ValaExpression* _tmp274_;
				_tmp272_ = param;
				_tmp273_ = vala_variable_get_initializer ((ValaVariable*) _tmp272_);
				_tmp274_ = _tmp273_;
				if (_tmp274_ != NULL) {
					optional_param = TRUE;
				}
			}
			if (params_array_param) {
				ValaParameter* _tmp275_;
				ValaSourceReference* _tmp276_;
				ValaSourceReference* _tmp277_;
				_tmp275_ = param;
				_tmp276_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp275_);
				_tmp277_ = _tmp276_;
				vala_report_error (_tmp277_, "parameter follows params-array parameter");
			} else {
				ValaParameter* _tmp278_;
				gboolean _tmp279_;
				gboolean _tmp280_;
				_tmp278_ = param;
				_tmp279_ = vala_parameter_get_params_array (_tmp278_);
				_tmp280_ = _tmp279_;
				if (_tmp280_) {
					params_array_param = TRUE;
				}
			}
			if (ellipsis_param) {
				ValaParameter* _tmp281_;
				ValaSourceReference* _tmp282_;
				ValaSourceReference* _tmp283_;
				_tmp281_ = param;
				_tmp282_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp281_);
				_tmp283_ = _tmp282_;
				vala_report_error (_tmp283_, "parameter follows ellipsis parameter");
			} else {
				ValaParameter* _tmp284_;
				gboolean _tmp285_;
				gboolean _tmp286_;
				_tmp284_ = param;
				_tmp285_ = vala_parameter_get_ellipsis (_tmp284_);
				_tmp286_ = _tmp285_;
				if (_tmp286_) {
					ellipsis_param = TRUE;
				}
			}
			_tmp288_ = param;
			_tmp289_ = vala_parameter_get_params_array (_tmp288_);
			_tmp290_ = _tmp289_;
			if (_tmp290_) {
				ValaBlock* _tmp291_;
				ValaBlock* _tmp292_;
				_tmp291_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp292_ = _tmp291_;
				_tmp287_ = _tmp292_ != NULL;
			} else {
				_tmp287_ = FALSE;
			}
			if (_tmp287_) {
				ValaLocalVariable* _tmp293_;
				gboolean _tmp297_;
				gboolean _tmp298_;
				ValaArrayType* type = NULL;
				ValaParameter* _tmp302_;
				ValaDataType* _tmp303_;
				ValaDataType* _tmp304_;
				ValaDataType* _tmp305_;
				ValaArrayType* _tmp306_;
				ValaDataType* _tmp307_;
				ValaDataType* _tmp308_;
				ValaArrayType* _tmp309_;
				gboolean _tmp310_;
				gboolean _tmp311_;
				ValaArrayType* _tmp312_;
				gboolean _tmp313_ = FALSE;
				ValaArrayType* _tmp314_;
				ValaDataType* _tmp315_;
				ValaDataType* _tmp316_;
				ValaArrayType* _tmp325_;
				ValaExpression* _tmp326_;
				ValaExpression* _tmp327_;
				ValaArrayType* _tmp331_;
				ValaParameter* _tmp332_;
				const gchar* _tmp333_;
				const gchar* _tmp334_;
				ValaParameter* _tmp335_;
				ValaSourceReference* _tmp336_;
				ValaSourceReference* _tmp337_;
				ValaLocalVariable* _tmp338_;
				ValaLocalVariable* _tmp339_;
				ValaBlock* _tmp340_;
				ValaBlock* _tmp341_;
				ValaLocalVariable* _tmp342_;
				ValaParameter* _tmp343_;
				ValaSourceReference* _tmp344_;
				ValaSourceReference* _tmp345_;
				ValaDeclarationStatement* _tmp346_;
				ValaDeclarationStatement* _tmp347_;
				_tmp293_ = self->priv->_params_array_var;
				if (_tmp293_ != NULL) {
					ValaParameter* _tmp294_;
					ValaSourceReference* _tmp295_;
					ValaSourceReference* _tmp296_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp294_ = param;
					_tmp295_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp294_);
					_tmp296_ = _tmp295_;
					vala_report_error (_tmp296_, "Only one params-array parameter is allowed");
					_vala_code_node_unref0 (param);
					continue;
				}
				_tmp297_ = vala_code_context_get_experimental (context);
				_tmp298_ = _tmp297_;
				if (!_tmp298_) {
					ValaParameter* _tmp299_;
					ValaSourceReference* _tmp300_;
					ValaSourceReference* _tmp301_;
					_tmp299_ = param;
					_tmp300_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp299_);
					_tmp301_ = _tmp300_;
					vala_report_warning (_tmp301_, "Support of params-arrays is experimental");
				}
				_tmp302_ = param;
				_tmp303_ = vala_variable_get_variable_type ((ValaVariable*) _tmp302_);
				_tmp304_ = _tmp303_;
				_tmp305_ = vala_data_type_copy (_tmp304_);
				type = G_TYPE_CHECK_INSTANCE_CAST (_tmp305_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp306_ = type;
				_tmp307_ = vala_array_type_get_element_type (_tmp306_);
				_tmp308_ = _tmp307_;
				_tmp309_ = type;
				_tmp310_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp309_);
				_tmp311_ = _tmp310_;
				vala_data_type_set_value_owned (_tmp308_, _tmp311_);
				_tmp312_ = type;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp312_, TRUE);
				_tmp314_ = type;
				_tmp315_ = vala_array_type_get_element_type (_tmp314_);
				_tmp316_ = _tmp315_;
				if (vala_data_type_is_real_struct_type (_tmp316_)) {
					ValaArrayType* _tmp317_;
					ValaDataType* _tmp318_;
					ValaDataType* _tmp319_;
					gboolean _tmp320_;
					gboolean _tmp321_;
					_tmp317_ = type;
					_tmp318_ = vala_array_type_get_element_type (_tmp317_);
					_tmp319_ = _tmp318_;
					_tmp320_ = vala_data_type_get_nullable (_tmp319_);
					_tmp321_ = _tmp320_;
					_tmp313_ = !_tmp321_;
				} else {
					_tmp313_ = FALSE;
				}
				if (_tmp313_) {
					ValaParameter* _tmp322_;
					ValaSourceReference* _tmp323_;
					ValaSourceReference* _tmp324_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp322_ = param;
					_tmp323_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp322_);
					_tmp324_ = _tmp323_;
					vala_report_error (_tmp324_, "Only nullable struct elements are supported in params-array");
				}
				_tmp325_ = type;
				_tmp326_ = vala_array_type_get_length (_tmp325_);
				_tmp327_ = _tmp326_;
				if (_tmp327_ != NULL) {
					ValaParameter* _tmp328_;
					ValaSourceReference* _tmp329_;
					ValaSourceReference* _tmp330_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp328_ = param;
					_tmp329_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp328_);
					_tmp330_ = _tmp329_;
					vala_report_error (_tmp330_, "Passing length to params-array is not supported yet");
				}
				_tmp331_ = type;
				_tmp332_ = param;
				_tmp333_ = vala_symbol_get_name ((ValaSymbol*) _tmp332_);
				_tmp334_ = _tmp333_;
				_tmp335_ = param;
				_tmp336_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp335_);
				_tmp337_ = _tmp336_;
				_tmp338_ = vala_local_variable_new ((ValaDataType*) _tmp331_, _tmp334_, NULL, _tmp337_);
				_tmp339_ = _tmp338_;
				vala_method_set_params_array_var (self, _tmp339_);
				_vala_code_node_unref0 (_tmp339_);
				_tmp340_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp341_ = _tmp340_;
				_tmp342_ = self->priv->_params_array_var;
				_tmp343_ = param;
				_tmp344_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp343_);
				_tmp345_ = _tmp344_;
				_tmp346_ = vala_declaration_statement_new ((ValaSymbol*) _tmp342_, _tmp345_);
				_tmp347_ = _tmp346_;
				vala_block_insert_statement (_tmp341_, 0, (ValaStatement*) _tmp347_);
				_vala_code_node_unref0 (_tmp347_);
				_vala_code_node_unref0 (type);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp348_ = self->priv->_coroutine;
	if (_tmp348_) {
		gboolean requires_pointer = FALSE;
		requires_pointer = FALSE;
		{
			gint i = 0;
			ValaList* _tmp349_;
			gint _tmp350_;
			gint _tmp351_;
			_tmp349_ = self->priv->parameters;
			_tmp350_ = vala_collection_get_size ((ValaCollection*) _tmp349_);
			_tmp351_ = _tmp350_;
			i = _tmp351_ - 1;
			{
				gboolean _tmp352_ = FALSE;
				_tmp352_ = TRUE;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp354_;
					gpointer _tmp355_;
					ValaParameter* _tmp356_;
					ValaParameterDirection _tmp357_;
					ValaParameterDirection _tmp358_;
					if (!_tmp352_) {
						gint _tmp353_;
						_tmp353_ = i;
						i = _tmp353_ - 1;
					}
					_tmp352_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp354_ = self->priv->parameters;
					_tmp355_ = vala_list_get (_tmp354_, i);
					param = (ValaParameter*) _tmp355_;
					_tmp356_ = param;
					_tmp357_ = vala_parameter_get_direction (_tmp356_);
					_tmp358_ = _tmp357_;
					if (_tmp358_ == VALA_PARAMETER_DIRECTION_IN) {
						requires_pointer = TRUE;
					} else {
						if (requires_pointer) {
							ValaParameter* _tmp359_;
							ValaSourceReference* _tmp360_;
							ValaSourceReference* _tmp361_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp359_ = param;
							_tmp360_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp359_);
							_tmp361_ = _tmp360_;
							vala_report_error (_tmp361_, "Synchronous out-parameters are not supported in async methods");
						}
					}
					_vala_code_node_unref0 (param);
				}
			}
		}
	}
	_tmp362_ = self->error_types;
	if (_tmp362_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp363_;
			ValaList* _tmp364_;
			gint _error_type_size = 0;
			ValaList* _tmp365_;
			gint _tmp366_;
			gint _tmp367_;
			gint _error_type_index = 0;
			_tmp363_ = self->error_types;
			_tmp364_ = _vala_iterable_ref0 (_tmp363_);
			_error_type_list = _tmp364_;
			_tmp365_ = _error_type_list;
			_tmp366_ = vala_collection_get_size ((ValaCollection*) _tmp365_);
			_tmp367_ = _tmp366_;
			_error_type_size = _tmp367_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp368_;
				gint _tmp369_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp370_;
				gpointer _tmp371_;
				ValaDataType* _tmp372_;
				ValaDataType* _tmp381_;
				ValaSemanticAnalyzer* _tmp382_;
				ValaSemanticAnalyzer* _tmp383_;
				ValaDataType* _tmp384_;
				_error_type_index = _error_type_index + 1;
				_tmp368_ = _error_type_index;
				_tmp369_ = _error_type_size;
				if (!(_tmp368_ < _tmp369_)) {
					break;
				}
				_tmp370_ = _error_type_list;
				_tmp371_ = vala_list_get (_tmp370_, _error_type_index);
				error_type = (ValaDataType*) _tmp371_;
				_tmp372_ = error_type;
				if (!VALA_IS_ERROR_TYPE (_tmp372_)) {
					ValaDataType* _tmp373_;
					ValaSourceReference* _tmp374_;
					ValaSourceReference* _tmp375_;
					ValaDataType* _tmp376_;
					gchar* _tmp377_;
					gchar* _tmp378_;
					gchar* _tmp379_;
					gchar* _tmp380_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp373_ = error_type;
					_tmp374_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp373_);
					_tmp375_ = _tmp374_;
					_tmp376_ = error_type;
					_tmp377_ = vala_code_node_to_string ((ValaCodeNode*) _tmp376_);
					_tmp378_ = _tmp377_;
					_tmp379_ = g_strdup_printf ("`%s' is not an error type", _tmp378_);
					_tmp380_ = _tmp379_;
					vala_report_error (_tmp375_, _tmp380_);
					_g_free0 (_tmp380_);
					_g_free0 (_tmp378_);
				}
				_tmp381_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp381_, context);
				_tmp382_ = vala_code_context_get_analyzer (context);
				_tmp383_ = _tmp382_;
				_tmp384_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp383_, (ValaSymbol*) self, _tmp384_)) {
					ValaSourceReference* _tmp385_;
					ValaSourceReference* _tmp386_;
					ValaDataType* _tmp387_;
					gchar* _tmp388_;
					gchar* _tmp389_;
					gchar* _tmp390_;
					gchar* _tmp391_;
					gchar* _tmp392_;
					gchar* _tmp393_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp385_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp386_ = _tmp385_;
					_tmp387_ = error_type;
					_tmp388_ = vala_code_node_to_string ((ValaCodeNode*) _tmp387_);
					_tmp389_ = _tmp388_;
					_tmp390_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp391_ = _tmp390_;
					_tmp392_ = g_strdup_printf ("error type `%s' is less accessible than method `%s'", _tmp389_, _tmp391_);
					_tmp393_ = _tmp392_;
					vala_report_error (_tmp386_, _tmp393_);
					_g_free0 (_tmp393_);
					_g_free0 (_tmp391_);
					_g_free0 (_tmp389_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_iterable_unref0 (_error_type_list);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp394_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp395_ = _tmp394_;
	if (_tmp395_ != NULL) {
		ValaLocalVariable* _tmp396_;
		ValaLocalVariable* _tmp397_;
		_tmp396_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp397_ = _tmp396_;
		vala_code_node_check ((ValaCodeNode*) _tmp397_, context);
	}
	_tmp398_ = self->priv->preconditions;
	if (_tmp398_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp399_;
			ValaList* _tmp400_;
			gint _precondition_size = 0;
			ValaList* _tmp401_;
			gint _tmp402_;
			gint _tmp403_;
			gint _precondition_index = 0;
			_tmp399_ = self->priv->preconditions;
			_tmp400_ = _vala_iterable_ref0 (_tmp399_);
			_precondition_list = _tmp400_;
			_tmp401_ = _precondition_list;
			_tmp402_ = vala_collection_get_size ((ValaCollection*) _tmp401_);
			_tmp403_ = _tmp402_;
			_precondition_size = _tmp403_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp404_;
				gint _tmp405_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp406_;
				gpointer _tmp407_;
				ValaExpression* _tmp408_;
				_precondition_index = _precondition_index + 1;
				_tmp404_ = _precondition_index;
				_tmp405_ = _precondition_size;
				if (!(_tmp404_ < _tmp405_)) {
					break;
				}
				_tmp406_ = _precondition_list;
				_tmp407_ = vala_list_get (_tmp406_, _precondition_index);
				precondition = (ValaExpression*) _tmp407_;
				_tmp408_ = precondition;
				vala_code_node_check ((ValaCodeNode*) _tmp408_, context);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp409_ = self->priv->postconditions;
	if (_tmp409_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp410_;
			ValaList* _tmp411_;
			gint _postcondition_size = 0;
			ValaList* _tmp412_;
			gint _tmp413_;
			gint _tmp414_;
			gint _postcondition_index = 0;
			_tmp410_ = self->priv->postconditions;
			_tmp411_ = _vala_iterable_ref0 (_tmp410_);
			_postcondition_list = _tmp411_;
			_tmp412_ = _postcondition_list;
			_tmp413_ = vala_collection_get_size ((ValaCollection*) _tmp412_);
			_tmp414_ = _tmp413_;
			_postcondition_size = _tmp414_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp415_;
				gint _tmp416_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp417_;
				gpointer _tmp418_;
				ValaExpression* _tmp419_;
				_postcondition_index = _postcondition_index + 1;
				_tmp415_ = _postcondition_index;
				_tmp416_ = _postcondition_size;
				if (!(_tmp415_ < _tmp416_)) {
					break;
				}
				_tmp417_ = _postcondition_list;
				_tmp418_ = vala_list_get (_tmp417_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp418_;
				_tmp419_ = postcondition;
				vala_code_node_check ((ValaCodeNode*) _tmp419_, context);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp420_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp421_ = _tmp420_;
	if (_tmp421_ != NULL) {
		ValaBlock* _tmp422_;
		ValaBlock* _tmp423_;
		_tmp422_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp423_ = _tmp422_;
		vala_code_node_check ((ValaCodeNode*) _tmp423_, context);
	}
	_tmp424_ = vala_code_context_get_analyzer (context);
	_tmp425_ = _tmp424_;
	_tmp426_ = vala_semantic_analyzer_get_current_struct (_tmp425_);
	_tmp427_ = _tmp426_;
	if (_tmp427_ != NULL) {
		gboolean _tmp428_ = FALSE;
		gboolean _tmp429_ = FALSE;
		gboolean _tmp430_;
		_tmp430_ = self->priv->_is_abstract;
		if (_tmp430_) {
			_tmp429_ = TRUE;
		} else {
			gboolean _tmp431_;
			_tmp431_ = self->priv->_is_virtual;
			_tmp429_ = _tmp431_;
		}
		if (_tmp429_) {
			_tmp428_ = TRUE;
		} else {
			gboolean _tmp432_;
			_tmp432_ = self->priv->_overrides;
			_tmp428_ = _tmp432_;
		}
		if (_tmp428_) {
			ValaSourceReference* _tmp433_;
			ValaSourceReference* _tmp434_;
			gchar* _tmp435_;
			gchar* _tmp436_;
			gchar* _tmp437_;
			gchar* _tmp438_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp433_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp434_ = _tmp433_;
			_tmp435_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp436_ = _tmp435_;
			_tmp437_ = g_strdup_printf ("A struct member `%s' cannot be marked as override, virtual, or abstrac" \
"t", _tmp436_);
			_tmp438_ = _tmp437_;
			vala_report_error (_tmp434_, _tmp438_);
			_g_free0 (_tmp438_);
			_g_free0 (_tmp436_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	} else {
		gboolean _tmp439_ = FALSE;
		gboolean _tmp440_ = FALSE;
		gboolean _tmp441_ = FALSE;
		gboolean _tmp442_;
		_tmp442_ = self->priv->_overrides;
		if (_tmp442_) {
			ValaMethod* _tmp443_;
			ValaMethod* _tmp444_;
			_tmp443_ = vala_method_get_base_method (self);
			_tmp444_ = _tmp443_;
			_tmp441_ = _tmp444_ == NULL;
		} else {
			_tmp441_ = FALSE;
		}
		if (_tmp441_) {
			ValaMethod* _tmp445_;
			ValaMethod* _tmp446_;
			_tmp445_ = vala_method_get_base_interface_method (self);
			_tmp446_ = _tmp445_;
			_tmp440_ = _tmp446_ != NULL;
		} else {
			_tmp440_ = FALSE;
		}
		if (_tmp440_) {
			ValaMethod* _tmp447_;
			ValaMethod* _tmp448_;
			gboolean _tmp449_;
			_tmp447_ = vala_method_get_base_interface_method (self);
			_tmp448_ = _tmp447_;
			_tmp449_ = _tmp448_->priv->_is_abstract;
			_tmp439_ = _tmp449_;
		} else {
			_tmp439_ = FALSE;
		}
		if (_tmp439_) {
			ValaSourceReference* _tmp450_;
			ValaSourceReference* _tmp451_;
			ValaMethod* _tmp452_;
			ValaMethod* _tmp453_;
			gchar* _tmp454_;
			gchar* _tmp455_;
			gchar* _tmp456_;
			gchar* _tmp457_;
			_tmp450_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp451_ = _tmp450_;
			_tmp452_ = vala_method_get_base_interface_method (self);
			_tmp453_ = _tmp452_;
			_tmp454_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp453_);
			_tmp455_ = _tmp454_;
			_tmp456_ = g_strdup_printf ("`override' not required to implement `abstract' interface method `%s'", _tmp455_);
			_tmp457_ = _tmp456_;
			vala_report_warning (_tmp451_, _tmp457_);
			_g_free0 (_tmp457_);
			_g_free0 (_tmp455_);
			vala_method_set_overrides (self, FALSE);
		} else {
			gboolean _tmp458_ = FALSE;
			gboolean _tmp459_ = FALSE;
			gboolean _tmp460_;
			_tmp460_ = self->priv->_overrides;
			if (_tmp460_) {
				ValaMethod* _tmp461_;
				ValaMethod* _tmp462_;
				_tmp461_ = vala_method_get_base_method (self);
				_tmp462_ = _tmp461_;
				_tmp459_ = _tmp462_ == NULL;
			} else {
				_tmp459_ = FALSE;
			}
			if (_tmp459_) {
				ValaMethod* _tmp463_;
				ValaMethod* _tmp464_;
				_tmp463_ = vala_method_get_base_interface_method (self);
				_tmp464_ = _tmp463_;
				_tmp458_ = _tmp464_ == NULL;
			} else {
				_tmp458_ = FALSE;
			}
			if (_tmp458_) {
				ValaSourceReference* _tmp465_;
				ValaSourceReference* _tmp466_;
				gchar* _tmp467_;
				gchar* _tmp468_;
				gchar* _tmp469_;
				gchar* _tmp470_;
				_tmp465_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp466_ = _tmp465_;
				_tmp467_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp468_ = _tmp467_;
				_tmp469_ = g_strdup_printf ("`%s': no suitable method found to override", _tmp468_);
				_tmp470_ = _tmp469_;
				vala_report_error (_tmp466_, _tmp470_);
				_g_free0 (_tmp470_);
				_g_free0 (_tmp468_);
			} else {
				gboolean _tmp471_ = FALSE;
				gboolean _tmp472_ = FALSE;
				gboolean _tmp473_ = FALSE;
				gboolean _tmp474_;
				_tmp474_ = self->priv->_is_abstract;
				if (_tmp474_) {
					_tmp473_ = TRUE;
				} else {
					gboolean _tmp475_;
					_tmp475_ = self->priv->_is_virtual;
					_tmp473_ = _tmp475_;
				}
				if (_tmp473_) {
					_tmp472_ = TRUE;
				} else {
					gboolean _tmp476_;
					_tmp476_ = self->priv->_overrides;
					_tmp472_ = _tmp476_;
				}
				if (_tmp472_) {
					ValaSymbolAccessibility _tmp477_;
					ValaSymbolAccessibility _tmp478_;
					_tmp477_ = vala_symbol_get_access ((ValaSymbol*) self);
					_tmp478_ = _tmp477_;
					_tmp471_ = _tmp478_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp471_ = FALSE;
				}
				if (_tmp471_) {
					ValaSourceReference* _tmp479_;
					ValaSourceReference* _tmp480_;
					gchar* _tmp481_;
					gchar* _tmp482_;
					gchar* _tmp483_;
					gchar* _tmp484_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp479_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp480_ = _tmp479_;
					_tmp481_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp482_ = _tmp481_;
					_tmp483_ = g_strdup_printf ("Private member `%s' cannot be marked as override, virtual, or abstract", _tmp482_);
					_tmp484_ = _tmp483_;
					vala_report_error (_tmp480_, _tmp484_);
					_g_free0 (_tmp484_);
					_g_free0 (_tmp482_);
					result = FALSE;
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
		}
	}
	_tmp487_ = vala_method_get_base_interface_type (self);
	_tmp488_ = _tmp487_;
	if (_tmp488_ != NULL) {
		ValaMethod* _tmp489_;
		ValaMethod* _tmp490_;
		_tmp489_ = vala_method_get_base_interface_method (self);
		_tmp490_ = _tmp489_;
		_tmp486_ = _tmp490_ != NULL;
	} else {
		_tmp486_ = FALSE;
	}
	if (_tmp486_) {
		ValaSymbol* _tmp491_;
		ValaSymbol* _tmp492_;
		_tmp491_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp492_ = _tmp491_;
		_tmp485_ = VALA_IS_CLASS (_tmp492_);
	} else {
		_tmp485_ = FALSE;
	}
	if (_tmp485_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp493_;
		ValaSymbol* _tmp494_;
		_tmp493_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp494_ = _tmp493_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp494_, VALA_TYPE_CLASS, ValaClass);
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp495_;
			ValaList* _tmp496_;
			ValaList* _tmp497_;
			gint _m_size = 0;
			ValaList* _tmp498_;
			gint _tmp499_;
			gint _tmp500_;
			gint _m_index = 0;
			_tmp495_ = cl;
			_tmp496_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp495_);
			_tmp497_ = _vala_iterable_ref0 (_tmp496_);
			_m_list = _tmp497_;
			_tmp498_ = _m_list;
			_tmp499_ = vala_collection_get_size ((ValaCollection*) _tmp498_);
			_tmp500_ = _tmp499_;
			_m_size = _tmp500_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp501_;
				gint _tmp502_;
				ValaMethod* m = NULL;
				ValaList* _tmp503_;
				gpointer _tmp504_;
				gboolean _tmp505_ = FALSE;
				ValaMethod* _tmp506_;
				_m_index = _m_index + 1;
				_tmp501_ = _m_index;
				_tmp502_ = _m_size;
				if (!(_tmp501_ < _tmp502_)) {
					break;
				}
				_tmp503_ = _m_list;
				_tmp504_ = vala_list_get (_tmp503_, _m_index);
				m = (ValaMethod*) _tmp504_;
				_tmp506_ = m;
				if (_tmp506_ != self) {
					ValaMethod* _tmp507_;
					ValaMethod* _tmp508_;
					ValaMethod* _tmp509_;
					ValaMethod* _tmp510_;
					ValaMethod* _tmp511_;
					_tmp507_ = m;
					_tmp508_ = vala_method_get_base_interface_method (_tmp507_);
					_tmp509_ = _tmp508_;
					_tmp510_ = vala_method_get_base_interface_method (self);
					_tmp511_ = _tmp510_;
					_tmp505_ = _tmp509_ == _tmp511_;
				} else {
					_tmp505_ = FALSE;
				}
				if (_tmp505_) {
					ValaMethod* _tmp512_;
					ValaMethod* _tmp513_;
					ValaSourceReference* _tmp514_;
					ValaSourceReference* _tmp515_;
					ValaClass* _tmp516_;
					gchar* _tmp517_;
					gchar* _tmp518_;
					ValaMethod* _tmp519_;
					ValaMethod* _tmp520_;
					gchar* _tmp521_;
					gchar* _tmp522_;
					gchar* _tmp523_;
					gchar* _tmp524_;
					ValaMethod* _tmp525_;
					ValaSourceReference* _tmp526_;
					ValaSourceReference* _tmp527_;
					ValaMethod* _tmp528_;
					ValaMethod* _tmp529_;
					gchar* _tmp530_;
					gchar* _tmp531_;
					gchar* _tmp532_;
					gchar* _tmp533_;
					_tmp512_ = m;
					vala_code_node_set_checked ((ValaCodeNode*) _tmp512_, TRUE);
					_tmp513_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp513_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp514_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp515_ = _tmp514_;
					_tmp516_ = cl;
					_tmp517_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp516_);
					_tmp518_ = _tmp517_;
					_tmp519_ = vala_method_get_base_interface_method (self);
					_tmp520_ = _tmp519_;
					_tmp521_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp520_);
					_tmp522_ = _tmp521_;
					_tmp523_ = g_strdup_printf ("`%s' already contains an implementation for `%s'", _tmp518_, _tmp522_);
					_tmp524_ = _tmp523_;
					vala_report_error (_tmp515_, _tmp524_);
					_g_free0 (_tmp524_);
					_g_free0 (_tmp522_);
					_g_free0 (_tmp518_);
					_tmp525_ = m;
					_tmp526_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp525_);
					_tmp527_ = _tmp526_;
					_tmp528_ = vala_method_get_base_interface_method (self);
					_tmp529_ = _tmp528_;
					_tmp530_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp529_);
					_tmp531_ = _tmp530_;
					_tmp532_ = g_strdup_printf ("previous implementation of `%s' was here", _tmp531_);
					_tmp533_ = _tmp532_;
					vala_report_notice (_tmp527_, _tmp533_);
					_g_free0 (_tmp533_);
					_g_free0 (_tmp531_);
					result = FALSE;
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (_m_list);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
	}
	_tmp534_ = vala_code_context_get_analyzer (context);
	_tmp535_ = _tmp534_;
	_tmp536_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp535_, _tmp536_);
	_tmp537_ = vala_code_context_get_analyzer (context);
	_tmp538_ = _tmp537_;
	_tmp539_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp538_, _tmp539_);
	_tmp543_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp544_ = _tmp543_;
	if (!_tmp544_) {
		gboolean _tmp545_;
		_tmp545_ = self->priv->_overrides;
		_tmp542_ = !_tmp545_;
	} else {
		_tmp542_ = FALSE;
	}
	if (_tmp542_) {
		gboolean _tmp546_;
		gboolean _tmp547_;
		_tmp546_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp547_ = _tmp546_;
		_tmp541_ = !_tmp547_;
	} else {
		_tmp541_ = FALSE;
	}
	if (_tmp541_) {
		ValaSymbol* _tmp548_;
		ValaSymbol* _tmp549_;
		_tmp548_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp549_ = _tmp548_;
		_tmp540_ = _tmp549_ != NULL;
		_vala_code_node_unref0 (_tmp549_);
	} else {
		_tmp540_ = FALSE;
	}
	if (_tmp540_) {
		ValaSourceReference* _tmp550_;
		ValaSourceReference* _tmp551_;
		gchar* _tmp552_;
		gchar* _tmp553_;
		ValaSymbol* _tmp554_;
		ValaSymbol* _tmp555_;
		gchar* _tmp556_;
		gchar* _tmp557_;
		gchar* _tmp558_;
		gchar* _tmp559_;
		_tmp550_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp551_ = _tmp550_;
		_tmp552_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp553_ = _tmp552_;
		_tmp554_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp555_ = _tmp554_;
		_tmp556_ = vala_symbol_get_full_name (_tmp555_);
		_tmp557_ = _tmp556_;
		_tmp558_ = g_strdup_printf ("%s hides inherited method `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp553_, _tmp557_);
		_tmp559_ = _tmp558_;
		vala_report_warning (_tmp551_, _tmp559_);
		_g_free0 (_tmp559_);
		_g_free0 (_tmp557_);
		_vala_code_node_unref0 (_tmp555_);
		_g_free0 (_tmp553_);
	}
	_tmp560_ = vala_code_context_get_analyzer (context);
	_tmp561_ = _tmp560_;
	_tmp562_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp563_ = _tmp562_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp561_, (ValaSymbol*) self, _tmp563_)) {
		ValaSourceReference* _tmp564_;
		ValaSourceReference* _tmp565_;
		ValaDataType* _tmp566_;
		ValaDataType* _tmp567_;
		gchar* _tmp568_;
		gchar* _tmp569_;
		gchar* _tmp570_;
		gchar* _tmp571_;
		gchar* _tmp572_;
		gchar* _tmp573_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp564_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp565_ = _tmp564_;
		_tmp566_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp567_ = _tmp566_;
		_tmp568_ = vala_code_node_to_string ((ValaCodeNode*) _tmp567_);
		_tmp569_ = _tmp568_;
		_tmp570_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp571_ = _tmp570_;
		_tmp572_ = g_strdup_printf ("return type `%s' is less accessible than method `%s'", _tmp569_, _tmp571_);
		_tmp573_ = _tmp572_;
		vala_report_error (_tmp565_, _tmp573_);
		_g_free0 (_tmp573_);
		_g_free0 (_tmp571_);
		_g_free0 (_tmp569_);
		result = FALSE;
		_vala_code_node_unref0 (init_attr);
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp574_;
		ValaList* _tmp575_;
		gint _precondition_size = 0;
		ValaList* _tmp576_;
		gint _tmp577_;
		gint _tmp578_;
		gint _precondition_index = 0;
		_tmp574_ = vala_method_get_preconditions (self);
		_tmp575_ = _vala_iterable_ref0 (_tmp574_);
		_precondition_list = _tmp575_;
		_tmp576_ = _precondition_list;
		_tmp577_ = vala_collection_get_size ((ValaCollection*) _tmp576_);
		_tmp578_ = _tmp577_;
		_precondition_size = _tmp578_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp579_;
			gint _tmp580_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp581_;
			gpointer _tmp582_;
			ValaExpression* _tmp583_;
			gboolean _tmp584_;
			gboolean _tmp585_;
			ValaExpression* _tmp586_;
			ValaDataType* _tmp587_;
			ValaDataType* _tmp588_;
			ValaSemanticAnalyzer* _tmp589_;
			ValaSemanticAnalyzer* _tmp590_;
			ValaDataType* _tmp591_;
			_precondition_index = _precondition_index + 1;
			_tmp579_ = _precondition_index;
			_tmp580_ = _precondition_size;
			if (!(_tmp579_ < _tmp580_)) {
				break;
			}
			_tmp581_ = _precondition_list;
			_tmp582_ = vala_list_get (_tmp581_, _precondition_index);
			precondition = (ValaExpression*) _tmp582_;
			_tmp583_ = precondition;
			_tmp584_ = vala_code_node_get_error ((ValaCodeNode*) _tmp583_);
			_tmp585_ = _tmp584_;
			if (_tmp585_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp586_ = precondition;
			_tmp587_ = vala_expression_get_value_type (_tmp586_);
			_tmp588_ = _tmp587_;
			_tmp589_ = vala_code_context_get_analyzer (context);
			_tmp590_ = _tmp589_;
			_tmp591_ = _tmp590_->bool_type;
			if (!vala_data_type_compatible (_tmp588_, _tmp591_)) {
				ValaExpression* _tmp592_;
				ValaSourceReference* _tmp593_;
				ValaSourceReference* _tmp594_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp592_ = precondition;
				_tmp593_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp592_);
				_tmp594_ = _tmp593_;
				vala_report_error (_tmp594_, "Precondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp595_;
		ValaList* _tmp596_;
		gint _postcondition_size = 0;
		ValaList* _tmp597_;
		gint _tmp598_;
		gint _tmp599_;
		gint _postcondition_index = 0;
		_tmp595_ = vala_method_get_postconditions (self);
		_tmp596_ = _vala_iterable_ref0 (_tmp595_);
		_postcondition_list = _tmp596_;
		_tmp597_ = _postcondition_list;
		_tmp598_ = vala_collection_get_size ((ValaCollection*) _tmp597_);
		_tmp599_ = _tmp598_;
		_postcondition_size = _tmp599_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp600_;
			gint _tmp601_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp602_;
			gpointer _tmp603_;
			ValaExpression* _tmp604_;
			gboolean _tmp605_;
			gboolean _tmp606_;
			ValaExpression* _tmp607_;
			ValaDataType* _tmp608_;
			ValaDataType* _tmp609_;
			ValaSemanticAnalyzer* _tmp610_;
			ValaSemanticAnalyzer* _tmp611_;
			ValaDataType* _tmp612_;
			_postcondition_index = _postcondition_index + 1;
			_tmp600_ = _postcondition_index;
			_tmp601_ = _postcondition_size;
			if (!(_tmp600_ < _tmp601_)) {
				break;
			}
			_tmp602_ = _postcondition_list;
			_tmp603_ = vala_list_get (_tmp602_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp603_;
			_tmp604_ = postcondition;
			_tmp605_ = vala_code_node_get_error ((ValaCodeNode*) _tmp604_);
			_tmp606_ = _tmp605_;
			if (_tmp606_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp607_ = postcondition;
			_tmp608_ = vala_expression_get_value_type (_tmp607_);
			_tmp609_ = _tmp608_;
			_tmp610_ = vala_code_context_get_analyzer (context);
			_tmp611_ = _tmp610_;
			_tmp612_ = _tmp611_->bool_type;
			if (!vala_data_type_compatible (_tmp609_, _tmp612_)) {
				ValaExpression* _tmp613_;
				ValaSourceReference* _tmp614_;
				ValaSourceReference* _tmp615_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp613_ = postcondition;
				_tmp614_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp613_);
				_tmp615_ = _tmp614_;
				vala_report_error (_tmp615_, "Postcondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp617_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp618_ = _tmp617_;
	if (_tmp618_ != NULL) {
		ValaBlock* _tmp619_;
		ValaBlock* _tmp620_;
		gboolean _tmp621_;
		gboolean _tmp622_;
		_tmp619_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp620_ = _tmp619_;
		_tmp621_ = vala_code_node_get_error ((ValaCodeNode*) _tmp620_);
		_tmp622_ = _tmp621_;
		_tmp616_ = !_tmp622_;
	} else {
		_tmp616_ = FALSE;
	}
	if (_tmp616_) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp623_;
		ValaArrayList* _tmp624_;
		ValaBlock* _tmp625_;
		ValaBlock* _tmp626_;
		ValaArrayList* _tmp627_;
		_tmp623_ = g_direct_equal;
		_tmp624_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp623_);
		body_errors = _tmp624_;
		_tmp625_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp626_ = _tmp625_;
		_tmp627_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp626_, (ValaCollection*) _tmp627_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp628_;
			ValaArrayList* _tmp629_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp630_;
			gint _tmp631_;
			gint _tmp632_;
			gint _body_error_type_index = 0;
			_tmp628_ = body_errors;
			_tmp629_ = _vala_iterable_ref0 (_tmp628_);
			_body_error_type_list = _tmp629_;
			_tmp630_ = _body_error_type_list;
			_tmp631_ = vala_collection_get_size ((ValaCollection*) _tmp630_);
			_tmp632_ = _tmp631_;
			_body_error_type_size = _tmp632_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp633_;
				gint _tmp634_;
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp635_;
				gpointer _tmp636_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp637_;
				gboolean _tmp649_ = FALSE;
				ValaDataType* _tmp650_;
				gboolean is_dynamic_error = FALSE;
				gboolean _tmp654_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				_tmp633_ = _body_error_type_index;
				_tmp634_ = _body_error_type_size;
				if (!(_tmp633_ < _tmp634_)) {
					break;
				}
				_tmp635_ = _body_error_type_list;
				_tmp636_ = vala_list_get ((ValaList*) _tmp635_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp636_;
				can_propagate_error = FALSE;
				_tmp637_ = self->error_types;
				if (_tmp637_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp638_;
						ValaList* _tmp639_;
						gint _method_error_type_size = 0;
						ValaList* _tmp640_;
						gint _tmp641_;
						gint _tmp642_;
						gint _method_error_type_index = 0;
						_tmp638_ = self->error_types;
						_tmp639_ = _vala_iterable_ref0 (_tmp638_);
						_method_error_type_list = _tmp639_;
						_tmp640_ = _method_error_type_list;
						_tmp641_ = vala_collection_get_size ((ValaCollection*) _tmp640_);
						_tmp642_ = _tmp641_;
						_method_error_type_size = _tmp642_;
						_method_error_type_index = -1;
						while (TRUE) {
							gint _tmp643_;
							gint _tmp644_;
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp645_;
							gpointer _tmp646_;
							ValaDataType* _tmp647_;
							ValaDataType* _tmp648_;
							_method_error_type_index = _method_error_type_index + 1;
							_tmp643_ = _method_error_type_index;
							_tmp644_ = _method_error_type_size;
							if (!(_tmp643_ < _tmp644_)) {
								break;
							}
							_tmp645_ = _method_error_type_list;
							_tmp646_ = vala_list_get (_tmp645_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp646_;
							_tmp647_ = body_error_type;
							_tmp648_ = method_error_type;
							if (vala_data_type_compatible (_tmp647_, _tmp648_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				_tmp650_ = body_error_type;
				if (VALA_IS_ERROR_TYPE (_tmp650_)) {
					ValaDataType* _tmp651_;
					gboolean _tmp652_;
					gboolean _tmp653_;
					_tmp651_ = body_error_type;
					_tmp652_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp651_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp653_ = _tmp652_;
					_tmp649_ = _tmp653_;
				} else {
					_tmp649_ = FALSE;
				}
				is_dynamic_error = _tmp649_;
				if (!can_propagate_error) {
					_tmp654_ = !is_dynamic_error;
				} else {
					_tmp654_ = FALSE;
				}
				if (_tmp654_) {
					ValaDataType* _tmp655_;
					ValaSourceReference* _tmp656_;
					ValaSourceReference* _tmp657_;
					ValaDataType* _tmp658_;
					gchar* _tmp659_;
					gchar* _tmp660_;
					gchar* _tmp661_;
					gchar* _tmp662_;
					_tmp655_ = body_error_type;
					_tmp656_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp655_);
					_tmp657_ = _tmp656_;
					_tmp658_ = body_error_type;
					_tmp659_ = vala_code_node_to_string ((ValaCodeNode*) _tmp658_);
					_tmp660_ = _tmp659_;
					_tmp661_ = g_strdup_printf ("unhandled error `%s'", _tmp660_);
					_tmp662_ = _tmp661_;
					vala_report_warning (_tmp657_, _tmp662_);
					_g_free0 (_tmp662_);
					_g_free0 (_tmp660_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	if (!VALA_IS_CREATION_METHOD (self)) {
		ValaMemberBinding _tmp668_;
		_tmp668_ = self->priv->_binding;
		_tmp667_ = _tmp668_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp667_ = FALSE;
	}
	if (_tmp667_) {
		gboolean _tmp669_;
		_tmp669_ = self->priv->_overrides;
		_tmp666_ = !_tmp669_;
	} else {
		_tmp666_ = FALSE;
	}
	if (_tmp666_) {
		ValaSymbolAccessibility _tmp670_;
		ValaSymbolAccessibility _tmp671_;
		_tmp670_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp671_ = _tmp670_;
		_tmp665_ = _tmp671_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp665_ = FALSE;
	}
	if (_tmp665_) {
		ValaSymbol* _tmp672_;
		ValaSymbol* _tmp673_;
		_tmp672_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp673_ = _tmp672_;
		_tmp664_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp673_);
	} else {
		_tmp664_ = FALSE;
	}
	if (_tmp664_) {
		ValaSymbol* _tmp674_;
		ValaSymbol* _tmp675_;
		ValaAttribute* _tmp676_;
		_tmp674_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp675_ = _tmp674_;
		_tmp676_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp675_, "DBus");
		_tmp663_ = _tmp676_ != NULL;
	} else {
		_tmp663_ = FALSE;
	}
	if (_tmp663_) {
		ValaAttribute* dbus_attr = NULL;
		ValaAttribute* _tmp677_;
		ValaAttribute* _tmp678_;
		gboolean _tmp679_ = FALSE;
		ValaAttribute* _tmp680_;
		_tmp677_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DBus");
		_tmp678_ = _vala_code_node_ref0 (_tmp677_);
		dbus_attr = _tmp678_;
		_tmp680_ = dbus_attr;
		if (_tmp680_ == NULL) {
			_tmp679_ = TRUE;
		} else {
			ValaAttribute* _tmp681_;
			_tmp681_ = dbus_attr;
			_tmp679_ = vala_attribute_get_bool (_tmp681_, "visible", TRUE);
		}
		if (_tmp679_) {
			gboolean throws_gerror = FALSE;
			gboolean throws_gioerror = FALSE;
			gboolean throws_gdbuserror = FALSE;
			ValaArrayList* error_types = NULL;
			GEqualFunc _tmp682_;
			ValaArrayList* _tmp683_;
			ValaArrayList* _tmp684_;
			gboolean _tmp703_ = FALSE;
			throws_gerror = FALSE;
			throws_gioerror = FALSE;
			throws_gdbuserror = FALSE;
			_tmp682_ = g_direct_equal;
			_tmp683_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp682_);
			error_types = _tmp683_;
			_tmp684_ = error_types;
			vala_code_node_get_error_types ((ValaCodeNode*) self, (ValaCollection*) _tmp684_, NULL);
			{
				ValaArrayList* _error_type_list = NULL;
				ValaArrayList* _tmp685_;
				ValaArrayList* _tmp686_;
				gint _error_type_size = 0;
				ValaArrayList* _tmp687_;
				gint _tmp688_;
				gint _tmp689_;
				gint _error_type_index = 0;
				_tmp685_ = error_types;
				_tmp686_ = _vala_iterable_ref0 (_tmp685_);
				_error_type_list = _tmp686_;
				_tmp687_ = _error_type_list;
				_tmp688_ = vala_collection_get_size ((ValaCollection*) _tmp687_);
				_tmp689_ = _tmp688_;
				_error_type_size = _tmp689_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp690_;
					gint _tmp691_;
					ValaDataType* error_type = NULL;
					ValaArrayList* _tmp692_;
					gpointer _tmp693_;
					ValaDataType* _tmp694_;
					ValaErrorDomain* error_domain = NULL;
					ValaDataType* _tmp695_;
					ValaErrorDomain* _tmp696_;
					ValaErrorDomain* _tmp697_;
					ValaErrorDomain* _tmp698_;
					gchar* full_error_domain = NULL;
					ValaErrorDomain* _tmp699_;
					gchar* _tmp700_;
					const gchar* _tmp701_;
					_error_type_index = _error_type_index + 1;
					_tmp690_ = _error_type_index;
					_tmp691_ = _error_type_size;
					if (!(_tmp690_ < _tmp691_)) {
						break;
					}
					_tmp692_ = _error_type_list;
					_tmp693_ = vala_list_get ((ValaList*) _tmp692_, _error_type_index);
					error_type = (ValaDataType*) _tmp693_;
					_tmp694_ = error_type;
					if (!VALA_IS_ERROR_TYPE (_tmp694_)) {
						_vala_code_node_unref0 (error_type);
						continue;
					}
					_tmp695_ = error_type;
					_tmp696_ = vala_error_type_get_error_domain (G_TYPE_CHECK_INSTANCE_CAST (_tmp695_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp697_ = _tmp696_;
					error_domain = _tmp697_;
					_tmp698_ = error_domain;
					if (_tmp698_ == NULL) {
						throws_gerror = TRUE;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp699_ = error_domain;
					_tmp700_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp699_);
					full_error_domain = _tmp700_;
					_tmp701_ = full_error_domain;
					if (g_strcmp0 (_tmp701_, "GLib.IOError") == 0) {
						throws_gioerror = TRUE;
					} else {
						const gchar* _tmp702_;
						_tmp702_ = full_error_domain;
						if (g_strcmp0 (_tmp702_, "GLib.DBusError") == 0) {
							throws_gdbuserror = TRUE;
						}
					}
					_g_free0 (full_error_domain);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			if (!throws_gerror) {
				gboolean _tmp704_ = FALSE;
				if (throws_gioerror) {
					_tmp704_ = throws_gdbuserror;
				} else {
					_tmp704_ = FALSE;
				}
				_tmp703_ = !_tmp704_;
			} else {
				_tmp703_ = FALSE;
			}
			if (_tmp703_) {
				ValaSourceReference* _tmp705_;
				ValaSourceReference* _tmp706_;
				_tmp705_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp706_ = _tmp705_;
				vala_report_warning (_tmp706_, "DBus methods are recommended to throw at least `GLib.Error' or `GLib.D" \
"BusError, GLib.IOError'");
			}
			_vala_iterable_unref0 (error_types);
		}
		_vala_code_node_unref0 (dbus_attr);
	}
	if (vala_method_is_possible_entry_point (self, context)) {
		ValaMethod* _tmp707_;
		ValaMethod* _tmp708_;
		gboolean _tmp717_;
		gboolean _tmp718_;
		gboolean _tmp721_;
		gboolean _tmp724_;
		_tmp707_ = vala_code_context_get_entry_point (context);
		_tmp708_ = _tmp707_;
		if (_tmp708_ != NULL) {
			ValaSourceReference* _tmp709_;
			ValaSourceReference* _tmp710_;
			ValaMethod* _tmp711_;
			ValaMethod* _tmp712_;
			gchar* _tmp713_;
			gchar* _tmp714_;
			gchar* _tmp715_;
			gchar* _tmp716_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp709_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp710_ = _tmp709_;
			_tmp711_ = vala_code_context_get_entry_point (context);
			_tmp712_ = _tmp711_;
			_tmp713_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp712_);
			_tmp714_ = _tmp713_;
			_tmp715_ = g_strdup_printf ("program already has an entry point `%s'", _tmp714_);
			_tmp716_ = _tmp715_;
			vala_report_error (_tmp710_, _tmp716_);
			_g_free0 (_tmp716_);
			_g_free0 (_tmp714_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		vala_method_set_entry_point (self, TRUE);
		vala_code_context_set_entry_point (context, self);
		_tmp717_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp718_ = _tmp717_;
		if (_tmp718_) {
			ValaSourceReference* _tmp719_;
			ValaSourceReference* _tmp720_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp719_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp720_ = _tmp719_;
			vala_report_error (_tmp720_, "\"main\" method cannot throw errors");
		}
		_tmp721_ = self->priv->_is_inline;
		if (_tmp721_) {
			ValaSourceReference* _tmp722_;
			ValaSourceReference* _tmp723_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp722_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp723_ = _tmp722_;
			vala_report_error (_tmp723_, "\"main\" method cannot be inline");
		}
		_tmp724_ = self->priv->_coroutine;
		if (_tmp724_) {
			ValaSourceReference* _tmp725_;
			ValaSourceReference* _tmp726_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp725_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp726_ = _tmp725_;
			vala_report_error (_tmp726_, "\"main\" method cannot be async");
		}
	}
	_tmp727_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkCallback");
	if (_tmp727_ != NULL) {
		vala_symbol_set_used ((ValaSymbol*) self, TRUE);
	}
	_tmp728_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp729_ = _tmp728_;
	result = !_tmp729_;
	_vala_code_node_unref0 (init_attr);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static gboolean
vala_method_is_possible_entry_point (ValaMethod* self,
                                     ValaCodeContext* context)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaMemberBinding _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaList* params = NULL;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	ValaList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	ValaList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	ValaIterator* params_it = NULL;
	ValaList* _tmp34_;
	ValaIterator* _tmp35_;
	ValaIterator* _tmp36_;
	ValaParameter* param = NULL;
	ValaIterator* _tmp37_;
	gpointer _tmp38_;
	ValaParameter* _tmp39_;
	ValaParameterDirection _tmp40_;
	ValaParameterDirection _tmp41_;
	ValaParameter* _tmp42_;
	ValaDataType* _tmp43_;
	ValaDataType* _tmp44_;
	ValaArrayType* array_type = NULL;
	ValaParameter* _tmp45_;
	ValaDataType* _tmp46_;
	ValaDataType* _tmp47_;
	ValaArrayType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSemanticAnalyzer* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_get_entry_point_name (context);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp4_ = g_strcmp0 (_tmp8_, "main") != 0;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_entry_point_name (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = self->priv->_binding;
	if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (VALA_IS_VOID_TYPE (_tmp16_)) {
	} else {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaDataType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_type_symbol (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->int_type;
		_tmp24_ = vala_data_type_get_type_symbol (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp20_ == _tmp25_) {
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp26_ = vala_callable_get_parameters ((ValaCallable*) self);
	_tmp27_ = _vala_iterable_ref0 (_tmp26_);
	params = _tmp27_;
	_tmp28_ = params;
	_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == 0) {
		result = TRUE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp31_ = params;
	_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ > 1) {
		result = FALSE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp34_ = params;
	_tmp35_ = vala_iterable_iterator ((ValaIterable*) _tmp34_);
	params_it = _tmp35_;
	_tmp36_ = params_it;
	vala_iterator_next (_tmp36_);
	_tmp37_ = params_it;
	_tmp38_ = vala_iterator_get (_tmp37_);
	param = (ValaParameter*) _tmp38_;
	_tmp39_ = param;
	_tmp40_ = vala_parameter_get_direction (_tmp39_);
	_tmp41_ = _tmp40_;
	if (_tmp41_ == VALA_PARAMETER_DIRECTION_OUT) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp42_ = param;
	_tmp43_ = vala_variable_get_variable_type ((ValaVariable*) _tmp42_);
	_tmp44_ = _tmp43_;
	if (!VALA_IS_ARRAY_TYPE (_tmp44_)) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp45_ = param;
	_tmp46_ = vala_variable_get_variable_type ((ValaVariable*) _tmp45_);
	_tmp47_ = _tmp46_;
	array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
	_tmp48_ = array_type;
	_tmp49_ = vala_array_type_get_element_type (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_data_type_get_type_symbol (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_context_get_analyzer (context);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->string_type;
	_tmp56_ = vala_data_type_get_type_symbol (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp52_ != _tmp57_) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (param);
	_vala_iterator_unref0 (params_it);
	_vala_iterable_unref0 (params);
	return result;
}

gint
vala_method_get_required_arguments (ValaMethod* self)
{
	gint n = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			ValaParameter* _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gint _tmp16_;
			_param_index = _param_index + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = vala_list_get (_tmp7_, _param_index);
			param = (ValaParameter*) _tmp8_;
			_tmp10_ = param;
			_tmp11_ = vala_variable_get_initializer ((ValaVariable*) _tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != NULL) {
				_tmp9_ = TRUE;
			} else {
				ValaParameter* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				_tmp13_ = param;
				_tmp14_ = vala_parameter_get_ellipsis (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = _tmp15_;
			}
			if (_tmp9_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp16_ = n;
			n = _tmp16_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = n;
	return result;
}

ValaMethod*
vala_method_get_end_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp36_;
	ValaMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->end_method;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaMethod* _tmp35_;
		_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_method_new ("end", _tmp3_, _tmp5_, NULL);
		_vala_code_node_unref0 (self->priv->end_method);
		self->priv->end_method = _tmp6_;
		_tmp7_ = self->priv->end_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->end_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
		_tmp9_ = self->priv->end_method;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp9_, _tmp11_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_method_get_async_end_parameters (self);
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				ValaParameter* param = NULL;
				ValaList* _tmp18_;
				gpointer _tmp19_;
				ValaMethod* _tmp20_;
				ValaParameter* _tmp21_;
				ValaParameter* _tmp22_;
				ValaParameter* _tmp23_;
				_param_index = _param_index + 1;
				_tmp16_ = _param_index;
				_tmp17_ = _param_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _param_list;
				_tmp19_ = vala_list_get (_tmp18_, _param_index);
				param = (ValaParameter*) _tmp19_;
				_tmp20_ = self->priv->end_method;
				_tmp21_ = param;
				_tmp22_ = vala_parameter_copy (_tmp21_);
				_tmp23_ = _tmp22_;
				vala_callable_add_parameter ((ValaCallable*) _tmp20_, _tmp23_);
				_vala_code_node_unref0 (_tmp23_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp24_;
			ValaList* _tmp25_;
			gint _param_size = 0;
			ValaList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _param_index = 0;
			_tmp24_ = vala_method_get_type_parameters (self);
			_tmp25_ = _vala_iterable_ref0 (_tmp24_);
			_param_list = _tmp25_;
			_tmp26_ = _param_list;
			_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_param_size = _tmp28_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp29_;
				gint _tmp30_;
				ValaTypeParameter* param = NULL;
				ValaList* _tmp31_;
				gpointer _tmp32_;
				ValaMethod* _tmp33_;
				ValaTypeParameter* _tmp34_;
				_param_index = _param_index + 1;
				_tmp29_ = _param_index;
				_tmp30_ = _param_size;
				if (!(_tmp29_ < _tmp30_)) {
					break;
				}
				_tmp31_ = _param_list;
				_tmp32_ = vala_list_get (_tmp31_, _param_index);
				param = (ValaTypeParameter*) _tmp32_;
				_tmp33_ = self->priv->end_method;
				_tmp34_ = param;
				vala_method_add_type_parameter (_tmp33_, _tmp34_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp35_ = self->priv->end_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp35_, (ValaCodeNode*) self, "CCode", "async_result_pos");
	}
	_tmp36_ = self->priv->end_method;
	result = _tmp36_;
	return result;
}

ValaMethod*
vala_method_get_callback_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp24_;
	ValaMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->callback_method;
	if (_tmp1_ == NULL) {
		ValaBooleanType* bool_type = NULL;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaNamespace* _tmp4_;
		ValaNamespace* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaBooleanType* _tmp10_;
		ValaBooleanType* _tmp11_;
		ValaBooleanType* _tmp12_;
		ValaBooleanType* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		ValaMethod* _tmp23_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_scope_lookup (_tmp7_, "bool");
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp10_ = vala_boolean_type_new (_tmp9_);
		_tmp11_ = _tmp10_;
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_context_unref0 (_tmp3_);
		bool_type = _tmp11_;
		_tmp12_ = bool_type;
		vala_data_type_set_value_owned ((ValaDataType*) _tmp12_, TRUE);
		_tmp13_ = bool_type;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_new ("callback", (ValaDataType*) _tmp13_, _tmp15_, NULL);
		_vala_code_node_unref0 (self->priv->callback_method);
		self->priv->callback_method = _tmp16_;
		_tmp17_ = self->priv->callback_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp17_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp18_ = self->priv->callback_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp18_, TRUE);
		_tmp19_ = self->priv->callback_method;
		vala_method_set_binding (_tmp19_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp20_ = self->priv->callback_method;
		_tmp21_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp20_, _tmp22_);
		_tmp23_ = self->priv->callback_method;
		vala_method_set_is_async_callback (_tmp23_, TRUE);
		_vala_code_node_unref0 (bool_type);
	}
	_tmp24_ = self->priv->callback_method;
	result = _tmp24_;
	return result;
}

ValaList*
vala_method_get_async_begin_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaParameter* ellipsis = NULL;
	ValaDelegateType* callback_type = NULL;
	ValaSymbol* _tmp30_;
	ValaScope* _tmp31_;
	ValaScope* _tmp32_;
	ValaSymbol* _tmp33_;
	ValaDelegate* _tmp34_;
	ValaDelegateType* _tmp35_;
	ValaDelegateType* _tmp36_;
	ValaDelegateType* _tmp37_;
	ValaSourceReference* _tmp38_;
	ValaSourceReference* _tmp39_;
	ValaDelegateType* _tmp40_;
	ValaDelegateType* _tmp41_;
	ValaDelegateType* _tmp42_;
	ValaParameter* callback_param = NULL;
	ValaDelegateType* _tmp43_;
	ValaSourceReference* _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaParameter* _tmp46_;
	ValaParameter* _tmp47_;
	ValaSourceReference* _tmp48_;
	ValaSourceReference* _tmp49_;
	ValaNullLiteral* _tmp50_;
	ValaNullLiteral* _tmp51_;
	ValaParameter* _tmp52_;
	ValaExpression* _tmp53_;
	ValaExpression* _tmp54_;
	ValaDelegateType* _tmp55_;
	ValaDataType* _tmp56_;
	ValaDataType* _tmp57_;
	ValaParameter* _tmp58_;
	ValaParameter* _tmp59_;
	ValaArrayList* _tmp60_;
	ValaParameter* _tmp61_;
	ValaParameter* _tmp62_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = vala_code_context_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_scope_lookup (_tmp6_, "GLib");
	_tmp8_ = _tmp7_;
	_vala_code_context_unref0 (_tmp2_);
	glib_ns = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	params = _tmp10_;
	ellipsis = NULL;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _param_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _param_index = 0;
		_tmp11_ = self->priv->parameters;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_param_list = _tmp12_;
		_tmp13_ = _param_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_param_size = _tmp15_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			ValaParameter* param = NULL;
			ValaList* _tmp18_;
			gpointer _tmp19_;
			ValaParameter* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			_param_index = _param_index + 1;
			_tmp16_ = _param_index;
			_tmp17_ = _param_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _param_list;
			_tmp19_ = vala_list_get (_tmp18_, _param_index);
			param = (ValaParameter*) _tmp19_;
			_tmp20_ = param;
			_tmp21_ = vala_parameter_get_ellipsis (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_) {
				ValaParameter* _tmp23_;
				ValaParameter* _tmp24_;
				_tmp23_ = param;
				_tmp24_ = _vala_code_node_ref0 (_tmp23_);
				_vala_code_node_unref0 (ellipsis);
				ellipsis = _tmp24_;
			} else {
				ValaParameter* _tmp25_;
				ValaParameterDirection _tmp26_;
				ValaParameterDirection _tmp27_;
				_tmp25_ = param;
				_tmp26_ = vala_parameter_get_direction (_tmp25_);
				_tmp27_ = _tmp26_;
				if (_tmp27_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaArrayList* _tmp28_;
					ValaParameter* _tmp29_;
					_tmp28_ = params;
					_tmp29_ = param;
					vala_collection_add ((ValaCollection*) _tmp28_, _tmp29_);
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp30_ = glib_ns;
	_tmp31_ = vala_symbol_get_scope (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_scope_lookup (_tmp32_, "AsyncReadyCallback");
	_tmp34_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALA_TYPE_DELEGATE, ValaDelegate);
	_tmp35_ = vala_delegate_type_new (_tmp34_);
	_tmp36_ = _tmp35_;
	_vala_code_node_unref0 (_tmp34_);
	callback_type = _tmp36_;
	_tmp37_ = callback_type;
	_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp39_ = _tmp38_;
	vala_code_node_set_source_reference ((ValaCodeNode*) _tmp37_, _tmp39_);
	_tmp40_ = callback_type;
	vala_data_type_set_nullable ((ValaDataType*) _tmp40_, TRUE);
	_tmp41_ = callback_type;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp41_, TRUE);
	_tmp42_ = callback_type;
	vala_delegate_type_set_is_called_once (_tmp42_, TRUE);
	_tmp43_ = callback_type;
	_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_parameter_new ("_callback_", (ValaDataType*) _tmp43_, _tmp45_);
	callback_param = _tmp46_;
	_tmp47_ = callback_param;
	_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_null_literal_new (_tmp49_);
	_tmp51_ = _tmp50_;
	vala_variable_set_initializer ((ValaVariable*) _tmp47_, (ValaExpression*) _tmp51_);
	_vala_code_node_unref0 (_tmp51_);
	_tmp52_ = callback_param;
	_tmp53_ = vala_variable_get_initializer ((ValaVariable*) _tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = callback_type;
	_tmp56_ = vala_data_type_copy ((ValaDataType*) _tmp55_);
	_tmp57_ = _tmp56_;
	vala_expression_set_target_type (_tmp54_, _tmp57_);
	_vala_code_node_unref0 (_tmp57_);
	_tmp58_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp58_, "CCode", "pos", (gdouble) -1, NULL);
	_tmp59_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp59_, "CCode", "delegate_target_pos", -0.9, NULL);
	_tmp60_ = params;
	_tmp61_ = callback_param;
	vala_collection_add ((ValaCollection*) _tmp60_, _tmp61_);
	_tmp62_ = ellipsis;
	if (_tmp62_ != NULL) {
		ValaArrayList* _tmp63_;
		ValaParameter* _tmp64_;
		_tmp63_ = params;
		_tmp64_ = ellipsis;
		vala_collection_add ((ValaCollection*) _tmp63_, _tmp64_);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (callback_param);
	_vala_code_node_unref0 (callback_type);
	_vala_code_node_unref0 (ellipsis);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

ValaList*
vala_method_get_async_end_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp3_;
	ValaCodeContext* _tmp4_;
	ValaNamespace* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaObjectType* result_type = NULL;
	ValaSymbol* _tmp11_;
	ValaScope* _tmp12_;
	ValaScope* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaObjectTypeSymbol* _tmp15_;
	ValaObjectType* _tmp16_;
	ValaObjectType* _tmp17_;
	ValaParameter* result_param = NULL;
	ValaObjectType* _tmp18_;
	ValaSourceReference* _tmp19_;
	ValaSourceReference* _tmp20_;
	ValaParameter* _tmp21_;
	ValaParameter* _tmp22_;
	ValaArrayList* _tmp23_;
	ValaParameter* _tmp24_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	params = _tmp2_;
	_tmp3_ = vala_code_context_get ();
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_code_context_get_root (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_scope_lookup (_tmp8_, "GLib");
	_tmp10_ = _tmp9_;
	_vala_code_context_unref0 (_tmp4_);
	glib_ns = _tmp10_;
	_tmp11_ = glib_ns;
	_tmp12_ = vala_symbol_get_scope (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_scope_lookup (_tmp13_, "AsyncResult");
	_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_tmp16_ = vala_object_type_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_code_node_unref0 (_tmp15_);
	result_type = _tmp17_;
	_tmp18_ = result_type;
	_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_parameter_new ("_res_", (ValaDataType*) _tmp18_, _tmp20_);
	result_param = _tmp21_;
	_tmp22_ = result_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp22_, "CCode", "pos", vala_code_node_get_attribute_double ((ValaCodeNode*) self, "CCode", "async_result_pos", 0.1), NULL);
	_tmp23_ = params;
	_tmp24_ = result_param;
	vala_collection_add ((ValaCollection*) _tmp23_, _tmp24_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp25_;
		ValaList* _tmp26_;
		gint _param_size = 0;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _param_index = 0;
		_tmp25_ = self->priv->parameters;
		_tmp26_ = _vala_iterable_ref0 (_tmp25_);
		_param_list = _tmp26_;
		_tmp27_ = _param_list;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_param_size = _tmp29_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			ValaParameter* param = NULL;
			ValaList* _tmp32_;
			gpointer _tmp33_;
			ValaParameter* _tmp34_;
			ValaParameterDirection _tmp35_;
			ValaParameterDirection _tmp36_;
			_param_index = _param_index + 1;
			_tmp30_ = _param_index;
			_tmp31_ = _param_size;
			if (!(_tmp30_ < _tmp31_)) {
				break;
			}
			_tmp32_ = _param_list;
			_tmp33_ = vala_list_get (_tmp32_, _param_index);
			param = (ValaParameter*) _tmp33_;
			_tmp34_ = param;
			_tmp35_ = vala_parameter_get_direction (_tmp34_);
			_tmp36_ = _tmp35_;
			if (_tmp36_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaArrayList* _tmp37_;
				ValaParameter* _tmp38_;
				_tmp37_ = params;
				_tmp38_ = param;
				vala_collection_add ((ValaCollection*) _tmp37_, _tmp38_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (result_param);
	_vala_code_node_unref0 (result_type);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

void
vala_method_add_captured_variable (ValaMethod* self,
                                   ValaLocalVariable* local)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->_closure;
	_vala_assert (_tmp0_, "this.closure");
	_tmp1_ = self->priv->captured_variables;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (self->priv->captured_variables);
		self->priv->captured_variables = (ValaList*) _tmp3_;
	}
	_tmp4_ = self->priv->captured_variables;
	vala_collection_add ((ValaCollection*) _tmp4_, local);
}

void
vala_method_get_captured_variables (ValaMethod* self,
                                    ValaCollection* variables)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = self->priv->captured_variables;
	if (_tmp0_ != NULL) {
		{
			ValaList* _local_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _local_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _local_index = 0;
			_tmp1_ = self->priv->captured_variables;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_local_list = _tmp2_;
			_tmp3_ = _local_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_local_size = _tmp5_;
			_local_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				ValaLocalVariable* local = NULL;
				ValaList* _tmp8_;
				gpointer _tmp9_;
				ValaLocalVariable* _tmp10_;
				_local_index = _local_index + 1;
				_tmp6_ = _local_index;
				_tmp7_ = _local_size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _local_list;
				_tmp9_ = vala_list_get (_tmp8_, _local_index);
				local = (ValaLocalVariable*) _tmp9_;
				_tmp10_ = local;
				vala_collection_add (variables, _tmp10_);
				_vala_code_node_unref0 (local);
			}
			_vala_iterable_unref0 (_local_list);
		}
	}
}

static void
vala_method_real_get_defined_variables (ValaCodeNode* base,
                                        ValaCollection* collection)
{
	ValaMethod * self;
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	ValaLocalVariable* _tmp4_;
	gboolean _tmp6_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaLocalVariable* _tmp2_;
		ValaLocalVariable* _tmp3_;
		_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp3_ = _tmp2_;
		vala_collection_add (collection, (ValaVariable*) _tmp3_);
	}
	_tmp4_ = self->priv->_params_array_var;
	if (_tmp4_ != NULL) {
		ValaLocalVariable* _tmp5_;
		_tmp5_ = self->priv->_params_array_var;
		vala_collection_add (collection, (ValaVariable*) _tmp5_);
	}
	_tmp6_ = self->priv->_closure;
	if (_tmp6_) {
		vala_method_get_captured_variables (self, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}

gint
vala_method_get_format_arg_index (ValaMethod* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaParameter* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->parameters;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->parameters;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaParameter*) _tmp6_;
				_tmp8_ = vala_parameter_get_format_arg (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp10_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_error_type_parameter (ValaMethod* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaMethod* _tmp4_;
	ValaMethod* _tmp5_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ValaMethod* _tmp12_;
	ValaMethod* _tmp13_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = vala_method_get_base_method (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		_tmp6_ = vala_method_get_base_method (self);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != self;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		_tmp8_ = vala_method_get_base_method (self);
		_tmp9_ = _tmp8_;
		_tmp2_ = vala_method_has_error_type_parameter (_tmp9_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp12_ = vala_method_get_base_interface_method (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		_tmp14_ = vala_method_get_base_interface_method (self);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_ != self;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		_tmp16_ = vala_method_get_base_interface_method (self);
		_tmp17_ = _tmp16_;
		_tmp10_ = vala_method_has_error_type_parameter (_tmp17_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
vala_method_class_init (ValaMethodClass * klass,
                        gpointer klass_data)
{
	vala_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_real_get_error_types;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_method_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_real_check;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_real_get_defined_variables;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_method_real_get_has_result;
}

static void
vala_method_vala_callable_interface_init (ValaCallableIface * iface,
                                          gpointer iface_data)
{
	vala_method_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_method_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_method_real_get_parameters;
	iface->get_return_type = vala_method_real_get_return_type;
	iface->set_return_type = vala_method_real_set_return_type;
}

static void
vala_method_instance_init (ValaMethod * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_method_finalize (ValaCodeNode * obj)
{
	ValaMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD, ValaMethod);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_code_node_unref0 (self->priv->_params_array_var);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_iterable_unref0 (self->priv->preconditions);
	_vala_iterable_unref0 (self->priv->postconditions);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_iterable_unref0 (self->error_types);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	_vala_code_node_unref0 (self->priv->callback_method);
	_vala_code_node_unref0 (self->priv->end_method);
	_vala_iterable_unref0 (self->priv->captured_variables);
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace method.
 */
static GType
vala_method_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
	static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_method_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_type_id;
	vala_method_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaMethod", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
	ValaMethod_private_offset = g_type_add_instance_private (vala_method_type_id, sizeof (ValaMethodPrivate));
	return vala_method_type_id;
}

GType
vala_method_get_type (void)
{
	static volatile gsize vala_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_type_id__volatile)) {
		GType vala_method_type_id;
		vala_method_type_id = vala_method_get_type_once ();
		g_once_init_leave (&vala_method_type_id__volatile, vala_method_type_id);
	}
	return vala_method_type_id__volatile;
}

