/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaAssignment_private_offset;
static gpointer vala_assignment_parent_class = NULL;

static void vala_assignment_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static gchar* vala_assignment_real_to_string (ValaCodeNode* base);
static void vala_assignment_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base,
                                             ValaSymbol* sym);
static void vala_assignment_real_get_error_types (ValaCodeNode* base,
                                           ValaCollection* collection,
                                           ValaSourceReference* source_reference);
static gboolean vala_assignment_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static void vala_assignment_check_constant_assignment (ValaAssignment* self,
                                                ValaMemberAccess* inner);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);
static GType vala_assignment_get_type_once (void);

static inline gpointer
vala_assignment_get_instance_private (ValaAssignment* self)
{
	return G_STRUCT_MEMBER_P (self, ValaAssignment_private_offset);
}

ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_assignment_set_left (ValaAssignment* self,
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_operator;
	return result;
}

void
vala_assignment_set_operator (ValaAssignment* self,
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_right (ValaAssignment* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type,
                           ValaExpression* left,
                           ValaExpression* right,
                           ValaAssignmentOperator operator,
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}

ValaAssignment*
vala_assignment_new (ValaExpression* left,
                     ValaExpression* right,
                     ValaAssignmentOperator operator,
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}

static void
vala_assignment_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_assignment_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static gchar*
vala_assignment_real_to_string (ValaCodeNode* base)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaAssignmentOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result = NULL;
	self = (ValaAssignment*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_assignment_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static void
vala_assignment_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}

static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_assignment_real_is_accessible (ValaExpression* base,
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_assignment_real_get_error_types (ValaCodeNode* base,
                                      ValaCollection* collection,
                                      ValaSourceReference* source_reference)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_assignment_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp93_;
	ValaExpression* _tmp94_;
	ValaExpression* _tmp95_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp97_;
	ValaExpression* _tmp98_;
	ValaExpression* _tmp242_;
	ValaExpression* _tmp243_;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp244_;
	ValaExpression* _tmp245_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp246_;
	ValaExpression* _tmp247_;
	gboolean transform_assignment = FALSE;
	gboolean _tmp248_ = FALSE;
	ValaMemberAccess* _tmp249_;
	gboolean _tmp277_ = FALSE;
	ValaAssignmentOperator _tmp278_;
	ValaMemberAccess* _tmp343_;
	ValaExpression* _tmp682_;
	ValaExpression* _tmp683_;
	ValaDataType* _tmp684_;
	ValaDataType* _tmp685_;
	ValaDataType* _tmp694_;
	ValaDataType* _tmp695_;
	gboolean _tmp698_;
	gboolean _tmp699_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (VALA_IS_TUPLE (_tmp7_)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_EXPRESSION_STATEMENT (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaSemanticAnalyzer* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaBlock* _tmp29_;
		ValaDeclarationStatement* _tmp30_;
		ValaDeclarationStatement* _tmp31_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp82_;
		ValaSemanticAnalyzer* _tmp83_;
		ValaList* _tmp84_;
		ValaCodeNode* _tmp85_;
		ValaCodeNode* _tmp86_;
		ValaExpressionStatement* _tmp87_;
		ValaExpression* _tmp88_;
		ValaExpression* _tmp89_;
		ValaExpressionStatement* _tmp90_;
		ValaExpression* _tmp91_;
		ValaExpression* _tmp92_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		tuple = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple);
		_tmp13_ = vala_code_node_get_temp_name ();
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_assignment_get_right (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_assignment_get_right (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (NULL, _tmp14_, _tmp16_, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp14_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = vala_code_context_get_analyzer (context);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_->insert_block;
		_tmp30_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp29_, (ValaStatement*) _tmp30_);
		_tmp31_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp31_, context);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp32_;
			ValaList* _tmp33_;
			ValaList* _tmp34_;
			gint _expr_size = 0;
			ValaList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _expr_index = 0;
			_tmp32_ = tuple;
			_tmp33_ = vala_tuple_get_expressions (_tmp32_);
			_tmp34_ = _vala_iterable_ref0 (_tmp33_);
			_expr_list = _tmp34_;
			_tmp35_ = _expr_list;
			_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_expr_size = _tmp37_;
			_expr_index = -1;
			while (TRUE) {
				gint _tmp38_;
				gint _tmp39_;
				ValaExpression* expr = NULL;
				ValaList* _tmp40_;
				gpointer _tmp41_;
				ValaExpressionStatement* _tmp42_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				ValaExpression* _tmp51_;
				ValaExpression* _tmp52_;
				ValaSourceReference* _tmp53_;
				ValaSourceReference* _tmp54_;
				ValaMemberAccess* _tmp55_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaSourceReference* _tmp58_;
				ValaSourceReference* _tmp59_;
				ValaElementAccess* _tmp60_;
				ValaElementAccess* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				ValaExpression* _tmp64_;
				ValaSourceReference* _tmp65_;
				ValaSourceReference* _tmp66_;
				ValaIntegerLiteral* _tmp67_;
				ValaIntegerLiteral* _tmp68_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp69_;
				ValaElementAccess* _tmp70_;
				ValaAssignmentOperator _tmp71_;
				ValaExpression* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaSourceReference* _tmp74_;
				ValaAssignment* _tmp75_;
				ValaAssignment* _tmp76_;
				ValaExpression* _tmp77_;
				ValaSourceReference* _tmp78_;
				ValaSourceReference* _tmp79_;
				ValaExpressionStatement* _tmp80_;
				gint _tmp81_;
				_expr_index = _expr_index + 1;
				_tmp38_ = _expr_index;
				_tmp39_ = _expr_size;
				if (!(_tmp38_ < _tmp39_)) {
					break;
				}
				_tmp40_ = _expr_list;
				_tmp41_ = vala_list_get (_tmp40_, _expr_index);
				expr = (ValaExpression*) _tmp41_;
				_tmp42_ = stmt;
				if (_tmp42_ != NULL) {
					ValaSemanticAnalyzer* _tmp43_;
					ValaSemanticAnalyzer* _tmp44_;
					ValaBlock* _tmp45_;
					ValaExpressionStatement* _tmp46_;
					ValaExpressionStatement* _tmp47_;
					_tmp43_ = vala_code_context_get_analyzer (context);
					_tmp44_ = _tmp43_;
					_tmp45_ = _tmp44_->insert_block;
					_tmp46_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp45_, (ValaStatement*) _tmp46_);
					_tmp47_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp47_, context);
				}
				_tmp48_ = local;
				_tmp49_ = vala_symbol_get_name ((ValaSymbol*) _tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = vala_assignment_get_right (self);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_member_access_new_simple (_tmp50_, _tmp54_);
				temp_access = _tmp55_;
				_tmp56_ = temp_access;
				_tmp57_ = expr;
				_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = vala_element_access_new ((ValaExpression*) _tmp56_, _tmp59_);
				ea = _tmp60_;
				_tmp61_ = ea;
				_tmp62_ = g_strdup_printf ("%i", i);
				_tmp63_ = _tmp62_;
				_tmp64_ = expr;
				_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = vala_integer_literal_new (_tmp63_, _tmp66_);
				_tmp68_ = _tmp67_;
				vala_element_access_append_index (_tmp61_, (ValaExpression*) _tmp68_);
				_vala_code_node_unref0 (_tmp68_);
				_g_free0 (_tmp63_);
				_tmp69_ = expr;
				_tmp70_ = ea;
				_tmp71_ = self->priv->_operator;
				_tmp72_ = expr;
				_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_assignment_new (_tmp69_, (ValaExpression*) _tmp70_, _tmp71_, _tmp74_);
				assign = _tmp75_;
				_tmp76_ = assign;
				_tmp77_ = expr;
				_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = vala_expression_statement_new ((ValaExpression*) _tmp76_, _tmp79_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp80_;
				_tmp81_ = i;
				i = _tmp81_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp82_ = vala_code_context_get_analyzer (context);
		_tmp83_ = _tmp82_;
		_tmp84_ = _tmp83_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp84_, (ValaCodeNode*) self);
		_tmp85_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp86_ = _tmp85_;
		_tmp87_ = stmt;
		_tmp88_ = vala_expression_statement_get_expression (_tmp87_);
		_tmp89_ = _tmp88_;
		vala_code_node_replace_expression (_tmp86_, (ValaExpression*) self, _tmp89_);
		_tmp90_ = stmt;
		_tmp91_ = vala_expression_statement_get_expression (_tmp90_);
		_tmp92_ = _tmp91_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp92_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp93_ = vala_assignment_get_left (self);
	_tmp94_ = _tmp93_;
	vala_expression_set_lvalue (_tmp94_, TRUE);
	_tmp95_ = vala_assignment_get_left (self);
	_tmp96_ = _tmp95_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp96_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp97_ = vala_assignment_get_left (self);
	_tmp98_ = _tmp97_;
	if (VALA_IS_MEMBER_ACCESS (_tmp98_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp99_;
		ValaExpression* _tmp100_;
		ValaMemberAccess* _tmp101_;
		gboolean _tmp102_ = FALSE;
		gboolean _tmp103_ = FALSE;
		ValaMemberAccess* _tmp104_;
		ValaSymbol* _tmp105_;
		ValaSymbol* _tmp106_;
		ValaMemberAccess* _tmp122_;
		gboolean _tmp123_;
		gboolean _tmp124_;
		gboolean _tmp134_ = FALSE;
		ValaMemberAccess* _tmp135_;
		gboolean _tmp136_;
		gboolean _tmp137_;
		ValaMemberAccess* _tmp141_;
		ValaSymbol* _tmp142_;
		ValaSymbol* _tmp143_;
		_tmp99_ = vala_assignment_get_left (self);
		_tmp100_ = _tmp99_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp101_ = ma;
		vala_assignment_check_constant_assignment (self, _tmp101_);
		_tmp104_ = ma;
		_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp104_);
		_tmp106_ = _tmp105_;
		if (!VALA_IS_DYNAMIC_PROPERTY (_tmp106_)) {
			ValaMemberAccess* _tmp107_;
			ValaDataType* _tmp108_;
			ValaDataType* _tmp109_;
			_tmp107_ = ma;
			_tmp108_ = vala_expression_get_value_type ((ValaExpression*) _tmp107_);
			_tmp109_ = _tmp108_;
			_tmp103_ = _tmp109_ == NULL;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			_tmp102_ = TRUE;
		} else {
			gboolean _tmp110_ = FALSE;
			gboolean _tmp111_ = FALSE;
			ValaMemberAccess* _tmp112_;
			ValaExpression* _tmp113_;
			ValaExpression* _tmp114_;
			_tmp112_ = ma;
			_tmp113_ = vala_member_access_get_inner (_tmp112_);
			_tmp114_ = _tmp113_;
			if (_tmp114_ == NULL) {
				ValaMemberAccess* _tmp115_;
				const gchar* _tmp116_;
				const gchar* _tmp117_;
				_tmp115_ = ma;
				_tmp116_ = vala_member_access_get_member_name (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp111_ = g_strcmp0 (_tmp117_, "this") == 0;
			} else {
				_tmp111_ = FALSE;
			}
			if (_tmp111_) {
				ValaSemanticAnalyzer* _tmp118_;
				ValaSemanticAnalyzer* _tmp119_;
				_tmp118_ = vala_code_context_get_analyzer (context);
				_tmp119_ = _tmp118_;
				_tmp110_ = vala_semantic_analyzer_is_in_instance_method (_tmp119_);
			} else {
				_tmp110_ = FALSE;
			}
			_tmp102_ = _tmp110_;
		}
		if (_tmp102_) {
			ValaSourceReference* _tmp120_;
			ValaSourceReference* _tmp121_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp121_ = _tmp120_;
			vala_report_error (_tmp121_, "unsupported lvalue in assignment");
			result = FALSE;
			return result;
		}
		_tmp122_ = ma;
		_tmp123_ = vala_member_access_get_prototype_access (_tmp122_);
		_tmp124_ = _tmp123_;
		if (_tmp124_) {
			ValaSourceReference* _tmp125_;
			ValaSourceReference* _tmp126_;
			ValaMemberAccess* _tmp127_;
			ValaSymbol* _tmp128_;
			ValaSymbol* _tmp129_;
			gchar* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			gchar* _tmp133_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp126_ = _tmp125_;
			_tmp127_ = ma;
			_tmp128_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp127_);
			_tmp129_ = _tmp128_;
			_tmp130_ = vala_symbol_get_full_name (_tmp129_);
			_tmp131_ = _tmp130_;
			_tmp132_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp131_);
			_tmp133_ = _tmp132_;
			vala_report_error (_tmp126_, _tmp133_);
			_g_free0 (_tmp133_);
			_g_free0 (_tmp131_);
			result = FALSE;
			return result;
		}
		_tmp135_ = ma;
		_tmp136_ = vala_code_node_get_error ((ValaCodeNode*) _tmp135_);
		_tmp137_ = _tmp136_;
		if (_tmp137_) {
			_tmp134_ = TRUE;
		} else {
			ValaMemberAccess* _tmp138_;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			_tmp138_ = ma;
			_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp138_);
			_tmp140_ = _tmp139_;
			_tmp134_ = _tmp140_ == NULL;
		}
		if (_tmp134_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp141_ = ma;
		_tmp142_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp141_);
		_tmp143_ = _tmp142_;
		if (VALA_IS_DYNAMIC_PROPERTY (_tmp143_)) {
		} else {
			ValaExpression* _tmp144_;
			ValaExpression* _tmp145_;
			ValaMemberAccess* _tmp146_;
			ValaDataType* _tmp147_;
			ValaDataType* _tmp148_;
			ValaDataType* _tmp149_;
			ValaDataType* _tmp150_;
			ValaExpression* _tmp151_;
			ValaExpression* _tmp152_;
			ValaMemberAccess* _tmp153_;
			ValaDataType* _tmp154_;
			ValaDataType* _tmp155_;
			ValaDataType* _tmp156_;
			ValaDataType* _tmp157_;
			_tmp144_ = vala_assignment_get_right (self);
			_tmp145_ = _tmp144_;
			_tmp146_ = ma;
			_tmp147_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp146_);
			_tmp148_ = _tmp147_;
			_tmp149_ = vala_data_type_copy (_tmp148_);
			_tmp150_ = _tmp149_;
			vala_expression_set_formal_target_type (_tmp145_, _tmp150_);
			_vala_code_node_unref0 (_tmp150_);
			_tmp151_ = vala_assignment_get_right (self);
			_tmp152_ = _tmp151_;
			_tmp153_ = ma;
			_tmp154_ = vala_expression_get_value_type ((ValaExpression*) _tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_data_type_copy (_tmp155_);
			_tmp157_ = _tmp156_;
			vala_expression_set_target_type (_tmp152_, _tmp157_);
			_vala_code_node_unref0 (_tmp157_);
		}
	} else {
		ValaExpression* _tmp158_;
		ValaExpression* _tmp159_;
		_tmp158_ = vala_assignment_get_left (self);
		_tmp159_ = _tmp158_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp159_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp160_;
			ValaExpression* _tmp161_;
			ValaElementAccess* _tmp162_;
			ValaExpression* _tmp163_;
			ValaExpression* _tmp164_;
			ValaElementAccess* _tmp165_;
			ValaExpression* _tmp166_;
			ValaExpression* _tmp167_;
			ValaDataType* _tmp168_;
			ValaDataType* _tmp169_;
			ValaTypeSymbol* _tmp170_;
			ValaTypeSymbol* _tmp171_;
			ValaSemanticAnalyzer* _tmp172_;
			ValaSemanticAnalyzer* _tmp173_;
			ValaDataType* _tmp174_;
			ValaTypeSymbol* _tmp175_;
			ValaTypeSymbol* _tmp176_;
			_tmp160_ = vala_assignment_get_left (self);
			_tmp161_ = _tmp160_;
			ea = G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
			_tmp162_ = ea;
			_tmp163_ = vala_element_access_get_container (_tmp162_);
			_tmp164_ = _tmp163_;
			vala_assignment_check_constant_assignment (self, VALA_IS_MEMBER_ACCESS (_tmp164_) ? ((ValaMemberAccess*) _tmp164_) : NULL);
			_tmp165_ = ea;
			_tmp166_ = vala_element_access_get_container (_tmp165_);
			_tmp167_ = _tmp166_;
			_tmp168_ = vala_expression_get_value_type (_tmp167_);
			_tmp169_ = _tmp168_;
			_tmp170_ = vala_data_type_get_type_symbol (_tmp169_);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_code_context_get_analyzer (context);
			_tmp173_ = _tmp172_;
			_tmp174_ = _tmp173_->string_type;
			_tmp175_ = vala_data_type_get_type_symbol (_tmp174_);
			_tmp176_ = _tmp175_;
			if (_tmp171_ == _tmp176_) {
				ValaElementAccess* _tmp177_;
				ValaSourceReference* _tmp178_;
				ValaSourceReference* _tmp179_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp177_ = ea;
				_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp177_);
				_tmp179_ = _tmp178_;
				vala_report_error (_tmp179_, "strings are immutable");
				result = FALSE;
				return result;
			} else {
				ValaElementAccess* _tmp180_;
				ValaExpression* _tmp181_;
				ValaExpression* _tmp182_;
				ValaDataType* _tmp183_;
				ValaDataType* _tmp184_;
				ValaSymbol* _tmp185_;
				ValaSymbol* _tmp186_;
				gboolean _tmp187_;
				_tmp180_ = ea;
				_tmp181_ = vala_element_access_get_container (_tmp180_);
				_tmp182_ = _tmp181_;
				_tmp183_ = vala_expression_get_value_type (_tmp182_);
				_tmp184_ = _tmp183_;
				_tmp185_ = vala_data_type_get_member (_tmp184_, "set");
				_tmp186_ = _tmp185_;
				_tmp187_ = VALA_IS_METHOD (_tmp186_);
				_vala_code_node_unref0 (_tmp186_);
				if (_tmp187_) {
					ValaMethodCall* set_call = NULL;
					ValaElementAccess* _tmp188_;
					ValaExpression* _tmp189_;
					ValaExpression* _tmp190_;
					ValaSourceReference* _tmp191_;
					ValaSourceReference* _tmp192_;
					ValaMemberAccess* _tmp193_;
					ValaMemberAccess* _tmp194_;
					ValaSourceReference* _tmp195_;
					ValaSourceReference* _tmp196_;
					ValaMethodCall* _tmp197_;
					ValaMethodCall* _tmp198_;
					ValaMethodCall* _tmp211_;
					ValaExpression* _tmp212_;
					ValaExpression* _tmp213_;
					ValaCodeNode* _tmp214_;
					ValaCodeNode* _tmp215_;
					ValaMethodCall* _tmp216_;
					ValaMethodCall* _tmp217_;
					_tmp188_ = ea;
					_tmp189_ = vala_element_access_get_container (_tmp188_);
					_tmp190_ = _tmp189_;
					_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp192_ = _tmp191_;
					_tmp193_ = vala_member_access_new (_tmp190_, "set", _tmp192_);
					_tmp194_ = _tmp193_;
					_tmp195_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp196_ = _tmp195_;
					_tmp197_ = vala_method_call_new ((ValaExpression*) _tmp194_, _tmp196_);
					_tmp198_ = _tmp197_;
					_vala_code_node_unref0 (_tmp194_);
					set_call = _tmp198_;
					{
						ValaList* _e_list = NULL;
						ValaElementAccess* _tmp199_;
						ValaList* _tmp200_;
						ValaList* _tmp201_;
						gint _e_size = 0;
						ValaList* _tmp202_;
						gint _tmp203_;
						gint _tmp204_;
						gint _e_index = 0;
						_tmp199_ = ea;
						_tmp200_ = vala_element_access_get_indices (_tmp199_);
						_tmp201_ = _vala_iterable_ref0 (_tmp200_);
						_e_list = _tmp201_;
						_tmp202_ = _e_list;
						_tmp203_ = vala_collection_get_size ((ValaCollection*) _tmp202_);
						_tmp204_ = _tmp203_;
						_e_size = _tmp204_;
						_e_index = -1;
						while (TRUE) {
							gint _tmp205_;
							gint _tmp206_;
							ValaExpression* e = NULL;
							ValaList* _tmp207_;
							gpointer _tmp208_;
							ValaMethodCall* _tmp209_;
							ValaExpression* _tmp210_;
							_e_index = _e_index + 1;
							_tmp205_ = _e_index;
							_tmp206_ = _e_size;
							if (!(_tmp205_ < _tmp206_)) {
								break;
							}
							_tmp207_ = _e_list;
							_tmp208_ = vala_list_get (_tmp207_, _e_index);
							e = (ValaExpression*) _tmp208_;
							_tmp209_ = set_call;
							_tmp210_ = e;
							vala_method_call_add_argument (_tmp209_, _tmp210_);
							_vala_code_node_unref0 (e);
						}
						_vala_iterable_unref0 (_e_list);
					}
					_tmp211_ = set_call;
					_tmp212_ = vala_assignment_get_right (self);
					_tmp213_ = _tmp212_;
					vala_method_call_add_argument (_tmp211_, _tmp213_);
					_tmp214_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp215_ = _tmp214_;
					_tmp216_ = set_call;
					vala_code_node_replace_expression (_tmp215_, (ValaExpression*) self, (ValaExpression*) _tmp216_);
					_tmp217_ = set_call;
					result = vala_code_node_check ((ValaCodeNode*) _tmp217_, context);
					_vala_code_node_unref0 (set_call);
					return result;
				} else {
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					ValaExpression* _tmp220_;
					ValaExpression* _tmp221_;
					ValaDataType* _tmp222_;
					ValaDataType* _tmp223_;
					ValaDataType* _tmp224_;
					ValaDataType* _tmp225_;
					_tmp218_ = vala_assignment_get_right (self);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_assignment_get_left (self);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_expression_get_value_type (_tmp221_);
					_tmp223_ = _tmp222_;
					_tmp224_ = vala_data_type_copy (_tmp223_);
					_tmp225_ = _tmp224_;
					vala_expression_set_target_type (_tmp219_, _tmp225_);
					_vala_code_node_unref0 (_tmp225_);
				}
			}
		} else {
			ValaExpression* _tmp226_;
			ValaExpression* _tmp227_;
			_tmp226_ = vala_assignment_get_left (self);
			_tmp227_ = _tmp226_;
			if (VALA_IS_POINTER_INDIRECTION (_tmp227_)) {
				ValaExpression* _tmp228_;
				ValaExpression* _tmp229_;
				ValaExpression* _tmp230_;
				ValaExpression* _tmp231_;
				ValaDataType* _tmp232_;
				ValaDataType* _tmp233_;
				ValaDataType* _tmp234_;
				ValaDataType* _tmp235_;
				_tmp228_ = vala_assignment_get_right (self);
				_tmp229_ = _tmp228_;
				_tmp230_ = vala_assignment_get_left (self);
				_tmp231_ = _tmp230_;
				_tmp232_ = vala_expression_get_value_type (_tmp231_);
				_tmp233_ = _tmp232_;
				_tmp234_ = vala_data_type_copy (_tmp233_);
				_tmp235_ = _tmp234_;
				vala_expression_set_target_type (_tmp229_, _tmp235_);
				_vala_code_node_unref0 (_tmp235_);
			} else {
				ValaExpression* _tmp236_;
				ValaExpression* _tmp237_;
				_tmp236_ = vala_assignment_get_left (self);
				_tmp237_ = _tmp236_;
				if (VALA_IS_LITERAL (_tmp237_)) {
					ValaSourceReference* _tmp238_;
					ValaSourceReference* _tmp239_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp239_ = _tmp238_;
					vala_report_error (_tmp239_, "Literals are immutable");
					result = FALSE;
					return result;
				} else {
					ValaSourceReference* _tmp240_;
					ValaSourceReference* _tmp241_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp240_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp241_ = _tmp240_;
					vala_report_error (_tmp241_, "unsupported lvalue in assignment");
					result = FALSE;
					return result;
				}
			}
		}
	}
	_tmp242_ = vala_assignment_get_right (self);
	_tmp243_ = _tmp242_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp243_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp244_ = vala_assignment_get_left (self);
	_tmp245_ = _tmp244_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp245_) ? ((ValaMemberAccess*) _tmp245_) : NULL;
	_tmp246_ = vala_assignment_get_left (self);
	_tmp247_ = _tmp246_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp247_) ? ((ValaElementAccess*) _tmp247_) : NULL;
	transform_assignment = FALSE;
	_tmp249_ = ma;
	if (_tmp249_ != NULL) {
		ValaMemberAccess* _tmp250_;
		ValaSymbol* _tmp251_;
		ValaSymbol* _tmp252_;
		_tmp250_ = ma;
		_tmp251_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp250_);
		_tmp252_ = _tmp251_;
		_tmp248_ = !VALA_IS_LOCAL_VARIABLE (_tmp252_);
	} else {
		_tmp248_ = FALSE;
	}
	if (_tmp248_) {
		transform_assignment = TRUE;
	} else {
		gboolean _tmp253_ = FALSE;
		ValaExpression* _tmp254_;
		ValaExpression* _tmp255_;
		ValaDataType* _tmp256_;
		ValaDataType* _tmp257_;
		_tmp254_ = vala_assignment_get_left (self);
		_tmp255_ = _tmp254_;
		_tmp256_ = vala_expression_get_value_type (_tmp255_);
		_tmp257_ = _tmp256_;
		if (_tmp257_ != NULL) {
			ValaExpression* _tmp258_;
			ValaExpression* _tmp259_;
			ValaDataType* _tmp260_;
			ValaDataType* _tmp261_;
			_tmp258_ = vala_assignment_get_left (self);
			_tmp259_ = _tmp258_;
			_tmp260_ = vala_expression_get_value_type (_tmp259_);
			_tmp261_ = _tmp260_;
			_tmp253_ = !vala_data_type_is_non_null_simple_type (_tmp261_);
		} else {
			_tmp253_ = FALSE;
		}
		if (_tmp253_) {
			transform_assignment = TRUE;
		} else {
			gboolean _tmp262_ = FALSE;
			ValaElementAccess* _tmp263_;
			_tmp263_ = ea;
			if (_tmp263_ != NULL) {
				ValaElementAccess* _tmp264_;
				ValaExpression* _tmp265_;
				ValaExpression* _tmp266_;
				ValaDataType* _tmp267_;
				ValaDataType* _tmp268_;
				_tmp264_ = ea;
				_tmp265_ = vala_element_access_get_container (_tmp264_);
				_tmp266_ = _tmp265_;
				_tmp267_ = vala_expression_get_value_type (_tmp266_);
				_tmp268_ = _tmp267_;
				_tmp262_ = VALA_IS_ARRAY_TYPE (_tmp268_);
			} else {
				_tmp262_ = FALSE;
			}
			if (_tmp262_) {
				ValaArrayType* array_type = NULL;
				ValaElementAccess* _tmp269_;
				ValaExpression* _tmp270_;
				ValaExpression* _tmp271_;
				ValaDataType* _tmp272_;
				ValaDataType* _tmp273_;
				ValaArrayType* _tmp274_;
				ValaDataType* _tmp275_;
				ValaDataType* _tmp276_;
				_tmp269_ = ea;
				_tmp270_ = vala_element_access_get_container (_tmp269_);
				_tmp271_ = _tmp270_;
				_tmp272_ = vala_expression_get_value_type (_tmp271_);
				_tmp273_ = _tmp272_;
				array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp273_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp274_ = array_type;
				_tmp275_ = vala_array_type_get_element_type (_tmp274_);
				_tmp276_ = _tmp275_;
				transform_assignment = !vala_data_type_is_non_null_simple_type (_tmp276_);
			}
		}
	}
	_tmp278_ = self->priv->_operator;
	if (_tmp278_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		_tmp277_ = transform_assignment;
	} else {
		_tmp277_ = FALSE;
	}
	if (_tmp277_) {
		ValaExpression* old_value = NULL;
		ValaMemberAccess* _tmp279_;
		ValaBinaryOperator bop = 0;
		ValaAssignmentOperator _tmp314_;
		ValaBinaryExpression* bin = NULL;
		ValaExpression* _tmp317_;
		ValaExpression* _tmp318_;
		ValaExpression* _tmp319_;
		ValaSourceReference* _tmp320_;
		ValaSourceReference* _tmp321_;
		ValaBinaryExpression* _tmp322_;
		ValaBinaryExpression* _tmp323_;
		ValaExpression* _tmp324_;
		ValaExpression* _tmp325_;
		ValaDataType* _tmp326_;
		ValaDataType* _tmp327_;
		ValaExpression* _tmp328_;
		ValaExpression* _tmp329_;
		ValaExpression* _tmp330_;
		ValaExpression* _tmp331_;
		ValaDataType* _tmp332_;
		ValaDataType* _tmp333_;
		ValaDataType* _tmp334_;
		ValaDataType* _tmp335_;
		ValaExpression* _tmp336_;
		ValaExpression* _tmp337_;
		ValaDataType* _tmp338_;
		ValaDataType* _tmp339_;
		ValaBinaryExpression* _tmp340_;
		ValaExpression* _tmp341_;
		ValaExpression* _tmp342_;
		old_value = NULL;
		_tmp279_ = ma;
		if (_tmp279_ != NULL) {
			ValaMemberAccess* _tmp280_;
			ValaExpression* _tmp281_;
			ValaExpression* _tmp282_;
			ValaMemberAccess* _tmp283_;
			const gchar* _tmp284_;
			const gchar* _tmp285_;
			ValaExpression* _tmp286_;
			ValaExpression* _tmp287_;
			ValaSourceReference* _tmp288_;
			ValaSourceReference* _tmp289_;
			ValaMemberAccess* _tmp290_;
			_tmp280_ = ma;
			_tmp281_ = vala_member_access_get_inner (_tmp280_);
			_tmp282_ = _tmp281_;
			_tmp283_ = ma;
			_tmp284_ = vala_member_access_get_member_name (_tmp283_);
			_tmp285_ = _tmp284_;
			_tmp286_ = vala_assignment_get_left (self);
			_tmp287_ = _tmp286_;
			_tmp288_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp287_);
			_tmp289_ = _tmp288_;
			_tmp290_ = vala_member_access_new (_tmp282_, _tmp285_, _tmp289_);
			_vala_code_node_unref0 (old_value);
			old_value = (ValaExpression*) _tmp290_;
		} else {
			ValaElementAccess* _tmp291_;
			_tmp291_ = ea;
			if (_tmp291_ != NULL) {
				ValaElementAccess* _tmp292_;
				ValaExpression* _tmp293_;
				ValaExpression* _tmp294_;
				ValaExpression* _tmp295_;
				ValaExpression* _tmp296_;
				ValaSourceReference* _tmp297_;
				ValaSourceReference* _tmp298_;
				ValaElementAccess* _tmp299_;
				ValaList* indices = NULL;
				ValaElementAccess* _tmp300_;
				ValaList* _tmp301_;
				ValaList* _tmp302_;
				_tmp292_ = ea;
				_tmp293_ = vala_element_access_get_container (_tmp292_);
				_tmp294_ = _tmp293_;
				_tmp295_ = vala_assignment_get_left (self);
				_tmp296_ = _tmp295_;
				_tmp297_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp296_);
				_tmp298_ = _tmp297_;
				_tmp299_ = vala_element_access_new (_tmp294_, _tmp298_);
				_vala_code_node_unref0 (old_value);
				old_value = (ValaExpression*) _tmp299_;
				_tmp300_ = ea;
				_tmp301_ = vala_element_access_get_indices (_tmp300_);
				_tmp302_ = _vala_iterable_ref0 (_tmp301_);
				indices = _tmp302_;
				{
					ValaList* _index_list = NULL;
					ValaList* _tmp303_;
					ValaList* _tmp304_;
					gint _index_size = 0;
					ValaList* _tmp305_;
					gint _tmp306_;
					gint _tmp307_;
					gint _index_index = 0;
					_tmp303_ = indices;
					_tmp304_ = _vala_iterable_ref0 (_tmp303_);
					_index_list = _tmp304_;
					_tmp305_ = _index_list;
					_tmp306_ = vala_collection_get_size ((ValaCollection*) _tmp305_);
					_tmp307_ = _tmp306_;
					_index_size = _tmp307_;
					_index_index = -1;
					while (TRUE) {
						gint _tmp308_;
						gint _tmp309_;
						ValaExpression* index = NULL;
						ValaList* _tmp310_;
						gpointer _tmp311_;
						ValaExpression* _tmp312_;
						ValaExpression* _tmp313_;
						_index_index = _index_index + 1;
						_tmp308_ = _index_index;
						_tmp309_ = _index_size;
						if (!(_tmp308_ < _tmp309_)) {
							break;
						}
						_tmp310_ = _index_list;
						_tmp311_ = vala_list_get (_tmp310_, _index_index);
						index = (ValaExpression*) _tmp311_;
						_tmp312_ = old_value;
						_tmp313_ = index;
						vala_element_access_append_index (G_TYPE_CHECK_INSTANCE_CAST (_tmp312_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess), _tmp313_);
						_vala_code_node_unref0 (index);
					}
					_vala_iterable_unref0 (_index_list);
				}
				_vala_iterable_unref0 (indices);
			} else {
				g_assert_not_reached ();
			}
		}
		_tmp314_ = self->priv->_operator;
		switch (_tmp314_) {
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_OR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_AND;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_XOR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_ADD:
			{
				bop = VALA_BINARY_OPERATOR_PLUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SUB:
			{
				bop = VALA_BINARY_OPERATOR_MINUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_MUL:
			{
				bop = VALA_BINARY_OPERATOR_MUL;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_DIV:
			{
				bop = VALA_BINARY_OPERATOR_DIV;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_PERCENT:
			{
				bop = VALA_BINARY_OPERATOR_MOD;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_LEFT;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				break;
			}
			default:
			{
				ValaSourceReference* _tmp315_;
				ValaSourceReference* _tmp316_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp315_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp316_ = _tmp315_;
				vala_report_error (_tmp316_, "internal error: unsupported assignment operator");
				result = FALSE;
				_vala_code_node_unref0 (old_value);
				return result;
			}
		}
		_tmp317_ = old_value;
		_tmp318_ = vala_assignment_get_right (self);
		_tmp319_ = _tmp318_;
		_tmp320_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp321_ = _tmp320_;
		_tmp322_ = vala_binary_expression_new (bop, _tmp317_, _tmp319_, _tmp321_);
		bin = _tmp322_;
		_tmp323_ = bin;
		_tmp324_ = vala_assignment_get_right (self);
		_tmp325_ = _tmp324_;
		_tmp326_ = vala_expression_get_target_type (_tmp325_);
		_tmp327_ = _tmp326_;
		vala_expression_set_target_type ((ValaExpression*) _tmp323_, _tmp327_);
		_tmp328_ = vala_assignment_get_right (self);
		_tmp329_ = _tmp328_;
		_tmp330_ = vala_assignment_get_right (self);
		_tmp331_ = _tmp330_;
		_tmp332_ = vala_expression_get_target_type (_tmp331_);
		_tmp333_ = _tmp332_;
		_tmp334_ = vala_data_type_copy (_tmp333_);
		_tmp335_ = _tmp334_;
		vala_expression_set_target_type (_tmp329_, _tmp335_);
		_vala_code_node_unref0 (_tmp335_);
		_tmp336_ = vala_assignment_get_right (self);
		_tmp337_ = _tmp336_;
		_tmp338_ = vala_expression_get_target_type (_tmp337_);
		_tmp339_ = _tmp338_;
		vala_data_type_set_value_owned (_tmp339_, FALSE);
		_tmp340_ = bin;
		vala_assignment_set_right (self, (ValaExpression*) _tmp340_);
		_tmp341_ = vala_assignment_get_right (self);
		_tmp342_ = _tmp341_;
		vala_code_node_check ((ValaCodeNode*) _tmp342_, context);
		vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
		_vala_code_node_unref0 (bin);
		_vala_code_node_unref0 (old_value);
	}
	_tmp343_ = ma;
	if (_tmp343_ != NULL) {
		ValaMemberAccess* _tmp344_;
		ValaSymbol* _tmp345_;
		ValaSymbol* _tmp346_;
		gboolean _tmp465_ = FALSE;
		ValaExpression* _tmp466_;
		ValaExpression* _tmp467_;
		ValaDataType* _tmp468_;
		ValaDataType* _tmp469_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp557_;
		ValaExpression* _tmp558_;
		gboolean _tmp559_ = FALSE;
		ValaMemberAccess* _tmp560_;
		_tmp344_ = ma;
		_tmp345_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp344_);
		_tmp346_ = _tmp345_;
		if (VALA_IS_PROPERTY (_tmp346_)) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp347_;
			ValaSymbol* _tmp348_;
			ValaSymbol* _tmp349_;
			ValaDynamicProperty* dynamic_prop = NULL;
			ValaProperty* _tmp350_;
			ValaDynamicProperty* _tmp351_;
			_tmp347_ = ma;
			_tmp348_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp347_);
			_tmp349_ = _tmp348_;
			prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp349_, VALA_TYPE_PROPERTY, ValaProperty);
			_tmp350_ = prop;
			dynamic_prop = VALA_IS_DYNAMIC_PROPERTY (_tmp350_) ? ((ValaDynamicProperty*) _tmp350_) : NULL;
			_tmp351_ = dynamic_prop;
			if (_tmp351_ != NULL) {
				ValaDynamicProperty* _tmp352_;
				ValaExpression* _tmp353_;
				ValaExpression* _tmp354_;
				ValaDataType* _tmp355_;
				ValaDataType* _tmp356_;
				ValaDataType* _tmp357_;
				ValaDataType* _tmp358_;
				ValaExpression* _tmp359_;
				ValaExpression* _tmp360_;
				ValaDynamicProperty* _tmp361_;
				ValaDataType* _tmp362_;
				ValaDataType* _tmp363_;
				ValaDataType* _tmp364_;
				ValaDataType* _tmp365_;
				_tmp352_ = dynamic_prop;
				_tmp353_ = vala_assignment_get_right (self);
				_tmp354_ = _tmp353_;
				_tmp355_ = vala_expression_get_value_type (_tmp354_);
				_tmp356_ = _tmp355_;
				_tmp357_ = vala_data_type_copy (_tmp356_);
				_tmp358_ = _tmp357_;
				vala_property_set_property_type ((ValaProperty*) _tmp352_, _tmp358_);
				_vala_code_node_unref0 (_tmp358_);
				_tmp359_ = vala_assignment_get_left (self);
				_tmp360_ = _tmp359_;
				_tmp361_ = dynamic_prop;
				_tmp362_ = vala_property_get_property_type ((ValaProperty*) _tmp361_);
				_tmp363_ = _tmp362_;
				_tmp364_ = vala_data_type_copy (_tmp363_);
				_tmp365_ = _tmp364_;
				vala_expression_set_value_type (_tmp360_, _tmp365_);
				_vala_code_node_unref0 (_tmp365_);
			}
		} else {
			gboolean _tmp366_ = FALSE;
			ValaMemberAccess* _tmp367_;
			ValaSymbol* _tmp368_;
			ValaSymbol* _tmp369_;
			_tmp367_ = ma;
			_tmp368_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp367_);
			_tmp369_ = _tmp368_;
			if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp369_)) {
				ValaMemberAccess* _tmp370_;
				ValaExpression* _tmp371_;
				ValaExpression* _tmp372_;
				ValaDataType* _tmp373_;
				ValaDataType* _tmp374_;
				gboolean _tmp375_;
				gboolean _tmp376_;
				_tmp370_ = ma;
				_tmp371_ = vala_member_access_get_inner (_tmp370_);
				_tmp372_ = _tmp371_;
				_tmp373_ = vala_expression_get_value_type (_tmp372_);
				_tmp374_ = _tmp373_;
				_tmp375_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp374_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp376_ = _tmp375_;
				_tmp366_ = _tmp376_;
			} else {
				_tmp366_ = FALSE;
			}
			if (_tmp366_) {
				ValaSourceReference* _tmp377_;
				ValaSourceReference* _tmp378_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp377_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp378_ = _tmp377_;
				vala_report_error (_tmp378_, "`length' field of fixed length arrays is read-only");
				result = FALSE;
				return result;
			} else {
				gboolean _tmp379_ = FALSE;
				ValaMemberAccess* _tmp380_;
				ValaSymbol* _tmp381_;
				ValaSymbol* _tmp382_;
				_tmp380_ = ma;
				_tmp381_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp380_);
				_tmp382_ = _tmp381_;
				if (VALA_IS_VARIABLE (_tmp382_)) {
					ValaExpression* _tmp383_;
					ValaExpression* _tmp384_;
					ValaDataType* _tmp385_;
					ValaDataType* _tmp386_;
					_tmp383_ = vala_assignment_get_right (self);
					_tmp384_ = _tmp383_;
					_tmp385_ = vala_expression_get_value_type (_tmp384_);
					_tmp386_ = _tmp385_;
					_tmp379_ = VALA_IS_METHOD_TYPE (_tmp386_);
				} else {
					_tmp379_ = FALSE;
				}
				if (_tmp379_) {
					ValaVariable* variable = NULL;
					ValaMemberAccess* _tmp387_;
					ValaSymbol* _tmp388_;
					ValaSymbol* _tmp389_;
					ValaVariable* _tmp390_;
					ValaDataType* _tmp391_;
					ValaDataType* _tmp392_;
					_tmp387_ = ma;
					_tmp388_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp387_);
					_tmp389_ = _tmp388_;
					variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp389_, VALA_TYPE_VARIABLE, ValaVariable);
					_tmp390_ = variable;
					_tmp391_ = vala_variable_get_variable_type (_tmp390_);
					_tmp392_ = _tmp391_;
					if (VALA_IS_DELEGATE_TYPE (_tmp392_)) {
						ValaExpression* _tmp393_;
						ValaExpression* _tmp394_;
						ValaDataType* _tmp395_;
						ValaDataType* _tmp396_;
						ValaVariable* _tmp397_;
						ValaDataType* _tmp398_;
						ValaDataType* _tmp399_;
						_tmp393_ = vala_assignment_get_right (self);
						_tmp394_ = _tmp393_;
						_tmp395_ = vala_expression_get_value_type (_tmp394_);
						_tmp396_ = _tmp395_;
						_tmp397_ = variable;
						_tmp398_ = vala_variable_get_variable_type (_tmp397_);
						_tmp399_ = _tmp398_;
						if (!vala_data_type_compatible (_tmp396_, _tmp399_)) {
							ValaMethod* m = NULL;
							ValaExpression* _tmp400_;
							ValaExpression* _tmp401_;
							ValaSymbol* _tmp402_;
							ValaSymbol* _tmp403_;
							ValaDelegate* cb = NULL;
							ValaVariable* _tmp404_;
							ValaDataType* _tmp405_;
							ValaDataType* _tmp406_;
							ValaDelegate* _tmp407_;
							ValaDelegate* _tmp408_;
							ValaSourceReference* _tmp409_;
							ValaSourceReference* _tmp410_;
							ValaMethod* _tmp411_;
							gchar* _tmp412_;
							gchar* _tmp413_;
							ValaDelegate* _tmp414_;
							gchar* _tmp415_;
							gchar* _tmp416_;
							gchar* _tmp417_;
							gchar* _tmp418_;
							_tmp400_ = vala_assignment_get_right (self);
							_tmp401_ = _tmp400_;
							_tmp402_ = vala_expression_get_symbol_reference (_tmp401_);
							_tmp403_ = _tmp402_;
							m = G_TYPE_CHECK_INSTANCE_CAST (_tmp403_, VALA_TYPE_METHOD, ValaMethod);
							_tmp404_ = variable;
							_tmp405_ = vala_variable_get_variable_type (_tmp404_);
							_tmp406_ = _tmp405_;
							_tmp407_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp406_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							_tmp408_ = _tmp407_;
							cb = _tmp408_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp409_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp410_ = _tmp409_;
							_tmp411_ = m;
							_tmp412_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp411_);
							_tmp413_ = _tmp412_;
							_tmp414_ = cb;
							_tmp415_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp414_);
							_tmp416_ = _tmp415_;
							_tmp417_ = g_strdup_printf ("Declaration of method `%s' is not compatible with delegate `%s'", _tmp413_, _tmp416_);
							_tmp418_ = _tmp417_;
							vala_report_error (_tmp410_, _tmp418_);
							_g_free0 (_tmp418_);
							_g_free0 (_tmp416_);
							_g_free0 (_tmp413_);
							result = FALSE;
							return result;
						}
					} else {
						ValaSourceReference* _tmp419_;
						ValaSourceReference* _tmp420_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp419_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp420_ = _tmp419_;
						vala_report_error (_tmp420_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						return result;
					}
				} else {
					gboolean _tmp421_ = FALSE;
					ValaMemberAccess* _tmp422_;
					ValaSymbol* _tmp423_;
					ValaSymbol* _tmp424_;
					_tmp422_ = ma;
					_tmp423_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp422_);
					_tmp424_ = _tmp423_;
					if (VALA_IS_VARIABLE (_tmp424_)) {
						ValaExpression* _tmp425_;
						ValaExpression* _tmp426_;
						ValaDataType* _tmp427_;
						ValaDataType* _tmp428_;
						_tmp425_ = vala_assignment_get_right (self);
						_tmp426_ = _tmp425_;
						_tmp427_ = vala_expression_get_value_type (_tmp426_);
						_tmp428_ = _tmp427_;
						_tmp421_ = _tmp428_ == NULL;
					} else {
						_tmp421_ = FALSE;
					}
					if (_tmp421_) {
						ValaSourceReference* _tmp429_;
						ValaSourceReference* _tmp430_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp429_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp430_ = _tmp429_;
						vala_report_error (_tmp430_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						return result;
					} else {
						ValaMemberAccess* _tmp431_;
						ValaSymbol* _tmp432_;
						ValaSymbol* _tmp433_;
						_tmp431_ = ma;
						_tmp432_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp431_);
						_tmp433_ = _tmp432_;
						if (VALA_IS_VARIABLE (_tmp433_)) {
							ValaVariable* variable = NULL;
							ValaMemberAccess* _tmp434_;
							ValaSymbol* _tmp435_;
							ValaSymbol* _tmp436_;
							ValaArrayType* variable_array_type = NULL;
							ValaVariable* _tmp437_;
							ValaDataType* _tmp438_;
							ValaDataType* _tmp439_;
							gboolean _tmp440_ = FALSE;
							gboolean _tmp441_ = FALSE;
							gboolean _tmp442_ = FALSE;
							ValaArrayType* _tmp443_;
							_tmp434_ = ma;
							_tmp435_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp434_);
							_tmp436_ = _tmp435_;
							variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp436_, VALA_TYPE_VARIABLE, ValaVariable);
							_tmp437_ = variable;
							_tmp438_ = vala_variable_get_variable_type (_tmp437_);
							_tmp439_ = _tmp438_;
							variable_array_type = VALA_IS_ARRAY_TYPE (_tmp439_) ? ((ValaArrayType*) _tmp439_) : NULL;
							_tmp443_ = variable_array_type;
							if (_tmp443_ != NULL) {
								ValaArrayType* _tmp444_;
								gboolean _tmp445_;
								gboolean _tmp446_;
								_tmp444_ = variable_array_type;
								_tmp445_ = vala_array_type_get_inline_allocated (_tmp444_);
								_tmp446_ = _tmp445_;
								_tmp442_ = _tmp446_;
							} else {
								_tmp442_ = FALSE;
							}
							if (_tmp442_) {
								ValaExpression* _tmp447_;
								ValaExpression* _tmp448_;
								_tmp447_ = vala_assignment_get_right (self);
								_tmp448_ = _tmp447_;
								_tmp441_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp448_);
							} else {
								_tmp441_ = FALSE;
							}
							if (_tmp441_) {
								ValaExpression* _tmp449_;
								ValaExpression* _tmp450_;
								ValaInitializerList* _tmp451_;
								ValaInitializerList* _tmp452_;
								_tmp449_ = vala_assignment_get_right (self);
								_tmp450_ = _tmp449_;
								_tmp451_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp450_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
								_tmp452_ = _tmp451_;
								_tmp440_ = _tmp452_ == NULL;
							} else {
								_tmp440_ = FALSE;
							}
							if (_tmp440_) {
								ValaSourceReference* _tmp453_;
								ValaSourceReference* _tmp454_;
								ValaCodeNode* _tmp455_;
								ValaCodeNode* _tmp456_;
								ValaCodeNode* _tmp457_;
								ValaCodeNode* _tmp458_;
								ValaCodeNode* _tmp459_;
								ValaCodeNode* _tmp460_;
								ValaSourceReference* _tmp461_;
								ValaSourceReference* _tmp462_;
								ValaEmptyStatement* _tmp463_;
								ValaEmptyStatement* _tmp464_;
								_tmp453_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp454_ = _tmp453_;
								vala_report_warning (_tmp454_, "Inline allocated arrays don't require an explicit instantiation");
								_tmp455_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp456_ = _tmp455_;
								_tmp457_ = vala_code_node_get_parent_node (_tmp456_);
								_tmp458_ = _tmp457_;
								_tmp459_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp460_ = _tmp459_;
								_tmp461_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp462_ = _tmp461_;
								_tmp463_ = vala_empty_statement_new (_tmp462_);
								_tmp464_ = _tmp463_;
								vala_block_replace_statement (G_TYPE_CHECK_INSTANCE_CAST (_tmp458_, VALA_TYPE_BLOCK, ValaBlock), G_TYPE_CHECK_INSTANCE_CAST (_tmp460_, VALA_TYPE_STATEMENT, ValaStatement), (ValaStatement*) _tmp464_);
								_vala_code_node_unref0 (_tmp464_);
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
		_tmp466_ = vala_assignment_get_left (self);
		_tmp467_ = _tmp466_;
		_tmp468_ = vala_expression_get_value_type (_tmp467_);
		_tmp469_ = _tmp468_;
		if (_tmp469_ != NULL) {
			ValaExpression* _tmp470_;
			ValaExpression* _tmp471_;
			ValaDataType* _tmp472_;
			ValaDataType* _tmp473_;
			_tmp470_ = vala_assignment_get_right (self);
			_tmp471_ = _tmp470_;
			_tmp472_ = vala_expression_get_value_type (_tmp471_);
			_tmp473_ = _tmp472_;
			_tmp465_ = _tmp473_ != NULL;
		} else {
			_tmp465_ = FALSE;
		}
		if (_tmp465_) {
			ValaExpression* _tmp474_;
			ValaExpression* _tmp475_;
			ValaDataType* _tmp476_;
			ValaDataType* _tmp477_;
			ValaExpression* _tmp478_;
			ValaExpression* _tmp479_;
			ValaDataType* _tmp480_;
			ValaDataType* _tmp481_;
			ValaMemberAccess* _tmp531_;
			ValaSymbol* _tmp532_;
			ValaSymbol* _tmp533_;
			_tmp474_ = vala_assignment_get_right (self);
			_tmp475_ = _tmp474_;
			_tmp476_ = vala_expression_get_value_type (_tmp475_);
			_tmp477_ = _tmp476_;
			_tmp478_ = vala_assignment_get_left (self);
			_tmp479_ = _tmp478_;
			_tmp480_ = vala_expression_get_value_type (_tmp479_);
			_tmp481_ = _tmp480_;
			if (!vala_data_type_compatible (_tmp477_, _tmp481_)) {
				ValaSourceReference* _tmp482_;
				ValaSourceReference* _tmp483_;
				ValaExpression* _tmp484_;
				ValaExpression* _tmp485_;
				ValaDataType* _tmp486_;
				ValaDataType* _tmp487_;
				gchar* _tmp488_;
				gchar* _tmp489_;
				ValaExpression* _tmp490_;
				ValaExpression* _tmp491_;
				ValaDataType* _tmp492_;
				ValaDataType* _tmp493_;
				gchar* _tmp494_;
				gchar* _tmp495_;
				gchar* _tmp496_;
				gchar* _tmp497_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp482_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp483_ = _tmp482_;
				_tmp484_ = vala_assignment_get_right (self);
				_tmp485_ = _tmp484_;
				_tmp486_ = vala_expression_get_value_type (_tmp485_);
				_tmp487_ = _tmp486_;
				_tmp488_ = vala_code_node_to_string ((ValaCodeNode*) _tmp487_);
				_tmp489_ = _tmp488_;
				_tmp490_ = vala_assignment_get_left (self);
				_tmp491_ = _tmp490_;
				_tmp492_ = vala_expression_get_value_type (_tmp491_);
				_tmp493_ = _tmp492_;
				_tmp494_ = vala_code_node_to_string ((ValaCodeNode*) _tmp493_);
				_tmp495_ = _tmp494_;
				_tmp496_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp489_, _tmp495_);
				_tmp497_ = _tmp496_;
				vala_report_error (_tmp483_, _tmp497_);
				_g_free0 (_tmp497_);
				_g_free0 (_tmp495_);
				_g_free0 (_tmp489_);
				result = FALSE;
				return result;
			} else {
				gboolean _tmp498_ = FALSE;
				gboolean _tmp499_ = FALSE;
				ValaExpression* _tmp500_;
				ValaExpression* _tmp501_;
				ValaDataType* _tmp502_;
				ValaDataType* _tmp503_;
				_tmp500_ = vala_assignment_get_left (self);
				_tmp501_ = _tmp500_;
				_tmp502_ = vala_expression_get_value_type (_tmp501_);
				_tmp503_ = _tmp502_;
				if (VALA_IS_ENUM_VALUE_TYPE (_tmp503_)) {
					ValaExpression* _tmp504_;
					ValaExpression* _tmp505_;
					ValaDataType* _tmp506_;
					ValaDataType* _tmp507_;
					_tmp504_ = vala_assignment_get_right (self);
					_tmp505_ = _tmp504_;
					_tmp506_ = vala_expression_get_value_type (_tmp505_);
					_tmp507_ = _tmp506_;
					_tmp499_ = VALA_IS_INTEGER_TYPE (_tmp507_);
				} else {
					_tmp499_ = FALSE;
				}
				if (_tmp499_) {
					gboolean _tmp508_ = FALSE;
					ValaExpression* _tmp509_;
					ValaExpression* _tmp510_;
					_tmp509_ = vala_assignment_get_right (self);
					_tmp510_ = _tmp509_;
					if (!VALA_IS_INTEGER_LITERAL (_tmp510_)) {
						_tmp508_ = TRUE;
					} else {
						ValaExpression* _tmp511_;
						ValaExpression* _tmp512_;
						const gchar* _tmp513_;
						const gchar* _tmp514_;
						_tmp511_ = vala_assignment_get_right (self);
						_tmp512_ = _tmp511_;
						_tmp513_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp512_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
						_tmp514_ = _tmp513_;
						_tmp508_ = g_strcmp0 (_tmp514_, "0") != 0;
					}
					_tmp498_ = _tmp508_;
				} else {
					_tmp498_ = FALSE;
				}
				if (_tmp498_) {
					ValaSourceReference* _tmp515_;
					ValaSourceReference* _tmp516_;
					ValaExpression* _tmp517_;
					ValaExpression* _tmp518_;
					ValaDataType* _tmp519_;
					ValaDataType* _tmp520_;
					gchar* _tmp521_;
					gchar* _tmp522_;
					ValaExpression* _tmp523_;
					ValaExpression* _tmp524_;
					ValaDataType* _tmp525_;
					ValaDataType* _tmp526_;
					gchar* _tmp527_;
					gchar* _tmp528_;
					gchar* _tmp529_;
					gchar* _tmp530_;
					_tmp515_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp516_ = _tmp515_;
					_tmp517_ = vala_assignment_get_right (self);
					_tmp518_ = _tmp517_;
					_tmp519_ = vala_expression_get_value_type (_tmp518_);
					_tmp520_ = _tmp519_;
					_tmp521_ = vala_code_node_to_string ((ValaCodeNode*) _tmp520_);
					_tmp522_ = _tmp521_;
					_tmp523_ = vala_assignment_get_left (self);
					_tmp524_ = _tmp523_;
					_tmp525_ = vala_expression_get_value_type (_tmp524_);
					_tmp526_ = _tmp525_;
					_tmp527_ = vala_code_node_to_string ((ValaCodeNode*) _tmp526_);
					_tmp528_ = _tmp527_;
					_tmp529_ = g_strdup_printf ("Assignment: Unsafe conversion from `%s' to `%s'", _tmp522_, _tmp528_);
					_tmp530_ = _tmp529_;
					vala_report_notice (_tmp516_, _tmp530_);
					_g_free0 (_tmp530_);
					_g_free0 (_tmp528_);
					_g_free0 (_tmp522_);
				}
			}
			_tmp531_ = ma;
			_tmp532_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp531_);
			_tmp533_ = _tmp532_;
			if (!VALA_IS_PROPERTY (_tmp533_)) {
				ValaExpression* _tmp534_;
				ValaExpression* _tmp535_;
				ValaDataType* _tmp536_;
				ValaDataType* _tmp537_;
				_tmp534_ = vala_assignment_get_right (self);
				_tmp535_ = _tmp534_;
				_tmp536_ = vala_expression_get_value_type (_tmp535_);
				_tmp537_ = _tmp536_;
				if (vala_data_type_is_disposable (_tmp537_)) {
					gboolean _tmp538_ = FALSE;
					ValaExpression* _tmp539_;
					ValaExpression* _tmp540_;
					ValaDataType* _tmp541_;
					ValaDataType* _tmp542_;
					_tmp539_ = vala_assignment_get_left (self);
					_tmp540_ = _tmp539_;
					_tmp541_ = vala_expression_get_value_type (_tmp540_);
					_tmp542_ = _tmp541_;
					if (!VALA_IS_POINTER_TYPE (_tmp542_)) {
						ValaExpression* _tmp543_;
						ValaExpression* _tmp544_;
						ValaDataType* _tmp545_;
						ValaDataType* _tmp546_;
						gboolean _tmp547_;
						gboolean _tmp548_;
						_tmp543_ = vala_assignment_get_left (self);
						_tmp544_ = _tmp543_;
						_tmp545_ = vala_expression_get_value_type (_tmp544_);
						_tmp546_ = _tmp545_;
						_tmp547_ = vala_data_type_get_value_owned (_tmp546_);
						_tmp548_ = _tmp547_;
						_tmp538_ = !_tmp548_;
					} else {
						_tmp538_ = FALSE;
					}
					if (_tmp538_) {
						ValaSourceReference* _tmp549_;
						ValaSourceReference* _tmp550_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp549_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp550_ = _tmp549_;
						vala_report_error (_tmp550_, "Invalid assignment from owned expression to unowned variable");
					}
				} else {
					ValaExpression* _tmp551_;
					ValaExpression* _tmp552_;
					ValaDataType* _tmp553_;
					ValaDataType* _tmp554_;
					gboolean _tmp555_;
					gboolean _tmp556_;
					_tmp551_ = vala_assignment_get_left (self);
					_tmp552_ = _tmp551_;
					_tmp553_ = vala_expression_get_value_type (_tmp552_);
					_tmp554_ = _tmp553_;
					_tmp555_ = vala_data_type_get_value_owned (_tmp554_);
					_tmp556_ = _tmp555_;
					if (_tmp556_) {
					}
				}
			}
		}
		_tmp557_ = vala_assignment_get_right (self);
		_tmp558_ = _tmp557_;
		right_ma = VALA_IS_MEMBER_ACCESS (_tmp558_) ? ((ValaMemberAccess*) _tmp558_) : NULL;
		_tmp560_ = right_ma;
		if (_tmp560_ != NULL) {
			ValaMemberAccess* _tmp561_;
			ValaSymbol* _tmp562_;
			ValaSymbol* _tmp563_;
			ValaMemberAccess* _tmp564_;
			ValaSymbol* _tmp565_;
			ValaSymbol* _tmp566_;
			_tmp561_ = ma;
			_tmp562_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp561_);
			_tmp563_ = _tmp562_;
			_tmp564_ = right_ma;
			_tmp565_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp564_);
			_tmp566_ = _tmp565_;
			_tmp559_ = _tmp563_ == _tmp566_;
		} else {
			_tmp559_ = FALSE;
		}
		if (_tmp559_) {
			gboolean _tmp567_ = FALSE;
			ValaMemberAccess* _tmp568_;
			ValaSymbol* _tmp569_;
			ValaSymbol* _tmp570_;
			_tmp568_ = ma;
			_tmp569_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp568_);
			_tmp570_ = _tmp569_;
			if (VALA_IS_LOCAL_VARIABLE (_tmp570_)) {
				_tmp567_ = TRUE;
			} else {
				ValaMemberAccess* _tmp571_;
				ValaSymbol* _tmp572_;
				ValaSymbol* _tmp573_;
				_tmp571_ = ma;
				_tmp572_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp571_);
				_tmp573_ = _tmp572_;
				_tmp567_ = VALA_IS_PARAMETER (_tmp573_);
			}
			if (_tmp567_) {
				ValaSourceReference* _tmp574_;
				ValaSourceReference* _tmp575_;
				_tmp574_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp575_ = _tmp574_;
				vala_report_warning (_tmp575_, "Assignment to same variable");
			} else {
				ValaMemberAccess* _tmp576_;
				ValaSymbol* _tmp577_;
				ValaSymbol* _tmp578_;
				_tmp576_ = ma;
				_tmp577_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp576_);
				_tmp578_ = _tmp577_;
				if (VALA_IS_FIELD (_tmp578_)) {
					ValaField* f = NULL;
					ValaMemberAccess* _tmp579_;
					ValaSymbol* _tmp580_;
					ValaSymbol* _tmp581_;
					ValaField* _tmp582_;
					ValaMemberBinding _tmp583_;
					ValaMemberBinding _tmp584_;
					_tmp579_ = ma;
					_tmp580_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp579_);
					_tmp581_ = _tmp580_;
					f = G_TYPE_CHECK_INSTANCE_CAST (_tmp581_, VALA_TYPE_FIELD, ValaField);
					_tmp582_ = f;
					_tmp583_ = vala_field_get_binding (_tmp582_);
					_tmp584_ = _tmp583_;
					if (_tmp584_ == VALA_MEMBER_BINDING_STATIC) {
						ValaSourceReference* _tmp585_;
						ValaSourceReference* _tmp586_;
						_tmp585_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp586_ = _tmp585_;
						vala_report_warning (_tmp586_, "Assignment to same variable");
					} else {
						ValaMemberAccess* ma_inner = NULL;
						ValaMemberAccess* _tmp587_;
						ValaExpression* _tmp588_;
						ValaExpression* _tmp589_;
						ValaMemberAccess* right_ma_inner = NULL;
						ValaMemberAccess* _tmp590_;
						ValaExpression* _tmp591_;
						ValaExpression* _tmp592_;
						gboolean _tmp593_ = FALSE;
						gboolean _tmp594_ = FALSE;
						gboolean _tmp595_ = FALSE;
						gboolean _tmp596_ = FALSE;
						gboolean _tmp597_ = FALSE;
						ValaMemberAccess* _tmp598_;
						_tmp587_ = ma;
						_tmp588_ = vala_member_access_get_inner (_tmp587_);
						_tmp589_ = _tmp588_;
						ma_inner = VALA_IS_MEMBER_ACCESS (_tmp589_) ? ((ValaMemberAccess*) _tmp589_) : NULL;
						_tmp590_ = right_ma;
						_tmp591_ = vala_member_access_get_inner (_tmp590_);
						_tmp592_ = _tmp591_;
						right_ma_inner = VALA_IS_MEMBER_ACCESS (_tmp592_) ? ((ValaMemberAccess*) _tmp592_) : NULL;
						_tmp598_ = ma_inner;
						if (_tmp598_ != NULL) {
							ValaMemberAccess* _tmp599_;
							const gchar* _tmp600_;
							const gchar* _tmp601_;
							_tmp599_ = ma_inner;
							_tmp600_ = vala_member_access_get_member_name (_tmp599_);
							_tmp601_ = _tmp600_;
							_tmp597_ = g_strcmp0 (_tmp601_, "this") == 0;
						} else {
							_tmp597_ = FALSE;
						}
						if (_tmp597_) {
							ValaMemberAccess* _tmp602_;
							ValaExpression* _tmp603_;
							ValaExpression* _tmp604_;
							_tmp602_ = ma_inner;
							_tmp603_ = vala_member_access_get_inner (_tmp602_);
							_tmp604_ = _tmp603_;
							_tmp596_ = _tmp604_ == NULL;
						} else {
							_tmp596_ = FALSE;
						}
						if (_tmp596_) {
							ValaMemberAccess* _tmp605_;
							_tmp605_ = right_ma_inner;
							_tmp595_ = _tmp605_ != NULL;
						} else {
							_tmp595_ = FALSE;
						}
						if (_tmp595_) {
							ValaMemberAccess* _tmp606_;
							const gchar* _tmp607_;
							const gchar* _tmp608_;
							_tmp606_ = right_ma_inner;
							_tmp607_ = vala_member_access_get_member_name (_tmp606_);
							_tmp608_ = _tmp607_;
							_tmp594_ = g_strcmp0 (_tmp608_, "this") == 0;
						} else {
							_tmp594_ = FALSE;
						}
						if (_tmp594_) {
							ValaMemberAccess* _tmp609_;
							ValaExpression* _tmp610_;
							ValaExpression* _tmp611_;
							_tmp609_ = right_ma_inner;
							_tmp610_ = vala_member_access_get_inner (_tmp609_);
							_tmp611_ = _tmp610_;
							_tmp593_ = _tmp611_ == NULL;
						} else {
							_tmp593_ = FALSE;
						}
						if (_tmp593_) {
							ValaSourceReference* _tmp612_;
							ValaSourceReference* _tmp613_;
							_tmp612_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp613_ = _tmp612_;
							vala_report_warning (_tmp613_, "Assignment to same variable");
						}
					}
				}
			}
		}
	} else {
		ValaElementAccess* _tmp614_;
		_tmp614_ = ea;
		if (_tmp614_ != NULL) {
			ValaExpression* _tmp615_;
			ValaExpression* _tmp616_;
			ValaDataType* _tmp617_;
			ValaDataType* _tmp618_;
			ValaExpression* _tmp619_;
			ValaExpression* _tmp620_;
			ValaDataType* _tmp621_;
			ValaDataType* _tmp622_;
			ValaExpression* _tmp639_;
			ValaExpression* _tmp640_;
			ValaDataType* _tmp641_;
			ValaDataType* _tmp642_;
			_tmp615_ = vala_assignment_get_right (self);
			_tmp616_ = _tmp615_;
			_tmp617_ = vala_expression_get_value_type (_tmp616_);
			_tmp618_ = _tmp617_;
			_tmp619_ = vala_assignment_get_left (self);
			_tmp620_ = _tmp619_;
			_tmp621_ = vala_expression_get_value_type (_tmp620_);
			_tmp622_ = _tmp621_;
			if (!vala_data_type_compatible (_tmp618_, _tmp622_)) {
				ValaSourceReference* _tmp623_;
				ValaSourceReference* _tmp624_;
				ValaExpression* _tmp625_;
				ValaExpression* _tmp626_;
				ValaDataType* _tmp627_;
				ValaDataType* _tmp628_;
				gchar* _tmp629_;
				gchar* _tmp630_;
				ValaExpression* _tmp631_;
				ValaExpression* _tmp632_;
				ValaDataType* _tmp633_;
				ValaDataType* _tmp634_;
				gchar* _tmp635_;
				gchar* _tmp636_;
				gchar* _tmp637_;
				gchar* _tmp638_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp623_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp624_ = _tmp623_;
				_tmp625_ = vala_assignment_get_right (self);
				_tmp626_ = _tmp625_;
				_tmp627_ = vala_expression_get_value_type (_tmp626_);
				_tmp628_ = _tmp627_;
				_tmp629_ = vala_code_node_to_string ((ValaCodeNode*) _tmp628_);
				_tmp630_ = _tmp629_;
				_tmp631_ = vala_assignment_get_left (self);
				_tmp632_ = _tmp631_;
				_tmp633_ = vala_expression_get_value_type (_tmp632_);
				_tmp634_ = _tmp633_;
				_tmp635_ = vala_code_node_to_string ((ValaCodeNode*) _tmp634_);
				_tmp636_ = _tmp635_;
				_tmp637_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp630_, _tmp636_);
				_tmp638_ = _tmp637_;
				vala_report_error (_tmp624_, _tmp638_);
				_g_free0 (_tmp638_);
				_g_free0 (_tmp636_);
				_g_free0 (_tmp630_);
				result = FALSE;
				return result;
			}
			_tmp639_ = vala_assignment_get_right (self);
			_tmp640_ = _tmp639_;
			_tmp641_ = vala_expression_get_value_type (_tmp640_);
			_tmp642_ = _tmp641_;
			if (vala_data_type_is_disposable (_tmp642_)) {
				ValaDataType* element_type = NULL;
				ValaElementAccess* _tmp643_;
				ValaExpression* _tmp644_;
				ValaExpression* _tmp645_;
				ValaDataType* _tmp646_;
				ValaDataType* _tmp647_;
				gboolean _tmp669_ = FALSE;
				ValaDataType* _tmp670_;
				_tmp643_ = ea;
				_tmp644_ = vala_element_access_get_container (_tmp643_);
				_tmp645_ = _tmp644_;
				_tmp646_ = vala_expression_get_value_type (_tmp645_);
				_tmp647_ = _tmp646_;
				if (VALA_IS_ARRAY_TYPE (_tmp647_)) {
					ValaArrayType* array_type = NULL;
					ValaElementAccess* _tmp648_;
					ValaExpression* _tmp649_;
					ValaExpression* _tmp650_;
					ValaDataType* _tmp651_;
					ValaDataType* _tmp652_;
					ValaArrayType* _tmp653_;
					ValaDataType* _tmp654_;
					ValaDataType* _tmp655_;
					ValaDataType* _tmp656_;
					_tmp648_ = ea;
					_tmp649_ = vala_element_access_get_container (_tmp648_);
					_tmp650_ = _tmp649_;
					_tmp651_ = vala_expression_get_value_type (_tmp650_);
					_tmp652_ = _tmp651_;
					array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp652_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
					_tmp653_ = array_type;
					_tmp654_ = vala_array_type_get_element_type (_tmp653_);
					_tmp655_ = _tmp654_;
					_tmp656_ = _vala_code_node_ref0 (_tmp655_);
					_vala_code_node_unref0 (element_type);
					element_type = _tmp656_;
				} else {
					ValaList* args = NULL;
					ValaElementAccess* _tmp657_;
					ValaExpression* _tmp658_;
					ValaExpression* _tmp659_;
					ValaDataType* _tmp660_;
					ValaDataType* _tmp661_;
					ValaList* _tmp662_;
					ValaList* _tmp663_;
					ValaList* _tmp664_;
					gint _tmp665_;
					gint _tmp666_;
					ValaList* _tmp667_;
					gpointer _tmp668_;
					_tmp657_ = ea;
					_tmp658_ = vala_element_access_get_container (_tmp657_);
					_tmp659_ = _tmp658_;
					_tmp660_ = vala_expression_get_value_type (_tmp659_);
					_tmp661_ = _tmp660_;
					_tmp662_ = vala_data_type_get_type_arguments (_tmp661_);
					_tmp663_ = _vala_iterable_ref0 (_tmp662_);
					args = _tmp663_;
					_tmp664_ = args;
					_tmp665_ = vala_collection_get_size ((ValaCollection*) _tmp664_);
					_tmp666_ = _tmp665_;
					_vala_assert (_tmp666_ == 1, "args.size == 1");
					_tmp667_ = args;
					_tmp668_ = vala_list_get (_tmp667_, 0);
					_vala_code_node_unref0 (element_type);
					element_type = (ValaDataType*) _tmp668_;
					_vala_iterable_unref0 (args);
				}
				_tmp670_ = element_type;
				if (!VALA_IS_POINTER_TYPE (_tmp670_)) {
					ValaDataType* _tmp671_;
					gboolean _tmp672_;
					gboolean _tmp673_;
					_tmp671_ = element_type;
					_tmp672_ = vala_data_type_get_value_owned (_tmp671_);
					_tmp673_ = _tmp672_;
					_tmp669_ = !_tmp673_;
				} else {
					_tmp669_ = FALSE;
				}
				if (_tmp669_) {
					ValaSourceReference* _tmp674_;
					ValaSourceReference* _tmp675_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp674_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp675_ = _tmp674_;
					vala_report_error (_tmp675_, "Invalid assignment from owned expression to unowned variable");
					result = FALSE;
					_vala_code_node_unref0 (element_type);
					return result;
				}
				_vala_code_node_unref0 (element_type);
			} else {
				ValaExpression* _tmp676_;
				ValaExpression* _tmp677_;
				ValaDataType* _tmp678_;
				ValaDataType* _tmp679_;
				gboolean _tmp680_;
				gboolean _tmp681_;
				_tmp676_ = vala_assignment_get_left (self);
				_tmp677_ = _tmp676_;
				_tmp678_ = vala_expression_get_value_type (_tmp677_);
				_tmp679_ = _tmp678_;
				_tmp680_ = vala_data_type_get_value_owned (_tmp679_);
				_tmp681_ = _tmp680_;
				if (_tmp681_) {
				}
			}
		} else {
			result = TRUE;
			return result;
		}
	}
	_tmp682_ = vala_assignment_get_left (self);
	_tmp683_ = _tmp682_;
	_tmp684_ = vala_expression_get_value_type (_tmp683_);
	_tmp685_ = _tmp684_;
	if (_tmp685_ != NULL) {
		ValaExpression* _tmp686_;
		ValaExpression* _tmp687_;
		ValaDataType* _tmp688_;
		ValaDataType* _tmp689_;
		ValaDataType* _tmp690_;
		ValaDataType* _tmp691_;
		ValaDataType* _tmp692_;
		ValaDataType* _tmp693_;
		_tmp686_ = vala_assignment_get_left (self);
		_tmp687_ = _tmp686_;
		_tmp688_ = vala_expression_get_value_type (_tmp687_);
		_tmp689_ = _tmp688_;
		_tmp690_ = vala_data_type_copy (_tmp689_);
		_tmp691_ = _tmp690_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp691_);
		_vala_code_node_unref0 (_tmp691_);
		_tmp692_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp693_ = _tmp692_;
		vala_data_type_set_value_owned (_tmp693_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp694_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp695_ = _tmp694_;
	if (_tmp695_ != NULL) {
		ValaDataType* _tmp696_;
		ValaDataType* _tmp697_;
		_tmp696_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp697_ = _tmp696_;
		vala_code_node_check ((ValaCodeNode*) _tmp697_, context);
	}
	_tmp698_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp699_ = _tmp698_;
	result = !_tmp699_;
	return result;
}

static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaBinaryExpression* _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	binary = VALA_IS_BINARY_EXPRESSION (_tmp1_) ? ((ValaBinaryExpression*) _tmp1_) : NULL;
	_tmp3_ = binary;
	if (_tmp3_ != NULL) {
		ValaBinaryExpression* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp4_ = binary;
		_tmp5_ = vala_binary_expression_get_left (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_expression_get_value_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = VALA_IS_ARRAY_TYPE (_tmp8_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaBinaryExpression* _tmp9_;
		ValaBinaryOperator _tmp10_;
		ValaBinaryOperator _tmp11_;
		_tmp9_ = binary;
		_tmp10_ = vala_binary_expression_get_operator (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaBinaryExpression* _tmp16_;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			_tmp12_ = vala_assignment_get_left (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_expression_get_symbol_reference (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = binary;
			_tmp17_ = vala_binary_expression_get_left (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_expression_get_symbol_reference (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp15_ == _tmp20_) {
				ValaBinaryExpression* _tmp21_;
				ValaExpression* _tmp22_;
				ValaExpression* _tmp23_;
				_tmp21_ = binary;
				_tmp22_ = vala_binary_expression_get_left (_tmp21_);
				_tmp23_ = _tmp22_;
				vala_expression_set_lvalue (_tmp23_, TRUE);
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static void
vala_assignment_check_constant_assignment (ValaAssignment* self,
                                           ValaMemberAccess* inner)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		if (!(inner != NULL)) {
			break;
		}
		_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) inner);
		_tmp1_ = _tmp0_;
		if (VALA_IS_CONSTANT (_tmp1_)) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			vala_report_error (_tmp3_, "Assignment to constant after initialization");
			break;
		}
		_tmp4_ = vala_member_access_get_inner (inner);
		_tmp5_ = _tmp4_;
		if (VALA_IS_MEMBER_ACCESS (_tmp5_)) {
			ValaExpression* _tmp6_;
			ValaExpression* _tmp7_;
			_tmp6_ = vala_member_access_get_inner (inner);
			_tmp7_ = _tmp6_;
			inner = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		} else {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (inner);
			_tmp9_ = _tmp8_;
			if (VALA_IS_ELEMENT_ACCESS (_tmp9_)) {
				ValaExpression* _tmp10_;
				ValaExpression* _tmp11_;
				ValaExpression* _tmp12_;
				ValaExpression* _tmp13_;
				_tmp10_ = vala_member_access_get_inner (inner);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_element_access_get_container (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
				_tmp13_ = _tmp12_;
				inner = VALA_IS_MEMBER_ACCESS (_tmp13_) ? ((ValaMemberAccess*) _tmp13_) : NULL;
			} else {
				inner = NULL;
			}
		}
	}
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static void
vala_assignment_real_emit (ValaCodeNode* base,
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaExpression* _tmp130_;
	ValaExpression* _tmp131_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL;
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp3_) ? ((ValaElementAccess*) _tmp3_) : NULL;
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	pi = VALA_IS_POINTER_INDIRECTION (_tmp5_) ? ((ValaPointerIndirection*) _tmp5_) : NULL;
	_tmp6_ = ma;
	if (_tmp6_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp13_;
		ValaSymbol* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		ValaField* _tmp21_;
		gboolean instance = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		ValaAssignmentOperator _tmp36_;
		gboolean _tmp115_ = FALSE;
		gboolean _tmp116_ = FALSE;
		_tmp7_ = ma;
		_tmp8_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp7_);
		_tmp9_ = _tmp8_;
		local = VALA_IS_LOCAL_VARIABLE (_tmp9_) ? ((ValaLocalVariable*) _tmp9_) : NULL;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		param = VALA_IS_PARAMETER (_tmp12_) ? ((ValaParameter*) _tmp12_) : NULL;
		_tmp13_ = ma;
		_tmp14_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp13_);
		_tmp15_ = _tmp14_;
		field = VALA_IS_FIELD (_tmp15_) ? ((ValaField*) _tmp15_) : NULL;
		_tmp16_ = ma;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp16_);
		_tmp18_ = _tmp17_;
		property = VALA_IS_PROPERTY (_tmp18_) ? ((ValaProperty*) _tmp18_) : NULL;
		_tmp21_ = field;
		if (_tmp21_ != NULL) {
			ValaField* _tmp22_;
			ValaMemberBinding _tmp23_;
			ValaMemberBinding _tmp24_;
			_tmp22_ = field;
			_tmp23_ = vala_field_get_binding (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp20_ = _tmp24_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			gboolean _tmp25_ = FALSE;
			ValaProperty* _tmp26_;
			_tmp26_ = property;
			if (_tmp26_ != NULL) {
				ValaProperty* _tmp27_;
				ValaMemberBinding _tmp28_;
				ValaMemberBinding _tmp29_;
				_tmp27_ = property;
				_tmp28_ = vala_property_get_binding (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp25_ = _tmp29_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp25_ = FALSE;
			}
			_tmp19_ = _tmp25_;
		}
		instance = _tmp19_;
		_tmp36_ = self->priv->_operator;
		if (_tmp36_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp37_ = FALSE;
			gboolean _tmp38_ = FALSE;
			ValaLocalVariable* _tmp39_;
			_tmp39_ = local;
			if (_tmp39_ != NULL) {
				_tmp38_ = TRUE;
			} else {
				ValaParameter* _tmp40_;
				_tmp40_ = param;
				_tmp38_ = _tmp40_ != NULL;
			}
			if (_tmp38_) {
				_tmp37_ = TRUE;
			} else {
				ValaField* _tmp41_;
				_tmp41_ = field;
				_tmp37_ = _tmp41_ != NULL;
			}
			_tmp35_ = _tmp37_;
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			_tmp34_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			ValaField* _tmp42_;
			_tmp42_ = field;
			_tmp33_ = !VALA_IS_ARRAY_LENGTH_FIELD (_tmp42_);
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			ValaField* _tmp43_;
			_tmp43_ = field;
			_tmp32_ = !VALA_IS_DELEGATE_TARGET_FIELD (_tmp43_);
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaField* _tmp44_;
			_tmp44_ = field;
			_tmp31_ = !VALA_IS_DELEGATE_DESTROY_FIELD (_tmp44_);
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			gboolean _tmp45_ = FALSE;
			ValaExpression* _tmp46_;
			ValaExpression* _tmp47_;
			ValaDataType* _tmp48_;
			ValaDataType* _tmp49_;
			_tmp46_ = vala_assignment_get_left (self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_expression_get_value_type (_tmp47_);
			_tmp49_ = _tmp48_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp49_)) {
				ValaExpression* _tmp50_;
				ValaExpression* _tmp51_;
				_tmp50_ = vala_assignment_get_right (self);
				_tmp51_ = _tmp50_;
				_tmp45_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp51_);
			} else {
				_tmp45_ = FALSE;
			}
			_tmp30_ = !_tmp45_;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			gboolean _tmp52_ = FALSE;
			ValaExpression* _tmp59_;
			ValaExpression* _tmp60_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp61_;
			ValaExpression* _tmp62_;
			ValaTargetValue* _tmp63_;
			ValaTargetValue* _tmp64_;
			ValaTargetValue* _tmp65_;
			ValaLocalVariable* _tmp66_;
			ValaCodeNode* _tmp91_;
			ValaCodeNode* _tmp92_;
			if (instance) {
				ValaMemberAccess* _tmp53_;
				ValaExpression* _tmp54_;
				ValaExpression* _tmp55_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_inner (_tmp53_);
				_tmp55_ = _tmp54_;
				_tmp52_ = _tmp55_ != NULL;
			} else {
				_tmp52_ = FALSE;
			}
			if (_tmp52_) {
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaExpression* _tmp58_;
				_tmp56_ = ma;
				_tmp57_ = vala_member_access_get_inner (_tmp56_);
				_tmp58_ = _tmp57_;
				vala_code_node_emit ((ValaCodeNode*) _tmp58_, codegen);
			}
			_tmp59_ = vala_assignment_get_right (self);
			_tmp60_ = _tmp59_;
			vala_code_node_emit ((ValaCodeNode*) _tmp60_, codegen);
			_tmp61_ = vala_assignment_get_right (self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_expression_get_target_value (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = _vala_target_value_ref0 (_tmp64_);
			new_value = _tmp65_;
			_tmp66_ = local;
			if (_tmp66_ != NULL) {
				ValaLocalVariable* _tmp67_;
				ValaTargetValue* _tmp68_;
				ValaSourceReference* _tmp69_;
				ValaSourceReference* _tmp70_;
				_tmp67_ = local;
				_tmp68_ = new_value;
				_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp70_ = _tmp69_;
				vala_code_generator_store_local (codegen, _tmp67_, _tmp68_, FALSE, _tmp70_);
			} else {
				ValaParameter* _tmp71_;
				_tmp71_ = param;
				if (_tmp71_ != NULL) {
					ValaParameter* _tmp72_;
					ValaTargetValue* _tmp73_;
					ValaSourceReference* _tmp74_;
					ValaSourceReference* _tmp75_;
					_tmp72_ = param;
					_tmp73_ = new_value;
					_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp75_ = _tmp74_;
					vala_code_generator_store_parameter (codegen, _tmp72_, _tmp73_, FALSE, _tmp75_);
				} else {
					ValaField* _tmp76_;
					_tmp76_ = field;
					if (_tmp76_ != NULL) {
						ValaTargetValue* _tmp77_ = NULL;
						gboolean _tmp78_ = FALSE;
						ValaField* _tmp87_;
						ValaTargetValue* _tmp88_;
						ValaSourceReference* _tmp89_;
						ValaSourceReference* _tmp90_;
						if (instance) {
							ValaMemberAccess* _tmp79_;
							ValaExpression* _tmp80_;
							ValaExpression* _tmp81_;
							_tmp79_ = ma;
							_tmp80_ = vala_member_access_get_inner (_tmp79_);
							_tmp81_ = _tmp80_;
							_tmp78_ = _tmp81_ != NULL;
						} else {
							_tmp78_ = FALSE;
						}
						if (_tmp78_) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							ValaTargetValue* _tmp85_;
							ValaTargetValue* _tmp86_;
							_tmp82_ = ma;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = vala_expression_get_target_value (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp77_ = _tmp86_;
						} else {
							_tmp77_ = NULL;
						}
						_tmp87_ = field;
						_tmp88_ = new_value;
						_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp90_ = _tmp89_;
						vala_code_generator_store_field (codegen, _tmp87_, _tmp77_, _tmp88_, _tmp90_);
					}
				}
			}
			_tmp91_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp92_ = _tmp91_;
			if (!VALA_IS_EXPRESSION_STATEMENT (_tmp92_)) {
				ValaLocalVariable* _tmp93_;
				_tmp93_ = local;
				if (_tmp93_ != NULL) {
					ValaLocalVariable* _tmp94_;
					ValaTargetValue* _tmp95_;
					ValaTargetValue* _tmp96_;
					_tmp94_ = local;
					_tmp95_ = vala_code_generator_load_local (codegen, _tmp94_, NULL);
					_tmp96_ = _tmp95_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp96_);
					_vala_target_value_unref0 (_tmp96_);
				} else {
					ValaParameter* _tmp97_;
					_tmp97_ = param;
					if (_tmp97_ != NULL) {
						ValaParameter* _tmp98_;
						ValaTargetValue* _tmp99_;
						ValaTargetValue* _tmp100_;
						_tmp98_ = param;
						_tmp99_ = vala_code_generator_load_parameter (codegen, _tmp98_, NULL);
						_tmp100_ = _tmp99_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp100_);
						_vala_target_value_unref0 (_tmp100_);
					} else {
						ValaField* _tmp101_;
						_tmp101_ = field;
						if (_tmp101_ != NULL) {
							ValaTargetValue* _tmp102_ = NULL;
							gboolean _tmp103_ = FALSE;
							ValaField* _tmp112_;
							ValaTargetValue* _tmp113_;
							ValaTargetValue* _tmp114_;
							if (instance) {
								ValaMemberAccess* _tmp104_;
								ValaExpression* _tmp105_;
								ValaExpression* _tmp106_;
								_tmp104_ = ma;
								_tmp105_ = vala_member_access_get_inner (_tmp104_);
								_tmp106_ = _tmp105_;
								_tmp103_ = _tmp106_ != NULL;
							} else {
								_tmp103_ = FALSE;
							}
							if (_tmp103_) {
								ValaMemberAccess* _tmp107_;
								ValaExpression* _tmp108_;
								ValaExpression* _tmp109_;
								ValaTargetValue* _tmp110_;
								ValaTargetValue* _tmp111_;
								_tmp107_ = ma;
								_tmp108_ = vala_member_access_get_inner (_tmp107_);
								_tmp109_ = _tmp108_;
								_tmp110_ = vala_expression_get_target_value (_tmp109_);
								_tmp111_ = _tmp110_;
								_tmp102_ = _tmp111_;
							} else {
								_tmp102_ = NULL;
							}
							_tmp112_ = field;
							_tmp113_ = vala_code_generator_load_field (codegen, _tmp112_, _tmp102_, NULL);
							_tmp114_ = _tmp113_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp114_);
							_vala_target_value_unref0 (_tmp114_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			return;
		}
		if (instance) {
			ValaMemberAccess* _tmp117_;
			ValaExpression* _tmp118_;
			ValaExpression* _tmp119_;
			_tmp117_ = ma;
			_tmp118_ = vala_member_access_get_inner (_tmp117_);
			_tmp119_ = _tmp118_;
			_tmp116_ = _tmp119_ != NULL;
		} else {
			_tmp116_ = FALSE;
		}
		if (_tmp116_) {
			ValaProperty* _tmp120_;
			_tmp120_ = property;
			_tmp115_ = _tmp120_ != NULL;
		} else {
			_tmp115_ = FALSE;
		}
		if (_tmp115_) {
			ValaMemberAccess* _tmp121_;
			ValaExpression* _tmp122_;
			ValaExpression* _tmp123_;
			_tmp121_ = ma;
			_tmp122_ = vala_member_access_get_inner (_tmp121_);
			_tmp123_ = _tmp122_;
			vala_code_node_emit ((ValaCodeNode*) _tmp123_, codegen);
		} else {
			ValaProperty* _tmp124_;
			_tmp124_ = property;
			if (_tmp124_ == NULL) {
				ValaMemberAccess* _tmp125_;
				_tmp125_ = ma;
				vala_code_node_emit ((ValaCodeNode*) _tmp125_, codegen);
			}
		}
	} else {
		ValaElementAccess* _tmp126_;
		_tmp126_ = ea;
		if (_tmp126_ != NULL) {
			ValaElementAccess* _tmp127_;
			_tmp127_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp127_, codegen);
		} else {
			ValaPointerIndirection* _tmp128_;
			_tmp128_ = pi;
			if (_tmp128_ != NULL) {
				ValaPointerIndirection* _tmp129_;
				_tmp129_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp129_, codegen);
			}
		}
	}
	_tmp130_ = vala_assignment_get_right (self);
	_tmp131_ = _tmp130_;
	vala_code_node_emit ((ValaCodeNode*) _tmp131_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaLocalVariable* _tmp12_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp7_) ? ((ValaLocalVariable*) _tmp7_) : NULL;
	_tmp8_ = vala_assignment_get_left (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_expression_get_symbol_reference (_tmp9_);
	_tmp11_ = _tmp10_;
	param = VALA_IS_PARAMETER (_tmp11_) ? ((ValaParameter*) _tmp11_) : NULL;
	_tmp12_ = local;
	if (_tmp12_ != NULL) {
		ValaLocalVariable* _tmp13_;
		_tmp13_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp13_);
	} else {
		gboolean _tmp14_ = FALSE;
		ValaParameter* _tmp15_;
		_tmp15_ = param;
		if (_tmp15_ != NULL) {
			ValaParameter* _tmp16_;
			ValaParameterDirection _tmp17_;
			ValaParameterDirection _tmp18_;
			_tmp16_ = param;
			_tmp17_ = vala_parameter_get_direction (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaParameter* _tmp19_;
			_tmp19_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp19_);
		}
	}
}

static void
vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMemberAccess* _tmp5_;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL;
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp3_) ? ((ValaElementAccess*) _tmp3_) : NULL;
	_tmp5_ = ma;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		_tmp6_ = ma;
		_tmp7_ = vala_member_access_get_inner (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaMemberAccess* _tmp9_;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		_tmp9_ = ma;
		_tmp10_ = vala_member_access_get_inner (_tmp9_);
		_tmp11_ = _tmp10_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
	} else {
		ValaElementAccess* _tmp12_;
		_tmp12_ = ea;
		if (_tmp12_ != NULL) {
			ValaElementAccess* _tmp13_;
			_tmp13_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
		}
	}
	_tmp14_ = vala_assignment_get_right (self);
	_tmp15_ = _tmp14_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
}

static void
vala_assignment_class_init (ValaAssignmentClass * klass,
                            gpointer klass_data)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_adjust_private_offset (klass, &ValaAssignment_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_assignment_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_assignment_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_used_variables;
}

static void
vala_assignment_instance_init (ValaAssignment * self,
                               gpointer klass)
{
	self->priv = vala_assignment_get_instance_private (self);
}

static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}

/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
static GType
vala_assignment_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
	GType vala_assignment_type_id;
	vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
	ValaAssignment_private_offset = g_type_add_instance_private (vala_assignment_type_id, sizeof (ValaAssignmentPrivate));
	return vala_assignment_type_id;
}

GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		GType vala_assignment_type_id;
		vala_assignment_type_id = vala_assignment_get_type_once ();
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}

const gchar*
vala_assignment_operator_to_string (ValaAssignmentOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_ASSIGNMENT_OPERATOR_SIMPLE:
		{
			result = "=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
		{
			result = "|=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
		{
			result = "&=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
		{
			result = "^=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_ADD:
		{
			result = "+=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SUB:
		{
			result = "-=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_MUL:
		{
			result = "*=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_DIV:
		{
			result = "/=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_PERCENT:
		{
			result = "%=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
		{
			result = "<<=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>=";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
vala_assignment_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
	GType vala_assignment_operator_type_id;
	vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
	return vala_assignment_operator_type_id;
}

GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = vala_assignment_operator_get_type_once ();
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}

