/* valatrystatement.c generated by valac, the Vala compiler
 * generated from valatrystatement.vala, do not modify */

/* valatrystatement.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>

enum  {
	VALA_TRY_STATEMENT_0_PROPERTY,
	VALA_TRY_STATEMENT_NUM_PROPERTIES
};
static GParamSpec* vala_try_statement_properties[VALA_TRY_STATEMENT_NUM_PROPERTIES];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaTryStatementPrivate {
	gboolean _after_try_block_reachable;
	ValaBlock* _body;
	ValaBlock* _finally_body;
	ValaList* catch_clauses;
};


static gpointer vala_try_statement_parent_class = NULL;
static ValaStatementIface * vala_try_statement_vala_statement_parent_iface = NULL;

#define VALA_TRY_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TRY_STATEMENT, ValaTryStatementPrivate))
static void vala_try_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_try_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_try_statement_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_try_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_try_statement_finalize (ValaCodeNode * obj);


/**
 * Creates a new try statement.
 *
 * @param body             body of the try statement
 * @param finally_body     body of the optional finally clause
 * @param source_reference reference to source code
 * @return                 newly created try statement
 */
ValaTryStatement* vala_try_statement_construct (GType object_type, ValaBlock* body, ValaBlock* finally_body, ValaSourceReference* source_reference) {
	ValaTryStatement* self = NULL;
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_val_if_fail (body != NULL, NULL);
	self = (ValaTryStatement*) vala_code_node_construct (object_type);
	_tmp0_ = body;
	vala_try_statement_set_body (self, _tmp0_);
	_tmp1_ = finally_body;
	vala_try_statement_set_finally_body (self, _tmp1_);
	_tmp2_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp2_);
	return self;
}


ValaTryStatement* vala_try_statement_new (ValaBlock* body, ValaBlock* finally_body, ValaSourceReference* source_reference) {
	return vala_try_statement_construct (VALA_TYPE_TRY_STATEMENT, body, finally_body, source_reference);
}


/**
 * Appends the specified clause to the list of catch clauses.
 *
 * @param clause a catch clause
 */
void vala_try_statement_add_catch_clause (ValaTryStatement* self, ValaCatchClause* clause) {
	ValaCatchClause* _tmp0_;
	ValaList* _tmp1_;
	ValaCatchClause* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clause != NULL);
	_tmp0_ = clause;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp0_, (ValaCodeNode*) self);
	_tmp1_ = self->priv->catch_clauses;
	_tmp2_ = clause;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp2_);
}


/**
 * Returns a copy of the list of catch clauses.
 *
 * @return list of catch clauses
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_try_statement_get_catch_clauses (ValaTryStatement* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->catch_clauses;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void vala_try_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaTryStatement * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaTryStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_try_statement (_tmp0_, self);
}


static void vala_try_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaTryStatement * self;
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	ValaBlock* _tmp16_;
	ValaBlock* _tmp17_;
	self = (ValaTryStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_try_statement_get_body (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	{
		ValaList* _clause_list = NULL;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _clause_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _clause_index = 0;
		_tmp3_ = self->priv->catch_clauses;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_clause_list = _tmp4_;
		_tmp5_ = _clause_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_clause_size = _tmp7_;
		_clause_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaCatchClause* clause = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaCatchClause* _tmp14_;
			ValaCodeVisitor* _tmp15_;
			_tmp8_ = _clause_index;
			_clause_index = _tmp8_ + 1;
			_tmp9_ = _clause_index;
			_tmp10_ = _clause_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _clause_list;
			_tmp12_ = _clause_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			clause = (ValaCatchClause*) _tmp13_;
			_tmp14_ = clause;
			_tmp15_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp14_, _tmp15_);
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	_tmp16_ = vala_try_statement_get_finally_body (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaBlock* _tmp18_;
		ValaBlock* _tmp19_;
		ValaCodeVisitor* _tmp20_;
		_tmp18_ = vala_try_statement_get_finally_body (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp19_, _tmp20_);
	}
}


static gboolean vala_try_statement_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaTryStatement * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaBlock* _tmp4_;
	ValaBlock* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaArrayList* error_types = NULL;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	ValaArrayList* handled_error_types = NULL;
	GEqualFunc _tmp23_;
	ValaArrayList* _tmp24_;
	ValaBlock* _tmp89_;
	ValaBlock* _tmp90_;
	ValaArrayList* _tmp108_;
	gboolean _tmp109_;
	gboolean _tmp110_;
	self = (ValaTryStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_try_statement_get_body (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp5_, _tmp6_);
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp7_);
	error_types = _tmp8_;
	{
		ValaList* _body_error_type_list = NULL;
		ValaBlock* _tmp9_;
		ValaBlock* _tmp10_;
		ValaList* _tmp11_;
		gint _body_error_type_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _body_error_type_index = 0;
		_tmp9_ = vala_try_statement_get_body (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp10_);
		_body_error_type_list = _tmp11_;
		_tmp12_ = _body_error_type_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_body_error_type_size = _tmp14_;
		_body_error_type_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			ValaDataType* body_error_type = NULL;
			ValaList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			ValaArrayList* _tmp21_;
			ValaDataType* _tmp22_;
			_tmp15_ = _body_error_type_index;
			_body_error_type_index = _tmp15_ + 1;
			_tmp16_ = _body_error_type_index;
			_tmp17_ = _body_error_type_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _body_error_type_list;
			_tmp19_ = _body_error_type_index;
			_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
			body_error_type = (ValaDataType*) _tmp20_;
			_tmp21_ = error_types;
			_tmp22_ = body_error_type;
			vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
			_vala_code_node_unref0 (body_error_type);
		}
		_vala_iterable_unref0 (_body_error_type_list);
	}
	_tmp23_ = g_direct_equal;
	_tmp24_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp23_);
	handled_error_types = _tmp24_;
	{
		ValaList* _clause_list = NULL;
		ValaList* _tmp25_;
		ValaList* _tmp26_;
		gint _clause_size = 0;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _clause_index = 0;
		_tmp25_ = self->priv->catch_clauses;
		_tmp26_ = _vala_iterable_ref0 (_tmp25_);
		_clause_list = _tmp26_;
		_tmp27_ = _clause_list;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_clause_size = _tmp29_;
		_clause_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			ValaCatchClause* clause = NULL;
			ValaList* _tmp33_;
			gint _tmp34_;
			gpointer _tmp35_;
			ValaArrayList* _tmp71_;
			ValaCatchClause* _tmp72_;
			ValaCodeContext* _tmp73_;
			_tmp30_ = _clause_index;
			_clause_index = _tmp30_ + 1;
			_tmp31_ = _clause_index;
			_tmp32_ = _clause_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _clause_list;
			_tmp34_ = _clause_index;
			_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
			clause = (ValaCatchClause*) _tmp35_;
			{
				ValaArrayList* _body_error_type_list = NULL;
				ValaArrayList* _tmp36_;
				ValaArrayList* _tmp37_;
				gint _body_error_type_size = 0;
				ValaArrayList* _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				gint _body_error_type_index = 0;
				_tmp36_ = error_types;
				_tmp37_ = _vala_iterable_ref0 (_tmp36_);
				_body_error_type_list = _tmp37_;
				_tmp38_ = _body_error_type_list;
				_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
				_tmp40_ = _tmp39_;
				_body_error_type_size = _tmp40_;
				_body_error_type_index = -1;
				while (TRUE) {
					gint _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					ValaDataType* body_error_type = NULL;
					ValaArrayList* _tmp44_;
					gint _tmp45_;
					gpointer _tmp46_;
					gboolean _tmp47_ = FALSE;
					ValaCatchClause* _tmp48_;
					ValaDataType* _tmp49_;
					ValaDataType* _tmp50_;
					_tmp41_ = _body_error_type_index;
					_body_error_type_index = _tmp41_ + 1;
					_tmp42_ = _body_error_type_index;
					_tmp43_ = _body_error_type_size;
					if (!(_tmp42_ < _tmp43_)) {
						break;
					}
					_tmp44_ = _body_error_type_list;
					_tmp45_ = _body_error_type_index;
					_tmp46_ = vala_list_get ((ValaList*) _tmp44_, _tmp45_);
					body_error_type = (ValaDataType*) _tmp46_;
					_tmp48_ = clause;
					_tmp49_ = vala_catch_clause_get_error_type (_tmp48_);
					_tmp50_ = _tmp49_;
					if (_tmp50_ == NULL) {
						_tmp47_ = TRUE;
					} else {
						ValaDataType* _tmp51_;
						ValaCatchClause* _tmp52_;
						ValaDataType* _tmp53_;
						ValaDataType* _tmp54_;
						gboolean _tmp55_;
						_tmp51_ = body_error_type;
						_tmp52_ = clause;
						_tmp53_ = vala_catch_clause_get_error_type (_tmp52_);
						_tmp54_ = _tmp53_;
						_tmp55_ = vala_data_type_compatible (_tmp51_, _tmp54_);
						_tmp47_ = _tmp55_;
					}
					if (_tmp47_) {
						ValaArrayList* _tmp56_;
						ValaDataType* _tmp57_;
						_tmp56_ = handled_error_types;
						_tmp57_ = body_error_type;
						vala_collection_add ((ValaCollection*) _tmp56_, _tmp57_);
					}
					_vala_code_node_unref0 (body_error_type);
				}
				_vala_iterable_unref0 (_body_error_type_list);
			}
			{
				ValaArrayList* _handled_error_type_list = NULL;
				ValaArrayList* _tmp58_;
				ValaArrayList* _tmp59_;
				gint _handled_error_type_size = 0;
				ValaArrayList* _tmp60_;
				gint _tmp61_;
				gint _tmp62_;
				gint _handled_error_type_index = 0;
				_tmp58_ = handled_error_types;
				_tmp59_ = _vala_iterable_ref0 (_tmp58_);
				_handled_error_type_list = _tmp59_;
				_tmp60_ = _handled_error_type_list;
				_tmp61_ = vala_collection_get_size ((ValaCollection*) _tmp60_);
				_tmp62_ = _tmp61_;
				_handled_error_type_size = _tmp62_;
				_handled_error_type_index = -1;
				while (TRUE) {
					gint _tmp63_;
					gint _tmp64_;
					gint _tmp65_;
					ValaDataType* handled_error_type = NULL;
					ValaArrayList* _tmp66_;
					gint _tmp67_;
					gpointer _tmp68_;
					ValaArrayList* _tmp69_;
					ValaDataType* _tmp70_;
					_tmp63_ = _handled_error_type_index;
					_handled_error_type_index = _tmp63_ + 1;
					_tmp64_ = _handled_error_type_index;
					_tmp65_ = _handled_error_type_size;
					if (!(_tmp64_ < _tmp65_)) {
						break;
					}
					_tmp66_ = _handled_error_type_list;
					_tmp67_ = _handled_error_type_index;
					_tmp68_ = vala_list_get ((ValaList*) _tmp66_, _tmp67_);
					handled_error_type = (ValaDataType*) _tmp68_;
					_tmp69_ = error_types;
					_tmp70_ = handled_error_type;
					vala_collection_remove ((ValaCollection*) _tmp69_, _tmp70_);
					_vala_code_node_unref0 (handled_error_type);
				}
				_vala_iterable_unref0 (_handled_error_type_list);
			}
			_tmp71_ = handled_error_types;
			vala_collection_clear ((ValaCollection*) _tmp71_);
			_tmp72_ = clause;
			_tmp73_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp72_, _tmp73_);
			{
				ValaList* _body_error_type_list = NULL;
				ValaCatchClause* _tmp74_;
				ValaBlock* _tmp75_;
				ValaBlock* _tmp76_;
				ValaList* _tmp77_;
				gint _body_error_type_size = 0;
				ValaList* _tmp78_;
				gint _tmp79_;
				gint _tmp80_;
				gint _body_error_type_index = 0;
				_tmp74_ = clause;
				_tmp75_ = vala_catch_clause_get_body (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp76_);
				_body_error_type_list = _tmp77_;
				_tmp78_ = _body_error_type_list;
				_tmp79_ = vala_collection_get_size ((ValaCollection*) _tmp78_);
				_tmp80_ = _tmp79_;
				_body_error_type_size = _tmp80_;
				_body_error_type_index = -1;
				while (TRUE) {
					gint _tmp81_;
					gint _tmp82_;
					gint _tmp83_;
					ValaDataType* body_error_type = NULL;
					ValaList* _tmp84_;
					gint _tmp85_;
					gpointer _tmp86_;
					ValaArrayList* _tmp87_;
					ValaDataType* _tmp88_;
					_tmp81_ = _body_error_type_index;
					_body_error_type_index = _tmp81_ + 1;
					_tmp82_ = _body_error_type_index;
					_tmp83_ = _body_error_type_size;
					if (!(_tmp82_ < _tmp83_)) {
						break;
					}
					_tmp84_ = _body_error_type_list;
					_tmp85_ = _body_error_type_index;
					_tmp86_ = vala_list_get (_tmp84_, _tmp85_);
					body_error_type = (ValaDataType*) _tmp86_;
					_tmp87_ = error_types;
					_tmp88_ = body_error_type;
					vala_collection_add ((ValaCollection*) _tmp87_, _tmp88_);
					_vala_code_node_unref0 (body_error_type);
				}
				_vala_iterable_unref0 (_body_error_type_list);
			}
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	_tmp89_ = vala_try_statement_get_finally_body (self);
	_tmp90_ = _tmp89_;
	if (_tmp90_ != NULL) {
		ValaBlock* _tmp91_;
		ValaBlock* _tmp92_;
		ValaCodeContext* _tmp93_;
		_tmp91_ = vala_try_statement_get_finally_body (self);
		_tmp92_ = _tmp91_;
		_tmp93_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp92_, _tmp93_);
		{
			ValaList* _body_error_type_list = NULL;
			ValaBlock* _tmp94_;
			ValaBlock* _tmp95_;
			ValaList* _tmp96_;
			gint _body_error_type_size = 0;
			ValaList* _tmp97_;
			gint _tmp98_;
			gint _tmp99_;
			gint _body_error_type_index = 0;
			_tmp94_ = vala_try_statement_get_finally_body (self);
			_tmp95_ = _tmp94_;
			_tmp96_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp95_);
			_body_error_type_list = _tmp96_;
			_tmp97_ = _body_error_type_list;
			_tmp98_ = vala_collection_get_size ((ValaCollection*) _tmp97_);
			_tmp99_ = _tmp98_;
			_body_error_type_size = _tmp99_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp100_;
				gint _tmp101_;
				gint _tmp102_;
				ValaDataType* body_error_type = NULL;
				ValaList* _tmp103_;
				gint _tmp104_;
				gpointer _tmp105_;
				ValaArrayList* _tmp106_;
				ValaDataType* _tmp107_;
				_tmp100_ = _body_error_type_index;
				_body_error_type_index = _tmp100_ + 1;
				_tmp101_ = _body_error_type_index;
				_tmp102_ = _body_error_type_size;
				if (!(_tmp101_ < _tmp102_)) {
					break;
				}
				_tmp103_ = _body_error_type_list;
				_tmp104_ = _body_error_type_index;
				_tmp105_ = vala_list_get (_tmp103_, _tmp104_);
				body_error_type = (ValaDataType*) _tmp105_;
				_tmp106_ = error_types;
				_tmp107_ = body_error_type;
				vala_collection_add ((ValaCollection*) _tmp106_, _tmp107_);
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
	}
	_tmp108_ = error_types;
	vala_code_node_add_error_types ((ValaCodeNode*) self, (ValaList*) _tmp108_);
	_tmp109_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp110_ = _tmp109_;
	result = !_tmp110_;
	_vala_iterable_unref0 (handled_error_types);
	_vala_iterable_unref0 (error_types);
	return result;
}


static void vala_try_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaTryStatement * self;
	ValaCodeGenerator* _tmp0_;
	self = (ValaTryStatement*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = codegen;
	vala_code_visitor_visit_try_statement ((ValaCodeVisitor*) _tmp0_, self);
}


ValaBlock* vala_try_statement_get_body (ValaTryStatement* self) {
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_try_statement_set_body (ValaTryStatement* self, ValaBlock* value) {
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp1_;
	_tmp2_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaBlock* vala_try_statement_get_finally_body (ValaTryStatement* self) {
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_finally_body;
	result = _tmp0_;
	return result;
}


void vala_try_statement_set_finally_body (ValaTryStatement* self, ValaBlock* value) {
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_finally_body);
	self->priv->_finally_body = _tmp1_;
	_tmp2_ = self->priv->_finally_body;
	if (_tmp2_ != NULL) {
		ValaBlock* _tmp3_;
		_tmp3_ = self->priv->_finally_body;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp3_, (ValaCodeNode*) self);
	}
}


gboolean vala_try_statement_get_after_try_block_reachable (ValaTryStatement* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_after_try_block_reachable;
	result = _tmp0_;
	return result;
}


void vala_try_statement_set_after_try_block_reachable (ValaTryStatement* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_after_try_block_reachable = _tmp0_;
}


static void vala_try_statement_class_init (ValaTryStatementClass * klass) {
	vala_try_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_try_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaTryStatementPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_try_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_try_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_try_statement_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_try_statement_real_emit;
}


static void vala_try_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_try_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_try_statement_instance_init (ValaTryStatement * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_TRY_STATEMENT_GET_PRIVATE (self);
	self->priv->_after_try_block_reachable = TRUE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_CATCH_CLAUSE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->catch_clauses = (ValaList*) _tmp1_;
}


static void vala_try_statement_finalize (ValaCodeNode * obj) {
	ValaTryStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_TRY_STATEMENT, ValaTryStatement);
	_vala_code_node_unref0 (self->priv->_body);
	_vala_code_node_unref0 (self->priv->_finally_body);
	_vala_iterable_unref0 (self->priv->catch_clauses);
	VALA_CODE_NODE_CLASS (vala_try_statement_parent_class)->finalize (obj);
}


/**
 * Represents a try statement in the source code.
 */
GType vala_try_statement_get_type (void) {
	static volatile gsize vala_try_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_try_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTryStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_try_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTryStatement), 0, (GInstanceInitFunc) vala_try_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_try_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_try_statement_type_id;
		vala_try_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaTryStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_try_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_try_statement_type_id__volatile, vala_try_statement_type_id);
	}
	return vala_try_statement_type_id__volatile;
}



