/*****************************************************************************/
/* td_mod_tree_prop.h : Objet Gtk+
 * td_mod_tree_prop.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>


/*****************************************************************************/
/* Macros */
/*****************************************************************************/
#define TD_TYPE_MOD_TREE_PROP (td_mod_tree_prop_get_type ())
#define TD_MOD_TREE_PROP(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_MOD_TREE_PROP, TdModTreeProp))
#define TD_MOD_TREE_PROP_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_MOD_TREE_PROP, TdModTreePropClass))
#define TD_IS_MOD_TREE_PROP(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_MOD_TREE_PROP))
#define TD_IS_MOD_TREE_PROP_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_MOD_TREE_PROP))

/*****************************************************************************/
/* Structure */
/*****************************************************************************/
typedef struct _TdModTreeProp TdModTreeProp;
typedef struct _TdModTreePropClass TdModTreePropClass;

struct _TdModTreeProp
{
  GtkObject object;
  gchar *name;
  gchar *defaultv;
  int tab;
  int column;
  GtkWidget *label;
  GtkWidget *widget;
  GtkWidget *widget_parent;
  GList *visible;
  GList *unsensitive;
};

struct _TdModTreePropClass
{
  GtkObjectClass parent_class;
  void (*set_widget) (TdModTreeProp *mod_tree_prop, GtkWidget *widget, GtkWidget *widget_parent);
  void (*add_visible) (TdModTreeProp *mod_tree_prop, GtkObject *equal);
  void (*add_unsensitive) (TdModTreeProp *mod_tree_prop, GtkObject *equal);
};

/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
void td_mod_tree_prop_set_name (TdModTreeProp *mod_tree_prop, gchar *name);
void td_mod_tree_prop_set_defaultv (TdModTreeProp *mod_tree_prop, gchar *defaultv);
void td_mod_tree_prop_set_tab (TdModTreeProp *mod_tree_prop, int tab);
void td_mod_tree_prop_set_column (TdModTreeProp *mod_tree_prop, int column);
static void td_mod_tree_prop_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_mod_tree_prop_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_mod_tree_prop_init (TdModTreeProp *mod_tree_prop);
static void td_mod_tree_prop_class_init (TdModTreePropClass *klass);
GtkType td_mod_tree_prop_get_type (void);
GtkObject *td_mod_tree_prop_new (void);

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_mod_tree_prop_set_widget (TdModTreeProp *mod_tree_prop, GtkWidget *widget, GtkWidget *widget_parent);
void td_mod_tree_prop_add_visible (TdModTreeProp *mod_tree_prop, GtkObject *equal);
void td_mod_tree_prop_add_unsensitive (TdModTreeProp *mod_tree_prop, GtkObject *equal);

/*****************************************************************************/
/* Commandes */
/*****************************************************************************/




