/*****************************************************************************/
/* td_mod_tree_prop.c : Objet Gtk+
 * td_mod_tree_prop.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "td_mod_tree_prop.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_DEFAULTV,
  ARG_TAB,
  ARG_COLUMN,
};

void td_mod_tree_prop_set_name (TdModTreeProp *mod_tree_prop, gchar *name)
{
  g_return_if_fail (mod_tree_prop != NULL);
  g_return_if_fail (TD_IS_MOD_TREE_PROP (mod_tree_prop));
  if (mod_tree_prop->name != name)
    {
      mod_tree_prop->name = name;
      mod_tree_prop->label = gtk_label_new (name);
    }
}

void td_mod_tree_prop_set_defaultv (TdModTreeProp *mod_tree_prop, gchar *defaultv)
{
  g_return_if_fail (mod_tree_prop != NULL);
  g_return_if_fail (TD_IS_MOD_TREE_PROP (mod_tree_prop));
  if (mod_tree_prop->defaultv != defaultv)
    mod_tree_prop->defaultv = defaultv;
}

void td_mod_tree_prop_set_tab (TdModTreeProp *mod_tree_prop, int tab)
{
  g_return_if_fail (mod_tree_prop != NULL);
  g_return_if_fail (TD_IS_MOD_TREE_PROP (mod_tree_prop));
  if (mod_tree_prop->tab != tab)
    mod_tree_prop->tab = tab;
}

void td_mod_tree_prop_set_column (TdModTreeProp *mod_tree_prop, int column)
{
  g_return_if_fail (mod_tree_prop != NULL);
  g_return_if_fail (TD_IS_MOD_TREE_PROP (mod_tree_prop));
  if (mod_tree_prop->column != column)
    mod_tree_prop->column = column;
}

static void td_mod_tree_prop_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModTreeProp *mod_tree_prop;
  mod_tree_prop = TD_MOD_TREE_PROP (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_mod_tree_prop_set_name (mod_tree_prop, GTK_VALUE_STRING (*arg));
      break;
    case ARG_DEFAULTV:
      td_mod_tree_prop_set_defaultv (mod_tree_prop, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TAB:
      td_mod_tree_prop_set_tab (mod_tree_prop, GTK_VALUE_INT (*arg));
      break;
    case ARG_COLUMN:
      td_mod_tree_prop_set_column (mod_tree_prop, GTK_VALUE_INT (*arg));
      break;
    default:
      break;
    }
}

static void td_mod_tree_prop_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModTreeProp *mod_tree_prop;
  mod_tree_prop = TD_MOD_TREE_PROP (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = mod_tree_prop->name;
      break;
    case ARG_DEFAULTV:
      GTK_VALUE_STRING (*arg) = mod_tree_prop->defaultv;
      break;
    case ARG_TAB:
      GTK_VALUE_INT (*arg) = mod_tree_prop->tab;
      break;
    case ARG_COLUMN:
      GTK_VALUE_INT (*arg) = mod_tree_prop->column;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_mod_tree_prop_init (TdModTreeProp *mod_tree_prop)
{
  mod_tree_prop->name = NULL;
  mod_tree_prop->defaultv = NULL;
  mod_tree_prop->tab = -1;
  mod_tree_prop->column = -1;
  mod_tree_prop->label = NULL;
  mod_tree_prop->widget = NULL;
  mod_tree_prop->widget_parent = NULL;
  mod_tree_prop->visible = NULL;
  mod_tree_prop->unsensitive = NULL;
}

static void td_mod_tree_prop_class_init (TdModTreePropClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdModTreeProp::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdModTreeProp::defaultv", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_DEFAULTV);
  gtk_object_add_arg_type ("TdModTreeProp::tab", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_TAB);
  gtk_object_add_arg_type ("TdModTreeProp::column", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_COLUMN);
  object_class->set_arg = td_mod_tree_prop_set_arg;
  object_class->get_arg = td_mod_tree_prop_get_arg;
  klass->set_widget = td_mod_tree_prop_set_widget;
  klass->add_visible = td_mod_tree_prop_add_visible;
  klass->add_unsensitive = td_mod_tree_prop_add_unsensitive;
}

GtkType td_mod_tree_prop_get_type (void)
{
  static GtkType mod_tree_prop_type = 0;
  if (!mod_tree_prop_type)
    {
      static const GtkTypeInfo mod_tree_prop_info =
      {
  	"TdModTreeProp", sizeof (TdModTreeProp), sizeof (TdModTreePropClass),
  	(GtkClassInitFunc) td_mod_tree_prop_class_init,
	(GtkObjectInitFunc) td_mod_tree_prop_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      mod_tree_prop_type = gtk_type_unique (GTK_TYPE_OBJECT, &mod_tree_prop_info);
    }
  return mod_tree_prop_type;
}

GtkObject *td_mod_tree_prop_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_mod_tree_prop_get_type ()));
}


/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_mod_tree_prop_set_widget (TdModTreeProp *mod_tree_prop, GtkWidget *widget, GtkWidget *widget_parent)
{
  g_return_if_fail (mod_tree_prop != NULL);
  g_return_if_fail (TD_IS_MOD_TREE_PROP (mod_tree_prop));
  if (mod_tree_prop->widget != widget)
    mod_tree_prop->widget = widget;
  if (widget_parent)
    {
      if (mod_tree_prop->widget_parent != widget_parent)
	mod_tree_prop->widget_parent = widget_parent;
    }
  else
    if (mod_tree_prop->widget_parent != widget)
      mod_tree_prop->widget_parent = widget;
}

void td_mod_tree_prop_add_visible (TdModTreeProp *mod_tree_prop, GtkObject *equal)
{
  g_return_if_fail (mod_tree_prop != NULL);
  g_return_if_fail (TD_IS_MOD_TREE_PROP (mod_tree_prop));
  mod_tree_prop->visible = g_list_append (mod_tree_prop->visible, equal);
}

void td_mod_tree_prop_add_unsensitive (TdModTreeProp *mod_tree_prop, GtkObject *equal)
{
  g_return_if_fail (mod_tree_prop != NULL);
  g_return_if_fail (TD_IS_MOD_TREE_PROP (mod_tree_prop));
  mod_tree_prop->unsensitive = g_list_append (mod_tree_prop->unsensitive, equal);
}

