/*****************************************************************************/
/* td_mod_box.h : Objet Gtk+
 * td_mod_box.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>


/*****************************************************************************/
/* Macros */
/*****************************************************************************/
#define TD_TYPE_MOD_BOX (td_mod_box_get_type ())
#define TD_MOD_BOX(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_MOD_BOX, TdModBox))
#define TD_MOD_BOX_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_MOD_BOX, TdModBoxClass))
#define TD_IS_MOD_BOX(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_MOD_BOX))
#define TD_IS_MOD_BOX_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_MOD_BOX))

/*****************************************************************************/
/* Structure */
/*****************************************************************************/
typedef struct _TdModBox TdModBox;
typedef struct _TdModBoxClass TdModBoxClass;

struct _TdModBox
{
  GtkObject object;
  gchar *name;
  int id;
  int idparent;
  GtkWidget *label;
  GtkWidget *widget;
  gboolean customize;
};

struct _TdModBoxClass
{
  GtkObjectClass parent_class;
  void (*set_widget) (TdModBox *mod_box, GtkWidget *widget);
  void (*create) (TdModBox *mod_box, int id, int idparent);
};

/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static void td_mod_box_set_name (TdModBox *mod_box, gchar *name);
static void td_mod_box_set_id (TdModBox *mod_box, int id);
static void td_mod_box_set_idparent (TdModBox *mod_box, int idparent);
static void td_mod_box_set_customize (TdModBox *mod_box, gboolean customize);
static void td_mod_box_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_mod_box_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_mod_box_init (TdModBox *mod_box);
static void td_mod_box_class_init (TdModBoxClass *klass);
GtkType td_mod_box_get_type (void);
GtkObject *td_mod_box_new (void);

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_mod_box_set_widget (TdModBox *mod_box, GtkWidget *widget);

/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
void td_mod_box_create (TdModBox *mod_box, int id, int idparent);





