/*****************************************************************************/
/* td_mod.c : Objet Gtk+
 * td_mod.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>
#include <dirent.h>
#include <sys/stat.h>

#include "commons.h"
#include "gtdk.h"

#include "td_app.h"
#include "td_app_palette.h"
#include "td_app_editprop.h"

#include "td_mod.h"
#include "td_mod_tree.h"
#include "td_mod_box.h"
#include "td_mod_tree_prop.h"

#include "td_db_base.h"
#include "td_db_mod.h"
#include "td_db_connect.h"

#include "td_field.h"
#include "td_about.h"
#include "td_custom.h"
#include "td_flower.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_NAME_INTL,
  ARG_ICON,
  ARG_ID,
};

void td_mod_set_name (TdMod *mod, gchar *name)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (mod->name != name)
    mod->name = name;
}

void td_mod_set_name_intl (TdMod *mod, gchar *name_intl)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (mod->name_intl != name_intl)
    mod->name_intl = name_intl;
}

void td_mod_set_id (TdMod *mod, int id)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (mod->id != id)
    mod->id = id;
}

static void td_mod_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdMod *mod;
  mod = TD_MOD (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_mod_set_name (mod, GTK_VALUE_STRING (*arg));
      break;
    case ARG_NAME_INTL:
      td_mod_set_name_intl (mod, GTK_VALUE_STRING (*arg));
      break;
    case ARG_ID:
      td_mod_set_id (mod, GTK_VALUE_INT (*arg));
      break;
    default:
      break;
    }
}

static void td_mod_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdMod *mod;
  mod = TD_MOD (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = mod->name;
      break;
    case ARG_NAME_INTL:
      GTK_VALUE_STRING (*arg) = mod->name_intl;
      break;
    case ARG_ID:
      GTK_VALUE_INT (*arg) = mod->id;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_mod_init (TdMod *mod)
{
  mod->name = NULL;
  mod->name_intl = NULL;
  mod->id = 0;
  mod->window = NULL;
  mod->notebook = NULL;
  mod->child = NULL;
  mod->toolbar = NULL;
  mod->editprop = NULL;
  mod->statusbar = NULL;
  mod->about = NULL;
  mod->custom = NULL;
  mod->custom_browser = NULL;
  mod->custom_notebook = NULL;
  mod->custom_tree = NULL;
}

static void td_mod_class_init (TdModClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdMod::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdMod::name_intl", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME_INTL);
  gtk_object_add_arg_type ("TdMod::id", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_ID);
  object_class->set_arg = td_mod_set_arg;
  object_class->get_arg = td_mod_get_arg;
  klass->add_child = td_mod_add_child;
  klass->set_about = td_mod_set_about;
  klass->add_custom = td_mod_add_custom;
  klass->set_toolbar = td_mod_set_toolbar;
  klass->set_statusbar = td_mod_set_statusbar;
  klass->show = td_mod_show;
}

GtkType td_mod_get_type (void)
{
  static GtkType mod_type = 0;
  if (!mod_type)
    {
      static const GtkTypeInfo mod_info =
      {
  	"TdMod", sizeof (TdMod), sizeof (TdModClass),
  	(GtkClassInitFunc) td_mod_class_init,
	(GtkObjectInitFunc) td_mod_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      mod_type = gtk_type_unique (GTK_TYPE_OBJECT, &mod_info);
    }
  return mod_type;
}

GtkObject *td_mod_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_mod_get_type ()));
}

void td_mod_destroy (TdMod *mod)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  gtdk_window_save_conf (mod->name, mod->window);
  gtk_widget_destroy (mod->window);
  if (mod->editprop)
    gtk_widget_destroy (mod->editprop);
  g_list_free (mod->child);
  gtk_object_destroy (GTK_OBJECT (mod->about));
  gtk_object_destroy (GTK_OBJECT (mod));
}


/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_mod_add_child (TdMod *mod, GtkObject *child)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  mod->child = g_list_append (mod->child, child);
}

void td_mod_set_toolbar (TdMod *mod, GtkWidget *toolbar)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (mod->toolbar != toolbar)
    mod->toolbar = toolbar;
}

void td_mod_set_statusbar (TdMod *mod, GtkWidget *statusbar)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (mod->statusbar != statusbar)
    mod->statusbar = statusbar;
}

void td_mod_set_about (TdMod *mod, GtkObject *about)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (mod->about != about)
    mod->about = about;
}

void td_mod_add_custom (TdMod *mod, GtkObject *custom)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  mod->custom = g_list_append (mod->custom, custom);
}


/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
gboolean td_mod_create (TdMod *mod, int id)
{
  TdModTree *mod_tree_tmp;
  GtkWidget *dock;
  GtkWidget *table;
  int i, j, k;
  gboolean bool_tmp;
  GtkObject *config = NULL;

  /* Fentre */
  mod->id = id;
  mod->window = gnome_app_new (mod->name, NULL);
  gnome_app_enable_layout_config (GNOME_APP (mod->window), FALSE);
  gtk_window_set_policy (GTK_WINDOW (mod->window), TRUE, TRUE, FALSE);
  if ((id==-1) || (id==2))
    gtk_window_set_title (GTK_WINDOW (mod->window), g_strdup_printf ("ToutDoux : %s", mod->name_intl));
  else
    gtk_window_set_title (GTK_WINDOW (mod->window), g_strdup_printf ("ToutDoux : %s : %s", mod->name_intl, TD_DB_CONNECT (TD_APP(APP)->connect)->name));
  dock = GNOME_APP (mod->window)->dock;
  gnome_app_create_menus (GNOME_APP (mod->window), TD_APP (APP)->menu_gnomeui);
  gtdk_window_save_defaultconf (mod->name, 600, 400);
  gtdk_window_load_conf (mod->name, mod->window);

  /* Barres */
  if (mod->toolbar)
    {
      gnome_app_add_toolbar (GNOME_APP (mod->window), GTK_TOOLBAR (mod->toolbar), "toolbar", GNOME_DOCK_ITEM_BEH_EXCLUSIVE, GNOME_DOCK_TOP, 1, 0, 0);
      gtk_widget_show (mod->toolbar);
    }
  if (mod->statusbar)
    {
      gnome_app_set_statusbar (GNOME_APP (mod->window), mod->statusbar); 
      gtk_widget_show (mod->statusbar); 
    }

  /* Configuration */
  for (i=0; i<g_list_length (mod->child); i++)
    {
      /* mod_tree */
      if (TD_IS_MOD_TREE (g_list_nth_data (mod->child, i)))
	if (TD_MOD_TREE (g_list_nth_data (mod->child, i))->customize)
	  {
	    config = td_flower_new ();
	    gtk_object_set (GTK_OBJECT (config),
			    "space", "toutdoux-customize/1.0.1",
			    "root", "customize", 
			    "branch", "custom",
			    "petal", "group",
			    "foliole", "option",
			    "mode_type", TRUE, NULL);
	    td_flower_add_branch_attribut (TD_FLOWER (config), "name");
	    td_flower_add_branch_attribut (TD_FLOWER (config), "value");
	    td_flower_add_petal_attribut (TD_FLOWER (config), "name");
	    td_flower_add_petal_attribut (TD_FLOWER (config), "value");
	    td_flower_add_foliole_attribut (TD_FLOWER (config), "name");
	    td_flower_add_foliole_attribut (TD_FLOWER (config), "value");
	    td_flower_load_file (TD_FLOWER (config), g_strdup_printf ("%s/customize/%s.xml", TD_APP(APP)->dir_var, TD_MOD(mod)->name));
	    break;
	  }
    }

  /* Box enfants */
  mod->notebook = gtk_notebook_new ();
  gtk_widget_show (mod->notebook);
  gnome_app_set_contents (GNOME_APP (mod->window), mod->notebook);
  for (i=0; i<g_list_length (mod->child); i++)
    {
      /* mod_tree */
      if (TD_IS_MOD_TREE (g_list_nth_data (mod->child, i)))
	{
	  td_mod_tree_create (TD_MOD_TREE (g_list_nth_data (mod->child, i)), i, mod->id, config);
	  gtk_container_add (GTK_CONTAINER (mod->notebook), TD_MOD_TREE (g_list_nth_data (mod->child, i))->widget);
	  gtk_widget_show (TD_MOD_TREE (g_list_nth_data (mod->child, i))->label);
	  gtk_notebook_set_tab_label (GTK_NOTEBOOK (mod->notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (mod->notebook), i), TD_MOD_TREE (g_list_nth_data (mod->child, i))->label);
	}

      /* mod_widget */
      if (TD_IS_MOD_BOX (g_list_nth_data (mod->child, i)))
	{
	  gtk_container_add (GTK_CONTAINER (mod->notebook), TD_MOD_BOX (g_list_nth_data (mod->child, i))->widget);
	  gtk_widget_show (TD_MOD_BOX (g_list_nth_data (mod->child, i))->label);
	  gtk_notebook_set_tab_label (GTK_NOTEBOOK (mod->notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (mod->notebook), i), TD_MOD_BOX (g_list_nth_data (mod->child, i))->label);
	}
    }
  if (!TD_APP (APP)->mode_debug)
    gtk_notebook_set_show_tabs (GTK_NOTEBOOK (mod->notebook), FALSE);

  /* Editeur des proprits */
  if (id==-1)
    return TRUE;
  gtk_signal_connect (GTK_OBJECT (mod->notebook), "switch_page", GTK_SIGNAL_FUNC (td_mod_switch_page), GTK_OBJECT (mod));
  mod->editprop = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (mod->editprop);
  gtk_container_add (GTK_CONTAINER (TD_APP_EDITPROP (TD_APP (APP)->editprop)->notebook), mod->editprop);
  gtdk_vbox_title (mod->name_intl, mod->editprop);
  j = 0; 
  for (i=0; i<g_list_length (mod->child); i++)
    {
      mod_tree_tmp = g_list_nth_data (mod->child, i);
      j = j + (g_list_length (mod_tree_tmp->property));
    }
  table = gtk_table_new (j, 2, FALSE);
  gtk_widget_show (table);
  gtk_box_pack_start (GTK_BOX (mod->editprop), table, FALSE, FALSE, 0);
  k = 0;
  for (i=0; i<g_list_length (mod->child); i++)
    {
      mod_tree_tmp = g_list_nth_data (mod->child, i);
      for (j=0; j<g_list_length (mod_tree_tmp->property); j++)
	{
	  gtk_table_attach (GTK_TABLE (table), TD_MOD_TREE_PROP (g_list_nth_data (mod_tree_tmp->property, j))->label, 0, 1, k, k+1, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
	  gtk_misc_set_padding (GTK_MISC (TD_MOD_TREE_PROP (g_list_nth_data (mod_tree_tmp->property, j))->label), 5, 0);
	  gtk_widget_hide (TD_MOD_TREE_PROP (g_list_nth_data (mod_tree_tmp->property, j))->label);
	  gtk_table_attach (GTK_TABLE (table), TD_MOD_TREE_PROP (g_list_nth_data (mod_tree_tmp->property, j))->widget_parent, 1, 2, k, k+1, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	  gtk_widget_hide (TD_MOD_TREE_PROP (g_list_nth_data (mod_tree_tmp->property, j))->widget_parent);
	  k++;
	}
    }

  /* Appels fentre */
  gtk_signal_connect_object (GTK_OBJECT (mod->window), "delete_event", GTK_SIGNAL_FUNC (td_mod_hide), GTK_OBJECT (mod));
  gtk_widget_realize (GTK_WIDGET (mod->window));
  gtk_widget_hide (GTK_WIDGET (mod->window));
  return TRUE;
}

gboolean td_mod_hide (TdMod *mod)
{
  int i;
  gboolean bool_tmp;

  /* Fentre */
  gtdk_window_save_conf (mod->name, mod->window);
  gtk_widget_hide (GTK_WIDGET (mod->window));
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_APP_EDITPROP (TD_APP (APP)->editprop)->notebook), 0);

  /* Palette */
  if (!TD_APP (APP)->base)
    return TRUE;
  bool_tmp = FALSE;
  for (i=0; i<g_list_length (TD_DB_BASE (TD_APP (APP)->base)->mod); i++)
    if (!strcmp (TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->name, mod->name))
      {
	bool_tmp = TRUE;
	break;
      }
  if (bool_tmp)
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (g_list_nth_data (TD_APP_PALETTE (TD_APP (APP)->palette)->button, i)))) 
      gtk_button_clicked (GTK_BUTTON (g_list_nth_data (TD_APP_PALETTE (TD_APP (APP)->palette)->button, i)));
  return TRUE;
}

void td_mod_show (TdMod *mod)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  gtk_widget_show (GTK_WIDGET (mod->window));
  gtk_widget_hide_all (GNOME_APP (mod->window)->menubar->parent->parent);
  if (mod->id == -1)
    gtk_notebook_set_page (GTK_NOTEBOOK (TD_APP_EDITPROP (TD_APP (APP)->editprop)->notebook), 0);
  else
    gtk_notebook_set_page (GTK_NOTEBOOK (TD_APP_EDITPROP (TD_APP (APP)->editprop)->notebook), mod->id);
}

void td_mod_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, gint page_num, TdMod *mod)
{
  TdModTree *mod_tree_tmp;
  int i, j;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  for (i=0; i<g_list_length (mod->child); i++)
    {
      mod_tree_tmp = g_list_nth_data (mod->child, i);
      for (j=0; j<g_list_length (mod_tree_tmp->property); j++)
	{
	  gtk_widget_hide (TD_MOD_TREE_PROP (g_list_nth_data (mod_tree_tmp->property, j))->label);
	  gtk_widget_hide (TD_MOD_TREE_PROP (g_list_nth_data (mod_tree_tmp->property, j))->widget_parent);
	}
    }
}

GtkObject *td_mod_get (gchar *file)
{
  GtkObject *(*symbol)();
  void *plugins;
  plugins = dlopen (file, RTLD_LAZY);
  if (dlerror() !=NULL)
    {
      td_palette_message (_("Loading plug-in"), g_strdup_printf (_("Loading plug-in : file '%s' unreadable"), file), "failed");
      return NULL;
    }
  (gpointer*) symbol = td_dlsym (plugins, "", file, "plugins_mod_def");
  return (symbol ());
}


void td_mod_custom_show (GtkObject *mod)
{
  void (*symbol)();
  if (!TD_MOD (mod)->custom_browser)
    {
      (gpointer*) symbol = td_dlsym (PLUGINS_CORE[5], TD_APP(APP)->dir_plugins, "libcustomize.so", "plugins_create");
      symbol (mod);
    }
  td_mod_show (TD_MOD (TD_MOD (mod)->custom_browser));
}




