/*****************************************************************************/
/* td_field_dico.h : Objet Gtk+
 * td_field_dico.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>


/*****************************************************************************/
/* Macros */
/*****************************************************************************/
#define TD_TYPE_FIELD_DICO (td_field_dico_get_type ())
#define TD_FIELD_DICO(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_FIELD_DICO, TdFieldDico))
#define TD_FIELD_DICO_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_FIELD_DICO, TdFieldDicoClass))
#define TD_IS_FIELD_DICO(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_FIELD_DICO))
#define TD_IS_FIELD_DICO_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_FIELD_DICO))

/*****************************************************************************/
/* Structure */
/*****************************************************************************/
typedef struct _TdFieldDico TdFieldDico;
typedef struct _TdFieldDicoClass TdFieldDicoClass;

struct _TdFieldDico
{
  GtkObject object;
  GList *word;
  GList *word_intl;
  GList *word_lang;
};

struct _TdFieldDicoClass
{
  GtkObjectClass parent_class;
  void (*add_word_intl) (TdFieldDico *dico, gchar *word, gchar *word_intl);
  void (*add_word_lang) (TdFieldDico *dico, gchar *word);
};

/*****************************************************************************/
/* Arguments */
/*****************************************************************************/

/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_field_dico_init (TdFieldDico *dico);
static void td_field_dico_class_init (TdFieldDicoClass *klass);
GtkType td_field_dico_get_type (void);
GtkObject *td_field_dico_new (void);

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_field_dico_add_word_intl (TdFieldDico *dico, gchar *word, gchar *word_intl);
void td_field_dico_add_word_lang (TdFieldDico *dico, gchar *word);

/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
gchar *td_field_dico_2intl (TdFieldDico *dico, gchar *word);
gchar *td_field_dico_intl2 (TdFieldDico *dico, gchar *word);
