/*****************************************************************************/
/* td_field.h : Objet Gtk+
 * td_field.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>


/*****************************************************************************/
/* Macros */
/*****************************************************************************/
#define TD_TYPE_FIELD (td_field_get_type ())
#define TD_FIELD(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_FIELD, TdField))
#define TD_FIELD_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_FIELD, TdFieldClass))
#define TD_IS_FIELD(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_FIELD))
#define TD_IS_FIELD_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_FIELD))

/*****************************************************************************/
/* Structure */
/*****************************************************************************/
typedef struct _TdField TdField;
typedef struct _TdFieldClass TdFieldClass;

struct _TdField
{
  GtkObject object;
  gchar *name;
  gchar *name_intl;
  gchar *type;
  gboolean visible;
  GtkObject *dico;
};

struct _TdFieldClass
{
  GtkObjectClass parent_class;
  void (*set_dico) (TdField *field, GtkObject *dico);
};

/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
void td_field_set_name (TdField *field, gchar *name);
void td_field_set_name_intl (TdField *field, gchar *name_intl);
void td_field_set_type (TdField *field, gchar *type);
void td_field_set_visible (TdField *field, gboolean visible);
static void td_field_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_field_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_field_init (TdField *field);
static void td_field_class_init (TdFieldClass *klass);
GtkType td_field_get_type (void);
GtkObject *td_field_new (void);

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_field_set_dico (TdField *field, GtkObject *dico);


/*****************************************************************************/
/* Commandes */
/*****************************************************************************/









