/*****************************************************************************/
/* td_field.c : Objet Gtk+
 * td_field.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "td_field.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_NAME_INTL,
  ARG_TYPE,
  ARG_VISIBLE,
};

void td_field_set_name (TdField *field, gchar *name)
{
  g_return_if_fail (field != NULL);
  g_return_if_fail (TD_IS_FIELD (field));
  if (field->name != name)
    field->name = name;
}

void td_field_set_name_intl (TdField *field, gchar *name_intl)
{
  g_return_if_fail (field != NULL);
  g_return_if_fail (TD_IS_FIELD (field));
  if (field->name_intl != name_intl)
    field->name_intl = name_intl;
}

void td_field_set_type (TdField *field, gchar *type)
{
  g_return_if_fail (field != NULL);
  g_return_if_fail (TD_IS_FIELD (field));
  if (field->type != type)
    field->type = type;
}

void td_field_set_visible (TdField *field, gboolean visible)
{
  g_return_if_fail (field != NULL);
  g_return_if_fail (TD_IS_FIELD (field));
  if (field->visible != visible)
    field->visible = visible;
}

static void td_field_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdField *field;
  field = TD_FIELD (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_field_set_name (field, GTK_VALUE_STRING (*arg));
      break;
    case ARG_NAME_INTL:
      td_field_set_name_intl (field, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TYPE:
      td_field_set_type (field, GTK_VALUE_STRING (*arg));
      break;
    case ARG_VISIBLE:
      td_field_set_visible (field, GTK_VALUE_BOOL (*arg));
      break;
    default:
      break;
    }
}

static void td_field_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdField *field;
  field = TD_FIELD (object);
  switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = field->name;
      break;
    case ARG_NAME_INTL:
      GTK_VALUE_STRING (*arg) = field->name_intl;
      break;
    case ARG_TYPE:
      GTK_VALUE_STRING (*arg) = field->type;
      break;
    case ARG_VISIBLE:
      GTK_VALUE_BOOL (*arg) = field->visible;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_field_init (TdField *field)
{
  field->name = NULL;
  field->name_intl = NULL;
  field->type = NULL;
  field->visible = TRUE;
  field->dico = NULL;
}

static void td_field_class_init (TdFieldClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdField::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdField::name_intl", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME_INTL);
  gtk_object_add_arg_type ("TdField::type", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TYPE);
  gtk_object_add_arg_type ("TdField::visible", GTK_TYPE_BOOL, GTK_ARG_READWRITE, ARG_VISIBLE);
  object_class->set_arg = td_field_set_arg;
  object_class->get_arg = td_field_get_arg;
  klass->set_dico = td_field_set_dico;
}

GtkType td_field_get_type (void)
{
  static GtkType field_type = 0;
  if (!field_type)
    {
      static const GtkTypeInfo field_info =
      {
  	"TdField", sizeof (TdField), sizeof (TdFieldClass),
  	(GtkClassInitFunc) td_field_class_init,
	(GtkObjectInitFunc) td_field_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      field_type = gtk_type_unique (GTK_TYPE_OBJECT, &field_info);
    }
  return field_type;
}

GtkObject *td_field_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_field_get_type ()));
}


/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_field_set_dico (TdField *field, GtkObject *dico)
{
  g_return_if_fail (field != NULL);
  g_return_if_fail (TD_IS_FIELD (field));
  if (field->dico != dico)
    field->dico = dico;
}


/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
