/*****************************************************************************/
/* td_app_palette.h : Objet Gtk+
 * td_app_palette.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>


/*****************************************************************************/
/* Macros */
/*****************************************************************************/
#define TD_TYPE_APP_PALETTE (td_app_palette_get_type ())
#define TD_APP_PALETTE(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_APP_PALETTE, TdAppPalette))
#define TD_APP_PALETTE_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_APP_PALETTE, TdAppPaletteClass))
#define TD_IS_APP_PALETTE(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_APP_PALETTE))
#define TD_IS_APP_PALETTE_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_APP_PALETTE))

/*****************************************************************************/
/* Structure */
/*****************************************************************************/
typedef struct _TdAppPalette TdAppPalette;
typedef struct _TdAppPaletteClass TdAppPaletteClass;

struct _TdAppPalette
{
  GtkObject object;
  GtkWidget *window;
  GList *button;
  GtkWidget *button_table;
  GnomeUIInfo *menu_main;
  GList *menu;
  GtkWidget *status;
  GtkWidget *progressbarr;
  GList *custom;
};

struct _TdAppPaletteClass
{
  GtkObjectClass parent_class;
  void (*add_button) (TdAppPalette *palette, GtkWidget *button);
  void (*set_menu_main) (TdAppPalette *palette, GnomeUIInfo *menu_main);
  void (*add_menu) (TdAppPalette *palette, GtkObject *menu);
  void (*add_custom) (TdAppPalette *palette, GtkObject *custom);
  void (*create) (TdAppPalette *palette);
};

/*****************************************************************************/
/* Arguments */
/*****************************************************************************/

/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_app_palette_init (TdAppPalette *palette);
static void td_app_palette_class_init (TdAppPaletteClass *klass);
GtkType td_app_palette_get_type (void);
GtkObject *td_app_palette_new (void);
void td_app_palette_destroy (TdAppPalette *palette);

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_app_palette_add_button (TdAppPalette *palette, GtkWidget *button);
void td_app_palette_set_menu_main (TdAppPalette *palette, GnomeUIInfo *menu_main);;
void td_app_palette_add_menu (TdAppPalette *palette, GtkObject *menu);
void td_app_palette_add_custom (TdAppPalette *palette, GtkObject *custom);

/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
void td_app_palette_create (TdAppPalette *palette);
void td_app_palette_progressbar_init (TdAppPalette *palette, gchar *message);
void td_app_palette_progressbar_update (TdAppPalette *palette, float pourcentage);
void td_app_palette_progressbar_hide (TdAppPalette *palette);

/*****************************************************************************/
/* Fichier */
/*****************************************************************************/
gboolean td_app_palette_load (TdAppPalette *palette);
void td_app_palette_clear (TdAppPalette *palette);
gboolean td_app_palette_select (GtkToggleButton *togglebutton, gchar *bouton);

