/*****************************************************************************/
/* td_app_palette.c : Objet Gtk+
 * td_app_palette.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>

#include "commons.h"
#include "gtdk.h"

#include "td_app.h"
#include "td_app_palette.h"

#include "td_db_base.h"
#include "td_db_mod.h"

#include "td_about.h"

/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_app_palette_init (TdAppPalette *palette)
{
  palette->window = NULL;
  palette->button = NULL;
  palette->button_table = NULL;
  palette->menu_main = NULL;
  palette->menu = NULL;
  palette->status = NULL;
  palette->progressbarr = NULL;
  palette->custom = NULL;
}

static void td_app_palette_class_init (TdAppPaletteClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type ());
  klass->add_button = td_app_palette_add_button;
  klass->set_menu_main = td_app_palette_set_menu_main;
  klass->add_menu = td_app_palette_add_menu;
  klass->add_custom = td_app_palette_add_custom;
  klass->create = td_app_palette_create;
}

GtkType td_app_palette_get_type (void)
{
  static GtkType app_palette_type = 0;
  if (!app_palette_type)
    {
      static const GtkTypeInfo app_palette_info =
      {
  	"TdAppPalette", sizeof (TdAppPalette), sizeof (TdAppPaletteClass),
  	(GtkClassInitFunc) td_app_palette_class_init,
	(GtkObjectInitFunc) td_app_palette_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      app_palette_type = gtk_type_unique (GTK_TYPE_OBJECT, &app_palette_info);
    }
  return app_palette_type;
}

GtkObject *td_app_palette_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_app_palette_get_type ()));
}

void td_app_palette_destroy (TdAppPalette *palette)
{
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));
  gtk_widget_destroy (palette->window);
  g_list_free (palette->menu);
  g_list_free (palette->custom);
  g_list_free (palette->button);
  gtk_object_destroy (GTK_OBJECT (palette));
}


/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_app_palette_add_button (TdAppPalette *palette, GtkWidget *button)
{
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));
  palette->button = g_list_append (palette->button, button);
}

void td_app_palette_set_menu_main (TdAppPalette *palette, GnomeUIInfo *menu_main)
{
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));
  if (palette->menu_main != menu_main)
    palette->menu_main = menu_main;
}

void td_app_palette_add_menu (TdAppPalette *palette, GtkObject *menu)
{
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));
  palette->menu = g_list_append (palette->menu, menu);
}

void td_app_palette_add_custom (TdAppPalette *palette, GtkObject *custom)
{
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));
  palette->custom = g_list_append (palette->custom, custom);
}


/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
void td_app_palette_create (TdAppPalette *palette)
{
  GtkWidget *dock;
  GtkWidget *vbox1;
  GtkWidget *vbox2;
  GtkWidget *viewport1;
  gchar *txt_tampon;
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));

  /* Fentre */
  palette->window = gnome_app_new ("palette", NULL);
  gtk_window_set_policy (GTK_WINDOW (palette->window), FALSE, FALSE, FALSE);
  gtk_window_set_title (GTK_WINDOW (palette->window), "ToutDoux");
  dock = GNOME_APP (palette->window)->dock;
  gnome_app_create_menus (GNOME_APP (palette->window), palette->menu_main);

  /* Table */
  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gnome_app_set_contents (GNOME_APP (palette->window), vbox1);
  palette->button_table = gtk_table_new (1, 1, TRUE);
  gtk_widget_hide (palette->button_table);
  gtk_box_pack_start (GTK_BOX (vbox1), palette->button_table, FALSE, FALSE, 0);

  /* Barre d'tats */
  palette->status = gtk_entry_new ();
  gtk_entry_set_editable (GTK_ENTRY (palette->status), FALSE);
  gtk_box_pack_start (GTK_BOX (vbox1), palette->status, FALSE, FALSE, 0);
  gtk_widget_show (palette->status);
  palette->progressbarr = gtk_progress_bar_new ();
  gtk_widget_hide (palette->progressbarr);
  gtk_box_pack_start (GTK_BOX (vbox1), palette->progressbarr, FALSE, FALSE, 0);
  
  /* Appels */
  gtk_signal_connect_object (GTK_OBJECT (palette->window), "delete_event", GTK_SIGNAL_FUNC (td_app_quit), GTK_OBJECT (APP));
  gtk_widget_show (palette->window);
}

void td_app_palette_progressbar_init (TdAppPalette *palette, gchar *message)
{
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));
  gtk_entry_set_text (GTK_ENTRY (palette->status), message);
  gtk_progress_set_percentage (GTK_PROGRESS (palette->progressbarr), 0);
  gtk_widget_show (palette->progressbarr);
  while (gtk_events_pending())
    gtk_main_iteration();
}

void td_app_palette_progressbar_update (TdAppPalette *palette, float pourcentage)
{
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));
  gtk_progress_set_percentage (GTK_PROGRESS (palette->progressbarr), pourcentage);
  while (gtk_events_pending())
    gtk_main_iteration();
}

void td_app_palette_progressbar_hide (TdAppPalette *palette)
{
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));
  gtk_widget_hide (palette->progressbarr);
  gtk_progress_set_percentage (GTK_PROGRESS (palette->progressbarr), 0);
}

/*****************************************************************************/
/* Fichier */
/*****************************************************************************/
gboolean td_app_palette_load (TdAppPalette *palette)
{
  void (*symbol)();
  int column;
  GList *plugins_filelist = NULL;
  GList *list_plugins_name = NULL;
  GtkObject *mod_tmp;
  GtkWidget *pixmap;
  GtkTooltips *tool_tips;
  int i, j;
  gchar *txt_tmp;

  /* Lecture des greffons disponibles */
  td_palette_message (NULL, _("Creating palette"), "begin");
  td_palette_message (NULL, _("Palette : Reading plug-ins"), "begin");
  plugins_filelist = td_about_filelist (TD_APP(APP)->dir_plugins, _("view"));
  for (i=0; i<g_list_length (plugins_filelist); i++)
    list_plugins_name = g_list_append (list_plugins_name, (td_about_get (g_list_nth_data (plugins_filelist, i)))->name);
  td_palette_message (NULL, _("Palette : Reading plug-ins"), "end");

  /* Go ! */
  column = 5; /* FIXME: Fig, dynamique +tards */
  gtk_table_resize (GTK_TABLE (palette->button_table), (g_list_length (TD_DB_BASE (TD_APP (APP)->base)->mod) / column), column);
  gtk_widget_show (palette->button_table);
  for (i=0; i < g_list_length (TD_DB_BASE (TD_APP (APP)->base)->mod); i++)
    {
      /* Chargement greffon */
      PLUGINS_DATA[i] = NULL;
      mod_tmp = g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i);
      for (j=0; i < g_list_length (list_plugins_name); j++)
	{
	  if (strcmp (g_list_nth_data (list_plugins_name, j), TD_DB_MOD (mod_tmp)->name))
	    continue;
	  PLUGINS_DATA[i] = dlopen (g_list_nth_data (plugins_filelist, j), RTLD_LAZY);
	  break;
	}
      if (dlerror() !=NULL)
	{
	  td_palette_message (_("Loading plug-in"), g_strdup_printf (_("Loading plug-in : file '%s' unreadable"), g_list_nth_data (plugins_filelist, j)), "failed");
	  td_palette_message (NULL, _("Creating palette"), "end");
	  return FALSE;
	}

      /* Bouton palette */
      palette->button = NULL;
      td_app_palette_add_button (palette, gtk_toggle_button_new());
      gtk_widget_show (g_list_nth_data (palette->button, i));
      gtk_table_attach (GTK_TABLE (palette->button_table), g_list_nth_data (palette->button, i), (i % column), (i % column)+1, (i / column), (i / column)+1, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
      gtk_widget_set_usize (g_list_nth_data (palette->button, i), 28, 28);
      gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (g_list_nth_data (palette->button, i)), FALSE);
      pixmap = gtk_type_new (gnome_pixmap_get_type ());
      gnome_pixmap_load_file (GNOME_PIXMAP (pixmap), TD_ABOUT (td_about_get (g_list_nth_data (plugins_filelist, j)))->icon);
      gtk_widget_show (pixmap);
      gtk_container_add (GTK_CONTAINER (g_list_nth_data (palette->button, i)), pixmap);
      tool_tips = gtk_tooltips_new();
      gtk_tooltips_set_tip (GTK_TOOLTIPS (tool_tips), (g_list_nth_data (palette->button, i)), TD_DB_MOD(mod_tmp)->name, TD_DB_MOD(mod_tmp)->name);
      gtk_signal_connect (GTK_OBJECT (g_list_nth_data (palette->button, i)), "toggled", GTK_SIGNAL_FUNC (td_app_palette_select), TD_DB_MOD(mod_tmp)->name);

      /* Lancement du greffon */
      (gpointer*) symbol = td_dlsym (PLUGINS_DATA[i], "", g_list_nth_data (plugins_filelist, j), "plugins_init");
      symbol (3+i); /* 0, 1 et 2 sont rserves (vide, cogitation, bookmarks) */
      if (g_list_length (TD_DB_BASE (TD_APP (APP)->base)->mod) == 1)
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (g_list_nth_data (palette->button, i)), TRUE);
    }
  td_palette_message (NULL, _("Creating palette"), "end");
  g_list_free (plugins_filelist);
  g_list_free (list_plugins_name);
  return TRUE;
}

void td_app_palette_clear (TdAppPalette *palette)
{
  int i;
  g_return_if_fail (palette != NULL);
  g_return_if_fail (TD_IS_APP_PALETTE (palette));
  for (i=0; i<g_list_length (palette->button); i++)
    if (GTK_IS_TOGGLE_BUTTON (g_list_nth_data (palette->button, i)))
      gtk_widget_destroy (g_list_nth_data (palette->button, i));
  gtk_widget_hide (palette->button_table);
  palette->button = NULL;
}

gboolean td_app_palette_select (GtkToggleButton *togglebutton, gchar *bouton)
{
  void (*symbol)();
  int i;
  gchar *txt_tmp;

  /* Recherche du bouton */
  i = 0;
  while (strcmp (TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->name, bouton))
    i++;

  /* Afficher - cacher */
  if ((gtk_toggle_button_get_active (togglebutton)))
    {
      (gpointer*) symbol = td_dlsym (PLUGINS_DATA[i], "", TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->name, "plugins_show");
      symbol ();
    }
  else 
    {
      (gpointer*) symbol = td_dlsym (PLUGINS_DATA[i], "", TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->name, "plugins_hide");
      symbol ();
    }
  return TRUE;
}





