/*****************************************************************************/
/* td_app_menu.h : Objet Gtk+
 * td_app_menu.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>


/*****************************************************************************/
/* Macros */
/*****************************************************************************/
#define TD_TYPE_APP_MENU (td_app_menu_get_type ())
#define TD_APP_MENU(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_APP_MENU, TdAppMenu))
#define TD_APP_MENU_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_APP_MENU, TdAppMenuClass))
#define TD_IS_APP_MENU(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_APP_MENU))
#define TD_IS_APP_MENU_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_APP_MENU))

/*****************************************************************************/
/* Structure */
/*****************************************************************************/
typedef struct _TdAppMenu TdAppMenu;
typedef struct _TdAppMenuClass TdAppMenuClass;

struct _TdAppMenu
{
  gchar *label;
  gchar *type; /* mod, file, url ou db */
  gchar *path;
  gchar *path_parent;
  gchar *file;
  gchar *symbol;
};

struct _TdAppMenuClass
{
  GtkObjectClass parent_class;
};


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
void td_app_menu_set_label (TdAppMenu *menu, gchar *label);
void td_app_menu_set_type (TdAppMenu *menu, gchar *type);
void td_app_menu_set_path (TdAppMenu *menu, gchar *path);
void td_app_menu_set_path_parent (TdAppMenu *menu, gchar *path_parent);
void td_app_menu_set_file (TdAppMenu *menu, gchar *file);
void td_app_menu_set_symbol (TdAppMenu *menu, gchar *symbol);
static void td_app_menu_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_app_menu_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_app_menu_init (TdAppMenu *menu);
static void td_app_menu_class_init (TdAppMenuClass *klass);
GtkType td_app_menu_get_type (void);
GtkObject *td_app_menu_new (void);

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/

/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
gboolean td_app_menu_activate (GtkMenuItem *menuitem, gpointer user_data);
