/*****************************************************************************/
/* td_app.c : Objet Gtk+
 * td_app.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>

#include "commons.h"
#include "gtdk.h"

#include "td_app.h"
#include "td_app_palette.h"
#include "td_app_editprop.h"

#include "td_mod.h"

#include "td_db_connect.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_DIR_VAR,
  ARG_DIR_TMP,
  ARG_DIR_PLUGINS,
  ARG_DIR_TEMPLATE,
  ARG_DIR_DOC,
  ARG_MODIFIED,
  ARG_MODE_DEBUG,
  ARG_MODE_NOCOLOR,
};

void td_app_set_dir_var (TdApp *app, gchar *dir_var)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  if (app->dir_var != dir_var)
    app->dir_var = dir_var;
}

void td_app_set_dir_tmp (TdApp *app, gchar *dir_tmp)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  if (app->dir_tmp != dir_tmp)
    app->dir_tmp = dir_tmp;
}

void td_app_set_dir_plugins (TdApp *app, gchar *dir_plugins)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  if (app->dir_plugins != dir_plugins)
    app->dir_plugins = dir_plugins;
}

void td_app_set_dir_template (TdApp *app, gchar *dir_template)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  if (app->dir_template != dir_template)
    app->dir_template = dir_template;
}

void td_app_set_dir_doc (TdApp *app, gchar *dir_doc)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  if (app->dir_doc != dir_doc)
    app->dir_doc = dir_doc;
}

void td_app_set_modified (TdApp *app, gboolean modified)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  if (app->modified != modified)
    app->modified = modified;
}

void td_app_set_mode_debug (TdApp *app, gboolean mode_debug)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  if (app->mode_debug != mode_debug)
    app->mode_debug = mode_debug;
}

void td_app_set_mode_nocolor (TdApp *app, gboolean mode_nocolor)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  if (app->mode_nocolor != mode_nocolor)
    app->mode_nocolor = mode_nocolor;
}

static void td_app_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdApp *app;
  app = TD_APP (object);
  switch (arg_id)
    {
    case ARG_DIR_VAR:
      td_app_set_dir_var (app, GTK_VALUE_STRING (*arg));
      break;
    case ARG_DIR_TMP:
      td_app_set_dir_tmp (app, GTK_VALUE_STRING (*arg));
      break;
    case ARG_DIR_PLUGINS:
      td_app_set_dir_plugins (app, GTK_VALUE_STRING (*arg));
      break;
    case ARG_DIR_TEMPLATE:
      td_app_set_dir_template (app, GTK_VALUE_STRING (*arg));
      break;
    case ARG_DIR_DOC:
      td_app_set_dir_doc (app, GTK_VALUE_STRING (*arg));
      break;
    case ARG_MODIFIED:
      td_app_set_modified (app, GTK_VALUE_BOOL (*arg));
      break;
    case ARG_MODE_DEBUG:
      td_app_set_mode_debug (app, GTK_VALUE_BOOL (*arg));
      break;
    case ARG_MODE_NOCOLOR:
      td_app_set_mode_nocolor (app, GTK_VALUE_BOOL (*arg));
      break;
    default:
      break;
    }
}

static void td_app_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdApp *app;
  app = TD_APP (object);
   switch (arg_id)
    {
    case ARG_DIR_VAR:
      GTK_VALUE_STRING (*arg) = app->dir_var;
      break;
    case ARG_DIR_TMP:
      GTK_VALUE_STRING (*arg) = app->dir_tmp;
      break;
    case ARG_DIR_PLUGINS:
      GTK_VALUE_STRING (*arg) = app->dir_plugins;
      break;
    case ARG_DIR_TEMPLATE:
      GTK_VALUE_STRING (*arg) = app->dir_template;
      break;
    case ARG_DIR_DOC:
      GTK_VALUE_STRING (*arg) = app->dir_doc;
      break;
    case ARG_MODIFIED:
      GTK_VALUE_BOOL (*arg) = app->modified;
      break;
    case ARG_MODE_DEBUG:
      GTK_VALUE_BOOL (*arg) = app->mode_debug;
      break;
    case ARG_MODE_NOCOLOR:
      GTK_VALUE_BOOL (*arg) = app->mode_nocolor;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_app_init (TdApp *app)
{
  app->palette = NULL;
  app->editprop = NULL;
  app->dir_var = NULL;
  app->dir_tmp = NULL;
  app->dir_plugins = NULL;
  app->dir_template = NULL;
  app->dir_doc = NULL;
  app->modified = FALSE;
  app->mode_debug = FALSE;
  app->mode_nocolor = FALSE;
  app->admin_field = NULL;
  app->menu_main = NULL;
  app->menu_gnomeui = NULL;
  app->connect = NULL;
  app->base = NULL;
  app->about = NULL;
  app->custom = NULL;
  app->mod_core = NULL;
  app->mod_data = NULL;
  app->menu_mod = NULL;
}

static void td_app_class_init (TdAppClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type ());
  gtk_object_add_arg_type ("TdApp::dir_var", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_DIR_VAR);
  gtk_object_add_arg_type ("TdApp::dir_tmp", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_DIR_TMP);
  gtk_object_add_arg_type ("TdApp::dir_plugins", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_DIR_PLUGINS);
  gtk_object_add_arg_type ("TdApp::dir_template", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_DIR_TEMPLATE);
  gtk_object_add_arg_type ("TdApp::dir_doc", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_DIR_DOC);
  gtk_object_add_arg_type ("TdApp::modified", GTK_TYPE_BOOL, GTK_ARG_READWRITE, ARG_MODIFIED);
  gtk_object_add_arg_type ("TdApp::mode_debug", GTK_TYPE_BOOL, GTK_ARG_READWRITE, ARG_MODE_DEBUG);
  gtk_object_add_arg_type ("TdApp::mode_nocolor", GTK_TYPE_BOOL, GTK_ARG_READWRITE, ARG_MODE_NOCOLOR);
  object_class->set_arg = td_app_set_arg;
  object_class->get_arg = td_app_get_arg;
  klass->set_palette = td_app_set_palette;
  klass->set_editprop = td_app_set_editprop;
  klass->add_admin_field = td_app_add_admin_field;
  klass->set_menu_main = td_app_set_menu_main;
  klass->set_current = td_app_set_current;
  klass->set_modified = td_app_set_modified;
  klass->set_about = td_app_set_about;
  klass->add_custom = td_app_add_custom;
  klass->add_mod_data = td_app_add_mod_data;
  klass->add_menu_mod = td_app_add_menu_mod;
  klass->create = td_app_create;
  klass->quit = td_app_quit;
}

GtkType td_app_get_type (void)
{
  static GtkType app_type = 0;
  if (!app_type)
    {
      static const GtkTypeInfo app_info =
      {
  	"TdApp", sizeof (TdApp), sizeof (TdAppClass),
  	(GtkClassInitFunc) td_app_class_init,
	(GtkObjectInitFunc) td_app_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      app_type = gtk_type_unique (GTK_TYPE_OBJECT, &app_info);
    }
  return app_type;
}

GtkObject *td_app_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_app_get_type ()));
}

void td_app_quit (TdApp *app)
{
  void (*symbol)() = NULL;
  int i;
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));

  /* Fermeture du fichier en cours */
  td_palette_message (NULL, _("Quitting"), "begin");
  if (td_db_connect_close (NULL, NULL))
    {
      /* Modules noyaux */
      for (i=0; i<g_list_length (app->mod_core); i++)
	{
	  symbol = dlsym (PLUGINS_CORE[i], "plugins_destroy");
	  if (dlerror() != NULL)
	    td_palette_message (_("Execution plug-in"), g_strdup_printf (_("Execution plug-in : file '%s' : function '%s' not find"), g_list_nth_data (app->mod_core, i), "plugins_destroy"), "failed");
	  else
	    {
	      symbol ();
	      td_palette_message (NULL, g_strdup_printf (_("Execution plug-in : file '%s' : function '%s'"), g_list_nth_data (app->mod_core, i), "plugins_destroy"), "plugins");
	    }
	}

      /* Fentres de base */
      td_app_palette_destroy (TD_APP_PALETTE (TD_APP (app)->palette));
      td_app_editprop_destroy (TD_APP_EDITPROP (TD_APP (app)->editprop));

      /* Application */
      td_palette_message (NULL, _("Quitting"), "end");
      gtk_widget_destroy (app->menu_main);
      g_list_free (app->admin_field);
      g_list_free (app->custom);
      g_list_free (app->mod_core);
      g_list_free (app->mod_data);
      g_list_free (app->menu_mod);
      g_list_free (app->custom);
      gtk_object_destroy (app->palette);
      gtk_object_destroy (app->editprop);
      gtk_object_destroy (app->about);
      gtk_object_destroy (GTK_OBJECT (app));
      gtk_exit (0);
    }
  else
    td_palette_message (NULL, _("Quitting"), "end");
}

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_app_set_palette (TdApp *app, GtkObject *palette)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  if (app->palette != palette)
    app->palette = palette;
}

void td_app_set_editprop (TdApp *app, GtkObject *editprop)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  if (app->editprop != editprop)
    app->editprop = editprop;
}

void td_app_add_admin_field (TdApp *app, GtkObject *admin_field)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  app->admin_field = g_list_append (app->admin_field, admin_field);
}

void td_app_set_menu_main (TdApp *app, GnomeUIInfo *menu_gnomeui)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  if (app->menu_gnomeui != menu_gnomeui)
    {
      app->menu_gnomeui = menu_gnomeui;
      app->menu_main = gnome_popup_menu_new (menu_gnomeui);
    }
}

void td_app_set_current (TdApp *app, GtkObject *connect, GtkObject *base)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  if (app->connect != connect)
    app->connect = connect;
  if (app->base != base)
    app->base = base;
}

void td_app_set_about (TdApp *app, GtkObject *about)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  if (app->about != about)
    app->about = about;
}

void td_app_add_custom (TdApp *app, GtkObject *custom)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  app->custom = g_list_append (app->custom, custom);
}

gboolean td_app_add_mod_core (TdApp *app, gchar *mod_core, gchar *symbol, int id)
{
  void (*symbol2)();

  /* Chargement */
  app->mod_core = g_list_append (app->mod_core, mod_core);
  PLUGINS_CORE[g_list_length (app->mod_core)-1] = dlopen (mod_core, RTLD_LAZY);
  if (dlerror() !=NULL)
    {
      td_palette_message (_("Loading plug-in"), g_strdup_printf (_("Loading plug-in : file '%s' unreadable"), mod_core), "failed");
      return FALSE;
    }

  /* Initialisation */
  if (!symbol)
    return TRUE;
  symbol2 = dlsym (PLUGINS_CORE[g_list_length (app->mod_core)-1], symbol);
  if (dlerror() != NULL)
    {
      td_palette_message (_("Execution plug-in"), g_strdup_printf (_("Execution plug-in : file '%s' : function '%s' not find"), mod_core, symbol), "failed");
      return FALSE;
    }
  td_palette_message (NULL, g_strdup_printf (_("Execution plug-in : file '%s' : function '%s'"), mod_core, symbol), "plugins");
  if (id == -1)
    symbol2 ();
  else
    symbol2 (id);
  return TRUE;
}

void td_app_add_mod_data (TdApp *app, gchar *mod_data)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  app->mod_data = g_list_append (app->mod_data, mod_data);
}

void td_app_add_menu_mod (TdApp *app, GtkObject *menu_mod)
{
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));
  app->menu_mod = g_list_append (app->menu_mod, menu_mod);
}


/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
void td_app_create (TdApp *app)
{
  GtkObject *connect;
  g_return_if_fail (app != NULL);
  g_return_if_fail (TD_IS_APP (app));

  /* Connexion  */
  connect = td_db_connect_new();
  gtk_object_set (GTK_OBJECT (connect),
		  "name", _("New"),
		  "type", "empty", NULL);
  td_app_set_current (TD_APP (app), connect, NULL);

  /* Fentres de base */
  td_app_palette_create (TD_APP_PALETTE (TD_APP (app)->palette));
  td_app_editprop_create (TD_APP_EDITPROP (TD_APP (app)->editprop));
}

gboolean td_palette_message (gchar *chtit_message, gchar *message, gchar *type)
{
  /* FIXME: changer en td_message : +tards */
  void (*symbol)();
  GtkCTreeNode *node;
  GtkCTreeNode *node_parent;
  gchar *txt_tampon = NULL;
  gchar *txt[2];
  GdkColor transparent;
  gchar *type_lang = NULL;
  gchar *type_color = NULL;

  /* Adaptation */
  if (!message)
    message = g_strdup_printf ("%s", chtit_message);

  /* Ecriture dans la palette */
  if (TD_APP_PALETTE (TD_APP (APP)->palette)->status)
    {
      if (!strcmp (type, "failed"))
	gtk_entry_set_text (GTK_ENTRY (TD_APP_PALETTE (TD_APP (APP)->palette)->status), " ");
      if (!strcmp (type, "done"))
  	gtk_entry_set_text (GTK_ENTRY (TD_APP_PALETTE (TD_APP (APP)->palette)->status), " ");
      if (chtit_message)
	{
	  if (!strcmp (type, "message"))
	    txt_tampon = g_strdup_printf ("%s", chtit_message);
	  else
	    txt_tampon = g_strdup_printf ("%s : %s", chtit_message, type);
	  gtk_entry_set_text (GTK_ENTRY (TD_APP_PALETTE (TD_APP (APP)->palette)->status), txt_tampon);
	}
    }

  /* Console */
  if (!strcmp (type, "done"))
    {
      type_lang = g_strdup_printf ("%s", _("done"));
      type_color = "\033[32m\033[1m";
    }
  if (!strcmp (type, "tested"))
    {
      type_lang = g_strdup_printf ("%s", _("tested"));
      type_color = "\033[32m\033[1m";
    }
  if (!strcmp (type, "plugins"))
    {
      type_lang = g_strdup_printf ("%s", _("plugins"));
      type_color = "\033[32m\033[1m";
    }
  if (!strcmp (type, "command"))
    {
      type_lang = g_strdup_printf ("%s", _("command"));
      type_color = "\033[32m\033[1m";
    }
  if (!strcmp (type, "failed"))
    {
      type_lang = g_strdup_printf ("%s", _("failed"));
      type_color = "\033[31m\033[1m";
    }
  if (!strcmp (type, "stop"))
    {
      type_lang = g_strdup_printf ("%s", _("stop"));
      type_color = "\033[31m\033[1m";
    }
  if (!strcmp (type, "begin"))
    {
      type_lang = g_strdup_printf ("%s", _("begin"));
      type_color = "\033[0m";
    }
  if (!strcmp (type, "end"))
    {
      type_lang = g_strdup_printf ("%s", _("end"));
      type_color = "\033[0m";
    }
  if (!strcmp (type, "message"))
    {
      type_lang = g_strdup_printf ("%s", _("message"));
      type_color = "\033[0m";
    }
  if (!strcmp (type, "yes"))
    {
      type_lang = g_strdup_printf ("%s", _("yes"));
      type_color = "\033[36m\033[1m";
    }
  if (!strcmp (type, "no"))
    {
      type_lang = g_strdup_printf ("%s", _("no"));
      type_color = "\033[34m\033[1m";
    }
  if (!strcmp (type, "(null)"))
    {
      type_lang = ("(null)"); 
      type_color = "\033[0m";
    }
  if (!TD_APP (APP)->mode_nocolor)
    printf ("%s%s : %s\033[0m\n", type_color, message, type_lang);
  else
    printf ("%s : %s\n", message, type_lang);

  /* Arbre *//* FIXME: Module dfnis statiquement : personnalisable + tards */
  if (PLUGINS_CORE[2])
    {
      symbol = dlsym (PLUGINS_CORE[2], "plugins_new_message");
      if (dlerror() != NULL)
	printf (_("Displaying message tree failed\n"));
      else
	symbol (message, type);
    }

  /* Bouton d'arrt d'urgence - Big red button */
  if (type)
    if (!strcmp (type, "stop"))
      gtk_exit (1);

  /* Rafrachissement Gtk+ */
  while (gtk_events_pending())
    gtk_main_iteration();
  return TRUE;
}

gboolean td_app_mod_core_activate (TdApp *app, gchar *file, gchar *symbol)
{
  void (*symbol2)() = NULL;
  gboolean bool_tmp;
  int i;
  gchar *txt_tmp;

  /* Localisation du module */
  bool_tmp = FALSE;
  for (i=0; i<g_list_length (app->mod_core); i++)
    if (!strcmp (g_list_nth_data (app->mod_core, i), file))
      {
	bool_tmp = TRUE;
	break;
      }
  if (!bool_tmp)
    {
      td_palette_message (_("Execution plug-in"), g_strdup_printf (_("Execution plug-in : file '%s' not loaded"), file), "failed");
      return FALSE;
    }

  /* Go ! */
  (gpointer*) symbol2 = td_dlsym (PLUGINS_CORE[i], "", file, symbol);
  symbol2 ();
  return TRUE;
}
