/*****************************************************************************/
/* gtdk.c : Functions complmentaires aux objects standards gtk
 * gtdk.c : Additionals functions for standards objects
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/* Ctree */
/*****************************************************************************/
gboolean gtdk_ctree_expand (GtkWidget *widget, GtkCTreeNode *node, GtkWidget *scrolledwindow);
void gtdk_ctree_clear (GtkWidget *widget);
GtkCTreeNode *gtdk_ctree_next (GtkCTreeNode *node);
int gtdk_ctree_optimal_column_width (GtkWidget *widget, int column);
void gtdk_ctree_invert_expand_recursive (GtkCTree *ctree, GtkCTreeNode *node);

/*****************************************************************************/
/* Clist */
/*****************************************************************************/
int gtdk_clist_correction (GtkWidget *widget, int row, int bevent_y);
void gtdk_clist_adjustheight (GtkWidget *widget);

/*****************************************************************************/
/* Window */
/*****************************************************************************/
void gtdk_window_load_conf (gchar *fenetre, GtkWidget *window);
void gtdk_window_save_conf (gchar *fenetre, GtkWidget *window);
void gtdk_window_save_defaultconf (gchar *fenetre, int xfen, int yfen);

/*****************************************************************************/
/* VBox */
/*****************************************************************************/
void gtdk_vbox_title (gchar *title, GtkWidget *vbox);

/*****************************************************************************/
/* Entry */
/*****************************************************************************/
GtkWidget *gtdk_entry_file_selector (gchar *title, gchar *file);
void gtdk_entry_file_selector_clicked (GtkButton *button, GList *data);

/*****************************************************************************/
/* Option menu */
/*****************************************************************************/
void gtdk_option_menu_set_popdown_strings (GtkOptionMenu *widget, GList *data);
GtkWidget *gtdk_entry_option_menu (void);
void gtdk_entry_option_menu_select (GtkItem *item, GtkWidget *widget);
void gtdk_entry_option_menu_set_popdown_strings (GtkWidget *widget, GList *data);
