/*****************************************************************************/
/* gtdk.c : Functions complmentaires aux objects standards gtk
 * gtdk.c : Additionals functions for standards objects
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "gtdk.h"

/*****************************************************************************/
/* Ctree */
/*****************************************************************************/
gboolean gtdk_ctree_expand (GtkWidget *widget, GtkCTreeNode *node, GtkWidget *scrolledwindow)
{
  GtkCList *clist;
  GtkCTreeNode *node_selection;
  int i, row_debut, row_fin;
  GtkAdjustment *tampon_adjustement;

  /* Internal flag */
  if (FLAG_ANTI_AUTOEXPAND)
    return TRUE;

  /* Line */
  clist = GTK_CLIST (widget);
  i = 0;
  node_selection = GTK_CTREE_NODE (clist->row_list);
  while (node_selection && node_selection != node)
    {
      node_selection = GTK_CTREE_NODE_NEXT (node_selection);
      i++;
    }
  row_debut = i;

  /* Last one detection */
  if (GTK_CTREE_ROW(node_selection)->children)
    {
      node_selection = GTK_CTREE_ROW(node_selection)->children;
      gtk_ctree_collapse (GTK_CTREE(widget), node_selection);
      i++;
      while (GTK_CTREE_ROW(node_selection)->sibling)
	{
	  node_selection = GTK_CTREE_ROW(node_selection)->sibling;
	  gtk_ctree_collapse (GTK_CTREE(widget), node_selection);
	  i++;
	}
    }
  row_fin = i;

  /* Scroll */
  tampon_adjustement = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (scrolledwindow));
  for (i=row_debut; i<row_fin+1; i++)
    if (((i+1)*((GTK_CLIST (widget)->row_height)+1))>(tampon_adjustement->value+tampon_adjustement->page_size))
      if (((row_debut)*((GTK_CLIST (widget)->row_height)+1))>(tampon_adjustement->value))
	{
	  gtk_adjustment_set_value (tampon_adjustement, (tampon_adjustement->value)+((GTK_CLIST(widget)->row_height)+1)); /* FIXME: not clear :  this night */
	  gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (scrolledwindow), tampon_adjustement);
	}
  return TRUE;
}

/* Ctree razage */
void gtdk_ctree_clear (GtkWidget *widget)
{
  GtkCTreeNode *ctree_tampon;
  GtkCTreeNode *ctree_tampon_suivant;
  ctree_tampon = gtk_ctree_node_nth (GTK_CTREE(widget), 0);

  /* Go ! */
  while (ctree_tampon)
    {
      gtk_ctree_collapse (GTK_CTREE (widget), ctree_tampon);
      ctree_tampon_suivant =  GTK_CTREE_NODE_NEXT (ctree_tampon);
      gtk_ctree_remove_node (GTK_CTREE (widget), ctree_tampon);
      ctree_tampon = ctree_tampon_suivant;
    }
}

/* Next */
GtkCTreeNode *gtdk_ctree_next (GtkCTreeNode *node)
{
  GtkCTreeNode *node_parent;

  /* Go ! */
  if (GTK_CTREE_ROW (node)->children)
    return (GTK_CTREE_ROW (node)->children);
  if (GTK_CTREE_ROW (node)->sibling)
    return (GTK_CTREE_ROW (node)->sibling);
  do
    {
      node_parent = GTK_CTREE_ROW (node)->parent;
      if (!node_parent)
	node = NULL;
      else
	if (GTK_CTREE_ROW (node_parent)->sibling == NULL)
	  node = node_parent;
	else
	  node = GTK_CTREE_ROW (node_parent)->sibling;
    }
  while ((node == node_parent) && (node));
  return node;
}

/* Optimal width */
int gtdk_ctree_optimal_column_width (GtkWidget *widget, int column)
{
  GtkCTreeNode *node_tampon;
  gchar *txt_tampon;
  GdkPixmap *pixmap_tampon;
  GdkBitmap *mask_tampon;
  guint8 spacing_tampon;
  int txt_long;
  int level_long;
  int ret = 0;
  GdkFont *font = NULL;

  /* Text */
  font = widget->style->font;
  node_tampon = gtk_ctree_node_nth (GTK_CTREE (widget), 0);
  while (node_tampon)
    {
      gtk_ctree_node_get_pixtext (GTK_CTREE(widget), node_tampon, column, &txt_tampon, &spacing_tampon, &pixmap_tampon, &mask_tampon);
      txt_long = gdk_string_width (font, txt_tampon);
      level_long = (GTK_CTREE_ROW (node_tampon)->level*GTK_CTREE (widget)->tree_indent);
      if (txt_long+level_long > ret)
	ret = txt_long+level_long;
      node_tampon = gtdk_ctree_next (node_tampon);
    }
  return ret;
}

/* Expansion rcursive des parents d'une node */
void gtdk_ctree_invert_expand_recursive (GtkCTree *ctree, GtkCTreeNode *node)
{
  GtkCTreeNode *node_parent;

  /* Go ! */
  FLAG_ANTI_AUTOEXPAND = TRUE;
  gtk_ctree_expand (ctree, node);
  node_parent = GTK_CTREE_ROW (node)->parent;
  while (node_parent)
    {
      gtk_ctree_expand (ctree, node_parent);
      node_parent = GTK_CTREE_ROW (node_parent)->parent;
    }
  FLAG_ANTI_AUTOEXPAND = FALSE;
}


/*****************************************************************************/
/* Clist */
/*****************************************************************************/
/* Correction ventuelle suite  un gtk_clist_get_selection_info */
int gtdk_clist_correction (GtkWidget *widget, int row, int bevent_y)
{
  if ((row == 0) && (GTK_CLIST(widget)->rows !=0))
    {
      if (bevent_y <= (GTK_CLIST(widget)->row_height+1))
	return 0;
      else
	return -1;
    }
  if ((row >= (GTK_CLIST(widget)->rows))||(row<0))
    return -1;
  return row;
}

/* Ajustement minimal de ligne de liste au minimum 16 */
void gtdk_clist_adjustheight (GtkWidget *widget)
{
  if ((GTK_CLIST (widget)->row_height) < 16)
    gtk_clist_set_row_height (GTK_CLIST (widget), 16);
}


/*****************************************************************************/
/* Window */
/*****************************************************************************/
void gtdk_window_load_conf (gchar *fenetre, GtkWidget *window)
{
  gchar *txt_tampon;
  int xfen, yfen;

  /* x */
  txt_tampon = g_strdup_printf ("geometry-x/%s", fenetre);
  txt_tampon = g_strdup_printf ("%s", gnome_config_get_string(txt_tampon));
  if (!strcmp (txt_tampon, "(null)"))
    xfen = 600;
  else
    xfen = atoi (txt_tampon);

  /* y */
  txt_tampon = g_strdup_printf ("geometry-y/%s", fenetre);
  txt_tampon = g_strdup_printf ("%s", gnome_config_get_string(txt_tampon));
  if (!strcmp (txt_tampon, "(null)"))
    yfen = 400;
  else
    yfen = atoi (txt_tampon);

  /* Redimensionne */
  gtk_widget_set_usize (window, xfen, yfen);
}

void gtdk_window_save_conf (gchar *fenetre, GtkWidget *window)
{
  int xfen, yfen;

  /* Capture dimensions */
  xfen = window->allocation.width;
  yfen = window->allocation.height;

  /* Ecriture, si les dimmensions sont "correctes" */
  if ((xfen > 2) && (yfen > 2))
    {
      gnome_config_set_string (g_strdup_printf ("geometry-x/%s", fenetre), g_strdup_printf ("%d", xfen));
      gnome_config_set_string (g_strdup_printf ("geometry-y/%s", fenetre), g_strdup_printf ("%d", yfen));
      gnome_config_sync ();
    }
}

void gtdk_window_save_defaultconf (gchar *fenetre, int xfen, int yfen)
{
  gchar *txt_tampon;

  /* x */  
  txt_tampon = g_strdup_printf ("geometry-x/%s", fenetre);
  txt_tampon = g_strdup_printf ("%s", gnome_config_get_string (txt_tampon));
  if (!strcmp (txt_tampon, "(null)"))
    gnome_config_set_string (g_strdup_printf("geometry-x/%s", fenetre), g_strdup_printf ("%d", xfen));

  /* y */
  txt_tampon = g_strdup_printf ("geometry-y/%s", fenetre);
  txt_tampon = g_strdup_printf ("%s", gnome_config_get_string (txt_tampon));
  if (!strcmp (txt_tampon, "(null)"))
    gnome_config_set_string (g_strdup_printf ("geometry-y/%s", fenetre), g_strdup_printf ("%d", yfen));
  gnome_config_sync ();
}

/*****************************************************************************/
/* VBox */
/*****************************************************************************/
void gtdk_vbox_title (gchar *title, GtkWidget *vbox)
{
  GtkWidget *viewport;
  GtkWidget *label;

  /* Go ! */
  viewport = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport);
  gtk_box_pack_start (GTK_BOX (vbox), viewport, FALSE, FALSE, 0);
  gtk_viewport_set_shadow_type (GTK_VIEWPORT (viewport), GTK_SHADOW_OUT);
  label = gtk_label_new (title);
  gtk_widget_show (label);
  gtk_container_add (GTK_CONTAINER (viewport), label);
}

/*****************************************************************************/
/* Entry */
/*****************************************************************************/
GtkWidget *gtdk_entry_file_selector (gchar *title, gchar *file)
{
  GList *data = NULL;
  GtkWidget *ret;
  GtkWidget *entry;
  GtkWidget *toggle_button;
  GtkWidget *arrow;

  /* Go ! */
  if (!file)
    file = g_strdup_printf ("%s", g_get_home_dir ());
  ret = gtk_hbox_new (FALSE, 0);
  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_box_pack_start (GTK_BOX (ret), entry, TRUE, TRUE, 0);
  toggle_button = gtk_toggle_button_new();
  gtk_widget_show (toggle_button);
  gtk_widget_set_usize (toggle_button, 17, 16);
  arrow = gtk_arrow_new (GTK_ARROW_RIGHT, GTK_SHADOW_OUT);
  gtk_widget_show (arrow);
  gtk_misc_set_padding (GTK_MISC (arrow), 1, 0);
  gtk_container_add (GTK_CONTAINER (toggle_button), arrow);
  gtk_box_pack_start (GTK_BOX (ret), toggle_button, FALSE, FALSE, 0);
  data = g_list_append (data, entry);
  data = g_list_append (data, title);
  data = g_list_append (data, file);
  gtk_signal_connect (GTK_OBJECT (toggle_button), "clicked", GTK_SIGNAL_FUNC (gtdk_entry_file_selector_clicked), data);
  return ret;
}

void gtdk_entry_file_selector_clicked (GtkButton *button, GList *data)
{
  gchar *txt_tmp;

  /* Go ! */
  if (GTK_TOGGLE_BUTTON (button)->active)
    {
      txt_tmp = td_fileselector_create_window ((gchar*) g_list_nth_data (data, 1), (gchar*) g_list_nth_data (data, 2), TRUE);
      if (txt_tmp)
	gtk_entry_set_text (GTK_ENTRY (g_list_nth_data (data, 0)), txt_tmp);
      gtk_button_clicked (GTK_BUTTON (button));
    }
  else
    txt_tmp = td_fileselector_create_window ((gchar*) g_list_nth_data (data, 1), (gchar*) g_list_nth_data (data, 2), FALSE);
}

/*****************************************************************************/
/* Option menu */
/*****************************************************************************/
void gtdk_option_menu_set_popdown_strings (GtkOptionMenu *widget, GList *data)
{
  int i;
  GList *menuitem = NULL;
  GtkWidget *menu;
  menu = gtk_menu_new ();
  for (i=0; i<g_list_length (data); i++)
    {
      if (!strcmp ("(separator)", g_list_nth_data (data, i)))
	menuitem = g_list_append (menuitem, gtk_menu_item_new ());
      else
	menuitem = g_list_append (menuitem, gtk_menu_item_new_with_label ((gchar*) g_list_nth_data (data, i)));
      gtk_widget_show (GTK_WIDGET (g_list_nth_data (menuitem, i)));
      gtk_signal_connect (GTK_OBJECT (g_list_nth_data (menuitem, i)), "select", GTK_SIGNAL_FUNC (gtdk_entry_option_menu_select), NULL);
      gtk_menu_append (GTK_MENU (menu), GTK_WIDGET (g_list_nth_data (menuitem, i)));
    }
  gtk_option_menu_set_menu (GTK_OPTION_MENU (widget), menu);
}

GtkWidget *gtdk_entry_option_menu (void)
{
  GtkWidget *ret;
  GtkWidget *entry;
  GtkWidget *option_menu;

  /* Go ! */
  ret = gtk_hbox_new (FALSE, 0);
  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_box_pack_start (GTK_BOX (ret), entry, TRUE, TRUE, 0);
  option_menu = gtk_option_menu_new ();
  gtk_widget_show (option_menu);
  /* gtk_widget_set_usize (option_menu, 32, 16); */
  gtk_box_pack_start (GTK_BOX (ret), option_menu, FALSE, FALSE, 0);
  return ret;
}

void gtdk_entry_option_menu_select (GtkItem *item, GtkWidget *widget)
{
  gchar *txt_tmp;
  if (GTK_BIN (item)->child)
    {
      gtk_label_get (GTK_LABEL (GTK_BIN (item)->child), &txt_tmp);
      gtk_entry_set_text (GTK_ENTRY (widget), txt_tmp);
    }
}

void gtdk_entry_option_menu_set_popdown_strings (GtkWidget *widget, GList *data)
{
  int i;
  GList *menuitem = NULL;
  GtkWidget *menu;
  menu = gtk_menu_new ();
  for (i=0; i<g_list_length (data); i++)
    {
      if (!strcmp ("(separator)", g_list_nth_data (data, i)))
	menuitem = g_list_append (menuitem, gtk_menu_item_new ());
      else
	menuitem = g_list_append (menuitem, gtk_menu_item_new_with_label ((gchar*) g_list_nth_data (data, i)));
      gtk_widget_show (GTK_WIDGET (g_list_nth_data (menuitem, i)));
      gtk_signal_connect (GTK_OBJECT (g_list_nth_data (menuitem, i)), "select", 
			  GTK_SIGNAL_FUNC (gtdk_entry_option_menu_select), 
			  g_list_nth_data (gtk_container_children (GTK_CONTAINER (widget)), 0));
      gtk_menu_append (GTK_MENU (menu), GTK_WIDGET (g_list_nth_data (menuitem, i)));
    }
  gtk_option_menu_set_menu (GTK_OPTION_MENU (g_list_nth_data (gtk_container_children (GTK_CONTAINER (widget)), 1)), menu);
}

