/*****************************************************************************/
/* general.c : Fonction gnrales
 * general.c : Generals functions
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gmodule.h>
#include <dlfcn.h>
#include <dirent.h>
#include <sys/stat.h>
#include <toutdoux.h>


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
void td_init (void)
{
  int i;

  /* Type PostgreSQL (uncomplete but simplify 35 types) *//* FIXME: next arrive : this night */
/*    gchar *pgsqltype []={"int8","float8","char","char()","varchar()","bool","money","time","date","(separator)",			 */
/*  		       "int2","int4","float4","text","(separator)", */
/*  		       "point","line","lseg","box","circle","polygon","path","","bytea","path","filename","(separator)", */
/*  		       "regproc","inet","oid","oid8","cid","cidr","xid","unknown"}; */
  gchar *pgsqltype []={"bool","(separator)","int2","int4","int8","(separator)",
		       "float4","float8","(separator)",
		       "char","char()","varchar()","text","(separator)",
		       "money","time","date"};
  for (i=0; i < 17; i++)
    DATA_LIST_TYPE = g_list_append (DATA_LIST_TYPE, pgsqltype[i]);

  /* Internals flags */
  FLAG_ANTI_AUTOEXPAND = FALSE;
}

/*****************************************************************************/
/* Ok */
/*****************************************************************************/
void td_set_ok (GtkWidget *widget, gboolean *dialog_result)
{
  *dialog_result = TRUE;
  gtk_main_quit ();
}

/*****************************************************************************/
/* Text */
/*****************************************************************************/
gchar *td_text_normalize_null (gchar *text)
{
  if (!text)
    return "(null)";
  if (strlen (text) == 0)
    return "(null)";
  return text;
}

/*****************************************************************************/
/* Message */
/*****************************************************************************/
void td_message_create_window (gchar *message)
{
  GtkWidget *window;
  GtkWidget *eventbox1;
  GtkWidget *hbox1;
  gchar *pixmap1_filename;
  GtkWidget *pixmap1;
  GtkWidget *label1;
  gchar *txt_tampon;

  /* Window */
  printf ("%s\n", message);
  window = gtk_window_new (GTK_WINDOW_DIALOG);
  txt_tampon = g_strdup_printf ("%s : %s" , "ToutDoux", _("Message"));
  gtk_window_set_title (GTK_WINDOW (window), txt_tampon);
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
  eventbox1 = gtk_event_box_new ();
  gtk_widget_show (eventbox1);
  gtk_container_add (GTK_CONTAINER (window), eventbox1);
  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (eventbox1), hbox1);
  gtk_container_set_border_width (GTK_CONTAINER (hbox1), 5);

  /* Image */
  pixmap1 = gtk_type_new (gnome_pixmap_get_type ());
  pixmap1_filename = gnome_pixmap_file ("gnome-error.png");
  if (pixmap1_filename)
    gnome_pixmap_load_file (GNOME_PIXMAP (pixmap1), pixmap1_filename);
  else
    printf (_("Couldn't find pixmap file: %s"), "gnome-error.png");
  g_free (pixmap1_filename);
  gtk_widget_show (pixmap1);
  gtk_box_pack_start (GTK_BOX (hbox1), pixmap1, FALSE, FALSE, 0);

  /* Text */
  label1 = gtk_label_new (message);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 5);

  /* Calls */
  gtk_widget_realize (window);
  gdk_window_set_cursor (window->window, gdk_cursor_new (GDK_ARROW));
  gtk_signal_connect_object (GTK_OBJECT (window), "delete_event",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),GTK_OBJECT (window));
  gtk_signal_connect_object (GTK_OBJECT (eventbox1), "button_press_event",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),GTK_OBJECT (window));
  gtk_widget_show (window);
}


/*****************************************************************************/
/* Question */
/*****************************************************************************/
int td_question_create_window (gchar *question, gchar *titre)
{
  int ret;
  gboolean oui = FALSE;
  gboolean non = FALSE;

  GtkWidget *window;
  GtkWidget *vbox1;
  GtkWidget *hbox1;
  gchar *pixmap1_filename;
  GtkWidget *pixmap1;
  GtkWidget *label1;
  GtkWidget *hseparator1;
  GtkWidget *hbox2;
  GtkWidget *button1;
  GtkWidget *button2;
  GtkWidget *button3;

  /* Window */
  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW (window), titre);
  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (window), vbox1);
  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

  /* Image */
  pixmap1 = gtk_type_new (gnome_pixmap_get_type ());
  pixmap1_filename = gnome_pixmap_file ("gnome-warning.png");
  if (pixmap1_filename)
    gnome_pixmap_load_file (GNOME_PIXMAP (pixmap1), pixmap1_filename);
  else
    printf (_("Couldn't find pixmap file: %s"), "gnome-warning.png");
  g_free (pixmap1_filename);
  gtk_widget_show (pixmap1);
  gtk_box_pack_start (GTK_BOX (hbox1), pixmap1, FALSE, FALSE, 0);

  /* Text */
  label1 = gtk_label_new (question);
  gtk_widget_show (label1);
  gtk_box_pack_end (GTK_BOX (hbox1), label1, TRUE, TRUE, GNOME_PAD);
  hseparator1 = gtk_hseparator_new ();
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, TRUE, TRUE, 0);

  /* Buttons */	
  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox2, TRUE, TRUE, 0);
  button1 = gnome_stock_button (GNOME_STOCK_BUTTON_YES);
  gtk_widget_show (button1);
  gtk_box_pack_start (GTK_BOX (hbox2), button1, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
  button2 = gnome_stock_button (GNOME_STOCK_BUTTON_NO);
  gtk_widget_show (button2);
  gtk_box_pack_start (GTK_BOX (hbox2), button2, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
  button3 = gnome_stock_button (GNOME_STOCK_BUTTON_CANCEL);
  gtk_widget_show (button3);
  gtk_box_pack_start (GTK_BOX (hbox2), button3, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button3);

  /* Calls */
  gtk_signal_connect (GTK_OBJECT (button1), "clicked",
		      GTK_SIGNAL_FUNC (td_set_ok), &oui);
  gtk_signal_connect (GTK_OBJECT (button2), "clicked",
		      GTK_SIGNAL_FUNC (td_set_ok), &non);
  gtk_signal_connect (GTK_OBJECT (button3), "clicked",
		      GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  gtk_widget_show (GTK_WIDGET (window));
  gtk_grab_add (GTK_WIDGET (window));
  gtk_main ();
  if (oui)
    /* yes */
    ret = 0;
  else
    if (non)
      /* no */
      ret = 1;
    else
      /* cancel */
      ret = 2;
	
  gtk_widget_destroy (GTK_WIDGET (window));
  return ret;
}


/*****************************************************************************/
/* File selector */
/*****************************************************************************/
gchar *td_fileselector_create_window (gchar *title, gchar *file, gboolean show)
{
  gchar *txt_tmp;
  gboolean ok = FALSE;
  
  /* Cancel */
  if (!show)
    {
      if (WINDOW_FILE_SELECTION)
	gtk_widget_destroy (GTK_WIDGET (WINDOW_FILE_SELECTION));
      return NULL;
    }

  /* Window */
  WINDOW_FILE_SELECTION = GTK_FILE_SELECTION (gtk_file_selection_new (title));
  if (file)
    gtk_file_selection_set_filename (WINDOW_FILE_SELECTION, file);
  
  /* Calls */
  gtk_signal_connect (GTK_OBJECT (WINDOW_FILE_SELECTION->ok_button), "clicked", GTK_SIGNAL_FUNC (td_set_ok), &ok);
  gtk_signal_connect (GTK_OBJECT (WINDOW_FILE_SELECTION->cancel_button), "clicked",GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  gtk_signal_connect (GTK_OBJECT (WINDOW_FILE_SELECTION), "delete_event", GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  gtk_widget_show (GTK_WIDGET (WINDOW_FILE_SELECTION));
  gtk_main ();
  
  /* Selection */
  if (ok)
    {
      txt_tmp = g_strdup_printf ("%s", gtk_file_selection_get_filename (WINDOW_FILE_SELECTION));
      if (!strcmp (txt_tmp, "(null)"))
	{
	  gtk_widget_destroy (GTK_WIDGET (WINDOW_FILE_SELECTION));
	  return NULL;
	}
      gtk_widget_destroy (GTK_WIDGET (WINDOW_FILE_SELECTION));
      return (txt_tmp);
    }

  /* Cancel */
  gtk_widget_destroy (GTK_WIDGET (WINDOW_FILE_SELECTION));
  return NULL;
}


/*****************************************************************************/
/* Extension */
/*****************************************************************************/
gboolean td_system (gchar *command)
{
  int system_verif;
  gchar *txt_tampon;

  /* Go ! */
  system_verif = system (command);
  if (system_verif != 0)
    {
      td_palette_message (_("Execution command"), g_strdup_printf (_("Execution command '%s'"), command), "failed");
      return FALSE;
    }
  td_palette_message (NULL, g_strdup_printf (_("Execution command '%s'"), command), "command");
  return TRUE;
}

gpointer *td_dlsym (void *module, gchar *dir, gchar *file, gchar *symbol)
{
  gpointer *ret;
  if (!dir)
    dir = g_strdup_printf ("%s", TD_APP(APP)->dir_plugins);
  file = g_strdup_printf ("%s%s", dir, file);
  ret = dlsym (module, symbol);
  if (dlerror() != NULL)
    {
      td_palette_message (_("Execution plug-in"), g_strdup_printf (_("Execution plug-in : file '%s' : symbol '%s' not find"), file, symbol), "failed");
      return NULL;
    }
  td_palette_message (NULL, g_strdup_printf (_("Execution plug-in : file '%s' : symbol '%s'"), file, symbol), "plugins");
  return ret;
}
