/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : messages
 * ToutDoux's plug-in : messages
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <toutdoux.h>

#include "main.h"


/*****************************************************************************/
/* Variables globales */
/*****************************************************************************/
GtkObject *mod; /* Module */
GtkObject *flower[1]; /* Fichier support */
GtkCTreeNode *node_current;


/*****************************************************************************/
/* Dfinition des menus */
/*****************************************************************************/
static GnomeUIInfo menu_help_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("About..."), NULL,
   mod_about, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_uiinfo[] =
{
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};


/*****************************************************************************/
/* Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "Messages",
		  "type", _("miscellaneous"),
		  "version", "1.0.1",
		  "blurb", _("Messages"),
		  "authors", "Philippe Roy <ph_roy@yahoo.com>",
		  "help", "(null)",
		  "category1", _("core"),
		  "category2", _("messages"),
		  "category3", "(null)",
		  "copyright", "Copyright (c) 2000 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "web", "(null)", NULL);
  return ret;
}

void mod_about (void)
{
  td_about_show TD_ABOUT (TD_MOD (mod)->about);
}

GtkObject *mod_def (void)
{
  GtkObject *ret;
  GtkObject *tree[1];
  GtkObject *field[2];
  GtkObject *icon[10];
  GtkObject *icon_equal[10];
  gchar *txt_tmp;

  /* Module */
  ret = td_mod_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "messages",
		  "name_intl", _("Messages"), NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def ());
  node_current = NULL;

  /* Messages : arbre */
  tree[0] = td_mod_tree_new ();
  gtk_object_set (GTK_OBJECT (tree[0]), 
		  "name", _("Messages"),
		  "column_auto_resize", TRUE, NULL); 
  td_mod_add_child (TD_MOD (ret), tree[0]);

  /* Messages : champs */
  field[0] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[0]), 
		  "name", "messages", 
		  "name_intl", _("Messages"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[0]);

  field[1] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[1]), 
		  "name", "type", 
		  "name_intl", _("Type"),
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[1]);

  /* Messages : menu */
  td_mod_tree_set_default_menu (TD_MOD_TREE (tree[0]), gnome_popup_menu_new (menu_uiinfo));

  /* Messages : fichier support */
  flower[0] = td_flower_new ();
  gtk_object_set (GTK_OBJECT (flower[0]),
		  "space", "toutdoux-messages/1.0.1",
		  "root", "messages", 
		  "branch", "message",
		  "mode_level", TRUE, NULL); 
  td_flower_add_branch_attribut (TD_FLOWER (flower[0]), "text");
  td_flower_add_branch_attribut (TD_FLOWER (flower[0]), "type");

  /* Messages : icones */
  icon[0] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[0]), (gchar*) TD_STOCK_LIST_OK, (gchar*) TD_STOCK_LIST_OK);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[0]);

  icon_equal[0] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[0]), 1, "done");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[0]), icon_equal[0]);

  icon_equal[1] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[1]), 1, "tested");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[0]), icon_equal[1]);

  icon[2] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[2]), (gchar*) TD_STOCK_LIST_PLUGINS, (gchar*) TD_STOCK_LIST_PLUGINS);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[2]);

  icon_equal[2] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[2]), 1, "plugins");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[2]), icon_equal[2]);

  icon[3] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[3]), (gchar*) TD_STOCK_LIST_COMMAND, (gchar*) TD_STOCK_LIST_COMMAND);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[3]);

  icon_equal[3] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[3]), 1, "command");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[3]), icon_equal[3]);

  icon[4] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[4]), (gchar*) TD_STOCK_LIST_WARNING, (gchar*) TD_STOCK_LIST_WARNING);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[4]);

  icon_equal[4] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[4]), 1, "failed");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[4]), icon_equal[4]);

  icon_equal[5] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[5]), 1, "stop");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[4]), icon_equal[5]);

  icon[6] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[6]), (gchar*) TD_STOCK_LIST_BOOKCLOSE, (gchar*) TD_STOCK_LIST_BOOKOPEN);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[6]);

  icon_equal[6] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[6]), 1, "begin");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[6]), icon_equal[6]);

  icon[7] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[7]), (gchar*) TD_STOCK_LIST_LIGHT, (gchar*) TD_STOCK_LIST_LIGHT);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[7]);

  icon_equal[7] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[7]), 1, "message");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[7]), icon_equal[7]);

  icon[8] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[8]), (gchar*) TD_STOCK_LIST_YES, (gchar*) TD_STOCK_LIST_YES);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[8]);

  icon_equal[8] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[8]), 1, "yes");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[8]), icon_equal[8]);

  icon[9] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[9]), (gchar*) TD_STOCK_LIST_NO, (gchar*) TD_STOCK_LIST_NO);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[9]);

  icon_equal[9] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[9]), 1, "no");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[9]), icon_equal[9]);
  return ret;
}

void plugins_init (void)
{
  mod = mod_def ();
  td_mod_create (TD_MOD (mod), -1);
}

void plugins_show (void)
{
  td_mod_show (TD_MOD (mod));
}

void plugins_hide (void)
{
  td_mod_hide (TD_MOD (mod));
}

void plugins_destroy (void)
{
  td_mod_destroy (TD_MOD (mod));
  td_flower_destroy (TD_FLOWER (flower[0]));
  mod = NULL;
}


/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
void plugins_new_message (gchar *message, gchar *type)
{
  GList *data = NULL;
  GtkCTreeNode *node;

  /* Go ! */
  if (mod)
    {
      data = g_list_append (data, message);
      data = g_list_append (data, type);
      if (!strcmp (type, "begin"))
	node_current = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), node_current , NULL, data, TRUE);
      else
	{
	  if (!strcmp (type, "end"))
	    {
	      if (node_current)
		{
		  if (GTK_CTREE_ROW (node_current)->parent)
		    node_current = GTK_CTREE_ROW (node_current)->parent;
		  else
		    node_current = NULL;
		}
	    }
	  else
	    {
	      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), node_current , NULL, data, TRUE);
	      if (!strcmp (type, "failed"))
		gtdk_ctree_invert_expand_recursive (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), node);
	    }
	}
    }
}

void plugins_load (gchar *file)
{
  GList *data;
  int i;
  td_palette_message (NULL, g_strdup_printf (_("XML Log")), "begin");
  td_flower_load_file (TD_FLOWER (flower[0]), file);
  for (i=0; i<g_list_length (TD_FLOWER (flower[0])->items_value); i++)
    {
      data = g_list_nth_data (TD_FLOWER (flower[0])->items_value , i);
      td_palette_message (NULL, g_list_nth_data (data, 0), g_list_nth_data (data, 1));
      data = NULL;
    }
  td_palette_message (NULL, g_strdup_printf (_("XML Log")), "end");
}
