/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Navigateur d'extensions
 * ToutDoux's plug-in : Extensions browser
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <toutdoux.h>

#include "main.h"


/*****************************************************************************/
/* Variables globales */
/*****************************************************************************/
GtkObject *mod; /* Module */
GList *plugins_filelist;
GList *plugins_list;
GtkWidget *ctree;
GtkWidget *viewport1;


/*****************************************************************************/
/* Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("Extensions browser"),
		  "type", _("help"),
		  "version", "1.0.1",
		  "blurb", _("Extensions browser"),
		  "authors", "Philippe Roy <ph_roy@yahoo.com>",
		  "help", "(null)",
		  "category1", _("core"),
		  "category2", _("help"),
		  "category3", _("extensions browser"),
		  "copyright", "Copyright (c) 2000 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "web", "(null)", NULL);
  return ret;
}

void mod_about (void)
{
  td_about_show TD_ABOUT (TD_MOD (mod)->about);
}

GtkObject *mod_def (void)
{
  GtkObject *ret;
  GtkObject *box[1];
  GtkWidget *hbox1;
  GtkWidget *vbox1;
  GtkWidget *scrolledwindow1;
  GtkWidget *vseparator1;
  GtkWidget *label1;
  gchar *txt[2];
  GtkWidget *toolbar;
  GtkWidget *toolbar_icon;
  GtkWidget *button1;
  gchar *txt_tmp;
  int i;

  /* Module */
  ret = td_mod_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "extensions_browser",
		  "name_intl", _("Extensions browser"), NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def ());
  box[0] = td_mod_box_new ();
  gtk_object_set (GTK_OBJECT (box[0]), 
		  "name", _("Extensions browser"), NULL);
  td_mod_add_child (TD_MOD (ret), box[0]);

  /* Barre d'outils */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  toolbar_icon = gnome_stock_pixmap_widget (TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_CLOSE);
  button1 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Close"), _("Close"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (button1);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (plugins_hide), NULL);
  td_mod_set_toolbar (TD_MOD (ret), toolbar);

  /* Arbre */
  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  td_mod_box_set_widget (TD_MOD_BOX (box[0]), hbox1);
  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (hbox1), scrolledwindow1, FALSE, FALSE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
  ctree = gtk_ctree_new (2, 0);
  gtk_widget_show (ctree);
  gtdk_clist_adjustheight (ctree);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), ctree);
  gtk_clist_set_column_visibility (GTK_CLIST (ctree), 1, FALSE);
  gtk_clist_column_titles_show (GTK_CLIST (ctree));
  label1 = gtk_label_new (_("Category"));
  gtk_widget_show (label1);
  gtk_clist_set_column_widget (GTK_CLIST (ctree), 0, label1);

  /* Greffons */
  td_palette_message (NULL, _("Extensions browser : Reading plug-ins"), "begin");
  plugins_filelist = td_about_filelist (TD_APP (APP)->dir_plugins, NULL);
  for (i=0; i<g_list_length (plugins_filelist); i++)
    plugins_list = g_list_append (plugins_list, td_about_get (g_list_nth_data (plugins_filelist, i)));
  td_about_categorytree (GTK_CTREE(ctree), plugins_list, plugins_filelist);
  gtk_clist_set_column_width (GTK_CLIST (ctree), 0, gtdk_ctree_optimal_column_width (ctree, 0));
  td_palette_message (NULL, _("Extensions browser : Reading plug-ins"), "end");

  /* Sparateur */
  vseparator1 = gtk_vseparator_new ();
  gtk_widget_ref (vseparator1);
  gtk_widget_show (vseparator1);
  gtk_box_pack_start (GTK_BOX (hbox1), vseparator1, FALSE, TRUE, 0);

  /* Tableau des informations */
  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport1);
  gtk_box_pack_start (GTK_BOX (hbox1), viewport1, TRUE, TRUE, 0);
  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (viewport1), vbox1);

  /* Appels */
  gtk_signal_connect (GTK_OBJECT (ctree), "button_press_event", GTK_SIGNAL_FUNC (ctree_clicked), vbox1);
  gtk_signal_connect (GTK_OBJECT (ctree), "tree_expand", GTK_SIGNAL_FUNC (gtdk_ctree_expand), scrolledwindow1);
  return ret;
}

void plugins_show (gboolean exist)
{
  /* Cration */
  if (!exist)
    {
      mod = mod_def ();
      td_mod_create (TD_MOD (mod), -1);
    }

  /* Affichage */
  td_mod_show (TD_MOD (mod));
}

void plugins_hide (void)
{
  td_mod_hide (TD_MOD (mod));
}

void plugins_destroy (void)
{
  td_mod_destroy (TD_MOD (mod));
  g_list_free (plugins_filelist);
  g_list_free (plugins_list);
}


/*****************************************************************************/
/* Evnement */
/*****************************************************************************/
gboolean ctree_clicked (GtkWidget *widget, GdkEvent *event, GtkWidget *vbox1)
{
  GtkWidget *viewport1;
  GtkWidget *label1 = NULL;
  GtkWidget *label2;
  GtkWidget *label5;
  GtkWidget *hseparator1;
  GtkWidget *entry1;
  GtkWidget *frame1;
  GtkWidget *scrolledwindow1;
  GtkWidget *text1;
  GtkWidget *frame2;
  GtkWidget *scrolledwindow2;
  GtkWidget *text2;
  GtkWidget *hseparator2;
  GtkWidget *label3;
  GtkWidget *label4;
  GtkWidget *href1;
  GdkEventButton *bevent;
  gint row, column;
  gchar *txt_tampon;
  int i;

  /* Capture du greffons */
  bevent = (GdkEventButton *) event;
  gtk_clist_get_selection_info (GTK_CLIST (widget), bevent->x, bevent->y, &row, &column);
  row = gtdk_clist_correction (widget, row, bevent->y);
  if (row < 0)
    return TRUE;
  gtk_container_foreach (GTK_CONTAINER (vbox1), (GtkCallback)gtk_widget_destroy, NULL);
  gtk_clist_get_text (GTK_CLIST (widget), row, 1, &txt_tampon);
  if (!strcmp (txt_tampon, "(null)"))
    return TRUE;
  for (i=0; i<g_list_length (plugins_filelist); i++)
    if (!strcmp (txt_tampon, g_list_nth_data (plugins_filelist, i)))
      break;

  /* Titre */
  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport1);
  gtk_box_pack_start (GTK_BOX (vbox1), viewport1, FALSE, FALSE, 0);
  gtk_viewport_set_shadow_type (GTK_VIEWPORT (viewport1), GTK_SHADOW_OUT);
  txt_tampon = g_strdup_printf("%s - %s", TD_ABOUT (g_list_nth_data (plugins_list, i))->name, TD_ABOUT (g_list_nth_data (plugins_list, i))->version);
  label1 = gtk_label_new (txt_tampon);
  gtk_widget_show (label1);
  gtk_container_add (GTK_CONTAINER (viewport1), label1);
  txt_tampon = g_strdup_printf ("%s", TD_ABOUT (g_list_nth_data (plugins_list, i))->copyright);
  label2 = gtk_label_new (txt_tampon);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (vbox1), label2, FALSE, TRUE, 0);
  txt_tampon = g_strdup_printf ("%s", TD_ABOUT (g_list_nth_data (plugins_list, i))->license);
  label5 = gtk_label_new (txt_tampon);
  gtk_widget_show (label5);
  gtk_box_pack_start (GTK_BOX (vbox1), label5, FALSE, TRUE, 0);

  /* Blurb */
  entry1 = gtk_entry_new ();
  gtk_widget_show (entry1);
  gtk_box_pack_start (GTK_BOX (vbox1), entry1, FALSE, TRUE, 0);
  gtk_entry_set_editable (GTK_ENTRY (entry1), FALSE);
  gtk_entry_set_text (GTK_ENTRY (entry1), TD_ABOUT (g_list_nth_data (plugins_list, i))->blurb);

  /* Auteurs */
  frame1 = gtk_frame_new (_("Authors"));
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox1), frame1, TRUE, TRUE, 0);
  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_container_add (GTK_CONTAINER (frame1), scrolledwindow1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  text1 = gtk_text_new (NULL, NULL);
  gtk_widget_show (text1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), text1);
  gtk_widget_realize (text1);
  gtk_text_insert (GTK_TEXT (text1), NULL, NULL, NULL, TD_ABOUT (g_list_nth_data (plugins_list, i))->authors, -2);

  /* Aide */
  frame2 = gtk_frame_new (_("Help"));
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (vbox1), frame2, TRUE, TRUE, 0);
  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow2);
  gtk_container_add (GTK_CONTAINER (frame2), scrolledwindow2);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  text2 = gtk_text_new (NULL, NULL);
  gtk_widget_show (text2);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), text2);
  gtk_widget_realize (text2);
  if (strcmp (TD_ABOUT (g_list_nth_data (plugins_list, i))->help, "(null)"))
    gtk_text_insert (GTK_TEXT (text2), NULL, NULL, NULL, TD_ABOUT (g_list_nth_data (plugins_list, i))->help, -2);

  /* Type */
  txt_tampon = g_strdup_printf("%s : %s", _("Type"), TD_ABOUT (g_list_nth_data (plugins_list, i))->type);
  label3 = gtk_label_new (txt_tampon);
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (vbox1), label3, FALSE, TRUE, 0);

  /* Fichier */
  txt_tampon = g_strdup_printf ("%s : %s", _("File"), (gchar*) g_list_nth_data (plugins_filelist, i));
  label4 = gtk_label_new (txt_tampon);
  gtk_widget_show (label4);
  gtk_box_pack_start (GTK_BOX (vbox1), label4, FALSE, TRUE, 0);

  /* Site web */
  if (strcmp (TD_ABOUT (g_list_nth_data (plugins_list, i))->web, "(null)"))
    {
      href1 = gnome_href_new (TD_ABOUT (g_list_nth_data (plugins_list, i))->web, TD_ABOUT (g_list_nth_data (plugins_list, i))->web);
      gtk_widget_show (href1);
      gtk_box_pack_start (GTK_BOX (vbox1), href1, FALSE, FALSE, 0);
    }
  return TRUE;
}
