/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Communication avec un URL
 * ToutDoux's plug-in : URL communication
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <pthread.h>
#include <toutdoux.h>

#include "main.h"


/*****************************************************************************/
/* Variables globales */
/*****************************************************************************/
GtkObject *mod; /* Module */
gboolean selection;
gboolean quit;
GtkWidget *entry;
int fin_wget;


/*****************************************************************************/
/* Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("URL communication"),
		  "type", _("communication"),
		  "version", "1.0.1",
		  "blurb", _("URL communication"),
		  "authors", "Philippe Roy <ph_roy@yahoo.com>",
		  "help", _("Wget frontend"),
		  "category1", _("core"),
		  "category2", _("communication"),
		  "category3", _("url"),
		  "copyright", "Copyright (c) 2000 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "web", "(null)", NULL);
  return ret;
}

void mod_about (void)
{
  td_about_show TD_ABOUT (TD_MOD (mod)->about);
}

GtkObject *mod_def (void)
{
  GtkObject *ret;

  GtkObject *box[1];
  GtkWidget *vbox1;

  GtkWidget *toolbar;
  GtkWidget *toolbar_icon;
  GtkWidget *button1;
  GtkWidget *button2;

  /* Module */
  ret = td_mod_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "url_communication",
		  "name_intl", _("URL communication"), NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def ());

  /* Barre d'outils */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  td_mod_set_toolbar (TD_MOD (ret), toolbar);

  toolbar_icon = gnome_stock_pixmap_widget (TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_JUMP_TO);
  button1 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL,	_("Open URL"), _("Open URL"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (button1);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (td_set_ok), &selection);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  toolbar_icon = gnome_stock_pixmap_widget (TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_CLOSE);
  button2 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Close"), _("Close"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (button2);
  gtk_signal_connect (GTK_OBJECT (button2), "clicked", GTK_SIGNAL_FUNC (td_set_ok), &quit);

  /* About : widget */
  box[0] = td_mod_box_new ();
  gtk_object_set (GTK_OBJECT (box[0]), 
		  "name", _("URL communication"), NULL);
  td_mod_add_child (TD_MOD (ret), box[0]);
  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  td_mod_box_set_widget (TD_MOD_BOX (box[0]), vbox1);
  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_box_pack_start (GTK_BOX (vbox1), entry, FALSE, FALSE, 0);
  return ret;
}

void plugins_init (void)
{
  mod = mod_def ();
  td_mod_create (TD_MOD (mod), -1);
}

gchar *plugins_show (void)
{
  gchar ret;

  /* Fentre */
  selection = FALSE;
  quit = FALSE;
  td_mod_show (TD_MOD (mod));
  do
    gtk_main ();
  while ((!selection)&&(!quit));

  /* Selection */
  if (selection)
    {
      td_mod_hide (TD_MOD (mod));
      return (gtk_entry_get_text (GTK_ENTRY (entry)));
    }
  td_mod_hide (TD_MOD (mod));
  return NULL;
}

void plugins_hide (void)
{
  td_mod_hide (TD_MOD (mod));
}

void plugins_destroy (void)
{
  td_mod_destroy (TD_MOD (mod));
}


/*****************************************************************************/
/* Wget */
/*****************************************************************************/
void *thread_wget (void * url)
{
  gchar *txt_tampon;
  gchar *txt_url;
  gchar *file_tmp;
  txt_url = g_strdup_printf ("%s", (gchar*)url);
  file_tmp = g_strdup_printf ("%s/url.toutdoux", TD_APP (APP)->dir_tmp);

  /* Go ! */
  if (!td_system (g_strdup_printf("wget -O %s %s", file_tmp, txt_url)))
    {
      td_palette_message (NULL, _("Loading URL failed"), "failed");
      return FALSE;
    }
  fin_wget = 1;
  pthread_exit (0);
}

void *thread_progression (void *taille)
{
  struct stat stat_tampon;
  guint32 cur_taille;
  float total_taille;
  float etat_taille;
  gchar *file_tmp;
  total_taille = (atoi(g_strdup_printf ("%s", (gchar*)taille))*1000);
  file_tmp = g_strdup_printf ("%s/url.toutdoux", TD_APP (APP)->dir_tmp);

  /* Go ! */
  while (!fin_wget)
    {
      if (stat (file_tmp, &stat_tampon) != -1)
	{
	  cur_taille = stat_tampon.st_size;
  	  etat_taille = (cur_taille/total_taille);
	  td_app_palette_progressbar_update (TD_APP_PALETTE (TD_APP (APP)->palette),  etat_taille);
	}
      sleep (1);
    }
  td_app_palette_progressbar_update (TD_APP_PALETTE (TD_APP (APP)->palette), 1);
  pthread_exit (0);
}

gboolean plugins_load_url (gchar *url)
{
  struct stat stat_tampon;
  char txt_tampon_ligne[500];
  gchar *txt_tampon;
  gchar *txt_taille;
  gchar *file_log;
  int taille;
  int retour_th;
  void *ret_thread;
  pthread_t th_a, th_b;
  guint32 cur_size;
  FILE *fp2;
  file_log = g_strdup_printf ("%s/wget.log", TD_APP (APP)->dir_tmp);

  /* Wget ? */
  td_palette_message (NULL, _("Retrieving url"), "begin");
  if (!td_system ("wget --version"))
    {
      td_palette_message (NULL, _("Retrieving url"), "end");
      return FALSE;
    }

  /* Taille du fichier */
  if (!td_system (g_strdup_printf ("wget -o %s --spider %s", file_log, url)))
    {
      td_palette_message (NULL, _("Retrieving url"), "end");
      return FALSE;
    }
  if ((fp2 = fopen (file_log, "r")) == NULL)
    {
      td_palette_message (NULL, _("Reading wget log"), "failed");
      td_palette_message (NULL, _("Retrieving url"), "end");
      return FALSE;
    }
  fgets (txt_tampon_ligne,500,fp2);
  fgets (txt_tampon_ligne,500,fp2);
  fgets (txt_tampon_ligne,500,fp2);
  fgets (txt_tampon_ligne,500,fp2);
  fgets (txt_tampon_ligne,500,fp2);
  txt_taille = strtok (txt_tampon_ligne," ");
  txt_taille = strtok (NULL," ");

  /* Go ! */
  td_app_palette_progressbar_init (TD_APP_PALETTE (TD_APP (APP)->palette), _("Open URL ..."));
  fin_wget = 0;
  retour_th = pthread_create (&th_a, NULL, thread_wget, url);
  if (retour_th != 0)
    td_palette_message (NULL, _("Creating thread 'wget'"), "failed");
  retour_th = pthread_create (&th_b, NULL, thread_progression, txt_taille);
  if (retour_th != 0)
    td_palette_message (NULL, _("Creating thread 'progression'"), "failed");

  /* Fin */
  (void)pthread_join (th_a, &ret_thread);
  (void)pthread_join (th_b, &ret_thread);
  fclose (fp2);
  td_app_palette_progressbar_hide (TD_APP_PALETTE (TD_APP (APP)->palette));
  td_palette_message (_("Retrieving url"), NULL, "done");
  td_palette_message (NULL, _("Retrieving url"), "end");
  return TRUE;
}
