/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : signets
 * ToutDoux's plug-in : bookmarks
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/stat.h>

#include "main.h"


/*****************************************************************************/
/* Variables globales */
/*****************************************************************************/
GtkObject *mod; /* Module */
GtkObject *flower[3]; /* Fichier support */


/*****************************************************************************/
/* Dfinition des menus */
/*****************************************************************************/

/* Gnrale */
static GnomeUIInfo menu_empty_uiinfo[] =
{
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_help_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Customize"), NULL,
   plugins_custom, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_CUSTOM, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("About..."), NULL,
   mod_about, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},
  GNOMEUIINFO_END
};

/* Fichier */
static GnomeUIInfo menu_file_maxi_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Create folder"), NULL,
   menu_new_file, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_LIST_FOLDER, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Create separator"), NULL,
   menu_new_file, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Add file"), NULL,
   menu_new_file, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Add directory"), NULL,
   menu_new_file, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_LIST_DIRECTORY, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Add URL"), NULL,
   menu_new_file, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_URL, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Add database"), NULL,
   menu_new_file, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_DATABASE, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Remove"), NULL,
   menu_remove_file, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_file_mini_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Create folder"), NULL,
   menu_new_file, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_LIST_FOLDER, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Create separator"), NULL,
   menu_new_file, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Add file"), NULL,
   menu_new_file, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Add directory"), NULL,
   menu_new_file, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_LIST_DIRECTORY, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Add URL"), NULL,
   menu_new_file, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_URL, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Add database"), NULL,
   menu_new_file, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_DATABASE, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};

/* Gabarit */
static GnomeUIInfo menu_template_maxi_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Create folder"), NULL,
   menu_new_template, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_LIST_FOLDER, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Create separator"), NULL,
   menu_new_template, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Add file"), NULL,
   menu_new_template, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Remove"), NULL,
   menu_remove_template, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_template_mini_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Create folder"), NULL,
   menu_new_template, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_LIST_FOLDER, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Create separator"), NULL,
   menu_new_template, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Add file"), NULL,
   menu_new_template, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_recents_uiinfo[] =
{
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};


/*****************************************************************************/
/* Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("Bookmarks"),
		  "type", _("miscellaneous"),
		  "version", "1.0.1",
		  "blurb", _("Bookmarks"),
		  "authors", "Philippe Roy <ph_roy@yahoo.com>",
		  "help", _("Edit bookmarks : favorites, templates and history"),
		  "category1", _("core"),
		  "category2", _("bookmarks"),
		  "category3", "(null)",
		  "copyright", "Copyright (c) 2000 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "web", "(null)", NULL);
  return ret;
}

void mod_about (void)
{
  td_about_show TD_ABOUT (TD_MOD (mod)->about);
}

GtkObject *mod_def (void)
{
  GtkObject *ret;
  GtkObject *tree[3];
  GtkObject *field[23];
  GtkObject *icon[14];
  GtkObject *icon_equal[14];
  GtkObject *menu[2];
  GtkObject *menu_equal[6];
  GtkObject *prop[11];
  GtkWidget *prop_widget[11];
  GtkObject *prop_visible_equal[8];

  GtkWidget *toolbar;
  GtkWidget *toolbar_icon;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *radiobutton3;
  GtkWidget *button1;
  GtkWidget *button2;
  GtkWidget *button3;

  /* Module */
  ret = td_mod_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "bookmarks",
		  "name_intl", _("Bookmarks"), NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def ());

  /* Barre d'outils */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  td_mod_set_toolbar (TD_MOD (ret), toolbar);

  toolbar_icon = gnome_pixmap_new_from_file (g_strdup_printf ("%s/share/pixmaps/toutdoux/button_favorites.xpm", PACKAGE_DATA_DIR));
  radiobutton1 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_RADIOBUTTON, NULL, _("Favorites"), _("Favorites"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (radiobutton1);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (radiobutton1), FALSE);
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "clicked", GTK_SIGNAL_FUNC (radiobutton1_clicked), NULL);

  toolbar_icon = gnome_pixmap_new_from_file (g_strdup_printf ("%s/share/pixmaps/toutdoux/button_build.xpm", PACKAGE_DATA_DIR));
  radiobutton2 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_RADIOBUTTON, radiobutton1, _("Templates"), _("Templates"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (radiobutton2);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (radiobutton2), FALSE);
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "clicked", GTK_SIGNAL_FUNC (radiobutton2_clicked), NULL);

  toolbar_icon = gnome_pixmap_new_from_file (g_strdup_printf ("%s/share/pixmaps/toutdoux/button_clock.xpm", PACKAGE_DATA_DIR));
  radiobutton3 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_RADIOBUTTON, radiobutton2, _("Templates"), _("Templates"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (radiobutton3);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (radiobutton3), FALSE);
  gtk_signal_connect (GTK_OBJECT (radiobutton3), "clicked", GTK_SIGNAL_FUNC (radiobutton3_clicked), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  toolbar_icon = gnome_stock_pixmap_widget (TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_REVERT);
  button1 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Re-read file"), _("Re-read file"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (button1);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (load_data), NULL);

  toolbar_icon = gnome_stock_pixmap_widget (TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_SAVE);
  button2 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Write file"), _("Write file"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (button2);
  gtk_signal_connect (GTK_OBJECT (button2), "clicked", GTK_SIGNAL_FUNC (save_data), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  toolbar_icon = gnome_stock_pixmap_widget (TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_CLOSE);
  button3 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Close"), _("Close"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (button3);
  gtk_signal_connect (GTK_OBJECT (button3), "clicked", GTK_SIGNAL_FUNC (plugins_hide), NULL);

  /* Favoris : arbre */
  tree[0] = td_mod_tree_new ();
  gtk_object_set (GTK_OBJECT (tree[0]), 
		  "name", _("Favorites"), 
		  "reorderable", TRUE,
		  "column_auto_resize", TRUE,
		  "customize", TRUE, NULL);
  td_mod_add_child (TD_MOD (ret), tree[0]);

  /* Favoris : champs */
  field[0] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[0]), 
		  "name", "name", 
		  "name_intl", _("Favorites"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[0]);

  field[1] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[1]), 
		  "name", "interface", 
		  "name_intl", _("Interface"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[1]);

  field[2] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[2]), 
		  "name", "host", 
		  "name_intl", _("Host"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[2]);

  field[3] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[3]), 
		  "name", "port", 
		  "name_intl", _("Port"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[3]);

  field[4] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[4]), 
		  "name", "base", 
		  "name_intl", _("Base"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[4]);

  field[5] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[5]), 
		  "name", "user", 
		  "name_intl", _("User"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[5]);

  field[6] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[6]), 
		  "name", "password", 
		  "name_intl", _("Password"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[6]);

  field[7] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[7]), 
		  "name", "template", 
		  "name_intl", _("Template"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[7]);

  field[8] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[8]), 
		  "name", "location", 
		  "name_intl", _("Location"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[8]);

  field[9] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[9]), 
		  "name", "type", 
		  "name_intl", _("Type"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[9]);

  /* Favoris : fichier support */
  flower[0] = td_flower_new ();
  gtk_object_set (GTK_OBJECT (flower[0]), 
		  "space", "toutdoux-favorites/1.0.1",
		  "root", "favorites", 
		  "branch", "favorite", 
		  "mode_level", TRUE, NULL); 
  td_flower_add_branch_attribut (TD_FLOWER (flower[0]), "name");
  td_flower_add_branch_attribut (TD_FLOWER (flower[0]), "interface");
  td_flower_add_branch_attribut (TD_FLOWER (flower[0]), "host");
  td_flower_add_branch_attribut (TD_FLOWER (flower[0]), "port");
  td_flower_add_branch_attribut (TD_FLOWER (flower[0]), "base");
  td_flower_add_branch_attribut (TD_FLOWER (flower[0]), "user");
  td_flower_add_branch_attribut (TD_FLOWER (flower[0]), "password");
  td_flower_add_branch_attribut (TD_FLOWER (flower[0]), "template");
  td_flower_add_branch_attribut (TD_FLOWER (flower[0]), "location");
  td_flower_add_branch_attribut (TD_FLOWER (flower[0]), "type");

  /* Favoris : proprits */
  prop[0] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[0]), 
		  "name", _("name"), 
		  "tab", 0, 
		  "column", 0, NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[0]);

  prop_widget[0] = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (prop_widget[0]), "changed", GTK_SIGNAL_FUNC (prop_favorite_name), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[0]), prop_widget[0], NULL);

  prop_visible_equal[0] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[0]), 9, "file");
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[0]), prop_visible_equal[0]);

  prop_visible_equal[1] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[1]), 9, "directory");
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[0]), prop_visible_equal[1]);

  prop_visible_equal[2] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[2]), 9, "folder");
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[0]), prop_visible_equal[2]);

  prop_visible_equal[3] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[3]), 9, "url");
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[0]), prop_visible_equal[3]);

  prop_visible_equal[4] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[4]), 9, "database");
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[0]), prop_visible_equal[4]);

  prop[1] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[1]), 
		  "name", _("interface (pgsql)"), 
		  "tab", 0, 
		  "column", 1, NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[1]);

  prop_widget[1] = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (prop_widget[1]), "changed", GTK_SIGNAL_FUNC (prop_favorite_interface), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[1]), prop_widget[1], NULL);;
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[1]), prop_visible_equal[4]);

  prop[2] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[2]), 
		  "name", _("host (optional)"), 
		  "tab", 0, 
		  "column", 2, NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[2]);

  prop_widget[2] = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (prop_widget[2]), "changed", GTK_SIGNAL_FUNC (prop_favorite_host), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[2]), prop_widget[2], NULL);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[2]), prop_visible_equal[4]);

  prop[3] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[3]), 
		  "name", _("port (optional)"), 
		  "tab", 0, 
		  "column", 3, NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[3]);

  prop_widget[3] = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (prop_widget[3]), "changed", GTK_SIGNAL_FUNC (prop_favorite_port), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[3]), prop_widget[3], NULL);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[3]), prop_visible_equal[4]);

  prop[4] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[4]), 
		  "name", _("base"), 
		  "tab", 0, 
		  "column", 4, NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[4]);

  prop_widget[4] = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (prop_widget[4]), "changed", GTK_SIGNAL_FUNC (prop_favorite_base), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[4]), prop_widget[4], NULL);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[4]), prop_visible_equal[4]);

  prop[5] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[5]), 
		  "name", _("user (optional)"),
		  "tab", 0, 
		  "column", 5, NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[5]);

  prop_widget[5] = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (prop_widget[5]), "changed", GTK_SIGNAL_FUNC (prop_favorite_user), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[5]), prop_widget[5], NULL);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[5]), prop_visible_equal[4]);

  prop[6] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[6]), 
		  "name", _("password (optional)"),
		  "tab", 0, 
		  "column", 6, NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[6]);

  prop_widget[6] = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (prop_widget[6]), "changed", GTK_SIGNAL_FUNC (prop_favorite_password), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[6]), prop_widget[6], NULL);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[6]), prop_visible_equal[4]);

  prop[7] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[7]), 
		  "name", _("template"),
		  "tab", 0, 
		  "column", 7, NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[7]);

  prop_widget[7] = gtdk_entry_file_selector (_("Select template"), TD_APP(APP)->dir_var);
  gtk_signal_connect (GTK_OBJECT (g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget[7])), 0)), "changed", GTK_SIGNAL_FUNC (prop_favorite_template), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[7]), g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget[7])), 0), prop_widget[7]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[7]), prop_visible_equal[4]);

  prop[8] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[8]), 
		  "name", _("location"),
		  "tab", 0, 
		  "column", 8, NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[8]);

  prop_widget[8] = gtdk_entry_file_selector (_("Select directory/file"), g_get_home_dir ());
  gtk_signal_connect (GTK_OBJECT (g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget[8])), 0)), "changed", GTK_SIGNAL_FUNC (prop_favorite_location), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[8]), g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget[8])), 0), prop_widget[8]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[8]), prop_visible_equal[0]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[8]), prop_visible_equal[1]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[8]), prop_visible_equal[3]);

  /* Favoris : icones */
  icon[0] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[0]), (gchar*) TD_STOCK_LIST_NEW, (gchar*) TD_STOCK_LIST_NEW);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[0]);

  icon_equal[0] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[0]), 9, "file");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[0]), icon_equal[0]);

  icon[1] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[1]), (gchar*) TD_STOCK_LIST_DIRECTORY, (gchar*) TD_STOCK_LIST_DIRECTORY);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[1]);

  icon_equal[1] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[1]), 9, "directory");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[1]), icon_equal[1]);

  icon[2] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[2]), (gchar*) TD_STOCK_LIST_FOLDER, (gchar*) TD_STOCK_LIST_FOLDER);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[2]);

  icon_equal[2] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[2]), 9, "folder");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[2]), icon_equal[2]);

  icon[3] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[3]), (gchar*) TD_STOCK_LIST_URL, (gchar*) TD_STOCK_LIST_URL);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[3]);

  icon_equal[3] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[3]), 9, "url");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[3]), icon_equal[3]);

  icon[4] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[4]), (gchar*) TD_STOCK_LIST_DATABASE, (gchar*) TD_STOCK_LIST_DATABASE);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[4]);

  icon_equal[4] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[4]), 9, "database");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[4]), icon_equal[4]);

  /* Favoris : menu */
  td_mod_tree_set_default_menu (TD_MOD_TREE (tree[0]), gnome_popup_menu_new (menu_file_mini_uiinfo));

  menu[0] = td_mod_tree_menu_new ();
  td_mod_tree_menu_set (TD_MOD_TREE_MENU (menu[0]), gnome_popup_menu_new (menu_file_maxi_uiinfo));
  td_mod_tree_add_menu (TD_MOD_TREE (tree[0]), menu[0]);

  menu_equal[0] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[0]), 13, "(bud)");
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[0]), menu_equal[0]);

  menu_equal[1] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[1]), 13, "t");
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[0]), menu_equal[1]);

  menu_equal[2] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[2]), 13, "f");
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[0]), menu_equal[2]);

  /* Gabarits : arbre */
  tree[1] = td_mod_tree_new ();
  gtk_object_set (GTK_OBJECT (tree[1]), 
		  "name", _("Templates"),
		  "reorderable", TRUE, 
		  "column_auto_resize", TRUE,
		  "customize", TRUE, NULL);
  td_mod_add_child (TD_MOD (ret), tree[1]);

  /* Gabarits : champs */
  field[10] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[10]), 
		  "name", "name", 
		  "name_intl", _("Templates"),  NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[1]), field[10]);

  field[11] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[11]), 
		  "name", "location", 
		  "name_intl", _("Location"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[1]), field[11]);

  field[12] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[12]), 
		  "name", "type", 
		  "name_intl", _("Type"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[1]), field[12]);

  /* Gabarits : fichier support */
  flower[1] = td_flower_new ();
  gtk_object_set (GTK_OBJECT (flower[1]), 
		  "space", "toutdoux-templates/1.0.1",
		  "root", "templates", 
		  "branch", "template", 
		  "mode_level", TRUE, NULL); 
  td_flower_add_branch_attribut (TD_FLOWER (flower[1]), "name");
  td_flower_add_branch_attribut (TD_FLOWER (flower[1]), "location");
  td_flower_add_branch_attribut (TD_FLOWER (flower[1]), "type");

  /* Gabarits : proprits */
  prop[9] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[9]), 
		  "name", _("name"), 
		  "tab", 1, 
		  "column", 0, NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[1]), prop[9]);

  prop_widget[9] = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (prop_widget[9]), "changed", GTK_SIGNAL_FUNC (prop_template_name), GTK_OBJECT (tree[1]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[9]), prop_widget[9], NULL);

  prop_visible_equal[5] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[5]), 2, "file");
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[9]), prop_visible_equal[5]);

  prop_visible_equal[6] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[6]), 2, "directory");
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[9]), prop_visible_equal[6]);

  prop_visible_equal[7] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[7]), 2, "folder");
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[9]), prop_visible_equal[7]);

  prop[10] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[10]), 
		  "name", _("location"),
		  "tab", 1, 
		  "column", 1, NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[1]), prop[10]);

  prop_widget[10] = gtdk_entry_file_selector (_("Select directory/file"), g_get_home_dir ());
  gtk_signal_connect (GTK_OBJECT (g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget[10])), 0)), "changed", GTK_SIGNAL_FUNC (prop_template_location), GTK_OBJECT (tree[1]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[10]), g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget[10])), 0), prop_widget[10]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[10]), prop_visible_equal[5]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[10]), prop_visible_equal[6]);

  prop_widget[10] = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (prop_widget[10]), "changed", GTK_SIGNAL_FUNC (prop_template_location), GTK_OBJECT (tree[1]));

  /* Gabarits : icones */
  icon[6] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[6]), (gchar*) TD_STOCK_LIST_NEW, (gchar*) TD_STOCK_LIST_NEW);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[1]), icon[6]);

  icon_equal[6] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[6]), 2, "file");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[6]), icon_equal[6]);

  icon[7] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[7]), (gchar*) TD_STOCK_LIST_DIRECTORY, (gchar*) TD_STOCK_LIST_DIRECTORY);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[1]), icon[7]);

  icon_equal[7] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[7]), 2, "directory");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[7]), icon_equal[7]);

  icon[8] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[8]), (gchar*) TD_STOCK_LIST_FOLDER, (gchar*) TD_STOCK_LIST_FOLDER);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[1]), icon[8]);

  icon_equal[8] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[8]), 2, "folder");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[8]), icon_equal[8]);

  /* Gabarits : menu */
  td_mod_tree_set_default_menu (TD_MOD_TREE (tree[1]), gnome_popup_menu_new (menu_template_mini_uiinfo));

  menu[1] = td_mod_tree_menu_new ();
  td_mod_tree_menu_set (TD_MOD_TREE_MENU (menu[1]), gnome_popup_menu_new (menu_template_maxi_uiinfo));
  td_mod_tree_add_menu (TD_MOD_TREE (tree[1]), menu[1]);

  menu_equal[3] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[3]), 6, "(bud)");
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[1]), menu_equal[3]);

  menu_equal[4] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[4]), 6, "t");
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[1]), menu_equal[4]);

  menu_equal[5] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[5]), 6, "f");
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[1]), menu_equal[5]);

  /* Historique : arbre */
  tree[2] = td_mod_tree_new ();
  gtk_object_set (GTK_OBJECT (tree[2]), 
		  "name", _("History"), 
		  "column_auto_resize", TRUE,
		  "customize", TRUE, NULL);
  td_mod_add_child (TD_MOD (ret), tree[2]);

  /* Historique : champs */
  field[13] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[13]), 
		  "name", "name", 
		  "name_intl", _("History"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[2]), field[13]);

  field[14] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[14]), 
		  "name", "interface", 
		  "name_intl", _("Interface"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[2]), field[14]);

  field[15] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[15]), 
		  "name", "host", 
		  "name_intl", _("Host"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[2]), field[15]);

  field[16] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[16]), 
		  "name", "port", 
		  "name_intl", _("Port"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[2]), field[16]);

  field[17] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[17]), 
		  "name", "base", 
		  "name_intl", _("Base"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[2]), field[17]);

  field[18] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[18]), 
		  "name", "user", 
		  "name_intl", _("User"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[2]), field[18]);

  field[19] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[19]), 
		  "name", "password", 
		  "name_intl", _("Password"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[2]), field[19]);

  field[20] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[20]), 
		  "name", "template", 
		  "name_intl", _("Template"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[2]), field[20]);

  field[21] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[21]), 
		  "name", "location", 
		  "name_intl", _("Location"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[2]), field[21]);

  field[22] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[22]), 
		  "name", "type", 
		  "name_intl", _("Type"), 
		  "visible", FALSE, NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[2]), field[22]);

  /* Historique : fichier support */
  flower[2] = td_flower_new ();
  gtk_object_set (GTK_OBJECT (flower[2]), 
		  "space", "toutdoux-history/1.0.1",
		  "root", "recents", 
		  "branch", "recent", 
		  "mode_level", TRUE, NULL); 
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "name");
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "interface");
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "host");
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "port");
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "base");
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "user");
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "password");
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "template");
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "location");
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "type");

  /* Historique : icones */
  icon[9] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[9]), (gchar*) TD_STOCK_LIST_NEW, (gchar*) TD_STOCK_LIST_NEW);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[2]), icon[9]);

  icon_equal[9] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[9]), 9, "file");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[9]), icon_equal[9]);

  icon[10] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[10]), (gchar*) TD_STOCK_LIST_DIRECTORY, (gchar*) TD_STOCK_LIST_DIRECTORY);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[2]), icon[10]);

  icon_equal[10] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[10]), 9, "directory");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[10]), icon_equal[10]);

  icon[11] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[11]), (gchar*) TD_STOCK_LIST_FOLDER, (gchar*) TD_STOCK_LIST_FOLDER);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[2]), icon[11]);

  icon_equal[11] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[11]), 9, "folder");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[11]), icon_equal[11]);

  icon[12] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[12]), (gchar*) TD_STOCK_LIST_URL, (gchar*) TD_STOCK_LIST_URL);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[2]), icon[12]);

  icon_equal[12] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[12]), 9, "url");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[12]), icon_equal[12]);

  icon[13] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[13]), (gchar*) TD_STOCK_LIST_DATABASE, (gchar*) TD_STOCK_LIST_DATABASE);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[2]), icon[13]);

  icon_equal[13] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[13]), 9, "database");
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[13]), icon_equal[13]);

  /* Historique : menu */
  td_mod_tree_set_default_menu (TD_MOD_TREE (tree[2]), gnome_popup_menu_new (menu_recents_uiinfo));
  return ret;
}

void plugins_init (int mod_id)
{
  mod = mod_def ();
  td_mod_create (TD_MOD (mod), mod_id);
  load_data ();
  menu_add (flower[0], g_strdup_printf("%s/%s/", _("File"), _("Favorites")), 9);
  menu_add (flower[1], g_strdup_printf("%s/%s/", _("File"), _("New")), 2);
  menu_add (flower[2], g_strdup_printf("%s/%s/", _("File"), _("Open")), 9);
  td_db_connect_add_menu ();
}

void plugins_show (void)
{
  td_mod_show (TD_MOD (mod));
}

void plugins_hide (void)
{
  save_data ();
  td_mod_hide (TD_MOD (mod));
}

void plugins_destroy (void)
{
  save_data ();
  td_mod_destroy (TD_MOD (mod));
}

void plugins_custom (void)
{
  td_mod_custom_show (mod);
}


/*****************************************************************************/
/* Proprits */
/*****************************************************************************/
void prop_favorite_name (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 0, FALSE, FALSE);
}

void prop_favorite_interface (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 1, FALSE, FALSE);
}

void prop_favorite_host (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 2, FALSE, FALSE);
}

void prop_favorite_port (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 3, FALSE, FALSE);
}

void prop_favorite_base (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 4, FALSE, FALSE);
}

void prop_favorite_user (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 5, FALSE, FALSE);
}

void prop_favorite_password (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 6, FALSE, FALSE);
}

void prop_favorite_template (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 7, FALSE, FALSE);
}

void prop_favorite_location (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 8, FALSE, FALSE);
}

void prop_template_name (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 0, FALSE, FALSE);
}

void prop_template_location (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 1, FALSE, FALSE);
}

/*****************************************************************************/
/* Menus */
/*****************************************************************************/
void menu_new_file (GtkMenuItem *menuitem, gpointer user_data)
{
  GList *data = NULL;
  GtkCTreeNode *node;
  int i;

  /* Valeurs */
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Create separator"))))
    data = g_list_append (data, "--------------------");
  else
    data = g_list_append (data, "");
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Add database"))))
    data = g_list_append (data, "pgsql");
  else
    data = g_list_append (data, "");
  for (i=2; i<9; i++)
    data = g_list_append (data, "");
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Create folder"))))
    data = g_list_append (data, "folder");
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Create separator"))))
    data = g_list_append (data, "separator");
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Add file"))))
    data = g_list_append (data, "file");
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Add directory"))))
    data = g_list_append (data, "directory");
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Add URL"))))
    data = g_list_append (data, "url");
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Add database"))))
    data = g_list_append (data, "database");

  /* Node */
  if (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected)
    td_mod_tree_expand (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), NULL);
  node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected , NULL, data, TRUE);
  g_list_free (data);
}

void menu_new_template (GtkMenuItem *menuitem, gpointer user_data)
{
  GList *data = NULL;
  GtkCTreeNode *node;
  int i;

  /* Valeurs */
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Create separator"))))
    data = g_list_append (data, "--------------------");
  else
    data = g_list_append (data, "");
  data = g_list_append (data, "");
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Create folder"))))
    data = g_list_append (data, "folder");
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Create separator"))))
    data = g_list_append (data, "separator");
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Add file"))))
    data = g_list_append (data, "file");
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Add directory"))))
    data = g_list_append (data, "directory");

  /* Node */
  if (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected)
    td_mod_tree_expand (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), NULL);
  node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected , NULL, data, TRUE);
  g_list_free (data);
}

void menu_remove_file (GtkMenuItem *menuitem, gpointer user_data)
{
  td_mod_tree_remove_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
}

void menu_remove_template (GtkMenuItem *menuitem, gpointer user_data)
{
  td_mod_tree_remove_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)));
}

/*****************************************************************************/
/* Barre d'outils */
/*****************************************************************************/
void radiobutton1_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->notebook), 0);
}

void radiobutton2_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->notebook), 1);
}

void radiobutton3_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->notebook), 2);
}


/*****************************************************************************/
/* Fichier */
/*****************************************************************************/
void save_data (void)
{
  /* Sauvegarde */
  td_mod_tree_save_flower (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), flower[0], g_strdup_printf ("%s/favorites.xml", TD_APP(APP)->dir_var));
  td_mod_tree_save_flower (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), flower[1], g_strdup_printf ("%s/templates.xml", TD_APP(APP)->dir_var));
  td_mod_tree_save_flower (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2)), flower[2], g_strdup_printf ("%s/history.xml", TD_APP(APP)->dir_var));

  /* Rafrachissement des menus */
  gnome_app_remove_menu_range (GNOME_APP (TD_APP_PALETTE (TD_APP (APP)->palette)->window), 
			       g_strdup_printf("%s/%s/", _("File"), _("Favorites")), 0, g_list_length (TD_FLOWER (flower[0])->items_value));
  td_flower_load_file (TD_FLOWER (flower[0]), g_strdup_printf ("%s/favorites.xml", TD_APP(APP)->dir_var));
  menu_add (flower[0], g_strdup_printf("%s/%s/", _("File"), _("Favorites")), 9);

  gnome_app_remove_menu_range (GNOME_APP (TD_APP_PALETTE (TD_APP (APP)->palette)->window), 
			       g_strdup_printf("%s/%s/", _("File"), _("New")), 0, g_list_length (TD_FLOWER (flower[1])->items_value)+3);
  td_flower_load_file (TD_FLOWER (flower[1]), g_strdup_printf ("%s/templates.xml", TD_APP(APP)->dir_var));
  menu_add (flower[1], g_strdup_printf("%s/%s/", _("File"), _("New")), 2);

  gnome_app_remove_menu_range (GNOME_APP (TD_APP_PALETTE (TD_APP (APP)->palette)->window), 
			       g_strdup_printf("%s/%s/", _("File"), _("Open")), 0, g_list_length (TD_FLOWER (flower[2])->items_value)+3);
  td_flower_load_file (TD_FLOWER (flower[2]), g_strdup_printf ("%s/history.xml", TD_APP(APP)->dir_var));
  menu_add (flower[2], g_strdup_printf("%s/%s/", _("File"), _("Open")), 9);
  td_db_connect_add_menu ();
}

void load_data (void)
{
  td_flower_load_file (TD_FLOWER (flower[0]), g_strdup_printf ("%s/favorites.xml", TD_APP(APP)->dir_var));
  td_flower_load_file (TD_FLOWER (flower[1]), g_strdup_printf ("%s/templates.xml", TD_APP(APP)->dir_var));
  td_flower_load_file (TD_FLOWER (flower[2]), g_strdup_printf ("%s/history.xml", TD_APP(APP)->dir_var));
  td_mod_tree_load_flower (g_list_nth_data (TD_MOD (mod)->child, 0), flower[0]);
  td_mod_tree_load_flower (g_list_nth_data (TD_MOD (mod)->child, 1), flower[1]);
  td_mod_tree_load_flower (g_list_nth_data (TD_MOD (mod)->child, 2), flower[2]);
}

/*****************************************************************************/
/* Menus de la palette */
/*****************************************************************************/
void menu_add (GtkObject *flower, gchar *path_init, int type_field)
{
  GList *path = NULL;
  gchar *path_tmp;
  GList *data = NULL;
  GnomeUIInfo *menu;
  gchar *txt_tmp;
  int i, j, k;
  int type = 0;

  /* Init */
  if (!strcmp (path_init, g_strdup_printf ("%s/%s/", _("File"), _("Favorites"))))
    type = 1;
  if (!strcmp (path_init, g_strdup_printf ("%s/%s/", _("File"), _("New"))))
    type = 2;
  if (!strcmp (path_init, g_strdup_printf ("%s/%s/", _("File"), _("Open"))))
    type = 3;
  menu = g_malloc0 (2 * sizeof (GnomeUIInfo));

  /* Go ! */
  for (i=0; i<g_list_length (TD_FLOWER (flower)->items_value); i++)
    {

      /* Commun */
      menu = g_malloc0 (2 * sizeof (GnomeUIInfo));
      data = g_list_nth_data (TD_FLOWER (flower)->items_value, i);
      menu->label = g_strdup_printf ("%s", (gchar*) g_list_nth_data (data, 0));

      /* Chemin */
      if ((!i) || (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 1))
	path_tmp = g_strdup_printf ("%s", path_init);
      else
	{
	  j = 1;
	  while (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i-j)) != 
		 (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i))) - 1)
	    j++;
	  path_tmp = g_strdup_printf ("%s", (gchar*) g_list_nth_data (path, i-j));
	}

      /* Dossier */
      if (!strcmp ((gchar*) g_list_nth_data (data, type_field), "folder"))
	{
	  menu->type = GNOME_APP_UI_SUBTREE;
 	  menu->moreinfo = menu_empty_uiinfo;
	  menu->pixmap_type = GNOME_APP_PIXMAP_DATA;
	  menu->pixmap_info = TD_STOCK_LIST_FOLDER;
	  (menu + 1)->type = GNOME_APP_UI_ENDOFINFO;
	  gnome_app_insert_menus (GNOME_APP (TD_APP_PALETTE (TD_APP (APP)->palette)->window), path_tmp, menu);
	  path = g_list_append (path, g_strdup_printf ("%s%s/", path_tmp, menu->label));
	  continue;
	}

      /* Sparateur */
      if (!strcmp ((gchar*) g_list_nth_data (data, type_field), "separator"))
	menu->type = GNOME_APP_UI_SEPARATOR; 

      /* Fichier */
      if (!strcmp ((gchar*) g_list_nth_data (data, type_field), "file"))
	{
	  menu->type = GNOME_APP_UI_ITEM;
	  menu->user_data = g_strdup_printf("%d/%d", type, i);
	  menu->hint = NULL;
	  menu->moreinfo = td_db_connect_bookmarks;
	  menu->unused_data = NULL;
	  menu->pixmap_type = GNOME_APP_PIXMAP_STOCK;
	  menu->pixmap_info = GNOME_STOCK_MENU_NEW;
	  menu->accelerator_key = 0;
	}

      /* Rpertoire */
      if (!strcmp ((gchar*) g_list_nth_data (data, type_field), "directory"))
	{
	  menu->type = GNOME_APP_UI_ITEM;
	  menu->user_data = g_strdup_printf("%d/%d", type, i);
	  menu->hint = NULL;
	  menu->moreinfo = td_db_connect_bookmarks;
	  menu->unused_data = NULL;
	  menu->pixmap_type = GNOME_APP_PIXMAP_DATA;
	  menu->pixmap_info = TD_STOCK_LIST_DIRECTORY;
	  menu->accelerator_key = 0;
	}

      /* URL */
      if (!strcmp ((gchar*) g_list_nth_data (data, type_field), "url"))
	{
	  menu->type = GNOME_APP_UI_ITEM;
	  menu->user_data = g_strdup_printf("%d/%d", type, i);
	  menu->hint = NULL;
	  menu->moreinfo = td_db_connect_bookmarks;
	  menu->unused_data = NULL;
	  menu->pixmap_type = GNOME_APP_PIXMAP_DATA;
	  menu->pixmap_info = TD_STOCK_LIST_URL;
	  menu->accelerator_key = 0;
	}

      /* Base de donnes */
      if (!strcmp ((gchar*) g_list_nth_data (data, type_field), "database"))
	{
	  menu->type = GNOME_APP_UI_ITEM;
	  menu->user_data = g_strdup_printf("%d/%d", type, i);
	  menu->hint = NULL;
	  menu->moreinfo = td_db_connect_bookmarks;
	  menu->unused_data = NULL;
	  menu->pixmap_type = GNOME_APP_PIXMAP_DATA;
	  menu->pixmap_info = TD_STOCK_LIST_DATABASE;
	  menu->accelerator_key = 0;
	}

      /* Go ! */
      (menu + 1)->type = GNOME_APP_UI_ENDOFINFO;
      path = g_list_append (path, path_tmp);
      gnome_app_insert_menus (GNOME_APP (TD_APP_PALETTE (TD_APP (APP)->palette)->window), (gchar*) g_list_nth_data (path, i), menu);
    }
  g_free (menu);
}


GtkObject *plugins_menu_activate (gchar *number_tmp)
{
  GtkObject *connect;
  GtkCTreeNode *node;
  GList *data;
  gchar *part1;
  gchar *part2;
  gchar *number;

  /* Recherche du signets */
  number = g_strdup_printf("%s", number_tmp);
  part1 = strtok (number,"/");
  part2 = strtok (NULL,"/");
  data = g_list_nth_data (TD_FLOWER (flower[atoi(part1)-1])->items_value, atoi(part2));
  connect = td_db_connect_new();
  if ((!strcmp (part1, "1")) || (!strcmp (part1, "3")))
    {
      if (!strcmp (g_list_nth_data (data, 9), "database"))
	gtk_object_set (GTK_OBJECT (connect), 
			"name", (gchar*) g_list_nth_data (data, 0),
			"interface", (gchar*) g_list_nth_data (data, 1),
			"host", (gchar*) g_list_nth_data (data, 2),
			"port", (gchar*) g_list_nth_data (data, 3),
			"base", (gchar*) g_list_nth_data (data, 4),
			"user", (gchar*) g_list_nth_data (data, 5),
			"password", (gchar*) g_list_nth_data (data, 6),
			"template", (gchar*) g_list_nth_data (data, 7),
			"type", (gchar*) g_list_nth_data (data, 9),
			"file", g_strdup_printf ("%s/database.toutdoux", TD_APP (APP)->dir_tmp), NULL);
      else
	gtk_object_set (GTK_OBJECT (connect),
			"name", (gchar*) g_list_nth_data (data, 0),
			"file", (gchar*) g_list_nth_data (data, 8),
			"type", (gchar*) g_list_nth_data (data, 9), NULL);
      if (!strcmp (g_list_nth_data (data, 9), "url"))
	gtk_object_set (GTK_OBJECT (connect),
			"base", (gchar*) g_list_nth_data (data, 8),
			"file", g_strdup_printf ("%s/url.toutdoux", TD_APP (APP)->dir_tmp), NULL);
    }
  if (!strcmp (part1, "2"))
    gtk_object_set (GTK_OBJECT (connect), 
		    "name", _("New"),
		    "type", "template",
		    "file", (gchar*) g_list_nth_data (data, 1), NULL);
  return connect;
}

void plugins_add_recents (GtkObject *connect)
{
  GList *data = NULL;
  GList *data1 = NULL;
  GtkCTreeNode *node;
  GtkCTreeNode *node2;
  GtkCTreeNode *node3 = NULL;
  int i, j;
  int fp;
  gboolean bool_tmp;

  /* Ajout */
  if (connect)
    {
      data = g_list_append (data, (gchar*) TD_DB_CONNECT(connect)->name);
      if (TD_DB_CONNECT(connect)->interface)
	data = g_list_append (data, (gchar*) TD_DB_CONNECT(connect)->interface);
      else
	data = g_list_append (data, "");
      if (TD_DB_CONNECT(connect)->host)
	data = g_list_append (data, (gchar*) TD_DB_CONNECT(connect)->host);
      else
	data = g_list_append (data, "");
      if (TD_DB_CONNECT(connect)->port)
	data = g_list_append (data, (gchar*) TD_DB_CONNECT(connect)->port);
      else
	data = g_list_append (data, "");

      if (TD_DB_CONNECT(connect)->base)
	{
	  if (!strcmp (TD_DB_CONNECT(connect)->type, "url"))
	    data = g_list_append (data, "");
	  else	    
	    data = g_list_append (data, (gchar*) TD_DB_CONNECT(connect)->base);
	}
      else
	data = g_list_append (data, "");

      if (TD_DB_CONNECT(connect)->user)
	data = g_list_append (data, (gchar*) TD_DB_CONNECT(connect)->user);
      else
	data = g_list_append (data, "");
      if (TD_DB_CONNECT(connect)->password)
	data = g_list_append (data, (gchar*) TD_DB_CONNECT(connect)->password);
      else
	data = g_list_append (data, "");
      if (TD_DB_CONNECT(connect)->template)
	data = g_list_append (data, (gchar*) TD_DB_CONNECT(connect)->template);
      else
	data = g_list_append (data, "");

      if (TD_DB_CONNECT(connect)->file)
	{
	  if (!strcmp (TD_DB_CONNECT(connect)->type, "url"))
	    data = g_list_append (data, (gchar*) TD_DB_CONNECT(connect)->base);
	  else
	    data = g_list_append (data, (gchar*) TD_DB_CONNECT(connect)->file);
	}
      else
	data = g_list_append (data, "");

      if (TD_DB_CONNECT(connect)->type)
	data = g_list_append (data, (gchar*) TD_DB_CONNECT(connect)->type);
      else
	data = g_list_append (data, "");
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2)), NULL , NULL, data, TRUE);
    }

  /* Suppression des doublons */
  bool_tmp = FALSE;
  node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->widget)->child), 0);
  while (node)
    {
      data = td_mod_tree_read_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2)), node, FALSE);
      if (bool_tmp)
	gtk_ctree_remove_node (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->widget)->child), node3);
      bool_tmp = FALSE;
      node2 = gtdk_ctree_next (node);
      while (node2)
	{
	  data1 = td_mod_tree_read_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2)), node2, FALSE);
	  if (!strcmp (g_list_nth_data (data, 0), g_list_nth_data (data1, 0)))
	    if (!strcmp (g_list_nth_data (data, 9), g_list_nth_data (data1, 9)))
	      {
		bool_tmp = TRUE;
		node3=node;
		break;
	      }
	  data1 = NULL;
	  node2 = gtdk_ctree_next (node2);
	}
      data = NULL;
      node = gtdk_ctree_next (node);
    }

  /* Suppression des obsoltes */
  bool_tmp = FALSE;
  node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->widget)->child), 0);
  while (node)
    {
      data = td_mod_tree_read_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2)), node, FALSE);
      if (bool_tmp)
	gtk_ctree_remove_node (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->widget)->child), node3);
      bool_tmp = FALSE;
      if (!strcmp (g_list_nth_data (data, 9), "file"))
	{
	  fp = open (g_list_nth_data (data, 8), O_RDONLY);
	  if (fp ==-1)
	    {
	      bool_tmp = TRUE;
	      node3=node;
	    }
	}
      data = NULL;
      node = gtdk_ctree_next (node);
    }

  /* Limitation de la liste  10 */
  i = 0;
  node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->widget)->child), 0);
  while (node)
    {      
      i++;
      node = gtdk_ctree_next (node);
    }
  node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->widget)->child), 0);
  if (i>10)
    gtk_ctree_remove_node (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2))->widget)->child), node);

  /* Menu */
  gnome_app_remove_menu_range (GNOME_APP (TD_APP_PALETTE (TD_APP (APP)->palette)->window), g_strdup_printf("%s/%s/", _("File"), _("Open")), 0, g_list_length (TD_FLOWER (flower[2])->items_value)+3);
  td_mod_tree_save_flower (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 2)), flower[2], g_strdup_printf ("%s/history.xml", TD_APP(APP)->dir_var));
  td_flower_load_file (TD_FLOWER (flower[2]), g_strdup_printf ("%s/history.xml", TD_APP(APP)->dir_var));
  menu_add (flower[2], g_strdup_printf("%s/%s/", _("File"), _("Open")), 9);
  td_db_connect_add_menu_recents ();
  g_list_free (data);
}
