/*****************************************************************************/
/* configuration.c : configuration utilisateur
 * configuration.c : user configuration
 *
 *
 * TouxDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>
#include <dirent.h>
#include <sys/stat.h>
#include <toutdoux.h>

#include "main.h"
#include "configuration.h"


/*****************************************************************************/
/* Installation */
/*****************************************************************************/
gboolean installation (void)
{
  DIR *cur_repertoire;
  gboolean bool_tmp;
  gchar *txt_tmp;

  /* Rpertoires */
  bool_tmp = FALSE;
  cur_repertoire = opendir (g_strdup_printf ("%s/.toutdoux", g_get_home_dir()));
  if (cur_repertoire)
    {
      closedir (cur_repertoire);
      return TRUE;
    }
  td_palette_message (NULL, _("Installation"), "begin");
  if (mkdir (g_strdup_printf ("%s/.toutdoux", g_get_home_dir ()), S_IRWXU))
    {
      td_palette_message (NULL, _("Creating user's directory"), "failed");
      td_palette_message (NULL, _("Installation"), "end");
      return FALSE;
    }
  cur_repertoire = opendir (g_strdup_printf("%s/.toutdoux/tmp", g_get_home_dir()));
  if (mkdir (g_strdup_printf ("%s/.toutdoux/tmp", g_get_home_dir()), S_IRWXU))
    {
      td_palette_message (NULL, _("Creating user's directory of tempory file"), "failed");
      td_palette_message (NULL, _("Installation"), "end");
      return FALSE;
    }
  cur_repertoire = opendir (g_strdup_printf("%s/.toutdoux/customize", g_get_home_dir()));
  if (mkdir (g_strdup_printf ("%s/.toutdoux/customize", g_get_home_dir()), S_IRWXU))
    {
      td_palette_message (NULL, _("Creating user's directory of customizing file"), "failed");
      td_palette_message (NULL, _("Installation"), "end");
      return FALSE;
    }

  /* Fichiers */
  txt_tmp = g_strdup_printf ("cp %s/share/toutdoux/favorites.install.xml %s/.toutdoux/favorites.xml", PACKAGE_DATA_DIR, g_get_home_dir());
  if (!td_system (txt_tmp))
    {
      td_palette_message (NULL, _("Installation"), "end");
      return FALSE;
    }
  txt_tmp = g_strdup_printf ("cp %s/share/toutdoux/templates.install.xml %s/.toutdoux/templates.xml", PACKAGE_DATA_DIR, g_get_home_dir());
  if (!td_system (txt_tmp))
    {
      td_palette_message (NULL, _("Installation"), "end");
      return FALSE;
    }
  td_palette_message (NULL, _("Installation"), "end");
  return TRUE;
}






