/* rygel-media-export-query-container.c generated by valac, the Vala compiler
 * generated from rygel-media-export-query-container.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;
typedef struct _RygelMediaExportQueryContainerPrivate RygelMediaExportQueryContainerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaExportQueryContainerSearchData RygelMediaExportQueryContainerSearchData;
typedef struct _RygelMediaExportQueryContainerGetChildrenData RygelMediaExportQueryContainerGetChildrenData;

struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelMediaExportQueryContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportQueryContainerPrivate * priv;
	char* plaintext_id;
};

struct _RygelMediaExportQueryContainerClass {
	RygelMediaExportDBContainerClass parent_class;
};

struct _RygelMediaExportQueryContainerPrivate {
	char* attribute;
	RygelSearchExpression* expression;
	char* pattern;
};

struct _RygelMediaExportQueryContainerSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportQueryContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	GeeList* result;
	RygelLogicalExpression* combined_expression;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp1_;
	guint max_objects;
	GeeList* children;
	GError * _inner_error_;
};

struct _RygelMediaExportQueryContainerGetChildrenData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportQueryContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	GeeList* result;
	GeeList* children;
	guint total_matches;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	guint max_objects;
	GeeList* _tmp2_;
	GeeList* data;
	GeeIterator* _meta_data_it;
	char* meta_data;
	char* new_id;
	char* _tmp3_;
	RygelMediaExportQueryContainer* container;
	GeeIterator* _child_it;
	RygelMediaObject* child;
	GError * _inner_error_;
};


static GeeHashMap* rygel_media_export_query_container_virtual_container_map;
static GeeHashMap* rygel_media_export_query_container_virtual_container_map = NULL;
static gpointer rygel_media_export_query_container_parent_class = NULL;

GType rygel_media_export_db_container_get_type (void);
GType rygel_media_export_media_cache_get_type (void);
GType rygel_media_export_query_container_get_type (void);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
gboolean rygel_media_export_query_container_validate_virtual_id (const char* id);
RygelMediaExportDBContainer* rygel_media_export_db_container_new (RygelMediaExportMediaCache* media_db, const char* id, const char* title);
RygelMediaExportDBContainer* rygel_media_export_db_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const char* id, const char* title);
char* rygel_media_export_query_container_get_virtual_container_definition (const char* hash);
static void rygel_media_export_query_container_update_search_expression (RygelMediaExportQueryContainer* self, const char* op1_, const char* op2);
static gint rygel_media_export_query_container_count_children (RygelMediaExportQueryContainer* self);
RygelMediaExportQueryContainer* rygel_media_export_query_container_new (RygelMediaExportMediaCache* media_db, const char* id, const char* name);
RygelMediaExportQueryContainer* rygel_media_export_query_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const char* id, const char* name);
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const char* container_id, guint offset, guint max_count, GError** error);
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const char* attribute, RygelSearchExpression* expression, glong offset, glong max_count, GError** error);
static void rygel_media_export_query_container_real_search_data_free (gpointer _data);
static void rygel_media_export_query_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_export_query_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GeeList* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const char* container_id, guint offset, guint max_count, guint* total_matches, GError** error);
static gboolean rygel_media_export_query_container_real_search_co (RygelMediaExportQueryContainerSearchData* data);
static void rygel_media_export_query_container_real_get_children_data_free (gpointer _data);
static void rygel_media_export_query_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_export_query_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_export_query_container_register_id (char** id);
static gboolean rygel_media_export_query_container_real_get_children_co (RygelMediaExportQueryContainerGetChildrenData* data);
static void rygel_media_export_query_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 38 "rygel-media-export-query-container.vala"
gboolean rygel_media_export_query_container_validate_virtual_id (const char* id) {
#line 189 "rygel-media-export-query-container.c"
	gboolean result = FALSE;
	char** _tmp1_;
	gint _args_size_;
	gint args_length1;
	char** _tmp0_;
	char** args;
#line 38 "rygel-media-export-query-container.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 39 "rygel-media-export-query-container.vala"
	if (!g_str_has_prefix (id, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX)) {
#line 200 "rygel-media-export-query-container.c"
		result = FALSE;
#line 41 "rygel-media-export-query-container.vala"
		return result;
#line 204 "rygel-media-export-query-container.c"
	}
	args = (_tmp1_ = _tmp0_ = g_strsplit (id, ",", 0), args_length1 = _vala_array_length (_tmp0_), _args_size_ = args_length1, _tmp1_);
#line 46 "rygel-media-export-query-container.vala"
	if ((args_length1 % 2) != 0) {
#line 47 "rygel-media-export-query-container.vala"
		g_warning ("rygel-media-export-query-container.vala:47: %s", _ ("ID does not contain pairs"));
#line 211 "rygel-media-export-query-container.c"
		result = FALSE;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 49 "rygel-media-export-query-container.vala"
		return result;
#line 216 "rygel-media-export-query-container.c"
	}
	{
		gint i;
#line 52 "rygel-media-export-query-container.vala"
		i = 0;
#line 222 "rygel-media-export-query-container.c"
		{
			gboolean _tmp2_;
#line 52 "rygel-media-export-query-container.vala"
			_tmp2_ = TRUE;
#line 52 "rygel-media-export-query-container.vala"
			while (TRUE) {
#line 229 "rygel-media-export-query-container.c"
				gboolean _tmp3_ = FALSE;
#line 52 "rygel-media-export-query-container.vala"
				if (!_tmp2_) {
#line 52 "rygel-media-export-query-container.vala"
					i = i + 2;
#line 235 "rygel-media-export-query-container.c"
				}
#line 52 "rygel-media-export-query-container.vala"
				_tmp2_ = FALSE;
#line 52 "rygel-media-export-query-container.vala"
				if (!(i < args_length1)) {
#line 52 "rygel-media-export-query-container.vala"
					break;
#line 243 "rygel-media-export-query-container.c"
				}
#line 53 "rygel-media-export-query-container.vala"
				if (_vala_strcmp0 (args[i], "") == 0) {
#line 53 "rygel-media-export-query-container.vala"
					_tmp3_ = TRUE;
#line 249 "rygel-media-export-query-container.c"
				} else {
#line 53 "rygel-media-export-query-container.vala"
					_tmp3_ = _vala_strcmp0 (args[i + 1], "") == 0;
#line 253 "rygel-media-export-query-container.c"
				}
#line 53 "rygel-media-export-query-container.vala"
				if (_tmp3_) {
#line 54 "rygel-media-export-query-container.vala"
					g_warning ("rygel-media-export-query-container.vala:54: %s", _ ("Empty part not allowed in virtual ID"));
#line 259 "rygel-media-export-query-container.c"
					result = FALSE;
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 56 "rygel-media-export-query-container.vala"
					return result;
#line 264 "rygel-media-export-query-container.c"
				}
#line 59 "rygel-media-export-query-container.vala"
				if (_vala_strcmp0 (args[i], "?") == 0) {
#line 60 "rygel-media-export-query-container.vala"
					g_warning ("rygel-media-export-query-container.vala:60: %s", _ ("Placeholder can only be on second place"));
#line 270 "rygel-media-export-query-container.c"
					result = FALSE;
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 62 "rygel-media-export-query-container.vala"
					return result;
#line 275 "rygel-media-export-query-container.c"
				}
			}
		}
	}
	result = TRUE;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 66 "rygel-media-export-query-container.vala"
	return result;
#line 284 "rygel-media-export-query-container.c"
}


#line 1148 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 290 "rygel-media-export-query-container.c"
	char* result = NULL;
	GError * _inner_error_;
#line 1148 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1148 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1148 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 299 "rygel-media-export-query-container.c"
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1150 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 308 "rygel-media-export-query-container.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch27_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1151 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 319 "rygel-media-export-query-container.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch27_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1151 "glib-2.0.vapi"
		return result;
#line 334 "rygel-media-export-query-container.c"
	}
	goto __finally27;
	__catch27_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1153 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 345 "rygel-media-export-query-container.c"
			_g_error_free0 (e);
		}
	}
	__finally27:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 69 "rygel-media-export-query-container.vala"
RygelMediaExportQueryContainer* rygel_media_export_query_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const char* id, const char* name) {
#line 360 "rygel-media-export-query-container.c"
	RygelMediaExportQueryContainer * self;
	char* _tmp0_;
	char** _tmp2_;
	gint _args_size_;
	gint args_length1;
	char** _tmp1_;
	char** args;
	gint i;
#line 69 "rygel-media-export-query-container.vala"
	g_return_val_if_fail (media_db != NULL, NULL);
#line 69 "rygel-media-export-query-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 69 "rygel-media-export-query-container.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 91 "rygel-media-export-query-container.vala"
	self = (RygelMediaExportQueryContainer*) rygel_media_export_db_container_construct (object_type, media_db, id, name);
#line 93 "rygel-media-export-query-container.vala"
	self->plaintext_id = (_tmp0_ = rygel_media_export_query_container_get_virtual_container_definition (id), _g_free0 (self->plaintext_id), _tmp0_);
#line 94 "rygel-media-export-query-container.vala"
	g_debug ("rygel-media-export-query-container.vala:94: plaintext ID is: %s", self->plaintext_id);
#line 381 "rygel-media-export-query-container.c"
	args = (_tmp2_ = _tmp1_ = g_strsplit (self->plaintext_id, ",", 0), args_length1 = _vala_array_length (_tmp1_), _args_size_ = args_length1, _tmp2_);
#line 97 "rygel-media-export-query-container.vala"
	if ((args_length1 % 2) != 0) {
#line 98 "rygel-media-export-query-container.vala"
		g_assert_not_reached ();
#line 387 "rygel-media-export-query-container.c"
	}
#line 101 "rygel-media-export-query-container.vala"
	i = 0;
#line 102 "rygel-media-export-query-container.vala"
	while (TRUE) {
#line 102 "rygel-media-export-query-container.vala"
		if (!(i < args_length1)) {
#line 102 "rygel-media-export-query-container.vala"
			break;
#line 397 "rygel-media-export-query-container.c"
		}
#line 103 "rygel-media-export-query-container.vala"
		if (_vala_strcmp0 (args[i + 1], "?") != 0) {
#line 104 "rygel-media-export-query-container.vala"
			rygel_media_export_query_container_update_search_expression (self, args[i], args[i + 1]);
#line 105 "rygel-media-export-query-container.vala"
			if (_vala_strcmp0 (name, "") == 0) {
#line 106 "rygel-media-export-query-container.vala"
				rygel_media_object_set_title ((RygelMediaObject*) self, args[i + 1]);
#line 407 "rygel-media-export-query-container.c"
			}
		} else {
			char* _tmp3_;
			char* _tmp4_;
			char* _tmp5_;
			char* _tmp6_;
#line 109 "rygel-media-export-query-container.vala"
			args[i + 1] = (_tmp3_ = g_strdup ("%s"), _g_free0 (args[i + 1]), _tmp3_);
#line 110 "rygel-media-export-query-container.vala"
			self->priv->attribute = (_tmp4_ = string_replace (args[i], RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, ""), _g_free0 (self->priv->attribute), _tmp4_);
#line 111 "rygel-media-export-query-container.vala"
			self->priv->attribute = (_tmp5_ = g_uri_unescape_string (self->priv->attribute, NULL), _g_free0 (self->priv->attribute), _tmp5_);
#line 112 "rygel-media-export-query-container.vala"
			self->priv->pattern = (_tmp6_ = g_strjoinv (",", args), _g_free0 (self->priv->pattern), _tmp6_);
#line 113 "rygel-media-export-query-container.vala"
			break;
#line 424 "rygel-media-export-query-container.c"
		}
#line 115 "rygel-media-export-query-container.vala"
		i = i + 2;
#line 428 "rygel-media-export-query-container.c"
	}
#line 117 "rygel-media-export-query-container.vala"
	((RygelMediaContainer*) self)->child_count = rygel_media_export_query_container_count_children (self);
#line 432 "rygel-media-export-query-container.c"
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


#line 69 "rygel-media-export-query-container.vala"
RygelMediaExportQueryContainer* rygel_media_export_query_container_new (RygelMediaExportMediaCache* media_db, const char* id, const char* name) {
#line 69 "rygel-media-export-query-container.vala"
	return rygel_media_export_query_container_construct (RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, media_db, id, name);
#line 442 "rygel-media-export-query-container.c"
}


#line 120 "rygel-media-export-query-container.vala"
static gint rygel_media_export_query_container_count_children (RygelMediaExportQueryContainer* self) {
#line 448 "rygel-media-export-query-container.c"
	gint result = 0;
	GError * _inner_error_;
#line 120 "rygel-media-export-query-container.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 453 "rygel-media-export-query-container.c"
	_inner_error_ = NULL;
	{
#line 122 "rygel-media-export-query-container.vala"
		if (_vala_strcmp0 (self->priv->pattern, "") == 0) {
#line 458 "rygel-media-export-query-container.c"
			glong _tmp0_;
#line 123 "rygel-media-export-query-container.vala"
			_tmp0_ = rygel_media_export_media_cache_get_object_count_by_search_expression (((RygelMediaExportDBContainer*) self)->media_db, self->priv->expression, "0", (guint) 0, (guint) (-1), &_inner_error_);
#line 462 "rygel-media-export-query-container.c"
			if (_inner_error_ != NULL) {
				goto __catch28_g_error;
			}
			result = (gint) _tmp0_;
#line 123 "rygel-media-export-query-container.vala"
			return result;
#line 469 "rygel-media-export-query-container.c"
		} else {
			gint retval;
			GeeList* data;
#line 129 "rygel-media-export-query-container.vala"
			retval = 0;
#line 130 "rygel-media-export-query-container.vala"
			data = rygel_media_export_media_cache_get_object_attribute_by_search_expression (((RygelMediaExportDBContainer*) self)->media_db, self->priv->attribute, self->priv->expression, (glong) 0, (glong) (-1), &_inner_error_);
#line 477 "rygel-media-export-query-container.c"
			if (_inner_error_ != NULL) {
				goto __catch28_g_error;
			}
			{
				GeeIterator* _meta_data_it;
				_meta_data_it = gee_iterable_iterator ((GeeIterable*) data);
#line 136 "rygel-media-export-query-container.vala"
				while (TRUE) {
#line 486 "rygel-media-export-query-container.c"
					char* meta_data;
#line 136 "rygel-media-export-query-container.vala"
					if (!gee_iterator_next (_meta_data_it)) {
#line 136 "rygel-media-export-query-container.vala"
						break;
#line 492 "rygel-media-export-query-container.c"
					}
#line 136 "rygel-media-export-query-container.vala"
					meta_data = (char*) gee_iterator_get (_meta_data_it);
#line 137 "rygel-media-export-query-container.vala"
					if (meta_data != NULL) {
#line 138 "rygel-media-export-query-container.vala"
						retval++;
#line 500 "rygel-media-export-query-container.c"
					}
					_g_free0 (meta_data);
				}
				_g_object_unref0 (_meta_data_it);
			}
			result = retval;
			_g_object_unref0 (data);
#line 142 "rygel-media-export-query-container.vala"
			return result;
#line 510 "rygel-media-export-query-container.c"
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			result = 0;
			_g_error_free0 (e);
#line 145 "rygel-media-export-query-container.vala"
			return result;
#line 524 "rygel-media-export-query-container.c"
		}
	}
	__finally28:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
}


static void rygel_media_export_query_container_real_search_data_free (gpointer _data) {
	RygelMediaExportQueryContainerSearchData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelMediaExportQueryContainerSearchData, data);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_media_export_query_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportQueryContainer * self;
	RygelMediaExportQueryContainerSearchData* _data_;
	self = (RygelMediaExportQueryContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportQueryContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_query_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_query_container_real_search_data_free);
	_data_->self = g_object_ref (self);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_export_query_container_real_search_co (_data_);
}


static GeeList* rygel_media_export_query_container_real_search_finish (RygelMediaContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	GeeList* result;
	RygelMediaExportQueryContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_export_query_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportQueryContainerSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_export_query_container_real_search_co (data);
}


static gboolean rygel_media_export_query_container_real_search_co (RygelMediaExportQueryContainerSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->combined_expression = rygel_logical_expression_new ();
#line 157 "rygel-media-export-query-container.vala"
		((RygelSearchExpression*) data->combined_expression)->operand1 = (data->_tmp0_ = _rygel_search_expression_ref0 (data->self->priv->expression), _rygel_search_expression_unref0 (((RygelSearchExpression*) data->combined_expression)->operand1), data->_tmp0_);
#line 158 "rygel-media-export-query-container.vala"
		((RygelSearchExpression*) data->combined_expression)->op = GINT_TO_POINTER (RYGEL_LOGICAL_OPERATOR_AND);
#line 159 "rygel-media-export-query-container.vala"
		((RygelSearchExpression*) data->combined_expression)->operand2 = (data->_tmp1_ = _rygel_search_expression_ref0 (data->expression), _rygel_search_expression_unref0 (((RygelSearchExpression*) data->combined_expression)->operand2), data->_tmp1_);
#line 611 "rygel-media-export-query-container.c"
		data->max_objects = data->max_count;
#line 162 "rygel-media-export-query-container.vala"
		if (data->max_objects == 0) {
#line 163 "rygel-media-export-query-container.vala"
			data->max_objects = (guint) (-1);
#line 617 "rygel-media-export-query-container.c"
		}
		data->children = rygel_media_export_media_cache_get_objects_by_search_expression (((RygelMediaExportDBContainer*) data->self)->media_db, (RygelSearchExpression*) data->combined_expression, "0", data->offset, data->max_objects, &data->total_matches, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_rygel_search_expression_unref0 (data->combined_expression);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->result = data->children;
		_rygel_search_expression_unref0 (data->combined_expression);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_rygel_search_expression_unref0 (data->combined_expression);
		_g_object_unref0 (data->children);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_media_export_query_container_real_get_children_data_free (gpointer _data) {
	RygelMediaExportQueryContainerGetChildrenData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelMediaExportQueryContainerGetChildrenData, data);
}


static void rygel_media_export_query_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportQueryContainer * self;
	RygelMediaExportQueryContainerGetChildrenData* _data_;
	self = (RygelMediaExportQueryContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportQueryContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_query_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_query_container_real_get_children_data_free);
	_data_->self = g_object_ref (self);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_export_query_container_real_get_children_co (_data_);
}


static GeeList* rygel_media_export_query_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	GeeList* result;
	RygelMediaExportQueryContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_export_query_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportQueryContainerGetChildrenData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_export_query_container_real_get_children_co (data);
}


static gboolean rygel_media_export_query_container_real_get_children_co (RygelMediaExportQueryContainerGetChildrenData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
#line 183 "rygel-media-export-query-container.vala"
		if (_vala_strcmp0 (data->self->priv->pattern, "") == 0) {
#line 719 "rygel-media-export-query-container.c"
			data->_state_ = 3;
			rygel_media_container_search ((RygelMediaContainer*) data->self, data->self->priv->expression, data->offset, data->max_count, data->cancellable, rygel_media_export_query_container_get_children_ready, data);
			return FALSE;
			_state_3:
			data->_tmp0_ = rygel_media_container_search_finish ((RygelMediaContainer*) data->self, data->_res_, &data->total_matches, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->children);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
#line 187 "rygel-media-export-query-container.vala"
			data->children = (data->_tmp1_ = data->_tmp0_, _g_object_unref0 (data->children), data->_tmp1_);
#line 741 "rygel-media-export-query-container.c"
		} else {
			data->max_objects = data->max_count;
#line 194 "rygel-media-export-query-container.vala"
			if (data->max_objects == 0) {
#line 195 "rygel-media-export-query-container.vala"
				data->max_objects = (guint) (-1);
#line 748 "rygel-media-export-query-container.c"
			}
#line 198 "rygel-media-export-query-container.vala"
			data->children = (data->_tmp2_ = (GeeList*) gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (data->children), data->_tmp2_);
#line 752 "rygel-media-export-query-container.c"
			data->data = rygel_media_export_media_cache_get_object_attribute_by_search_expression (((RygelMediaExportDBContainer*) data->self)->media_db, data->self->priv->attribute, data->self->priv->expression, (glong) data->offset, (glong) data->max_objects, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->children);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			{
				data->_meta_data_it = gee_iterable_iterator ((GeeIterable*) data->data);
#line 204 "rygel-media-export-query-container.vala"
				while (TRUE) {
#line 204 "rygel-media-export-query-container.vala"
					if (!gee_iterator_next (data->_meta_data_it)) {
#line 204 "rygel-media-export-query-container.vala"
						break;
#line 776 "rygel-media-export-query-container.c"
					}
					data->meta_data = (char*) gee_iterator_get (data->_meta_data_it);
#line 205 "rygel-media-export-query-container.vala"
					if (data->meta_data == NULL) {
#line 781 "rygel-media-export-query-container.c"
						_g_free0 (data->meta_data);
#line 206 "rygel-media-export-query-container.vala"
						continue;
#line 785 "rygel-media-export-query-container.c"
					}
					data->new_id = g_uri_escape_string (data->meta_data, "", TRUE);
#line 212 "rygel-media-export-query-container.vala"
					data->new_id = (data->_tmp3_ = string_replace (data->self->priv->pattern, "%s", data->new_id), _g_free0 (data->new_id), data->_tmp3_);
#line 213 "rygel-media-export-query-container.vala"
					rygel_media_export_query_container_register_id (&data->new_id);
#line 792 "rygel-media-export-query-container.c"
					data->container = rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) data->self)->media_db, data->new_id, data->meta_data);
#line 217 "rygel-media-export-query-container.vala"
					gee_collection_add ((GeeCollection*) data->children, (RygelMediaObject*) data->container);
#line 796 "rygel-media-export-query-container.c"
					_g_free0 (data->meta_data);
					_g_free0 (data->new_id);
					_g_object_unref0 (data->container);
				}
				_g_object_unref0 (data->_meta_data_it);
			}
			_g_object_unref0 (data->data);
		}
		{
			data->_child_it = gee_iterable_iterator ((GeeIterable*) data->children);
#line 221 "rygel-media-export-query-container.vala"
			while (TRUE) {
#line 221 "rygel-media-export-query-container.vala"
				if (!gee_iterator_next (data->_child_it)) {
#line 221 "rygel-media-export-query-container.vala"
					break;
#line 813 "rygel-media-export-query-container.c"
				}
				data->child = (RygelMediaObject*) gee_iterator_get (data->_child_it);
#line 222 "rygel-media-export-query-container.vala"
				data->child->parent = (RygelMediaContainer*) data->self;
#line 818 "rygel-media-export-query-container.c"
				_g_object_unref0 (data->child);
			}
			_g_object_unref0 (data->_child_it);
		}
		data->result = data->children;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->children);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 228 "rygel-media-export-query-container.vala"
void rygel_media_export_query_container_register_id (char** id) {
#line 849 "rygel-media-export-query-container.c"
	char* md5;
	char* _tmp1_;
#line 228 "rygel-media-export-query-container.vala"
	g_return_if_fail (id != NULL);
#line 229 "rygel-media-export-query-container.vala"
	md5 = g_compute_checksum_for_string (G_CHECKSUM_MD5, *id, -1);
#line 230 "rygel-media-export-query-container.vala"
	if (rygel_media_export_query_container_virtual_container_map == NULL) {
#line 858 "rygel-media-export-query-container.c"
		GeeHashMap* _tmp0_;
#line 231 "rygel-media-export-query-container.vala"
		rygel_media_export_query_container_virtual_container_map = (_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL), _g_object_unref0 (rygel_media_export_query_container_virtual_container_map), _tmp0_);
#line 862 "rygel-media-export-query-container.c"
	}
#line 233 "rygel-media-export-query-container.vala"
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) rygel_media_export_query_container_virtual_container_map, md5)) {
#line 234 "rygel-media-export-query-container.vala"
		gee_abstract_map_set ((GeeAbstractMap*) rygel_media_export_query_container_virtual_container_map, md5, *id);
#line 235 "rygel-media-export-query-container.vala"
		g_debug ("rygel-media-export-query-container.vala:235: Registering %s for %s", md5, *id);
#line 870 "rygel-media-export-query-container.c"
	}
#line 238 "rygel-media-export-query-container.vala"
	*id = (_tmp1_ = g_strconcat (RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, md5, NULL), _g_free0 (*id), _tmp1_);
#line 874 "rygel-media-export-query-container.c"
	_g_free0 (md5);
}


#line 241 "rygel-media-export-query-container.vala"
char* rygel_media_export_query_container_get_virtual_container_definition (const char* hash) {
#line 881 "rygel-media-export-query-container.c"
	char* result = NULL;
	char* id;
	gboolean _tmp0_ = FALSE;
#line 241 "rygel-media-export-query-container.vala"
	g_return_val_if_fail (hash != NULL, NULL);
#line 242 "rygel-media-export-query-container.vala"
	id = string_replace (hash, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
#line 243 "rygel-media-export-query-container.vala"
	if (rygel_media_export_query_container_virtual_container_map != NULL) {
#line 244 "rygel-media-export-query-container.vala"
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) rygel_media_export_query_container_virtual_container_map, id);
#line 893 "rygel-media-export-query-container.c"
	} else {
#line 243 "rygel-media-export-query-container.vala"
		_tmp0_ = FALSE;
#line 897 "rygel-media-export-query-container.c"
	}
#line 243 "rygel-media-export-query-container.vala"
	if (_tmp0_) {
#line 901 "rygel-media-export-query-container.c"
		result = (char*) gee_abstract_map_get ((GeeAbstractMap*) rygel_media_export_query_container_virtual_container_map, id);
		_g_free0 (id);
#line 245 "rygel-media-export-query-container.vala"
		return result;
#line 906 "rygel-media-export-query-container.c"
	}
	result = NULL;
	_g_free0 (id);
#line 248 "rygel-media-export-query-container.vala"
	return result;
#line 912 "rygel-media-export-query-container.c"
}


#line 251 "rygel-media-export-query-container.vala"
static void rygel_media_export_query_container_update_search_expression (RygelMediaExportQueryContainer* self, const char* op1_, const char* op2) {
#line 918 "rygel-media-export-query-container.c"
	RygelRelationalExpression* exp;
	char* op1;
	char* _tmp0_;
	char* _tmp1_;
#line 251 "rygel-media-export-query-container.vala"
	g_return_if_fail (self != NULL);
#line 251 "rygel-media-export-query-container.vala"
	g_return_if_fail (op1_ != NULL);
#line 251 "rygel-media-export-query-container.vala"
	g_return_if_fail (op2 != NULL);
#line 252 "rygel-media-export-query-container.vala"
	exp = rygel_relational_expression_new ();
#line 253 "rygel-media-export-query-container.vala"
	op1 = string_replace (op1_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
#line 254 "rygel-media-export-query-container.vala"
	((RygelSearchExpression*) exp)->operand1 = (_tmp0_ = g_uri_unescape_string (op1, NULL), _g_free0 (((RygelSearchExpression*) exp)->operand1), _tmp0_);
#line 255 "rygel-media-export-query-container.vala"
	((RygelSearchExpression*) exp)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
#line 256 "rygel-media-export-query-container.vala"
	((RygelSearchExpression*) exp)->operand2 = (_tmp1_ = g_uri_unescape_string (op2, NULL), _g_free0 (((RygelSearchExpression*) exp)->operand2), _tmp1_);
#line 257 "rygel-media-export-query-container.vala"
	if (self->priv->expression != NULL) {
#line 941 "rygel-media-export-query-container.c"
		RygelLogicalExpression* exp2;
		RygelSearchExpression* _tmp2_;
		RygelSearchExpression* _tmp3_;
		RygelSearchExpression* _tmp4_;
#line 258 "rygel-media-export-query-container.vala"
		exp2 = rygel_logical_expression_new ();
#line 259 "rygel-media-export-query-container.vala"
		((RygelSearchExpression*) exp2)->operand1 = (_tmp2_ = _rygel_search_expression_ref0 (self->priv->expression), _rygel_search_expression_unref0 (((RygelSearchExpression*) exp2)->operand1), _tmp2_);
#line 260 "rygel-media-export-query-container.vala"
		((RygelSearchExpression*) exp2)->operand2 = (_tmp3_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) exp), _rygel_search_expression_unref0 (((RygelSearchExpression*) exp2)->operand2), _tmp3_);
#line 261 "rygel-media-export-query-container.vala"
		((RygelSearchExpression*) exp2)->op = GINT_TO_POINTER (RYGEL_LOGICAL_OPERATOR_AND);
#line 262 "rygel-media-export-query-container.vala"
		self->priv->expression = (_tmp4_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) exp2), _rygel_search_expression_unref0 (self->priv->expression), _tmp4_);
#line 956 "rygel-media-export-query-container.c"
		_rygel_search_expression_unref0 (exp2);
	} else {
		RygelSearchExpression* _tmp5_;
#line 264 "rygel-media-export-query-container.vala"
		self->priv->expression = (_tmp5_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) exp), _rygel_search_expression_unref0 (self->priv->expression), _tmp5_);
#line 962 "rygel-media-export-query-container.c"
	}
	_rygel_search_expression_unref0 (exp);
	_g_free0 (op1);
}


static void rygel_media_export_query_container_class_init (RygelMediaExportQueryContainerClass * klass) {
	rygel_media_export_query_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportQueryContainerPrivate));
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search = rygel_media_export_query_container_real_search;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search_finish = rygel_media_export_query_container_real_search_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_media_export_query_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_media_export_query_container_real_get_children_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_query_container_finalize;
}


static void rygel_media_export_query_container_instance_init (RygelMediaExportQueryContainer * self) {
	self->priv = RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_PRIVATE (self);
	self->priv->pattern = g_strdup ("");
}


static void rygel_media_export_query_container_finalize (GObject* obj) {
	RygelMediaExportQueryContainer * self;
	self = RYGEL_MEDIA_EXPORT_QUERY_CONTAINER (obj);
	_g_free0 (self->priv->attribute);
	_rygel_search_expression_unref0 (self->priv->expression);
	_g_free0 (self->plaintext_id);
	_g_free0 (self->priv->pattern);
	G_OBJECT_CLASS (rygel_media_export_query_container_parent_class)->finalize (obj);
}


GType rygel_media_export_query_container_get_type (void) {
	static volatile gsize rygel_media_export_query_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_query_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportQueryContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_query_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportQueryContainer), 0, (GInstanceInitFunc) rygel_media_export_query_container_instance_init, NULL };
		GType rygel_media_export_query_container_type_id;
		rygel_media_export_query_container_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, "RygelMediaExportQueryContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_query_container_type_id__volatile, rygel_media_export_query_container_type_id);
	}
	return rygel_media_export_query_container_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




