/* rygel-item-creator.c generated by valac, the Vala compiler
 * generated from rygel-item-creator.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <gst/gst.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_ITEM_CREATOR (rygel_item_creator_get_type ())
#define RYGEL_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreator))
#define RYGEL_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))
#define RYGEL_IS_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_IS_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_ITEM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))

typedef struct _RygelItemCreator RygelItemCreator;
typedef struct _RygelItemCreatorClass RygelItemCreatorClass;
typedef struct _RygelItemCreatorPrivate RygelItemCreatorPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;

#define RYGEL_TYPE_DIDL_LITE_WRITER (rygel_didl_lite_writer_get_type ())
#define RYGEL_DIDL_LITE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DIDL_LITE_WRITER, RygelDIDLLiteWriter))
#define RYGEL_DIDL_LITE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DIDL_LITE_WRITER, RygelDIDLLiteWriterClass))
#define RYGEL_IS_DIDL_LITE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DIDL_LITE_WRITER))
#define RYGEL_IS_DIDL_LITE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DIDL_LITE_WRITER))
#define RYGEL_DIDL_LITE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DIDL_LITE_WRITER, RygelDIDLLiteWriterClass))

typedef struct _RygelDIDLLiteWriter RygelDIDLLiteWriter;
typedef struct _RygelDIDLLiteWriterClass RygelDIDLLiteWriterClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelItemCreatorRunData RygelItemCreatorRunData;
typedef struct _RygelItemCreatorParseArgsData RygelItemCreatorParseArgsData;
typedef struct _RygelItemCreatorFetchContainerData RygelItemCreatorFetchContainerData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelItemCreator {
	GObject parent_instance;
	RygelItemCreatorPrivate * priv;
	char* container_id;
	char* elements;
	GUPnPDIDLLiteItem* didl_item;
	RygelMediaItem* item;
};

struct _RygelItemCreatorClass {
	GObjectClass parent_class;
};

struct _RygelItemCreatorPrivate {
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	RygelDIDLLiteWriter* didl_writer;
	GUPnPDIDLLiteParser* didl_parser;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	char* feature_list;
	char* sort_caps;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
	RygelMediaContainer* (*create_root_container) (RygelContentDirectory* self);
	void (*browse_cb) (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
	void (*search_cb) (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
	void (*create_object_cb) (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
	void (*import_resource_cb) (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
	void (*get_transfer_progress_cb) (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
	void (*stop_transfer_resource_cb) (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
	RygelMediaContainer* parent_ref;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* author;
	char* album;
	char* date;
	char* mime_type;
	char* dlna_profile;
	glong size;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint n_audio_channels;
	gint track_number;
	gint width;
	gint height;
	gint pixel_width;
	gint pixel_height;
	gint color_depth;
	GeeArrayList* thumbnails;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*should_stream) (RygelMediaItem* self);
};

struct _RygelItemCreatorRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelMediaContainer* container;
	RygelMediaItem* _tmp0_;
	char* _tmp1_;
	GError * err;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelItemCreatorParseArgsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	gboolean _tmp0_;
	GError * _inner_error_;
};

struct _RygelItemCreatorFetchContainerData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelMediaContainer* result;
	RygelMediaObject* media_object;
	gboolean _tmp0_;
	RygelMediaObject* _tmp1_;
	GError * _inner_error_;
};


static gpointer rygel_item_creator_parent_class = NULL;
static RygelStateMachineIface* rygel_item_creator_rygel_state_machine_parent_iface = NULL;

GType rygel_state_machine_get_type (void);
GType rygel_item_creator_get_type (void);
GType rygel_media_object_get_type (void);
GType rygel_media_item_get_type (void);
GType rygel_content_directory_get_type (void);
GType rygel_didl_lite_writer_get_type (void);
#define RYGEL_ITEM_CREATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorPrivate))
enum  {
	RYGEL_ITEM_CREATOR_DUMMY_PROPERTY,
	RYGEL_ITEM_CREATOR_CANCELLABLE
};
GType rygel_media_container_get_type (void);
GType rygel_transcode_manager_get_type (void);
GType rygel_http_server_get_type (void);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
RygelDIDLLiteWriter* rygel_didl_lite_writer_new (RygelHTTPServer* http_server);
RygelDIDLLiteWriter* rygel_didl_lite_writer_construct (GType object_type, RygelHTTPServer* http_server);
RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static void rygel_item_creator_real_run_data_free (gpointer _data);
static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_item_creator_parse_args (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_parse_args_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static void _lambda6_ (GUPnPDIDLLiteItem* didl_item, RygelItemCreator* self);
static void __lambda6__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self);
RygelMediaItem* rygel_media_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelMediaItem* rygel_media_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
static char* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void);
GType rygel_thumbnail_get_type (void);
void rygel_media_container_add_item (RygelMediaContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_container_add_item_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
void rygel_didl_lite_writer_serialize (RygelDIDLLiteWriter* self, RygelMediaObject* media_object, GError** error);
static void rygel_item_creator_conclude (RygelItemCreator* self);
static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_);
static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* data);
static void rygel_item_creator_parse_args_data_free (gpointer _data);
static void rygel_item_creator_parse_args_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GQuark rygel_content_directory_error_quark (void);
static gboolean rygel_item_creator_parse_args_co (RygelItemCreatorParseArgsData* data);
static void rygel_item_creator_fetch_container_data_free (gpointer _data);
static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* data);
#define RYGEL_MEDIA_ITEM_IMAGE_CLASS "object.item.imageItem"
#define RYGEL_MEDIA_ITEM_VIDEO_CLASS "object.item.videoItem"
#define RYGEL_MEDIA_ITEM_AUDIO_CLASS "object.item.audioItem"
static void rygel_item_creator_finalize (GObject* obj);
static void rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 43 "rygel-item-creator.vala"
RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
#line 366 "rygel-item-creator.c"
	RygelItemCreator * self;
	RygelContentDirectory* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	RygelDIDLLiteWriter* _tmp2_;
	GUPnPDIDLLiteParser* _tmp3_;
#line 43 "rygel-item-creator.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 43 "rygel-item-creator.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 43 "rygel-item-creator.vala"
	self = (RygelItemCreator*) g_object_new (object_type, NULL);
#line 45 "rygel-item-creator.vala"
	self->priv->content_dir = (_tmp0_ = _g_object_ref0 (content_dir), _g_object_unref0 (self->priv->content_dir), _tmp0_);
#line 46 "rygel-item-creator.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, content_dir->cancellable);
#line 47 "rygel-item-creator.vala"
	self->priv->action = (_tmp1_ = action, action = NULL, _tmp1_);
#line 48 "rygel-item-creator.vala"
	self->priv->didl_writer = (_tmp2_ = rygel_didl_lite_writer_new (content_dir->http_server), _g_object_unref0 (self->priv->didl_writer), _tmp2_);
#line 49 "rygel-item-creator.vala"
	self->priv->didl_parser = (_tmp3_ = gupnp_didl_lite_parser_new (), _g_object_unref0 (self->priv->didl_parser), _tmp3_);
#line 388 "rygel-item-creator.c"
	return self;
}


#line 43 "rygel-item-creator.vala"
RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
#line 43 "rygel-item-creator.vala"
	return rygel_item_creator_construct (RYGEL_TYPE_ITEM_CREATOR, content_dir, action);
#line 397 "rygel-item-creator.c"
}


static void rygel_item_creator_real_run_data_free (gpointer _data) {
	RygelItemCreatorRunData* data;
	data = _data;
	g_slice_free (RygelItemCreatorRunData, data);
}


static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreator * self;
	RygelItemCreatorRunData* _data_;
	self = (RygelItemCreator*) base;
	_data_ = g_slice_new0 (RygelItemCreatorRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_real_run_data_free);
	_data_->self = self;
	rygel_item_creator_real_run_co (_data_);
}


static void rygel_item_creator_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelItemCreatorRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_item_creator_real_run_co (data);
}


#line 58 "rygel-item-creator.vala"
static void _lambda6_ (GUPnPDIDLLiteItem* didl_item, RygelItemCreator* self) {
#line 436 "rygel-item-creator.c"
	GUPnPDIDLLiteItem* _tmp0_;
#line 58 "rygel-item-creator.vala"
	g_return_if_fail (didl_item != NULL);
#line 59 "rygel-item-creator.vala"
	self->didl_item = (_tmp0_ = _g_object_ref0 (didl_item), _g_object_unref0 (self->didl_item), _tmp0_);
#line 442 "rygel-item-creator.c"
}


#line 58 "rygel-item-creator.vala"
static void __lambda6__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self) {
#line 448 "rygel-item-creator.c"
	_lambda6_ (item, self);
}


static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			{
#line 54 "rygel-item-creator.vala"
				rygel_item_creator_parse_args (data->self, NULL, NULL);
#line 462 "rygel-item-creator.c"
				data->_state_ = 43;
				rygel_item_creator_fetch_container (data->self, rygel_item_creator_run_ready, data);
				return FALSE;
				case 43:
				data->container = rygel_item_creator_fetch_container_finish (data->self, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch47_g_error;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
#line 58 "rygel-item-creator.vala"
				g_signal_connect_object (data->self->priv->didl_parser, "item-available", (GCallback) __lambda6__gupnp_didl_lite_parser_item_available, data->self, 0);
#line 61 "rygel-item-creator.vala"
				gupnp_didl_lite_parser_parse_didl (data->self->priv->didl_parser, data->self->elements, &data->_inner_error_);
#line 478 "rygel-item-creator.c"
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->container);
					goto __catch47_g_error;
					_g_object_unref0 (data->container);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
#line 63 "rygel-item-creator.vala"
				data->self->item = (data->_tmp0_ = rygel_media_item_new (gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) data->self->didl_item), data->container, gupnp_didl_lite_object_get_title ((GUPnPDIDLLiteObject*) data->self->didl_item), gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) data->self->didl_item)), _g_object_unref0 (data->self->item), data->_tmp0_);
#line 67 "rygel-item-creator.vala"
				data->self->item->mime_type = (data->_tmp1_ = rygel_item_creator_get_generic_mime_type (data->self), _g_free0 (data->self->item->mime_type), data->_tmp1_);
#line 68 "rygel-item-creator.vala"
				data->self->item->place_holder = TRUE;
#line 493 "rygel-item-creator.c"
				data->_state_ = 44;
				rygel_media_container_add_item (data->container, data->self->item, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_item_creator_run_ready, data);
				return FALSE;
				case 44:
#line 70 "rygel-item-creator.vala"
				rygel_media_container_add_item_finish (data->container, data->_res_, &data->_inner_error_);
#line 500 "rygel-item-creator.c"
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->container);
					goto __catch47_g_error;
					_g_object_unref0 (data->container);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
#line 71 "rygel-item-creator.vala"
				rygel_didl_lite_writer_serialize (data->self->priv->didl_writer, (RygelMediaObject*) data->self->item, &data->_inner_error_);
#line 511 "rygel-item-creator.c"
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->container);
					goto __catch47_g_error;
					_g_object_unref0 (data->container);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
#line 74 "rygel-item-creator.vala"
				rygel_item_creator_conclude (data->self);
#line 522 "rygel-item-creator.c"
				_g_object_unref0 (data->container);
			}
			goto __finally47;
			__catch47_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
#line 76 "rygel-item-creator.vala"
					rygel_item_creator_handle_error (data->self, data->err);
#line 533 "rygel-item-creator.c"
					_g_error_free0 (data->err);
				}
			}
			__finally47:
			if (data->_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_item_creator_parse_args_data_free (gpointer _data) {
	RygelItemCreatorParseArgsData* data;
	data = _data;
	g_slice_free (RygelItemCreatorParseArgsData, data);
}


static void rygel_item_creator_parse_args (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorParseArgsData* _data_;
	_data_ = g_slice_new0 (RygelItemCreatorParseArgsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_parse_args);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_parse_args_data_free);
	_data_->self = self;
	rygel_item_creator_parse_args_co (_data_);
}


static void rygel_item_creator_parse_args_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelItemCreatorParseArgsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_item_creator_parse_args_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorParseArgsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_item_creator_parse_args_co (data);
}


static gboolean rygel_item_creator_parse_args_co (RygelItemCreatorParseArgsData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
#line 82 "rygel-item-creator.vala"
			gupnp_service_action_get (data->self->priv->action, "ContainerID", G_TYPE_STRING, &data->self->container_id, "Elements", G_TYPE_STRING, &data->self->elements, NULL);
#line 85 "rygel-item-creator.vala"
			if (data->self->container_id == NULL) {
#line 85 "rygel-item-creator.vala"
				data->_tmp0_ = TRUE;
#line 603 "rygel-item-creator.c"
			} else {
#line 85 "rygel-item-creator.vala"
				data->_tmp0_ = data->self->elements == NULL;
#line 607 "rygel-item-creator.c"
			}
#line 85 "rygel-item-creator.vala"
			if (data->_tmp0_) {
#line 611 "rygel-item-creator.c"
				data->_inner_error_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, "No such object");
				{
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
			}
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_item_creator_fetch_container_data_free (gpointer _data) {
	RygelItemCreatorFetchContainerData* data;
	data = _data;
	_g_object_unref0 (data->result);
	g_slice_free (RygelItemCreatorFetchContainerData, data);
}


static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* _data_;
	_data_ = g_slice_new0 (RygelItemCreatorFetchContainerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_fetch_container);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_fetch_container_data_free);
	_data_->self = self;
	rygel_item_creator_fetch_container_co (_data_);
}


static RygelMediaContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelMediaContainer* result;
	RygelItemCreatorFetchContainerData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_item_creator_fetch_container_co (data);
}


static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->_state_ = 45;
			rygel_media_container_find_object (data->self->priv->content_dir->root_container, data->self->container_id, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_item_creator_fetch_container_ready, data);
			return FALSE;
			case 45:
			data->media_object = rygel_media_container_find_object_finish (data->self->priv->content_dir->root_container, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
#line 95 "rygel-item-creator.vala"
			if (data->media_object == NULL) {
#line 95 "rygel-item-creator.vala"
				data->_tmp0_ = TRUE;
#line 708 "rygel-item-creator.c"
			} else {
#line 95 "rygel-item-creator.vala"
				data->_tmp0_ = !RYGEL_IS_MEDIA_CONTAINER (data->media_object);
#line 712 "rygel-item-creator.c"
			}
#line 95 "rygel-item-creator.vala"
			if (data->_tmp0_) {
#line 716 "rygel-item-creator.c"
				data->_inner_error_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, "No such object");
				{
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->media_object);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
			}
			data->result = _g_object_ref0 ((data->_tmp1_ = data->media_object, RYGEL_IS_MEDIA_CONTAINER (data->_tmp1_) ? ((RygelMediaContainer*) data->_tmp1_) : NULL));
			_g_object_unref0 (data->media_object);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->media_object);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


#line 102 "rygel-item-creator.vala"
static void rygel_item_creator_conclude (RygelItemCreator* self) {
#line 761 "rygel-item-creator.c"
	char* didl;
#line 102 "rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 104 "rygel-item-creator.vala"
	didl = gupnp_didl_lite_writer_get_string ((GUPnPDIDLLiteWriter*) self->priv->didl_writer);
#line 107 "rygel-item-creator.vala"
	gupnp_service_action_set (self->priv->action, "Result", G_TYPE_STRING, didl, "ObjectID", G_TYPE_STRING, ((RygelMediaObject*) self->item)->id, NULL);
#line 110 "rygel-item-creator.vala"
	gupnp_service_action_return (self->priv->action);
#line 111 "rygel-item-creator.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 773 "rygel-item-creator.c"
	_g_free0 (didl);
}


#line 114 "rygel-item-creator.vala"
static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_) {
#line 114 "rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 115 "rygel-item-creator.vala"
	if (_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 116 "rygel-item-creator.vala"
		gupnp_service_action_return_error (self->priv->action, (guint) _error_->code, _error_->message);
#line 786 "rygel-item-creator.c"
	} else {
#line 118 "rygel-item-creator.vala"
		gupnp_service_action_return_error (self->priv->action, (guint) 701, _error_->message);
#line 790 "rygel-item-creator.c"
	}
#line 121 "rygel-item-creator.vala"
	g_warning ("rygel-item-creator.vala:121: Failed to create item under '%s': %s", self->container_id, _error_->message);
#line 125 "rygel-item-creator.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 796 "rygel-item-creator.c"
}


#line 128 "rygel-item-creator.vala"
static char* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self) {
#line 802 "rygel-item-creator.c"
	char* result;
	GQuark _tmp1_;
	const char* _tmp0_;
#line 128 "rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 808 "rygel-item-creator.c"
	_tmp0_ = ((RygelMediaObject*) self->item)->upnp_class;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == g_quark_from_string (RYGEL_MEDIA_ITEM_IMAGE_CLASS))
	do {
		result = g_strdup ("image");
#line 131 "rygel-item-creator.vala"
		return result;
#line 816 "rygel-item-creator.c"
	} while (0); else if (_tmp1_ == g_quark_from_string (RYGEL_MEDIA_ITEM_VIDEO_CLASS))
	do {
		result = g_strdup ("video");
#line 133 "rygel-item-creator.vala"
		return result;
#line 822 "rygel-item-creator.c"
	} while (0); else
	do {
		result = g_strdup ("audio");
#line 136 "rygel-item-creator.vala"
		return result;
#line 828 "rygel-item-creator.c"
	} while (0);
}


static GCancellable* rygel_item_creator_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelItemCreator* self;
	self = (RygelItemCreator*) base;
	result = self->priv->_cancellable;
#line 41 "rygel-item-creator.vala"
	return result;
#line 840 "rygel-item-creator.c"
}


static void rygel_item_creator_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelItemCreator* self;
	GCancellable* _tmp0_;
	self = (RygelItemCreator*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_item_creator_class_init (RygelItemCreatorClass * klass) {
	rygel_item_creator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelItemCreatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_item_creator_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_item_creator_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_item_creator_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_ITEM_CREATOR_CANCELLABLE, "cancellable");
}


static void rygel_item_creator_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_item_creator_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_item_creator_real_run;
	iface->run_finish = rygel_item_creator_real_run_finish;
	iface->get_cancellable = rygel_item_creator_real_get_cancellable;
	iface->set_cancellable = rygel_item_creator_real_set_cancellable;
}


static void rygel_item_creator_instance_init (RygelItemCreator * self) {
	self->priv = RYGEL_ITEM_CREATOR_GET_PRIVATE (self);
}


static void rygel_item_creator_finalize (GObject* obj) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (obj);
	_g_free0 (self->container_id);
	_g_free0 (self->elements);
	_g_object_unref0 (self->didl_item);
	_g_object_unref0 (self->item);
	_g_object_unref0 (self->priv->content_dir);
	_g_object_unref0 (self->priv->didl_writer);
	_g_object_unref0 (self->priv->didl_parser);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_item_creator_parent_class)->finalize (obj);
}


GType rygel_item_creator_get_type (void) {
	static GType rygel_item_creator_type_id = 0;
	if (rygel_item_creator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemCreatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_creator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemCreator), 0, (GInstanceInitFunc) rygel_item_creator_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_item_creator_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		rygel_item_creator_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemCreator", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_item_creator_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
	}
	return rygel_item_creator_type_id;
}


static void rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
	switch (property_id) {
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
	switch (property_id) {
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




